 -- Macro_Scripts File
 -- Purpose:  define action for each creatable MaxFluid objects to hook up to the create main menu (or quads)
 
 /*
 Revision History
 
     12 September 2017, Tom Hudson
     created for 3ds MAX 2018 Update 4
 */
 
 -- Macro Scripts for Fluids
 --***********************************************************************************************
 -- MODIFY THIS AT YOUR OWN RISK
 
 --------------------------------------------------------------------------------------------
 -- MaxFluids
 
 --------------------------------------------------------------------------------------------
 macroScript MaxLiquid 
             category:~FLUIDS_CATEGORY~ 
             internalCategory:"Fluids" 
             tooltip:~MAXLIQUID_TOOLTIP~ 
             ButtonText:~MAXLIQUID_BUTTONTEXT~
			 iconName:"MaxFluid/solveLiquidComponent"
(
     on execute do StartObjectCreation MaxLiquid
     on isChecked return (mcrUtils.IsCreating MaxLiquid)
)
 
macroScript SimulationView 
             category:~FLUIDS_CATEGORY~ 
             internalCategory:"Fluids" 
             tooltip:~SIMULATIONVIEW_TOOLTIP~ 
             ButtonText:~SIMULATIONVIEW_BUTTONTEXT~
 (
     on execute do FluidSimObjectManager.ShowInterface()
 )
 
macroScript ToggleSimulationView 
    category:~FLUIDS_CATEGORY~ 
    internalCategory:"Fluids" 
    tooltip:~TOGGLE_SIMULATIONVIEW_TOOLTIP~ 
    ButtonText:~TOGGLE_SIMULATIONVIEW_BUTTONTEXT~
	iconName:"MainUI/SimulationView"
(
	on isChecked return (FluidSimObjectManager.IsDialogOpen())
	on execute do 
	(
		if FluidSimObjectManager.IsDialogOpen() then
			FluidSimObjectManager.HideInterface()
		else
			FluidSimObjectManager.ShowInterface()
	)
 )
 

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQA61MPT7zTciGUlqrSsMm0OcBGcYHunEH57
-- DI79PifXq9y1Vr90UuGZ5dFqiZmrt0J8BdfXRu0YcSJSu3xbPweN4PU2Bt7gLNBf
-- Etrf4B+1iWlwl4JPH8rJTpULiU2UWhRS5q7HqWhqGCiSABbPly2FxO0fipk8c10d
-- dw7Ry9b/Lutixk1XcCqpdZR1lbMaM0SIy1blAmkg4Es2KOURGd357uAPRqU3w4zi
-- kR/aEQFJcT+MCYbAIN4/I7Lngx6mx8laXYR1rinZEE9ivdjYIzy9/WxYxjfIssJf
-- T7sbsiSZqT79sJlT0ilaoMoMQsP/UWCoyA3ARRKuDF7w8F6tlGvJ
-- -----END-SIGNATURE-----