-- Macro_Scripts File
-- Purpose:  define action for each creatable Compound objects to hook up to the create main menu (or quads)

/*
Revision History
	July 6 2006, Pierre-Felix Breton
		Added the Pro Boolean to 3dsmax 9

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products

	24 Mai 2003: Pierre-felix Breton
		created for 3ds MAX 6
*/

-- Macro Scripts for Objects
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK



----------------------------------------------------------------------------------------------------
macroScript Terrain 
category:~TERRAIN_CATEGORY~ 
internalCategory:"Objects Compounds" 
tooltip:~TERRAIN_TOOLTIP~ 
buttontext:~TERRAIN_BUTTONTEXT~ 
Icon:#("Compound",4)
(
   on execute do StartObjectCreation Terrain 
   on isChecked return (mcrUtils.IsCreating Terrain)
   on isEnabled return okToCreate Terrain

)

----------------------------------------------------------------------------------------------------
macroScript Morph 
category:~MORPH_CATEGORY~ 
internalCategory:"Objects Compounds" 
tooltip:~MORPH_TOOLTIP~ 
buttontext:~MORPH_BUTTONTEXT~ 
Icon:#("Compound",1)
(
   on execute do StartObjectCreation Morph
   on isChecked return (mcrUtils.IsCreating Morph)
   on isEnabled return okToCreate Morph

)

----------------------------------------------------------------------------------------------------
macroScript Conform 
category:~CONFORM_CATEGORY~ 
internalCategory:"Objects Compounds" 
tooltip:~CONFORM_TOOLTIP~ 
buttontext:~CONFORM_BUTTONTEXT~ 
Icon:#("Compound",2)
(
   on execute do StartObjectCreation Conform
   on isChecked return (mcrUtils.IsCreating Conform)
   on isEnabled return okToCreate Conform
)

----------------------------------------------------------------------------------------------------
macroScript ShapeMerge 
            category:~SHAPEMERGE_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~SHAPEMERGE_TOOLTIP~ 
            buttontext:~SHAPEMERGE_BUTTONTEXT~ 
            Icon:#("Compound",3)
(
   on execute do StartObjectCreation ShapeMerge
   on isChecked return (mcrUtils.IsCreating ShapeMerge)
   on isEnabled return (okToCreate ShapeMerge)
)

----------------------------------------------------------------------------------------------------
macroScript Loft 
            category:~LOFT_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~LOFT_TOOLTIP~ 
            buttontext:~LOFT_BUTTONTEXT~ 
            Icon:#("Compound",8)
(
   on execute do StartObjectCreation Loft
   on isChecked return (mcrUtils.IsCreating Loft)
   on isEnabled return okToCreate Loft

)

----------------------------------------------------------------------------------------------------
macroScript Scatter 
            category:~SCATTER_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~SCATTER_TOOLTIP~ 
            buttontext:~SCATTER_BUTTONTEXT~ 
            Icon:#("Compound",5)
(
   on execute do StartObjectCreation Scatter
   on isChecked return (mcrUtils.IsCreating Scatter)
   on isEnabled return okToCreate Scatter

)

----------------------------------------------------------------------------------------------------
macroScript Connect 
            category:~CONNECT_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~CONNECT_TOOLTIP~ 
            buttontext:~CONNECT_BUTTONTEXT~ 
            Icon:#("Compound",6)
(
    on execute do StartObjectCreation Connect
   on isChecked return (mcrUtils.IsCreating Connect)
   on isEnabled return okToCreate Connect

)

----------------------------------------------------------------------------------------------------
macroScript Boolean 
            category:~BOOLEAN_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~BOOLEAN_TOOLTIP~ 
            buttontext:~BOOLEAN_BUTTONTEXT~ 
            Icon:#("Compound",7)
(
   on execute do StartObjectCreation Boolean3
   on isChecked return (mcrUtils.IsCreating Boolean3)
   on isEnabled return okToCreate Boolean3

)

----------------------------------------------------------------------------------------------------
macroScript BlobMesh 
            category:~BLOBMESH_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~BLOBMESH_TOOLTIP~ 
            buttontext:~BLOBMESH_BUTTONTEXT~ 
            --Icon:#("Compound",5)
(
   on execute do StartObjectCreation BlobMesh 
   on isChecked return (mcrUtils.IsCreating BlobMesh )
   on isEnabled return okToCreate BlobMesh 

)

----------------------------------------------------------------------------------------------------
macroScript Mesher 
            category:~MESHER_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~MESHER_TOOLTIP~ 
            buttontext:~MESHER_BUTTONTEXT~ 
            --Icon:#("Compound",5)
(
   on execute do StartObjectCreation Mesher 
   on isChecked return (mcrUtils.IsCreating Mesher )
   on isEnabled return okToCreate Mesher 

)

----------------------------------------------------------------------------------------------------
macroScript ProBoolean 
            category:~PROBOOLEAN_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~PROBOOLEAN_TOOLTIP~ 
            buttontext:"ProBoolean" 
            Icon:#("PowerBoolean",7)
(
   on execute do StartObjectCreation ProBoolean
   on isChecked return (mcrUtils.IsCreating ProBoolean)
   on isEnabled return okToCreate ProBoolean
)

----------------------------------------------------------------------------------------------------
macroScript Procutter
            category:~PROCUTTER_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~PROCUTTER_TOOLTIP~ 
            buttontext:"ProCutter" 
            Icon:#("PowerBoolean",9)
(
   on execute do StartObjectCreation ProCutter
   on isChecked return (mcrUtils.IsCreating ProCutter)
   on isEnabled return okToCreate ProCutter
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBAo//b3FB+4JEZ306J7y/gy7bTfggRhUN1
-- lCWtDUlOt9hkbsloOGnz1gEv3TvNvRX8FWCszjncKpA2TX+cTRyD4W6i8Cn6Ym1d
-- h5LYse7qBZFCwW6/RQ0aOHNVLrPHxhI3+4CKwmngFpml4AoMP/bq2e3uxs6zQmtv
-- Xd8IJZY2o3TmmPQurBRJAype0rLuNIRvdUUK5DDg/nxXTONffKyZf5mGxAAgRVrC
-- XB/wYYiBFFqxkSiVZROQHArLQDiQx5a1KmhCwK0QLqpiyqWARFxCeXe2GtW6dFWb
-- rUEuuOOLHq9LvMF2cYRDaAGl0hEjcG4im9iAKuli58dqziY9tA+x
-- -----END-SIGNATURE-----