-- Macro Scripts File


/* revision history


	13 Jan 2004, Alexander Bicalho
		added Target Camera with Elevation for VIZ Render
		Removed "VIZR" from the product list of the regular Target Camera

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products
		consolidated the preview DOF macro from the Macro_Render.mcr

       22 Juillet 2003; Pierre-Felix Breton
                Modified to use the old match camera to view when a camera is selected
       24 Mai 2003; Pierre-Felix Breton
                Migrated VIZ 4 functionality in 3ds MAX 6

	August 29 2001 Pierre-Felix Breton
		Added Macro allowing creating a camera from the selected Perspective Viewport
	
	August 30th 2001 Pierre-Felix Breton
	added test for properties so the 'select target' don't show on free cameras anymore
	
	Sept 12 2001 Pierre-Felix Breton
	added a Macro allowing applying the Correction Modifier from the Quad menu.
	
	17 Nov 1998; Frank Delise: initial implementation
*/

-- Macro Scripts for Cameras
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK


--***********************************************************************************************
-- Creation Macros
-- enables actions for creation from menus and quads
------------------------------------------------------------------------------------------
macroScript Free_Camera 
	category:~FREE_CAMERA_CAPTION~ 
	internalCategory:"Lights and Cameras" 
	tooltip:~FREE_CAMERA_TOOLTIP~ 
	buttontext:~FREE_CAMERA_BUTTONTEXT~ 
	icon:#("Cameras",2)
	--palettehint: Cameras --used for publishing to palettes
(
	on execute do
	(
		StartObjectCreation FreeCamera
	)
	on isChecked do
	(
		mcrUtils.IsCreating FreeCamera
	)
)
------------------------------------------------------------------------------------------
macroScript Target_Camera 
	category:~TARGET_CAMERA_CATEGORY~ 
	internalCategory:"Lights and Cameras" 
	tooltip:~TARGET_CAMERA_TOOLTIP~ 
	buttontext:~TARGET_CAMERA_BUTTONTEXT~ 
	icon:#("Cameras",1)
	--palettehint: Cameras --used for publishing to palettes
(
	on execute do
	(
		StartObjectCreation TargetCamera
	)   
	on isChecked do
	(
		mcrUtils.IsCreating Target_Camera
	)
)
------------------------------------------------------------------------------------------
macroScript Physical_Camera 
	category:~PHYSICAL_CAMERA_CATEGORY~ 
	internalCategory:"Lights and Cameras" 
	tooltip:~PHYSICAL_CAMERA_TOOLTIP~ 
	buttontext:~PHYSICAL_CAMERA_BUTTONTEXT~ 
	icon:#("Cameras",1)
	--palettehint: Cameras --used for publishing to palettes
(
	on execute do
	(
		StartObjectCreation Physical_Camera
	)   
	on isChecked do
	(
		mcrUtils.IsCreating Physical_Camera
	)
)

--***********************************************************************************************
-- Create Camera from View

macroScript StandardCamera_CreateFromView
	ButtonText:~CREATE_STANDARDCAMERA_FROM_VIEW_BUTTONTEXT~
	category:~CAMERA_CREATEFROMVIEW_CATEGORY~ 
	internalCategory:"Lights and Cameras" 
	Tooltip:~CREATE_STANDARDCAMERA_FROM_VIEW_TOOLTIP~
	Icon:#("Cameras",3)
(

	On IsEnabled Return (If (viewport.Gettype() == #view_persp_user) and (not theHold.Holding()) do return true)
	On Execute Do
	( 
		CreateCameraFromView(FreeCamera)
	)--end on execute
)--end macro

macroScript PhysicalCamera_CreateFromView
	ButtonText:~CREATE_PHYSICALCAMERA_FROM_VIEW_BUTTONTEXT~
	category:~CAMERA_CREATEFROMVIEW_CATEGORY~ 
	internalCategory:"Lights and Cameras" 
	Tooltip:~CREATE_PHYSICALCAMERA_FROM_VIEW_TOOLTIP~
	Icon:#("Cameras",3)
(

	On IsEnabled Return (If (viewport.Gettype() == #view_persp_user) and (not theHold.Holding()) do return true)
	On Execute Do
	( 
		CreateCameraFromView(Physical_Camera)
	)--end on execute
)--end macro

--***********************************************************************************************
-- Selection macros

MacroScript Camera_SelectTarget
	ButtonText:~CAMERA_SELECTTARGET_BUTTONTEXT~
	category:~CAMERA_SELECTTARGET_CATEGORY~ 
	internalCategory:"Lights and Cameras" 
	Tooltip:~CAMERA_SELECTTARGET_TOOLTIP~ 
(

	On IsVisible Return ((Filters.Is_Camera $) and(IsValidNode $.target)) -- pfb, aug 30th 2001, added test for properties so the 'select target' don't show on Omnis anymore
	On Execute Do Try(select $.Target) Catch()
)



--***********************************************************************************************
-- Viewport Macros
macroScript Camera_ActivateView
ButtonText:~CAMERA_ACTIVATEVIEW_BUTTONTEXT~
category:~CAMERA_ACTIVATEVIEW_CATEGORY~ 
	internalCategory:"Lights and Cameras" 
	Tooltip:~CAMERA_ACTIVATEVIEW_TOOLTIP~
(

	On IsVisible Return ((Filters.Is_Camera $) and (viewport.getcamera() != $) and (viewport.canSetToViewport $) )
	On Execute Do
	( 
		Try(viewport.setcamera $) Catch()
	)
)


--***********************************************************************************************
-- Perspective Correction
-- this function is similar to the CameraCorrection available in the Macros_Modifers.mcr
-- the only difference is in the Visibility flags for Quads
-- the reason for this is to have the menu item visible from the pulldown | Modifier menu
-- AND control the visibility in the quads.  Doing this requires a duplicated definition of the macros

macroScript CameraCorrection_Quad 
	category:~CAMERACORRECTION_QUAD_CATEGORY~ 
	internalCategory:"Lights and Cameras" 
	tooltip:~CAMERACORRECTION_QUAD_TOOLTIP~ 
	ButtonText:~CAMERACORRECTION_QUAD_BUTTONTEXT~
(
    on execute do addMod CamPerspCorrect
    on isVisible return (Filters.Is_Camera $)
)


--***********************************************************************************************
-- Preview DOF

macroScript Preview_DOF 
	ButtonText:~PREVIEW_DOF_BUTTONTEXT~ 
	category:~PREVIEW_DOF_CATEGORY~ 
	internalCategory:"Render" 
	tooltip:~PREVIEW_DOF_TOOLTIP~ 
	buttontext:~PREVIEW_DOF_IN_VIEWPORT_BUTTONTEXT~        
(
	Try(MaxOps.displayActiveCameraViewWithMultiPassEffect())Catch()
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBLKbl3S8R/KQ7qyG/qtsQe1mL9nwSBYCxA
-- XhQ7QUCGvVF4nnrTJD7wmeU9ll4oY02/MPiVIrwQJOncXmpqBhTaoVClh3EBjsWD
-- DxQnssIn/UNOGV3hpt12Y16jnLMC7xnAr14Mfy14v8IQukOG50yeDLZ5AdnwtRbW
-- uBALcg8+5NGtDdmIELds4GEsp2tmEQk50aezauXPIw1IOgLSmjbNmk5wy8Vg4DUk
-- n2GSuCeLzlidA/veYV1Bl0aDd9DN0jIoqw8lBY5bqwkx8rK99UCMfpyk8+sriMpA
-- J/wKGNxRdSzuwi2/SXtDzyX2b5GYX/iDLVg3ObkJBtpMmjeA659n
-- -----END-SIGNATURE-----