-- Macro_Scripts File
-- Purpose:  define action for each creatable AEC Primitive objects to hook up to the create main menu (or quads)

/*
Revision History

	24 Mai 2003: Pierre-felix Breton
		created for 3ds MAX 6

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products

*/

-- Macro Scripts for Objects
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK



----------------------------------------------------------------------------------------------------
--Doors
macroScript PivotDoor 
category:~PIVOTDOOR_CATEGORY~
internalCategory:"Objects AEC" 
tooltip:~PIVOTDOOR_TOOLTIP~ 
buttontext:~PIVOTDOOR_BUTTONTEXT~ 
icon:#("ObjectsAEC_Doors",1)
(
StartObjectCreation pivot 
)

macroScript BifoldDoor
category:~BIFOLDDOOR_CATEGORY~
internalCategory:"Objects AEC"
tooltip:~BIFOLDDOOR_TOOLTIP~ 
buttontext:~BIFOLDDOOR_BUTTONTEXT~ 
icon:#("ObjectsAEC_Doors",2)
(
StartObjectCreation BiFold
)

macroScript SlidingDoor 
category:~SLIDINGDOOR_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~SLIDINGDOOR_TOOLTIP~
buttontext:~SLIDINGDOOR_BUTTONTEXT~ 
icon:#("ObjectsAEC_Doors",3)
(
StartObjectCreation SlidingDoor
)


----------------------------------------------------------------------------------------------------
--Windows
macroScript AwningWindow 
category:~AWNINGWINDOW_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~AWNINGWINDOW_TOOLTIP~
buttontext:~AWNINGWINDOW_BUTTONTEXT~
icon:#("ObjectsAEC_Win",1)
(
StartObjectCreation Awning 
)

macroScript FixedWindow 
category:~FIXEDWINDOW_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~FIXEDWINDOW_TOOLTIP~ 
buttontext:~FIXEDWINDOW_BUTTONTEXT~ 
icon:#("ObjectsAEC_Win",3)
(
StartObjectCreation Fixed
)

macroScript ProjectedWindow
category:~PROJECTEDWINDOW_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~PROJECTEDWINDOW_TOOLTIP~ 
buttontext:~PROJECTEDWINDOW_BUTTONTEXT~ 
icon:#("ObjectsAEC_Win",5)
(
StartObjectCreation projected
)

macroScript CasementWindow 
category:~CASEMENTWINDOW_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~CASEMENTWINDOW_TOOLTIP~ 
buttontext:~CASEMENTWINDOW_BUTTONTEXT~ 
icon:#("ObjectsAEC_Win",2)
(
StartObjectCreation Casement
)

macroScript PivotedWindow 
category:~CASEMENT_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~CASEMENT_TOOLTIP~ 
buttontext:~CASEMENT_BUTTONTEXT~ 
icon:#("ObjectsAEC_Win",4)
(
StartObjectCreation Pivoted
)

macroScript SlidingWindow 
category:~SLIDINGWINDOW_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~SLIDINGWINDOW_TOOLTIP~ 
buttontext:~SLIDINGWINDOW_BUTTONTEXT~ 
icon:#("ObjectsAEC_Win",6)
(
StartObjectCreation SlidingWindow 
)



----------------------------------------------------------------------------------------------------
--Foliage
macroScript Foliage 
category:~FOLIAGE_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~FOLIAGE_TOOLTIP~ 
buttontext:~FOLIAGE_BUTTONTEXT~ 
icon:#("ObjectsAEC_misc",1)
(
cui.CommandPanelOpen = true
StartObjectCreation Foliage
)



----------------------------------------------------------------------------------------------------
--Railing
macroScript Railing 
category:~RAILING_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~RAILING_TOOLTIP~ 
buttontext:~RAILING_BUTTONTEXT~ 
icon:#("ObjectsAEC_misc",2)
(
StartObjectCreation Railing
)



----------------------------------------------------------------------------------------------------
--Stairs
macroScript SpiralStair 
category:~SPIRALSTAIR_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~SPIRALSTAIR_TOOLTIP~ 
buttontext:~SPIRALSTAIR_BUTTONTEXT~ 
icon:#("ObjectsAEC_Stairs",4)
(
StartObjectCreation Spiral_Stair
)

macroScript L_Stair 
category:~L_STAIR_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~L_STAIR_TOOLTIP~ 
buttontext:~L_STAIR_BUTTONTEXT~ 
icon:#("ObjectsAEC_Stairs",1)
(
StartObjectCreation L_Type_Stair
)

macroScript StraightStair 
category:~STRAIGHTSTAIR_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~STRAIGHTSTAIR_TOOLTIP~ 
buttontext:~STRAIGHTSTAIR_BUTTONTEXT~ 
icon:#("ObjectsAEC_Stairs",3)
(
StartObjectCreation Straight_Stair
)

macroScript U_Stair 
category:~U_STAIR_CATEGORY~
internalCategory:"Objects AEC"
tooltip:~U_STAIR_TOOLTIP~ 
buttontext:~U_STAIR_BUTTONTEXT~ 
icon:#("ObjectsAEC_Stairs",2)
(
StartObjectCreation U_Type_Stair
)



----------------------------------------------------------------------------------------------------
--Wall
macroScript Wall 
category:~WALL_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~WALL_TOOLTIP~
buttontext:~WALL_BUTTONTEXT~
icon:#("ObjectsAEC_misc",3)
(
StartObjectCreation Wall
)



-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCxlwLedKQgGksVpvNAfhE7ghQysV9PC3OE
-- NIK660R2SfZ58zpEFTwOYOBAYcEuc53Swv3W6miVosxvKuXUUYybN5Ankh55Gy1y
-- CY4dTRVs91KWigYkN1nHYjOiBo19E00VO4pMJZEEcahr37Cq4IpL4yESsEM2DqzU
-- aUXNu6GKuubHhUofwk6Wu5dfIitrNMgTStRhs8IG3XeARildPRZ+gwXF4CWB0sQD
-- 2dqvliwF/M2OR52rHuqaaV9gNNHL83ItQ1G2Q10KI/f2Knw1rEvMhWbsnL4D7n7f
-- a1+YayGHuA26lCOv3V4snOJbDx3GcldIsdrPzmcgCs5nb7yIcgzk
-- -----END-SIGNATURE-----