/*

Convert To: MacroScript File


	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products

 
This script enables all surface conversions through Macroscripts.
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
-- 

*/


MacroScript Collapse_Stack 
	ButtonText:~COLLAPSE_STACK_BUTTONTEXT~ 
	Category:~COLLAPSE_STACK_CATEGORY~ 
	internalCategory:"Modifier Stack" 
	Tooltip:~COLLAPSE_STACK_TOOLTIP~ 
	-- Needs Icon
	--Icon:#("Max_edit_modifiers",1)
(	
	
	On isEnabled return Try(Filters.Are_Modifiers_Applied())Catch()
	On isVisible return Try(Filters.Are_Modifiers_Applied())Catch() 
	On Execute Do	
	(
		Undo on 
		(
			if SubObjectLevel == undefined then Max Modify Mode
			For obj in selection do
			(
				Try(CollapseStack obj)Catch()
			)		
		) 
	
	)
	
)


MacroScript Modify_Mode 
	ButtonText:~MODIFY_MODE_BUTTONTEXT~ 
	Category:~MODIFY_MODE_CATEGORY~ 
	internalCategory:"Modifier Stack" 
	Tooltip:~MODIFY_MODE_TOOLTIP~ 
	-- Needs Icon
	--Icon:#("Max_edit_modifiers",1)
(	
	
	On isEnabled return (Try(getCommandPanelTaskMode() != #modify)Catch())
	On isVisible return (Try(getCommandPanelTaskMode() != #modify)Catch()) 
	On Execute Do	
	(
		Max Modify Mode 
	
	)
	
)
MacroScript Create_Mode 
	ButtonText:~CREATE_MODE_BUTTONTEXT~ 
	Category:~CREATE_MODE_CATEGORY~ 
	internalCategory:"Modifier Stack" 
	Tooltip:~CREATE_MODE_TOOLTIP~ 
	-- Needs Icon
	--Icon:#("Max_edit_modifiers",1)
(	
	
	On isEnabled return (Try(getCommandPanelTaskMode() != #create)Catch())
	On isVisible return (Try(getCommandPanelTaskMode() != #create)Catch()) 
	On Execute Do	
	(
		Max Create Mode 
	
	)
	
)


MacroScript Convert_to_Mesh 
	ButtonText:~CONVERT_TO_MESH_BUTTONTEXT~ 
	Category:~CONVERT_TO_MESH_CATEGORY~ 
	internalCategory:"Modifier Stack" 
	Tooltip:~CONVERT_TO_MESH_TOOLTIP~ 
	Icon:#("Max_edit_modifiers",1)
(	

	On isEnabled return (Try(Selection.count != 0 and CanConvertTo Selection[1] Mesh)Catch())
	On isVisible return (Try(Selection.count != 0 and CanConvertTo Selection[1] Mesh)Catch()) 
	On Execute Do	
	(
		SuspendEditing()
		for obj in selection do
		(
			Try(ConvertToMesh obj)Catch() 
		)
		ResumeEditing()
		Max modify mode
	)
)

MacroScript Convert_to_Patch 
	ButtonText:~CONVERT_TO_PATCH_BUTTONTEXT~ 
	Category:~CONVERT_TO_PATCH_CATEGORY~  
	internalCategory:"Modifier Stack"  
	Tooltip:~CONVERT_TO_PATCH_TOOLTIP~ 
	Icon:#("Max_edit_modifiers",2)
(	

	On isEnabled return (Try(Selection.count != 0 and CanConvertTo Selection[1] Editable_Patch)Catch())
	On isVisible return (Try(Selection.count != 0 and CanConvertTo Selection[1] Editable_Patch)Catch()) 
	On Execute Do	
	(
		SuspendEditing()
		for obj in selection do
		(
			Try(ConvertTo obj Editable_Patch)Catch() 
		)
		ResumeEditing()
		Max modify mode
	)
)

MacroScript Convert_to_Spline 
	ButtonText:~CONVERT_TO_SPLINE_BUTTONTEXT~ 
	Category:~CONVERT_TO_SPLINE_CATEGORY~ 
	internalCategory:"Modifier Stack" 
	Tooltip:~CONVERT_TO_SPLINE_TOOLTIP~ 
	Icon:#("Max_edit_modifiers",11)
(	

	On isEnabled return (Try(Selection.count != 0 and CanConvertTo Selection[1] SplineShape)Catch())
	On isVisible return (Try(Selection.count != 0 and CanConvertTo Selection[1] SplineShape)Catch()) 
	On Execute Do	
	(
		SuspendEditing()
		for obj in selection do
		(
			Try(ConvertToSplineShape obj)Catch() 
		)
		ResumeEditing()
		Max modify mode
	)
)

MacroScript Convert_to_NURBS 
	ButtonText:~CONVERT_TO_NURBS_BUTTONTEXT~ 
	Category:~CONVERT_TO_NURBS_CATEGORY~  
	internalCategory:"Modifier Stack"  
	Tooltip:~CONVERT_TO_NURBS_TOOLTIP~ 
	Icon:#("Max_edit_modifiers",16)
(	
	-- only check the first item in the selection array. Fast but not very robust.
	On isEnabled return (Try(Selection.count != 0 and CanConvertTo Selection[1] NURBSSurface)Catch())
	-- only check the first item in the selection array. Fast but not very robust.
	On isVisible return (Try(Selection.count != 0 and CanConvertTo Selection[1] NURBSSurface)Catch()) 
	On Execute Do	
	(
		SuspendEditing()
		-- Ensure each item can be converted before attempting it.
		for obj in selection where (CanConvertTo obj NurbsSurface) do
		(
			ConvertToNURBSSurface obj 
		)
		ResumeEditing()
		Max modify mode
	)
)

MacroScript Convert_to_Poly
	ButtonText:~CONVERT_TO_POLY_BUTTONTEXT~ 
	Category:~CONVERT_TO_POLY_CATEGORY~  
	internalCategory:"Modifier Stack"  
	Tooltip:~CONVERT_TO_POLY_TOOLTIP~ 
	Icon:#("Max_edit_modifiers",16)
(	

	On isEnabled return (Try(Selection.count != 0 and CanConvertTo Selection[1] Editable_Poly)Catch())
	On isVisible return (Try(Selection.count != 0 and CanConvertTo Selection[1] Editable_Poly)Catch()) 
	On Execute Do	
	(
		SuspendEditing()
		Try(
		for obj in selection do
		(
			Try(ConvertTo obj Editable_Poly)Catch() 
		)
		Max modify mode
		)
		Catch() 
		ResumeEditing()
	)
)

MacroScript Convert_to_deformable_gPoly
	ButtonText:~CONVERT_TO_DEFORMABLE_GPOLY_BUTTONTEXT~ 
	Category:~CONVERT_TO_DEFORMABLE_GPOLY_CATEGORY~  
	internalCategory:"Modifier Stack"  
	Tooltip:~CONVERT_TO_DEFORMABLE_GPOLY_TOOLTIP~ 
	Icon:#("Max_edit_modifiers",16)
(	

	On isEnabled return (Try(Selection.count != 0 and CanConvertTo Selection[1] deformable_gPoly)Catch())
	On isVisible return (Try(Selection.count != 0 and CanConvertTo Selection[1] deformable_gPoly)Catch()) 
	On Execute Do	
	(
		SuspendEditing()
		Try(
		for obj in selection do
		(
			Try(ConvertTo obj deformable_gPoly) Catch() 
		)
		Max modify mode
		)
		Catch() 
		ResumeEditing()
	)
)

-- Added by NH as part of Grab bag feature.  Provide an Action item for Show End Result in modifier stack
MacroScript Show_End_Result_Toggle
            category:~SHOW_END_RESULT_TOGGLE_CATEGORY~ 
            internalCategory:"Modifier Stack" 
            ButtonText:~SHOW_END_RESULT_TOGGLE_BUTTONTEXT~
            tooltip:~SHOW_END_RESULT_TOGGLE_TOOLTIP~ 

(
     on execute do showEndResult = not showEndResult -- action to execute - toggle the setting
     on isEnabled return true -- greyed out if false
     on isChecked return showEndResult -- checked if true
     on isVisible return true -- visible if true
)

-- Added by NH as part of Maintain Custom Attributes on Stack Collapse feature.  Provide an Action item for togglng the Survive flag state
MacroScript Maintain_Custom_Attributes_On_StackCollapse_Toggle
            category:~MAINTAIN_CUSTOM_ATTRIBUTES_ON_STACKCOLLAPSE_TOGGLE_CATEGORY~ 
            internalCategory:"Modifier Stack" 
            ButtonText:~MAINTAIN_CUSTOM_ATTRIBUTES_ON_STACKCOLLAPSE_TOGGLE_BUTTONTEXT~
            tooltip:~MAINTAIN_CUSTOM_ATTRIBUTES_ON_STACKCOLLAPSE_TOGGLE_TOOLTIP~ 

(
     on execute do custattribCollapsemanager.surviveState = not custattribCollapsemanager.surviveState -- action to execute - toggle the setting
     on isEnabled return true -- greyed out if false
     on isChecked return custattribCollapsemanager.surviveState -- checked if true
     on isVisible return true -- visible if true
)

macroScript ProjectioModToggleNodeVisibility
	category:~PROJECTIOMODTOGGLENODEVISIBILITY_CATEGORY~ 
	internalCategory:"Projection Modifier" 
	tooltip:~PROJECTIOMODTOGGLENODEVISIBILITY_TOOLTIP~
	ButtonText:~PROJECTIOMODTOGGLENODEVISIBILITY_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try (
			if selection.Count > 0 do (
				pmod = FindPMod $
				if pmod != undefined do (
					pmodi = pmod.projectionModOps
					pmodi.setGeomSelNodesVisibility (not pmodi.getGeomSelNodesVisibility())
				)
			)
		)
		Catch()
	)

	on isEnabled do
	(
		selection.Count > 0
	)
)

macroScript ProjectioModDisplayToggleEnable
	category:~PROJECTIOMODDISPLAYTOGGLEENABLE_CATEGORY~ 
	internalCategory:"Projection Modifier" 
	tooltip:~PROJECTIOMODDISPLAYTOGGLEENABLE_TOOLTIP~
	ButtonText:~PROJECTIOMODDISPLAYTOGGLEENABLE_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try (
			if selection.Count > 0 do (
				local pmod = FindPMod $
				if pmod != undefined do (
					pmod.displayToggleEnable = (not pmod.displayToggleEnable)
				)
			)
		)
		Catch()
	)

	on isEnabled do
	(
		selection.Count > 0
	)
)

macroScript ProjectioModDisplayToggleMode
	category:~PROJECTIOMODDISPLAYTOGGLEMODE_CATEGORY~ 
	internalCategory:"Projection Modifier" 
	tooltip:~PROJECTIOMODDISPLAYTOGGLEMODE_TOOLTIP~
	ButtonText:~PROJECTIOMODDISPLAYTOGGLEMODE_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try (
			if selection.Count > 0 do (
				local pmod = FindPMod $
				if pmod != undefined do (
					local pmodMode = pmod.displayToggleMode
					if (pmodMode==1) then
					     pmod.displayToggleMode = 2
					else pmod.displayToggleMode = 1
				)
			)
		)
		Catch()
	)

	on isEnabled do
	(
		selection.Count > 0
	)
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCuSgCsDj/AibGTqKz1Oo3WgQkYgxKxlFY5
-- REXPsdcN+650llkqpL8mTok8rRFVlCqV0javmVPgEBbdIX2J/M5rTvLUF89Id0IZ
-- Pov6/yNCYKlud71ec2LaoS7R7fzFjDUJd/tDc8QFIroa8qOC4lVdCAqxqTb1AUcg
-- nudL26K4alq4Bl+w0zbPoYaOweaWAlyvbC/5NB23//2a805tTyYnVW0lNp+IDefb
-- K+/6cRizAgAsXMdJmDHiZnhdXUoX0DJDo6aFzltBtNlSBLQi3b0Fw+0AIzs3EGnQ
-- x+bZkCIMboopt84wUGxe6frQuLbH1cYVRFQjgYTmcp38NSi1l2lJ
-- -----END-SIGNATURE-----