-- MacroScript File
-- Created:       
-- Last Modified: 
-- Mesh validator
-- Version: 3ds Max 2012
-- Author: Attila Szabo
-- Modified: 
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

/* History

Nov 30 2012 - first version

NOTE TO LOCALIZATION
Only the headers should be localized

*/

macroScript mesh_validator_toggle 
	category: ~MESH_VALIDATOR_CATEGORY~
	internalCategory: "Mesh Validator Tools"
	ButtonText: ~MESH_VALIDATOR_TOOGLE_BUTTONTEXT~ 
	tooltip: ~MESH_VALIDATOR_TOOGLE_TOOLTIP~
(
	local iniSectionName = "MeshInspector"
	local iniEnabledName = "Enable"
	
	function getMeshValidatorActive =
	(
		-- ini settings control the state of the Mesh Validator across 3ds Max sessions
		-- per 3ds Max session state of the Mesh Validator is controlled via meshValidator interface properties
		return meshInspector.Enable 
	)
	
	function setMeshValidatorActive enabled = 
	(
		-- ini settings are not updated by the Mesh Validator tool, the user 
		-- (in this case this macro) is expected to update them as needed
		local maxIniFile = getMAXIniFile() 
		if enabled then
		(
			setINISetting maxIniFile iniSectionName iniEnabledName "1"
		)
		else
		(
			setINISetting maxIniFile iniSectionName iniEnabledName "0"
		)
		meshInspector.Enable = enabled
	)
	
	On isEnabled do 
	(
		true
	)

	on isChecked do 
	(
		getMeshValidatorActive()
	)
	
	On execute Do
	(
		if (getMeshValidatorActive()) then 
			setMeshValidatorActive(false)
		else
			setMeshValidatorActive(true)
	)

)

macroScript mesh_validator_auto_repair
	category: ~MESH_VALIDATOR_CATEGORY~
	internalCategory: "Mesh Validator Tools"
	ButtonText: ~MESH_VALIDATOR_AUTOREPAIR_BUTTONTEXT~ 
	tooltip: ~MESH_VALIDATOR_AUTOREPAIR_TOOLTIP~
(
	local iniSectionName = "MeshInspector"
	local iniRepairName = "Repair"
	local iniShowDialogName = "ShowDialog"
	
	function getAutoRepairEnabled =
	(
		-- ini settings control the state of the Mesh Validator across 3ds Max sessions
		-- per 3ds Max session state of the Mesh Validator is controlled via meshValidator interface properties
		return (meshInspector.RepairMesh and (not meshInspector.ShowDialog))
	)
	
	function setAutoRepairEnabled enabled = 
	(
		-- ini settings are not updated by the Mesh Validator tool, the user 
		-- (in this case this macro) is expected to update them as needed
		local maxIniFile = getMAXIniFile() 
		if enabled then
		(
			setINISetting maxIniFile iniSectionName iniRepairName "1"
			setINISetting maxIniFile iniSectionName iniShowDialogName "0"
		)
		else
		(
			setINISetting maxIniFile iniSectionName iniRepairName "1"
			setINISetting maxIniFile iniSectionName iniShowDialogName "1"
		)
		meshInspector.ShowDialog = (not enabled)
	)
	
	On isEnabled do 
	(
		true
	)

	on isChecked do 
	(
		getAutoRepairEnabled()
	)
	
	On execute Do
	(
		if (getAutoRepairEnabled()) then 
			setAutoRepairEnabled(false)
		else
			setAutoRepairEnabled(true)
	)

)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAXmWTzWxysNRblyMShXqGozZ0JSbOTWuJe
-- JIndi14+r841JeFUdMIBxy1sbIXnh5RK784YxdUPVRPQL84q4nsKyE6K2tG9u+Jf
-- hvq7n6Rqn02tbIUO+yExRDtESrrz9pzhJZhsO5mHIupTv2jwgfM12Mq6k3MnDkel
-- swiod7dkxF6Fwv63SCfUUGXSp16CB/iaI53lAiu8fZ6MqM3rhVRm7uFcD/zS8mnX
-- hgenh8b0Nn20XJ0qcyKdC8hPX4iSXPo6RcRx4lB6/KEeFdjDR/fROcGSrVq2bJ0e
-- NsKG9WfWmuZtg+c+3xV0nQYany8zslQQzDZ0aHW703LDb9PkeT1k
-- -----END-SIGNATURE-----