-- Macro Scripts File
-- Created:  Sep 06 2001
-- Author:   Alexander Esppeschit Bicalho


/*
Revision History
	13 sept 2001; Pierre-Felix Breton
	added snap mode toggle
	changed the cancellation prompt to be shown for 1 second
	
	19 sept 2001; Pierre-Felix Breton
	removed snap mode toggle

	24 mai 2003; Pierre-Felix Breton
	Added to 3ds MAX 6
	
	12 dec 2003, Pierre-Felix Breton, 
	added product switcher: this macro file can be shared with all Discreet products

*/

-- Macro Script to measure the distance between 2 points
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

macroScript two_point_dist
            category:~TWO_POINT_DIST_CATEGORY~ 
            internalCategory:"Tools" 
            tooltip:~TWO_POINT_DIST_TOOLTIP~ 
            buttontext:~TWO_POINT_DIST_BUTTONTEXT~ 
            iconName:"Extras/MeasureDistance"
(

	local pt1, pt2, str1, str2, str3, str4, str5, strDist, dist,  strDx, strDy, strDz

	local CurSnapModeActive, CurSnapModeType
	/* Start localization */
	

	fn RestoreSnaps = 
	(
			-- restores the snap mode that was setup before the command was invoked	
			snapMode.Active = CurSnapModeActive
			if snapMode.type == undefined do snapMode.type = #3D -- I have seen some old files where the mode was undefined, this is for security.
			snapMode.type = CurSnapModeType
	)
		
	str1 = ~STR1_CAPTION~
	str2 = ~STR2_CAPTION~ -- there are leading and a trailing spaces
	str3 = ~STR3_CAPTION~
	str4 = ~STR4_CAPTION~
	str5 = ~STR5_CANCELED~
	
	/* End localization */

	-- saves the snap mode that was used before the command was invoked
	--CurSnapModeActive = snapMode.Active
	--CurSnapModeType = snapMode.type

	-- activate the snap mode
	--snapMode.Active = True
	--if CurSnapModeActive == false do snapMode.type = #3d --if no snap was defined, assume that a default to per vertex would be good
		
	-- picks a first point
	pt1 = pickpoint snap:#3d
	
	if classof pt1 == point3 then
	(
		pt2 = pickpoint snap:#3d rubberband:pt1
		if classof pt2 == point3 then
		(
			dist = (distance pt1 pt2)
			strDist =  units.formatValue dist
	        strDx = units.formatValue ((((pt2.x-pt1.x) * 1000) as integer) / 1000.0)
			strDy = units.formatValue((((pt2.y-pt1.y) * 1000) as integer) / 1000.0)
			strDz = units.formatValue((((pt2.z-pt1.z) * 1000) as integer) / 1000.0)
			--RestoreSnaps()
			replacePrompt (str1 + strDist + str2 + strDx + str3 + strDy + str4 + strDz)	
			print (str1 + strDist)
		)
		else 
		(
			--RestoreSnaps() 	
			displayTempPrompt str5 1000 --the user cancelled
		)
	)
	else 
	(
		--RestoreSnaps() 	
		displayTempPrompt str5 1000 --the user cancelled
	)
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBKgI2+3f7uRmMLVeXY8CN79YQmvyyUNPc+
-- TrJiM8A0D9FaiSRBBQE9ux63RE/sjeK5fm+hrt6+T15ONPrUPbs6/jfQ8z9lJKpa
-- xkArcz1VvUl7sIbffV63BwRfcuwPLCQj2VPFkM508KrHzn3+tjblxqUDxPnmyKGV
-- jbxPKL+aq0Mvg4BPI32B+qwyzBI0bUZ8drYjwhWSO1pzizr/ADGbGYCGkrKbfK8k
-- dsk1+mpYb5wCHpoIbjWM81//wDsdDXxPcXKtNR3Q0JBry2NU12ipPNxfRhrAkQGN
-- oGXrNLRj77sx1E0w/p0pgXYVXzSGoWCCGfhOclrKkWWgL3vCi8de
-- -----END-SIGNATURE-----