-- Macro Scripts File
--
-- Macro Scripts for MCG (aka Viper aka Procedural Content) maxscript commands
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

MacroScript MCG3DOFRotationSpring
	ButtonText:~MCG_3DOF_ROTATION_TEXT~
	Category:~MCG_CATEGORY~ 
	internalCategory:"Max Creation Graph" 
	Tooltip:~MCG_3DOF_ROTATION_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	local promptStr
	local pickedParent
	
	fn displayViewportPrompt = (
		local xpos = mouse.pos.x + 20
		local ypos = mouse.pos.y + 20
		local txtSize = (gw.getTextExtent promptStr)
		if xpos < 0 then 
			xpos = 0
		else if xpos + txtSize.x > gw.getWinSizeX() do 
			xpos = gw.getWinSizeX() - txtSize.x
		if ypos < txtSize.y then 
			ypos = txtSize.y
		else if ypos > gw.getWinSizeY() do 
			ypos = gw.getWinSizeY()
		gw.wtext [xpos, ypos, 0] promptStr color:(color 255 255 255)
		gw.updateScreen()
	)
	
	fn ChildPickFn obj = 
	(
		if not ConstrFilterFn obj then return false
		if obj == pickedParent then return false
		return true
	)

	on isEnabled do
	(
		(::MCG_rotationalSpring3DOFTransform != undefined) and IsValidControllerSelection()
	)
	 
	on execute do 
	(
		Try
		(
			--Pick the parent
			promptStr = ~CONSTR_ROTATION_PARENT_PICKCAPTION~
			registerRedrawViewsCallback displayViewportPrompt 
			pickedParent = PickObject count:1 filter:ConstrFilterFn message:promptStr Rubberband:selection[1].transform.pos rubberBandColor:(color 100 100 160) ForceListenerFocus:False
			if (pickedParent != undefined and pickedParent != "None") then
			(
				--pick the child representation object
				promptStr = ~CONSTR_ROTATION_CHILD_PICKCAPTION~
				pickedChild = PickObject count:1 filter:ChildPickFn message:promptStr Rubberband:selection[1].transform.pos rubberBandColor:(color 160 100 100) ForceListenerFocus:False
				if (pickedChild != undefined and pickedChild != "None") then 
				(
					SetCommandPanelTaskMode Mode:#Motion
					node = selection[1]
					local controllerClass = classof node.controller
					if not (controllerClass == BipSlave_Control or
							controllerClass == XRef_Controller or
							(controllerClass == IK_ControllerMatrix3Controller and 
							 node.controller[1].controller == undefined)) then
					(
						-- Skip group members, only apply to head.  If you're a group member, your parent is a group head
						local nodeParent = node.parent 
						if not (nodeParent != undefined and nodeParent.isSelected and isGroupHead nodeParent) then
						(
							if (refs.DependencyLoopTest pickedParent node.controller != true and
								refs.DependencyLoopTest pickedChild node.controller != true) then 
							(
								node.controller = MCG_rotationalSpring3DOFTransform()
								node.controller.Parent_Object = pickedParent
								node.controller.Geometry_Hull = pickedChild
							)
						)
					)
				)
			)
			unregisterRedrawViewsCallback displayViewportPrompt 
		)
		Catch (
			unregisterRedrawViewsCallback displayViewportPrompt 
			MessageBox ~CONSTRFILTERFN_MCGROTATION_CONTROLLER_CAPTION~ Title:~MSGBOX_CONSTRAINTS_TITLE~)
	)
)

MacroScript MCG1DOFRotationSpring
	ButtonText:~MCG_1DOF_ROTATION_TEXT~
	Category:~MCG_CATEGORY~ 
	internalCategory:"Max Creation Graph" 
	Tooltip:~MCG_1DOF_ROTATION_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	local promptStr
	local pickedParent
	
	fn displayViewportPrompt = (
		local xpos = mouse.pos.x + 20
		local ypos = mouse.pos.y + 20
		local txtSize = (gw.getTextExtent promptStr)
		if xpos < 0 then 
			xpos = 0
		else if xpos + txtSize.x > gw.getWinSizeX() do 
			xpos = gw.getWinSizeX() - txtSize.x
		if ypos < txtSize.y then 
			ypos = txtSize.y
		else if ypos > gw.getWinSizeY() do 
			ypos = gw.getWinSizeY()
		gw.wtext [xpos, ypos, 0] promptStr color:(color 255 255 255)
		gw.updateScreen()
	)
	
	fn ChildPickFn obj = 
	(
		if not ConstrFilterFn obj then return false
		if obj == pickedParent then return false
		return true
	)

	on isEnabled do
	(
		(::MCG_rotationalSpring1DOFTransform != undefined) and IsValidControllerSelection()
	)
	 
	on execute do 
	(
		Try
		(
			--Pick the parent
			promptStr = ~CONSTR_ROTATION_PARENT_PICKCAPTION~
			registerRedrawViewsCallback displayViewportPrompt 
			pickedParent = PickObject count:1 filter:ConstrFilterFn message:promptStr Rubberband:selection[1].transform.pos rubberBandColor:(color 100 100 160) ForceListenerFocus:False
			if (pickedParent != undefined and pickedParent != "None") then
			(
				--pick the child representation object
				promptStr = ~CONSTR_ROTATION_CHILD_PICKCAPTION~
				pickedChild = PickObject count:1 filter:ChildPickFn message:promptStr Rubberband:selection[1].transform.pos rubberBandColor:(color 160 100 100) ForceListenerFocus:False
				if (pickedChild != undefined and pickedChild != "None") then 
				(
					SetCommandPanelTaskMode Mode:#Motion
					node = selection[1]
					local controllerClass = classof node.controller
					if not (controllerClass == BipSlave_Control or
							controllerClass == XRef_Controller or
							(controllerClass == IK_ControllerMatrix3Controller and 
							 node.controller[1].controller == undefined)) then
					(
						-- Skip group members, only apply to head.  If you're a group member, your parent is a group head
						local nodeParent = node.parent 
						if not (nodeParent != undefined and nodeParent.isSelected and isGroupHead nodeParent) then
						(
							if (refs.DependencyLoopTest pickedParent node.controller != true and
								refs.DependencyLoopTest pickedChild node.controller != true) then 
							(
								node.controller = MCG_rotationalSpring1DOFTransform()
								node.controller.Parent_Object = pickedParent
								node.controller.Geometry_Hull = pickedChild
							)
						)
					)
				)
			)
			unregisterRedrawViewsCallback displayViewportPrompt 
		)
		Catch (
			unregisterRedrawViewsCallback displayViewportPrompt 
			MessageBox ~CONSTRFILTERFN_MCGROTATION_CONTROLLER_CAPTION~ Title:~MSGBOX_CONSTRAINTS_TITLE~)
	)
)

MacroScript MCGSurfacePositionConstraint
	ButtonText:~MCG_SURFACE_POSITION_TEXT~
	Category:~MCG_CATEGORY~ 
	internalCategory:"Max Creation Graph" 
	Tooltip:~MCG_SURFACE_POSITION_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	local promptStr
	fn displayViewportPrompt = (
		local xpos = mouse.pos.x + 20
		local ypos = mouse.pos.y + 20
		local txtSize = (gw.getTextExtent promptStr)
		if xpos < 0 then 
			xpos = 0
		else if xpos + txtSize.x > gw.getWinSizeX() do 
			xpos = gw.getWinSizeX() - txtSize.x
		if ypos < txtSize.y then 
			ypos = txtSize.y
		else if ypos > gw.getWinSizeY() do 
			ypos = gw.getWinSizeY()
		gw.wtext [xpos, ypos, 0] promptStr color:(color 255 255 255)
		gw.updateScreen()
	)

	on isEnabled do
	(
		(::MCG_rayToSurfacePosition != undefined) and IsValidControllerSelection()
	)
	 
	on execute do 
	(
		Try (
			promptStr = ~CONSTR_SURFACE_PICKCAPTION~
			registerRedrawViewsCallback displayViewportPrompt 
			pickedSurface = PickObject count:1 filter:ConstrFilterFn message:~CONSTR_SURFACE_PICKCAPTION~ Rubberband:selection[1].transform.pos rubberBandColor:(color 100 100 160) ForceListenerFocus:False
			if (pickedSurface != undefined and pickedSurface != "None") then (
				promptStr = ~CONSTR_RAYCASTER_PICKCAPTION~
				pickedCaster = PickObject count:1 filter:ConstrFilterFn message:~CONSTR_RAYCASTER_PICKCAPTION~ Rubberband:selection[1].transform.pos rubberBandColor:(color 160 100 100) ForceListenerFocus:False
				if (pickedCaster != undefined and pickedCaster != "None") then (
					if selection.count == 1 then SetCommandPanelTaskMode Mode:#Motion
					for node in selection do (
						local controllerClass = classof node.controller
						if not (controllerClass == BipSlave_Control or
								controllerClass == XRef_Controller or
								(controllerClass == IK_ControllerMatrix3Controller and 
								 node.controller[1].controller == undefined)) then
						(
							-- Skip group members, only apply to head.  If you're a group member, your parent is a group head
							local nodeParent = node.parent 
							if not (nodeParent != undefined and nodeParent.isSelected and isGroupHead nodeParent) then (
								if (refs.DependencyLoopTest pickedSurface node.controller != true and
								    refs.DependencyLoopTest pickedCaster node.controller != true) then 
								(
									-- Add a Position_List Controller if not already there, to which we will add the MCG_rayToSurface controller
									local theListCtrl = AddListController node ~POSITION_CAPTION~ Position_List 
									local surfaceConst
							
									-- Add an MCG_rayToSurfacePosition if it's not already the active controller of the position list
									If classof theListCtrl[listCtrl.GetActive theListCtrl].object != MCG_rayToSurfacePosition then (
										surfaceConst = AddConstraint node ~POSITION_CAPTION~ MCG_rayToSurfacePosition true
									)
									else (
										surfaceConst = theListCtrl[listCtrl.GetActive theListCtrl].object
									)
					
									-- Set the MCG_rayToSurfacePosition as the active Controller of the position list controller
									SetActiveController theListCtrl surfaceConst

									append surfaceConst.Surfaces_Tab pickedSurface
									surfaceConst.Ray_Origin = pickedCaster
								)
							)
						)
					)
				)
			)
			unregisterRedrawViewsCallback displayViewportPrompt 
		)
		Catch (
			unregisterRedrawViewsCallback displayViewportPrompt 
			MessageBox ~CONSTRFILTERFN_MCGSURFACE_CONSTRAINT_CAPTION~ Title:~MSGBOX_CONSTRAINTS_TITLE~)
	)
)

MacroScript MCGSurfacePositionAndRotationConstraint
	ButtonText:~MCG_SURFACE_POSANDROTATION_TEXT~
	Category:~MCG_CATEGORY~ 
	internalCategory:"Max Creation Graph" 
	Tooltip:~MCG_SURFACE_POSANDROTATION_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	local promptStr 
	fn displayViewportPrompt = (
		local xpos = mouse.pos.x + 20
		local ypos = mouse.pos.y + 20
		local txtSize = (gw.getTextExtent promptStr)
		if xpos < 0 then 
			xpos = 0
		else if xpos + txtSize.x > gw.getWinSizeX() do 
			xpos = gw.getWinSizeX() - txtSize.x
		if ypos < txtSize.y then 
			ypos = txtSize.y
		else if ypos > gw.getWinSizeY() do 
			ypos = gw.getWinSizeY()
		gw.wtext [xpos, ypos, 0] promptStr color:(color 255 255 255)
		gw.updateScreen()
	)

	on isEnabled do
	(
		(::MCG_rayToSurfacePosition != undefined) and (::MCG_rayToSurfaceOrientation != undefined) and IsValidControllerSelection()
	)
	 
	on execute do 
	(
		Try (
			promptStr = ~CONSTR_SURFACE_PICKCAPTION~
			registerRedrawViewsCallback displayViewportPrompt 
			pickedSurface = PickObject count:1 filter:ConstrFilterFn message:~CONSTR_SURFACE_PICKCAPTION~ Rubberband:selection[1].transform.pos rubberBandColor:(color 100 100 160) ForceListenerFocus:False
			if (pickedSurface != undefined and pickedSurface != "None") then (
				promptStr = ~CONSTR_RAYCASTER_PICKCAPTION~
				pickedCaster = PickObject count:1 filter:ConstrFilterFn message:~CONSTR_RAYCASTER_PICKCAPTION~ Rubberband:selection[1].transform.pos rubberBandColor:(color 160 100 100) ForceListenerFocus:False
				if (pickedCaster != undefined and pickedCaster != "None") then (
					if selection.count == 1 then SetCommandPanelTaskMode Mode:#Motion
					for node in selection do (
						local controllerClass = classof node.controller
						if not (controllerClass == BipSlave_Control or
								controllerClass == XRef_Controller or
								(controllerClass == IK_ControllerMatrix3Controller and 
								 node.controller[1].controller == undefined)) then
						(
							-- Skip group members, only apply to head.  If you're a group member, your parent is a group head
							local nodeParent = node.parent 
							if not (nodeParent != undefined and nodeParent.isSelected and isGroupHead nodeParent) then (
								if (refs.DependencyLoopTest pickedSurface node.controller != true and
								    refs.DependencyLoopTest pickedCaster node.controller != true) then 
								(
									-- First, take care of the position
									---------------------------------------------------------------
									-- Add a Position_List Controller if not already there, to which we will add the MCG_rayToSurface Position controller
									local theListCtrl = AddListController node ~POSITION_CAPTION~ Position_List 
									local surfaceConst
							
									-- Add an MCG_rayToSurfacePosition if it's not already the active controller of the position list
									If classof theListCtrl[listCtrl.GetActive theListCtrl].object != MCG_rayToSurfacePosition then (
										surfaceConst = AddConstraint node ~POSITION_CAPTION~ MCG_rayToSurfacePosition true
									)
									else (
										surfaceConst = theListCtrl[listCtrl.GetActive theListCtrl].object
									)
					
									-- Set the MCG_rayToSurfacePosition as the active Controller of the position list controller
									SetActiveController theListCtrl surfaceConst

									append surfaceConst.Surfaces_Tab pickedSurface
									surfaceConst.Ray_Origin = pickedCaster

									-- Then, take care of the rotation
									---------------------------------------------------------------
									-- Add a Rotation_List Controller if not already there, to which we will add the MCG_rayToSurface Rotation controller
									theListCtrl = AddListController node ~ROTATION_CAPTION~ Rotation_List 
							
									-- Add an MCG_rayToSurfaceOrientation if it's not already the active controller of the rotation list
									If classof theListCtrl[listCtrl.GetActive theListCtrl].object != MCG_rayToSurfaceOrientation then (
										surfaceConst = AddConstraint node ~ROTATION_CAPTION~ MCG_rayToSurfaceOrientation true
									)
									else (
										surfaceConst = theListCtrl[listCtrl.GetActive theListCtrl].object
									)
					
									-- Set the MCG_rayToSurfaceOrientation as the active Controller of the rotation list controller
									SetActiveController theListCtrl surfaceConst

									append surfaceConst.Surfaces_Tab pickedSurface
									surfaceConst.Ray_Origin = pickedCaster
								)
							)
						)
					)
				)
			)
			unregisterRedrawViewsCallback displayViewportPrompt 
		)
		Catch (
			unregisterRedrawViewsCallback displayViewportPrompt 
			MessageBox ~CONSTRFILTERFN_MCGSURFACE_CONSTRAINT_CAPTION~ Title:~MSGBOX_CONSTRAINTS_TITLE~)
	)
)


MacroScript MCGSurfaceTransformConstraint
	ButtonText:~MCG_SURFACE_TRANSFORM_TEXT~
	Category:~MCG_CATEGORY~ 
	internalCategory:"Max Creation Graph" 
	Tooltip:~MCG_SURFACE_TRANSFORM_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	local promptStr
	fn displayViewportPrompt = (
		local xpos = mouse.pos.x + 20
		local ypos = mouse.pos.y + 20
		local txtSize = (gw.getTextExtent promptStr)
		if xpos < 0 then 
			xpos = 0
		else if xpos + txtSize.x > gw.getWinSizeX() do 
			xpos = gw.getWinSizeX() - txtSize.x
		if ypos < txtSize.y then 
			ypos = txtSize.y
		else if ypos > gw.getWinSizeY() do 
			ypos = gw.getWinSizeY()
		gw.wtext [xpos, ypos, 0] promptStr color:(color 255 255 255)
		gw.updateScreen()
	)

	on isEnabled do
	(
		(::MCG_rayToSurfaceTransform != undefined) and IsValidControllerSelection()
	)
	 
	on execute do 
	(
		Try (
			promptStr = ~CONSTR_SURFACE_PICKCAPTION~
			registerRedrawViewsCallback displayViewportPrompt 
			pickedSurface = PickObject count:1 filter:ConstrFilterFn message:~CONSTR_SURFACE_PICKCAPTION~ Rubberband:selection[1].transform.pos rubberBandColor:(color 100 100 160) ForceListenerFocus:False
			if (pickedSurface != undefined and pickedSurface != "None") then (
				promptStr = ~CONSTR_RAYCASTER_PICKCAPTION~
				pickedCaster = PickObject count:1 filter:ConstrFilterFn message:~CONSTR_RAYCASTER_PICKCAPTION~ Rubberband:selection[1].transform.pos rubberBandColor:(color 160 100 100) ForceListenerFocus:False
				if (pickedCaster != undefined and pickedCaster != "None") then (
					if selection.count == 1 then SetCommandPanelTaskMode Mode:#Motion
					for node in selection do (
						local controllerClass = classof node.controller
						if not (controllerClass == BipSlave_Control or
								controllerClass == XRef_Controller or
								(controllerClass == IK_ControllerMatrix3Controller and 
								 node.controller[1].controller == undefined)) then
						(
							-- Skip group members, only apply to head.  If you're a group member, your parent is a group head
							local nodeParent = node.parent 
							if not (nodeParent != undefined and nodeParent.isSelected and isGroupHead nodeParent) then (
								if (refs.DependencyLoopTest pickedSurface node.controller != true and
								    refs.DependencyLoopTest pickedCaster node.controller != true) then 
								(
									local transfo = MCG_rayToSurfaceTransform()

									append transfo.Surfaces_Tab pickedSurface
									transfo.Ray_Origin = pickedCaster
									node.transform.controller = transfo
								)
							)
						)
					)
				)
			)
			unregisterRedrawViewsCallback displayViewportPrompt 
		)
		Catch (
			unregisterRedrawViewsCallback displayViewportPrompt 
			MessageBox ~CONSTRFILTERFN_MCGSURFACE_CONSTRAINT_CAPTION~ Title:~MSGBOX_CONSTRAINTS_TITLE~)
	)
)

MacroScript MCGLookAt
	ButtonText:~MCG_LOOKAT_BUTTONTEXT~
	Category:~MCG_CATEGORY~ 
	internalCategory:"Max Creation Graph" 
	Tooltip:~MCG_LOOKAT_TOOLTIP~
	SilentErrors:(Debug != True) 

(
	on isEnabled do
	(
		(::MCG_lookAt != undefined) and IsValidControllerSelection()
	)
	 
	on execute do 
	(
		Try (
			pickedNode = PickObject count:1 filter:ConstrFilterFn message:~CONSTRFILTERFN_PICK_OBJ_LOOK_AT_CAPTION~ Rubberband:selection[1].transform.pos ForceListenerFocus:False
			if (pickedNode != undefined and pickedNode != "None") then
			(
				if selection.count == 1 then SetCommandPanelTaskMode Mode:#Motion
				for node in selection do
				(
					local controllerClass = classof node.controller
					if not (controllerClass == BipSlave_Control or
							controllerClass == XRef_Controller or
							(controllerClass == IK_ControllerMatrix3Controller and 
							 node.controller[1].controller == undefined)) then
					(
						-- Skip group members, only apply to head.  If you're a group member, your parent is a group head
						local nodeParent = node.parent 
						if not (nodeParent != undefined and nodeParent.isSelected and isGroupHead nodeParent) then (
							if (refs.DependencyLoopTest pickedNode node.controller != true) then (
								-- Add a Rotation_List Controller if not already there, to which we will add the look at
								local theListCtrl = AddListController node ~ROTATION_CAPTION~ Rotation_List 
							
								-- Add MCG_lookAt if it's not already the active controller of the rotation list
								If classof theListCtrl[listCtrl.GetActive theListCtrl].object != MCG_lookAt then (
									lookAt = AddConstraint node ~ROTATION_CAPTION~ MCG_lookAt true
								)
								else (
									lookAt = theListCtrl[listCtrl.GetActive theListCtrl].object
								)
					
								-- Set the MCG_lookAt as the active Controller of the rotation list controller
								SetActiveController theListCtrl lookAt

								append lookAt.Targets_Tab pickedNode
								append lookAt.Weights_Tab 50.0
							)
						)
					)
				)
			)			
		)
		Catch (
			MessageBox ~CONSTRFILTERFN_MCGLOOKAT_CONSTRAINT_CAPTION~ Title:~MSGBOX_CONSTRAINTS_TITLE~)
	)
)

MacroScript MCG_CFD_CreateCSVreaderNode
	ButtonText:~MCG_CREATE_CFD_READER_BUTTONTEXT~
	Category:~MCG_CATEGORY~ 
	internalCategory:"Max Creation Graph" 
	Tooltip:~MCG_CREATE_CFD_READER_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isEnabled do (
		(::CFDImportData != undefined)
	)
	 
	on execute do (
		-- Create a CFDImportData object, hide it, and browse for a CSV file to read from
		local importCFDdataNode = CFDImportData isSelected:true
		-- no symbolic name for CFD folder
		local csvFilename = getOpenFileName caption:~MCG_CFD_FILENAME_CAPTION~ filename:((symbolicPaths.getPathValue "$systemCFD") + "\\") types:"CSV(*.csv)|*.csv|All|*.*|"
		if (csvFilename != undefined) do (
			importCFDdataNode.CSV_File = csvFilename
		)
		importCFDdataNode.vertexTicks = on
		if (::CFDKeepNVertices != undefined) then (
			local keepNVtx = CFDKeepNVertices()
			keepNVtx.n = 2000
			AddModifier importCFDdataNode keepNVtx
		)
	)
)

MacroScript MCG_CFD_VisualizeTemperature
	ButtonText:~MCG_CFDTEMPERATURE_BUTTONTEXT~
	Category:~MCG_CATEGORY~ 
	internalCategory:"Max Creation Graph" 
	Tooltip:~MCG_CFDTEMPERATURE_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isEnabled do (
		(selection.count > 0 AND ::CFDVertexPaintChannel != undefined)
	)
	 
	on execute do (
		-- add a filter to the picking
		local pickedCFDNode = pickObject message:~MCG_CFD_PICK_CFDDATA_PROMPT~ ForceListenerFocus:False
		for node in selection do (
			node.showVertexColors = on
			local vtxPaintMod = CFDVertexPaintChannel()
			vtxPaintMod.CFDPoints = pickedCFDNode
			vtxPaintMod.ChannelID = 9
			vtxPaintMod.Local_Norm = on
			AddModifier node vtxPaintMod
		)			
		-- Apply a standard material with a vertex color map
		-- applied to the diffuse and self-illumination channels
		local mat = standardmaterial()
		local txt = Vertex_Color()
		mat.diffuseMap = txt
		mat.selfillumMap = txt
		$.material = mat
	)
)

MacroScript MCG_CFD_VisualizePressure
	ButtonText:~MCG_CFDPRESSURE_BUTTONTEXT~
	Category:~MCG_CATEGORY~ 
	internalCategory:"Max Creation Graph" 
	Tooltip:~MCG_CFDPRESSURE_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isEnabled do
	(
		(selection.count > 0 AND ::CFDVertexPaintChannel != undefined)
	)
	 
	on execute do 
	(
		-- add a filter to the picking
		local pickedCFDNode = pickObject message:~MCG_CFD_PICK_CFDDATA_PROMPT~ ForceListenerFocus:False
		for node in selection do (
			node.showVertexColors = on
			local vtxPaintMod = CFDVertexPaintChannel()
			vtxPaintMod.CFDPoints = pickedCFDNode
			vtxPaintMod.ChannelID = 8
			vtxPaintMod.Local_Norm = on
			AddModifier node vtxPaintMod
		)			
		-- Apply a standard material with a vertex color map
		-- applied to the diffuse and self-illumination channels
		local mat = standardmaterial()
		local txt = Vertex_Color()
		mat.diffuseMap = txt
		mat.selfillumMap = txt
		$.material = mat
	)
)

MacroScript MCG_CFD_VisualizeVelocity
	ButtonText:~MCG_CFDVELOCITY_BUTTONTEXT~
	Category:~MCG_CATEGORY~ 
	internalCategory:"Max Creation Graph" 
	Tooltip:~MCG_CFDVELOCITY_TOOLTIP~
	SilentErrors:(Debug != True) 

(
	on isEnabled do
	(
		(selection.count > 0 AND ::CFDVertexPaintVelocity != undefined)
	)
	 
	on execute do 
	(
		-- add a filter to the picking
		local pickedCFDNode = pickObject message:~MCG_CFD_PICK_CFDDATA_PROMPT~ ForceListenerFocus:False
		for node in selection do (
			node.showVertexColors = on
			local vtxPaintMod = CFDVertexPaintVelocity()
			vtxPaintMod.CFDPoints = pickedCFDNode
			vtxPaintMod.Local_Norm = on
			AddModifier node vtxPaintMod
		)
		-- Apply a standard material with a vertex color map
		-- applied to the diffuse and self-illumination channels
		local mat = standardmaterial()
		local txt = Vertex_Color()
		mat.diffuseMap = txt
		mat.selfillumMap = txt
		$.material = mat
	)
)


MacroScript MCG_CFD_VisualizeSpline
	ButtonText:~MCG_CFDSPLINE_BUTTONTEXT~
	Category:~MCG_CATEGORY~ 
	internalCategory:"Max Creation Graph" 
	Tooltip:~MCG_CFDSPLINE_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	local promptStr
	-- Display a picking prompt in the active viewport near the cursor
	fn displayViewportPrompt = (
		local xpos = mouse.pos.x + 20
		local ypos = mouse.pos.y + 20
		local txtSize = (gw.getTextExtent promptStr)
		if xpos < 0 then 
			xpos = 0
		else if xpos + txtSize.x > gw.getWinSizeX() do 
			xpos = gw.getWinSizeX() - txtSize.x
		if ypos < txtSize.y then 
			ypos = txtSize.y
		else if ypos > gw.getWinSizeY() do 
			ypos = gw.getWinSizeY()
		gw.wtext [xpos, ypos, 0] promptStr color:(color 255 255 255)
		gw.updateScreen()
	)

	fn filterHelperFn o = (
		superClassOf o == Helper
	)

	on isEnabled do
	(
		(::CFDSplineNode != undefined)
	)
	 
	on execute do 
	(
		-- add a filter to the picking
		promptStr = ~MCG_CFD_PICK_CFDDATA_PROMPT~
		Try
		(
			registerRedrawViewsCallback displayViewportPrompt 
			local pickedCFDNode = pickObject message:~MCG_CFD_PICK_CFDDATA_PROMPT~ ForceListenerFocus:False
			promptStr = ~MCG_CFD_PICK_SPLINEHELPER_PROMPT~
			local pickedHelperNode = pickObject message:~MCG_CFD_PICK_SPLINEHELPER_PROMPT~ ForceListenerFocus:False
			local splineNode = CFDSplineNode isSelected:true
			if (splineNode != undefined) then (
				splineNode.Spline_Origin_Helper = pickedHelperNode
				splineNode.CFD_Points = pickedCFDNode
				-- Making the spline renderable and visible in the viewport through maxscript does not work...
	--			splineNode.render_displayRenderMesh = true
	--			splineNode.render_renderable = true
				local mat = Multimaterial()
				mat.numsubs = 5
				local mat1 = standardmaterial()
				mat1.ambient = mat1.diffuse = (color 221 43 0)
				local mat2 = standardmaterial()
				mat2.ambient = mat2.diffuse = (color 254 60 1)
				local mat3 = standardmaterial()
				mat3.ambient = mat3.diffuse = (color 254 110 11)
				local mat4 = standardmaterial()
				mat4.ambient = mat4.diffuse = (color 254 156 30)
				local mat5 = standardmaterial()
				mat5.ambient = mat5.diffuse = (color 254 244 78)
				mat.materialList  = #(mat1, mat2, mat3, mat4, mat5)
				splineNode.material = mat
			)
			unregisterRedrawViewsCallback displayViewportPrompt 
		)
		Catch (
			-- in case anything goes wrong, make sure displayViewportPrompt is unregistered
			unregisterRedrawViewsCallback displayViewportPrompt 
		)
	)
)

MacroScript MCG_CFD_VelocityField
	ButtonText:~MCG_CFDVELOCITYFIELD_BUTTONTEXT~
	Category:~MCG_CATEGORY~ 
	internalCategory:"Max Creation Graph" 
	Tooltip:~MCG_CFDVELOCITYFIELD_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isEnabled do
	(
		(::CFDVelocityField != undefined)
	)
	 
	on execute do 
	(
		-- add a filter to the picking
		local velFieldObj = CFDVelocityField isSelected:true
		if (velFieldObj != undefined) then (
			local pickedCFDNode = pickObject message:~MCG_CFD_PICK_CFDDATA_PROMPT~ ForceListenerFocus:False
			velFieldObj.CFDImport_Object = pickedCFDNode
			velFieldObj.showVertexColors = on
			-- Apply a standard material with a vertex color map
			-- applied to the diffuse and self-illumination channels
			local mat = standardmaterial()
			local txt = Vertex_Color()
			mat.diffuseMap = txt
			mat.selfillumMap = txt
			velFieldObj.material = mat
		)
	)
)

MacroScript MCG_CreateToolForObject
	ButtonText:~MCG_CREATE_OBJECT_GRAPH_BUTTONTEXT~
	Category:~MCG_CATEGORY~ 
	internalCategory:"Max Creation Graph" 
	Tooltip:~MCG_CREATE_OBJECT_GRAPH_TOOLTIP~
(
	local toolName = ~MCG_OBJECT_NAME~
	local ToolDialogOK = false

	-- describe a rollout to be used as a dialog in the command
	rollout GetToolName ~MCG_OBJECT_DIALOG_CAPTION~
	(
		label		lbl_test ~MCG_OBJECT_DIALOG_PROMPT~ offset:[0, 10] align:#left
		dotnetcontrol	edit_toolText "TextBox" toolTip:~MCG_OBJECT_NAME~
		button		btn_OK ~MCG_OK_TEXT~ offset:[80, 10] width:60  across:2 align:#right
		button		btn_CCL ~MCG_CANCEL_TEXT~  offset:[0, 10] width:60   align:#right
		
		-- we add that event so that the user can simply press enter to validate his choice
		on edit_toolText KeyUp evnt do (
			if evnt.KeyCode == (dotNetClass "System.Windows.Forms.Keys").Enter do (
				ToolDialogOK = true
				DestroyDialog GetToolName
			)

		)
		
		on btn_OK pressed do (
			ToolDialogOK = true
			DestroyDialog GetToolName
		)

		on btn_CCL pressed do (
			ToolDialogOK = false 
			DestroyDialog GetToolName
		)

		on GetToolName open do (
			-- we set an explanatory tooltip to the textbox
			ToolTipObj = dotnetobject "System.Windows.Forms.ToolTip"
			ToolTipObj.SetToolTip edit_toolText ~MCG_OBJECT_TOOLTIP~
			ToolTipObj.Active = True
			
			ToolDialogOK = false
			edit_toolText.text = toolName
			setFocus edit_toolText
			-- Select all text in the tool name.
			local EM_SETSEL = 0xB1
			windows.sendmessage edit_toolText.hwnd[1] EM_SETSEL 0 -1
		)

		on GetToolName okToClose do (
			local invalidName = false
			if (ToolDialogOK) do (
				toolName = (dotNetObject "System.Text.RegularExpressions.Regex" "\W").Replace edit_toolText.text "_"
				local toolPath = ::GetFileNameForMCGUserTool toolName
				local fileExists = doesFileExist toolPath
				-- validate that no tool with that name already exists
				invalidName = true
				if (fileExists) then (
					MessageBox ~MCG_USER_TOOL_EXISTS~ title: ~MCG_INVALID_TOOL_NAME~
					ToolDialogOK = false
					return false
				)
				else (
					try (
						invalidName = (execute toolName) != undefined
					)
					catch (
					)
					if (invalidName) then (
						MessageBox ~MCG_MAXSCRIPT_CONFLICT~ title: ~MCG_INVALID_TOOL_NAME~
						ToolDialogOK = false
						return false
					)
				)
			)
			(NOT ToolDialogOK OR NOT invalidName)
		)
	)

	on execute do 
	(
		ToolDialogOK = true
		-- If not in quiet mode, open a dialog to get the tool name.
		-- If in quiet mode, a value can be set via NewMCGObjectName or the default value will be used.
		if (GetQuietMode()) then (
			if (::NewMCGObjectName != undefined) do
				toolName = ::NewMCGObjectName
			-- validation of the name for invalid characters and maxscript conflict in quiet mode
			toolName = (dotNetObject "System.Text.RegularExpressions.Regex" "\W").Replace toolName "_"
			if (execute toolName) != undefined do
				ToolDialogOK = false
		) else
			createDialog GetToolName 320 100 modal:true
			
		local res = ToolDialogOK
		if (ToolDialogOK) do (
			setWaitCursor()
			local templateFile = pathConfig.appendPath (getDir #plugcfg) "MCG\\Tools\\MCG_objectTemplate.maxtool"
			res = ::GenerateMCGToolFromTemplate templateFile toolName true true
			if (res) do
			(
				execute (toolName + " isSelected:on")
				setCommandPanelTaskMode #modify
			)
			setArrowCursor()
		)
		res
	)
)


MacroScript MCG_CreateToolForModifier
	ButtonText:~MCG_CREATE_MODIFIER_GRAPH_BUTTONTEXT~
	Category:~MCG_CATEGORY~ 
	internalCategory:"Max Creation Graph" 
	Tooltip:~MCG_CREATE_MODIFIER_GRAPH_TOOLTIP~
(
	local toolName = ~MCG_MODIFIER_NAME~
	local ToolDialogOK = false

	-- describe a rollout to be used as a dialog in the command
	rollout GetToolName ~MCG_MODIFIER_DIALOG_CAPTION~
	(
		label		lbl_test ~MCG_MODIFIER_DIALOG_PROMPT~ offset:[0, 10] align:#left
		dotnetcontrol	edit_toolText "TextBox" toolTip:~MCG_MODIFIER_NAME~
		button		btn_OK ~MCG_OK_TEXT~ offset:[80, 10] width:60  across:2 align:#right
		button		btn_CCL ~MCG_CANCEL_TEXT~  offset:[0, 10] width:60   align:#right

		-- we add that event so that the user can simply press enter to validate his choice
		on edit_toolText KeyUp evnt do (
			if evnt.KeyCode == (dotNetClass "System.Windows.Forms.Keys").Enter do (
				ToolDialogOK = true
				DestroyDialog GetToolName
			)

		)
		
		on btn_OK pressed do (
			ToolDialogOK = true
			DestroyDialog GetToolName
		)

		on btn_CCL pressed do (
			ToolDialogOK = false
			DestroyDialog GetToolName
		)

		on GetToolName open do (
			-- we set an explanatory tooltip to the textbox
			ToolTipObj = dotnetobject "System.Windows.Forms.ToolTip"
			ToolTipObj.SetToolTip edit_toolText ~MCG_MODIFIER_TOOLTIP~
			ToolTipObj.Active = True
		
			ToolDialogOK = false
			edit_toolText.text = toolName
			setFocus edit_toolText
			-- Select all text in the tool name.
			local EM_SETSEL = 0xB1
			windows.sendmessage edit_toolText.hwnd[1] EM_SETSEL 0 -1
		)

		on GetToolName okToClose do (
			local invalidName = false
			if (ToolDialogOK) do (
				toolName = (dotNetObject "System.Text.RegularExpressions.Regex" "\W").Replace edit_toolText.text "_"
				local toolPath = ::GetFileNameForMCGUserTool toolName
				local fileExists = doesFileExist toolPath
				-- validate that no tool with that name already exists
				invalidName = true
				if (fileExists) then (
					MessageBox ~MCG_USER_TOOL_EXISTS~ title: ~MCG_INVALID_TOOL_NAME~
					ToolDialogOK = false
					return false
				)
				else (
					try (
						invalidName = (execute toolName) != undefined
					)
					catch (
					)
					if (invalidName) then (
						MessageBox ~MCG_MAXSCRIPT_CONFLICT~ title: ~MCG_INVALID_TOOL_NAME~
						ToolDialogOK = false
						return false
					)
				)
			)
			(NOT ToolDialogOK OR NOT invalidName)
		)
	)

	on isEnabled do
	(
		-- enable if we have at least one selected node that can be converted to mesh
		local enabled = selection.count > 0
		if enabled do (
			enabled = false
			for node in selection do (
				if (CanConvertTo node Mesh) do (
					enabled = true
					break
				)
			)
		)
		enabled
	)
	 
	on execute do 
	(
		ToolDialogOK = true
		-- If not in quiet mode, open a dialog to get the tool name.
		-- If in quiet mode, a value can be set via NewMCGModifierName or the default value will be used.
		if (GetQuietMode()) then (
			if (::NewMCGModifierName != undefined) do
				toolName = ::NewMCGModifierName
			-- validation of the name for invalid characters and maxscript conflict in quiet mode
			toolName = (dotNetObject "System.Text.RegularExpressions.Regex" "\W").Replace toolName "_"
			if (execute toolName) != undefined do
				ToolDialogOK = false
		) else
			createDialog GetToolName 320 100 modal:true

		local res = ToolDialogOK
		if (ToolDialogOK) do (
			setWaitCursor()
			local templateFile = pathConfig.appendPath (getDir #plugcfg) "MCG\\Tools\\MCG_modifierTemplate.maxtool"
			res = ::GenerateMCGToolFromTemplate templateFile toolName true true
			if (res) do
			(
				local toolClass = execute toolName
				for node in $ do (
					if (validModifier node toolClass) do
						AddModifier node (toolClass())
				)
				setCommandPanelTaskMode #modify
			)
			setArrowCursor()
		)
		res
	)
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBKuq6dVe3bO5EYiTS13vGDS3gF54KeWN5S
-- ECarYxZmfKBNCX7MqTicI1B6Nuxnn+k919L+k93Ocm3vaWGhbI7Wol2u0ZwjwIwt
-- OZYiEm8Ib1BfWdwQwfBgazAm5Toj+gwjdgv/GM7T2OGvrDrR5pV+lIt5+Y5joWCQ
-- 1joeKKpdaAEnIQcT0GQW+Ju+VzraGNPUZgk3H8hUaz55SS0AWzTk+UrYQ3UCzW91
-- tTl77w4/NE1TxRPy3HJqfeCrom9aGcdMJkHoeYgAlx5KZw5b2RlyvIOv+GrMQcam
-- Hqs+L6aCjXT8K2BOMkeWxR1SRF15Q9yPxrKRjc+sdt9XszQI/RS0
-- -----END-SIGNATURE-----