/*

Isolate Inverse Selection Script File
Created:  		July 31 2001
Author:   Pete Samson


Isolate Inverse Selection Functions
This script creates functions for Isolating  unselected geometery and 
basically inverses the selection and call the Isolate Selection script 
***********************************************************************************************/

MacroScript Isolate_Inverse_Selection
Category:~ISOLATE_INVERSE_SELECTION_CATEGORY~ 
internalCategory:"Tools" 
ToolTip:~ISOLATE_INVERSE_SELECTION_TOOLTIP~ 
buttontext:~ISOLATE_INVERSE_SELECTION_BUTTONTEXT~ 
Icon:#("ViewPortNavigationControls",7) 
SilentErrors:True
(

	on isEnabled return(selection.count > 0 and (subObjectLevel == 0 or subObjectLevel == undefined))
			
	on execute do with undo off
	(
		-- saves the current selection filter (all, lights, geometry etc...)
		local SavedSelectionFilter
		SavedSelectionFilter = GetSelectFilter()

		--set the selection filter to all in order to provide an efficient Isolation tool
		SetSelectFilter 1
		if (isSelectionFrozen() == true)do thawSelection() ---pfb feb 10 2003, tool was failing when selection is locked
		max select invert
		IsolateSelection.EnterIsolateSelectionMode()
		max select none
		
		--restores the previously saved selection filter
		SetSelectFilter SavedSelectionFilter
	)
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAcDLlclmTvKMIj1qP3kO3x2f9byY3GOwhD
-- rqv2kwQ+ccmhr3HYRY4cWIbUyh7kHbCrDS9g2Y1yPYhl1L2EsAlogIiqEUr1mm9z
-- khr2nkVBlG/wo5ZECYr9WhAF/wAi662JMLnrqxCZA53PAdWJObBJck+9RHYNtv/l
-- 7I0PSJJETe7iANIIACYrmhRZspL6YZWGVQry1Emh0ArGPaLRDGNSMsTkZNsnHuxn
-- v261dy/2JyBmeT8WBfXs1ELXquZDBKu6yU+K6AKpWRW0GmGGKO1tzRebq0lR25sf
-- wKEwLsWfMUOPW2UWOqMZ4qbOQHEIAwq2UJ0ztK1R5rFqgGdK9Yyt
-- -----END-SIGNATURE-----