/*
   
Easy IK Assignment MacroScript File

Revision History:

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products


This script increases workflow on assigning IK Solvers.
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
-- 
*/


MacroScript HD_IK
	ButtonText:~HD_SOLVER_BUTTONTEXT~
	Category:~INVERSE_KINEMATICS_CATEGORY~ 
	internalCategory:"Inverse Kinematics" 
	Tooltip:~HISTORY_DEPENDENT_IK_SOLVER_TOOLTIP~ 
	Icon:#("MainToolbar",49)
	SilentErrors:(Debug == undefined or Debug != True)

(
	
			
	on isEnabled return selection.count == 1 or 
						selection.count > 1 and
						(
							local h = selection[1].parent 
							h != undefined and h.isSelected and isGroupHead h
						)
	 
	on execute do 
	(
		Global EC_OBJ, EC_TargetObj
		
		Animate Off
		(
			EC_OBJ = selection[1]
			
			-------------------------------------------------------------------------------------------
			-- Define Filter Function for PickObject Selection
			-------------------------------------------------------------------------------------------
			
			fn ChildFilt o = Filters.Is_Child EC_OBJ o or Filters.Is_Parent EC_OBJ o
			
			-------------------------------------------------------------------------------------------
						
			EC_TargetOBJ = PickObject count:1 select:false filter:ChildFilt count:#Multiple Message:~PICK_JOINT_TO_COMPLETE_IK_CHAIN_CAPTION~ Rubberband:EC_OBJ.pos ForceListenerFocus:False
			
			If EC_TargetOBJ != #escape and EC_TargetOBJ != undefined then 
			(
				if Filters.Is_Child EC_OBJ EC_TargetOBJ then
				(
					NIK = HDiksys.ikchain EC_OBJ EC_TargetOBJ True
									
				)
				Else
				(
					NIK = HDiksys.ikchain  EC_TargetOBJ EC_OBJ True
				)
		
				
			)
				
			Max Motion Mode
		)
		
	)		

)
MacroScript HI_IK
	ButtonText:~HI_SOLVER_BUTTONTEXT~
	Category:~HI_IK_INVERSE_KINEMATICS_CATEGORY~ 
	internalCategory:"Inverse Kinematics" 
	Tooltip:~HISTORY_INDEPENDENT_IK_SOLVER_TOOLTIP~ 
	Icon:#("MainToolbar",49)
	SilentErrors:(Debug == undefined or Debug != True)

(
	
	
	-- Check to see if something is selected
		
	on isEnabled return selection.count == 1 or 
						selection.count > 1 and
						(
							local h = selection[1].parent 
							h != undefined and h.isSelected and isGroupHead h
						)
	 
	on execute do 
	(
		Global EC_OBJ, EC_TargetObj
					
		Animate off
		(	
			EC_OBJ = selection[1]
			
			-------------------------------------------------------------------------------------------
			-- Define Filter Function for PickObject Selection
			-------------------------------------------------------------------------------------------
			
			fn ChildFilt o = Filters.Is_Child EC_OBJ o or Filters.Is_Parent EC_OBJ o
			
			-------------------------------------------------------------------------------------------
						
			EC_TargetOBJ = PickObject count:1 select:false filter:ChildFilt count:#Multiple Message:~PICKOBJECT_JOINT_TO_COMPLETE_IK_CHAIN_CAPTION~ Rubberband:EC_OBJ.pos ForceListenerFocus:False
			
			If EC_TargetOBJ != #escape and EC_TargetOBJ != undefined then 
			(
				if Filters.Is_Child EC_OBJ EC_TargetOBJ then
				(
					NIK = iksys.ikchain EC_OBJ EC_TargetOBJ "IKHISolver"
				)
				Else
				(
					NIK = iksys.ikchain  EC_TargetOBJ EC_OBJ "IKHISolver"
				)
							
			)
			Max Motion Mode
		)
					
	)		

)

MacroScript IK_Limb
	ButtonText:~IK_LIMB_SOLVER_BUTTONTEXT~
	Category:~IK_LIMB_INVERSE_KINEMATICS_CATEGORY~ 
	internalCategory:"Inverse Kinematics" 
	Tooltip:~IK_LIMB_SOLVER_TOOLTIP~ 
	Icon:#("MainToolbar",49)
	SilentErrors:(Debug == undefined or Debug != True)

(
	
		
	-- Check to see if something is selected
		
	on isEnabled return selection.count == 1 or 
						selection.count > 1 and
						(
							local h = selection[1].parent 
							h != undefined and h.isSelected and isGroupHead h
						)
	 
	on execute do 
	(
		Global EC_OBJ, EC_TargetObj		
		EC_OBJ = selection[1]
		
		-------------------------------------------------------------------------------------------
		-- Define Filter Function for PickObject Selection
		-------------------------------------------------------------------------------------------
		
		fn ChildFilt o = Filters.Is_Child EC_OBJ o or Filters.Is_Parent EC_OBJ o
		
		-------------------------------------------------------------------------------------------
			
		Animate off
		(
			EC_TargetOBJ = PickObject count:1 select:false filter:ChildFilt Message:~IK_LIMB_JOINT_TO_COMPLETE_IK_CHAIN_CAPTION~ count:#Multiple Rubberband:EC_OBJ.pos ForceListenerFocus:False
			
			If EC_TargetOBJ != #escape and EC_TargetOBJ != undefined then 
			(
				if Filters.Is_Child EC_OBJ EC_TargetOBJ then
				(
					NIK = iksys.ikchain EC_OBJ EC_TargetOBJ "IKLimb"
				)
					Else
				(
					NIK = iksys.ikchain EC_TargetOBJ EC_OBJ  "IKLimb"
				)
						
			)
			
			Max Motion Mode
		)
			
	)	
)



MacroScript SPLINE_IK
	ButtonText:~SPLINEIK_SOLVER_BUTTONTEXT~
	Category:~SPLINE_IK_INVERSE_KINEMATICS_CATEGORY~ 
	internalCategory:"Inverse Kinematics" 
	Tooltip:~SPLINE_IK_SOLVER_TOOLTIP~ 
	Icon:#("MainToolbar",49)
	SilentErrors:(Debug == undefined or Debug != True)

(
	Global EC_OBJ, EC_TargetObj, EC_SplineOBJ, EC_HelperOBJ
	
	-- Check to see if something is selected
	on isEnabled return selection.count == 1 or 
						selection.count > 1 and
						(
							local h = selection[1].parent 
							h != undefined and h.isSelected and isGroupHead h
						)
	 
	on execute do 
	(
		Try
		(
			-------------------------------------------------------------------------------------------
			-- Switch to Motion Panel
			-------------------------------------------------------------------------------------------
		
			IF getCommandPanelTaskMode() != #motion then SetCommandPanelTaskMode Mode:#Motion
			-------------------------------------------------------------------------------------------
			-- Check for Groups and act accordingly
			-------------------------------------------------------------------------------------------
			
			EC_OBJ = selection[1]
			if selection.count > 1 do 
			(
				local h = EC_OBJ.parent 
				if (h != undefined and h.isSelected and isGroupHead h) do EC_OBJ = h
			)
		
					
		Animate off
		(	
			-------------------------------------------------------------------------------------------
			-- Define Filter Functions for PickObject Selection
			-------------------------------------------------------------------------------------------			
			fn ChildFilt o = Filters.Is_Child EC_OBJ o or Filters.Is_Parent EC_OBJ o
			fn ShapeFilt o = superClassOf o == Shape and o != EC_OBJ
			-------------------------------------------------------------------------------------------
						
			EC_TargetOBJ = PickObject count:1 select:false filter:ChildFilt count:#Multiple Message:~SPLINE_IK_JOINT_TO_COMPLETE_IK_CHAIN_CAPTION~ Rubberband:EC_OBJ.pos ForceListenerFocus:False			
			If EC_TargetOBJ != #escape and EC_TargetOBJ != undefined then 
			(
				if Filters.Is_Child EC_OBJ EC_TargetOBJ then
				(
					NIK = iksys.IKChain  EC_OBJ EC_TargetOBJ "SplineIKSolver"
				)
				Else
				(
					NIK = iksys.IKChain  EC_TargetOBJ EC_OBJ "SplineIKSolver"
				)
							
			)
			
			EC_SplineOBJ = PickObject count:1 select:false filter:ShapeFilt count:#Multiple Message:~SPLINE_IK_PICK_SPLINE_TO_ASSIGN_SPLINEIK_CAPTION~ Rubberband:EC_TargetOBJ.pos ForceListenerFo
			
			If EC_SplineOBJ != undefined and EC_SplineOBJ != ~EC_SPLINEOBJ_NOT_NONE~ then
			(
				-------------------------------------------------------------------------------------------
				-- Make the Spline the goal shape of the SplineIK
				-------------------------------------------------------------------------------------------
				NIK.transform.controller.pickShape = EC_SplineOBJ		
								
				-------------------------------------------------------------------------------------------			
				-- Add SplinIKControl Modifier and Create Helpers
				-------------------------------------------------------------------------------------------		
				mod = Spline_IK_Control()
				AddModifier EC_SplineOBJ (mod)
				mod.createHelper(0)
				EC_HelperOBJ = mod.helper_list[1]
				
				-- Set the upnode to the first helper
				NIK.controller.upnode = EC_HelperObj

				-------------------------------------------------------------------------------------------
				-- Add List Controller and Path Constraint
				-------------------------------------------------------------------------------------------
				local cont
				if Filters.Is_Child EC_OBJ EC_TargetOBJ then
				(
					cont = AddListController EC_OBJ ~EC_OBJ_POS_CONTROLLER_NAME~ Position_List
					If classof cont[listCtrl.GetActive cont].object != Path_Constraint then constraint = AddConstraint EC_OBJ ~CONSTRAINT_EC_OBJ_POS~ Path_Constraint true
					else constraint = cont[listCtrl.GetActive cont].object
				)
				else
				(
					cont = AddListController EC_TargetOBJ ~EC_TARGETOBJ_NAME~ Position_List
					If classof cont[listCtrl.GetActive cont].object != Path_Constraint then constraint = AddConstraint EC_TargetOBJ ~EC_TARGETOBJ_PART_NAME~ Path_Constraint true
					else constraint = cont[listCtrl.GetActive cont].object
				)

				-------------------------------------------------------------------------------------------
				-- Add Path Constraint Object Target as the spline
				-------------------------------------------------------------------------------------------		
				constraint.AppendTarget EC_SplineObj 50
				DeleteKeys constraint.percent.controller
				constraint.percent = 0.0
							
				-------------------------------------------------------------------------------------------
				-- Set Active Controller
				-------------------------------------------------------------------------------------------
						
				SetActiveController cont constraint
				
				--Format "%\n"  (EC_OBJ.name + ~IS_POSITION_CONSTRAINED_TO~ + EC_HelperOBJ.name) to:Listener
							
				Select EC_OBJ
			)	

			Max Motion Mode
		)
		
		)
		Catch (MessageBox ~SPLINEOK_NOT_COMPLETED_CAPTION~ Title:~IK_TITLE~)
					
	)		

)






-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCTq8XMkoS8W8jPF8xR2+IEmLdamlMj0J9W
-- hv+IcIGs6Nl0acp8heMJ+/SiQFrNctOKHaA1IqVQiIUykRTwO1h1jKYGVER7ZjGT
-- L8pXwLqLUPNk7CH/33+l/yRx46H8UNLOM7C26GPzGRmYhXRUIUSj3WhEs9X9Wk1B
-- f2uDBHtbjv9aUJ3QhORIeJEGnAeFajVscJRIjI6OBpn3GhbRz1WmIrerbrSdfSt3
-- 9jkN4c80en/8D41oyPqlQ1fgEaTqIhaYRPAALljZNdZ/VhXDjV1UU5euD2zyBSgG
-- Mk65belOuaD2w/jvkFNlyitjxihDAjzwmSQorvqPFznT0MnAAs2q
-- -----END-SIGNATURE-----