/*

***************************************************************************
Macro_Scripts File
Author:   Attila Szabo
Macro_Scripts that implement some of the Help menu items

Revision History
    Aug 06, 2003 - aszabo - Created
	
	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products
		consolidated the hotkey movie macro in this file

	23 march 2006, Pierre-Felix Breton
		added a new "data exchange solutions" menu
		consolidated with the welcome screen

	30th June 2006, Pierre-Felix Breton
		Added a check for 64 bit in the welcome screen to load a different web page
		reduces the margins of the welcome screen
		
	April 2006, Chris Johnson
		Removed activeX controls, and added .NET controls.

-- MODIFY THIS AT YOUR OWN RISK
***************************************************************************

*/
macroScript Help_Web_Area_learning
buttontext:~HELP_WEB_AREA_LEARNING_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_AREA_LEARNING_TOOLTIP~ 
(
	local fname = ~FNAME_AUTODESK_COM_AREA_LEARNING~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_AREA_LEARNING_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_OnlineSupport
buttontext:~HELP_WEB_ONLINESUPPORT_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_ONLINESUPPORT_TOOLTIP~ 
(
	local fname = ~FNAME_AUTODESK_COM_3DSMAX_SUPPORT~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_ONLINE_SUPPORT_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Updates
buttontext:~HELP_WEB_UPDATES_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_UPDATES_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_UPDATE~
	local strMsgTitle = "3ds Max"
	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_UPDATES_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Training
buttontext:~HELP_WEB_TRAINING_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_TRAINING_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_TRAINING~
	local strMsgTitle = "3ds Max"
		
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_TRANING_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Partners
buttontext:~HELP_WEB_PARTNERS_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_PARTNERS_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_DEVELOPERS~
	local strMsgTitle = "3ds Max"
        
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_PARTNERS_WEB_PAGE~
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)


macroScript Help_Web_ExchangeSolutions
buttontext:~HELP_WEB_EXCHANGESOLUTIONS_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_EXCHANGESOLUTIONS_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_MAX_EXCHANGE~
	local strMsgTitle = "3ds Max"
        
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_DATA_EXCHANGE_SOLUTIONS_WEB_PAGE~
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)


macroScript HotkeyFlash 
category:~HELP_CATEGORY~ 
internalCategory:"Help"
tooltip:~HOTKEYFLASH_TOOLTIP~ 
(
	on execute do
	(
		local langDir = (sysinfo.getMaxLanguage())[5]
		local page = (getDir #maxroot) + "\\" + langdir + "\\html\\hotkeymap.html"
		ShellLaunch page ""
	)
)
macroScript Help_Web_LearningPath
buttontext:~HELP_WEB_LEARNINGPATH_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_LEARNINGPATH_TOOLTIP~ 
(
	local fname = ~FNAME_AUTODESK_COM_3DSMAX_LEARNINGPATH~
	local strMsgTitle = "3ds Max"
        
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_LEARNING_PATH_WEB_PAGE~
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)


macroScript Help_Web_TheArea
buttontext:~HELP_WEB_THEAREA_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_THEAREA_TOOLTIP~ 
(
	local fname = ~FNAME_AREA_AUTODESK_COM2~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_AREA_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_HowTo_Movies
buttontext:~HELP_HOWTO_MOVIES_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_HOWTO_MOVIES_TOOLTIP~ 
(
	local fname = ~FNAME_AUTODESK_COM_3DSMAX_HOWTO~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_HOW_TO_MOVIES_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)


macroScript Help_Certified_Graphic_Cards
buttontext:~HELP_CERTIFIED_GRAPHIC_CARDS_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_CERTIFIED_GRAPHIC_CARDS_TOOLTIP~ 
(
	local fname = ~FNAME_AUTODESK_COM_3DSMAX_CERTHARDWARE~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_CERTIFIED_HARDWARE_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Tutorials
buttontext:~HELP_TUTORIALS_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_TUTORIALS_TOOLTIP~ 
(
	
	local fname = ~AUTODESK_COM_3DSMAX_TUTORIALS~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_TUTORIALS_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)


macroScript Help_Vegetation
buttontext:~HELP_VEGETATION_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_VEGETATION_TOOLTIP~ 
(
	local fname = ~FNAME_AUTODESK_COM_SEEK_XFROG~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_VEGETATION_DOWNLOAD_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Student
buttontext:~HELP_STUDENT_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_STUDENT_TOOLTIP~ 
(
	local fname = ~FNAME_AUTODESK_COM_EDCOMMUNITY~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_STUDENT_COMMUNITY_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_DefectSubmission
buttontext:~HELP_DEFECTSUBMISSION_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_DEFECTSUBMISSION_TOOLTIP~ 
(
	
	local fname = ~FNAME_AUTODESK_COM_3DSMAX_DEFECTSUBMIT~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_DEFECTSUBMISSION_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Feedback
buttontext:~HELP_WEB_FEEDBACK_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_FEEDBACK_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_FEEDBACK~
	local strMsgTitle = "3ds Max"	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_FEEDBACK_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Facebook
buttontext:~HELP_WEB_FACEBOOK_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_FACEBOOK_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_FACEBOOK~

	local strMsgTitle = "3ds Max"	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_FACEBOOK_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Area_Forums
buttontext:~HELP_WEB_AREA_FORUMS_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_AREA_FORUMS_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_AREA_FORUMS~

	local strMsgTitle = "3ds Max"	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_AREA_FORUMS_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Ideas
buttontext:~HELP_WEB_IDEAS_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_IDEAS_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_IDEAS~

	local strMsgTitle = "3ds Max"	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_IDEAS_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_3dsMax_Home
buttontext:~HELP_WEB_3DSMAX_HOME_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_3DSMAX_HOME_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_HOME~

	local strMsgTitle = "3ds Max"	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_3DSMAX_HOME_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Try_Other
buttontext:~HELP_WEB_TRY_OTHER_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_TRY_OTHER_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_TRY_OTHER~

	local strMsgTitle = "3ds Max"	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_TRY_OTHER_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Exchange_Apps 
buttontext:~HELP_WEB_EXCHANGE_APPS_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_EXCHANGE_APPS_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_EXCHANGE_APPS~

	local strMsgTitle = "3ds Max"	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_EXCHANGE_APPS_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Free_Learning_Resources
buttontext:~HELP_FREE_LEARNING_RES_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_FREE_LEARNING_RES_TOOLTIP~ 
(
	
	local fname = ~AUTODESK_COM_3DSMAX_FREE_LEARNING_RES~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_FREE_LEARNING_RES_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_FBX_Review
buttontext:~HELP_FBXREVIEW_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_FBXREVIEW_TOOLTIP~ 
(
	
	local fname = ~AUTODESK_COM_3DSMAX_FBXREVIEW~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_FBXREVIEW_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Pixlr
buttontext:~HELP_PIXLR_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_PIXLR_TOOLTIP~ 
(
	
	local fname = ~AUTODESK_COM_3DSMAX_PIXLR~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_PIXLR_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_123dapp
buttontext:~HELP_123DAPP_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_123DAPP_TOOLTIP~ 
(
	
	local fname = ~AUTODESK_COM_3DSMAX_123DAPP~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_123DAPP_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Character_Generator
buttontext:~HELP_CHARGEN_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_CHARGEN_TOOLTIP~ 
(
	
	local fname = ~AUTODESK_COM_3DSMAX_CHARGEN~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_CHARGEN_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Creative_Market
buttontext:~HELP_CREATIVE_MARKET_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_CREATIVE_MARKET_TOOLTIP~ 
(
	
	local fname = ~AUTODESK_COM_3DSMAX_CREATIVE_MARKET~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_CREATIVE_MARKET_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_1min_essentials
buttontext:~HELP_1MIN_ESSENTIALS_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_1MIN_ESSENTIALS_TOOLTIP~ 
(
	local fname = ~FNAME_AUTODESK_COM_1MIN_ESSENTIALS~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_1MIN_ESSENTIALS_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)
-- END OF FILE

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCKgdgTr2eFpDmtRHHmp0sKHRTyMaZ4sGh2
-- ugfOGNeryVaROHn5q09VwczwaA0CUL5xq2c7CVbObwFlPUHLQEe+tF7G18MwDDKF
-- TnXM9W6keegKXG+wSIEoFmxYaQJfZ4kxm37HA29tvnrpYyy2ssbSukZ5ExdOD48c
-- RYU7UCS6DGsB0fMBfK4T8xR/6Ww8NRpUAQzBOKbffB9bmSh7NcKy8Dz/CU1fbUmF
-- Q4X0arpmwuPpLoORxPk7mcDeLK5vQk971JCeCJWGRW7VPLdpTA/3ecLMDQdTBd8E
-- fB/Q8OaYF6iHKWkoFXHSEToEILEfQMom2r5fTE4XFDQD/Ro7bOCL
-- -----END-SIGNATURE-----