--
-- @file Macro_Hair.mcr
--
-- @author Gonzalo Rueda <grueda@animatedpixel.com>
--
-- $Started: 2004/08/02 $
-- $Date: 2006/08/10 03:27:27 $
-- $Revision: 1.1 $
--
-- @brief   These are the macro scripts declared by Hair.
--
-- Copyright Joe Alter, Inc. 2004 
--
-- This work may not be duplicated, in whole or part, without the express
-- written permission of Joe Alter, Inc.
--


macroScript Hair_AddMod 
            category:~HAIR_ADDMOD_HAIR_AND_FUR_CATEGORY~ 
            internalCategory:"Hair" 
            tooltip:~ADD_HAIR_MODIFIER_TOOLTIP~
            buttontext:~ADD_HAIR_MODIFIER_BUTTONTEXT~
(
   on execute do
   (
      if $ != undefined then
      (
         hair.addMod $
		   setCommandPanelTaskMode mode:#create
		   setCommandPanelTaskMode mode:#modify
		   completeRedraw()
      )
   )
)


macroScript Hair_AddEffect
            category:~HAIR_ADDEFFECT_HAIR_AND_FUR_CATEGORY~ 
            internalCategory:"Hair" 
            tooltip:~ADD_HAIR_EFFECT_TOOLTIP~
            buttontext:~ADD_HAIR_EFFECT_BUTTONTEXT~
(
   on execute do
   (
      hair.addEffect true
   )
)


macroScript Hair_Purge
            category:~HAIR_PURGE_HAIR_AND_FUR_CATEGORY~ 
            internalCategory:"Hair" 
            tooltip:~PURGE_TOOLTIP~
            buttontext:~PURGE_BUTTONTEXT~
(
   on execute do
   (
      hair.Purge()
   )
)


macroScript Hair_AddHairProperties
            category:~ADDHAIRPROPERTIES_HAIR_AND_FUR_CATEGORY~ 
            internalCategory:"Hair" 
            tooltip:~ADDHAIRPROPERTIES_TOOLTIP~
            buttontext:~ADDHAIRPROPERTIES_BUTTONTEXT~
(
   on execute do
   (
      if $ != undefined then
      (
         hair.AddHairProperties $
      )
   )
)


macroScript Hair_ConvertHairsToMesh
            category:~CONVERTHAIRSTOMESH_HAIR_AND_FUR_CATEGORY~ 
            internalCategory:"Hair" 
            tooltip:~CONVERTHAIRSTOMESH_TOOLTIP~
            buttontext:~CONVERTHAIRSTOMESH_BUTTONTEXT~
(
   on execute do
   (
      if $ != undefined then
      (
         for obj in $ do 
		 (
			--modifier = getActiveHairMod()

			currentModifier = undefined			
			if getCommandPanelTaskMode() == #modify then
			(
				modifier = modPanel.getCurrentObject()
				if modifier != undefined then
				(
					if isKindOf modifier HairMod == true then
					(
						currentModifier = modifier
					)		
				)	
			)

			if currentModifier != undefined then currentModifier.ConvertToMesh instance:obj
			break
		 )
      )
   )
)


macroScript Hair_ConvertHairsToSplines
            category:~CONVERTHAIRSTOSPLINES_CATEGORY~ 
            internalCategory:"Hair" 
            tooltip:~CONVERT_HAIRS_TO_SPLINES_TOOLTIP~
            buttontext:~CONVERTHAIRSTOSPLINES_BUTTONTEXT~
(
   on execute do
   (
      if $ != undefined then
      (
         for obj in $ do 
		 (
			--modifier = getActiveHairMod()
			
			currentModifier = undefined			
			if getCommandPanelTaskMode() == #modify then
			(
				modifier = modPanel.getCurrentObject()
				if modifier != undefined then
				(
					if isKindOf modifier HairMod == true then
					(
						currentModifier = modifier
					)		
				)	
			)
			
			if currentModifier != undefined then currentModifier.ConvertHairsToSplines instance:obj
			break
		 )
      )
   )
)

macroScript Hair_ConvertGuidesToSplines
            category:~CONVERTGUIDESTOSPLINES_CATEGORY~ 
            internalCategory:"Hair" 
            tooltip:~CONVERT_GUIDES_TO_SPLINES_TOOLTIP~
            buttontext:~CONVERTGUIDESTOSPLINES_BUTTONTEXT~
(
   on execute do
   (
      if $ != undefined then
      (
         for obj in $ do 
		 (
			--modifier = getActiveHairMod()
			
			currentModifier = undefined			
			if getCommandPanelTaskMode() == #modify then
			(
				modifier = modPanel.getCurrentObject()
				if modifier != undefined then
				(
					if isKindOf modifier HairMod == true then
					(
						currentModifier = modifier
					)		
				)	
			)
			
			if currentModifier != undefined then currentModifier.ConvertGuidesToSplines instance:obj
			break
		 )
      )
   )
)

macroScript Hair_CopyHairdo
            category:~HAIR_COPYHAIRDO_CATEGORY~ 
            internalCategory:"Hair" 
            tooltip:~COPY_HAIRDO_TOOLTIP~
            buttontext:~COPYHAIRDO_BUTTONTEXT~
(
   on execute do
   (
      if $ != undefined then
      (
         for obj in $ do 
		 (
			--modifier = getActiveHairMod()
			
			currentModifier = undefined			
			if getCommandPanelTaskMode() == #modify then
			(
				modifier = modPanel.getCurrentObject()
				if modifier != undefined then
				(
					if isKindOf modifier HairMod == true then
					(
						currentModifier = modifier
					)		
				)	
			)

			if currentModifier != undefined then currentModifier.CopyHairdo instance:obj
			break
		 )
      )
   )
)

macroScript Hair_PasteHairdo
            category:~PASTEHAIRDO_CATEGORY~ 
            internalCategory:"Hair" 
            tooltip:~PASTEHAIRDO_TOOLTIP~
            buttontext:~PASTEHAIRDO_BUTTONTEXT~
(
   on execute do
   (
      if $ != undefined then
      (
         for obj in $ do 
		 (
			--modifier = getActiveHairMod()
			
			currentModifier = undefined			
			if getCommandPanelTaskMode() == #modify then
			(
				modifier = modPanel.getCurrentObject()
				if modifier != undefined then
				(
					if isKindOf modifier HairMod == true then
					(
						currentModifier = modifier
					)		
				)	
			)

			if currentModifier != undefined then currentModifier.PasteHairdo instance:obj
			break
		 )
      )
   )
)

macroScript Hair_ReplaceRest
            category:~REPLACEREST_CATEGORY~ 
            internalCategory:"Hair" 
            tooltip:~REPLACEREST_TOOLTIP~
            buttontext:~REPLACEREST_BUTTONTEXT~
(
   on execute do
   (
      if $ != undefined then
      (
         for obj in $ do 
		 (
			--modifier = getActiveHairMod()
			
			currentModifier = undefined			
			if getCommandPanelTaskMode() == #modify then
			(
				modifier = modPanel.getCurrentObject()
				if modifier != undefined then
				(
					if isKindOf modifier HairMod == true then
					(
						currentModifier = modifier
					)		
				)	
			)
			
			if currentModifier != undefined then currentModifier.ResetRest instance:obj
			break
		 )
      )
   )
)

macroScript Hair_RegrowHair
            category:~REGROWHAIR_CATEGORY~ 
            internalCategory:"Hair" 
            tooltip:~REGROWHAIR_TOOLTIP~
            buttontext:~REGROWHAIR_BUTTONTEXT~
(
   on execute do
   (
      if $ != undefined then
      (
         for obj in $ do 
		 (
			--modifier = getActiveHairMod()
			
			currentModifier = undefined			
			if getCommandPanelTaskMode() == #modify then
			(
				modifier = modPanel.getCurrentObject()
				if modifier != undefined then
				(
					if isKindOf modifier HairMod == true then
					(
						currentModifier = modifier
					)		
				)	
			)
			
			if currentModifier != undefined then currentModifier.RegrowHair instance:obj
			break
		 )
      )
   )
)

macroScript Hair_ClearHairInstanceMesh
            category:~CLEARHAIRINSTANCEMESH_CATEGORY~ 
            internalCategory:"Hair" 
            tooltip:~CLEARHAIRINSTANCEMESH_TOOLTIP~
            buttontext:~CLEARHAIRINSTANCEMESH_BUTTONTEXT~
(
   on execute do
   (
      if $ != undefined then
      (
         for obj in $ do 
		 (
			--modifier = getActiveHairMod()

			currentModifier = undefined			
			if getCommandPanelTaskMode() == #modify then
			(
				modifier = modPanel.getCurrentObject()
				if modifier != undefined then
				(
					if isKindOf modifier HairMod == true then
					(
						currentModifier = modifier
					)		
				)	
			)

			if currentModifier != undefined then currentModifier.ClearInstance()
			break
		 )
      )
   )
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCgX1UG/QDKaXd5uGbCuOZ8r86GFRrQKdcd
-- lXMK2bDqAK0SNxHO3YSckCGW2WWYKRYkxR00z7Jbt2Xjuvyy/qP74yoECgPy2s9F
-- VvlVFz3i6IJWa9i1181NOg6g/Mtexhcl2PfYoXZuvzR6YoKgiM8gwFr/LFE1RCKX
-- 6QzZ5qxNu3ScOT05ykj9mcpV7qUEezstyEPbTjxESp7B06UqyRYVpyySvaTa2Vat
-- LK6dimvMUCenKLiw1KYWSbd0lS05uy7826r13IhbfTZ7ZVsx5iUF2+C+cvY5Yh7H
-- +Ct9Bu5eFnfZBuKYjGAFnaQsRnFNOisjwuquWX/wtgX2ZSMXvNIP
-- -----END-SIGNATURE-----