/*

Macro_Scripts File
Purposes:  
    
	define UI actions for the xView feature introduced in 3ds max 2010

Revision History
	July 2008: Pierre-Felix Breton
	created for 3ds MAX 2010
	July 2008: Michael Zyracki
	finished it

IDs for checkers.
Isolated Vertex 	1
Overlapping Faces 	2
Multiple Edges		3
Open Edges		4
Face Orientation	5
Missing UV Coordinates	6
Overlapping Vertices	7
T-Verts			8
Flipped UVW Faces	9
Overlapped UVW Faces	10

*/

--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
--***********************************************************************************************


--***********************************************************************************************
-- Macros to enable each checker, to be hooked in the CUi system
--***********************************************************************************************

MacroScript xView_Isolated_Vertex_Checker
            ButtonText:~XVIEW_ISOLATED_VERTEX_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_ISOLATED_VERTEX_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 1 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 1 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 1
					xViewChecker.On = True
				)
			)	
		Catch()	
	 
)--end MacroScript

MacroScript xView_Overlapping_Faces_Checker
            ButtonText:~XVIEW_OVERLAPPING_FACES_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_OVERLAPPING_FACES_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 2 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 2 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 2
					xViewChecker.On = True
				)
			)	
		Catch()	
	 
)--end MacroScript

MacroScript xView_Multiple_Edges_Checker
            ButtonText:~XVIEW_MULTIPLE_EDGES_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_MULTIPLE_EDGES_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 3 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 3 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 3
					xViewChecker.On = True
				)
			)	
		Catch()	
	 
)--end MacroScript

MacroScript xView_Open_Edges_Checker
            ButtonText:~XVIEW_OPEN_EDGES_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_OPEN_EDGES_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 4 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 4 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 4
					xViewChecker.On = True
				)
			)	
		Catch()	
	
)--end MacroScript

MacroScript xView_Face_Orientation_Checker
            ButtonText:~XVIEW_FACE_ORIENTATION_CHECKER_BUTTONTEXT~
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_FACE_ORIENTATION_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 5 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 5 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 5
					xViewChecker.On = True
				)
			)	
		Catch()	
	
)--end MacroScript

MacroScript xView_Missing_UV_Coordinates_Checker
            ButtonText:~XVIEW_MISSING_UV_COORDINATES_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_MISSING_UV_COORDINATES_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 6 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 6 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 6
					xViewChecker.On = True
				)
			)	
		Catch()	
	
)--end MacroScript



MacroScript xView_Overlapping_Vertices_Checker
            ButtonText:~XVIEW_OVERLAPPING_VERTICES_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_OVERLAPPING_VERTICES_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 7 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 7 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 7
					xViewChecker.On = True
				)
			)	
		Catch()	
	 
)--end MacroScript

MacroScript xView_TVerts_Checker
            ButtonText:~XVIEW_TVERTS_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_TVERTS_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 8 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 8 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 8
					xViewChecker.On = True
				)
			)	
		Catch()	
	 
)--end MacroScript

MacroScript xView_Flipped_UVW_Faces_Checker
            ButtonText:~XVIEW_FLIPPED_UVW_FACES_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_FLIPPED_UVW_FACES_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 9 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 9 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 9
					xViewChecker.On = True
				)
			)	
		Catch()	
	 
)--end MacroScript

MacroScript xView_Overlapped_UVW_Faces_Checker
            ButtonText:~XVIEW_OVERLAPPED_UVW_FACES_CHECKER_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_OVERLAPPED_UVW_FACES_CHECKER_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.getActiveCheckerID() == 10 and xViewChecker.On == True) Catch()
	On Execute Do 
		Try (
				if (xViewChecker.getActiveCheckerID() == 10 and xViewChecker.On == True)
				then
					xViewChecker.On = False
				else
				(	
					xViewChecker.setActiveCheckerID 10
					xViewChecker.On = True
				)
			)	
		Catch()	
	 
)--end MacroScript

--***********************************************************************************************
-- Macros to cycle through the list of checkers, useful when assigned to a hotkey
--***********************************************************************************************


MacroScript xView_Cycle_Forward
            ButtonText:~XVIEW_CYCLE_FORWARD_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_CYCLE_FORWARD_TOOLTIP~ 
(
	
	On Execute Do 
		Try (
				if (xViewChecker.ActiveIndex < xViewChecker.getNumCheckers()) 
				then xViewChecker.ActiveIndex = xViewChecker.ActiveIndex + 1
				else xViewChecker.ActiveIndex = 1
				xViewChecker.On = true
			)	
		Catch()	
	
)--end MacroScript



MacroScript xView_Cycle_Backward
            ButtonText:~XVIEW_CYCLE_BACKWARD_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_CYCLE_BACKWARD_TOOLTIP~ 
(
	
	On Execute Do 
		Try (
				if (xViewChecker.ActiveIndex > 1) 
				then xViewChecker.ActiveIndex = xViewChecker.ActiveIndex - 1
				else xViewChecker.ActiveIndex = xViewChecker.getNumCheckers()
				xViewChecker.On = true
			)	
		Catch()	
	
)--end MacroScript

--***********************************************************************************************
-- Misc Macros to perform different checker functions
--***********************************************************************************************

MacroScript xView_Select_Results
            ButtonText:~XVIEW_SELECT_RESULTS_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_SELECT_RESULTS_TOOLTIP~ 
(
	
	On Execute Do 
		Try (
				xViewChecker.selectResults sliderTime
			)	
		Catch()	
	 
)--end MacroScript


MacroScript xView_See_Through
            ButtonText:~XVIEW_SEE_THROUGH_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_SEE_THROUGH_TOOLTIP~ 
(
	
	on ischecked Return Try(xViewChecker.seeThrough) Catch()
	On Execute Do 
		Try (
			if (xViewChecker.seeThrough==true) 
				then xViewChecker.seeThrough = false
				else xViewChecker.seeThrough = true
			)	
		Catch()	
	 
)--end MacroScript


MacroScript xView_Auto_Update
            ButtonText:~XVIEW_AUTO_UPDATE_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_AUTO_UPDATE_TOOLTIP~ 
(
	on ischecked Return Try(xViewChecker.autoUpdate) Catch()
	On Execute Do 
		Try (
			if (xViewChecker.autoUpdate==true) 
				then xViewChecker.autoupdate = false
				else xViewChecker.autoupdate = true
			)	
		Catch()	
	 
)--end MacroScript

MacroScript xView_Display_On_Top
            ButtonText:~XVIEW_DISPLAY_ON_TOP_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_DISPLAY_ON_TOP_TOOLTIP~ 
(
	on ischecked  Return Try(xViewChecker.displayTextUpTop) Catch()
	On Execute Do 
		Try (

			if (xViewChecker.displayTextUpTop==true) 
				then xViewChecker.displayTextUpTop = false
				else xViewChecker.displayTextUpTop= true
			
			)	
		Catch()	
	 
)--end MacroScript


MacroScript xView_Configure
            ButtonText:~XVIEW_CONFIGURE_BUTTONTEXT~ 
            category:"xView"
            internalCategory:"xView"
            Tooltip:~XVIEW_CONFIGURE_TOOLTIP~ 
(
	on isenabled Return Try(xViewChecker.doesCheckerHavePropDlg xViewChecker.activeIndex == True) Catch()

	On Execute Do 
		Try (
				xViewChecker.showCheckerPropDlg xViewChecker.activeIndex
			)	
		Catch()	
	 
)--end MacroScript



-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQA1CVsavzA/LmL5luoEcxd3azSsccary0Ip
-- /uHAwc82dMpkNVOrTaymntK2XAI6RnQFzmO+WFal/bALpFl4BR+VBQHO3opO1vYw
-- xUD7x8HJ32WBrGZ/kCUKYosRQeY5yb1mc06F5arfAmPkma67ldjk5TmvFS9HXgjJ
-- /qLzpqYG92vcCMJNVHnHSAmGwrEOC9jaUM0RGq3MUsnLrsKRwJQ19W935jSsjv6m
-- uM3FSW5B5NI/H4roS5wnPHlIMUTYjI2M5cb+EBqbxTm2Otfw+2HTBVmtlGAO7WdK
-- Ae11CLLZ1XbTvFHFCHj01LkuTG3MM4H//i/8x/F8QY+goa94nIKr
-- -----END-SIGNATURE-----