--//////////////////////////////////////////////////////////////////////////////////////////////////////
/*

*/
--//////////////////////////////////////////////////////////////////////////////////////////////////////
macroScript CreateDefaultProject
	category:~CREATE_DEFAULT_PROJECT_CATEGORY~
	internalCategory:"Tools" 
	tooltip:~CREATE_DEFAULT_PROJECT_TOOLTIP~
	ButtonText:~CREATE_DEFAULT_PROJECT_BUTTONTEXT~
	icon:#("SetProjectFolder", 1)
(
	On Execute Do	
	(
		selectedFolderAbsolutePath = getSavePath initialDir:(pathconfig.getCurrentProjectFolder())
		
		--user selected a valid folder
		if ((selectedFolderAbsolutePath != undefined) and (selectedFolderAbsolutePath != "")) then  
		(
			if(pathconfig.IsProjectFolder(selectedFolderAbsolutePath) )then 
			(
				messagebox (~FOLDER_CONTAINS_EXISTING_PROJECT_CAPTION~) title:~CREATE_DEFAULT_PROJECT_TITLE~ beep:false
			)
			else
			(		
				-- backup the current config paths settings 
				pathconfig.SaveTo(pathconfig.getCurrentProjectFolderPath())
				
				pathconfig.setCurrentProjectFolder selectedFolderAbsolutePath
				
				setdir #autoback ".\\autoback"
				setdir #scene ".\\scenes"
				setdir #import ".\\import"
				setdir #export ".\\export"
				setdir #expression ".\\express"
				setdir #preview ".\\previews"
				setdir #image ".\\sceneassets\\images"
				setdir #sound ".\\sceneassets\\sounds"
				setdir #vpost ".\\vpost"
				setdir #matlib ".\\materiallibraries"
				setdir #renderassets ".\\sceneassets\\renderassets"
				setdir #renderoutput ".\\renderoutput"
				setdir #renderPresets ".\\renderPresets"
				setdir #animations ".\\sceneassets\\animations"
				setdir #archives ".\\archives"
				setdir #photometric ".\\sceneassets\\photometric"
				setdir #downloads ".\\downloads"
				setdir #proxies ".\\proxies"
				setdir #maxstart ".\\scenes"
				setdir #cfd ".\\sceneassets\\CFD"
				
				-- create project folder hierarchy
				dirCount = pathconfig.getProjectSubDirectoryCount()
				for i = 1 to dirCount do
				(
					dir = pathconfig.getProjectSubDirectory i
					dir = pathconfig.convertPathToAbsolute dir
					makedir dir all:true
				)
				
				--Add MapPaths
				mapPathsCount = mapPaths.count()
				for i = 1 to mapPathsCount do
				(
					mapPaths.delete 1
				)
				
				mapsPath = getdir #maxroot
				mapPaths.add(pathconfig.appendpath mapsPath "\\Maps")
				mapPaths.add(pathconfig.appendpath mapsPath "\\Maps\\glare")
				mapPaths.add(pathconfig.appendpath mapsPath "\\Maps\\adskMtl")
				mapPaths.add(pathconfig.appendpath mapsPath "\\Maps\\Noise")
				mapPaths.add(pathconfig.appendpath mapsPath "\\Maps\\Substance\\noises")
				mapPaths.add(pathconfig.appendpath mapsPath "\\Maps\\Substance\\textures")
				mapPaths.add(pathconfig.appendpath mapsPath "\\Maps\\mental_mill")
				mapPaths.add(pathconfig.appendpath mapsPath "\\Maps\\Particle Flow Presets")
				mapPaths.add(pathconfig.appendpath mapsPath "\\Maps\\fx")
				
				downloadsPath = getdir #downloads
				downloadsPath = pathconfig.convertPathToRelativeTo downloadsPath selectedFolderAbsolutePath
				mapPaths.add downloadsPath
				
				-- add XRefs Paths
				xrefPathsCount = xrefPaths.count()
				for i = 1 to xrefPathsCount do
				(
					xrefPaths.delete 1
				)
				
				scenesPath = getdir #scene
				scenesPath = pathconfig.convertPathToRelativeTo scenesPath selectedFolderAbsolutePath
				xrefPaths.add scenesPath
					
				-- save new config paths settings in <rootProjectFolderName>.mxp
				mxpFileName = pathconfig.stripPathToLeaf(selectedFolderAbsolutePath) + ".mxp"
				pathconfig.SaveTo(pathconfig.appendpath selectedFolderAbsolutePath mxpFileName)	
			)	
		)
	)
)
	
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCahbTqDa77IhT4YakJxUHb65Qr8vuZgr1O
-- b0xlQByn+enlKFtQ4HLfXlvx/LZlSV7JS+XhCtACcPPM+lNuSE/qKWPAXv3Fon/l
-- Em8lC1uE4Aw8kLIdLY4yYrGAi6jAuDrNc+6DMqCmUNiNBsBNEXovykO+bnsbXEAc
-- x5U4oH7+lNcLMmJQQennJ+IcHWxlqZTSxGDkCjMuwJ0k5IQ03Yh/GxmTgv0baJh7
-- NgEtDI3JWruvs7UgcKQKBQy07tJRzrboHMEWRRZXPx1aoDH7ON2u5UYkz6AE+rgS
-- A1wRmbrH94Q+9dN7KfLYzLpLzDgTSn+UO+QkZGSOywXN4DODhcb4
-- -----END-SIGNATURE-----