/*

Combustion Output MacroScript File
Created:		Sept 6 2000
Author:		Fred Moreau

Revision History:
	Yann Bertaud
		changed the method for which the render element filename was retrieved. Using the new GetRenderElementFilename method. 
		re.bitmap.filename was replaced by refilename which is defined by eman.GetRenderElementfilename (e)
		
	11 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macroscript file can be shared with all Discreet products
	

*/

Macroscript CombustionOutput 
category:~COMBUSTIONOUTPUT_CATEGORY~ 
internalCategory:"File"
ButtonText:~COMBUSTIONOUTPUT_BUTTONTEXT~
tooltip:~COMBUSTIONOUTPUT_TOOLTIP~
icon:#("CWS_Output",2)
silentErrors:true
(
	SetSilentMode true											-- Set Silent Mode for BitMap Loading
	eman = maxOps.GetCurRenderElementMgr()						-- Get Current Render Elements Manager
	if (eman.NumRenderElements()) > 0 and (eman.GetElementsActive()) == true and eman.GetCombustionOutputPath() != "" then
	(
		try
		(
			re_array = #()										-- Init the RenderElements Array
			for e = 0 to (eman.NumRenderElements() - 1) do		-- For all RenderElements in REManager
			(
				re = eman.GetRenderElement e					-- Get the Element
				refilename = eman.GetRenderElementfilename (e)	-- added for 3ds max 5, use new GetRenderElementFilename method to get render element filename.
				try (re.enabled ; OkToGo = True) catch (OkToGo = False) -- Is Element Plug-In Missing
				if OkToGo then							-- If Element is not Standin
				(
					if re.enabled == true and refilename != undefined then	-- If Element Enabled
					(
						if not IsCwsImgType refilename then	-- Check combustion ImageType Compliance
						(
							Print ~OK~
							cwsMessage = ~CWSMESSAGE_WARNING_IMAGE_TYPE_NOT_SUPPORTED_IN_COMBUSTION~ +
							(re.elementName + ~ELEMENT_IS_OUTPUTTING_TO~ + (getfilenameType refilename) + ~FILES~)
							cwsWarn cwsMessage
						)
						else
						(
							if ((KindOfRenderElement re) == #Diffuse or (KindOfRenderElement re) == #Shadow or (KindOfRenderElement re) == #Atmosphere) and (findItem #(".tga", ".tif", ".rla", ".rpf", ".png") (getfilenameType refilename) == 0) then
							(
								cwsMessage = ~CWSMESSAGE_WARNING_ELEMENT_REQUIRES_ALPHA~ +
								re.elementName + ~ELEMENT_NAME_ELEMENT_IS_OUTPUTTING_TO~ + (getfilenameType refilename) + ~ELEMENT_NAME_FILES~ +
								~IT_IS_RECOMMENDED_TO_OUTPUT_DIFFUSE_SHADOWS_AND_ATMOSPHERE_ELEMENTS~
								cwsWarn cwsMessage
							)
							cwselement = relement name:re.elementName kind:(KindOfRenderElement re) file:refilename transferMode:1 Visibility:Off
							append re_array cwselement				-- Add RenderElement to the Process List
						)
					)-- end If Enabled
					else
					(
						cwsMessage = ~WARNING~ + re.elementName + ~ELEMENT_HAS_NO_BITMAP_OR_IS_DISABLED~
						cwsWarn cwsMessage
					)
				)-- end If not Standin
				else
				(
					cwsMessage = ~CWSMESSAGE_WARNING_ELEMENT_IS_USING_MISSING_DLL~
					cwsWarn cwsMessage
				)
			)-- end for loop
			if re_array.count != 0 then
			(
				RElements2cws re_array (eman.GetCombustionOutputPath())
				print ~PRINT_RENDER_ELEMENTS_HAVE_BEEN_OUTPUTTED_TO_COMBUSTION_SUCCESSFULLY~
			)-- end if
			Else
			(
				cwsMessage = ~CWSMESSAGE_NO_RENDER_ELEMENTS_TO_OUTPUT~
				cwsWarn cwsMessage
			)
		)-- end try
		catch
		(
			try (close (eman.GetCombustionOutputPath())) catch()
			cwsMessage = ~CWSMESSAGE_ERRORS_OCCURED_WHEN_OUTPUTTING_TO_COMBUSTION_FILE~
			cwsWarn cwsMessage
		)-- end catch
	)
	else
	(
			cwsMessage = ~WARNING_COMBUSTION_WORKSPACE_FILE_NOT_SET~ +
~OR_NO_RENDER_ELEMENTS_TO_OUTPUT~
			cwsWarn cwsMessage
	)
	SetSilentMode false -- Reset Silent Mode Off for BitMap Loading
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQA6Z0htAkTeOMULfBXlpjc62Ca4MUXN/8wC
-- 0ZuMdH7ZePZ8BwYeSt/bb/0E3CEr2crycBYAtkg7JJr4A3DKYxv94WqPQZJfcIVl
-- VHJriezGdkqQFp4GCXFB8PWQ6RfXQLLo4NT+14emdEuJayqITjzxRkHYRnxcJVmM
-- pGI7Q+dfPm5coLP9LcGwZUmzqyXuJ6CCsajluIQQq292HGFMhBewvFjfvark+xF8
-- HyjK4hjWzsP5q4yIT/3NsAr/GXMaenb1B6q3MsIOq7kD3ONz2mHWeNcB+3611FXT
-- VGjm5y6H2b/9BqDCzlUIuJW6Vv0Dx/EVNY8DEMpfXKcMepJcUWYL
-- -----END-SIGNATURE-----