-------------------------------------------------------------------------------
-- Macros_CAT.mcr
--- CAT macros, copied from CATScripts
--
-- History:
--  05.20.09  -  Susan Amkraut
--
-- Copyright 2009, Discreet
-------------------------------------------------------------------------------

--- Apply Max IK ---
macroScript catApplyMaxIK
		category:"CAT" 
		internalcategory:"CAT" 
		tooltip:~CATAPPLYMAXIK_TOOLTIP~ 
		buttontext:~CATAPPLYMAXIK_BUTTONTEXT~ 
		Icon:#("CAT",1)
(
   on execute do rApplyIKChain.openDialog()
)



--- Capture Animation ---

macroScript catCaptureAnimation 
		  category:"CAT" 
		  internalcategory:"CAT" 
		  tooltip:~CATCAPTUREANIMATION_TOOLTIP~ 
		  buttontext:~CATCAPTUREANIMATION_BUTTONTEXT~ 
		  Icon:#("CAT",1)
(
   on execute do rCaptureAnim.openDialog();
)

macroScript catMapBone
		  category:"CAT" 
		  internalcategory:"CAT" 
		  tooltip:~CATMAPBONE_TOOLTIP~ 
		  buttontext:~CATMAPBONE_BUTTONTEXT~ 
		  Icon:#("CAT",6)
(
	on execute do (
		local src = pickObject prompt:~PICKOBJECT_PROMPT_CAPTION~
		if src != undefined then(
			rCATRigMapping.MapNodes src selection[1] undefined;
		)
	)
	on isVisible do 
	(
		local result = false
		if (selection.count != 1) then
			result = false
		else if (rCaptureAnim.open == false) then 
			result = false
		else
			result = CATParentSetupMode();
		
		result
	)
)



--- File IO: BVH, HTR ---
macroScript catImportBVH
		  category:"CAT" 
		  internalcategory:"CAT" 
		  tooltip:~CATIMPORTBVH_TOOLTIP~ 
		  buttontext:~CATIMPORTBVH_BUTTONTEXT~ 
		  Icon:#("CAT",6)
(
	on execute do (	
		rImportBVH.openDialog catparent:(GetSelectedCATParent())
	)
	on isVisible do 
	(
		SelectionHasCATParent()
	)
)

macroScript catImportHTR
		  category:"CAT" 
		  internalcategory:"CAT" 
		  tooltip:~CATIMPORTHTR_TOOLTIP~ 
		  buttontext:~CATIMPORTHTR_BUTTONTEXT~ 
		  Icon:#("CAT",6)
(
	on execute do (	
		rImportHTR.openDialog catparent:(GetSelectedCATParent())
	)
	on isVisible do 
	(
		SelectionHasCATParent()
	)
)

macroScript catImportBIP
		  category:"CAT" 
		  internalcategory:"CAT" 
		  tooltip:~CATIMPORTBIP_TOOLTIP~ 
		  buttontext:~CATIMPORTBIP_BUTTONTEXT~ 
		  Icon:#("CAT",6)
(
	on execute do (	
		rImportBIP.openDialog catparentnode:(GetSelectedCATParent())
	)
	on isVisible do 
	(
		SelectionHasCATParent()
	)
)


--- Rigging ---
macroScript catAddExtraBone
		  category:"CAT" 
		  internalcategory:"CAT" 
		  tooltip:~CATADDEXTRABONE_TOOLTIP~ 
		  buttontext:~CATADDEXTRABONE_BUTTONTEXT~ 
		  Icon:#("CAT",6)
(
	on execute do (
		local selSubAnim = GetSelectedSubAnim 3
		if (selSubAnim != undefined) then
		(
			local extrabone = selSubAnim.AddArbBone()
			select extrabone.node
		)
	)
	on isVisible do 
	(
		CATParentSetupMode()
	)
)

macroScript catAddExtraController
		  category:"CAT" 
		  internalcategory:"CAT" 
		  tooltip:~CATADDEXTRACONTROLLER_TOOLTIP~ 
		  buttontext:~CATADDEXTRACONTROLLER_BUTTONTEXT~ 
		  Icon:#("CAT",6)
(
	on execute do
	(
		local tvpSetFocus = 0
		tvpSetFocus = bit.set tvpSetFocus 27 true -- set focus to first selected node found
		local tvp = trackview.pickTrackDlg  IsFloatController options:tvpSetFocus
		if tvp != undefined then
		(
			local val = tvp.anim.value
			local lf = selection[1][3].CreateLayerFloat()
			-- make sure the new controller defaults to the original value
			lf.SetupVal = val
			lf.value = val
			tvp.client[tvp.subNum].controller = lf
		)
	)
	on isVisible do 
	(
		CATParentSetupMode()
	)
)





macroScript catAddArm
		  category:"CAT" 
		  internalcategory:"CAT" 
		  tooltip:~CATADDARM_TOOLTIP~ 
		  buttontext:~CATADDARM_BUTTONTEXT~ 
		  Icon:#("CAT",6)
(
	on execute do (	
		selection[1][3].AddArm()
	)
	on isVisible do 
	(
		(IsSelectionSubAnimClassOf HubTrans) and CATParentSetupMode()
	)
)

macroScript catAddLeg
		  category:"CAT" 
		  internalcategory:"CAT" 
		  tooltip:~CATADDLEG_TOOLTIP~ 
		  buttontext:~CATADDLEG_BUTTONTEXT~ 
		  Icon:#("CAT",6)
(
	on execute do (
		selection[1][3].AddLeg()
	)
	on isVisible do 
	(
		(IsSelectionSubAnimClassOf HubTrans) and CATParentSetupMode()
	)
)

macroScript catAddSpine
		  category:"CAT" 
		  internalcategory:"CAT" 
		  tooltip:~CATADDSPINE_TOOLTIP~ 
		  buttontext:~CATADDSPINE_BUTTONTEXT~ 
		  Icon:#("CAT",6)
(
	on execute do (	
		selection[1][3].AddSpine()
	)
	on isVisible do 
	(
		(IsSelectionSubAnimClassOf HubTrans) and CATParentSetupMode()
	)
)

macroScript catAddTail
		  category:"CAT" 
		  internalcategory:"CAT" 
		  tooltip:~CATADDTAIL_TOOLTIP~ 
		  buttontext:~CATADDTAIL_BUTTONTEXT~ 
		  Icon:#("CAT",6)
(
	on execute do (
		selection[1][3].AddTail()
	)
	on isVisible do 
	(
		(IsSelectionSubAnimClassOf HubTrans) and CATParentSetupMode()
	)
)



macroScript catAddGizmo
		  category:"CAT" 
		  internalcategory:"CAT" 
		  tooltip:~CATADDGIZMO_TOOLTIP~ 
		  buttontext:~CATADDGIZMO_BUTTONTEXT~ 
		  Icon:#("CAT",6)
(
	on execute do (	
		rGizmos.openDialog();
	)
	on isVisible do 
	(
		CATParentSetupMode()
	)
)


--- Collapse Layers ---

macroScript catCollapseLayersMacro
		  category:"CAT" 
		  internalcategory:"CAT" 
		  tooltip:~CATCOLLAPSELAYERSMACRO_TOOLTIP~ 
		  buttontext:~CATCOLLAPSELAYERSMACRO_BUTTONTEXT~ 
		  Icon:#("CAT",6)
(
	on execute do
	(
		if selection.count == 1 then
		(
			rCollapseLayers.openDialog (GetSelectedCATParent()) 
			SetDialogPos rCollapseLayers mouse.pos
		)
	)
	
	on isVisible do 
	(
		SelectionHasCATParent()
	)
)


--- Pin Bone ---

macroScript catPinBone
		  category:"CAT" 
		  internalcategory:"CAT" 
		  tooltip:~CATPINBONE_TOOLTIP~ 
		  buttontext:~CATPINBONE_BUTTONTEXT~ 
		  Icon:#("CAT",6)
(
	on execute do
	(
		if ((IsSelectionSubAnimClassOf HubTrans) and not CATParentSetupMode()) then
		(
			local selectedSubAnim = GetSelectedSubAnim 3
			selectedSubAnim.pinhub = not selectedSubAnim.pinhub
		)
	)
	on isVisible do 
	(
		(IsSelectionSubAnimClassOf HubTrans) and not CATParentSetupMode()
	)
	on isChecked do
	(
		local result = false
		if ((IsSelectionSubAnimClassOf HubTrans) and not CATParentSetupMode()) then
		(
			local selectedSubAnim = GetSelectedSubAnim 3
			if (selectedSubAnim != undefined) then
			(
				result = selectedSubAnim.controller.pinhub
			)
		)
		result
	)
)



--- Pose Mixer ---

macroScript catPoseMixer
		  category:"CAT" 
		  internalcategory:"CAT" 
		  tooltip:~CATPOSEMIXER_TOOLTIP~ 
		  buttontext:~CATPOSEMIXER_BUTTONTEXT~ 
		  Icon:#("CAT",1)
(
   on execute do rPoseMixer.OpenDialog()
)



--- Reset XForms ---

macroScript catResetTransforms
		  category:"CAT" 
		  internalcategory:"CAT" 
		  tooltip:~CATRESETTRANSFORMS_TOOLTIP~ 
		  buttontext:~CATRESETTRANSFORMS_BUTTONTEXT~ 
		  Icon:#("CAT",6)
(
	on execute do
	(
		for i in selection do(
			if (getinterface i[3] "CATControlInterface") != undefined then 
				i[3].ResetTransforms()
		)
	)
	
	on isVisible do 
	(
		DoesSelectedContainInterface "CATControlInterface"
	)
)

macroScript catSetPosetoActiveLayer
		  category:"CAT" 
		  internalcategory:"CAT" 
		  tooltip:~CATSETPOSETOACTIVELAYER_TOOLTIP~ 
		  buttontext:~CATSETPOSETOACTIVELAYER_BUTTONTEXT~ 
		  Icon:#("CAT",6)
(
	on execute do (	
		for i in selection do(
			if (getinterface i[3] "CATControlInterface") != undefined then 
				i[3].CollapsePoseToCurLayer()
		)
	)
	on isVisible do 
	(
		DoesSelectedContainInterface "CATControlInterface"
	)
)

--- Save/Load Clips/Poses ---

macroScript catSaveAnim
		  category:"CAT" 
		  internalcategory:"CAT" 
		  tooltip:~CATSAVEANIM_TOOLTIP~ 
		  buttontext:~CATSAVEANIM_BUTTONTEXT~ 
		  Icon:#("CAT",6)
(
	on execute do
	(	
		if selection.count == 1 then
		(
			rSaveFile.openDialog selection[1] "Animation" ".clp";
		)
	)
	
	on isVisible do 
	(
		local result = false
		if selection.count == 1 then
		(
			result = true
			local aParent = GetCATParent selection[1];
			
			if aParent == undefined then
				result = false;
			else if aParent.NumLayers == 0 then
				result = false;
			else if aParent.selectedlayer < 1 then
				result = false;
		)
		result;
	)
)


macroScript catLoadAnim
		  category:"CAT" 
		  internalcategory:"CAT" 
		  tooltip:~CATLOADANIM_TOOLTIP~ 
		  buttontext:~CATLOADANIM_BUTTONTEXT~ 
		  Icon:#("CAT",6)
(
	on execute do
	(
		if selection.count == 1 then 
		(
			rLoadFile.openDialog selection[1] "Animation" ".clp";
		)
	)
	on isVisible do 
	(
		local result = false
		if selection.count == 1 then
		(
			result = true
			local aParent = GetCATParent selection[1];
			if aParent==undefined then
				result = false
			else if aParent.catmode == 0 then
				result = false
			else if aParent.NumLayers == 0 then
				result = false
			else if aParent.selectedlayer < 1 then
				result = false
			else if aParent.layers.controller[aParent.selectedlayer].LayerType =="CATMotion" then
				result = false
		)
		result
	)
)


macroScript catSavePose
		  category:"CAT" 
		  internalcategory:"CAT" 
		  tooltip:~CATSAVEPOSE_TOOLTIP~ 
		  buttontext:~CATSAVEPOSE_BUTTONTEXT~ 
		  Icon:#("CAT",6)
(
	on execute do
	(
		if selection.count == 1 then 
		(
			rSaveFile.openDialog selection[1] "Pose" ".pse";
		)
	)
	on isVisible do 
	(
		local result = false
		if selection.count == 1 then
		(
			result = true
			local aParent = GetCATParent selection[1];
			if aParent == undefined then
				result = false
			else if aParent.catmode == 0 then
				result = false
		)
		result;
	)
)


macroScript catLoadPose
		  category:"CAT" 
		  internalcategory:"CAT" 
		  tooltip:~CATLOADPOSE_TOOLTIP~ 
		  buttontext:~CATLOADPOSE_BUTTONTEXT~ 
		  Icon:#("CAT",6)
(
	on execute do
	(
		if selection.count == 1 then 
		(
			rLoadFile.openDialog selection[1] "Pose" ".pse";
		)
	)
	on isVisible do 
	(
		local result = false
		if selection.count == 1 then
		(
			result = true
			local aParent = GetCATParent selection[1];
			if aParent == undefined then
				result = false
			else if aParent.catmode == 0 then
				result = false
			else if aParent.selectedlayer < 1 then
				result = false
			else if aParent.layers.controller[aParent.selectedlayer].LayerType =="CATMotion" then 
				result = false;
		)
		result;
	)
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBkMVwuDcZnz9/7YN6fstOXmRbHw6a2tmug
-- 5R7m91gz3VconAbtrk843eoAZ9O2Dq3EtGDnPvfktpjwZoCE2nRKJPajkN5T2jPY
-- glqxZPPJnBSUenddGaxtDiQyxRQFG/Gf6tU4WvXCXbD41ujZMyuNeSIwbYhUniou
-- b+gzRRGWl17VnBcOWAzwG6abUAoMcz5XzAWOVd4jIiCFnsnGQ5s3FcA/DJ+eQuhI
-- ibfYVm3xSEqai9EtlEWM4j5hcNuRg8pTsRR8sbByp6pN7FVNZo2XS68mYGU50NJO
-- q2LSQsEmBXGaiWgn9Kh22PKfI8tOLfuUhTjhEQ7W+nX26K565Voo
-- -----END-SIGNATURE-----