/*
 
***************************************************************************
Macro_Scripts File
Author:   Adam Felt
Macro_Scripts that implement some animation specific methods

Revision History
    May 26, 2004 - Adam Felt - Created
    December 14, 2004 - Nicolas Lonard - added ToggleLimits
	
-- MODIFY THIS AT YOUR OWN RISK
***************************************************************************

*/

macroScript DeleteSelectedAnimation
buttontext:~BUTTONTEXT_CAPTION~
category:~CATEGORY_ANIMATION_TOOLS~ 
internalCategory:"Animation Tools" 
tooltip:~DEL_SELECTED_ANIM_TOOLTIP~ 
(
	On isEnabled Return 
	(
		$selection.count != 0 
	)
	
	
	On Execute Do
	(
		maxOps.deleteSelectedAnimation()
	)
)

macroScript OpenReactionManager
	buttontext:~BUTTONTEXT_REACTION_MANAGER~
	category:~OPENREACTIONMANAGER_CATEGORY_ANIM_TOOLS~
	internalCategory:"Animation Tools" 
	toolTip:~OPENREACTIONMANAGER_TOOLTIP~
(
	reactionMgr.openEditor()
)

macroScript OpenAnimationLayers
	buttontext:~BUTTONTEXT_ANIM_LAYERS~
	category:~OPENANIMATIONLAYERS_ANIM_TOOLS~
	internalCategory:"Animation Tools" 
	toolTip:~OPENANIMATIONLAYERS_TOOLTIP~
(
	animLayerManager.showAnimLayersManagerToolbar true	
)

macroScript ToggleLimits
	buttontext:~BUTTONTEXT_TOGGLE_LIMITS~
	category:~TOGGLELIMITS_ANIM_TOOLS~
	internalCategory:"Animation Tools" 
	toolTip:~TOGGLE_LIMITS_TOOLTIP~
(
	Fn toggleAnimLimits anim &limitTab &toggleValue =
	(
		local ILimitControl
		if anim != undefined do
		(
			if (ILimitControl = getInterface anim #limits) != undefined do		
			(
				if toggleValue and anim.IsEnabled() do
				(
					toggleValue = false
				)
				append limitTab anim 
			)
			
			for i = 1 to anim.numsubs do
			(
				toggleAnimLimits (getSubAnim anim i) &limitTab &toggleValue
			) 
		)
	)

	On isEnabled Return 
	(
		$selection.count != 0 
	)
	
	On Execute Do
	(
		local limitTab = #()
		local toggleValue = true
		for s in selection do
		(
			toggleAnimLimits s &limitTab &toggleValue
		)
		for limit in limitTab do 
		(
			limit.SetEnabled toggleValue
		)
	)
)

macroScript TrajectoryToggle
buttontext:~BUTTONTEXT_TRAJECTORYTOGGLE~
category:~CATEGORY_TRAJECTORYTOGGLE~ 
internalCategory:"Animation Tools" 
tooltip:~TRAJECTORYTOGGLE_TOOLTIP~ 
(
	on isChecked Return
	(
		if(maxOps.trajectoryMode == true) then
			return true
		return false
	)
	On isEnabled Return 
	(
		$selection.count != 0 
	)
	On Execute Do
	(
		if(maxOps.trajectoryMode == true) then
			maxOps.trajectoryMode = false
		else
			maxOps.trajectoryMode = true
	)
)


macroScript TrajectoryKeyModeToggle
buttontext:~BUTTONTTEXT_TRAJECTORYKEYMODETOGGLE~
category:~CATEGORY_TRAJECTORYKEYMODETOGGLE~ 
internalCategory:"Animation Tools" 
tooltip:~TRAJECTORYKEYMODETOGGLE_TOOLTIP~ 
(
	On isEnabled Return 
	(
		$selection.count != 0 
	)
		
	On Execute Do
	(
		if(maxOps.trajectoryKeySubMode == true) then
			maxOps.trajectoryKeySubMode = false
		else
			maxOps.trajectoryKeySubMode = true
	)
)

macroScript TrajectoryAddKeyModeToggle
buttontext:~BUTTONTTEXT_TRAJECTORYADDKEYMODETOGGLE~
category:~TRAJECTORYADDKEYMODETOGGLE_ANIM_TOOLS_CATEGORY~ 
internalCategory:"Animation Tools" 
tooltip:~TRAJECTORYADDKEYMODETOGGLE_TOOLTIP~ 
(
	On isEnabled Return 
	(
		$selection.count != 0 
	)
	
	
	On Execute Do
	(
		if(maxOps.trajectoryAddKeyMode == true) then
			maxOps.trajectoryAddKeyMode = false
		else
			maxOps.trajectoryAddKeyMode = true
	)
)

macroScript TrajectoryDeleteKey
buttontext:~BUTTONTEXT_TRAJECTORYDELETEKEY~
category:~TRAJECTORYDELETEKEY_CATEGORY~ 
internalCategory:"Animation Tools" 
tooltip:~TRAJECTORYDELETEKEY_TOOLTIP~ 
(
	On isEnabled Return 
	(
		$selection.count != 0 
	)
	
	
	On Execute Do
	(
		maxOps.deleteSelectedTrajectoryKey()

	)
)



-- END OF FILE

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBYES8QR4go9Jy4PhUU3XpbzBAL0eE8n0RI
-- OB40ECHQ5aPPJJZFuqoB+4TzPtLFPzNouKe0yb2N0apx4WYmEpzqXnkKZM+69elj
-- APkqNYpfz7Wwkg3lnyNlw2zUJEFahdasc/NFeQKXP91nolB7tfDHD5kQAl3cETkv
-- cgRA26K8QcTI+UXwl/Z1MvExDgko+mkM3moH7zTfvw2FuRCBVpOppPWEB4uh9+KW
-- IO+ddt7FtjPv8ixDuOAxv55ndixu6vMRmuaNjv0o2H41T0LcuX8zIhkmIHdN2Q47
-- INrkImHL4LgiwLwszZD108uWlVbtaFv6TAY/BvCQWe4e1ha9ug0U
-- -----END-SIGNATURE-----