/*

Macro_Scripts File
Created:  29 Mai 2003
Author:   PF Breton

Macro_Scripts that lauches the Advanced Lighting Panel and Assigns the desired plugins if none is used yet


Revision History

	29 Mai 2003, Pierre-Felix Breton created
	
	10 dec 2003, Pierre-Felix Breton, 
               added product switcher: this macroscript file can be shared with all Discreet products



*/


--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

--------------------------------------------------------------------------------------------------
-- MacroScripts for Lauching the UI
--------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------
-- Radiosity

MacroScript AdvLighting_Radiosity
ButtonText:~ADVLIGHTING_RADIOSITY_CAPTION~
category:~ADVLIGHTING_RADIOSITY_CATEGORY~
internalCategory:"Render"
Tooltip:~ADVLIGHTING_RADIOSITY_TOOLTIP~
Icon:#("Radiosity",1)
(
	on execute do
	(
		local assignAdvLighting= false
		--shows the panel
		sceneradiosity.showpanel()
		
		if classof sceneradiosity.radiosity == Light_Tracer
		then
		(
			local answer
			answer = QueryBox ~QUERYBOX_ADV_LIGHTING_DISCARD~ \
			title:~CHANGE_ADV_LIGHTING_PLUGIN_TITLE~ beep:false
			
			if answer == true do assignAdvLighting= true
		)--end then
		else
		(
			assignAdvLighting= true
		)--end else

		
		if assignAdvLighting == true do
		(
			--assigns a default engine
			if classof sceneradiosity.radiosity != Radiosity do sceneradiosity.radiosity = Discreet_Radiosity()
		
			--assigns a default exposure control
			if (classof sceneExposureControl.exposureControl == UndefinedClass) do 
			(
				local answer
				answer = QueryBox ~QUERYBOX_RADIOSITY_PLUGIN_RECOMMEND_CAMERA_EXP_CONTROL~ \
					title:~ADVLIGHTING_RADIOSITY_QUERY_TITLE~ beep:false
	
				if answer == true do sceneExposureControl.exposureControl = Logarithmic_Exposure_Control()
			)
		)--end if assignAdvLighting == true do

	)
	
	on isenabled return ((classof renderers.current == Default_Scanline_Renderer))
	on isvisible return ((classof renderers.current == Default_Scanline_Renderer))
)



macroScript LightingAnalysis
ButtonText:~BUTTONTEXT_LIGHTING_ANALYSIS~
category:~RENDER_CATEGORY~ 
internalCategory:"Render" 
Tooltip:~LIGHTING_ANALYSIS_TOOLTIP~
(

on isvisible return ((classof renderers.current == Default_Scanline_Renderer))
on isEnabled return	((classof sceneradiosity.radiosity == Discreet_Radiosity) and (sceneradiosity.radiosity.CanShowLightingStatistics())) --checks if the lighting analysis tools is available with the engine's current state
On Execute Do
	( 
		Try(sceneradiosity.radiosity.ShowLightingStatistics()) Catch()
	)
)


-------------------------------------------------------------------------------------------------
-- MacroScripts for Quad Controls: Daylight Assemblies
--------------------------------------------------------------------------------------------------
-- store direct illumination of Sunlight located inside a Daylight assembly
macroScript RadProperty_StoreSun
category:~RADPROPERTY_STORESUN_CATEGORY~
internalCategory:"Render"
buttonText:~BUTTONTEXT_STORE_DIRECT_ILLUMINATION_SUN~
Tooltip:~STORE_DIRECT_ILLUMINATION_SUN_TOOLTIP~
( --macroScript RadTool_StoreSun begin

	fn notRadiosExcluded obj =
	(
		((obj.globalIlluminationByLayer and not obj.layer.isGIExcluded) or
		(not obj.globalIlluminationByLayer and not obj.isGIExcluded))
	)
	
	--visibility of menu item
	on isVisible return 
	(
		if classof (assemblyMgr.isassembly selection) != DaylightAssemblyHead then false
		else 
		(
			sunObj = (assemblyMgr.isassembly selection).sun
			if sunObj == undefined then false
				else 
				(
				local sunobj2
				for i in selection do 
					if classof i == IES_Sun or classof i == Directionallight do sunObj2 = i
				if sunObj2 != undefined do notRadiosExcluded sunObj2
				)
				)
	)--end on isvisible
	
	-- status of property					
	on isChecked return 
	(
		if classof (assemblyMgr.isassembly selection) != DaylightAssemblyHead then false
		else 
			if (assemblyMgr.isassembly selection).sun == undefined then false
			else
			(
				sunObj = (assemblyMgr.isassembly selection).sun
				if sunObj == undefined then false
					else 
					(
					local sunobj2
						for i in selection do 
							if classof i == IES_Sun or classof i == Directionallight do sunObj2 = i
						if sunObj2 != undefined do notRadiosExcluded sunObj2 and sunObj2.storeIllumToMesh
					)
			)
	)--end on ischecked
	
	-- execution
	on execute do		
	(
		local sunobj2
		for i in selection do 
			if classof i == IES_Sun or classof i == Directionallight do sunObj2 = i
		sunObj2.globalIlluminationByLayer = false
		sunObj2.storeIllumToMesh = not sunObj2.storeIllumToMesh
	)--end on execute
	
) --macroScript RadTool_StoreSun end



-- store direct illumination of skylight located inside a Daylight assembly
macroScript RadProperty_StoreSky
category:~RADPROPERTY_STORESKY_CATEGORY~
internalCategory:"Render"
buttonText:~BUTTONTEXT_RADPROPERTY_STORESKY~
Tooltip:~RADPROPERTY_STORESKY_TOOLTIP~

( --macroScript RadTool_Storesky begin

	fn notRadiosExcluded obj =
	(
		((obj.globalIlluminationByLayer and not obj.layer.isGIExcluded) or
		(not obj.globalIlluminationByLayer and not obj.isGIExcluded))
	)
	
	--visibility of menu item
	on isVisible return 
	(
		if classof (assemblyMgr.isassembly selection) != DaylightAssemblyHead then false
		else 
		(
			skyObj = (assemblyMgr.isassembly selection).sky
			if skyObj == undefined then false
				else 
				(
				local skyobj2
				for i in selection do 
					if classof i == IES_sky or classof i == Texture_Sky do skyObj2 = i
				if skyObj2 != undefined do notRadiosExcluded skyObj2
				)
				)
	)--end on isvisible
	
	-- status of property					
	on isChecked return 
	(
		if classof (assemblyMgr.isassembly selection) != DaylightAssemblyHead then false
		else 
			if (assemblyMgr.isassembly selection).sky == undefined then false
			else
			(
				skyObj = (assemblyMgr.isassembly selection).sky
				if skyObj == undefined then false
					else 
					(
					local skyobj2
						for i in selection do 
							if classof i == IES_sky or classof i == Texture_Sky do skyObj2 = i
						if skyObj2 != undefined do notRadiosExcluded skyObj2 and skyObj2.storeIllumToMesh
					)
			)
	)--end on ischecked
	
	-- execution
	on execute do		
	(
		local skyobj2
		for i in selection do 
			if classof i == IES_sky or classof i == Texture_Sky do skyObj2 = i
		skyObj2.globalIlluminationByLayer = false
		skyObj2.storeIllumToMesh = not skyObj2.storeIllumToMesh
	)--end on execute
	
) --macroScript RadTool_Storesky end


MacroScript Exposure_Control
ButtonText:~BUTTONTTEXT_EXPOSURE_CONTROL~
category:~EXPOSURE_CONTROL_CATEGORY~ 
internalCategory:"Render" 
Tooltip:~EXPOSURE_CONTROL_TOOLTIP~ 
Icon:#("Exposure",1)
(
	on execute do 
	(	
		actionMan.executeAction 0 "40029" -- LOC NOTE: Do Not Localize this
		
	)
)

--------------------------------------------------------------------------------------------------
-- Light tracer

MacroScript AdvLighting_LightTracer
ButtonText:~BUTTONTEXT_LIGHT_TRACER~
category:~ADVLIGHTING_LIGHTTRACER_CATEGORY~ 
internalCategory:"Render" 
Tooltip:~ADVLIGHTING_LIGHTTRACER_TOOLTIP~ 
--Icon:#("Radiosity",1)
(
	on execute do
(
		local assignAdvLighting= false
		--shows the panel
		sceneradiosity.showpanel()
		
		if classof sceneradiosity.radiosity == Radiosity
		then
		(
			local answer
			answer = QueryBox ~ADVLIGHTING_LIGHTTRACER_QUERYBOX_DISCARD_ARE_YOU_SURE~ \
			title:~CHANGE_ADVLIGHTING_LIGHTTRACER_PLUGIN_TITLE~ beep:false
			
			if answer == true do assignAdvLighting= true
		)--end then
		else
		(
			assignAdvLighting= true
		)--end else

		
		if assignAdvLighting == true do
		(
			--assigns a default engine
			if classof sceneradiosity.radiosity != Light_Tracer do sceneradiosity.radiosity = Light_Tracer()

		)--end if assignAdvLighting == true do

	)


	
	on isenabled return ((classof renderers.current == Default_Scanline_Renderer))
	on isvisible return ((classof renderers.current == Default_Scanline_Renderer))
)



-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCAsqcl20aLT55BMxserL+znoiHuHQHxwgi
-- n1OwgX0fJBXXLMuwdukJbhMCrPeOlzkNhpnTKLtSA+gsaqZOoMKptp7yJnS77dIx
-- 8k2wZ1F9PBmtSRNn+eWLHQFEj9wD5rIxq/4qnmHBK4gd4vkuPbOggqE440DZfTjv
-- OieAEkOLXPhbqqW8FHm0nfRNh/YNgEjjKBw+otBL3IXhmi2aEdpr2ZxfjgzwUSE1
-- zSvtIe1FBPrGn3Miq66V8fP/xaFIYcJPjXzHWf54tcQ4VgZb3aX6Cz6udRiBKSzT
-- rAeAB5b2rb+HeLels68M05PGDJ/UVnodefAwd+JfLEwl1qM5LZVC
-- -----END-SIGNATURE-----