
#ifndef MAX_NITROUS
#define MAX_NITROUS
#endif

//
// The following are parameters representing
// non-varying state variables referenced by the shader.
// These should be set by the application at runtime.
//
float4 __scene_ambient : Ambient
<
    string UIName = "Scene Ambient";
    string UIWidget = "color";
> = float4(0.0,0.0,0.0,1.0);

float __refracted_ior = 1.0;

bool __orthographic : Orthographic= false;
float __focal_length : Focal_length= .5;
float __aperture : Aperture= 0.0;
int __image_x_resolution : Image_x_resolution= 256;
int __image_y_resolution : Image_y_resolution= 256;
float2 rasteroffset : raster_offset = float2(0.5f, 0.5f);

#ifndef __LIGHT_TYPES
#define __LIGHT_TYPES
//
// Values for the light_type parameter of light shaders
//
#define LIGHT_POINT    0
#define LIGHT_SPOT     1
#define LIGHT_INFINITE 2
#define LIGHT_PLANAR   3

#endif // __LIGHT_TYPES

#ifndef __LIGHT_ITERATOR_STRUCT
#define __LIGHT_ITERATOR_STRUCT
struct Light_iterator {
    float3 msl_point;
    float3 msl_direction;
    float  msl_distance;
    float  msl_dot_nl;
    float3 msl_contribution;
    float3 msl_raw_contribution;
    float3 msl_shadow;
    int    msl_count;
};
#endif // __LIGHT_ITERATOR_STRUCT

#ifndef __FLOAT3_CTOR
#define __FLOAT3_CTOR
float3 __float3_ctor(float v)
{
    return v.xxx;
}

#endif // __FLOAT3_CTOR

#ifndef __FLOAT4_CTOR
#define __FLOAT4_CTOR
float4 __float4_ctor(float v)
{
    return v.xxxx;
}

#endif // __FLOAT4_CTOR

#ifndef __IRRADIANCE_OPTIONS_TYPE
#define __IRRADIANCE_OPTIONS_TYPE
struct Irradiance_options
{
    float near;
    float far;
};

#endif // __IRRADIANCE_OPTIONS_TYPE

#ifndef __DIFFERENTIAL_SCALE
#define __DIFFERENTIAL_SCALE
uniform float __differential_scale = 1.0;

#endif // __DIFFERENTIAL_SCALE

#ifndef __RASTER_OFFSET
#define __RASTER_OFFSET
uniform float2 __raster_offset = float2(0,0);

#endif // __RASTER_OFFSET

#ifndef __GRID_SNAP_2D
#define __GRID_SNAP_2D

float2 _grid_snap(float4 props, float2 coord)
{
	return (floor(props.xy * coord) + 0.5) / props.xy;
}

#endif // __GRID_SNAP_2D

#ifndef __GRID_SNAP_3D
#define __GRID_SNAP_3D

float3 _grid_snap(float4 props, float3 coord)
{
    return (floor(props.xyz * coord) + 0.5) / props.xyz;
}

#endif // __GRID_SNAP_3D

#ifndef __MAKE_BASIS
#define __MAKE_BASIS
void __make_basis(const float3 n,const float3 u,const float3 v,out float3 t,out float3 b)
{
    // If u or v a 0, we could create NaNs, try to avoid this.
    float3 c = cross(u,n);
    if(dot(c,c) == 0.0) {
        c = cross(float3(0.0,1.0,0.0),n);
        if(dot(c,c) == 0.0) {
            c = cross(float3(1.0,0.0,0.0), n);
        }
    }
    b = normalize(c);
    t = cross(n,b);
    if(dot(b,v) < 0.0)
        b = -b;
}

#endif // __MAKE_BASIS

#ifndef __PERSPECTIVE_DIVIDE
#define __PERSPECTIVE_DIVIDE
float3 __perspective_divide(float4 pt)
{
    return pt.xyz / pt.w;
}

#endif // __PERSPECTIVE_DIVIDE

#ifndef __DEPENDENT_STATE
#define __DEPENDENT_STATE
void __update_state_origin_or_position(inout State state)
{
    state.direction = state.position - state.origin;
    state.ray_length = length(state.direction);
    state.direction = normalize(state.direction);
} 

#endif // __DEPENDENT_STATE

#ifndef __OBJECT_LABELS
#define __OBJECT_LABELS
uniform int __object_label = 0;
float4 _label_as_color()
{
    int n = __object_label;
    float4 c;
    c.a = float(n / 16777216);
    c.b = float((n % 16777216) / 65536);
    c.g = float((n % 65536) / 256);
    c.r = float(n % 256);
    c /= 255.0;
    return c;
} 

#endif // __OBJECT_LABELS

#ifndef __CLIP_PLANE
#define __CLIP_PLANE
uniform float4 __clip_plane = float4(1.0,1.0,0.0,0.0);

#endif // __CLIP_PLANE

#ifndef __BIT_COUNT
#define __BIT_COUNT
int __bit_count(uint a) {
    int res = 0;
    if (a >= 0x8000) { a -= 0x8000; ++res; }
    if (a >= 0x4000) { a -= 0x4000; ++res; }
    if (a >= 0x2000) { a -= 0x2000; ++res; }
    if (a >= 0x1000) { a -= 0x1000; ++res; }
    if (a >= 0x0800) { a -= 0x0800; ++res; }
    if (a >= 0x0400) { a -= 0x0400; ++res; }
    if (a >= 0x0200) { a -= 0x0200; ++res; }
    if (a >= 0x0100) { a -= 0x0100; ++res; }
    if (a >= 0x8000) { a -= 0x8000; ++res; }
    if (a >= 0x0040) { a -= 0x0040; ++res; }
    if (a >= 0x0020) { a -= 0x0020; ++res; }
    if (a >= 0x0010) { a -= 0x0010; ++res; }
    if (a >= 0x0008) { a -= 0x0008; ++res; }
    if (a >= 0x0004) { a -= 0x0004; ++res; }
    if (a >= 0x0002) { a -= 0x0002; ++res; }
    if (a >= 0x0001) {              ++res; }
    return res;
}
#endif // __BIT_COUNT


#ifndef __BIT_SUBSET
#define __BIT_SUBSET
bool __bit_subset(uint a, uint b)
{
    if (a >= 0x8000) {
        if (b < 0x8000)
        return false;
        a -= 0x8000;
    }
    if (b >= 0x8000) b -= 0x8000;
    if (a >= 0x4000) {
        if (b < 0x4000)
        return false;
        a -= 0x4000;
    }
    if (b >= 0x4000) b -= 0x4000;
    if (a >= 0x2000) {
        if (b < 0x2000)
        return false;
        a -= 0x2000;
    }
    if (b >= 0x2000) b -= 0x2000;
    if (a >= 0x1000) {
        if (b < 0x1000)
        return false;
        a -= 0x1000;
    }
    if (b >= 0x1000) b -= 0x1000;
    if (a >= 0x0800) {
        if (b < 0x0800)
        return false;
        a -= 0x0800;
    }
    if (b >= 0x0800) b -= 0x0800;
    if (a >= 0x0400) {
        if (b < 0x0400)
        return false;
        a -= 0x0400;
    }
    if (b >= 0x0400) b -= 0x0400;
    if (a >= 0x0200) {
        if (b < 0x0200)
        return false;
        a -= 0x0200;
    }
    if (b >= 0x0200) b -= 0x0200;
    if (a >= 0x0100) {
        if (b < 0x0100)
        return false;
        a -= 0x0100;
    }
    if (b >= 0x0100) b -= 0x0100;
    if (a >= 0x0080) {
        if (b < 0x0080)
        return false;
        a -= 0x0080;
    }
    if (b >= 0x0080) b -= 0x0080;
    if (a >= 0x0040) {
        if (b < 0x0040)
        return false;
        a -= 0x0040;
    }
    if (b >= 0x0040) b -= 0x0040;
    if (a >= 0x0020) {
        if (b < 0x0020)
        return false;
        a -= 0x0020;
    }
    if (b >= 0x0020) b -= 0x0020;
    if (a >= 0x0010) {
        if (b < 0x0010)
        return false;
        a -= 0x0010;
    }
    if (b >= 0x0010) b -= 0x0010;
    if (a >= 0x0008) {
        if (b < 0x0008)
        return false;
        a -= 0x0008;
    }
    if (b >= 0x0008) b -= 0x0008;
    if (a >= 0x0004) {
        if (b < 0x0004)
        return false;
        a -= 0x0004;
    }
    if (b >= 0x0004) b -= 0x0004;
    if (a >= 0x0002) {
        if (b < 0x0002)
        return false;
        a -= 0x0002;
    }
    if (b >= 0x0002) b -= 0x0002;
    if (a >= 0x0001) {
        if (b < 0x0001)
        return false;
        a -= 0x0001;
    }
    if (b >= 0x0001) b -= 0x0001;
    return true;
}
#endif // __BIT_SUBSET

#ifndef __BIT_NOT
#define __BIT_NOT
int __bit_not(int a) {
    return 0xFFFF - a;
}
#endif // __BIT_NOT

#ifndef __BIT_AND
#define __BIT_AND
int __bit_and(uint a, uint b) {
    uint res = a;
    if (a >= 0x8000) {
        a -= 0x8000;
        if (b >= 0x8000) b -= 0x8000; else res -= 0x8000;
    } else if (b >= 0x8000) b -= 0x8000;
    if (a >= 0x4000) {
        a -= 0x4000;
        if (b >= 0x4000) b -= 0x4000; else res -= 0x4000;
    } else if (b >= 0x4000) b -= 0x4000;
    if (a >= 0x2000) {
        a -= 0x2000;
        if (b >= 0x2000) b -= 0x2000; else res -= 0x2000;
    } else if (b >= 0x2000) b -= 0x2000;
    if (a >= 0x1000) {
        a -= 0x1000;
        if (b >= 0x1000) b -= 0x1000; else res -= 0x1000;
    } else if (b >= 0x1000) b -= 0x1000;
    if (a >= 0x0800) {
        a -= 0x0800;
        if (b >= 0x0800) b -= 0x0800; else res -= 0x0800;
    } else if (b >= 0x0800) b -= 0x0800;
    if (a >= 0x0400) {
        a -= 0x0400;
        if (b >= 0x0400) b -= 0x0400; else res -= 0x0400;
    } else if (b >= 0x0400) b -= 0x0400;
    if (a >= 0x0200) {
        a -= 0x0200;
        if (b >= 0x0200) b -= 0x0200; else res -= 0x0200;
    } else if (b >= 0x0200) b -= 0x0200;
    if (a >= 0x0100) {
        a -= 0x0100;
        if (b >= 0x0100) b -= 0x0100; else res -= 0x0100;
    } else if (b >= 0x0100) b -= 0x0100;
    if (a >= 0x0080) {
        a -= 0x0080;
        if (b >= 0x0080) b -= 0x0080; else res -= 0x0080;
    } else if (b >= 0x0080) b -= 0x0080;
    if (a >= 0x0040) {
        a -= 0x0040;
        if (b >= 0x0040) b -= 0x0040; else res -= 0x0040;
    } else if (b >= 0x0040) b -= 0x0040;
    if (a >= 0x0020) {
        a -= 0x0020;
        if (b >= 0x0020) b -= 0x0020; else res -= 0x0020;
    } else if (b >= 0x0020) b -= 0x0020;
    if (a >= 0x0010) {
        a -= 0x0010;
        if (b >= 0x0010) b -= 0x0010; else res -= 0x0010;
    } else if (b >= 0x0010) b -= 0x0010;
    if (a >= 0x0008) {
        a -= 0x0008;
        if (b >= 0x0008) b -= 0x0008; else res -= 0x0008;
    } else if (b >= 0x0008) b -= 0x0008;
    if (a >= 0x0004) {
        a -= 0x0004;
        if (b >= 0x0004) b -= 0x0004; else res -= 0x0004;
    } else if (b >= 0x0004) b -= 0x0004;
    if (a >= 0x0002) {
        a -= 0x0002;
        if (b >= 0x0002) b -= 0x0002; else res -= 0x0002;
    } else if (b >= 0x0002) b -= 0x0002;
    if (a >= 0x0001) {
        a -= 0x0001;
        if (b >= 0x0001) b -= 0x0001; else res -= 0x0001;
    } else if (b >= 0x0001) b -= 0x0001;
    return res;
}
#endif // __BIT_AND

#ifndef __BIT_OR
#define __BIT_OR
int __bit_or(uint a, uint b) {
    uint res = a;
    if (a >= 0x8000) {
        a -= 0x8000;
        if (b >= 0x8000) b -= 0x8000;
    } else if (b >= 0x8000) { b -= 0x8000; res += 0x8000; }
    if (a >= 0x4000) {
        a -= 0x4000;
        if (b >= 0x4000) b -= 0x4000;
    } else if (b >= 0x4000) { b -= 0x4000; res += 0x4000; }
    if (a >= 0x2000) {
        a -= 0x2000;
        if (b >= 0x2000) b -= 0x2000;
    } else if (b >= 0x2000) { b -= 0x2000; res += 0x2000; }
    if (a >= 0x1000) {
        a -= 0x1000;
        if (b >= 0x1000) b -= 0x1000;
    } else if (b >= 0x1000) { b -= 0x1000; res += 0x1000; }
    if (a >= 0x0800) {
        a -= 0x0800;
        if (b >= 0x0800) b -= 0x0800;
    } else if (b >= 0x0800) { b -= 0x0800; res += 0x0800; }
    if (a >= 0x0400) {
        a -= 0x0400;
        if (b >= 0x0400) b -= 0x0400;
    } else if (b >= 0x0400) { b -= 0x0400; res += 0x0400; }
    if (a >= 0x0200) {
        a -= 0x0200;
        if (b >= 0x0200) b -= 0x0200;
    } else if (b >= 0x0200) { b -= 0x0200; res += 0x0200; }
    if (a >= 0x0100) {
        a -= 0x0100;
        if (b >= 0x0100) b -= 0x0100;
    } else if (b >= 0x0100) { b -= 0x0100; res += 0x0100; }
    if (a >= 0x0080) {
        a -= 0x0080;
        if (b >= 0x0080) b -= 0x0080;
    } else if (b >= 0x0080) { b -= 0x0080; res += 0x0080; }
    if (a >= 0x0040) {
        a -= 0x0040;
        if (b >= 0x0040) b -= 0x0040;
    } else if (b >= 0x0040) { b -= 0x0040; res += 0x0040; }
    if (a >= 0x0020) {
        a -= 0x0020;
        if (b >= 0x0020) b -= 0x0020;
    } else if (b >= 0x0020) { b -= 0x0020; res += 0x0020; }
    if (a >= 0x0010) {
        a -= 0x0010;
        if (b >= 0x0010) b -= 0x0010;
    } else if (b >= 0x0010) { b -= 0x0010; res += 0x0010; }
    if (a >= 0x0008) {
        a -= 0x0008;
        if (b >= 0x0008) b -= 0x0008;
    } else if (b >= 0x0008) { b -= 0x0008; res += 0x0008; }
    if (a >= 0x0004) {
        a -= 0x0004;
        if (b >= 0x0004) b -= 0x0004;
    } else if (b >= 0x0004) { b -= 0x0004; res += 0x0004; }
    if (a >= 0x0002) {
        a -= 0x0002;
        if (b >= 0x0002) b -= 0x0002;
    } else if (b >= 0x0002) { b -= 0x0002; res += 0x0002; }
    if (a >= 0x0001) {
        a -= 0x0001;
        if (b >= 0x0001) b -= 0x0001;
    } else if (b >= 0x0001) { b -= 0x0001; res += 0x0001; }
    return res;
}
#endif // __BIT_OR

#ifndef __TEXTURE_FLIP
#define __TEXTURE_FLIP

float2 __flip_v(float2 v) { return float2(v.x, -v.y); }
float3 __flip_v(float3 v) { return float3(v.x, -v.y, v.z); }
float4 __flip_v(float4 v) { return float4(v.x, -v.y, v.z, v.w); }

#endif // __TEXTURE_FLIP
