float3 MAX_OGS_Vw( float3 Pw, float3 Ew, float4x4 invViewProj, bool orthographic ) 
{ 
	if( orthographic ) return mul( float4(0, 0, -1, 1), invViewProj ); 
	return normalize( Ew - Pw ); 
} 

float MAX_OGS_specularFunction(float3 V, float3 N, float3 L, float P) 
{ 
	float3 H = normalize(L + V); 
	float dotNH = saturate(dot(N, H)); 
	return (0 == dotNH) ? 0 : pow(dotNH, P); 
} 

void UnPackSpecular(float f, inout int specular, inout int base2) 
{  
	specular += base2 * (floor(f) < 1 ? 0 : 1); 
	base2 *= 2; 
	specular += base2 * (sign(f) > 0 ? 0 : 1); 
	base2 *= 2; 
}

int UnPackSpecular(float4 packedVar) 
{  
	int base2 = 1; 
	int specular = 0; 
	UnPackSpecular(packedVar.w, specular, base2); 
	UnPackSpecular(packedVar.z, specular, base2); 
	UnPackSpecular(packedVar.y, specular, base2); 
	return specular * 2; 
}

float UnPackZ(float4 p)
{  
	return abs(p.x) + frac(abs(p.y)) / 1024;  
}

float3 UnPackNormal(float4 p, float leftHanded)
{  
	float2 fenc = frac(abs(p.zw))*4-2; 
	float f = dot(fenc,fenc); 
	float g = sqrt(1 - f*0.25f); 
	return float3(fenc*g, (f*0.5f - 1)*leftHanded); 
}

void UnPackGBuffer(float4 p, float leftHanded, out float z, out float3 n, out int specular, out bool receiveShadow)
{  
	receiveShadow = p.x > 0 ? true : false; 
	specular = UnPackSpecular(p); 
	z = UnPackZ(p);  
	n = UnPackNormal(p, leftHanded); 
}

float2 EncodeNormal(float3 n, float leftHanded)
{  
	float p = sqrt(8 - 8*n.z*leftHanded); 
	return float2(n.xy / p); 
}

float3 DecodePosition(float d, float2 uv, float4x4 invViewProj)
{  
	uv.y = 1 - uv.y; 
	uv = 2 * uv - 1; 
	float4 pos = mul(float4(uv, d, 1), invViewProj); 
	return pos.xyz / pos.w; 
}

float3 DecodePosition(float d, float2 uv, float4x4 invViewProjNear, float4x4 invViewProjFar)
{  
	return d < 1 ? DecodePosition(d, uv, invViewProjNear) : DecodePosition(frac(d), uv, invViewProjFar); 
}