(

    struct AMGData 
	(
		fn GetUUID mtl context =
		(
			-- here you return the UUID of the AMG node or graph that implements this material/map
			--
			-- Example:
			--    "c0a9d104-c110-49f9-8cf7-82171c872bdd"
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			-- here you add to the "res" array for each map connection, the syntax is:
			--
			--    append res #( <string parametername>, <mtl/map submap> [, <string output>, [<context>]] )
			--
			-- <output>  is optional and will be "result" if not specified.
			-- <context> is an integer passed down to the functions of the node being connected
			--
			-- Example:
			--    if mtl.diffuse_map != undefined and mtl.diffuse_map_on do
			--        append res #( "diffuse", mtl.diffuse_map )                  -- connect "result" of the map to "diffuse" parameter
			--    if mtl.roughness_map != undefined and mtl.rougness_map_on do
			--        append res #( "rougness", mtl.diffuse_map, "resultFloat" )  -- connect "resultFloat" of the map to "roughness" parameter
			--    if mtl.bump_map != undefined and mtl.bump_map_on do
			--        append res #( "bump", mtl.diffuse_map, "resultFloat" )  -- connect "resultFloat" of the map to "roughness" parameter

			res
		),

		fn GetParams mtl context = 
		(
			local res = #()	

			-- here you add to the "res" array for each map connection, the syntax is:
			--
			--    append res #( <string parametername>, <value of matching type> )
			--
			-- Example:
			--    append res #( "diffuse",  mtl.diffuse_color)                   
			--    append res #( "rougness", mtl.diffuse_roughness )  

 			res
		)
	)

	AMGData()
)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQB/x50buC83c+0SLRiU04S3VKkU3SUPWwox
-- 8Ds8Z+LnkcGdElOUJ6trrjf/lP9Vqil2IPznaGTI/mG+n1mHJHjhcr/D5p0H4io2
-- T4XTCVhIS50ydrsnBTRW2L48RgG9QUtUgdhxQNl2lLh5w58IJmNp+kos/3FLSHZz
-- +eBtogS8fX8Vnwv1UyfGrxWDzrfh9RgIpl9cHATtNldbdCDqR+H9ivdq3NZjYIat
-- aJa8m1em+UY8QuTCXcWIIjEWQtupaE+javIcuVgdMXY4gzTpWWg21gN7gXGJluxI
-- FvZLOwhaY4+NXaII2TxCT72ac4QlzwJUWHhCHMkPc/hwxcOGEQ7n
-- -----END-SIGNATURE-----