(
	-- UV Generator 

    struct AMGData 
	(
		fn GetUUID mtl context =
		(
			"d472fb22-9c8d-44f4-bcaa-cef1dd62cc61"
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			-- If we have an UVW override, we just use that...
			if (AMG_UVW_override != undefined) then
			(
				join res AMG_uvw_override
			)
			else
			(
				-- Environment mode cannot use varying attributes
				if (mtl.mappingType == 0 and context != 2) do
				(
					append res #("uvw",      undefined, "uvw_"       + (mtl.mapChannel as String))
					append res #("utangent", undefined, "u_tangent_" + (mtl.mapChannel as String))
					append res #("vtangent", undefined, "v_tangent_" + (mtl.mapChannel as String))
				)
			)

			res
		),

		fn GetParams mtl context =
		(
			local res = #()	

			append res #("mapSlotType",   mtl.mappingType)
			append res #("mapType",       mtl.mapping)     
			append res #("showMapOnBack", mtl.showMapOnBack)

			append res #("utile", mtl.U_Tile)
			append res #("vtile", mtl.V_Tile)
			append res #("umirror", mtl.U_Mirror)
			append res #("vmirror", mtl.V_Mirror)

			-- Thankfully, all the transform-craziness gets baked into this one parameter.... <3 you max
			append res #("UVTransform", mtl.UVTransform)
			append res #("TangentTransform", orthogonalize(inverse(mtl.UVTransform)))

			append res #("blur",      mtl.blur) 
			append res #("blurOffs",  mtl.Blur_Offset) 

			append res #("ns",     mtl.Noise_On) 
			append res #("nsAni",  mtl.Noise_Animate) 
			append res #("nsAmt",  mtl.Noise_Amount) 
			append res #("nsPhs",  mtl.phase) 
			append res #("nsSize", mtl.Noise_Size) 
			append res #("nsLev",  mtl.Noise_Levels) 
	
 			res
		)
	)

	AMGData()
)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAddNn7SvKi04qmrePaEhOiH49cm+El1+8u
-- EQU9iLS1lEevF8trOE1OR3OajBaPfWSSMLqbxrDRYiHsFo+YBtruf6LPxzV9tMTm
-- KSMkFipd7kOn0CkuyzKt8kNx3aVwzZw+SMEnYKGn3BekFsoc1OwqlzYcstTTNmKn
-- zo+Uup/Psk/69l31XYtz7/TMsgElb3rFHfLeNYv/I2NyqUTJYq8AyILVf/FcRJvv
-- P8Kva6D2LCCvlN8GmtxEH6O5zPRATdQIdlrltOz72Ms0S3xHnRgEUtDAoYnY+SM8
-- EeVMUqIK0x54qW20C7OephBlUxRUjuKLbdwapMYKhQwkkGlYCqNP
-- -----END-SIGNATURE-----