(
	-- Standard Material (Approximation)

    struct AMGData
	(
		fn GetUUID mtl context = 
		(
			"480295f3-8b79-4622-b7ef-84e86073d73c"
		)
		,
		fn GetMaps mtl context = 
		(
			local res = #()	

			if mtl.diffuseMap != undefined and mtl.diffuseMapEnable do (
				append res #("diffuseMap",      mtl.diffuseMap)
				append res #("diffuseMapAlpha", mtl.diffuseMap, "alpha")
			)

			-- some subshaders have this, others don't. We used it when it's there....
			if hasProperty mtl "diffuseLevelMap" do
			(
				if mtl.diffuseLevelMap != undefined and mtl.diffuseLevelMapEnable do 
					append res #("diffuseLevelMap", mtl.diffuseLevelMap, "resultFloat")
			)

			if mtl.opacityMap != undefined and mtl.opacityMapEnable do (
				append res #("opacityMap",      mtl.opacityMap, "resultFloat")
			)

			if mtl.bumpMap != undefined and mtl.bumpMapEnable do (
				append res #("bump",            mtl.bumpMap,    "normalPerturb", 1)
			)

			-- some subshaders have this, others don't. We used it when it's there....
			if hasProperty mtl "Specular" do
			(
				if mtl.specularMap != undefined and mtl.specularMapEnable do (
					append res #("specularMap",      mtl.specularMap)
				)
				if mtl.specularLevelMap != undefined and mtl.specularLevelMapEnable do (
					append res #("specularLevelMap", mtl.specularLevelMap, "resultFloat")
				)
				if mtl.glossinessMap != undefined and mtl.glossinessMapEnable do (
					append res #("glossinessMap",    mtl.glossinessMap,    "resultFloat")
				)
			)


			if hasProperty mtl "selfillumMap" do
			(
				if mtl.selfIllumMap != undefined and mtl.selfillumMapEnable do (
					append res #("selfIllumMap",      mtl.selfillumMap)
				)
			)

			res
		),

		fn GetParams mtl context =
		(
			local res = #()	

			-- Diffuse
			append res #("diffuse",           mtl.diffuse)

			-- Diffuse map knobs
			append res #("diffuseMapAmount",  mtl.diffuseMapAmount / 100.0)
			append res #("diffuseMapAlpha",   0.0) 

			-- some subshaders have this, others don't. We used it when it's there....
			if (hasProperty mtl "diffuseLevel") then (
				append res #("diffuseLevel",      mtl.diffuseLevel / 100.0)
			)
			else
			(
				append res #("diffuseLevel",      1.0)
			)

			-- some subshaders have this, others don't. We used it when it's there....
			if (hasProperty mtl "diffuseLevelMap") then (
				if mtl.diffuseLevelMap != undefined and mtl.diffuseLevelMapEnable then (
					append res #("diffuseLevelMapAmount",      mtl.diffuseLevelMapAmount / 100.0)
				)
				else
				(
					append res #("diffuseLevelMapAmount",      0.0)
				)
			)
			else
			(
				append res #("diffuseLevelMapAmount",      0.0)
			)


			-- some subshaders have this, others don't. We used it when it's there....
			if hasProperty mtl "Specular" then
			(
				append res #("specular",      mtl.specular)

				if mtl.specularMap != undefined and mtl.specularMapEnable then (
					append res #("specularMapAmount",      mtl.specularMapAmount / 100.0)
				)
				else
				(
					append res #("specularMapAmount",      0.0)
				)

				append res #("specularLevel",  mtl.specularLevel  / 100.0)

				if mtl.specularLevelMap != undefined and mtl.specularLevelMapEnable then (
					append res #("specularLevelMapAmount", mtl.specularLevelMapAmount / 100.0)
				)
				else
				(
					append res #("specularLevelMapAmount", 0.0)
				)

				append res #("glossiness",  mtl.glossiness  / 100.0)

				if mtl.glossinessMap != undefined and mtl.glossinessMapEnable then (
					append res #("glossinessMapAmount", mtl.glossinessMapAmount / 100.0)
				)
				else
				(
					append res #("glossinessMapAmount", 0.0)
				)
			)
			else
			(
				-- No speculars
				append res #("specularLevel", 0.0)				
			)

			local emissive = false

			if hasProperty mtl "selfillumAmount" then
			(
				if mtl.selfIllumMap != undefined and mtl.selfillumMapEnable then (
					append res #("selfIllumMapAmount",      mtl.selfillumMapAmount / 100.0)
					emissive = true
				)
				else
				(
					append res #("selfIllumMapAmount",      0.0)
				)

				if mtl.useSelfIllumColor then (
					append res #("selfIllum",   mtl.selfIllumColor)
					emissive = true
				)
				else
				(
					local x = (mtl.selfIllumAmount / 100.0) * 256.0

					if x > 0 do emissive = true

					append res #("selfIllum",   (color x x x))
				)

				append res #("useSelfIllumColor", mtl.useSelfIllumColor)
			)
			else
			(
				append res #("selfIllum",           (color 0 0 0))
				append res #("selfIllumMapAmount",  0.0)
				append res #("useSelfIllumColor",   false)
			)

			-- Flag emissive or not

			append res #("att:emissive", emissive) 

			-- Opacity
			append res #("opacity",           mtl.opacity / 100.0)
			append res #("opacityMap",        mtl.opacity / 100.0)

			-- Opacity map knobs
			if mtl.opacityMap != undefined and mtl.opacityMapEnable then 			
				append res #("opacityMapAmount",  mtl.opacityMapAmount / 100.0)
			else
				append res #("opacityMapAmount",  0.0)
			
			-- Bump map knobs
			append res #("bumpAmount",  mtl.bumpMapAmount / 100.0)

			res
		)
	)

	AMGData()	
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBTtRFUi47Svr82efxkR5Itn6bM25Pm89iP
-- P7e38dSGGIbUrB+6CNcllvltXhddxbhj8hL/aHcm98441y4AI+R3NUVyTNdIsmA1
-- WiQzCWo61hnHOqrmL+wPHRmDpzd8L4GVYbh5cEQarLcyRb13zbhOIO14HPL0oye7
-- kgMImmxtqrziDZcCDCF8JHYyIMWREskH1dCbOijPMPT3gXkpqgQjVDNwKXkJg9ul
-- S7xhMdtvXJSFKZoI+RpH4j3nOBoekxWmxjWojlRoboK3j8LOvIoUh86SM383BJsX
-- Ia0isXKi0AyyvqN4s+Bk+KAs5NCpwftBHkE33+fDSJ5a6mf2yJM/
-- -----END-SIGNATURE-----