(
	-- The 3ds max "Physical Material""

    struct AMGData
	(
		fn GetUUID mtl context = 
		(
			"cbd3dcad-6eff-4094-9e9a-53f0414aebac"
		)
		,
		fn GetMaps mtl context = 
		(
			local res = #()	

			-- Bump map
			if mtl.bump_map_on AND mtl.bump_map != undefined do 
				append res #("bump", mtl.bump_map, "normalPerturb", 1)		

			-- Base reflectance			
			if mtl.base_weight_map_on AND mtl.base_weight_map != undefined do 
				append res #("base_weight", mtl.base_weight_map, "resultFloat")
			if mtl.base_color_map_on AND mtl.base_color_map != undefined do 
				append res #("base_color", mtl.base_color_map)
			if mtl.reflectivity_map_on AND mtl.reflectivity_map != undefined do 
				append res #("refl_weight", mtl.reflectivity_map, "resultFloat")
			
			if mtl.roughness_map_on AND mtl.roughness_map != undefined do (
				append res #("refl_rough", mtl.roughness_map, "resultFloat")			

				-- If they are locked, also assign to transparency roughness
				if (mtl.trans_roughness_lock) do
					append res #("tran_rough", mtl.roughness_map, "resultFloat")			
			)

			if mtl.metalness_map_on AND mtl.metalness_map != undefined do 
				append res #("metalness", mtl.metalness_map, "resultFloat")			

			if mtl.diff_rough_map_on AND mtl.diff_rough_map != undefined do 
				append res #("diff_rough", mtl.diff_rough_map, "resultFloat")			

			if mtl.refl_color_map_on AND mtl.refl_color_map != undefined do 
				append res #("refl_color", mtl.refl_color_map)			
			
			-- Transmittance
			if mtl.transparency_map_on AND mtl.transparency_map != undefined do 
				append res #("trans_weight", mtl.transparency_map, "resultFloat")			
			if mtl.trans_color_map_on AND mtl.trans_color_map != undefined do 
				append res #("trans_color", mtl.trans_color_map)

			if mtl.trans_roughness_lock == false AND mtl.trans_rough_map_on AND mtl.trans_rough_map != undefined do 
				append res #("tran_rough", mtl.trans_rough_map)

			-- SSS
			if mtl.scattering_map_on AND mtl.scattering_map != undefined do 
				append res #("scatter_weight", mtl.scattering_map, "resultFloat")			
			if mtl.sss_color_map_on AND mtl.sss_color_map != undefined do 
				append res #("scatter_color", mtl.sss_color_map)
			if mtl.sss_scale_map_on AND mtl.sss_scale_map != undefined do 
				append res #("scatter_depth", mtl.sss_scale_map, "resultFloat")			

			-- Emission
			if mtl.emission_map_on AND mtl.emission_map != undefined do 
				append res #("emission_weight", mtl.emission_map, "resultFloat")			
			if mtl.emit_color_map_on AND mtl.emit_color_map != undefined do 
				append res #("emission_filter", mtl.emit_color_map)

			-- Coating
			if mtl.coat_map != undefined and mtl.coat_map_on do 
				append res #("coat_weight",  mtl.coat_map, "resultFloat")
			if mtl.coat_color_map_on AND mtl.coat_color_map != undefined do 
				append res #("coat_color", mtl.coat_color_map)
			if mtl.coat_rough_map_on AND mtl.coat_rough_map != undefined do 
				append res #("coat_rough", mtl.coat_rough_map, "resultFloat")			
			if mtl.coat_bump_map_on AND mtl.coat_bump_map != undefined do 
				append res #("coat_bump", mtl.coat_bump_map, "normalPerturb", 1)		


			-- Anisotropy			
			if mtl.anisotropy_map != undefined and mtl.anisotropy_map_on do 
				append res #("anisotropy",  mtl.anisotropy_map, "resultFloat")
			if mtl.aniso_angle_map != undefined and mtl.aniso_angle_map_on do 
				append res #("angle",       mtl.aniso_angle_map, "resultFloat")

			if mtl.aniso_mode == 1 do 
			(
				append res #("utangent", undefined, "u_tangent_" + (mtl.aniso_channel as String))
				append res #("vtangent", undefined, "v_tangent_" + (mtl.aniso_channel as String))
			)


			if mtl.cutout_map_on AND mtl.cutout_map != undefined do 
				append res #("cutout", mtl.cutout_map, "resultFloat")		

            -- MAXX-32321: 2017-08-17: IOR map didn't work
			if mtl.trans_ior_map_on AND mtl.trans_ior_map != undefined do 
				append res #("refl_ior", mtl.trans_ior_map, "resultFloat")

			-- print res
		
			res
		),

		fn GetParams mtl context =
		(
			local res = #()	
			
			append res #("bump_amount",  mtl.bump_map_amount)		

			append res #("base_weight",         mtl.base_weight)
			append res #("base_color",          mtl.base_color)
			append res #("refl_weight",         mtl.reflectivity)
			append res #("refl_color",          mtl.refl_color)
			append res #("refl_ior",            mtl.trans_ior)

			append res #("anisotropy",          mtl.anisotropy)
			append res #("angle",               mtl.anisoangle)
			
			append res #("refl_rough",          mtl.roughness)
			append res #("refl_rough_invert",   mtl.roughness_inv)
			append res #("metalness",           mtl.metalness)
			append res #("diff_rough",          mtl.diff_roughness)

			append res #("trans_weight",        mtl.transparency)
			append res #("trans_color",         mtl.trans_color)

			-- Todo: Transparency depth

			if mtl.trans_roughness_lock then (
				append res #("trans_rough",        mtl.roughness)
				append res #("trans_rough_inv",    mtl.roughness_inv)
			)
			else
			(
				append res #("trans_rough",        mtl.trans_roughness)
				append res #("trans_rough_inv",    mtl.trans_roughness_inv)
			)

			append res #("scatter_weight",      mtl.scattering)
			append res #("scatter_color",       mtl.sss_color)
			append res #("scatter_depth",       mtl.sss_scale)
			append res #("scatter_ratio",       (mtl.sss_scatter_color * mtl.sss_depth))

			append res #("coat_weight",         mtl.coating)
			append res #("coat_color",          mtl.coat_color)
			append res #("coat_rough",          mtl.coat_roughness)
			append res #("coat_rough_inv",      mtl.coat_roughness_inv)
			append res #("coat_ior",            mtl.coat_ior)
			append res #("coat_affect_color",   mtl.coat_affect_color)
			append res #("coat_affect_rough",   mtl.coat_affect_roughness)
			append res #("coat_bump_amount",    mtl.clearcoat_bump_map_amt)


			append res #("brdf_mode",           mtl.brdf_mode)
			append res #("brdf_high",           mtl.brdf_high)
			append res #("brdf_low",            mtl.brdf_low)
			append res #("brdf_curve",          mtl.brdf_curve)

			append res #("thin_walled",         mtl.thin_walled)

			append res #("cutout", 1.0) -- default to Opaque
			

		    local emit = false
			
				
			if mtl.emission_map != undefined and mtl.emission_map_on do emit = true
			if mtl.emit_color_map != undefined and mtl.emit_color_map_on do emit = true

			append res #("emission_weight", mtl.emission)
			append res #("emission_filter", mtl.emit_color)

			if mtl.emission > 0.0 do emit = true

			if mtl.trans_depth > 0.0 and mtl.thin_walled == false then
			(
				append res #("trans_depth_inverse", 1.0 / mtl.trans_depth)
			)
			else
			(
				append res #("trans_depth_inverse", 0.0)
			)

			-- Effective luminance is computed by the plugin
			append res #("emission",     mtl.EffectiveLuminance)

			append res #("att:emissive", emit)
			
			-- print res
			
			res
		)
	)

	AMGData()	
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBfStxpJMM46GbYEPipf989t8bqRCbuyu3C
-- FBaxFYFThWyv+nLUFIdjcQlwP90m/DqX1XCBqLQ1srpSfFVl2kL+0PdN9yicG4KP
-- TeoaxqTyVvJBALOoGCFxxoCrWQLC3kMgRaOkHi8NX7+Oon/a+RdBdn3NPfU34s3f
-- csWRyAxswdVG5YJFmr1dY0ew8Udw+Gv/hvGDZVVvM8vNWcyQIwXfaLAygaJvY84H
-- 8GA3y7/0O9M+FNMip7BSb8Ea91naQWIelY1OLJQwwhkEdwv3HD9QQ+W4DRafYeD7
-- RjFzd/ofQIv02YMTffZXsCxdKRqfOoCwljKdYNAeVbTHb+qEPnkR
-- -----END-SIGNATURE-----