(
	-- Normal Bump
	struct AMGData
	(
		fn GetUUID mtl context =
		(	
			"637b9cdd-2908-454a-a8c9-ff9c98970637"
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			if mtl.normal_map != undefined and mtl.map1on do (
				append res #("normal_map", mtl.normal_map, "result", 0) -- reset context to zero - no longer bump evaluation!	

				local mapChannel = 1

				try (
					mapChannel = mtl.normal_map.coords.mapChannel
				)
				catch (
					mapChannel = 1
				)

				-- Environment mode cannot use varying attributes
				if (context != 2) do
				(
					append res #("utangent", undefined, "u_tangent_" + (mapChannel as String))
					append res #("vtangent", undefined, "v_tangent_" + (mapChannel as String))
				)
			)

			if mtl.bump_map != undefined and mtl.map2on do (
				append res #("additional_bump", mtl.bump_map, "normalPerturb", 1) 
			)

 			res
		),

		fn GetParams mtl context =
		(
			local res = #()	

			append res #("amount", mtl.mult_spin)
			append res #("normal_map", (point3 0.5 0.5 0.0))

			append res #("additional_amount", mtl.bump_spin)

			append res #("swap_rg", mtl.swap_rg)
			append res #("flip_r", mtl.flipred)
			append res #("flip_g", mtl.flipgreen)

 			res
		)
	)
	AMGData()
)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCgX9/dpzWyJLGjkxI7Y/FKs58ypXfAOQY8
-- 0s5IPw5A6MbVVcHHQGaTIR+0+KJyXBCM+UrgXfau2tW9pAe4Lbvh/xW8tqv+xbaX
-- IltmRs+Z3zD1D4TlyC7KsFutWOjUnpikPeIMTRiai/OBVc1rFjR51qNXFK38DIxg
-- IzWQ2naMMSWo+nKK8iwolcnvDnVI2om2MxBoHzDk2VqoaQeQMGFEixBpid63qL59
-- NEvhR0dFZgz+aX9PeAQY1UwBJlDG34d8qas6J8e3UILxYCyZzVOyAK6Ra+hf3SHk
-- SjySiSRiW/3OKG926AzSbXgap/6ioOp1z44gIE4R2FO3JcQtb2rJ
-- -----END-SIGNATURE-----