(
	-- RGB Multiply

    struct AMGData 
	(
		fn GetUUID mtl context = 
		(
			"129a5bfc-72e3-4e69-bc0f-7dcc5a2adf26"
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			local out = "result"
			if (context == 1) do out = "normalPerturb" -- bump mode
			
			if mtl.map1 != undefined and mtl.map1enabled do 
			(
				append res #("Color1", mtl.map1, out)
				append res #("Alpha1", mtl.map1, "alpha")
				append res #("Float1", mtl.map1, "resultFloat")
			)
			if mtl.map2 != undefined and mtl.map2enabled do 
			(
				append res #("Color2", mtl.map2, out)
				append res #("Alpha2", mtl.map2, "alpha")
				append res #("Float2", mtl.map2, "resultFloat")
			)

			append res #("UVW",      mtl.coords, "result")
			append res #("utangent", mtl.coords, "utangent") 
			append res #("vtangent", mtl.coords, "vtangent") 
			append res #("wtangent", mtl.coords, "wtangent") 

			res
		),

		fn GetParams mtl context = 
		(
			local res = #()	

			append res #("Color1", mtl.color1)
			append res #("Color2", mtl.color2)
			append res #("Alpha1", 1.0)
			append res #("Alpha2", 1.0)
			append res #("Float1", (mtl.color1.r+mtl.color1.g+mtl.color1.b)/768.0)
			append res #("Float2", (mtl.color2.r+mtl.color2.g+mtl.color2.b)/768.0)
			append res #("Map1on", mtl.map1 != undefined and mtl.map1enabled)
			append res #("Map2on", mtl.map2 != undefined and mtl.map2enabled)

			append res #("scale",     1.0/mtl.size)
			append res #("levels",    mtl.levels)
			append res #("lowThresh", mtl.thresholdLow)
			append res #("hiThresh",  mtl.thresholdHigh)
			append res #("type",      mtl.type)
			append res #("phase",     mtl.phase)

			-- Output parameters
			append res #( "invert",			mtl.output.invert)                   
			append res #( "clamp",			mtl.output.clamp )  
			append res #( "rgb_level",		mtl.output.RGB_Level )  
			append res #( "rgb_offset",		mtl.output.RGB_Offset )  
			append res #( "out_amount",		mtl.output.Output_Amount )  
			append res #( "bump_amount",	mtl.output.Bump_Amount)  
			append res #( "alpha_from_rgb",	mtl.output.alphaFromRGB)  
			append res #( "curves",			mtl,   "output" )  -- Attach and translate the "output" rollout
				
 			res
		)
	)
	AMGData()
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQA5dT3UHAlYg29CNzyBV1i69yjNkGRqvAJu
-- s/IaP4ESVhVGcq3GrYCwtFrpKyw7N0rqFHznaL+nHjhUzeJOxtzSVV81Qn3KmYAd
-- 9PB/ERanB8kukY3CP8dFTF3f2p+PJhS0ZKjTKa6ljs2mbM8++rWPY46qT+xL/RfH
-- FWIb+hKIcHo53aGEg4KmV7BpWDfEqx/bH/Tf94p2ddeV4VIixcRi+syeeLdlhf1F
-- YuZlqL1tsxxF+IKlvVuxhJtbAnCxKeUgCXbdvA5UFbTnwdE99JZBWxLr/CLg0S/X
-- bee4Hq7AcA2MVV2Nwe+8v2iSqozofF+YuTg6GpTIm6YDwiO3Z+fb
-- -----END-SIGNATURE-----