(
    -- MultiTile Texture: FULL IMPLEMENTATION
	-- 
	-- GetUUID() is the same as the one in CompositeTexturemap.ms, 
	-- means it reuses same graph definition of CompositeMap.
	-- In GetMaps(), replace the semantics with MultiTile methods,
	-- and set proper init values in GetParams()
	
	struct AMGData 
    (
        fn GetUUID mtl context =
        (
            "5d210056-f52c-4c17-8cba-0fef8f265f26"
        ),

        fn GetMaps mtl context =
        (
            local res = #()	
            
            local layer = mtl.tileCount() - (context / 256)
            local newContext = mod context 256

            local subLayer = mtl.getTileTexmap layer 

            if (subLayer != undefined) do
            (
				if (newContext == 1) then
				(
					-- Bump mode
					append res #("fg",           subLayer,  "normalPerturb", newContext) 
				)
				else
				(
					-- Regular mode, also attach alpha
					append res #("fg",           subLayer,  "result", newContext) 
					append res #("alpha",        subLayer,  "alpha",  newContext) 
				)
            )

            -- Recurseively append yourself
            if (layer > 1) do
            (
                append res #("bg",           mtl, "result", context + 256) 
				append res #("bgalpha",      mtl, "alpha", context + 256) 
            )

            res
        ),

        fn GetParams mtl context = 
        (
            local res = #()	

            append res #( "weight",   1.0)  
            append res #( "mode",	  0)  
            append res #( "mask",	  1.0)            -- Default
			append res #( "alpha",	  0.0)            -- Default
            append res #( "bg",	      (color 0 0 0))  -- Default
            append res #( "fg",	      (color 0 0 0))  -- Default

            res
        )
    )

    AMGData()
)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQARhWOL0GG0V5/lpaGiPe0JxiKTet+oSRS2
-- XFdD+vx9hyzSr1QS/mBRxJvpf74UKs0mxjcJjGSUoZW/M4vLhvi74ZYHTstx/4iw
-- 0j25RuZ2Z6eBqvWYD+LcaDo2cpBOgLtIQnOZjFpzIlZWBoe2B8jgHZlMrhMHXrqW
-- 6WzrHX/YtsVUIcARGY078uAOpzWMekLt6msT6a1aciPTqJC2pcR3Kiucoz9+L0Cc
-- FN7dLXw6V0KFMSUUHdC8567YcSky0o5+K9Z4niZmUFkBuTc20UZkcJ2+KDaP8N5y
-- p9e1Aaa5QpJwOz+q5pPv9orHEnjltHktwYo3xG1f4sHqx/+CestN
-- -----END-SIGNATURE-----