(
	-- Matte/Shadow/Reflection material
	--Currently implemented as a test w. ArchNDesign shader with matte-flag set only
	struct AMGData 
	(
		fn GetUUID mtl context =
		(
			"019b2fab-058c-4877-8d02-e6c4b20ebe8f"
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			if mtl.catch_reflections do (
				if mtl.refl_color_shader != undefined do 
					append res #("refl_color", mtl.refl_color_shader)
			)

			if mtl.bump != undefined do 
				append res #("normal_perturb", mtl.bump, "normalPerturb", 1)

			if mtl.bump_amount_shader != undefined and mtl.bump_amount_connected do 
				append res #("bump_amount", mtl.bump_amount_shader, "resultFloat")

			res
		),

		fn GetParams mtl context =
		(
			local res = #()	

			append res #("diffuse_weight", mtl.ambient_intensity)
			append res #("diffuse",        mtl.ambient)

			if mtl.catch_reflections do (
				append res #("reflectivity",      1.0)

				append res #("refl_use_ior",      false)
				append res #("refl_exponent",     5.0)
				append res #("refl_curve_low",    1.0)
				append res #("refl_curve_high",   1.0)


				append res #("refl_color",        mtl.refl_color)
				append res #("refl_gloss",        mtl.refl_glossiness)
				append res #("anisotropy",        1.0)
			)

			append res #("refr_ior",          1.4)
			append res #("cutout_opacity",    mtl.opacity)

			append res #("bump_amount",       mtl.bump_amount)

			append res #("att:matte", true) -- Enabled Matte Mode

			res
		)
	)

	AMGData()
)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCa7fLzVmiMWRvroevXAIrmy8p2BnKsQjmH
-- iJPPeTwJtX/8ISgv/HNGtTcD3bYYTjUt+cdrOa/LcaFXC2Kj10vywr2dqMATZdp6
-- h57DD2cCIBgQyd+tZ9Dxc6McS3I4ue29dVymI1FoCCeyquQZdfAbjlBYhqaT2ojW
-- OgrwdykbwTMPfZ6MY0k6gQwTiBfmsfbzqvbCFaPG7C3K2BhBL87DmVowLUstHLJa
-- z8rOiL0/0u4TB9YP/1drYDM5FTA872K2zGA6C5RUeb9SguBp7WXk0yREYyPbYHe8
-- VZ+5fbRoRQDuE6rOaLY96obML1qcdzyLFV0dWOdj+zQEhph8b/eA
-- -----END-SIGNATURE-----