(
	-- Color Correction Texture: FULL IMPLEMENTATION

    struct AMGData 
	(
		fn GetUUID mtl context =
		(
			"85518d3a-34a4-4967-9296-c279811bbf80" 
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			local out = "result"
			if (context == 1) do out = "normalPerturb" -- bump mode

			if (mtl.map != undefined) do
			(
				append res #("input",     mtl.map, out) 
				append res #("alpha",     mtl.map, "alpha") 
			)

			res
		),

		fn GetParams mtl context = 
		(
			local res = #()	

			append res #("input",     mtl.color) 
			append res #("alpha",     mtl.color.a/255.0) 

			append res #("RewireR", mtl.rewireR) 
			append res #("RewireG", mtl.rewireG) 
			append res #("RewireB", mtl.rewireB) 
			append res #("RewireA", mtl.rewireA) 

			append res #("hueShift", mtl.hueShift / 360.0) 
			append res #("saturation", 1.0 + (mtl.saturation / 100.0)) 

			append res #("tintHue", mtl.tint.h / 255.0)
			append res #("tintStrength", mtl.tintStrength / 100.0)  

			if (mtl.lightnessmode == 0) then
			(
				-- Regular mode

				local gain = 1.0 + mtl.contrast / 100.0;
				local lift = (mtl.brightness / 100.0) - 0.5 * (gain - 1.0)

				append res #("gainRGB", gain )
				append res #("liftRGB", lift )
				append res #("gammaRGB", 1.0 )
				append res #("pivotRGB", 1.0 )
				append res #("EnableR", false )
				append res #("EnableG", false )
				append res #("EnableB", false )
			)
			else
			(
				local gain = 1.0
				local lift = 0.0

				-- Gain math for Global
				gain = mtl.gainRGB / 100.0
				if (mtl.exposureMode == 1) do gain = pow 2.0 gain
				if (mtl.exposureMode == 2) do gain = pow mtl.printerLights gain
				append res #("gainRGB", gain )
				append res #("liftRGB", mtl.liftRGB)
				append res #("gammaRGB", 1.0 / mtl.gammaRGB )
				append res #("pivotRGB", mtl.pivotRGB )

				if (mtl.EnableR) do (
					-- Gain math for red override
					gain = mtl.gainR / 100.0
					if (mtl.exposureMode == 1) do gain = pow 2.0 gain
					if (mtl.exposureMode == 2) do gain = pow mtl.printerLights gain
					append res #("gainR", gain )
					append res #("liftR", mtl.liftR )
					append res #("gammaR", 1.0 / mtl.gammaR )
					append res #("pivotR", mtl.pivotR )
				)

				if (mtl.EnableG) do (
					-- Gain math for green override
					gain = mtl.gainG / 100.0
					if (mtl.exposureMode == 1) do gain = pow 2.0 gain
					if (mtl.exposureMode == 2) do gain = pow mtl.printerLights gain
					append res #("gainG", gain )
					append res #("liftG", mtl.liftG )
					append res #("gammaG", 1.0 / mtl.gammaG )
					append res #("pivotG", mtl.pivotG )
				)

				if (mtl.EnableB) do (
					-- Gain math for blue override
					gain = mtl.gainB / 100.0
					if (mtl.exposureMode == 1) do gain = pow 2.0 gain
					if (mtl.exposureMode == 2) do gain = pow mtl.printerLights gain
					append res #("gainB", gain )
					append res #("liftB", mtl.liftB )
					append res #("gammaB", 1.0 / mtl.gammaB )
					append res #("pivotB", mtl.pivotB )
				)

				append res #("EnableR", mtl.EnableR)
				append res #("EnableG", mtl.EnableG)
				append res #("EnableB", mtl.EnableB)
			)			

 			res
		)
	)

	AMGData()
)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCMO8K6BTaWM1375gQK25ytT7M2DhMSZuXP
-- HWemniUr/Ui2nAQSaExLUOaswNLU4UF0Im5fkvpFuM440tFERk7ikI4wUG6i2mjn
-- uG+tuyn3gaN3HnatrfyQIwxMy2Ra7sJJ5fwc/0nMtWy1DfJDVo2sJjlHljwxXTTC
-- rUPVdGeh7zDdg7aFalz6HfORVu8YONH4G6I7AYFbL+UTTnjX3DJFfrgWzvbW+mP+
-- YcorjMVpr+vMtkCN7e/ZSlZK2grQ70SuBqpVKMbOABB75uG7Foz7Z1cL9LDBYKI3
-- VN6fiai/nCCfhCr6WymLlyfQ6O0OGnEGI2Zj70CjkpE1PIlZb/U4
-- -----END-SIGNATURE-----