(
	-- Arch&Design Material

    struct AMGData
	(
		fn GetUUID mtl context = 
		(
			"15b1323b-7add-4998-8d52-acebedd81dea"
		)
		,
		fn GetMaps mtl context = 
		(
			local res = #()	

			if mtl.base_color_shader != undefined and mtl.base_color_connected do 
				append res #("base_color", mtl.base_color_shader)

			if mtl.diffuse_weight_shader != undefined and mtl.diffuse_weight_connected do 
				append res #("diffuse_weight",   mtl.diffuse_weight_shader, "resultFloat")

			if mtl.edge_color_shader != undefined and mtl.edge_color_connected do 
				append res #("pearl_color",      mtl.edge_color_shader)

			if mtl.edge_color_bias_shader != undefined and mtl.edge_color_bias_connected do 
				append res #("pearl_angle",      mtl.edge_color_bias_shader, "resultFloat")

			if mtl.lit_color_shader != undefined and mtl.lit_color_connected do 
				append res #("metal_color",      mtl.lit_color_shader)

			if mtl.spec_weight_shader != undefined and mtl.spec_weight_connected do 
				append res #("metal_weight",     mtl.spec_weight_shader, "resultFloat")

			if mtl.flake_color_shader != undefined and mtl.flake_color_connected do 
				append res #("flake_color",      mtl.flake_color_shader)

			if mtl.flake_density_shader != undefined and mtl.flake_density_connected do 
				append res #("flake_density",    mtl.flake_density_shader, "resultFloat") 

			if mtl.flake_scale_shader != undefined and mtl.flake_scale_connected do 
				append res #("flake_size",       mtl.flake_scale_shader, "resultFloat") 

			if mtl.reflection_color_shader != undefined and mtl.reflection_color_connected do 
				append res #("coat_color",       mtl.reflection_color_shader) 

			if mtl.reflection_edge_weight_shader != undefined and mtl.reflection_edge_weight_connected do 
				append res #("coat_high",        mtl.reflection_edge_weight_shader, "resultFloat") 

			if mtl.reflection_base_weight_shader != undefined and mtl.reflection_base_weight_connected do 
				append res #("coat_low",         mtl.reflection_base_weight_shader, "resultFloat") 

			if mtl.edge_factor_shader != undefined and mtl.edge_factor_connected do 
				append res #("coat_exponent",    mtl.edge_factor_shader, "resultFloat") 

			if mtl.dirt_color_shader != undefined and mtl.dirt_color_connected do 
				append res #("dirt_color",       mtl.dirt_color_shader) 

			if mtl.dirt_weight_shader != undefined and mtl.dirt_weight_connected do 
				append res #("dirt_mix",         mtl.dirt_weight_shader, "resultFloat") 

			res
		),

		fn GetParams mtl context =
		(
			local res = #()	

			append res #("base_color",       mtl.base_color)
			append res #("diffuse_weight",   mtl.diffuse_weight)
			append res #("pearl_color",      mtl.edge_color)
			append res #("pearl_mix",        1.0)
			append res #("pearl_angle",      mtl.edge_color_bias)

			append res #("metal_color",      mtl.lit_color)
			append res #("metal_weight",     mtl.spec_weight)
			append res #("metal_gloss",      mtl.lit_color_bias / 20.0) -- totally fudged

			append res #("flake_color",      mtl.flake_color)

			-- flake weight is completely non-physical in the mr shader and has to be fudged completely
			append res #("flake_weight",     mtl.flake_weight / 3.0)
			append res #("flake_gloss",      mtl.flake_exp / 100.0) -- totally fudged
			append res #("flake_perturb",    mtl.flake_strength / 10.0) 
			append res #("flake_density",    mtl.flake_density) 
			append res #("flake_size",       mtl.flake_scale) 

			append res #("coat_color",       mtl.reflection_color) 
			append res #("coat_high",        mtl.reflection_edge_weight) 
			append res #("coat_low",         mtl.reflection_base_weight) 
			append res #("coat_exponent",    mtl.edge_factor) 
			append res #("coat_gloss",       (1.0 - mtl.glossy_spread)) 

			append res #("dirt_color",       mtl.dirt_color) 
			append res #("dirt_mix",         mtl.dirt_weight) 

			res
		)
	)

	AMGData()	
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBOyzHToljs06UeZenZQyBuWrsz4JHHYYpv
-- PthufPHS2Es/vgTDcqhLxUinXYNn/pbf/sB5K6vTdAsc/8rSpmi/O+iZyaWxZkpz
-- gD3mm8xcNeYfP4YWoSXbEKEk8AYrUNjaIaaEyFxSTTGSLCa4ZiFy+T1uo7tPlXQH
-- wRQXM22SxHWvruA54DmkYCnLqesz/me06xn7Otn3Lm3A/2HjVTvgLoDcaMbeMJ1S
-- fOpe2fW7CGpaThVRgTkzRjFXPJ5UeMI+6UB8H0u7VJ1nGXtBLD3CdjaLL16xrTG7
-- aqZNqseO2bbhhlF6pI/Yrbi3wpMafvS2aGUEw34oq3O2yjhPSKf0
-- -----END-SIGNATURE-----