(
	-- Bitmap Texture

    struct AMGData 
	(
		fn GetUUID mtl context =
		(
			"b4321acb-05bf-449c-95f9-4b24240ade4f"
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			append res #("UV", mtl.coords) -- UVGenerator
			append res #("utangent", mtl.coords, "utangent") 
			append res #("vtangent", mtl.coords, "vtangent") 
			append res #("visible",  mtl.coords, "visible") 

			res
		),

		fn GetParams mtl context = 
		(
			local res = #()	

			append res #( "rgb_source",		    mtl.rgbOutput == 1 )  
			append res #( "mono_source",		mtl.monoOutput == 1 )  
			append res #( "alpha_source",		mtl.alphaSource == 1 )  
			append res #( "output_alpha",		mtl.alphaSource < 2 )  
			
			append res #( "apply",				mtl.apply)  
			append res #( "place",				mtl.cropPlace == 1)  
			append res #( "u",					mtl.ClipU)  
			append res #( "v",					mtl.ClipV)  
			append res #( "w",					mtl.ClipW)  
			append res #( "h",					mtl.ClipH)  
			append res #( "random",				mtl.useJitter)  
			append res #( "jitter",				mtl.Jitter)  

			append res #("Bitmap", mtl, "bitmap")

			-- Output parameters
			append res #( "invert",			mtl.output.invert)                   
			append res #( "clamp",			mtl.output.clamp )  
			append res #( "rgb_level",		mtl.output.RGB_Level )  
			append res #( "rgb_offset",		mtl.output.RGB_Offset )  
			append res #( "out_amount",		mtl.output.Output_Amount )  
			append res #( "bump_amount",	mtl.output.Bump_Amount)  
			append res #( "alpha_from_rgb",	mtl.output.alphaFromRGB)  
			append res #( "curves",			mtl,   "output" )  -- Attach and translate the "output" rollout

 			res
		)
	)

	AMGData()
)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQA3HtgZ5SV4YQt7YGF3Qv7BxfCSl+kKOZwA
-- Omx3WI+h94JbF70L5COtiyf6/A1wUD74AfcONC1QyHvg1BvM+ltP0gxI1zgTh7no
-- 6vORrMhtG/xvUzr7vaJ60uiuFx62zB1MN0DJipEREPD0SY+HXjAJcuJwf3OGJ+Ad
-- JSAPrz0yYVtqx/VJSLAjljrVR1mA1Lw12UILeRLg50BSQ5rWD2d4floja0NhEjO3
-- hPHFlOvm990E9jO1V7XEsm2Qqt0NbFbFfcYv1bRoyOL/YXYVGAr6LgXlAuQdVIUx
-- 4vGwM5ug72+YjLzaU1gUKStVLx8yc0zoroaIAZLynT9XSjKR4E2m
-- -----END-SIGNATURE-----