(
	-- Autodesk Material

    struct AMGData
	(
		fn GetUUID mtl context = 
		(
			local res = undefined

			-- Car Paint treated specially

			case mtl.basetype of 
			(
				"Metallic Paint" :
				(
					-- "Metallic Paint" graph
					res = "15b1323b-7add-4998-8d52-acebedd81dea"
				)
				default : (
					-- Everything else use the "Generic" graph
					res = "8f3f1eed-dc94-4b18-a30c-217d9c7f8c75"
				)
			)
		
			res
		)
		,
		fn GetMaps input context = 
		(
			local res = #()	
			local mtl = input
			local org = mtl -- remember original

			case mtl.basetype of 
			(
				"Metallic Paint" : 	-- Car Paint treated specially
				(
					if mtl.Metallic_Paint_Color_Map != undefined and mtl.Metallic_Paint_Color_Option == 1 do (
						append res #("base_color",   mtl.Metallic_Paint_Color_Map )
					)
				)
				"Glazing" : -- Glazing treated specially
				(
					if mtl.Glazing_Custom_Color_Map != undefined and mtl.Glazing_Color == 6 and mtl.Glazing_Custom_Color_Option == 1 do
						append res #("refr_color_map",  mtl.Glazing_Custom_Color_Map)
				)
				"Solid Glass" : -- Solid Glass treated specially
				(
					if mtl.Solid_Glass_Custom_Color_Map != undefined and mtl.Solid_Glass_Color == 6 and mtl.Solid_Glass_Custom_Color_Option == 1 do
						append res #("refr_color_map",  mtl.Solid_Glass_Custom_Color_Map)
					if mtl.Relief_Pattern_Enable do (
						-- We steal the bump map from the Generic conversion
						local bumpmap = mtl.ConvertToGeneric.Bump_Image
						if bumpmap != undefined do
							append res #("normal_perturb",  bumpmap, "normalPerturb", 1)
					)
				)
				default : -- everything else converts to "Generic"
				(
					-- Slow - but will work
					if mtl.basetype != "Generic" do
						mtl = mtl.ConvertToGeneric 

					try(	
						if mtl.Generic_Image != undefined do (
							append res #("diffuse_map",   mtl.Generic_Image)
							append res #("diffuse_alpha", mtl.Generic_Image, "alpha")
						)

						if mtl.Reflectivity_Enable do
						(
							if mtl.Generic_Glossiness_Option == 1 and mtl.Generic_Glossiness_Map != undefined do
								append res #("refl_gloss",      mtl.Generic_Glossiness_Map, "resultFloat")

							if mtl.Reflectivity_Direct_Option == 1 and mtl.Reflectivity_Direct_Map != undefined do
								append res #("refl_curve_low",  mtl.Reflectivity_Direct_Map, "resultFloat")

							if mtl.Reflectivity_Oblique_Option == 1 and mtl.Reflectivity_Oblique_Map != undefined do
								append res #("refl_curve_high", mtl.Reflectivity_Oblique_Map, "resultFloat")
						)

						if mtl.Transparency_Enable do
						(
							if mtl.Transparency_Image != undefined do
								append res #("refr_color_map",  mtl.Transparency_Image)
						)

						if mtl.Bump_Enable do
						(
							if mtl.Bump_Image != undefined do
								append res #("normal_perturb",  mtl.Bump_Image, "normalPerturb", 1)
							if mtl.Bump_Amount_Option == 1 do
								append res #("bump_amount",     mtl.Bump_Amount_Map, "resultFloat")
						)

						if mtl.Cutouts_Enable and mtl.Cutouts_Image != undefined do
							append res #("cutout_opacity", mtl.Cutouts_Image, "resultFloat")

						if mtl.Self_Illumination_Enable and mtl.Self_Illumination_Filter_Color_Option == 1 and mtl.Self_Illumination_Filter_Color_Map != undefined do
							append res #("emission_filter", mtl.Self_Illumination_Filter_Color_Map)
					)
					catch()
				)
			)

			res
		),

		fn GetParams input context =
		(
			local res = #()	
			local mtl = input
			local org = mtl -- remember original

			case mtl.basetype of 
			(
				"Metallic Paint":  	-- Car Paint treated specially
				(
					try (
						append res #("base_color",       mtl.Metallic_Paint_Color)
						append res #("diffuse_weight",   0.8)

						if (mtl.Pearl_Enable) then
						(
							if (mtl.Pearl_Type == 2) then
							(
								append res #("pearl_color",      mtl.Pearl_Color)
							)
							else
							(
								-- Build the slighgly darker, more saturated version of the color
								local c = mtl.Metallic_Paint_Color
								local pearl = (color ((pow (c.r / 300.0) 5) * 255) ((pow (c.g / 300.0) 5) * 255) 	((pow (c.b / 300.0) 5) * 255) )
								append res #("pearl_color",      pearl)
							)

							append res #("pearl_mix",        mtl.Pearl_Amount / 100.0)
							append res #("pearl_angle",      1.5 - (mtl.Pearl_Blend / 100.0))
						)
						else
						(
							append res #("pearl_mix",        0.0)
						)

						append res #("metal_color",      mtl.Metallic_Paint_Color)
						append res #("metal_weight",     0.25) -- guesstimate
						append res #("metal_gloss",      1.0 - (mtl.Metallic_Paint_Highlight_Spread / 100.0)) -- totally fudged

						if (mtl.Flecks_Enable) then
						(
							append res #("flake_color",      mtl.Flecks_Color)

							append res #("flake_weight",     0.1)
							append res #("flake_gloss",      0.5) 
							append res #("flake_perturb",    0.15) 
							append res #("flake_density",    10.0) 
							append res #("flake_size",       mtl.Flecks_Size / 100.0) 
						)
						else
						(
							append res #("flake_weight",     0.0)
						)

						case (mtl.Top_Coat_Type) of
						(
							0: (
								append res #("coat_color",       (color 255 255 255)) 
								append res #("coat_high",        1.0) 
								append res #("coat_low",         0.2) 
								append res #("coat_exponent",    5.0) 
								append res #("coat_gloss",       1.0) 
							)
							1: (
								append res #("coat_color",       (color 255 255 255)) 
								append res #("coat_high",        1.0) 
								append res #("coat_low",         0.6) 
								append res #("coat_exponent",    5.0) 
								append res #("coat_gloss",       1.0) 
							)
							2: (
								append res #("coat_color",       (color 255 255 255)) 
								append res #("coat_high",        1.0) 
								append res #("coat_low",         0.2) 
								append res #("coat_exponent",    5.0) 
								append res #("coat_gloss",       0.5) 
							)
							3: (
								append res #("coat_color",       (color 255 255 255)) 
								append res #("coat_high",        1.0) 
								append res #("coat_low",         1.0 - (mtl.Top_Coat_Angle_Falloff / 100.0)) 
								append res #("coat_exponent",    5.0) 
								append res #("coat_gloss",       mtl.Top_Coat_Glossiness / 100.0) 
							)

						)

						if (mtl.Top_Coat_Finish == 1) then
						(
							append res #("orange_peel_on",       true) 
							append res #("orange_peel_amount",   mtl.Top_Coat_Amount / 100.0)
							append res #("orange_peel_scale",    1.0) 
						)
						else
						(
							append res #("orange_peel_on",       false) 
						)

						append res #("dirt_mix",         0.0) 
					)
					catch ()
				)
				"Glazing" : -- Glazing treated specially
				(
					try(
						append res #("diffuse",        (color 0 0 0))
						append res #("diffuse_weight", 0.0)
						append res #("diffuse_alpha",  1.0)

						append res #("anisotropy",     1.0)

						append res #("refl_is_metal",  false)

						append res #("reflectivity",  1.0 / mtl.Glazing_Sheets_of_Glass)
						append res #("refl_color",    (color 255 255 255))
						append res #("refl_exponent", 5.0)

						append res #("refl_gloss",      1.0)
						append res #("refl_curve_low",  mtl.Glazing_Reflectance / 100.0) 
						append res #("refl_curve_high", 1.0)

						local glazecolor = (point3 1.0 1.0 1.0)

						case mtl.Glazing_Color of (
							0: glazecolor = (point3 0.858 0.893 0.879)
							1: glazecolor = (point3 0.676 0.797 0.737)
							2: glazecolor = (point3 0.451 0.459 0.472)
							3: glazecolor = (point3 0.367 0.514 0.651)
							4: glazecolor = (point3 0.654 0.788 0.772)
							5: glazecolor = (point3 0.583 0.516 0.467)
							6: glazecolor = mtl.Glazing_Custom_Color
						)

						local b = 1.0 / mtl.Glazing_Sheets_of_Glass

						glazecolor.x = pow glazecolor.x b
						glazecolor.y = pow glazecolor.y b
						glazecolor.z = pow glazecolor.z b

						append res #("transparency",  1.0)
						append res #("refr_color",    (color (glazecolor.x*255) (glazecolor.y*255) (glazecolor.x*255)))

						append res #("refr_gloss",      1.0)

						append res #("refr_color_mix",  0.0)
			
						append res #("cutout_opacity", 1.0) -- default to Opaque
						append res #("refr_ior",	   1.0) -- Glazing is faked as see-through  
					)
					catch()
				)
				"Solid Glass" : -- Solid Glass treated specially
				(
					try(
						append res #("diffuse",        (color 0 0 0))
						append res #("diffuse_weight", 0.0)
						append res #("diffuse_alpha",  1.0)

						append res #("anisotropy",     1.0)

						append res #("refl_is_metal",  false)

						append res #("reflectivity",  1.0)
						append res #("refl_color",    (color 255 255 255))
						append res #("refl_exponent", 5.0)

						append res #("refl_gloss",      1.0)
						append res #("refl_curve_low",  mtl.Solid_Glass_Reflectance / 100.0) 
						append res #("refl_curve_high", 1.0)

						local glazecolor = (point3 1.0 1.0 1.0)

						case mtl.Solid_Glass_Color of (
							0: glazecolor = (point3 0.858 0.893 0.879)
							1: glazecolor = (point3 0.676 0.797 0.737)
							2: glazecolor = (point3 0.451 0.459 0.472)
							3: glazecolor = (point3 0.367 0.514 0.651)
							4: glazecolor = (point3 0.654 0.788 0.772)
							5: glazecolor = (point3 0.583 0.516 0.467)
							6: glazecolor = mtl.Glazing_Custom_Color
						)

						if mtl.Relief_Pattern_Enable then
						(
							append res #("bump_amount",  mtl.Relief_Pattern_Amount)
						)
						else
						(
							append res #("bump_amount",  0.0)
						)

						append res #("transparency",    1.0)
						append res #("refr_color",      (color (glazecolor.x*255) (glazecolor.y*255) (glazecolor.x*255)))

						append res #("refr_gloss",      1.0 - mtl.Solid_Glass_Roughness)

						append res #("refr_color_mix",  0.0)
			
						append res #("cutout_opacity",  1.0) -- default to Opaque
						append res #("refr_ior",	    mtl.Solid_Glass_Refraction) 
					)
					catch()
				)
				default : -- Everything else converts to "Generic"
				(
					-- Slow - but will work
					if mtl.basetype != "Generic" do
						mtl = input.ConvertToGeneric 

					try(
						append res #("diffuse",        mtl.Generic_Color)
						append res #("diffuse_weight", 1.0)
						append res #("diffuse_alpha", 1.0)

						if mtl.Generic_Image != undefined do
							append res #("diffuse_mix", mtl.Generic_Image_Fade / 100.0)

						append res #("anisotropy",     1.0)

						append res #("refl_is_metal",  mtl.Generic_Highlights)

						if mtl.Reflectivity_Enable then
						(
							append res #("reflectivity",  1.0)
							append res #("refl_color",    (color 255 255 255))
							append res #("refl_exponent", 5.0)

							append res #("refl_gloss",      mtl.Generic_Glossiness   / 100.0)
							append res #("refl_curve_low",  mtl.Reflectivity_Direct  / 100.0)
							append res #("refl_curve_high", mtl.Reflectivity_Oblique / 100.0)
						)
						else
						(
							append res #("reflectivity",  0.0)
						)

						if mtl.Transparency_Enable then
						(
							append res #("transparency",  mtl.Transparency_Amount / 100.0)
							append res #("refr_color",    (color 255 255 255))

							append res #("refr_gloss",      1.0)

							if mtl.Transparency_Image != undefined do
								append res #("refr_color_mix",      mtl.Transparency_Image_Fade / 100.0)
						)
						else
						(
							append res #("transparency",  0.00)
						)


						if mtl.Bump_Enable then
						(
							append res #("bump_amount",  mtl.Bump_Amount / 100.0)
						)
						else
						(
							append res #("bump_amount",  0.0)
						)


						if mtl.Self_Illumination_Enable and mtl.Self_Illumination_Luminance > 0.0 then
						(
							-- TODO: THIS IS NOT EXACT, we need to get the physical scale from max some other way
							-- a maxscript exported function would be more future-proof
							local physical_scale = 1500

							local p = SceneExposureControl.exposureControl

							if p != undefined do (
								physical_scale = p.physical_scale

								if ClassOf p == mr_Photographic_Exposure_Control do 
								(
									if p.physical_scale_mode == 0 do physical_scale = 3.141592654
								)

								if ClassOf p == Physical_Camera_Exposure_Control do 
								(
									if p.physical_scale_mode == 0 do physical_scale = 1.0
								)
							)

							local x = mtl.Self_Illumination_Luminance * 3.1415 / physical_scale
							append res #("emission",  (ConvertKelvinToRGB mtl.Self_Illumination_Color_Temperature x))
							append res #("emission_filter",   mtl.Self_Illumination_Filter_Color)
							append res #("att:emissive", true)
						)
						else
						(
							append res #("emission",  (color 0 0 0))
							append res #("att:emissive", false)
						)


						append res #("cutout_opacity", 1.0) -- default to Opaque
						append res #("refr_ior",		mtl.Transparency_Refraction) 

						if hasProperty org "Wood_Stain" then (
							try (
								if org.Wood_Stain == 1 then 
								(
									append res #("tint", org.Wood_Stain_Color) -- Wood tint
								)
								else
								(
									append res #("tint", (color 255 255 255)) -- no tint by default
								)
							)
							catch 
							(
								append res #("tint", (color 255 255 255)) -- no tint by default
							)
						)
						else
						(
							append res #("tint", (color 255 255 255)) -- no tint by default
						)
					)
					catch()
				)
			)

			res
		)
	)

	AMGData()	
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAGA+sEn1t21q5H2kwxs9g0x2TNvd4qow98
-- gD09/pbu07eKt/vnBrP6CsL8Rx/HmXV/6kkPCr5V3OwqgB0Ckvv3TrNahyuuJP65
-- u2AgvP4G8Wy3YE6gmfqBoFMsEBoGmnrEotqwftmDYj1aVmehD5W2eBXnOFcWtQFD
-- Bm10TBTpQRnOwSiaPsamkK5I/tLXYfmEews+9H0UwFsmFXDQm3QxOYw/qBHFQeib
-- k11uxHYNzWLGRUMl2JZkb6g721mFqDjRfl6Wtpnt3w16qH+sH4M3bRRgxCg5YD4q
-- DwrOKaUbyb4dFz/PLwEFoT1/0sJugn/8+/zy68Lpw9Vw027eFIes
-- -----END-SIGNATURE-----