(
	-- Autodesk Map (only "Bitmap" supported currently)

    struct AMGData 
	(
		fn GetUUID mtl context =
		(
			case mtl.basetype of 
			(
				"Bitmap" : (
					"d21c6827-57cb-4bb5-86a6-ace0e02f6646" 
				)
				"Noise" : (
					"6435caa8-affa-4e68-b7d3-e768ca5cadeb"
				)
				default : (
					-- TODO: Fallback to "Bitmap"
					-- And it will attempt to bake it....
					undefined
				)
			)
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			try (
				case mtl.basetype of 
				(
					"Bitmap" : (
						append res #("uvw",      undefined, "uvw_"       + (mtl.Advanced_Parameters_Map_Channel as String))
						append res #("utangent", undefined, "u_tangent_" + (mtl.Advanced_Parameters_Map_Channel as String))
						append res #("vtangent", undefined, "v_tangent_" + (mtl.Advanced_Parameters_Map_Channel as String))
					)
					"Noise" : (
						local out = "result"
						if (context == 1) do out = "normalPerturb" -- bump mode
			
						if mtl.Appearance_Color_1_Map != undefined and mtl.Appearance_Color_1_Option==1 do 
						(
							append res #("Color1", mtl.Appearance_Color_1_Map, out)
							append res #("Alpha1", mtl.Appearance_Color_1_Map, "alpha")
							append res #("Float1", mtl.Appearance_Color_1_Map, "resultFloat")
						)
						if mtl.Appearance_Color_2_Map != undefined and mtl.Appearance_Color_2_Option==1 do 
						(
							append res #("Color2", mtl.Appearance_Color_2_Map, out)
							append res #("Alpha2", mtl.Appearance_Color_2_Map, "alpha")
							append res #("Float2", mtl.Appearance_Color_2_Map, "resultFloat")
						)
					)
				)
			)
			catch (
				-- Do nothing in particular, this is normal
				print "GetMaps Failed"
				print mtl
				print res
				showProperties mtl
			)

			res
		),

		fn GetParams mtl context = 
		(
			local res = #()	
			local mtx = matrix3 1

			-- Accessing mtl.bitmap causes an MXS exception if the file cannot be found!!
			try (
				case mtl.basetype of 
				(
					"Bitmap" : (
						append res #("Bitmap",     mtl, "Parameters_Source")

						append res #("out_amount", mtl.Parameters_Brightness / 100.0)
						append res #("invert",     mtl.Parameters_Invert_Image)
						append res #("blur",       mtl.Advanced_Parameters_Blur)
						append res #("blurOffs",   mtl.Advanced_Parameters_Blur_Offset)

						append res #("utile",      mtl.Repeat_Horizontal)
						append res #("vtile",      mtl.Repeat_Vertical)

						local  mtx_rot   = RotateZMatrix -mtl.Position_Rotation
						local  mtx_scale = ScaleMatrix (Point3 mtl.Scale_Width  mtl.Scale_Height  1.0)
						local  mtx_move  = TransMatrix (Point3 mtl.Position_X   mtl.Position_Y    1.0)

						mtx = inverse (mtx_rot * mtx_scale * mtx_move)

						append res #("UVTransform",        mtx)
						append res #("TangentTransform",   mtx_rot)
					)
					"Noise" : (
						append res #("Color1", mtl.Appearance_Color_1)
						append res #("Color2", mtl.Appearance_Color_2)
						append res #("Alpha1", 1.0)
						append res #("Alpha2", 1.0)
						append res #("Float1", (mtl.Appearance_Color_1.r+mtl.Appearance_Color_1.g+mtl.Appearance_Color_1.b)/768.0)
						append res #("Float2", (mtl.Appearance_Color_2.r+mtl.Appearance_Color_2.g+mtl.Appearance_Color_2.b)/768.0)
						append res #("Map1on", mtl.Appearance_Color_1_Map != undefined and mtl.Appearance_Color_1_Option==1)
						append res #("Map1on", mtl.Appearance_Color_2_Map != undefined and mtl.Appearance_Color_2_Option==1)

						append res #("type",      mtl.Appearance_Noise_Type)
						append res #("scale",     1.0/mtl.Appearance_Size)

						append res #("levels",    mtl.Noise_Threshold_Levels)
						append res #("lowThresh", mtl.Noise_Threshold_Low)
						append res #("hiThresh",  mtl.Noise_Threshold_High)
						append res #("phase",     mtl.Noise_Threshold_Phase)

						local UVTransform = transMatrix (point3 mtl.Position_X mtl.Position_Y mtl.Position_Z)

						UVTransform *= rotateXmatrix mtl.Position_XYZ_Rotation.x
						UVTransform *= rotateYmatrix mtl.Position_XYZ_Rotation.y
						UVTransform *= rotateZmatrix mtl.Position_XYZ_Rotation.z

						append res #("UVTransform", UVTransform)
						append res #("TangentTransform", orthogonalize(copy UVTransform))

					)
				)
			)
			catch (
				-- Do nothing in particular, this is normal
				print "GetParams Failed"
				print mtl
				print res
				showProperties mtl
			)

 			res
		)
	)

	AMGData()
)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBNlc2X+loJoM1dnedPPco/3rw0+6w8VXPh
-- UXUMrS5s9aZDop/CbXqq24wtAUkhNXrDwKcIlorKghiLr+mxMpO2Kfyi2R14a+nn
-- 3q8SLZogY7+uA24gF35Ey83yQJ5vSzznEkubaDagQ+IBaLQoLxo4uwBwKbupsdNY
-- 8mr7WQWNuUOdaJY8Z57PzsGfwcJ3MLTx+yikBroZ7YUxXWnrBLQcOPV+NjthV2Zb
-- cTXcQTaTYNOsPXcTs1Uk4nk7KOLz1Qqe2ZNkfGXweAVP/PwtamqohQrU0j/8F0pq
-- 6w/9ZsgO7FtDkZqpn4mzzCYhgxNaJTJwB2a76X+YlsGAFjX4NbfP
-- -----END-SIGNATURE-----