(
	-- Arch&Design Material

    struct AMGData
	(
		fn GetUUID mtl context = 
		(
			"019b2fab-058c-4877-8d02-e6c4b20ebe8f"
		)
		,
		fn GetMaps mtl context = 
		(
			local res = #()	

			if mtl.diffuse_weight > 0 do (
				if mtl.diff_color_map != undefined and mtl.diff_color_map_on do 
					append res #("diffuse", mtl.diff_color_map)
				if mtl.diff_rough_map != undefined and mtl.diff_rough_map_on do 
					append res #("diffuse_roughness", mtl.diff_rough_map, "resultFloat")
			)

			if mtl.refl_weight > 0 do (
				if mtl.refl_color_map != undefined and mtl.refl_color_map_on do 
					append res #("refl_color", mtl.refl_color_map)
				if mtl.refl_gloss_map != undefined and mtl.refl_gloss_map_on do 
					append res #("refl_gloss", mtl.refl_gloss_map, "resultFloat")

				if mtl.anisotropy_map != undefined and mtl.anisotropy_map_on do 
					append res #("anisotropy",  mtl.anisotropy_map, "resultFloat")
				if mtl.anisoangle_map != undefined and mtl.anisoangle_map_on do 
					append res #("angle",       mtl.anisoangle_map, "resultFloat")

				if mtl.aniso_mode == 1 do 
				(
					append res #("utangent", undefined, "u_tangent_" + (mtl.aniso_channel as String))
					append res #("vtangent", undefined, "v_tangent_" + (mtl.aniso_channel as String))
				)
			)

			if mtl.refr_weight > 0 do (
				if mtl.refr_color_map != undefined and mtl.refr_color_map_on do 
					append res #("refr_color", mtl.refr_color_map)
				if mtl.refl_gloss_map != undefined and mtl.refl_gloss_map_on do 
					append res #("refr_gloss", mtl.refr_gloss_map, "resultFloat")

				if mtl.refr_trans_on do (
					if mtl.refr_transc_map != undefined and mtl.refr_transc_map_on do 
						append res #("refr_transc", mtl.refr_transc_map)
					if mtl.refr_transw_map != undefined and mtl.refr_transw_map_on do 
						append res #("refr_transw", mtl.refr_transw_map, "resultFloat")
				)
			)

			if mtl.refr_ior_map != undefined and mtl.refr_ior_map_on do 
				append res #("refr_ior", mtl.refr_ior_map, "resultFloat")

			if mtl.bump_map != undefined and mtl.bump_map_on do 
				append res #("normal_perturb", mtl.bump_map, "normalPerturb", 1)

			if mtl.self_illum_on and mtl.self_illum_map != undefined and mtl.self_illum_map_on do 
				append res #("emission_filter", mtl.self_illum_map)
			if mtl.cutout_map != undefined and mtl.cutout_map_on do 
				append res #("cutout_opacity", mtl.cutout_map, "resultFloat")

			if mtl.add_color_map != undefined  and mtl.add_color_map_on do 
				append res #("additional_color", mtl.add_color_map)

			res
		),

		fn GetParams mtl context =
		(
			local res = #()	

			append res #("diffuse",           mtl.diff_color)
			append res #("diffuse_weight",    mtl.diff_weight)
			append res #("diffuse_roughness", mtl.diff_rough)

			append res #("reflectivity",      mtl.refl_weight)
			if mtl.refl_weight > 0 do (
				append res #("refl_use_ior",      mtl.refl_func_fresnel)
				append res #("refl_exponent",     mtl.refl_func_curve)
				append res #("refl_curve_low",    mtl.refl_func_low)
				append res #("refl_curve_high",   mtl.refl_func_high)

				append res #("refl_color",        mtl.refl_color)
				append res #("refl_gloss",        mtl.refl_gloss)
				append res #("refl_is_metal",     mtl.refl_metal)
				append res #("anisotropy",        mtl.anisotropy)
				append res #("angle",             mtl.anisoangle)
			)

			append res #("thin_walled",       mtl.opts_1sided)

			append res #("transparency",      mtl.refr_weight) 
			if mtl.refr_weight > 0.0 do (
				append res #("refr_color",        mtl.refr_color)
				append res #("refr_gloss",        mtl.refr_gloss)

				if mtl.refr_trans_on do (
					append res #("refr_transc",  mtl.refr_transc)
					append res #("refr_transw",  mtl.refr_transw)
				)
			)

			append res #("refr_ior",          mtl.refr_ior)

			local emit = false

			if mtl.self_illum_on then (
				append res #("emission_filter",  mtl.self_illum_color_filter)
				append res #("emission",         mtl.EffectiveSelfIllum)
				emit = true
			)
			else
			(
				append res #("emission",  (color 0 0 0))
			)

			if mtl.add_color_map != undefined  and mtl.add_color_map_on do (
				emit = true
			)

			append res #("att:emissive", emit) 

			append res #("no_diffuse_bump",  mtl.no_diffuse_bump)

			append res #("bump_amount",      mtl.bump_map_amt)

			append res #("cutout_opacity", 1.0) -- default to Opaque

			res
		)
	)

	AMGData()	
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCgE/0K/Op2oDss+r1YE3omjj+TW5U+Uz6/
-- sWIVkdAyf2Tes03NzDdQlUutlICvEubmGXpbxwYw1oYnC3bBV0h1XPWIif7fGMm0
-- a95TUa5TPcCOuQEHfa3NpTJxK53/9DwCKNGtlZynuBcEKqnS7FKWjlIKr2lEYPWt
-- AbzVRMrY+7XpiygiEgCuxlQYWFGxK+oMxqGa4ynJBtyrQnDjC5GdZPz11ffTKU5X
-- p9n9fwfs32zJY27Y/jITIDWXgRS67dqIrtkEFfn8MJs4PmgeHzX1a5DezK690Hu+
-- YxGvD8NGt/nx4SyXAYDtEXRkSxW+SznsrAHw0AjiAlfRX9aU//zG
-- -----END-SIGNATURE-----