﻿//
// BIM IFC export alternate UI library: this library works with Autodesk(R) Revit(R) to provide an alternate user interface for the export of IFC files from Revit.
// Copyright (C) 2013  Autodesk, Inc.
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Revit.IFC.Common.Enums.IFC2x
{
    /// <summary>
    /// IFC entity types.
    /// </summary>
    public enum IFCEntityType
    {
        Ifc2DCompositeCurve,
        IfcActionRequest,
        IfcActor,
        IfcActorRole,
        IfcActuatorType,
        IfcAddress,
        IfcAirTerminalBoxType,
        IfcAirTerminalType,
        IfcAirToAirHeatRecoveryType,
        IfcAlarmType,
        IfcAngularDimension,
        IfcAnnotation,
        IfcAnnotationCurveOccurrence,
        IfcAnnotationFillArea,
        IfcAnnotationFillAreaOccurrence,
        IfcAnnotationOccurrence,
        IfcAnnotationSurface,
        IfcAnnotationSurfaceOccurrence,
        IfcAnnotationSymbolOccurrence,
        IfcAnnotationTextOccurrence,
        IfcApplication,
        IfcAppliedValue,
        IfcAppliedValueRelationship,
        IfcApproval,
        IfcApprovalActorRelationship,
        IfcApprovalPropertyRelationship,
        IfcApprovalRelationship,
        IfcArbitraryClosedProfileDef,
        IfcArbitraryOpenProfileDef,
        IfcArbitraryProfileDefWithVoids,
        IfcAsset,
        IfcAsymmetricIShapeProfileDef,
        IfcAxis1Placement,
        IfcAxis2Placement2D,
        IfcAxis2Placement3D,
        IfcBSplineCurve,
        IfcBeam,
        IfcBeamType,
        IfcBezierCurve,
        IfcBlobTexture,
        IfcBlock,
        IfcBoilerType,
        IfcBooleanClippingResult,
        IfcBooleanResult,
        IfcBoundaryCondition,
        IfcBoundaryEdgeCondition,
        IfcBoundaryFaceCondition,
        IfcBoundaryNodeCondition,
        IfcBoundaryNodeConditionWarping,
        IfcBoundedCurve,
        IfcBoundedSurface,
        IfcBoundingBox,
        IfcBoxedHalfSpace,
        IfcBuilding,
        IfcBuildingElement,
        IfcBuildingElementComponent,
        IfcBuildingElementPart,
        IfcBuildingElementProxy,
        IfcBuildingElementProxyType,
        IfcBuildingElementType,
        IfcBuildingStorey,
        IfcCShapeProfileDef,
        IfcCableCarrierFittingType,
        IfcCableCarrierSegmentType,
        IfcCableSegmentType,
        IfcCalendarDate,
        IfcCartesianPoint,
        IfcCartesianTransformationOperator,
        IfcCartesianTransformationOperator2D,
        IfcCartesianTransformationOperator2DnonUniform,
        IfcCartesianTransformationOperator3D,
        IfcCartesianTransformationOperator3DnonUniform,
        IfcCenterLineProfileDef,
        IfcChamferEdgeFeature,
        IfcChillerType,
        IfcCircle,
        IfcCircleHollowProfileDef,
        IfcCircleProfileDef,
        IfcClassification,
        IfcClassificationItem,
        IfcClassificationItemRelationship,
        IfcClassificationNotation,
        IfcClassificationNotationFacet,
        IfcClassificationReference,
        IfcClosedShell,
        IfcCoilType,
        IfcColourRgb,
        IfcColourSpecification,
        IfcColumn,
        IfcColumnType,
        IfcComplexProperty,
        IfcCompositeCurve,
        IfcCompositeCurveSegment,
        IfcCompositeProfileDef,
        IfcCompressorType,
        IfcCondenserType,
        IfcCondition,
        IfcConditionCriterion,
        IfcConic,
        IfcConnectedFaceSet,
        IfcConnectionCurveGeometry,
        IfcConnectionGeometry,
        IfcConnectionPointEccentricity,
        IfcConnectionPointGeometry,
        IfcConnectionPortGeometry,
        IfcConnectionSurfaceGeometry,
        IfcConstraint,
        IfcConstraintAggregationRelationship,
        IfcConstraintClassificationRelationship,
        IfcConstraintRelationship,
        IfcConstructionEquipmentResource,
        IfcConstructionMaterialResource,
        IfcConstructionProductResource,
        IfcConstructionResource,
        IfcContextDependentUnit,
        IfcControl,
        IfcControllerType,
        IfcConversionBasedUnit,
        IfcCooledBeamType,
        IfcCoolingTowerType,
        IfcCoordinatedUniversalTimeOffset,
        IfcCostItem,
        IfcCostSchedule,
        IfcCostValue,
        IfcCovering,
        IfcCoveringType,
        IfcCraneRailAShapeProfileDef,
        IfcCraneRailFShapeProfileDef,
        IfcCrewResource,
        IfcCsgPrimitive3D,
        IfcCsgSolid,
        IfcCurrencyRelationship,
        IfcCurtainWall,
        IfcCurtainWallType,
        IfcCurve,
        IfcCurveBoundedPlane,
        IfcCurveStyle,
        IfcCurveStyleFont,
        IfcCurveStyleFontAndScaling,
        IfcCurveStyleFontPattern,
        IfcDamperType,
        IfcDateAndTime,
        IfcDefinedSymbol,
        IfcDerivedProfileDef,
        IfcDerivedUnit,
        IfcDerivedUnitElement,
        IfcDiameterDimension,
        IfcDimensionCalloutRelationship,
        IfcDimensionCurve,
        IfcDimensionCurveDirectedCallout,
        IfcDimensionCurveTerminator,
        IfcDimensionPair,
        IfcDimensionalExponents,
        IfcDirection,
        IfcDiscreteAccessory,
        IfcDiscreteAccessoryType,
        IfcDistributionChamberElement,
        IfcDistributionChamberElementType,
        IfcDistributionControlElement,
        IfcDistributionControlElementType,
        IfcDistributionElement,
        IfcDistributionElementType,
        IfcDistributionFlowElement,
        IfcDistributionFlowElementType,
        IfcDistributionPort,
        IfcDocumentElectronicFormat,
        IfcDocumentInformation,
        IfcDocumentInformationRelationship,
        IfcDocumentReference,
        IfcDoor,
        IfcDoorLiningProperties,
        IfcDoorPanelProperties,
        IfcDoorStyle,
        IfcDoorType,
        IfcDraughtingCallout,
        IfcDraughtingCalloutRelationship,
        IfcDraughtingPreDefinedColour,
        IfcDraughtingPreDefinedCurveFont,
        IfcDraughtingPreDefinedTextFont,
        IfcDuctFittingType,
        IfcDuctSegmentType,
        IfcDuctSilencerType,
        IfcEdge,
        IfcEdgeCurve,
        IfcEdgeFeature,
        IfcEdgeLoop,
        IfcElectricApplianceType,
        IfcElectricDistributionPoint,
        IfcElectricFlowStorageDeviceType,
        IfcElectricGeneratorType,
        IfcElectricHeaterType,
        IfcElectricMotorType,
        IfcElectricTimeControlType,
        IfcElectricalBaseProperties,
        IfcElectricalCircuit,
        IfcElectricalElement,
        IfcElement,
        IfcElementAssembly,
        IfcElementComponent,
        IfcElementComponentType,
        IfcElementQuantity,
        IfcElementType,
        IfcElementarySurface,
        IfcEllipse,
        IfcEllipseProfileDef,
        IfcEnergyConversionDevice,
        IfcEnergyConversionDeviceType,
        IfcEnergyProperties,
        IfcEnvironmentalImpactValue,
        IfcEquipmentElement,
        IfcEquipmentStandard,
        IfcEvaporativeCoolerType,
        IfcEvaporatorType,
        IfcExtendedMaterialProperties,
        IfcExternalReference,
        IfcExternallyDefinedHatchStyle,
        IfcExternallyDefinedSurfaceStyle,
        IfcExternallyDefinedSymbol,
        IfcExternallyDefinedTextFont,
        IfcExtrudedAreaSolid,
        IfcFace,
        IfcFaceBasedSurfaceModel,
        IfcFaceBound,
        IfcFaceOuterBound,
        IfcFaceSurface,
        IfcFacetedBrep,
        IfcFacetedBrepWithVoids,
        IfcFailureConnectionCondition,
        IfcFanType,
        IfcFastener,
        IfcFastenerType,
        IfcFeatureElement,
        IfcFeatureElementAddition,
        IfcFeatureElementSubtraction,
        IfcFillAreaStyle,
        IfcFillAreaStyleHatching,
        IfcFillAreaStyleTileSymbolWithStyle,
        IfcFillAreaStyleTiles,
        IfcFilterType,
        IfcFireSuppressionTerminalType,
        IfcFlowController,
        IfcFlowControllerType,
        IfcFlowFitting,
        IfcFlowFittingType,
        IfcFlowInstrumentType,
        IfcFlowMeterType,
        IfcFlowMovingDevice,
        IfcFlowMovingDeviceType,
        IfcFlowSegment,
        IfcFlowSegmentType,
        IfcFlowStorageDevice,
        IfcFlowStorageDeviceType,
        IfcFlowTerminal,
        IfcFlowTerminalType,
        IfcFlowTreatmentDevice,
        IfcFlowTreatmentDeviceType,
        IfcFluidFlowProperties,
        IfcFooting,
        IfcFuelProperties,
        IfcFurnishingElement,
        IfcFurnishingElementType,
        IfcFurnitureStandard,
        IfcFurnitureType,
        IfcGasTerminalType,
        IfcGeneralMaterialProperties,
        IfcGeneralProfileProperties,
        IfcGeometricCurveSet,
        IfcGeometricRepresentationContext,
        IfcGeometricRepresentationItem,
        IfcGeometricRepresentationSubContext,
        IfcGeometricSet,
        IfcGrid,
        IfcGridAxis,
        IfcGridPlacement,
        IfcGroup,
        IfcHalfSpaceSolid,
        IfcHeatExchangerType,
        IfcHumidifierType,
        IfcHygroscopicMaterialProperties,
        IfcIShapeProfileDef,
        IfcImageTexture,
        IfcInventory,
        IfcIrregularTimeSeries,
        IfcIrregularTimeSeriesValue,
        IfcJunctionBoxType,
        IfcLShapeProfileDef,
        IfcLaborResource,
        IfcLampType,
        IfcLibraryInformation,
        IfcLibraryReference,
        IfcLightDistributionData,
        IfcLightFixtureType,
        IfcLightIntensityDistribution,
        IfcLightSource,
        IfcLightSourceAmbient,
        IfcLightSourceDirectional,
        IfcLightSourceGoniometric,
        IfcLightSourcePositional,
        IfcLightSourceSpot,
        IfcLine,
        IfcLinearDimension,
        IfcLocalPlacement,
        IfcLocalTime,
        IfcLoop,
        IfcManifoldSolidBrep,
        IfcMappedItem,
        IfcMaterial,
        IfcMaterialClassificationRelationship,
        IfcMaterialDefinitionRepresentation,
        IfcMaterialLayer,
        IfcMaterialLayerSet,
        IfcMaterialLayerSetUsage,
        IfcMaterialList,
        IfcMaterialProperties,
        IfcMeasureWithUnit,
        IfcMechanicalConcreteMaterialProperties,
        IfcMechanicalFastener,
        IfcMechanicalFastenerType,
        IfcMechanicalMaterialProperties,
        IfcMechanicalSteelMaterialProperties,
        IfcMember,
        IfcMemberType,
        IfcMetric,
        IfcMonetaryUnit,
        IfcMotorConnectionType,
        IfcMove,
        IfcNamedUnit,
        IfcObject,
        IfcObjectDefinition,
        IfcObjectPlacement,
        IfcObjective,
        IfcOccupant,
        IfcOffsetCurve2D,
        IfcOffsetCurve3D,
        IfcOneDirectionRepeatFactor,
        IfcOpenShell,
        IfcOpeningElement,
        IfcOpticalMaterialProperties,
        IfcOrderAction,
        IfcOrganization,
        IfcOrganizationRelationship,
        IfcOrientedEdge,
        IfcOutletType,
        IfcOwnerHistory,
        IfcParameterizedProfileDef,
        IfcPath,
        IfcPerformanceHistory,
        IfcPermeableCoveringProperties,
        IfcPermit,
        IfcPerson,
        IfcPersonAndOrganization,
        IfcPhysicalComplexQuantity,
        IfcPhysicalQuantity,
        IfcPhysicalSimpleQuantity,
        IfcPile,
        IfcPipeFittingType,
        IfcPipeSegmentType,
        IfcPixelTexture,
        IfcPlacement,
        IfcPlanarBox,
        IfcPlanarExtent,
        IfcPlane,
        IfcPlate,
        IfcPlateType,
        IfcPoint,
        IfcPointOnCurve,
        IfcPointOnSurface,
        IfcPolyLoop,
        IfcPolygonalBoundedHalfSpace,
        IfcPolyline,
        IfcPort,
        IfcPostalAddress,
        IfcPreDefinedColour,
        IfcPreDefinedCurveFont,
        IfcPreDefinedDimensionSymbol,
        IfcPreDefinedItem,
        IfcPreDefinedPointMarkerSymbol,
        IfcPreDefinedSymbol,
        IfcPreDefinedTerminatorSymbol,
        IfcPreDefinedTextFont,
        IfcPresentationLayerAssignment,
        IfcPresentationLayerWithStyle,
        IfcPresentationStyle,
        IfcPresentationStyleAssignment,
        IfcProcedure,
        IfcProcess,
        IfcProduct,
        IfcProductDefinitionShape,
        IfcProductRepresentation,
        IfcProductsOfCombustionProperties,
        IfcProfileDef,
        IfcProfileProperties,
        IfcProject,
        IfcProjectOrder,
        IfcProjectOrderRecord,
        IfcProjectionCurve,
        IfcProjectionElement,
        IfcProperty,
        IfcPropertyBoundedValue,
        IfcPropertyConstraintRelationship,
        IfcPropertyDefinition,
        IfcPropertyDependencyRelationship,
        IfcPropertyEnumeratedValue,
        IfcPropertyEnumeration,
        IfcPropertyListValue,
        IfcPropertyReferenceValue,
        IfcPropertySet,
        IfcPropertySetDefinition,
        IfcPropertySingleValue,
        IfcPropertyTableValue,
        IfcProtectiveDeviceType,
        IfcProxy,
        IfcPumpType,
        IfcQuantityArea,
        IfcQuantityCount,
        IfcQuantityLength,
        IfcQuantityTime,
        IfcQuantityVolume,
        IfcQuantityWeight,
        IfcRadiusDimension,
        IfcRailing,
        IfcRailingType,
        IfcRamp,
        IfcRampFlight,
        IfcRampFlightType,
        IfcRationalBezierCurve,
        IfcRectangleHollowProfileDef,
        IfcRectangleProfileDef,
        IfcRectangularPyramid,
        IfcRectangularTrimmedSurface,
        IfcReferencesValueDocument,
        IfcRegularTimeSeries,
        IfcReinforcementBarProperties,
        IfcReinforcementDefinitionProperties,
        IfcReinforcingBar,
        IfcReinforcingElement,
        IfcReinforcingMesh,
        IfcRelAggregates,
        IfcRelAssigns,
        IfcRelAssignsTasks,
        IfcRelAssignsToActor,
        IfcRelAssignsToControl,
        IfcRelAssignsToGroup,
        IfcRelAssignsToProcess,
        IfcRelAssignsToProduct,
        IfcRelAssignsToProjectOrder,
        IfcRelAssignsToResource,
        IfcRelAssociates,
        IfcRelAssociatesAppliedValue,
        IfcRelAssociatesApproval,
        IfcRelAssociatesClassification,
        IfcRelAssociatesConstraint,
        IfcRelAssociatesDocument,
        IfcRelAssociatesLibrary,
        IfcRelAssociatesMaterial,
        IfcRelAssociatesProfileProperties,
        IfcRelConnects,
        IfcRelConnectsElements,
        IfcRelConnectsPathElements,
        IfcRelConnectsPortToElement,
        IfcRelConnectsPorts,
        IfcRelConnectsStructuralActivity,
        IfcRelConnectsStructuralElement,
        IfcRelConnectsStructuralMember,
        IfcRelConnectsWithEccentricity,
        IfcRelConnectsWithRealizingElements,
        IfcRelContainedInSpatialStructure,
        IfcRelCoversBldgElements,
        IfcRelCoversSpaces,
        IfcRelDecomposes,
        IfcRelDefines,
        IfcRelDefinesByProperties,
        IfcRelDefinesByType,
        IfcRelFillsElement,
        IfcRelFlowControlElements,
        IfcRelInteractionRequirements,
        IfcRelNests,
        IfcRelOccupiesSpaces,
        IfcRelOverridesProperties,
        IfcRelProjectsElement,
        IfcRelReferencedInSpatialStructure,
        IfcRelSchedulesCostItems,
        IfcRelSequence,
        IfcRelServicesBuildings,
        IfcRelSpaceBoundary,
        IfcRelVoidsElement,
        IfcRelationship,
        IfcRelaxation,
        IfcRepresentation,
        IfcRepresentationContext,
        IfcRepresentationItem,
        IfcRepresentationMap,
        IfcResource,
        IfcRevolvedAreaSolid,
        IfcRibPlateProfileProperties,
        IfcRightCircularCone,
        IfcRightCircularCylinder,
        IfcRoof,
        IfcRoot,
        IfcRoundedEdgeFeature,
        IfcRoundedRectangleProfileDef,
        IfcSIUnit,
        IfcSanitaryTerminalType,
        IfcScheduleTimeControl,
        IfcSectionProperties,
        IfcSectionReinforcementProperties,
        IfcSectionedSpine,
        IfcSensorType,
        IfcServiceLife,
        IfcServiceLifeFactor,
        IfcShapeAspect,
        IfcShapeModel,
        IfcShapeRepresentation,
        IfcShellBasedSurfaceModel,
        IfcSimpleProperty,
        IfcSite,
        IfcSlab,
        IfcSlabType,
        IfcSlippageConnectionCondition,
        IfcSolidModel,
        IfcSoundProperties,
        IfcSoundValue,
        IfcSpace,
        IfcSpaceHeaterType,
        IfcSpaceProgram,
        IfcSpaceThermalLoadProperties,
        IfcSpaceType,
        IfcSpatialStructureElement,
        IfcSpatialStructureElementType,
        IfcSphere,
        IfcStackTerminalType,
        IfcStair,
        IfcStairFlight,
        IfcStairFlightType,
        IfcStructuralAction,
        IfcStructuralActivity,
        IfcStructuralAnalysisModel,
        IfcStructuralConnection,
        IfcStructuralConnectionCondition,
        IfcStructuralCurveConnection,
        IfcStructuralCurveMember,
        IfcStructuralCurveMemberVarying,
        IfcStructuralItem,
        IfcStructuralLinearAction,
        IfcStructuralLinearActionVarying,
        IfcStructuralLoad,
        IfcStructuralLoadGroup,
        IfcStructuralLoadLinearForce,
        IfcStructuralLoadPlanarForce,
        IfcStructuralLoadSingleDisplacement,
        IfcStructuralLoadSingleDisplacementDistortion,
        IfcStructuralLoadSingleForce,
        IfcStructuralLoadSingleForceWarping,
        IfcStructuralLoadStatic,
        IfcStructuralLoadTemperature,
        IfcStructuralMember,
        IfcStructuralPlanarAction,
        IfcStructuralPlanarActionVarying,
        IfcStructuralPointAction,
        IfcStructuralPointConnection,
        IfcStructuralPointReaction,
        IfcStructuralProfileProperties,
        IfcStructuralReaction,
        IfcStructuralResultGroup,
        IfcStructuralSteelProfileProperties,
        IfcStructuralSurfaceConnection,
        IfcStructuralSurfaceMember,
        IfcStructuralSurfaceMemberVarying,
        IfcStructuredDimensionCallout,
        IfcStyleModel,
        IfcStyledItem,
        IfcStyledRepresentation,
        IfcSubContractResource,
        IfcSubedge,
        IfcSurface,
        IfcSurfaceCurveSweptAreaSolid,
        IfcSurfaceOfLinearExtrusion,
        IfcSurfaceOfRevolution,
        IfcSurfaceStyle,
        IfcSurfaceStyleLighting,
        IfcSurfaceStyleRefraction,
        IfcSurfaceStyleRendering,
        IfcSurfaceStyleShading,
        IfcSurfaceStyleWithTextures,
        IfcSurfaceTexture,
        IfcSweptAreaSolid,
        IfcSweptDiskSolid,
        IfcSweptSurface,
        IfcSwitchingDeviceType,
        IfcSymbolStyle,
        IfcSystem,
        IfcSystemFurnitureElementType,
        IfcTShapeProfileDef,
        IfcTable,
        IfcTableRow,
        IfcTankType,
        IfcTask,
        IfcTelecomAddress,
        IfcTendon,
        IfcTendonAnchor,
        IfcTerminatorSymbol,
        IfcTextLiteral,
        IfcTextLiteralWithExtent,
        IfcTextStyle,
        IfcTextStyleFontModel,
        IfcTextStyleForDefinedFont,
        IfcTextStyleTextModel,
        IfcTextStyleWithBoxCharacteristics,
        IfcTextureCoordinate,
        IfcTextureCoordinateGenerator,
        IfcTextureMap,
        IfcTextureVertex,
        IfcThermalMaterialProperties,
        IfcTimeSeries,
        IfcTimeSeriesReferenceRelationship,
        IfcTimeSeriesSchedule,
        IfcTimeSeriesValue,
        IfcTopologicalRepresentationItem,
        IfcTopologyRepresentation,
        IfcTransformerType,
        IfcTransportElement,
        IfcTransportElementType,
        IfcTrapeziumProfileDef,
        IfcTrimmedCurve,
        IfcTubeBundleType,
        IfcTwoDirectionRepeatFactor,
        IfcTypeObject,
        IfcTypeProduct,
        IfcUShapeProfileDef,
        IfcUnitAssignment,
        IfcUnitaryEquipmentType,
        IfcValveType,
        IfcVector,
        IfcVertex,
        IfcVertexBasedTextureMap,
        IfcVertexLoop,
        IfcVertexPoint,
        IfcVibrationIsolatorType,
        IfcVirtualElement,
        IfcVirtualGridIntersection,
        IfcWall,
        IfcWallStandardCase,
        IfcWallType,
        IfcWasteTerminalType,
        IfcWaterProperties,
        IfcWindow,
        IfcWindowLiningProperties,
        IfcWindowPanelProperties,
        IfcWindowStyle,
        IfcWorkControl,
        IfcWorkPlan,
        IfcWorkSchedule,
        IfcZShapeProfileDef,
        IfcZone,
        UnKnown
    }
}
