#!/bin/bash
#self untar script 
#created by Happi
PACK_PATH=init/

INPUT_FILE=$0
SCRIPT=$0

print_usage()
{
printf "Usage: $SCRIPT  [WORK_DIR]\n"
printf "example: $SCRIPT  temp\n"
        exit 1
}

if [ $# != 3 ];then
        print_usage
fi


PARM=$1
MODEL_STRING=$2
URL=$3


HOST_DOMAIN=`echo $URL|awk -F : '{ print $1 }'`
HTTP_PORT=`echo $URL|awk -F : '{ print $2 }'`

REMOTE_DIAG_PARM=/app/remote_diag_parm.txt
touch ${REMOTE_DIAG_PARM}
RET=$?
if [ $RET != 0 ];then
mount -o remount,rw / 
fi

echo "parm=$PARM">${REMOTE_DIAG_PARM}
echo "string=$MODEL_STRING">>${REMOTE_DIAG_PARM}
echo "host_domain=$HOST_DOMAIN">>${REMOTE_DIAG_PARM}
echo "http_port=$HTTP_PORT">>${REMOTE_DIAG_PARM}


WORK_PATH=/var/ramfs

mkdir -p ${WORK_PATH}
mount -t ramfs none ${WORK_PATH}

SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1 ; exit 0 ; }' $INPUT_FILE`
mkdir -p $WORK_PATH 2>/dev/null
busybox tail -n +${SKIP} $INPUT_FILE | tar x -C $WORK_PATH 2>/dev/null

cd $WORK_PATH
WORK_PATH=`pwd`

cd $PACK_PATH
chmod +x autorun.sh
./autorun.sh
#	ret=$?
#	cd $WORK_PATH
#	rm -rf $PACK_PATH
#	rm -rf $SCRIPT
#	exit $ret
exit 0
__ARCHIVE_FOLLOWS__
init/                                                                                               0000755 0000000 0000000 00000000000 13214262777 010532  5                                                                                                    ustar   root                            root                                                                                                                                                                                                                   init/autorun.sh                                                                                     0000755 0000000 0000000 00000005457 13214262777 012601  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   #!/bin/bash
#the autorun script invoked by the self-upack script
#created by Happi


PACK_PATH=$1
if [ -d "/app" ]
then
echo "app is exit!"
else
mkdir /app
fi

DIAG_WORK_PATH=/var/ramfs
PRE_DIAG_PATH=/var/pre_diag_ramfs
DIAG_SN_FILE=/app/diag_sn.txt
RESULT_TXT=/var/diag_init_result.txt
REMOTE_DIAG_PARM=/app/remote_diag_parm.txt
DIAG_RUN_FLAG=${PRE_DIAG_PATH}/pre_diag/run_diag.txt


. `pwd`/functions

chmod +x *.sh
chmod +x tools/*
cd ${WORK_PATH}
export LD_LIBRARY_PATH=${WORK_PATH}/tools

uname -a | grep 'x86_64' > /dev/null 2>/dev/null
RET=$?
if [ ${RET} == 0 ];then
	export BIT64=yes
else
	export BIT64=no
fi



echo "">${RESULT_TXT}
if [ -e "${DIAG_RUN_FLAG}" ];then
	echo "this machine seems to be under testing,you should reboot it if you want to diagnostic it again." >> ${RESULT_TXT}
	exit 1
fi




if [ -f $DIAG_SN_FILE ];then
	OS=`read_config.sh $DIAG_SN_FILE os`
else
	sed -n '1p' /app/appversion | grep 'M[0-9]\+\.[0-9]\+' > /dev/null 2>/dev/null
	RET=$?
	if [ ${RET} == 0 ];then
		OS="S"
	else
		OS=`sed -n '1p' /app/appversion | sed 's/-/ /g' | awk '{ print $2 }'`
		if [ "$OS" == "" ];then
			OS=NULL
		fi
	fi
fi

if [ "${OS}" == "S" ];then
	DIAG_SN=/config/etc/diag_sn.txt
	PRE_DIAG=/config/etc/rc.d/rc2.d/S999pre_diag.sh
else
        DIAG_SN=/etc/diag_sn.txt
        if [ -d /etc/rc.d/rc2.d ];then
        	PRE_DIAG=/etc/rc.d/rc2.d/S999pre_diag.sh
        else
        	PRE_DIAG=/etc/rc2.d/S999pre_diag.sh
        fi
fi

echo "os=$OS">>${RESULT_TXT}




if [ -f ${REMOTE_DIAG_PARM} ];then
        HOST_DOMAIN=`read_config.sh ${REMOTE_DIAG_PARM} host_domain`
else
	echo "fail to read the config file :${REMOTE_DIAG_PARM}">>${RESULT_TXT}
        exit 1
fi


HOSTPC=`getip ${HOST_DOMAIN}|awk -F : '{ print $2 }'`

echo "${HOSTPC}" | grep '[0-9]\+\.[0-9]\+\.[0-9]\+\.[0-9]\+' > /dev/null 2>/dev/null
RET=$?
if [ ${RET} == 0 ];then
        echo "hostpc=${HOSTPC}" >>${RESULT_TXT} 
else
        #fail to get the hostPC ip
	echo "fail to get the host ip by domain,please check network or DNS">>${RESULT_TXT}
        exit 1
fi


echo "hostpc=${HOSTPC}" >${DIAG_SN}
cat >>${DIAG_SN} <<- config_file
log_port=300
status_port=500
report_interface=${INDEX_PORT}
diag_path=${DIAG_WORK_PATH}
config_file

cat /app/diag_sn.txt >> ${DIAG_SN}
if [ "${OS}" == "S" ];then
	cat ${DIAG_SN} > /etc/diag_sn.txt
fi

sync

echo "init done" >> ${RESULT_TXT}
echo "prepare to download the diagnostic tools" >> ${RESULT_TXT}

mkdir -p ${PRE_DIAG_PATH}
mount -t ramfs ramfs ${PRE_DIAG_PATH}
if [ -e "/sbin/busybox" ]||[ -e "/bin/busybox" ];then
busybox env -i - PATH=/usr/bin:/usr/sbin:/bin:/sbin HOME=$HOME TERM=$TERM PS1=$PS1 /bin/sh ${WORK_PATH}/pre_diag.sh ${PRE_DIAG_PATH} &
else
env -i - PATH=/usr/bin:/usr/sbin:/bin:/sbin HOME=$HOME TERM=$TERM PS1=$PS1 /bin/sh ${WORK_PATH}/pre_diag.sh ${PRE_DIAG_PATH} &
fi
#${WORK_PATH}/pre_diag.sh ${PRE_DIAG_PATH} &

exit 0


                                                                                                                                                                                                                 init/functions                                                                                      0000755 0000000 0000000 00000001362 11666104020 012453  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   #!/bin/bash
#the common functions invoke by the other script 
#created by Happi




# returns OK if $1 contains $2
function strstr()
{
        #case "$1" in
        #       *${2}*) return 0 ;;
        #esac
        #return 1
  [ "$1" = "$2" ] && return 0
  slice=${1#*$2*}
  [ "$slice" = "$1" ] && return 1
  return 0      
} 



function report()
{
	$WORK_PATH/report_log.sh "$@"
	return 0
}

function report_file()
{
	local LOG_FILE=$1
	local line
        cat ${LOG_FILE}| while read line ;do $WORK_PATH/report_log.sh "$MODULE_NAME:$line" ;done
	return 0
}

function build_env()
{
	export WORK_PATH="`pwd`"
	export PATH=$WORK_PATH:$WORK_PATH/tools:$WORK_PATH/diag_tools:$PATH
	export -f report
	export -f report_file
	export -f strstr
}


build_env



                                                                                                                                                                                                                                                                              init/tools/                                                                                         0000755 0000000 0000000 00000000000 13214265233 011660  5                                                                                                    ustar   root                            root                                                                                                                                                                                                                   init/tools/getip                                                                                    0000755 0000000 0000000 00000001110 13214265233 012707  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   #!/bin/bash
#created by Happi

DOMAIN="$1"

        CONTENT=`ping -A -c 4 $DOMAIN | grep "bytes from" | awk 'NR==3' | awk '{print $4}' | grep [0-9].[0-9] | awk -F : '{print $1}'`
	if [ -e $CONTENT ];then
		NSLOOKUP=nslookup
		CONTENT=`${NSLOOKUP}  "$DOMAIN"  | sed '/^Name/,$!d' | grep "Address.*:" | awk -F : '{ print $2 }' | awk '{ print $1 }'`
		if [ -e $CONTENT ];then
			NSLOOKUP="busybox nslookup"
			CONTENT=`${NSLOOKUP}  "$DOMAIN"  | sed '/^Name/,$!d' | grep "Address.*:" | awk -F : '{ print $2 }' | awk '{ print $1 }'`
		fi			
        fi
	echo "Address : ${CONTENT}"

exit 0
                                                                                                                                                                                                                                                                                                                                                                                                                                                        init/tools/.getip.bak.swp                                                                           0000644 0000000 0000000 00000030000 13214263155 014327  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   b0VIM 7.0      rvZ3O&-Z  root                                    localhost.localdomain                   /var/ramfs/init/tools/getip.bak                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   
 3210#"! U                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     tp       (                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 ad  P
       (                     i  c  N  J  I      =  .    
  
  
  _
  3
  
      3          w  j  <                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          exit 0  fi         fi                 echo "${CONTENT}"                 CONTENT=`getip.bin "$DOMAIN"`         else                 fi                         echo "${CONTENT}"                         CONTENT=`getip.bin "$DOMAIN"`                 else                         echo "Address : ${CONTENT}"                         CONTENT=`${NSLOOKUP}  "$DOMAIN"  | sed '/^Name/,$!d' | grep "Address.*:" | awk -F : '{ print $2 }' | awk '{ print $1 }'`                 if [ $ret == 0 ];then                 ret=$?                 ${NSLOOKUP}  "$DOMAIN" >/dev/null                 NSLOOKUP="busybox nslookup"         if [ -e "/usr/bin/busybox" ]||[ -e "/usr/sbin/busybox" ]||[ -e "/bin/busybox" ]||[ -e "/sbin/busybox" ];then else         fi                 echo "Address : ${CONTENT}"         if [ $ret == 0 ];then         ret=$?         CONTENT=`${NSLOOKUP}  "$DOMAIN"  | sed '/^Name/,$!d' | grep "Address.*:" | awk -F : '{ print $2 }' | awk '{ print $1 }'`         NSLOOKUP=nslookup if [ -e "/usr/bin/nslookup" ]||[ -e "/usr/sbin/nslookup" ]||[ -e "/bin/nslookup" ]||[ -e "/sbin/nslookup" ];then  #fi #	GETIPBIN=getip.bin #else #	GETIPBIN=getip64.bin #if [ ${RET} == 0 ];then #RET=$? #uname -a | grep 'x86_64' > /dev/null 2>/dev/null   DOMAIN="$1"  #created by Happi #!/bin/bash init/tools/index.html.4                                                                             0000644 0000000 0000000 00000000137 11726625242 014026  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   <html>
<head>
</head>
<body onLoad="parent.location='/monitor/index.php'"></body></html>

                                                                                                                                                                                                                                                                                                                                                                                                                                 init/tools/index.html.3                                                                             0000644 0000000 0000000 00000000137 11726625242 014025  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   <html>
<head>
</head>
<body onLoad="parent.location='/monitor/index.php'"></body></html>

                                                                                                                                                                                                                                                                                                                                                                                                                                 init/tools/index.html.2                                                                             0000644 0000000 0000000 00000000137 11726625242 014024  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   <html>
<head>
</head>
<body onLoad="parent.location='/monitor/index.php'"></body></html>

                                                                                                                                                                                                                                                                                                                                                                                                                                 init/tools/index.html.1                                                                             0000644 0000000 0000000 00000000137 11726625242 014023  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   <html>
<head>
</head>
<body onLoad="parent.location='/monitor/index.php'"></body></html>

                                                                                                                                                                                                                                                                                                                                                                                                                                 init/tools/getip.bak                                                                                0000755 0000000 0000000 00000002374 13207273162 013462  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   #!/bin/bash
#created by Happi

DOMAIN="$1"


#uname -a | grep 'x86_64' > /dev/null 2>/dev/null
#RET=$?
#if [ ${RET} == 0 ];then
#	GETIPBIN=getip64.bin
#else
#	GETIPBIN=getip.bin
#fi

if [ -e "/usr/bin/nslookup" ]||[ -e "/usr/sbin/nslookup" ]||[ -e "/bin/nslookup" ]||[ -e "/sbin/nslookup" ];then
        NSLOOKUP=nslookup
        CONTENT=`${NSLOOKUP}  "$DOMAIN"  | sed '/^Name/,$!d' | grep "Address.*:" | awk -F : '{ print $2 }' | awk '{ print $1 }'`
        ret=$?
        if [ $ret == 0 ];then
                echo "Address : ${CONTENT}"
        fi
else
        if [ -e "/usr/bin/busybox" ]||[ -e "/usr/sbin/busybox" ]||[ -e "/bin/busybox" ]||[ -e "/sbin/busybox" ];then
                NSLOOKUP="busybox nslookup"
                ${NSLOOKUP}  "$DOMAIN" >/dev/null
                ret=$?
                if [ $ret == 0 ];then
                        CONTENT=`${NSLOOKUP}  "$DOMAIN"  | sed '/^Name/,$!d' | grep "Address.*:" | awk -F : '{ print $2 }' | awk '{ print $1 }'`
                        echo "Address : ${CONTENT}"
                else
                        CONTENT=`getip.bin "$DOMAIN"`
                        echo "${CONTENT}"
                fi
        else
                CONTENT=`getip.bin "$DOMAIN"`
                echo "${CONTENT}"
        fi
fi

exit 0
                                                                                                                                                                                                                                                                    init/tools/index.html                                                                               0000644 0000000 0000000 00000000137 11726625242 013664  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   <html>
<head>
</head>
<body onLoad="parent.location='/monitor/index.php'"></body></html>

                                                                                                                                                                                                                                                                                                                                                                                                                                 init/tools/getip.bin                                                                                0000755 0000000 0000000 00000006124 12375053566 013503  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   ELF              4   l      4    (      4   44                                       t  t           t  tt                                              /lib/ld-linux.so.2           GNU                                                                      9            9         ̂         ܂J      *        K                libc.so.6 printf gethostbyname inet_ntop _IO_stdin_used __libc_start_main __gmon_start__ GLIBC_2.0                        ii
   Z       x  h  l  p  t  U         5`%d    %hh    %lh   %ph   %th   1^PTRhthDQVhUSP    [B     tЋ]ÐU=| u)|t|ҡ|u|ÉUXt    thXk|ÐUH    )ċE Eu
E} uuh YE@Eă}t}
t2j EPE@0EpPhGhT    ÐUVS6t-t19sƐtC9r[^USPt-tXu]6   tKuUSRHHtЋuX[USR    [Æ  R]                                                      error:gethostbyname error for host:%s
 address: %s
 error:unknown address type
             T         
   ̄   (   ȁ   X
   d                   \                d   \            o<o   o,                                                                    ҂     GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  .shstrtab .interp .note.ABI-tag .hash .dynsym .dynstr .gnu.version .gnu.version_r .rel.dyn .rel.plt .init .text .fini .rodata .eh_frame .data .dynamic .ctors .dtors .jcr .got .bss .comment                                                                                                     !         ((  0                '         XX  p               /         ȁ  d                  7   o   ,,                  D   o   <<                   S   	      \\                  \   	      dd                  e                             `           P                 k                            q         ̄                    w             p                            pp                             tt                                                        HH                             PP                             XX                             \\                             ||                                  |  2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               init/tools/create_self_run_pack.sh                                                                  0000755 0000000 0000000 00000003722 12661474331 016367  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   #!/bin/bash
#the script to create a self run tar-pack
#created by Happi

CREATE_SCRIPT=$0
PACK_PATH=$1
SELF_RUN_PACK=$2

print_usage()
{
        printf "Usage: $CREATE_SCRIPT  [PACK_DIR] [self_run_pack_program]\n\n"
        printf "example: $CREATE_SCRIPT  /Diag/ Diag.sh\n"
        printf "\n"
        printf "This script will create a script that self-contain a pack with\n"
        printf "the PACK_DIR on tar format.When the new script was run,it will\n"
        printf "unpack the tar file ,and default invoke a autorun.sh script in it\n"
        printf "\n"
        exit 1
}

if [ $# != 2 ];then
        print_usage
fi


cat >$SELF_RUN_PACK <<-self_run_header_part1
	#!/bin/bash
	#self untar script 
	#created by Happi
	PACK_PATH=$PACK_PATH
self_run_header_part1
cat >>$SELF_RUN_PACK <<-'self_run_header'
	
	INPUT_FILE=$0
	SCRIPT=$0
	
	print_usage()
	{
		printf "Usage: $SCRIPT  [WORK_DIR]\n"
		printf "example: $SCRIPT  temp\n"
	        exit 1
	}
	
	if [ $# != 3 ];then
	        print_usage
	fi


	PARM=$1
	MODEL_STRING=$2
	URL=$3


	HOST_DOMAIN=`echo $URL|awk -F : '{ print $1 }'`
	HTTP_PORT=`echo $URL|awk -F : '{ print $2 }'`

	REMOTE_DIAG_PARM=/app/remote_diag_parm.txt
	touch ${REMOTE_DIAG_PARM}
	RET=$?
	if [ $RET != 0 ];then
		mount -o remount,rw / 
	fi

	echo "parm=$PARM">${REMOTE_DIAG_PARM}
	echo "string=$MODEL_STRING">>${REMOTE_DIAG_PARM}
	echo "host_domain=$HOST_DOMAIN">>${REMOTE_DIAG_PARM}
	echo "http_port=$HTTP_PORT">>${REMOTE_DIAG_PARM}


	WORK_PATH=/var/ramfs
	
	mkdir -p ${WORK_PATH}
	mount -t ramfs none ${WORK_PATH}

	SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1 ; exit 0 ; }' $INPUT_FILE`
	mkdir -p $WORK_PATH 2>/dev/null
	busybox tail -n +${SKIP} $INPUT_FILE | tar x -C $WORK_PATH 2>/dev/null
	
	cd $WORK_PATH
	WORK_PATH=`pwd`
	
	cd $PACK_PATH
	chmod +x autorun.sh
	./autorun.sh
#	ret=$?
#	cd $WORK_PATH
#	rm -rf $PACK_PATH
#	rm -rf $SCRIPT
#	exit $ret
	exit 0
	__ARCHIVE_FOLLOWS__
self_run_header

tar -c $PACK_PATH >> $SELF_RUN_PACK
chmod +x $SELF_RUN_PACK

exit 0
                                              init/read_config.sh                                                                                 0000755 0000000 0000000 00000000570 12015460774 013326  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   #!/bin/bash
#created by Happi

CONFIG_FILE=$1
KEY=$2

if [ -f $CONFIG_FILE ];then
	VALUE=`grep -m 1 "^[[:space:]]*$KEY[[:space:]]*=" ${CONFIG_FILE} | sed "s/^[[:space:]]*$KEY[[:space:]]*=//g" | sed 's/^[ ]*//g' | sed 's/[ ]*$//g'`
	if [ "${VALUE}" == "" ];then
		echo CONFIG_READ_ERROR
		exit 1 
	else
		echo "${VALUE}"
		exit 0
	fi
else
	echo CONFIG_READ_ERROR
	exit 1 
fi


                                                                                                                                        init/pre_diag.sh                                                                                    0000755 0000000 0000000 00006155143 13207551571 012655  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   #!/bin/bash
#self untar script 
#created by Happi
PACK_PATH=pre_diag/

INPUT_FILE=$0
SCRIPT=$0
WORK_PATH=$1

print_usage()
{
printf "Usage: $SCRIPT  [WORK_DIR]\n"
printf "example: $SCRIPT  temp\n"
        exit 1
}

if [ $# != 1 ];then
print_usage
fi

SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1 ; exit 0 ; }' $INPUT_FILE`
mkdir -p $WORK_PATH 2>/dev/null
busybox tail -n +${SKIP} $INPUT_FILE | tar x -C $WORK_PATH 2>/dev/null

cd $WORK_PATH
WORK_PATH=`pwd`

cd $PACK_PATH
chmod +x autorun.sh
./autorun.sh
#	ret=$?
#	cd $WORK_PATH
#	rm -rf $PACK_PATH
#	rm -rf $SCRIPT
#	exit $ret
exit 0
__ARCHIVE_FOLLOWS__
pre_diag/                                                                                           0000755 0000000 0000000 00000000000 12667754516 011351  5                                                                                                    ustar   root                            root                                                                                                                                                                                                                   pre_diag/index.html                                                                                 0000644 0000000 0000000 00000000137 12667754516 013347  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   <html>
<head>
</head>
<body onLoad="parent.location='/monitor/index.php'"></body></html>

                                                                                                                                                                                                                                                                                                                                                                                                                                 pre_diag/read_config.sh                                                                             0000755 0000000 0000000 00000000570 12667754516 014152  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   #!/bin/bash
#created by Happi

CONFIG_FILE=$1
KEY=$2

if [ -f $CONFIG_FILE ];then
	VALUE=`grep -m 1 "^[[:space:]]*$KEY[[:space:]]*=" ${CONFIG_FILE} | sed "s/^[[:space:]]*$KEY[[:space:]]*=//g" | sed 's/^[ ]*//g' | sed 's/[ ]*$//g'`
	if [ "${VALUE}" == "" ];then
		echo CONFIG_READ_ERROR
		exit 1 
	else
		echo "${VALUE}"
		exit 0
	fi
else
	echo CONFIG_READ_ERROR
	exit 1 
fi


                                                                                                                                        pre_diag/update_status                                                                              0000755 0000000 0000000 00000001703 12667754516 014165  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   #!/bin/bash
#the script to a line log to the hostPC
#created by Happi

NEW_ERROR_LEVEL=$1

INFO="$2"

uname -a | grep 'armv5' > /dev/null 2>/dev/null
RET=$?
if [ ${RET} == 0 ];then
 export mvl=yes
else
 export mvl=no
fi
HOSTPC=`read_config.sh  $CONFIG_FILE hostpc`


if [ ${HOSTPC} == "" ]||[ ${LOGPORT} == "" ];then
        printf "[$0]:Configure file error!!!"
        exit 1
fi


LAST_ERROR_LEVEL=`read_config.sh ${ERROR_LEVEL_FILE} error_level`

if [ $NEW_ERROR_LEVEL -ge $LAST_ERROR_LEVEL ];then
	sed -i s/^[^#]*error_level.*\$/error_level="${NEW_ERROR_LEVEL}"/   ${ERROR_LEVEL_FILE}
	echo "$INFO" > ${STATUS_FILE}
	if [ "x_${mvl}" == "x_yes" ];then
	 echo "${SESSION_ID}:::errorlevel::${NEW_ERROR_LEVEL};description::${INFO}" | busybox nc -u -w 3 ${HOSTPC} ${PORT}
	else
	 echo "${SESSION_ID}:::errorlevel::${NEW_ERROR_LEVEL};description::${INFO}" | netcat -u -c ${HOSTPC} ${PORT}
        fi
fi
report "errorlevel::${NEW_ERROR_LEVEL};description::${INFO}" 
                                                             pre_diag/alive_daemon                                                                               0000755 0000000 0000000 00000002026 12667754777 013733  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   #!/bin/bash
#the script to a line log to the hostPC
#created by Happi

uname -a | grep 'armv5' > /dev/null 2>/dev/null
RET=$?
if [ ${RET} == 0 ];then
  export mvl=yes
else
  export mvl=no
fi


while [ 1 ]
do
	ERROR_LEVEL=`read_config.sh ${ERROR_LEVEL_FILE} error_level`
	if [ -e "${STATUS_FILE}" ];then
		INFO=`cat ${STATUS_FILE}`
	else
		INFO="this machine is online now."
	fi
	HOSTPC=`read_config.sh  $CONFIG_FILE hostpc`
	if [ ${HOSTPC} == "" ];then
        	printf "[$0]:Configure file error!!!"
	fi
	echo "${SESSION_ID}:::errorlevel::${ERROR_LEVEL};description::${INFO};${MODEL_STRING} to ${HOSTPC} ${PORT}" >>/var/test_result/update.txt
	if [ "x_${mvl}" == "x_yes" ];then
	echo "${SESSION_ID}:::errorlevel::${ERROR_LEVEL};description::${INFO};${MODEL_STRING}" | busybox nc -u -w 3 ${HOSTPC} ${PORT}
	else
	echo "${SESSION_ID}:::errorlevel::${ERROR_LEVEL};description::${INFO};${MODEL_STRING}" | ./tools64/netcat -u -c ${HOSTPC} ${PORT}
#	report "errorlevel:${ERROR_LEVEL};status:${INFO};string:${MODEL_STRING}"
        fi   
	sleep 20
done
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          pre_diag/autorun.sh                                                                                 0000755 0000000 0000000 00000000502 12667755017 013377  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   #!/bin/bash
#the autorun script invoked by the self-upack script
#created by Happi


PACK_PATH=$1

chmod +x *
. `pwd`/functions
cd ${WORK_PATH}

mkdir /var/test_result/
#invoke main script
#./pre_diag.sh >/dev/null 2>/dev/null
bash -x pre_diag.sh >>/var/test_result/test_true.txt 2>>/var/test_result/test_false.txt
exit 0
                                                                                                                                                                                              pre_diag/create_self_run_pack.sh                                                                    0000755 0000000 0000000 00000002673 12667754516 016056  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   #!/bin/bash
#the script to create a self run tar-pack
#created by Happi

CREATE_SCRIPT=$0
PACK_PATH=$1
SELF_RUN_PACK=$2

print_usage()
{
        printf "Usage: $CREATE_SCRIPT  [PACK_DIR] [self_run_pack_program]\n\n"
        printf "example: $CREATE_SCRIPT  /Diag/ Diag.sh\n"
        printf "\n"
        printf "This script will create a script that self-contain a pack with\n"
        printf "the PACK_DIR on tar format.When the new script was run,it will\n"
        printf "unpack the tar file ,and default invoke a autorun.sh script in it\n"
        printf "\n"
        exit 1
}

if [ $# != 2 ];then
        print_usage
fi


cat >$SELF_RUN_PACK <<-self_run_header_part1
	#!/bin/bash
	#self untar script 
	#created by Happi
	PACK_PATH=$PACK_PATH
self_run_header_part1
cat >>$SELF_RUN_PACK <<-'self_run_header'
	
	INPUT_FILE=$0
	SCRIPT=$0
	WORK_PATH=$1
	
	print_usage()
	{
		printf "Usage: $SCRIPT  [WORK_DIR]\n"
		printf "example: $SCRIPT  temp\n"
	        exit 1
	}
	
	if [ $# != 1 ];then
		print_usage
	fi
	
	SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1 ; exit 0 ; }' $INPUT_FILE`
	mkdir -p $WORK_PATH 2>/dev/null
	busybox tail -n +${SKIP} $INPUT_FILE | tar x -C $WORK_PATH 2>/dev/null
	
	cd $WORK_PATH
	WORK_PATH=`pwd`
	
	cd $PACK_PATH
	chmod +x autorun.sh
	./autorun.sh
#	ret=$?
#	cd $WORK_PATH
#	rm -rf $PACK_PATH
#	rm -rf $SCRIPT
#	exit $ret
	exit 0
	__ARCHIVE_FOLLOWS__
self_run_header

tar -c $PACK_PATH >> $SELF_RUN_PACK
chmod +x $SELF_RUN_PACK

exit 0
                                                                     pre_diag/report_log.sh                                                                              0000755 0000000 0000000 00000001276 12667755021 014062  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   #!/bin/bash
#the script to a line log to the hostPC
#created by Happi

LINE_LOG=$@

uname -a | grep 'armv5' > /dev/null 2>/dev/null
RET=$?
if [ ${RET} == 0 ];then
 export mvl=yes
else
 export mvl=no
fi

HOSTC=`read_config.sh  $CONFIG_FILE hostpc`


if [ ${HOSTPC} == "" ]||[ ${LOGPORT} == "" ];then
	printf "[$0]:Configure file error!!!"
	exit 1
fi
echo "LOG:${SESSION_ID}:::${LINE_LOG} to ${HOSTPC} ${LOGPORT}" >>/var/test_result/update.txt
if [ "x_${mvl}" == "x_yes" ];then
echo "${SESSION_ID}:::${LINE_LOG}" | busybox nc -u -w 3 ${HOSTPC} ${LOGPORT}
else
echo "${SESSION_ID}:::${LINE_LOG}" | ./tools64/netcat -u -c ${HOSTPC} ${LOGPORT}
fi
#output for debug 
#echo $LINE_LOG >> ./tmp/tmp.log

exit 0
                                                                                                                                                                                                                                                                                                                                  pre_diag/debug_functions                                                                            0000755 0000000 0000000 00000001360 12667754516 014455  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   #!/bin/bash
#the common functions invoke by the other script 
#created by Happi




# returns OK if $1 contains $2
function strstr()
{
        #case "$1" in
        #       *${2}*) return 0 ;;
        #esac
        #return 1
  [ "$1" = "$2" ] && return 0
  slice=${1#*$2*}
  [ "$slice" = "$1" ] && return 1
  return 0      
} 



function report()
{
	echo "$@"
	$WORK_PATH/report_log.sh "$@"
	return 0
}

function report_file()
{
	local LOG_FILE=$1
	local line
        cat ${LOG_FILE}| while read line ;do $WORK_PATH/report_log.sh "$line" ;done
	return 0
}

function build_env()
{
	export WORK_PATH="`pwd`"
	export PATH=$WORK_PATH:$WORK_PATH/tools:$WORK_PATH/diag_tools:$PATH
	export -f report
	export -f report_file
	export -f strstr
}


build_env



                                                                                                                                                                                                                                                                                pre_diag/toolsmvl/                                                                                  0000755 0000000 0000000 00000000000 12667754516 013230  5                                                                                                    ustar   root                            root                                                                                                                                                                                                                   pre_diag/toolsmvl/busybox                                                                           0000755 0000000 0000000 00002236240 12667754516 014662  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   ELF          (      4   8	   4    (     p.	 	 	                4   4  4                                                (.	 (.	           0	  0
  0
   +           0	 0
 0
             Qtd                          /lib/ld-linux.so.3    W           K          8                     %      U                 6          N  g      y              m       .      %       :             0         n   A          M  &         (                  B   5             6   z       J  -          L                    4  K  @     ,        l        d           
     1  R                           `                            P      ;     W             E  D                        /  Q  7                                  ~   {           	                ^       9     B                           V  +  H         ?  (           !                              F  S  T              =         p                 D         I                             S   <             I        *       O  $  h                 R   7  5            O      #         }      
                 J   !      )     Z   .  9                                 >      "                                                                                                                                                                              "                           &       )       '                               *       4                                                                     $          1       ?              8                       T           \   =                 [           G       <           	   H   Q          N       :                               f               i       E   M                     ]                              v           L          P                                      X       A                       3                     w                 ;       +       U                        r   ,              @   2                        Y          x         t       q                                                                j                        |                           b                  e                    s   u                                                          
  C          F       _       >       0                 /   #               c                          V      '         a           o     k      
              3    C  G     -   2                                               x         	                      l                                 Y
  7
    !  d             ̸         0  ظ         Z                                     O                                  r  ,         *  8           D           P           \         }  h           t         P                                             L           |             ȹ         B
  7
      #
  Թ                    7           	                      	                        (            4         p  @           L         %               4               l  d         *	  p           |         c           u	                                               ĺ           к         :  ܺ                                                      -           	  $         6  0           <         l  H         	  T         {  `         "  l           x         b
           #                      V                      H             ̻            ػ         	                                                       $            `  ,         _	  8            D         W
  7
        P           \           h         	  t         Y                                                                    ȼ            Լ         y
           	           {                                 e           v   (           4           @           L         
  X           d           7
      
  p         ]  |                    E                                 @           |	  Ľ           н           ܽ                               +
            t           	             $           0         	  <           H            T           `           l         3  x         q                                  %                                   ̾            ؾ                                                                 K            m  ,         B  8           D           P            \           h           t         ,           t                                            A             ȿ           Կ         @	           m	                                             Y           -  (         l  4           @         D
  7
    !  *  L           X           d         D  p           |                                 v           ;           {           L                       O
  7
    !             	                      ?            8           5           (  $           0         b  <           H         A  T         S	  `         6	  l         e  x                                                     ?                      6                                                                  `                         ,           8         f  D           P         C  \         	  h         o
  t         
           1                      ]                                            s           N           	                                                         (         z  4           @           L           X         p   d         p  p           |           7
      =                      _           !                                 	                                            e	            +           Y           b  $           0         N
  7
    !    <           H         
  T           `         j  l         $  x         [  7
                 
           	                      $                      +                                 m           M
  7
      {            	             7
      Q                       
  ,           8         R  D         `   P           7
      
  \           h           t         F                                            w           
           3                                 	           
           	           M                        (           4           @         I  L         G  X           d           p           |         	                                                                                                                                                 	  $           0           <         N  H           T         V  `           l           x                                e                                 H               ;
                        libcrypt.so.1 __register_frame_info __gmon_start__ _Jv_RegisterClasses __deregister_frame_info crypt libm.so.6 atan2 sqrt sin pow cos exp libc.so.6 klogctl dprintf setuid chroot strcasestr socket __res_init mkdtemp fflush strcpy shmget sigsuspend gethostid vasprintf gmtime_r fchmod setgrent execl fnmatch gnu_dev_major execv _IO_putc srand ttyname_r gai_strerror strsignal strncmp inet_aton optind strrchr wait regexec pipe cfmakeraw shmat perror connect getpwuid ftruncate64 mmap64 semctl closedir initgroups inet_ntoa nanosleep getusershell getgrgid ftell inet_ntop strncpy getpriority sigprocmask regfree sigfillset shmctl unlink putchar listen select mkdir shmdt realloc fsync abort stdin strtoll _exit vsprintf div memchr strpbrk memrchr popen getpid kill strspn strdup creat64 strftime inet_pton flock localtime_r strtod strtok strtol isatty lchown setmntent clearenv feof strchrnul swapoff syslog symlink cfsetispeed ether_ntoa fgetc reboot execlp fdatasync fgets getpwnam getppid strlen ungetc pivot_root send sigemptyset openlog getaddrinfo dirname memset cfgetospeed getchar strstr strcspn __errno_location rmdir bind tcsetattr fseek chdir memcmp getnameinfo getpagesize endgrent getsockopt grantpt mempcpy getopt getlogin_r msgget dup2 clearerr unsetenv strptime _setjmp vsnprintf poll sigaddset ctime getgrnam adjtimex sethostname putenv fchown __sigsetjmp stdout gethostbyaddr fputc fseeko64 recv getsid inet_addr fputs strtok_r regerror strnlen memcpy freopen64 fclose tcsetpgrp getmntent strtoul vprintf setsockopt malloc siglongjmp killpg strcat umask strcasecmp ftello64 realpath raise setpgid getpeername __res_state getgid tzset hasmntopt opendir getenv sscanf recvfrom regcomp optarg getservbyname msgctl stderr sigdelset ioctl alarm system setrlimit64 wait3 gethostbyname getgroups getuid readlink fscanf ether_aton_r execve getegid getopt_long settimeofday execvp strncasecmp if_nametoindex strncat sendmsg strtoull fileno pclose usleep utimes __cmsg_nxthdr getcwd fwrite fread gettimeofday sigaction rename mkstemp64 gnu_dev_minor geteuid srandom atof setlinebuf atoi stime tcflush waitpid unlockpt localtime swapon lseek64 umount strchr endmntent getsockname sendto vfork mktime mallopt fdopen readdir64 qsort accept hstrerror tcgetattr statfs64 umount2 syscall bsearch freeaddrinfo setsid fcntl getrlimit64 cfsetospeed cfgetispeed ptsname_r __h_errno_location getmntent_r uname memmove fopen64 strsep access _IO_getc sysinfo getgrouplist setgid mkfifo setbuf strcmp recvmsg tcgetpgrp __libc_start_main setpwent semop ferror setpriority getservbyport vfprintf closelog sysconf gnu_dev_makedev semget __timezone __environ __daylight __cxa_atexit __xstat64 __fxstat64 __lxstat64 __xmknod GLIBC_2.4                                                                                                                                                                                                                                                                                                                                                                         ii
   
        f          ii
   
                  ii
   
      46
 +  7
 V  7
   7
 o  7
  7
   7
  7
  7
   1
   1
   1
   1
    1
   $1
   (1
   ,1
 	  01
 
  41
   81
   <1
 
  @1
   D1
   H1
   L1
   P1
   T1
   X1
   \1
   `1
   d1
   h1
   l1
   p1
   t1
   x1
   |1
   1
   1
    1
 !  1
 "  1
 #  1
 $  1
 %  1
 &  1
 '  1
 (  1
 )  1
 *  1
 +  1
 -  1
 .  1
 /  1
 0  1
 1  1
 2  1
 3  1
 4  1
 5  1
 6  1
 7  1
 8  1
 9  1
 :  1
 ;  1
 <  1
 =  1
 >  1
 ?   2
 @  2
 A  2
 B  2
 C  2
 D  2
 E  2
 F  2
 G   2
 H  $2
 I  (2
 J  ,2
 K  02
 L  42
 M  82
 N  <2
 O  @2
 P  D2
 Q  H2
 R  L2
 S  P2
 T  T2
 U  X2
 W  \2
 X  `2
 Y  d2
 Z  h2
 [  l2
 \  p2
 ]  t2
 ^  x2
 _  |2
 `  2
 a  2
 b  2
 c  2
 d  2
 e  2
 f  2
 g  2
 h  2
 i  2
 j  2
 k  2
 l  2
 m  2
 n  2
 p  2
 q  2
 r  2
 s  2
 t  2
 u  2
 v  2
 w  2
 x  2
 y  2
 z  2
 {  2
 |  2
 }  2
 ~  2
   2
   2
    3
   3
   3
   3
   3
   3
   3
   3
    3
   $3
   (3
   ,3
   03
   43
   83
   <3
   @3
   D3
   H3
   L3
   P3
   T3
   X3
   \3
   `3
   d3
   h3
   l3
   p3
   t3
   x3
   |3
   3
   3
   3
   3
   3
   3
   3
   3
   3
   3
   3
   3
   3
   3
   3
   3
   3
   3
   3
   3
   3
   3
   3
   3
   3
   3
   3
   3
   3
   3
   3
   3
    4
   4
   4
   4
   4
   4
   4
   4
    4
   $4
   (4
   ,4
   04
   44
   84
   <4
   @4
   D4
   H4
   L4
   P4
   T4
   X4
   \4
   `4
   d4
   h4
   l4
   p4
   t4
   x4
   |4
   4
   4
   4
   4
   4
   4
   4
   4
   4
   4
   4
   4
   4
   4
   4
   4
   4
   4
   4
   4
   4
   4
   4
   4
   4
   4
   4
   4
   4
  4
  4
  4
   5
  5
  5
  5
 	 5
 
 5
  5
 
 5
   5
  $5
  (5
  ,5
  05
  45
  85
  <5
  @5
  D5
  H5
  L5
  P5
  T5
  X5
  \5
 ! `5
 " d5
 # h5
 $ l5
 % p5
 & t5
 ' x5
 ( |5
 ) 5
 * 5
 + 5
 , 5
 - 5
 . 5
 / 5
 0 5
 1 5
 2 5
 3 5
 4 5
 5 5
 6 5
 7 5
 8 5
 9 5
 : 5
 ; 5
 < 5
 = 5
 > 5
 ? 5
 @ 5
 A 5
 B 5
 C 5
 D 5
 E 5
 F 5
 G 5
 H 5
 I  6
 J 6
 K 6
 L 6
 M 6
 N 6
 O 6
 P 6
 Q  6
 R $6
 S (6
 T ,6
 U 06
 V @- -x	  Əʌ Əʌ Əʌ Əʌx Əʌp Əʌh Əʌ` ƏʌX ƏʌP ƏʌH Əʌ@ Əʌ8 Əʌ0 Əʌ( Əʌ  Əʌ Əʌ Əʌ Əʌ  Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌx Əʌp Əʌh Əʌ` ƏʌX ƏʌP ƏʌH Əʌ@ Əʌ8 Əʌ0 Əʌ( Əʌ  Əʌ Əʌ Əʌ Əʌ  Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌx Əʌp Əʌh Əʌ` ƏʌX ƏʌP ƏʌH Əʌ@ Əʌ8 Əʌ0 Əʌ( Əʌ  Əʌ Əʌ Əʌ Əʌ  Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌx Əʌp Əʌh Əʌ` ƏʌX ƏʌP ƏʌH Əʌ@ Əʌ8 Əʌ0 Əʌ( Əʌ  Əʌ Əʌ Əʌ Əʌ  Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌx Əʌp Əʌh Əʌ` ƏʌX ƏʌP ƏʌH Əʌ@ Əʌ8 Əʌ0 Əʌ( Əʌ  Əʌ Əʌ Əʌ Əʌ  Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌx Əʌp Əʌh Əʌ` ƏʌX ƏʌP ƏʌH Əʌ@ Əʌ8 Əʌ0 Əʌ( Əʌ  Əʌ Əʌ Əʌ Əʌ  Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌx Əʌp Əʌh Əʌ` ƏʌX ƏʌP ƏʌH Əʌ@ Əʌ8 Əʌ0 Əʌ( Əʌ  Əʌ Əʌ Əʌ Əʌ  Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌx Əʌp Əʌh Əʌ` ƏʌX ƏʌP ƏʌH Əʌ@ Əʌ8 Əʌ0 Əʌ( Əʌ  Əʌ Əʌ Əʌ Əʌ  Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌx Əʌp Əʌh Əʌ` ƏʌX ƏʌP ƏʌH Əʌ@ Əʌ8 Əʌ0 Əʌ( Əʌ  Əʌ Əʌ Əʌ Əʌ  Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌx Əʌp Əʌh Əʌ` ƏʌX ƏʌP ƏʌH Əʌ@ Əʌ8 Əʌ0 Əʌ( Əʌ  Əʌ Əʌ Əʌ Əʌ  Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌ Əʌx Əʌp Əʌh Əʌ` ƏʌX ƏʌP$ 
  - - 0-zOt h  t 0 0  Q/h	 0  @-,0 0  S   0  S  
 0   7
     $	 80@-  S  
, ,(  0  S  
0  S   
3/    $	 7
 0
      0b!  $ @- @0  0 @l[
 d[
 @-$@$ 0 >  P    d    M   0  P @   =  @P  
    i0    P    0  S @  PX  T   0 SH 	  
D  ,0   4    (   ݚ F  2  d[
  }   ( W  `P   P1  S0  Up :#:@0   0 @
     P     P   
p@ 0  S
  
*'7 S    P  
H m   S      ,0 $   D6
 d[
  D	 7
  Px s@-P @n  P      Pd  @`  T1  P0  0!  <  `^ \\ XZ 0 @La0C0   0P0e T  $K     T  F @  B  @ 0E`@ 0  S 8 ,    K  P   @   *  (    @ 0  S     PP  0  S
 0   E  X@    
 D      |֘  } ޘ    _	 	 W  X  d[
 ɚ p@-  P X   PL@   0- S0 0      (0    b       ֘ d[
 7
 ɚ @-/ @  P@ @-/ @  P  
 P  0  S    @-/ @    P  
   00 0/ S 00  T 0  S @ @p@- @PP  
 0  S  
' @ 0   S   
  pO-1 p 0  S`  
1  W p  `PW  d1  
  XP  
  <1@   
  P  0
 P &    0  20:  0 C0  X0C
  
 0  S  
 0  @  
@ l0	P  L0 0   
    (0 0   
    X =L6
 '	 d[
 H6
 	  -@-0   0@Ѝ/ -M0   0~80    P  
  (0((  0  S0  `[
 D6
 RY
 G- R p  
x@ P`   0 00 T0  Sp  
Z	  
00P0 
`
 V @  ʚ;  R  
  P-00  ` B /@-@  0 0 9
 @-@  0 0 9
 A-  p`P @
   4PE0   2@   00L L  U  p@-` 0 P    @ 0#  00B0	 S    a0B S'  W0B0200L0	 S0
    a0B SW0B00    \: \  !2  \ 0 0@: S     R V  R "0 0   0     pl[
 80A- p `P@  6 p   0 S
l[
   P@-     p  
0 <C  
0<<  S  
              p@- @P` P    P  
% 0 @ 0 0D  S  p-u  0@-M 0P@t 00  P0  00s 03  T0  
 8 0    U  
 P 0   Ѝ0T  + 1 @- @   @ @- @z   @ @- a    I @- @+ @@- @+ @@-  P    ! @- @  P    9     @-  P  
  I A-  `  @P    	 p p P@B$@P U  W  
  p0 ?0< @ <0 V @-@  P    p@-P @P   h  p0-@- @P	  00(0 0  I    @Ѝ/l[
 0-@-  P
  00(0 0  5   ;@Ѝ/l[
 @- @S  P  
 :  @- 0 0  P   .  @-  P  
 &  @-:  P  
   p@- @P`u  P   T4  
 T,  
( (0
 T 0  p;	     @- @&  P    9 p@- @ PP     p9 p@- @ PP     p9     @- @  P  
   @- @W  P  
   @-F  P  
   @-  P  
   @- 6  P  
   -@-0 
 0  P     @Ѝ/ 0  @- @ I  p   q    @@-@  P  
 q 0  7
  s@-`@P ` p	   q    V   0 m  k |  @- @R  
8  P  
 L p@- P @   p@@-@ P  
 M %  P@- @  
 @v@-  P  
 < E p@- @P `P  
    pW p@- @P  P  
  # pW @- @  P  
  o @- @  P    9  0P@-  
i  P     @-@F0p 03  T 0  S  
  @- @X0p 03  T 0  S  
  p@-  @ P  0   S  
A  Q@a  0 0p@@-= @[ P   @d  @ @@- @ @p@- @  P w pp@- @  P  <  P  
  P pp@- @0p 03  T 0  S P  
 x p O-MM  S@P     @t P0  S/  0J Pp p    U     
T   *    `P  
 
    Z
  
  =   P    [  \ M    W  
      w @TP0  
  	 ЍڍT x    0   /A-O`pP $0$ R0 P   Q  
 p   q  
 " A- p`P @    q    P    T @  P` @ `  U  -@-00,0 0    P   
   z@Ѝ/l[
    ꟕ	  -M00$0 0    P   
   dl[
    럕	 80A- p `P@    P   0 S
l[
 A- p`P @      P    T @    
P` ` @  U p@- @ P  pp@-P @  P   p@p80A- p `P@    P   0 S
l[
   @-O 
   0d  ? ܀@- 
  ?! Ѝ @B @- @ ; p   c O- 0$M0P: `>  P ;  
 (
 0  P)  @p  0  	 P00C0   	 0 P	  	 0  P  0 v>C0C B0 0: S0    
   0@ S   
   <2  0 0  S   E  P  
 @      w  10n   .j  f P    0  P   P    0  P   P    | 0 PM  ;   P    D 0v P  
 P   @  0@e P,  00C0   P&   @  0@P P  0 v>C0C B0 . Q
   7  `0= P   000  S  
8 $Ѝ    l[
       	  0     "0 0/l[
   R 0    R/00B	 S   0a0C S  0   0  S   
0 0/l[
 @- @- \00L	 S   0a0C0 S  	  $ 0  00 0l[
 7@- P00L	 S   0a0C S  	  $0 @ 0 @ 0>l[
 @- @- \00L	 S   0a0C0 S      0  0
 0l[
 @- @00L	 S   0a0C S      0  0# 0l[
 A- 00`  P  
1  1  [|1 @Q0  S  
    
6      i  PD  
00p    R19  Q@ p  P    0 0 q  0  S 0d@Opp c `P  
0 0   
   t  T  | g@h   04 f  P   %    [
  [
  7
    [
     @M	   @- 0LMD0d#d3`   pPT  PPß 0 Dß@P$8ß8 , D(pPѷ3 p @1 0僱(0  S  ( 2  0  
D0  S2D0 2,0D   P 0  
 0  0  P4  2 0  @    d0?0|B0xB  h2 0   
 x\  @0 S  Du00   P 0 s     P 0 s	  0  0  P  
 (   ,$0W   0  PI  D   R  H @   ]@ (  ( d PP7    P7L1(HA00D18 <  P40<@P׮0 0 03(     P  (   P  
( P     @0  P   0  LЍ0 0 0 S [
   [
 ~   7
  0	     [
     ;M	           L6
 lt	      ( l[
   0   R00  C P@-@  
l0 00 Pg S   
  P  
H \<0 00u S   ,  P    d[
    @- 
   P  @ E-MP 0D  0H	ȟ`  @ȟp0ǟP ǟ ` ǟPp$啶7   Pa  
 0 0  @	  \ S 0D       D@ D 0  S 00  0# 0 000C	 S      (@( 1l 1l0  SI 0
 S(0J  ʐ S PP  Q  
36    4 @    0D@ Tʐ6
  6   |6|Ɵ \6@  0- S     P    / S  
<
 @   (     ^  .         Q  NT` 5   Du   ,@     TP`    P v `K>\00T@ > \0 0  `  0X0\0d  1  \0D  0k0j 90   
  {0 '  
T`D P 0T T0kpkP(  *g PP 
     000C	 S    P\0:00\0    P:T T`kp	 0    00
 S
 S0  
   > P
0  p
@     3    k  $ vf3   @0  0-  P   00C SH  p`  V  ( QU  00      	    0 S00c0p@
 T  
   T'  
 T  
&   T  
 T  

 T  
  2 7$   0  T 0
%  2 U  2  1!PE  PET2 U  @ T420c
S  :4   @ R 0  S
    0QT@ %  @es Pp
@  _`0T X>
 T0+T  `0<XT0X  W  
 W
  
 W  \0<\0\ T0,00\ T0\000 0\00e f\0iph1 \0 0T  lg   $ S  P    0 1  -x [
 ] h '	  m 7
 ~   .	 L6
 _ d[
 `[
 H6
       T  T  9
 l[
     T  X j	    A- 0(MP H 0$0_< N @ *    $0m  p  
  T  
 
    L2 0  Q  

   D  w  P  
 s  P  
 o  P  
  5  P  $ 2  R    
 t+   h'd2       `  H  I 0  S(  
@ p   

 P  @T D	0@0 S S(0( c@1   (  P 
 
7  P
      0  S 0 0
 7 @P
P  
 `u  0 0* S! S  
     S  
    P   t`0R V  0 
 5   0 0p  H      ê`  V  
 0  S   `     V PP   
 0  S    h     0 (Ѝ@  / 5 7
 I 7
 Q d d[
 T  7
 m }  !  @- e<  V  7 @- @P  
    @O-x3$M @0$l3`  `3    ? L pD3 @  @  Pp P  
  P  1  S    &   X  1  U @  
0 S     W 0!0C0j   `U`  S 00  S`    VX  
0 0  S  
d嵩 P@  
'J  P  
  8  㪩(@`P2  	  囩 PP)  
 P	  G  P  
  V  卩 `P@  
$ pP  
i @  @     
 m    @   @`	 Z X V  T   14   d   
  S+  
     
  S$   ] @  0@@  0 "a 
  &?      0  P   -  T   0t t   -  $Ѝ'	 d[
 L6
  7
 u	    / > X k z      `    	  G- 0@0$P0/ 0  |1  0!  R  
 0- S  0  S    P P	 Q  PA  
   @ Hh1  Pp\1 p    ! 0  Y `  
  P	  
0 $+ 0 0  S  
   0- 0 
    
 R 0  S  
 0  S  000  S  YP    G  P  
 @P  0 @
  S00  T0 0     0  x0 @' 7
 AY	 '	 / d[
 4 @ S  Y A- P`p @	  &  P      P     @  P p@-M  X @  3  00  P  @P  U  
 0@  ,  1h P @@   , ,0   S 1,0@$(#  
   P  
    P  R ,   P  
    "   " $ ,    P    0 l  
i ( 0    
 y `P   A 4N ,K$$H (E _ . # P
 ?	  0(  > @ P ( $ z  P  1   )  $ xp  P  
$ k  P$|l1t   @P  
T1\    P,   
 0- S  0- S      P  
 ],@ &0   
 
  ^    ,  Q  
0 0- S  0- S     
   x0  孯  P  P Ѝpp h[
 |         	     " * 3 <	  	 7
 < A  ] E-0$M   0(|0 `  t@t Pp @l0p`
   PPPP嵰<0      $Ѝ'	 h[
 b [
 p 	  7
 E-  $M ``|l1 P  d1dAd  0 @X0p  <p```儰$1   @  
1   1  S00*`    `  V|# P @ 0  N 0  0p0p    P@`@   0l h0 d  < p@  TH  $Ѝh[
   [
 	  7
 7
 5	 	    7
 '	 P p@-`m |0 P  ̯ @P  
 0+ S  \0 00  S  
    V  
 I @ k @p p@  7
 h[
 Z   O-M `P`%  3   Cß0p @tß 
 hßhPp ``pL3 @  @Q   U 0   S   
2      @@9    0< S/    -  
>P  P@ ጽ@p    p2 `@    g 4   0 0 T  @H X V  0$  eO 
@  . P A1 0 ܡ  
n p\  0   
e `
 l0	
  
R  Px  U  pC   . P   0. S  0 . S  

 S  0
 S  0  S
  
  1   @P0	  
 c P  
   M0   - n0  0 @e000 0  P    pG  Wd    Ѝh[
 h [
 	  z 7
 @        3 5	  7
        00B	 S   0a0C S  _ R  
- R  
. R  
@ R       R  /A-`)  p   P  0- S  `0  偮 @P   xD0 P 00  S  
  =  v U    O7
 h[
 V	   @-  @    P  
 @2  G- @0M$@W   3 P  3 03,p`0 c0ßC  @	 $(  `pp勮3   P  
$0  S  2$ 5 0 @u S   	@3 0  0p S    3 0 $   R3 0  	  
3   030,00   @   s  P2, ,0, >     P       P  
  P P  
t J0   
``l0  S  
0  S          ((]     V(  p(`Z    V  
  . P   ;     P  
   P   8     P   . 4   :  P  $0  S  
   U  
p W.  $ ✹!   @ $ Ⓓ    P  0 P    $ x  K$0  S  U` !   Y PP  V
 |   0Ѝh[
 	  [
  " 7
 T	 z	 2 ; E J V ^ f N  '	 q I      b  	 ?	  p@- ` PP@  
    @埣  x  ᙣ	     @.   )40   0  S  
 0  S  
0  S   ph[
    E- P @-  
  p    - P  
ЍE` n  P
 0= S	    U  0 TPC    P  
 S   U!  
P  0  f C@ P   @ T ` &R Tp'K T
  @DЍT 	 E- `PDMP  
 0- S  0  SP	  
 P     Q2  
 & p  V  
 - 0 @P   - W-@  @  T  
  x0j  VP pd   

 A RP0 !  0  V  
 0- S  0  S  
 DЍ9
 T 	 7
 L0p@- 0 @P   P   
"  T  
  @  7 ph[
 I 0@-M@    		0 00  P   10  P    @  T@ @  T000 U  T0 0 0 N 1    T@@ 0  0  S    k Ѝ0@ h[
    $0@- @    P  ( 0 0h[
 @- P   d `0  @    P  00<<  S,     Q     Q  
  h[
   A- p#   M  P  0 0`  0  S00`   0 0   @  T0  S   0 0     p P  U9
  -7@-P   0  @ T"  0 0@ 	     P  
   P  ? T        0 0  
 D0D    [  0  S   >@Ѝ/9
 [
 A    d[
  O-M@D@ p 0 0* S`I p.  
00C	 S    W  
  % p   
 0`    [H  
 P    }  P    W`   H p
   C   P0  S.   /- Q 00  S@  R/ Q   
 ` PG@{ 	Y@TP   	S0
@0pW	  
 U  , R @p
  R  
D ` Q  X0 0@   
L0 0 S@  
  04 00@  >	 T
 Ѝ [
 9
 S	 7
 O- PM  

 s P  

 P2  P    P  (@  T    `
  @    Y{  
 x$"$2徺 PPt  
2 0@   

  x    P   x0   P
  Uڠ   x P @ c< 0| + 0C00   0P    00p   0  0  S  
@ T    C0  S0  
   R  0 Q  
  Q      	 7  4l0  0@   
l @\0       Y`    
<  ḺЍAY	   ' + [
 / A   I 9
 V p@-@   0  S   B    R    P   b| . PP  h h  @.   P	     P  
   0 K   P p@%9
 o { ?	  @-M 0 u  P   2M    04 P=    M  P  lAl D  P  PL1 0@   
@   R  0  S] o>  0  0     ^  
 0 ?   
   0  S 00  
     ^  
 @ ` <0     R   Ѝ     { [
     & O-6Ɵ	@0iM  	 0 @ 宩  @   a@ 
  0  S  5H   j5    cz   |< tXp     sl   a  l[  @h  <(N `P  
   3P    P x4 0@   
X4. R   < N  T <6aO   SJ  gP `C  \4 0@   
\70  S@5  
6  ,4 0@   
0+00c0  S'  
00+0  S"  
00C0  S  000  S  
000  S  
3 0@   
 
0  S  ڜ    0000 @  T P  U1<011  S`L  0  S 00PC  D  0  S>    0 R00 p  
\FO "2   -l pP  @ 0@    0 @    2   0,2Fύr0` 0  S00  00 P  U `  V Pb  0  S 00@W  X     PR  g   P  0 PF    \ 00<  p!1  50    S0  
   `   V'   F(  P  01  S  ,1  S  0 H1  S  L1 S  
(1:	S  
 ,  0  S	  
 
  0 0  S  
    P  00 @  T0 P  U  X<p
pî9
 4 B [
 \ d[
 L6
 S  h  o  [
          &    , G z	    @-   @P  P   
d P      	      Ѝ  @-    P     
G  h ޿`   P @  P L0  P @@ 80  P     0b s       
 A-xxxMp lp ht0 t§X2 @ 嗳  P  
   
<A   
p 吞  _q@0D  P    T    Q   V 0- S  0  S  
  `P  ! ! `t ^ T  
 T  
  T  B  (   0 0 00#T  t@  `k\- \  `    @P	   >     0  * c  L- p @P    %      t  X  
        P  0  S   ` `- @PP t@   xЍ[
  4  7
 C   B   A   v	 o A  " @-$ 0  S   !0C 0 9
 8 ,,0@-   R    1   9
   H p@- @Pi ` e  &p@@-^  @p@- @PT ` P  p@p@- @PF ` B  p@p@- @P8 ` 4  i qp@p@- @P 0Bp@p@- @P  0 p@p@- @P 0p@p@-} @Pz  0 p@s@- P0 S
  
 0  S
  v     P  6/  @   @`  V |{ W  
0p@-00  S  
  @  0 P  S  
  U  
 @ 00  80   `P  @ 0@  S  p9
 7
 p@-'  @, 9 0$P  S0   
00p 9
 l @-0 `p@
 T     0@ T `  
 T `   
   T @A 0   0 S@ 1 0 @
 @9
    p@-$0 @Q   @D  TPEp9
   01 9
 p@- @P 0p@0  0mh[
  @- @0   0A@`h[
  G-2  2  @H`H	 n0  Vp00"   @  003 0 0 P @h     0P0\" 0 0  H0    P@2 @$ (0 R    n$"$  K    ^   0$0 R( :  1 1$ Q
     R
  
0U E	 S  
0$0 B 0 0E 	 Q000 S  0x1
 Q  $00$0 000H0  
  Q
  00  V	   0  S  1`  000 1 ` 0 H P0  | G@ 00 1 H0  S0000 @0 Q 0   0 0 Q   0  S    
h0 0 0 S  0 0L G?00	  0p0`
Ph[
 h[
    9
   ~ l[
 T           pH-h1M \1 P @  0PK 00M
`  
40 P   K  KPK  0 1 P       KK e*     PP  
 0 P  S#  
   V g     P?0  
 P  {00  l0 00 R 0  0@ 0  S Kph[
 [
       9	  t0@- @0  S     Q  
0 0b Q@   : @@ 80 S   <  @@vh[
  "   p@- i,0 @ P  ,0k@0 Tp@h[
    00, 11T0  0 Q   0  \  4 ,0 0  0 Qh[
 0p@- P00  S @    00@ @0 T0  000l0 P @ 0@ 0 P PP  
y  4 @ $0   0H $(Gp@h[
  |0@- 0 P < 8  P  
  Q   < H0 @@ <0 D0c @ @0   Q @h[
 = N 0p@- @ P 0 0 0 0  S 0 0d0    0 0 R   0e  S 0 0 0,0 0   00b0`  S 0 0p@bh[
 (0@-   00`  S 0 0 0@Uh[
 80p@- PO @ 0 S0@aOā @p@Dh[
 @-0  0 L @h[
 @- @  T    d, A-0 P 0 0000 p 00 `     0 0 R@   0  S @@  Q   gr0  S  
 d  6  ᅷ p @   0 S     Ѝh[
 l[
 p@- P80 @P P 00
 P 0  S 00  
 Pph[
 A-   P `0  p 
 P @   00 00  P@ T 00  U 0  S  
H PE T00C0h U* @P h[
 [   `lp@-t ,	  0 P  S  h p@  P  
8 00 @@ D 0@P P80<0p@_ i h[
 A- P `6 p   006@ 408@<@ @H@٢6  0Pca8PD`  P=  
8   P    P  
xEvD0  R@ `6`  0 8&P6  40(6 PJ  P !  L@         0 
0,00 0 00  0 S  0 S   Ѝ0C0   +, 7  (R P Pk  
"    PF  
   p[  
  
 pF  
 pX  
 p<  
   p7  

 P3  
 p1  
  > PL  
  : Pu  
< PE  
% P  G PC  
Q P  
E Pu  p P;  
  f P   
  d P)  
  b P  j P  
k P  
g P,  
  u P#  
  r P0  
  s P/  
  y P  
z P  
w P
  
      	  4 0  :  3 0  \  3 0   3 0       3 @3 0@  Sq  o  ,
  0 `  S  
  pP  
H3 @   00 d!@0 T D M  4
 n P>  
  d P	  
e P7  
A  q P:  
x P;  
p P4  
:  2  80 S5  <  P  
      D0    d2  80 P0C80     D0 0 02  8  \<0 B8 0C<0
                  00B	 S  !Pp` 9 P @  0
 00C	 S    Vp  
P`  0
 0L
 l1 @ ` R  b T*  
    T$  
   t$  

 T  
 t  < T!  
  % T&  
> T  
G T  p T  
  d Te T  g T  
w T
  
  u T  
y T  
z T R wL0  00 0h F
  ,0d @ 00 0\ oh[
 J	  7
  [
  '	 N X>    v	    ~ @-0    77
 @-p2M`@ d2 @\2 P  u SP  
w S@  
s S0  S`F   P  
 0- S
1 V 1 @1 P  
1     	1A 0    S  
0 @P d  
    P   @  -a|Q  P      Z  P    @1  P  %  18q     Q9  P   1  0   4  : `P  0  @  	    0  S  
 {     P  U  
       0  @ P 0    j `      ;  G Ѝ7
 7
 7
 7
  7
 П	 S	 7
 G V 4F P	 p@- M@  P  
   P   P  P  
0  S `  `P 凗  P   0  @  P0@0  
  T  (B("t00  S      T  T P0 `qD   < ,0 `h  ЍpP{	 : e D ڐ    	m	 [ m@0@-  S@     P    P  
  *z O-|1MP 0"l d1!  ` @  1D  S01010,100  0 p0  ׿ P006  

 ? r  P G 0@	 P^ S @ ``  
 U    0   0 0   
  M0 0   
  	0Ex0  P  
 U  
 P  0 t 0  S m1	 h 7
 n 	  [
 u 7
 p@- P@  T$5 #pE-    L  pP      ~ c  _ `x0 P @   p   0 S  
T 
     3 Pc  L0  cL 
 C @  l[
 E	 O-%5\M@   L5%  0x5p5   {  0<<  S4    Q  <C  
0 O  0
0$ d0  P @   @P  
  % U 0C0C5 S  hO O O HP R R PP R XP R P R P P R P P  Q 4Q R Q Q R Q R R R R R R R R  R R R R R R R R DR R R R R LR R XR `R hR LQ R xR R @ U0  S  $
 (( @
 $6  Tp 6P `
  :1 P W <*< @ Pc  <#< P I @
dC 0"  0  8  $
 ( P
   @
 @  	  w  
 <q  T  Q  
  Xm  Tk  ,d  D   M  `V  < < P D @$     :  `V    P 1 << @ *0 < < P  @d 0 4$  
    
<"  P  T@ 
 P d    H  
 (  D  @  $
 qL    	 P  U
  0 S  
 0<<  S    P  <C   C\Ѝ^ [
 a 7
 |   e   9	 A	 @	    '   	  7	 @-MP  p  0ȝ  @   {   
 N   `  
 F `  g0 _ #@ $\\ \0   LL0D  W .TC	 [
 `   x| N T Wt|  W '	 @-  B   p@-GM8M @
  @  PW  *02 SS    PP0 U   `  4  P  
 ! IB `奔8P.PE @  P     KF P  P  *1:	S0 @ P%  
 @!   @  0 @$t0    P@  
F  P  *1:	S @  
40@      @ ~ߍڍp <	 ! 7
  W   A-0@ 
0   00cC#P`  U     pP  \0 @  T  
      pP  
        g0   . 7
 7
 2 p@- 0@ P  S 
  
 @P    `0    p7
 0@- M P N  S  P  
]  P  
 PG F    S0 0t ;  l   @  0 @0DH   +4 40 G  PЍ0H i V p     +  0   P /@- 0!  rY p@- `Q P  
  P   p@ @     P  p@	 p@-M`
 d0 P   @
 y  P  
P  U  V@  
 / @
    ܍p9
 @- @D0 0     0 
   0@ 0 0  000[
 9
 9
 A-M @ 0. Sb  
 S P ]  
R  At 7  P*  1  SI  
XqI P   @   a  P   =   ` ͧ 0  0 000C0 0 0 0000P  U!     P
  1  S  
 @ ]    |  P  I	   `  P   00 0 A8 80o  P  ލI D	 9
     + O- 0M  0"   0    $P   0     <        P0 P 0l    G K1 `   0    
  P^  
 p  PP  
  [W  
  @ N   \P   00H    PF  p , P  
	  P   	    P
  0 . S	  @= |  P  
  p F @P
  X  0  p 5  P P P   U
  
  @   0 @    00 00  S Ѝ[
    & 9
 * A-`#`3M@ 0 PL3 H P  @n  q'  
  5 P  :  P  
 @ @c0  0 S
  Y
  c  F  P  Q@   P "2勪  P   2     P      
"    P  
`j\\ `   00 0 4"2j  P (   
@  r0  S  l   1 Q0  Sd  
Ԫ `'  :  P"  
  /  P  
     
1 0    
0  0  
0  S  0@0C0  K  P  
$!  0  S  
  0  P ᔪ P  0  S  @   
 0     P  p  ` 0      
    
 P 0  Sl  @P  U      ߍ[
 H b 7
 !  I  + L6
 j H I  9
 p  [
 , 9
  PD /   p8 / P0 /   P$ /& P /  P  `     $0@- @ 0  0    l[
 s@-l0   Q P`0`0"X0`0 0w @P 0 @c	  
 0 00    @ |l[
  '	 A- 0 p ` P  
 r@ P  ,0  P(   `   P {	 3 p@- PP@@  
  T  b @     - S_00  R  
0  S  
. S 00 p@-p ` @	   0  S  
,  \  @  PP @- AM@劙0 P"] \    
  k  P!  
0 0 0 S  
 1q  S   D

 W  P
`@  
<0 0  6
  , @   P  Aߍ9 7
 l[
 j > O- @PM  
R)n 0  P  d 0  D    Gn  *΍ ΍΍-  @!.?@AR P`  Q0 S  
0 2 SO    Z  
!
.  PH   0  S  
 &  P@  pq 0 hA  !N)n 0   P    0  @ !1  P@R  `P     ` !.g      a     \    
 W  0弩 N@    P  Y  4 0  Z  S  0 0  S  
L 8  ߍ9
 	   [
 F	        | (   E-5Mԅ05    0
@   P    
 0
  P {|5  @ `
  
 +   P  J XT%H  00 0 S  
 (0  S     P   $0  S 	
q! 
1  S?  
Px@  
 D  a 0   P  ` p  V x(  
t4 0  
0X@  SP P  @@4 `e  U  
0&0 R   $h0  @p?   0  P<P P 񟗛  j j j j j j j k p	  p  p  p     j@  0  S  
0  `  V}  
 T  P  
x@ 0   Pd  8   p@ P  U@ 4 4p  2   D   0
   P
D      \0020@40 pD  dގP P =  8l @l Hl Xl ll tl l l p  p  40@0  40@040)     @#  0  S  
0@  `  V  
   P
`  
x@ 0   P  8  40 040@      Q  W@p4  g   
  4l  P
  (1 0 0 S             P 00  S  
40 0 40S  P  0 0 0 S  
          Ѝ 
   P 
 9
 '	  
 . 7
 ?  \ N |   [
 '     T 	 . Q U  a 	 S  l[
  j  0M 0   p pD Td  S X  @z80 0   
,0L   P      0L  p  3[
 9
 	 	  @-CM`a@04  S@   QM  
<  \  
@0 0c SF    Q0A4080  S  
  c1 R=  Qq   0 0<<@ 000
@  0 P   00 @a   0  P
  X 8 D0  0@ D0H00H040  S  $0 0    
 Cߍ9
   [
 9
 9
 G-7wRM P `D1 0 40@QD0 RFƟ  @Qύ  ͍4 O?Y   
<&6z:><0V6BO   0?   ad6     D DƟD 00  {,,6 0 O1    
  
  0p  
  ᰸@!0  R0  
 )  P  @5  0 S   0  S0 0   
 0  S<  
    JoD@ P$   U 0 ̍  S"  
  ,1c!  A , ̍ 4<A p  `JO  Ꮈ O/2 S  
S,1 0 40  00060R/0"0 hi0$D  S   P/ 0       8,ğ   0  0'  0 
    %  |D!  W T
2 <Bύ 0 Oύ* 0u PP  @      |1 S  0S  
S  ̍!48#8"4 Q  
3 R  Q  0 S  @ T  0  R  0 U  N  J 81 R~  42 @ 
    (1 Rv   l     P
  
 P   Pi  
    R  
(1 Rc  F  !2  RRP2Q8B@ `
 7   0( 0 P	@  
 @      P  
  T   0㓢   |w80  S  
80 @c ` P ᆹD f  4AL0!@0  RL0P00P00ST00T0 0    
    
   0@0 0   , Rߍ 9
 	  [
 & 1  @B [
 7
 D6
 -C	 3    5 V	 B Q { k    9
  9
   n 8o    9
   	 	    %	   9
     S    0  S  l/0   P   /9
 @- @+   @ 9	 @-0@    00 S   @:
 9
 @-0@    00 S   @(:
 9
 O- P `v @ s    p+	 /
@f P  |     R   0C    
`@-0 # L 
   @
0 0  G 00 S    
  9
 @-,04   P  
&  P  
 @ @9
 550 250 @-  @ 000 S   @r9
 @-g  P   0,@  T     9
 - @-(@,    0,0 P   ڟ 0 09
 7@- PH  Pl   
     @P  P `	  	 <0   , 倶 @  T    >9
 425 { 150 p@-P M @    PV  
\1\! 4 T1  L1  P 0@10 00  
 0- S     P   \ @P   O  J  " B :  U `
  
 s 
 @P  
  @    |  @P
    PP	  
  P   4  X Ѝp9
 Ï	 ^ G j	 L 213 _  226 p@-P^(0    @  (  s(    (  (  [ 8 # #p9
   0s@- `|@ P0  c  P     P  
   0 #0    S  0 S  
  f P|  l[
 9
 r A-H   0pM P$p `@"  PE  
  T  
n @   4   P `  
0  V0 Ac  P `   P  0:	S  
 e  V  !  0`  
 0    T|   P f  U    @x  T  @ 6  8 D o 00pЍ9
  A  A    553  226 451 E-|ɟ|Mxy ΠLx  0`@D} 0  S 50 0	  
  R10n 0  S    *  P(     8     
8 	  ( 00 08 0  S  
X @  |1  t8 0  P  
`
  @ D8   @=	 ,8   @7
 8   @1   0  :0"7  Ő  P @0    4P  U  
00S
 S  PU  
00S
 SPE 00   d P     0 S    0 S    0   S
00  P 000 S   k  
  P 0  4   40   0P   U6 Q  _ Ѝ6 Q  
6 Q  } 6 Q% 
6 Q" 
6 Q 
6 Q 
|6 Qxm 
t6 Qp{ 
l6 Q     PP  T4 PH&HT @ S4v  ,6 Q  
$6 Q  640m6 Q   6 Q    P  
5E  R@ Z UV5 Q 9  
5 Q6  
%5 Q @@ Q Q&  4   P 
  P  0:	S   Ty@  
 h$  ` t   v. ,0vy  5 Q  40  S  
 4 Q   @( 0 S   ⫲   P., 0$$
 @    4 Q   | @ d4 Q?     0 P$"  P
4   P  
 `P  ⱻ @P   0:	S  
     `0  
 0  @	4$ @ P   U   - @  T  g  u  00l3 Q2  4@  T  T|   ,/  P
 
 ,3 P  0 P  S `` ,  P
`
  0 @ P  S   f4, 8#!#߱R  2 Q
  4   P   0  
7  ?|"D   S  
l2 Q   L  
\2 Q  4   P3  
H  P/  <1  82 Q  4   P'  
  2 Q  4   P  
  P  1 Q  8 4 8   1 Q  8   P  
4  Q    Z @8  0  T80  
H# 1 Q    
p1 Q       0"CL9[
  9
   :
  ,:
 L6
 d[
  7
 ?	 { 220 H~ 7
  TIUQ221 RESUSSAP230 POONEPYTURTSEDOMOLLA202 TSYS DWP '	 ""  &|	 257 DWC PUDC ?	 PLEHTAEF211 214   ( TSILTSLNEZISMTDM, 7 TATSV VSAP  VSPE RTER550  226 451 TROP500 l[
 200 TSER350 ROTSDKM   257 DMR ELEDRFNROTNR 250 EPPAUOTS <    0 0C^ S  P   0 0     0U9
 '	   p@-` @P0  S  
  ;  T	  
   U 0   `` 'X X   P   000C	 S@  T 0 03@p9
 < F tn	 9
   G-t1M@  h1hh0$P`g UPP0L HH
 ` <p  0P pr 1  P A  0 a  S  
 A    '  P        P  
     P  
0 P   z P  
t ad  d q   Q 9/Ѝd[
 N @  9
 [
  n e [
 R \ 7
 J
	 w   K    p@-  S P  
 :)   P 0 0,h } @ @䣯, PD t @䛯 T,@X% !%? p@ñ 9
 9
 p@- @P@ p   q   p      P  
       p A-hMp P   P1    0- S     R0@    
 @`0  S  
 
k  P   S  Q      P   00   0  S  
0   |  t0 P 00d  P  T  t   D0D  R x @ hЍ 9
 9	  9
 ^   A    p@-@ PY 0 `- S     P  
  [ @( } P  
 P  
  p@n @-  Q   
\叞 @     < <0  P   @}    P  
 I  +  	 s@-1`   7 1 @ P0 0 0d S@ %  
 ` P. 0 '    0  #     
 0  S     0 SP@  
     h  @  P
   0     Q  
    c  | [
  	 7
 d[
 {	 O- tM  R  
 0- S  0a S  0  S4       P  
0  S  O      T       
  0<- SP@*P
     P  0P
  D     Q0#c  0   
0#c 0 t  0   S   n  @`  3#0c0 >    
@V  
 P/  @Pp  
   ! 0 p 00 6 (  Pd 6  
 0+ S  0  S  	  
 >S   0 0#     P  
  
 \  8@0      2 Pr `(  h2LHp `  0d0d00  d`5  , N   
  Q    P'  P@  : S@   00B0	 S    a0@ SW0@0    \  
  R: R  
  2  \@
P 0P U 0  S  
d 0   M     @ Pp@
  
   1 ZP  
 P   P @ 0  *   0    : Q08 #8   Q  S  
0R- S  
@   
P 0 0"  002` \0@  T tЍp[
 | ! 	 } \}   3  + 	 7 	  	 > 	 p  Q 	   5   \ 	      0  S/   P/H   0 @0 	 S/ A0@ S  7 @/A-0 `0 p    R U	  @  T: T%
  
    P  L 0     0  T`  0p: S` 0  S  W    Pl[
      0  S/   P/} p@- `,P    q  PP  
@  T p} p@- `,P    a  PP  
@  T pH p@-0 ` P   P  P  
  P  UF @ 80  UP   0P  S 00@ @ @ p7
 7
 s@- 0   0 `P    @   M  @
  l h0$  P  @
   0M S
P @   @ 0  T @   |V	   v	 O-|"M8  0  S @  80``  S0 0 P   @  @@	  	     P<f   }  P < _    `   `    R: R pp  : R  
  	0B  R S  P` U  	M   p  @r   0@2@`	
X@  p  <<!0    $ ,(  ,  0  4 @P`pЀ⸠    <0 S  
  S   0++ 0000800  \  
8 	w  P  
@@ 	 d  P	 $  P @  
( 0   @  	 R ߍ7
 %	 П	 	 _	  O- p $M    

  
 A  P
P   2 0   P  
  1

 1|@    q L
 '  P    T1

 1 00
    P0

 0 0 0
  
  P0(P  0  H

 
    P0  

  0$0
 x   P0

 $08`0   1' 8
  P
@
4  0@x0 HP 

 y	  
    P  XP

 j   
    P0  
hP
 Z   
 t   P0  
@ Y    
  
<    $Ѝ  l[
 	 '    !  p  B          	 @-|@`Mp  P  ^  \  :;
 #;,5˃"U.@Q  0  PP@pЍ|	 	 A-`@ p 0  S  1   @0 @ `P  ,@n TP00   C0  7
 	 00C8s   / 	 p@-<` @P  00C8s   p ᬌ  p 8
 	   ^p@-@` @P  00C8s   p    p7
 	 O- `MN PP  K P 8 @P     @ 4  n  \       |0  S     R | </ xZ1
	  
40d$dR1	  
PM
 x0  S#  
8  @  ?1   
H  51   
X  +h  $l  P< [  
6   4  P1  Dp@0@ xP   
 J
  )P  0,00  S  
    S
  
 S  
  @ S  
 S   
HP#@0D0 $Dp
@@<  0 (@t p< I`1  S  P  HRHB U1   
4 V  0P  S    R 
 0  S8  
!18 Q Q pp*@P@P  W  
t* AP@P|py  W  
`t$ q  
LoHm@!l8!i20  S  (0  S  00(  
 \2  Q  
 W Q   R(  Q  
 , L3  Q  
 G
 
 Ѝ0  S
	 	 ~ 	 #	 *	 @	 K	 V	 `	 s	 	 	 h	 	 	 	 	 	 	 	 
	   	 {	 	     ,	 k	 	 	 	 	 	 	 X 	 !	 5	 E	 p@- @P!  0 0  S    P   j  P P#  0 @   = PP  1   l0 0  S  
 o  U   @  TP    P @   % @ " PP   [p7
 p[
 @-<` @    0P@  0 0  Ѝp7
 R	 @- @ $ 4/  t   pt   o   4U   pQ @- $   @  Q    
 @4 0 	 T @-E-2"p   "2  
x2     l2 `
Q       V  
0  S   

0  / R    @ @ 0 S  
  ㅨ1   @0  P!<(<"4,40@   0    R @
   P
  
   P
  
  T  
Q  P  lJ  T    "<<!4,$1S4  
  R0100   
  4   
  0        )   
	   }  !   
0  #,,!$<$ 0 0   S   
  

  ! @P  
X %   H   [
 	 Z	 [
 `	 7
 L6
 g	 z	 	   	 	 	 	 	 	 @- @ @ @4 @- 8  @G-3HM 0    |3 P 0  S  
      ⸨L3 @  D  ) $3 0 6  
0(03 0$@  T	  
(       թ2 00  H )  Pa      0,@ @    0ǣ  P   $0  SN     0  尩G   H   P?  $2  `0,p(@(0  P   }$0  S#  
  $   P   $@(   P   U
  
 0  S  
 B @ |< r
 b
    a  <61 P 0  S@  
(`D D  0   P  D   R  
M@ ~D0  E=(0 0   0 0  ,@  ` h0 P 0  @    @L0d   0 Ph % #0 0    HЍ[
 h[
 7
 	  	 	 F	 E	 U	 @-0  H h[
 `0@- 0	  0H `  P  	 $   @  0 @  n0 0 h[
 l[
  @         q	 A- `RhM;  
0< P 0 p#0?0 0p @0 VP    0 qP@  >`e> @  0  " 0@^ S 00D  .0  DD L0L U @
00 a    VphЍh[
 	  3O-  M1 0  P1   
& 0Pp  %N    \	  
   0     0   P  43 0 0 S  
 0  S  
6 }`    1   [
   0 S  2  m    P2 
@  
M@ *P  P	    
 0 S  101   p  U`  L2 @P2`
@P  
-n  *2  P P
@  1  `019
@ P 1 W U  1 0 0  SP  
  Pp  Y  1 0 0  S  
 [    W  
 
  @P  t1 0  
< 
 01pd ! ?!  U)  
1 `0  S  
  X  

U
    0
 S0h    
  U          @P
  ڼ0 0  
>  ! ?!Pd`0 0   P  
M 0H    0  0IPp 0 `1@  Ѝh[
 l[
 	 7
 	 	    	 	 [
 O-$M4  ?<
@    P   
   P t4ğ P  0@
 ` @P巄P4  L4   
 8$F $4 0   
 4   7 `P  % `	A	  T  
   P  
3   0 3"  x3 0$ 3h 0 PP 
  
 @       P   @ $    Q  V P  
8  #!#ᨥ  @2 0   
 㦡2 0   2 0 00 S  
2  0   l2  X  101  
  
h" 0< 0X2 0  
` 42 0   
  X[  
S  1 p$P  U  (   @    T  
 ▥  1 p  3 0#%)  
 )  
 -  P  
`  V  
 L  00@1  @ 0 th P$ 6  ` 1   - P   P  0 0 0  S  
	!0     X  
 0 0`   `  |0 0 0 S    S  
0 0 0o S  
	  A`80  0 S  l!A  l@ $ЍB  h[
   X    	 	 [
 	 [
 7
   g
	 J
	 	 A  	 	 zi  7
 +	 l[
 7	 9	 H0s@-  ` 0 S  0!A  $@{0   h[
 7
 9	 O	 E-MMp PPt  
 1    d      c `P     
  ỿ < /V0@̍@D?   ᬿ!0 0 R00S;  0 H  P`    H  0 臿  P  < 孿    Ѝۍ7
 V	 r	 7      	 	 @- @ç40 01   0 S       P h[
 	 A-  S pM .  
000C	 S&  Kz`  @ P ᬿ  U  /0 @ BC   8z\ ` 4z0!H  P@ `Ҙ @ ᓿ ᑿ  T  
      ߍ   	 ` s@-`9 @P?  
@   P     0 P 0] S    {  P	     0 P 0 0  S   
 P _  U   Kp0  00@   0 S  
@    R r 0    Pu |	 	 l[
 h[
 A- pv `P @      T  
8/  P  
 4  @'  ' PP Az	 X s@-@Bt2 P  00d2 ` 0X 0 @000 02  000 2  000  
1 ! 0   ; u  !1a  a 0  
1   P00!1   P  0 S  
`1  0000H1 @0p   
\囿 0 SL  
 DD <<!县81 0  
,刿
 0   
ol0    
 f c0@   
 ] Z0   
 f 0 Sx   
 p p ] [l0 0  
` U 1 ?  |h[
 	 	  		 	 A		 )	 t o		 		 		 		 		 		 
	 
	 [
 +
	 @
	 , N
	 ]
	 t k
	 z
	  
	 
	 
	 
	 
	 8 @- @Ҿ00	 A- 0XM   S  
 <L D@H8<T P0帾 P ӄ  2 0 0 S	  
@0 S  L0  
     s  
D P0  S Bp p R  $  , 4 < a  a  a  a  a   a@0 S  t | l   lQ
  hQ  L0`!\1PP  PQ  LQ   ,Q@ <岾L0  
 (凿L0  
 偿L0  
  {@ wH0 T  ` 馾0 0  
H   坾<0
`  0 0P  0  @P  T
       XЍ	 h[
 *	 
	 #	 )	 0	 4	 8	 I ^	 B	 '	 G	 Q	 [	 i	 l	 q	 t	 )	 w	 [
 bv	 7
 p@-HM8@` @0
P P	.0 
 ]
  ⚽
00HЍp	 G-M `  L@HP`Pp|
 0 P@P`p  P   
 ݽ P,@  
 	   
 	   Ѝ	 A- pS@`  
   ( P"48#8"L\ 
  
  W   J  P    8#  #[   c @ * 	 : E-  SM `p0  
 00    00 )  
0@, P  000  0   L0 @  H ҽH0 0  
P   0 ɽ
 9  ЍEЍh[
 [
 	 @-XM  d  P   #
 R	  8 <00@ 0D   @@   R @  40 @S@ 0     XЍ
	 -\M  >  P    Qx  
t t0 Q3
 S	  8 <00@ 0D   00   S 0  40 0S0  s  \Ѝ 	 I '	 g
	 0@-\MP   @P   0  0\ \Ѝ0t J
	 A-(M @P `  p $@  $0 P    $`p9   ) @ *p  P P 0
0 H *  U  
 `  V       X (Ѝb	 l	 }	 p@- P  R  
   P 00- R0  S   
-h   P  
50 @ S  м000  0
 S  Ƽ01 s?  0  P ۠
 V p@	 	 A-p `Ӧx0 C   @P \06 03 00  0  4?  0 &  0 !Z7_  ?  ?@-
0  0 ("<@Ѥ `$8#LpȤ 0堥  0 ܀  A@- 0H@P#ᵤD `%pᰤ   0別  0 Ѝ  @A- P `p[ @ᛤ  0 D D0ӤP$, <  <,!4,$ L 4$    A@-p `; X%H Ⴄ  0 ȣ  40層.,0 D 4 <%L0@0 @  (0p@- P  @\  0 ᭣ph[
 O-lM ؆\  p`H 0  PA 	 0ԥ`  P Vp2     "2  0 p p `0&&x"2 `'s @ P"  0   0eF 0ᘥ  P  
  02X'   	 0ዥ  P  
 	  1K       RD" '"
 7   1Cp W 0B00 "
 !$ `p   0 @PP  P   0ᗤ  1 @PJ  P  
# 0  0  `p0  @d P\ &   0ڣ  0 P\ X @\  5 ɣ  80 @P%  P$P  @ElЍ  ?h[
 iUMu>  ?  p?O-! 1	     P 00@ P  Z  
	 0ᵢf   0   P  	 0 ᧢	  t0   0  0&`0  'P U@  Z  
	 0ᑢ  0 0 " ЍOh[
   0@A-`@ 0 Ấ  P  
    0  P A-`@ 0 ᦤ  P  
    0ᬤ  P 0@-@ F%H 0h[
 <0@- 0@I0 @ D 0 0  # h[
 0@-h M PQ   0 $@ 0   @0 P~   @0  @* P    
   Ѝ0l[
 	 M-0 (  Q8  
 00 40  S  
   凾A   p᯺P   `᩺I0 #  P᡺
 0||  @ᚺ iL 冸L 儸L 傸H 倸 ᘹ ᖹ ᔹ ᒹ "h[
 	 	 	 	 	 	 	 	 O-6 tM 0p08 D ,00"0  P MtM  lxh h K  M  l0 #ᶡ%5P @   PK0BdEK`U p0e #KK%$K*  
   ,5儢"Kᗡ 0ᔡ#K @PKᎡ % 5w  0 ᇡ$Kᅡp0KI @ 3$4g  4y  0K£  P  
lPPlPl  \h  `P  
t h d4޷P @   
  t00  c P0# 1  !  *  S h0 R:   Kth 0 h0  C
  0 Q  :0t1؀    S B @  R  \  K 	0f  P `tp   @ VPE  @&K W  P    	0_  P   0x 
B@
2 彡!x  `ph0 V:  Zg  
x 
 2s ZI   `+  x@  V  
$K+  P  
K p @ P  x2p$ޠ  0ǡ  0 נ @P
 W:  V  
 %K  P  
EK`
 V:
 o  0KFe$KK  P
  x 0JB    DD 
 Y@:p0x@T    Q
  
 0 R     xP2 Q   
 
 R:pT       KhPt(Kh@tKp @Gh 0
t0 KQPtP@@
p(KHK`A at@
EK@HKAYAt  l0h0l0h[
 {Gz?  ?iUMu>  ?   @   s@- 
 L0   ` @ P0 00"  0 2
"0/ |h[
 ư>OuAE-M `ᗹ߸ʷ PP  
墼1 @0A0 `P"\Q(0 4@P P @{  !   ⵆ @Zݿ{ P ᅝ 0 0 s0     00$0 1@b1 a! ᳆800800  S@   㒙0 @|0  @ 000  
{  0 0 00   P0ѹ   
    㝷4 4%"
"ЍC h[
 [
 	 
	 L6
    48 1O- `dM@0 p p  䄿 0 0 D 0 @0^0 PD P P   
  P  l1 0 0 SP  
\)   @ D 9D   D @HD۶A  80 P@֕ R  000 I 0@0   s0<00@0!0   j0 D00H0!c084,0000 ~ 82y 82< 0 0( P0   0
  dЍh[
 l[
 
	  
	 pC-`MT`   T   0 	* @X Pڟ@!@1  0 P @m 0T0̟  0   0a X  ፷ p   垿T0` @0 念P 0  f	0  p0 0,`
   @ 	0 # 	0`  V\ 	0 @   	0ܞ 	0מ`Ѝpư>.AK
	 X
	 p
	 h[
 O-3M   @؂d 	&  P    10  5 `!  P*  
H Q  
 Q0H0  
	   	᧞  l3  P  
     dL3 0   L  03L    0AIl    0,S  I0 S  D0  S0I0 0L02 00  0c % pQ  2 @Ḡ  PR @  0N
 0_  \2H  0
 X(2  @H   P  2 0@   
h  0 v   0 A 00 R  
A0 01 @A0@00<0#'  " h!h1e% 0H!H1 @P^  P0A0Q  0	0     X0 @0,0@ @ 0,0 ,0   0,0I0L0מ=01  #    P   xP  0  ,  S4 0C8 QP0   P%D  F Ѝh[
   `@[
 
	   p?  ?	 iUMu>{Gz?.A
	 
	 G-M D D @0ƴ p  14 0  p0Be R S  d R  
o R  
c R  
 R  N@ )0 PD P  
@
 H!\0 S L!`0 S D 0 S  
E0  S  
 S    / @    0H fL c""P d0  ;l0 73  0  RpЀ  
0010CB>A>A0Bp0㓧&p"Q  @P	0K  0 G   3/" 	># @P9  0 4  	0m  P4  S	    c0 ѝ  0  |姞   ȝ`2  㜧$0  S  
 0㗣#&(  P"0   40  S   2 0   
0㗣#cF`c@bf
 A @P*  
1 0O  LHp `A  x1 #  P&    VA  
    T1Ὕ  0   P  
L00$ SL0 1  .  I0L S0I0(  LI 0#$ sL0  0 0I0	 S  0   0IL0 Q  0AI0,`   @0  S
  p0  0I0Q  0ᘜ`  V  ? @
  W 00Ѝ
	 l[
 
	 
	 h[
   ?  p?  ?[
 ,	   ?  @O-M@P  p γ3 @ GP@@G DP0  0  H0 s  0 ,3  YD0 r    P!ᓞ  PV  
  pE  00S00\00 s   0  @Ῐ  `  ⩺ T     2 3 ܳٲHײL0 ! 0000 0    p @   @   0001 040  S  
倸   δ 00  @ 0r ?a
 0 /   P  R  ! 1Q  000   R!
 ٛ+L0@ S  a 02 E?	  p  W  @0  S)  
#Ὓ  0  P!  
' n  H0 s @  
0  S  
dpG@1`0Q	  0  S  
  pGV@`P  W T:00    R.
 h[
   @ 	 	 	  @	 [
 @-`0 0A p ˠ@,ˠPp0PX @Pй P  
    R  
80  S  0 S  * C8   R  
@00 S@0  : H8 
  0<@  S  
,0I@ , Ѝ@讳9
 x 8 0H-`P0 00MH0(
@"4"<02   0:  
  K09
    7@-P0  L@ 0  (238#8"<020 0        0RA  Q0  000   8#8@8( C808#800  k>9
   O- A Q `0  
# ( Pa  0#,0 U(P5 U,P; #;1p R0   
  0p 0C0    00p0|0 0   	 0d  ?  X
  
 , @ R8  2 ЍO蠹Ѝ9
 	 	 [
 	 0	 LM |P80(   Q  
   R  
00cd    (` v$  
0    06 @    p ` ,@  ٙ   0L ݲ   R  
80  S  
0 R  *      h9
 A	 ^	 x	 	 	 	 G-DǟDDM 8  @8P 
<`p 0 P<(@  @%uP   
  @ 
  
 噰  P @    ᝗@ 剳6  0 1
   P0嗗0 @  S  
 0 R 00 xP 0  @T0   P  
 m  wt0V0 D0ù0H 
 S    ⼹L Nn       \   
   D  Q  
  5D  0     T00T0        : D0 弳  P8    冗0@P<00$ 0   P嫳0    P壳 )4   P坳0   Sp0s  K4H D t0000000000  00  10  0 `P   0 S
<0 S   	  0) S  0 S00  s  P0Hp0 V9  : 2 R5    Q   V @D .0
 P@Я4  8 #8%4 pN   Q  
   Qd#  
   QX#  
   QL#  
 QD#  

   Q8#  
4#5  : Q,#  
 Q$#   
 # 嗵   R
0 S  *  L m   `  ^    
  0    
  P  
儵    n  Q  
    ɖ0#     ȯ   2    HD  0Ȳ P   0 S
R0H@0 ^R  : 0" 0 SJ  1  S  p` W `PP48  #8 &4 5   S3  
 S,  `   h p x                                    
                       R
0 S:  [
 	 9
 	 7
 
	 
	 	 (:
 [
 +	 { 8 l[
  0:
 \	 D	 k	 y	 	 	 	 	 	 	 	 &	 4	 	 L	 ^	 n	 	 	 	   U00    $01   00  S 0/ 	 A- P` @ p  W  
 G  P
     0    
0  S   ˲0 0   00  S  @-SMܒ p!哰΍ ͍NύOύ@Qύ/ ΍| M?,	 P` @  
  P   P  PJ  @q` V  R  ( T PR0@ C 㾗  QR?  @:00BJ TD1 
 P@ 
 㐯 
0?Su  U @$ 	  4 0 d g(P@   <>L 8΍- VSߍ	 )	 5	 	 >	 Y	    	 `	 A-M0` ,0 ᩱ @P  t  P   /㧮  PP  
   Pt Gu  P0  @ H  ʮ U00| L00D0T  p 8  x* !0@ S@  \1  !L00L0)   P   D #   P  L0    tu  P   ƳL0,| 0L0      W   P  
  P  000  S  0p   ֱ0 P  U
  ឵  W `PP  
T@   t ԴP0  H.d0P0 X  000 ,,0#Ѝ 	  	 + 	 3    	   	 E-tMp0l# 0 ` 0  S  
 T  D0/P0  @P<s  
    q 030#,,!$<$ 04 p 003
  u  P)    T/0 0  V   P00     @  
2  104c   P   > \   P  4   RV  `P t  P  00 p I   P  4 C     t4  P04;  
 P  4@ 0)4T ,   P  4 0!4X !   P  4 <4 H $HE)d
5  P0  S   P  
  P  000  S  00P0   0 0  S4  
P0  S0P00   P  
 <(  <"4, 4$00"1 0  0 0  
p 媲 X  4  00    㗴 X <<0<<01tЍ	  	  	 	 m	 	 	 	   	   	 A- Mpɐ1  W `~ (  P    4( 0  P  
  P   5  P:  V 
x >0h@ !0  x00 l0 06s0 P  l0s @ 听 0 xl  0 Y W  W( 0@  04   Ѝ	 '	 9	 L	 	 	 Y	 	 	 	 0@-MP   堯  P  
  囯  P  #0 0@  T  pp  @  
P ቯ  P  
 儯  P  @0  101  S
  0     
A  O  n\   P  
 0  S      
   H  Ѝ0	 
	 	  m	 7
   	 0  R/ 嫱9
 	 0  @-  0 0@ʭ	 9
  @-   0 0@轭km	 9
 G-7MP  0'000
00  phhǟX7` ,ǟ@  ,0@ @o @   

  *   0  S  
: S   
 $  (     $ 6 0 SƟ @`  
 6 @!1D0 0  S  
0 S  0  S  X61t W pp  W(Ɵ,pp F, 㐫$$
 ㊫0  S  
  D0,   5 \* !, 4    R  40<  0g < 88  ,   R  
< < 8  <   V  
 H >ş 0  S  
    V @  
 0۰  װ 
 00   ̊ 0 R*4 P   ʊ, 80  RL0l0  
L <   4l    P, p8<  0 @   T	   0 S
,$4$  Q , <    R gß0  S  
P ⎐#0  \ ß0  P	  0 庫$  Q
( @0  N,   R  40 u< ֑, P8 婑<  8 c< 8 p @  8j  P  
0  0  R0   
0"  S@ @  ꩳ 00 @  Pp2    P  @@ 0  d0  S   P :0  @ l
  
P 6  P p   `0)0p,0  S  
l   Rp@   V P  
`  V    `P   P        0  S  
t @0  S  
`0 @1  00 @ @ 3  ,0  ShA  
l@ P 0 b  P   ߏ @ 0> $A 8  % 0 !@  
    h   P  
   	 
    w 
  㬉D  &ld[
 9
 9
 	 [
 	 7
   N  J
	 g
	 	 	 l[
 
	 	   	 9	 N	 ]	 t	 |	 x	 	 	 	 	 	 	 @- 0 @ 0  S  
 | ፉ9
 	 7@-  0  S   
'  0  S0C0 0  S  
0<C4X   
0<L <  SD0 0 04 Y A PP$@ 0  S   
>	 	 2	 	 9
 p@-d0   ` PX0@    0 S    r,0  0 p @ R:p8
 8
 O-t0  h0 @ p` P    PP  
Ἤ  P`@
 T: u `  
	 V1 0 8
 8
 @- @h0  0 @8
 8
 0     /9
 @-@   5 0 09
 p@-40 @P 00 S      p@9
  0  S/U/  ȫ9
  0  S/F/  㿫9
 \@-0    
  R  0<< 0ʪ@ R  
0 0@9
 	 	 	  @ N@-D1 0  S   
4r     ܩ  P 4  0e S0  
  c S  
.  l S  
z S"  
)  0   Q%   000    0 0  S  
0      ~s    㴫     4 㢩0 0  S   
0    [
 2	 9
 	 @-M    \ R    L0 R "C   0  

 R  <  0 2B @  P  Q  
  
r܍9
 G-TMp   )彨FO   ㍩  P`
  Uυ       0 0U4P  U
  
 @   P@\\ @  T   
-  fɰ44	   | U000@10   ㋪  P  3 0  S  
0 㧪0  S  
     P    y1  S
   P  t D p   R   Q00p  0B S񟗫    T    Q00p     Q  0   00p   Q  
  : Qƕ0     Q"  
   Q  
P   Q+  
 Q.  
K  0 SN  
 S|  
    
 S    Su  
0 S0"00   ,墮g  0    
 R    R_  
0# 0  )  0  S %  #   h 0@P	0 S   W M K I$  F D%  A ? = ;5  0 S   
 S/   D,   R  
 R$  
)   Q0%  
 Q$  P  U!  
 ը 0   P   $      @    @  P  	   Q  
0   00	 XB0  S
  
 0  S   
0 S 00  W

	 $ 09
 .	 	 J
	 { 48 [
 9
 	  p@- @pM
> X l! 0  P1      	 |1  Q0 @  T   @D!H 0  T,1@ @/4 `P    寰   7  0`4  "
ᇆ XP⎧    Z W놩@     (0,0* (0  f8  v( h0l` h0h 㗧 pЍp9
 { 	   p@-0 @ 0   
  P 0  S 0 0  
  0 S 0 0 堨 垨 Ⴇ 00    0 S0 S    Rp[
 9
 O- 0KM̗ǟ$17	 ΍0  Iύ0j @    @    YH0@ S  
x7   dh7     Q  
  -  P    
      
 ( $嬍  C
 c   ] 02"0    J?! 00    Q   0  Q 9  0 @ s   n1  0  S  J/21 11  (6 R  J/20 10 (0  S  J/21 11 ( 5 R  J/20 10   \0  S	  J1   [     0   ѧ  PC 
  Q   J/ 10   
  ٦ @P   P 0 0     ὧ P#   0J02 11S2 k  
0~.c,0
  R``p@7  0  R
  
@
 R 00 T 0#  S *  
 0  S
 S@%   S%  * 0 S@  
 S  00@  
 R  * S   0 S  0 V   0J/ 41 0	@ 41b 左   @ T: T`h  
0 0 0g d  f0    s  P  $3 0 0 S
  
   3  Q ` 0 0J2 
11S2 A  
$0(  ~nc>0
` V`p  V#  
 0 S	  
  E P  p`F  e  P @g@
  4 P`d p  
  P    X   
     X  1 0 0 S
  
h  $1(  Q h 0$( $00 J  S00(0    S$0 0210S2 $  
 ~>a~.b
0
 , S  ཮  P  >  
81 0 0 S  
8  0   +0   S0 @ Q   0 0 J2  10S2 !  
  (0~>c~.b
0
  R   P    
0 0 0 S
  

   \0(  Q   0 (  0   P  U[Kߍ9
 ] 	 	 d[
 L6
 '   T  l[
 	 X0@- 0 @    P  <0    0  S 00
    R0 0 @l[
 9
 O-"M `p`v0: P   J ʟ0  @ʟ  |xtpyh9    
  	 P  
   P   
 `9 0
 L   
| !L   
   P8	  	  
x $) 9 0 	  
t  )ڈ0H D0  
p P шD 8A PὊ&    P  
)   㣫r`  
  h8 #    ᔫc 8@  P 0 @  P  墭  [	  
   0 @  P    V  
  7  ά7   @b 0 00  
   Z  
  e P @    0 ަ  P  
LX   C 뢫s똫6A P  =   F  Z  
AP =@ @   ⌬,   0 \00  催( 0  ~H?$ T  4pD4 08 p< k H0#  \ 00  S  
T 끫둭5@ D `   l@  @0 @,3    x  P  l@1("(08X # PL!#@垈0   0 崪 P	 
  Pj W0  0 0 [  (5 0@   
\      P  0A P0a   48#8"40 T  P  
  T T  00!0
 S  0 S  004 0!X0 ("48#8"< Q   T`%  #  <4 0@   
\    T44 @1 
0 0`y@ P   r@P
 T   `8  Q  
,0( \  墢  P9  
\ Sx3 P 0   
 xX  ,0 S  \   P  
\ F  P @   @   ,D m k2 0@   
$ -2 @  0 K1 Z,0( \  8  0@b  P : ,0 2 R P @     
d v[  
F Q4  1 1 $1 0 81 D1 d1 d1 l1 L1 \1 t1 t1 L1 T1 \1 0 S 4 B  4=      44    
             p!  ѣp  0 @ d@& ?d ~  P  ,0 `  ,\ 0 $ P 尣< 0<< L R
 4  Q    W  
L 0B W  D00D0DP \r  Ѝh[
  	 [
 '	 7
 C Q 6 { C	 M	 	 _	 
	 u	 	 	 	 [
 	  	 	 (	 ?	 5	 ?	 O	 Wn	 \	 _	 c	 g	 k	 r	 v	 ~	 z	 	 	 	 	 	 p@- @P   00  S      P Dp@- PDM @`   p⭨8      P 0P T   
d R    0$0   k@  T    ;$    
    T  l 1$    T  
*$    '   	( $0 ɨ  DЍ!	 	 K	     7	 @- 8#8S*    <( 0"4   G-@MP*p `   ὡ0@  2ᣢ0  l)0 02bb(@哢0
   3ኢ  0 ᖨ@Ѝ9
   9
   Rp@- P   
  	  `p l @ 0h ᲄ @P    8 嚪80 0 0 @c    
0  冦 p x	  l[
 	 G-M@H   XD00ş0E0   @d
 % l;`   5   审$ 00 0   
   P  
 "<<!4,4$#88 S  
S4  00c

p
00塨 l    P
 
 PP|@  @&
 m04 , ǧ"    S0  S     V   K
h `   `0x040  S07 07  (4厪4@ Px  C|  P  
 PA  
   V񟗻  8 49 \9 ; 9 <0 S
  0 O <04@4  0  @0}>40`@0 S   0  @0}>40  0  D0  0408 
   04008040  S	  >T#  S 0C40E  J 4 7    

圥D0  Sm  
  h   N* é  P  嫩%1 R|VU  
UwN@  ɟ  P @   |  @P@U
  NP&  㹟  P    @ 㳟  P       V-  (; ; (; h; ; @N
80 	 R1`8 40Y 0 @040<0@  T>
 0  40`Z6  T4
 @  D@@` 4@<@@@'9 0 40<0@0` Ѝ[
 	 	   d[
 L6
   	 7
 	 X	 9
 9
 +	 '  9
 9
 9	 `	 M	 ^	 T `  '  @- @&   0- S&  0- S  0  S@  
 Z  P	  0 @    
 P
    Q   %d Z  P    T!  @L0@  D0     Q 00   0  S\0
0 0	 t[
 g	 x	 	 9
 x[
 O-eM F/@  㬟4   004 P$  4`᳐pP  pZ P    Q  
  X  $ YE $0e   Sd1 F$0Z?  ,6%0   P$    Qf  
  W  
$  0+ S  0  S pq  
  - S  0  Spj  
$  $0Q   SP1F $0U?  QqZ   P    Q?  
  [$ z $0Q   SP1F $0U? s QB   P   01 Q%  
c   P  
   001'0/   P  P  U*     P  `  V  
 F  0 J    P  0  S   i   Z  
 U  $ ^ $0y   Sx1F $0_? / y@   Q]  U4/  
  V  
    P  P  
  0x 03  Z 0  S  
 Y  
Y^ύ   yA  F _? @ %0  S7%0@Y@5  
$0 S  
xYύ  ,5   S    T  !   w	  00,#, !$<  00#,,!$<$ (0`BSQ F U?T    Q
    T  
x1 S  y1  S  
|1 S0   
 0'0KO >     (       P   eߍ9
 	 -	  	 2	 :	 D	 @	 Q	 t	 @-4@     P   傧   00 9
 	 A-0M P0C8S     `R  Jhp$   R  
0 S  40  S  
0   
@ h  4 0 +   Q   I        P  
2 S  S      P  0 S  C  >@  T  
@  T  P5  p   p. S   PP  T&P@< 㔥A0 S  4@ ,,,2r  P  
   U  

0  S  
   Q  
00  S  
p Y  H0  S  
oX ,0  S  
   `W PP  @    ᴝ   TT1v  P        Q  
(̞2 S  S+  1pP  @    從   P
  
 0A@   0 i0  S  
0     p0@ A  x0 U
   Ѝ9
 	 	 	 	 	 	 	 $ 	  0	 	 z	 	 	 		 	 	 B  	 ,	 x[
 4	 7
 C	 J	 @- yM`0@8S  , R  Zba  t0  S  
 P! M    7 0  0C- 1P  S111  S11$   R  
0 R 0 0#  0 0#    0  S  
  P            P  <0  S  
1  S  
L   0  1  B p#   P  0  S&  
0   000 S  }  P  
    0@00@   00   0000 0 8@@b@  0 S  00  S  
@ W    Q|  

 Q  pٝ  h֝  Q   

 <  D2
p 僟  P  
@    P  弝  
  <   岝  Q  
 
 <  姝  Q  
 
 <  圝   喝0   
00h叝0@   
@00P初0    
 008偝0   S00ŵ  y  Q  
t  P  
0  &a  V!  
0@\  ף  r   M   @\ t     @      |x H
 㸣  yߍP	 9
 :
 	 c	 j	 t	 	 7
 x!	 	 	 	 	 	 	 	 	 	 x[
 	 	 	 %	 :	 O-e5 MM P P  @L΍H΍20@  S0,04 0(0  XP  
 0  S  	2 SG  V  P
    Q5  
" 2  S<0(04   P    0D> R&  
 009
     P  
 @$ y  P  
  0D> D>0   P040  
 P  0  S  
 0   P  0  S      W  
   pP    p   QL M T3  % 9- \    W  
  $   X  
 00< 00І0L  
  0  80x 80  S  
  P    Q  
L   9-  d 2  S S 0090^  b  H~V  P 0 RP  (0  S  
  <CRI  0 0# C  0 0# =  <0  S   0  S;  
N@    $0 0C  ,>  S(>,><0  S  
,>  S  
  
  0,  0 
@ B
 P#+   P   0  S  
0  P    
        P  
 p  W2     X [L^$    X     P  2 SpHN    0 S  0 S   0 S	  (0  S  
  <CR      t @  T P  U  ߍۍ 0 09
 t[
 9
  D	 J	 	 :
 g	 :	 %	 Q F @-  @  Q  
` ZU P   P0 L   Ɵ P@    P  @ Q  @e	 d[
  A- 0 ` @ p   j   @ P  U p       嘟	 O-EMM @ B.  @c42E [   00 2  p㳰2   0  U  P    Y   P  p  W   P    X  	   P    Z  
   0  S     @ `  VBN@      X  
@@D0B  P `O
  0    BG
 0PP00 00b0 [  
  Z .  

 m      W
p  Y  
	 e =L  @B 0 %
   W  
 0@ S   d;   @0B  
 BA   C
   P   TЍۍ9
   	 %	 }=	  @-   d  P
     ^  P  
   @ܠO- M P  Q1 
hT P4      PP    P 6&  P   000Y  xKT @PQ  
 TM  
 T    X!   T     P.  
 |  
    :   T     P   
0 s  
    +   T    \%       T  0  S	  
  Y  
       Q    x*T T    Ph     T    P  D뀰〠P p  W  Y  `0  SK  
  P@ `   ) 	቟P 2@   0  0:=* @" ^ {PM   `	 c T  L
   P   㹛 P  
    @1嫟 X  X  
	 ᣛ  P  
p@	 ? <
  P1啟 B   	 |  
P@ P    Ř %  XX1`} *0 s  
0@ P    ᯘ   1@g   [ #  
@ 0  PX20* 
  
Ƞ ,Ƞ
0 0H     0     }Ѝ	 d[
  	 p 	  	 %	 	  	   %	 +	 3  8	 $  e	 #  s	 C  	 "  	 5     \ 	 9
 @-@   X 0759
 @-4@     P   q   00 9
 	 E-`oM  0A8S  6  0 əz u0  S  
 Qt R  Z
OP
 Q  
   Q    R     0  S  
   ] 
  Z  S  0 SU 	   SR 0 SO 
  0 RK    ꀀ<0  S  
 QD #0 R@ P0  S  
 Q; %  R  0 R5 d0  S  
 Q0 &0 R, x0  S  
 Q' '  R  0 R! RO @  җ
0  
 <0  S  
gd#   P P0  S  
5  S  g8    P d0  S  
b&   P  x0  S  
7  S  b    P  0  S1  
1
 S  0 S  `1  S  
0 s  
0  000 S  7  P  
t屜0@00@   k00 0000 0 @@b@  0 S   啘  P  
BG  単L1  S  
 Q    
<u   ~  <n      Q  
t  qP1  S  
 Q    
<Y   Hb  <R  4    Q  
(X\  Q
  
2 S  
  <@  JX!  R  
$0 s  
   ?d  Q  X  
  <)  3`1  S  
-0
 S;  x1  S@@0    T2  
0  S  )  H1H `  V"  
4   Q  (Zz PP  
m/>ⷙ P  1! R1 0 ᇖP 0  S   <  0  ~    Q  
 T!  R  
0 s  
 X   
 S  oߍ7
 1	 9
 P	 :
  :
 4:
 H:
 D	 	 {	 \	 w!	 N	 W	 c	 l	 w	 $	 	 	 x[
 	 8
 	 	 @B 	 K\	 	 A-MM # @ ⌖,3  003  ` 0C PpM  `PQ P 1  pb b b b b hb c P?    Q$  
B   0%  S$40  \  
B>  0 	 2p0%  `  V    X     0< 0  0  S    B    0%  S$40  \  
B> @ 0 b	 2@0   Q0  SY  
FN@ 
  {  @X@ 0V0  
  S  
 }  0  ]	   T  
 t  0  T	 0@F  S0  0e	   PS    UK  
  WI    @H1- 0 S8  PT  Z(BN@@  ߕ 0   @4  S  
@40N2C10  ,4  S     X  44  S㲀84  S   V  04  S`d00CF  	   P      f      Ѝۍ  9
  	 	 	  	  	 G-4d9MР P20  Y 0  
 0  S  屚;P @P  <N  Q  
    P  
 PP	 P  x+  <N~  0D S    X   T  p  Ws  g   T    Qb  

 $+   T    QZ  
 P P  
	 P 0  

 P\  
  
   P  
  
 <>   T   0 0L   T"    Q<  
O
 P    Q5  
|
 
 <   P    Q,  

 X P  0  S$  
<C 
  
   ß$   T    Q  
O @
 T    Q  

  T    Q  

  T  0  S   U
 B 
  
   @  @P   p   Qc  Z   0  S L@ 	  <
  @X@ 0W0 
  
  S  
 >
  0 0  T  
 7
  0  $0  Y3  
 0 s  
 Z  
 @P	    P  ʰ   & ZU  
00C0 00<0<00L@
  @	  0 0 H 0  S<  
E  P
 8   0 s  

  *	 )  ~@@D`	  ე	  @9(^@@P@̠$  0P`(^,^k  P  l 堝 L  k   9ݍ9
 9
  0 	 	 A 	 9
 J 	 4:
 H:
 :
  :
 	 ^ P 	 [   j 	 G-VM  @P @T$ <L4V.@@00W>CⳐ 00(4B Y    
00 00000 0 p0 0 `  N  P    Q  

  ?
 0 I  SH5 @0    P    Qn  

  ,
 0I   SH5 @40= 0 `|   P    QW  
N P  0  SP  
p  3
  0 
  g   P
    QA  
U F   P    \5`0W   P
    Q1  
U 
   P  
  h \50G  0@ S    XA    	 P     P  
(  0   @ 2   P  0  S  
  000C	 S  U A   P  0  S    \5`0   
  
   = 0I,  SH5`04  \0  
<  @ =0  P   QQRN@ )   X	  
     0  @  0 S    W  
0
  k   @L0  } 0
 S S0  
 S S  
 S  
 S   Y 0  
   000R  S0A   0   P   Vލ  9
 !	 p 	 A 	 J 	 i 	  @-  @  Q  
 M  P "  dp o p p p p $p $p 4p <p Dp Lp          @i  @`
          @ 	  	 A-FM p #` @ ߒ3F  W 3ß  pG>000p3      0   H|M   <3 8   R    Q  
M@  n  IT0 @    R    Q  
M@  Z IT 0 @  P   0@ S
     Pk  
p  0  @<    R    Q^  
E J	   P  ,c  \40c   R     PO  
  0  @
  U   R    QA  
E 	   P  F    @ \40@ S
    Q.  
E 	   P  x3  \402  
0@ S  @  T  
  0 @   
0B S     P
  

  0  @ x 
0   R  0  S  {
  R   pE  	   P  
  j
 \40`   QG0  S00  X    W00BN@   A  g   P   Fލ  9
   !	 d[
  5!	 @!	 D!	 (	 K!	 	 p@- (M @  Q  
 L P  0     P@    P  !   \0 `P  UP  V    @  "  a      (Ѝp$"	 d[
  9
 <u @-paM`  W 0  PS  C  JM @  ᩑ0   0P S@  

 S @@X(  QÒH1  S  
 Q 
   
<	   岒
  
 <	 1 d    Q  
妒  壒  D1  S  
 Q 
   
<	   t咒	  
 <	  \    Q  
P凒   P  
_  4h1  S  
 yL  Q  
s   P  
1   kl  P  
@$  
[   ` T   Y 
 P  T  Q  
 
 <A	  | K	  t H   P  
 $0 
 㰘  aߍT!	 Y!	 _!	 7
 e!	 g	 j!	 !	 t!	 }!	 !	 !	 !	 !	 {	 !	 !	 p@- M@ 
 [    @
 $$0 Pḗ @ \
`  Ѝp  "	 E-`lM P  4 ܐ 0  T 0@0 0 0@
00 0  K  P&    Q  
K0@ S  )0  S S  0  0@ S  )0  S/ S	  /0)0 0@ S  )0  S) S  
ll  )0X\͕ P  0  S  
1!. 0  1! @ ^  P  
 5	      	  < <( "4  403   P  0  S  
1. 01 @ A  P  
 	     	  < <( "4  40  	 P  0  S  
1. 01 @ $  P 0	  < <( "4  40  
 P1!0 
  
 P10  
 P10  

 P  1!0 1!   P  101   P  101z   P 02v  
 P@r  
 P
    QJ  
0J Pi  
   0 e   P
    Q=  
J P\  
   , X   P    Q0  
T dP   P    Q(  
J PG  
  H	  P    ( >  0@ S    Q  
\J P	  
d     P  
  X0 d0   0!0'   P  0  S   *  p  W  
    +2 Z  X  4 
   
  P  
 }
@       0 0P   Q)0  S    
  P/0
  
 l   P0  
 T   P  )0)0)0) S S  1    1    
2  T0  S  
4PT     㛖0 @ 7 D000  S  0 <2S1  010  S  0 <2S1  0100<2S  ,0  S  P {lЍ:"	 #	 #	 8#	 6	 D#	 I#	 N#	 R#	 @!	 }=	   d#	 h#	 #	 m#	 +	 3  #	 0@-|0$M P P@   0  S
    
 ᑕ    @J40
  @ U$0
   0 ᎐  $Ѝ0  #	   #	 @- @8M  ),0  S  
2  ST   
-0) S	  
/ S  
 S 4  
   (  $  8Ѝ #	 $	 
$	 $	 $	 @- 0 M    S@
 
 G    @   @
 0圕 I   Ѝ  C$	 @-M `0B/<  , <  /@0 / @0) Q4"  
/ Q,"  
(2) Q$" 00  S,0B  S0 Џ0  S  
    2录 1 P` @   T	    @P  
ᵏ ގ(  Q  
宏  x嫏!0  S  
h妏!0   
X塏!0   
 /@ @v   ,問2@   吏    
1    
 0 R 
  
10  
  
  P  
 {1    
 u1   
0  n1   
0  g1   
t0|  `1   
X0d  Yߍx	 d#	 Q$	 `	 Z$	 V$	   z$	 $	 $	 $	 $	 $	 $	 $	 $	 $	 $	 x[
 $	 %	 2%	 R%	 A-x-M `pq P  
4@  㼍  ḍ   :ɍ @P  
 0 0  ˎ P  
{  ύ ͍ύύύύ+΍ύύ ύ$*΍( ύ/?,婎 PU   0  S  
 ፐ  PM  O (     @@1 Pᆔ @ *  T  <'1R R    ̒/  R-  O 4  ᥍  P#     R  
D2 S   0  S  
U  P  0   R  
d2 S  ,   R  
`2 S	     R  
L2 S  
 4P  ,  Pr-ލП	 %	 	 o%	 %	 '  +	 
  %	 0@- <M @  Q,  
TH P  H1 D  兒  P@0  
 P  $:@   P  P  c-0) S   
/ S   
 S   L*   P  L-0) S  
/ S  
 S  0   0t   0d   S   P @  	          >
 㮔 <Ѝ0"	 d[
        $	 
$	 $	   @-  0 S!װ000 c Q  ڰ0 S   S    Q  
  	  %	 7@- @ P  0 S     0 !P0  0  0000>A- @  p` P  R     `P  ⥍ 0  000 07@- @  P  0 S     0 !P0  ㊍ 0  000 0>O- 0<M 
`400Ԕ$@ P00 0 0 0 @P{0 "  X000    ǌ  P@  10 00  :  40嚎 `P    0 S
t倕  hs @O   QT  @2   0  @<o  W 0 R%  0	 S"  0 S   Q 0  0c  S 0    X     &   P  X  
  @   <00@`c V   P(p U 00E?
 0    
X (  V
D @ W <Ѝ%	 l[
 &	 
&	 &	 5&	 G&	 b&	 r&	 &	 &	 &	 O- p4M
2:,01 (  0   00 0(00 0
0 `P   0 S
80  
 Q$:  P'      P   0 R    0 R  0 S+  
 S  # Q   ϐ @$  0  @ 0c 0Д   
 9/ @P   000P`c V    Q   Q0    
X 寐  V
H ᴐ @ ދ  T  
, 子 4Ѝl[
 &	 
&	 &	 b&	 r&	 &	 &	 &	 A-Mp @P`   l   0 iЍG-(M` P 
  W@P  @@ @p  0⼀@ pG(Ѝ  7@- $  P:   W@00   H 00"  {  㳌   >A- Mp .@  P `'  

  q   P
P   W       : ъ PP 00 T Ջ P  0 S  4       U0  
`@ V Ѝ0	 &	 G- Q p @  RR  
|0 R   0 G  U   L  0"@D`  00 @D`P   P`
 U 
  &	 &	 40      P0/  0 S/    P/8
   P@-  
  P  
   @-  @ :     褒 p@- `  M   + PP  
  0
 < 0> @   T     P   壏 Ѝp3  &	 p@- @PP  0 p  P  
 p0  巌 p	  '	  9
 p@-0hMP SE   0 S  B   h 
 P 0`
  0C E0
@  S2  
@ 0  S  @   0  0Q  0 S  
P @  T, w 0 @ 000  0 0000  S000  
  B  R  ,  hЍp8
 A-PP `p @D00 S  
@ Ԋ~ T0P  ͌P '	 8 (	 @-pp `] P      ҔP @  @  	   (0
$  &]  P ]I (	 +  @-P0 0  S  D J@0    404 0004,0 4(03@$8
   8
 (	 (	 D	 (	 (	 @-4@ 0  S	  ( +$  0    0@$8
   @	 (	 @-4@ 0  S	  ( $  0    0@8
   `	 (	 @-T@ 0  S  H D0  0808   400 4,03(0(3@}8
   )	 )	 )	 	 	 )	 G- p    P  
   P  0 0` P@  T  
   P  0  PPU` 	  . P      p@- @Pk0    0p@8
 p@- @P~0   0p@$8
 p@- @P0    0p@8
 p@- @P0    0p@8
  Pp@- @P     <ڋ p3, 0    P    ͋ pS	 8
  Pp@- @P     < p8, 0    P    峋 pS	 $8
 <3	  Pp@- @P     <奋 p1, 0    P    嘋 pS	 8
  Pp@- @P     <勋 p+, 0    P    ~ pS	 8
 p@-X@ 0  S  L !H0P  @       0  0p@p 8
   @ 0)	 p@- @P0    0p@ 8
 @- p `@ p/@ PP p
  
 p F P/0 0
   0@8 0/00 0  S  
 6  P  
     0   0 07@- P @C  R )  
 R
 &  
0@ S "   R   
 R   
 R   
 R   
	 R   

 R   
 R 
  
 R	 
  
   
0 S  
 0 P  S           >t)	 @-@ P #           ( 0 8 @ H p l h d ` \ X T P L H D    8 )	 / D	  	 2	  	 )	 )	 )	 )	 *	 *	 S	  P  

 P  
 /*	 A-R@ `p  
 !8  P  
     
 0`  #10 "<<!4,  4         ی*	     ֌@*	     ь   Όi*	 p@-`@   Pᜇ Z  P	  
 U  P  
 P  P  
 T000 00 @  p :K  P
  
  T
 T
  @@       P0
      T T  @@  
   և  P  00 00 p  p g	 V$	 @-M  @    P  
0  v Ѝ*	 _0	 #	 E- RMp @  !f  9
   P	  

 p  P  

 `  P   pJ  /
  `P 0 0 
 z PP3   0
 S0 0  V07  
  P0  0 0  S  0 P    _  P&  0 S㲀   "<<!4,$ 0b0  
     R0 Qđ  
    V  
/0  U 0  

04 4   Ѝ P*	 *	  g	 V$	 l[
 *	   R@-@  ( ( $  P  
0  *	 #	 *	  7@- 0 @P  S  
  㗇0 0  S   > 7@- 0 @P  S  
  ㆇ0 0  S   > A-p  Pa `   @    P Ps p@-|P @`i   h@  Q  
  H  Q  
  L  Q  
   V V  
D  Q  
 p@ pI
 p@- P     0   
00  S  
 0! R#   
0 0` 0  Q  \  
 70 0   00 0<@    \ @  TpI
 3	 @-0 :L @ 0 @I ЍI
  @-MP @p ` @`@ -M  W	  
4  :B 0 
    ߍ,	 I
 p@-
M@ `P m.  6 P- , 
M(  :B 0 
 
ݍp$,	 I
 E-M@).  `
 ԅ 
)."  P
pT   PQ  L) 48#8"T PH  :	0 SE   0E SB  1 148#8"4 Q8  ).0E8$("(!$#R-  0)΍  
 @ U
   T#  
  	 㙅)΍⸀0  㺀@   T  

 C
   T  @E  s 0 4< 8 < S   
( L ߍrI
 zcSc7,	 @-  g0  4    @YL6
 I
 @-@ 0  P@*ЍW,	 O- 0 ` 3P	pV@ dm|3	0@  l 
 @  0I S  ꠧ x @  ħ   T p    _    /0   0`@           0 0000$("(#$      Y"8#t2,$ ̇ @     00   P  U    0pG     P0pG ^ ` Z Wq    u @  ᥇ @  k @`pG W]   W[      RX  0 ST  0b 0 SP  h ቇ @  T ᄇ @ (ǅ Pp` 0  U$!00  4P8p#8,4j U `  .&      0pGP  S	   
   @P  

 ׄ   S  \pW  J  P @Pph  W   0 0 00` W, 2	 +	 e,	 '	 	 7	 	 r	 ( 	  i,	 O-p"M80 P  S  
  P `` p	        P  
 T``p20@  T 4   P  ᶌ1 0彋  {  U\  
 r  0 @⨁na'   p   P  
H  a W  
  0  #,,!$<4   0  S $勋 I ̄  ` 0  S0  48 `  
 1    0   l0  S  
 lh &   ,0  S  
,| ^  H  80   00@0f   > @  P	 ЍI
 3	 p,	 },	 3	 3	 ,	 ,	 ,	 ,	 p@-P @0   M @  P   0 0 T  00  0       T  
@  `嵊:D0 PC S  0D S   D0 200 0 0`喊0 P ЍpP6
 08
 I
 t @-|0 `P 00C S    
 ႄ 
  @ J d  ,
@ $ zJ  0   ,8
 ,	 ^	 ,	 O-D˟D_MM 88˟@E ō$$˟${^^0˟ `P8˟Peō^΍ʟeEʟe^.]΍ʟ^> ͍͍ ͍$]΍(]΍,]΍0CDx 0 PF    
  h(H     
 Q `*0L 0  
哂   
0g0@09 ɟ00
  ] 8R} 900 0# 5  S
  ]'R: @ᘂ  P 0 0p  %  R09X0 H   P@>    
  = ȟ@       = 0 @ 0@  Ⓝ 0  S  
  < (D 	  
8   ( 00 0"e8 @P  L8`4 Vl8t I 1؁`8 \ @  L8@@ 0<0  {  7  0  ȟS~p   0f   S @5帕  [΍D  	 	0 彃	 P
  < 0 S  D 0b `冋  |7 0 S  @ L   ,   `|  Q `5  S  
@ \&  @  ^  j P@@D   ZP  
 2
 b
 P@@D&9 \
  & 0 S0 0  1I@ P  @ @ 5      
$I6     
|I@r U 0@0`5  S  
@ \  P@@DU c2
  P%
  6 !
  {
 ` H@ @ `U^ 5    5     `< U   `5    	  U    
 PA\H  $S5  @   7 
  P!  
 P$  

 P+  DH   R  02b 	        
 4       4 0 S P@P
 
QH  

 	@  p4    P
0$_΍ 2 1032 
 P
  
     p @
  <  僀 yHE3  D   T0b `r W" R4宀  P
5   P  ZH3 0 S`  T     0 S
6   P  DD  

2  P  ĲТ     Ps  
3w   P  .>   [  5#,,!$<$"	 R%  
050  
 2 0  
  P'  pHP@R@De b 2 Pp$  6   ,G 1 0 S  

 x 1    U@ `V5xAPH% G  1 R
Т\0 0  <  
'  

 6#  ꀀF386`0 P-DG
<@0 0 S  
  9  0  P  @P` @0 0  S  
$4 Z }ߍۍ[
 -	 +	 [
 I
  9
 ,	 -	  J
 J
 J
 .-	 3	 J
 I
 '	 d[
 L6
 7
 W-	 ,8
 ^	 l[
 P6
 	 @  (8
 l-	 -	 -	 -	 -	 -	 -	 
.	 08
 .	 ?.	 g.	 .	 .	 .	 .	 .	 /	 /	 ./	 [
 @-h@3 00   P  
   +0  #,,!$<$  R  $ 0 S 5 9
 p@-@ P	  0 48 <0##$#8 0   
0 4
0#40 048<0##$#8 0
 048<0##$#800
  6p@/ 9
 p@-` P@    03 S  
  @  T<00=00>00?00L  Q  
, ? P  Q  
l  p@xp9
 0@-0 48<M @  
        Q  
0   0
  4 8<P  8P 0, @  P@ Ѝ09
  O-鸇ZMMC00zD0Z. ` 0(C@ P   at7 @p7  @  
d7   H' 00 0   
c00 1$  S p a7  ~D S6  ~F 3	 6  P 0  
  >  "<<!4,4 00 (0@b Q   ^(@(0$  ໇x6  @ | l   
0   P@~ l ˈ,0   Y      O	> ,0 @  S  
 0 `5,0  S  
5  S  Y΍   O0 p  P  
  5 0 0 SO
 
 P  
 P  
  P
  
xF 뒈,0dF @= O 	   P	   p,5 0 0 S
	 O~2 S  |2 S  
  54
  P  
 0  S  
 S  OT   pP  
E"@W>x%  @p%tu@   [  @6
  `P  
Y   5 Sy2
  PP  
Z  00C Sk x X x x x  4 _  [  Wp?    T  
0  48 <   2	   P  
 Y  ^ <(  <"4, $ R  :0 R     P  
    P  
50    0  S
  
	  0PS 8      P  o ,8  ,#$@  $3 {	  J } SE}    U  2  S5
  T5  
0  4u8 < W+  @_   p ,8  ,#$< $3 ` N	   } &E  : c	   PP  0        V
@   7    V  U
  T
 0 4%8 < R   }  `00     V  T
 0 4"8 < R  N < $ 0   @     |0 0  S  
D ~ kߍۍ9
 2/	 L6
 7
 d[
 8/	 7
 W-	  /
 9
 I/	 |[
 9
 l[
 q/	 
.	 /	 /	 /	 /	 0	 .0	 B0	 [
 @- 00C S  5   P  
    O-M,C< P1   '~  P  `孆 P 03   
 嘅p @    , S 00p 0  Sۅ  @P`  @` #~  @ @ VP``叅 pC  @    P   C  P  [ @ T  /0   P  
 ߍ? ! 00  P 
  /20 10 0 \ (  0 ,Ío~  P   2 10S2 +  
   `P'  
R @  0 S  
@  T   ] P P  
 P  <"0     S 00  0   | P  
` [  @ 
  0  S0   }0  P   P 2  10S2 >  
0Íύ 3΍/ 0? P2  
  0 , '   P43 ,0
 P P  
 P P  
 P    P؄?P` @  '  0  @ ύ   0  	  k|	 P  
| 囅`0 VTP@	 `   0 0cx S0    |0@P@  T .T0	 9
 l[
  O-M 0  @} ⑄   
   @   Pr P3  R. R  0Ln0q 03? Q0  S  . R  0. S  
  U 	  0  S  
A0B S 0  L 0j S  
 q|    Z 0 0
p8     0 00;    [ P!  ,  @0	 SP  
  Y     0 ` d{  P	   V  
 0 S0? 4@ 0	P   P0 U    U  E4=#= 0P   0p 0  S0  0j0 0 ЍO-    @ `P2  0 p0  S	  	 \?   ?0   V`    P  
 0	 S2    T  
   | 0   TP .00B	    V   T  0`0B `l0 U Z  	 Q:  U  
  T    ]| @  Ѓ  P q|@  00B       G-h28M8 0"\\2 X TT2 ?  @4 <2< 0|
 ( S(@,P  $̠(̌%<"Č<("4\4L@ 0"P|,0 ` S  2  (0 S/  b-  D}*    Y"  @f Qc| P wc @sc  U  
PQ| @c< P <c< @ bc 0A|  8 @ @| 1 }@
 $ l$ P'   0|
 -| *| '| $| !| xz   |0#("<"@ P Uʥ T  8Ѝ0	 b0	 [
 0	 0	 [
 xK	 	 0	 0	 Q 0	 0	 7
 &	 &	 
1	 @- L8  L!̠#D̌8#ČČ    4  A- 8M  pP?  0  P8    4|# @r_  U.  0 T+  #    <(  <"4, $ R  :0 R  0#,,!$<$ d  R   0  O   P  8   `$  ك$ P
 {8Ѝ  9
 1	 O-ı$M@ ā Pi    {  ?   0 c 	  h
pI  lA 0  48 <  
0  4 8 0b#,##0    `  0  P$ 	 0@!<<.440###80 & 0((((  $p(0 Z:	 v{H   R  
@0  0 005]$Ѝ9
 A  |[
 A-A   0@ T M p  @  y  P  P` 6/  P
    ~ 6/  0 T 
t t0M  P Ph@dP M !, <, <H ,$$4 $ 40 Ȁ  :1	 ԁ  + Ā 9
 @-@ $P h{  P  
`{  P  
   <~{  P	  
   P  
  y       Ѝp, @-
 @ l0   0   p  3l[
 p@- @  Py ᤁ   p@-X0 p @(`L0 P  0  48 < S$P  
@ T:  9
 |[
 A-H0 p P(`<0 @    x  P $@  
P U:  9
 |[
 @-0 @ DH  Lz  T  # 3G- P p@     X  
1     x  P
  
  W  
1   0  4 8< S  X1 $    
yP$@<a(0 U:  z 1  P(` @    0 48 < S 0! !$P@ ^:  T-  
  $ x  Z  
  
   R #fT     0C^ S^00 0  S  X  
  y''4'(0 p  Nz	   4 (0    |[
 9
 s@-TP `  0   @P   /x4  $ ?4  0 @n |9
  2	 G-<  p,  0)  
 S'  
(<(<"4,DT Y   P    P   	  P1      W  
  ` 0 @P$4 (8,< R   *p0 X  W  
 "  P  
 0 	  P  
0  48 L    @ 9
   M    0RA  Q0 	      000    8#8 @(    Ѝ/@-  
 E-  PMp  x `P @P7  ^  
 xȠ ,4 8
32,<00p0\y p @P  
  
 w0 
Ƞ ,4832,<000?w p @PP  
    t4P @ Sy  T    ЍS2	 ^2	 g2	  t	 O-M0 P @  ex `P @Qk   
  
pw ). w 0 x22< 崺 x 
 x  P @<QC  2	8 $#Ġ(Ƞ"(,Ƞ#̌1実 , 00!P$00 .!@   40 
000!48ᮟ#8!< 0@@0
 0d0    0 SwDP @ x  T   ,~ ߍS2	 ^2	 p^tvf ;	 p@-/@ P Dw /㒀 @P#   0 4| 8 < S  
l S>@   0 S   <   P
  
 R R
  4v  P   
040#$ 
0 pcSc7,	 o2	 p@-/P  @w  U    <C<3d 0 00000}0c 000  0   50p@5 @-80 21 S2   
  8 P   48
 p@-   @P 00  R UP0`  1 21   1}2!!!0    U   p48
 @-,@ ~  } } '}%@U48
 \ @-$0 a  w P  
 48
 w2	 @- `  @ } P] ] p  h  []  P   
{  
 vȠ ,4 8
32,<000
@} Ѝp2	 E-,MP `p    mv  }0 @ 1|  W	  
  0 `.}  P  0 0  X  
 | x0}  P  0 0  Z  
P T P0}  P  
 w    
  'w w  ,Ѝ  2	 3  +	 '  +	   0 S   /    P/p@- @P    u  P   p @  T pA- P`p   P 0  S ~ @    vpO-䡟lM  

 Pv p @`   f  i\ p  [  `@ <  u 0  10v0'0<20 2 <2ᰢ&@v0PPp30   30u  IQ< `  0 u  P(  }NU0 ` ` 6Q  P    
P< ` ~  P  ) P  ڸ2S  0	 S    [
  
  t  P    20@`  T@    @` v lЍ  + 2	        S 0 0   0 S/      P/ 0 0 S:  /p@- 0P`0 S @   }  @{(0 0 0  S  
 z 0d 0 pl[
 2	 E- `  P0 pP.  @   0 0 S    0 P  z} p  v}@ 0   0 @v
        Q  
 0  0 S: p/   0   +  
 
  0   0 S@    
0 P 0 Q    3}   00 S  00 0@    u0  00 ;u@- @ [ 0P   0 0.u p@- P @M0 `0MS  : $ p@y   u  00p3	 @-l0   R   0X 0000000  0   R yЍ 3	 2	 +3	 A- ,`lPpaϠ      \  ʤ y     QL 
 Q  |00  S  
`00  S    @0@\J Q   4 Q0    C3	     @- M @\ 6/  P   Ѝ0  S 00,  0 R: 0   0py3	 f3	 G- v @P
u  
  #1 0 0 P  S00 p  
 1p P  v @P_  
 0!0C
 QV     4 L x         
  
 )@ P  u  P
`>  
  U=  
 P*   u P7  2     t       t  48#8 <0     t     t < <( "4  4 00 0Ps P3  U  

   0	 }  U  
 0      P Ѝ P6	 l[
 3	 3	 2	 3	 @-PM PvD   R  
 R   $0 4( ,0.,Š !"%#5 $0 4( ,0   0"%,0 $0,@00$ 400 (04(0  0 t  ,0d||  @t40 hh 0l t 00 4$ 0l0a8 8 t  PЍ4	 4	 4	 4	 4	 4	 5	 4	 -5	 5	 35	 O-p@`@P "t  V @T@V   0- SS  0l S(     P%   Vp2 `   PcS   000C	 S
    
 ~ 0  S    cS7u	   lS  P  +   NtP@  TPv  a Y  q S
  0  S
  `V@   bv 0- S  
    VP  
0s S  0  SP`F ?S P  dx
  `F@   
u  V   4xPD  a Y1 P =   P    5 0 `  S @    XP   w   P	  

>u  P  
  XP   {@   P s@  T   0 
   S@ } 0 `  S  
T w  
u  P  
0 {P@  T l[
 :5	 P	 N5	 c5	 5	 5	 5	 @0  00g S  (0 0   
  s std[
 [
 5	 P	 O-DM@  ( ~r2 00k S   P  P  
 0- S   R p   PLL @@ @"80 8 8@62    2 @0k S     
|R  y  kt<0   S  t< 1 < 80   Z1  S  
0  S   
u   Q  
   Y `p@K  (0  SG  
P  U hP       0R S 00B B  Q8   R  ,0 R1  <   R  40 R+   0  S  
    0 s  P    
  
00  S   r40  S        0 R  
  (`  
 Gr z p   	 L    G @P  W  
	  ? v  3DЍd[
 5	 [
 5	 7
   G- 0 0"0 P g5@  	A @P  
r4w  0p 0  4d4 P `   @      U0 P
  
@  Tl  r  p   pP0  S q   P  W  
 ,y 5	 [
 5	 5	 7
 	 I- KM 00"1  5 @$   P  
 P0;   K  w 00CS 0  ; 0 ps 0  p  8 H @*PK  `0 6d0%@K 0 0(p yr 
P( `   M@h0 F JsР F pPK5	 [
 5	 5	 1@ 1  	6	 6	 G- Pq.0 ` 0 E
@
   p. W	     q  P/0 0
 p@D T 00A-hM
 ``_0:	S"  2 0 @   kp pP PP     , @P  
 0. S  0/ S    
  P Eq 2s  P br~   y y   p  / T.00 @  T1 0 0  
 =p  P  
  X  
0P  S  uPW   0h @x t!@q   Pq  P @  L14! 0 0 S   0 
, 0$$   1 y` 0 
  
zx 
r 0   
 q r P"  sI ` q  VP   yP  p0 0   
 q0 P Kr
 T  
 @  T @  T pP p p hЍ[
 %6	 P6	 A    l[
 n6	 6	 6	  6	 6	 7
 s@-P 30@     @a  
 0 01   S #D P w    
  w @% p0
|  C  P  X w  P@  
P  P   @ P   P |6	 7
 [
 6	 6	 km	 6	  ?	 0  `/ 0   R  3/1   /0  `/0  R  3/1   /p@-0@ `P P  P  0@ Tp9
 9
 <00!1 S$0$  S       0  S  `/9
   u9
  Qp@- P  :p$  ? Wd @Wd ` 
X 0  V 000  @ 
 W.00  0 
W%00 000 00 po7	 O- WM,SU@  0 Pqr PSoR   
 P EoQύ > ͍@_rPALHD@!T1$E,Š !"%#5PALHD@!T1  0 X Gr0 H Br P 0@H10Q/0 9r0- 4rL!T10bP1 oL, `@ HP PP  D$@ @P1 q4崤 0I 4 ep0XX   S10  R D\ V  1!T@@0@  Rc  Q<  
D tP  0 	 aAL 0	 Ja:H 0	 a30 	 aF, 0  p	 a%(0( `	 aB000 P	 aL`@@ H P0P# p`P/q pD T D PD \0T RVO ``dO Lx
00 n`P `0@" q p2TA 0," 2 o}V4 0  4 0 A4 04 R*00 V 1!8 c8 R#8,5p  qw/:0b8#8  
 V p  'qHW* VX< D  ,0L0` S `A   @8040J1!
 1o0<
 !1o81N T$% (($q @PE00,!N?0(10   @0 ,4A000@	   @p0	 S   	`  0 C0 0` q[Z<0 0 
 
 uuWߍw7	 7	 7	 7	 7	 7	 7	 7	 [
 v	 9
 08	 '	 :8	 e8	 m8	 9	 ~8	   8	 8	 8	 :
 7
 E-AMM  !:0 , Q@@,@Dlh!rw  P  \a 0 0Pp Ko 0P
  
 V  M @M 0 P0:0@1`p V40 8  @p0  0   n<0   , 0pl  n($0d DH  o 4 n 00C 0DЍڍF	 w7	   6	 p7	   8	 :
 9	 [
 9	 9	 ?9	 @-0@2 00	6	 @-hq0 #`  @vLFnD1@  0q,41  *0F/1n0 P0C S0 -   @            $  (  ,  0 VHA    0 0FBx L `n0P00C  S0 0 0 
 
 tt9
 U9	 [
 9	  :
 :
 :
 :
  ;
 ;
 ;
 ;
 ;
 9	 @-@B  im 00 09
 A-  M l  P3  
 1c S/  F @(P0`8p 0 P@P`pm P       0  0a B0 0  0  0  0$ R0 R0$     Ѝ:
   9
 9	 A-5P A pP h m h P   q0  S-  
1  S  !T! P0 ! P1011!  S0P0 u` l  1! `1!P   `}PP1 V A6l9	 9
 9	 P  P  O-`  0@1t  %     0
P      00`p W  
\!0   S   0  c 101   T Q0@0 Y\ l0 `0\9
 O-ş\Me  <ş H D0⸰/%5 L pp   
H  0- S0H0H _P L0   
D  0- S0D0D JP ys  l< 
 l0K00K
 
r?
	4
@P04T04X0XO00! 0P P0rP0 S  L0	 S  $ P SL i  `4 W*  
@t  0 0FS00  (0 d0 0, 0   00    0  00 08 0     l  h  l 0x 9  H L007  
@  0 0S00   h   l  (00H  L0 00 0H 0 P  T0 0 0  \0X    000  T0\ 0$0 0T 0(  0` 0,  +A PP  Q  p  2 W  
`0  S  kMl 0 2    |20 }jt2 0 P0 $2 W  
L  L4  X  Xq  
(R 0@  

 1mI< 	 F  PC W t P 00 0:W %0 SW  
  q RW S  
n R1lqP0  
m R  t1TqP0d1T0d1X0@1h R  W   Q0u'  p R  $1P0 1T01  t R  1P0 1T00X0p  s R
  \ Sk  0 `0\0|SpW r R00#01 Rc R0  S11  
;k9kL010  ! S 000
 rr  \Ѝ[
 	 9
 8:
 9	 36 !  )	 9
 4 N      0  9	  4 x [
  @- zm0@-\MT@ =l j @ Fm 0  k R  P  
0  Q   k< R< @RS P<S  U   
 k   k* Ƞ(d .,Ƞ"($H,Ƞ!"(#8%X4  P@k  \Ѝ09	 Q '	 	 :	 :	 !:	 *:	       	0 R  
 000C	 S   p  3/  = S / 0  S/0 0  0`  /[
 (0   0 0000000 /[
 @-   @  0  \  
     \ 000C	 S    /0  S / 0_ S 0    _ R  
00B	 S   0a0C S/   R/     = P  P  0  
 0 P
= P  = S 0  c/@- 0         R= R'3R0  [
    p@- @P     P  
 @ 0  S p@- @    P  
0     @n  p@-@0 P @     P   p@_ @  T p@h8
 h0   \ 0  Q    
 Q/80    R  
0 S    00 /8
 0 0  c0@   /9
 m۶!0 t0  B 0?0  S0        R  0C  S* <C/0 S<C  
 P000 /[
   P        0 S  
   R /  / ql0       R   Q  
 0  S  P  
     0 S  
   R  / /\6
          R/!0q S
/ /  /@- @  T     0= S   0  /9
 @-   p  30  00C0/\6
 @-4 q  00 0   0\6
 p@- 0 `     0  S '6Q40 0Q   k  P  
P @  T p8
 @-@    T  P  
0   A- Q )  p @0      @0SZ 0 0` 6g P  @   @ vk  P   @ 0`  S P   P 0`  SP @  ak40p@- P@@0@00C S  h 0@0p[
 0  000(  i[
 d0  @ 0 0G0  S  
0  S     P  40  S    g i      [
 @-,0  00C00  S   0  S   
[
 0@-  000o@[
 A-X` p 0P  SD@
  
@0  000 p 0 @  0 @P89
 8
 [
 @-0   00 0  S   
[
 P0 P  @- 0	  0  S  0  S  $0 0 0$ [
 0p@-   `000t0 P  0  S0  
 S  T0 0 S   0 0Sh    @    PP0 0|0 U@1:p@[
 8
 T6
 1A- 0 @0 ` pP 0   S  
  S  : R  
  : S    RP  P  P  R  
?% R 00  S  
 t  Pp p 0P@: S`L /@@ 0/ p 0  S      P    p[
 '  C	 T6
 p@-0 P 00    @g g gP p@- 0 @  S   $0  000      [
 0@-  0  0@0  Q  
 000S	 S  S  00 00  P   
g0    0   
 80   0 T 00  
 g@[
 \6
 8
 @- 0 @  S  
l0  000\0  0    0 0g<0      P0000 00@[
 [
 p@-0  SP @    tg @  P p@mgpp@- ` 0  S9  
 0  S
    0  000   @Yg @P    R0 S  ` Pp      R  
0 S\0   X0  000 0 0  @7g 0 @rP   0  S0 S`p89
 8
 [
 |0A-   @000 P0q`    P   
g`P0 sZ  P   
g0 00AE[
   P/ 00C  S 0/fH0@-  00040   @ 0 00 S    f@([
 9
 `0@-  X0 @000   P   g f   0  S  0   f@[
 \6
 @-   0  0 R\6
 8
 (0@-  @000h g@[
 0A- P` p   g0 @  T  
 
i  P  
   dg40  S  
X0 00  S  80D  @0  g @   h 
 A[
 7
 	 @8
 \6
 \<	 <8
  @   -M0  0@- @  P    @Ogf<	 0@- @ 0	 [
 A-   P@  
 @0 0 `0  00 T @ 0pP0d 0  0  S  
  @fP@TZ  @  T@ 0   0000m [
 [
 000  0  S00 0   P   
0  /8
 9
 9
   Q@- @  g    g  P   0 0 0 S  
  l[
 y<	 0G-  00C  S0,  0  000` pP  @  t    Z     t  
  Z  
  Y  
  
A fpP0 W 0 00  0 eG	[
 [
 @- @$0  0  R  
 [
    ><	 @P0  RM 0D0  
 0 S  ,0$ @d 0  %[
 <	 <	 <	 @-0    R  
 0  S       R.  
 0- S+  0   S'  
- S0 0  0  S   
     S   
0: S  0 S0: S
  0  S  @  0  \ 0  0 ,0  0    8
 L8
 <	 <	 8
 p@-  a T  0  000 P0 0`@    J  V   @ `  VP U@y  l  @P  I  P  
P  0L   0D @kf<  00 0,P 0    P p[
 8
 q	 7
 <	 
E	 L8
 p@- @LP   P@$ P t  P p<	 G-\1 P P  
 0% SL   p  R  
0@  S  % R+ R  
- R	    UAP A  :  @  U7  
-   h  P  
 e0 0 P	  * 0  0CP0   !  0  `? S0p@
  0 :/  P  
  V  h@`P  U  V	  
P  Y  
0 <@  
 $@ 78
 <	 =	 8
 9
   @ =	 $=	 2=	 @- @  P  
/  P  L " D0  P     \   0  $0c R 0      f<	 x8
 8
 9
  -M0 00p@- ` P0 U  ~U@!~O3   :d `0  000Yl   0     0@0   00e0p[
  [
 A-@ p0 ` 0;00P
 @  T!  
0   
  
 =d@= {d  d    `  V  
@    ~6/0    &d0N?P      Hl 0 @ 0  F   k p [
 W=	   Pp@-P
  
40  000 @  @  Tp@=p[
 A- p `    `1   S @k P  k @ 0  P  (0 @ f  00 `P  [
 H0p@-   P000t,0  @PHd00 0 0p@[
 \6
 A-@ `;d0 p  000lP  0  S    
 k 00 0@0  T  0 00@0000`p`A[
 \6
 @- @  TC  
  1 00 0 R9  / / / / / / / / / / / / / / / / 0 0 0 0 0 0 0 0 0 0  0  @   cl0                c40             @T8
 !<	 9
 @- @     00 0  @  TT8
 G- `p= @|c@P@ P@  T @f  
    W P  
 c Pt0  000  k  c  W     
=00  c  0 0
 GHj=	 [
   A- ` @ p  T      
  P     \0  000    b 0  0b"    0 00[
 @-0M  0  00  101)c @P    00   | 40!  100  S   0  S   
ލ[
 p@- P&c@ * p@:cG- 1  @  1 p000 j 0 `- S	  @  T   j1 "c $   7 pK= @ a  T     P  
 %    2 0 @0  0  P000000  
  0 @ 0 ` 0P  U L8
 [
 8
 0A- @  Q pP  
  0000 @ 0` P  
 P   
?b`@w @3  W U     c  Px0 00 l0  T 0 
  
   j  U @  
@0 000 U  
  b   @0 0@X  A[
 =	 =	  -@-0 0V@Ѝ/ -<0@-  0000 0a @8 @Ѝ/[
 G- P" 0  0    - R+ R 00  - R   p     R  
- R  0  S  
p    Z    R  (2  08 9  0  S  
  Zc R     P1 0j  o R@  1 0 P  U  
 @1 d  P1 00 1p(  
@ T  W|-+  T1@ P`  W	  
D11D!@1  \<   11(   Q-+ @|< T`P   0  S0 0'  l R 00  S 0  ,0   
  
- R   c  P| 0  ,0   l01 0 ST0 00 1p  
 Q  W-+L     R     Q[  [
 L8
  =	 _	 R>	 =	 =	 b =	 H0p@- P@   P  
 00 R    @ #  p[
 v	 p@-\  @PP0  T	  @   @< T  ,  @PVU   p=	  =	 X W 0p@-  ` @000 a PP   '   	 U	  
 @ b  T  | tP f   
`0   00P0 @0P  S  h ,0   0  p[
 9 =	 \6
 |1A- pM ` 10  SP  
 0  SPP0  S U    V  
   V  
 V  
   V  
 V  
  40  S
  0  S
  70  S  
  40   50  S  P  P   PF0@@  T    a  P   0 S  50  S  
0F S@   @ T T 00  
 U0  
 U00  0(0 0b n?0@PЍ[
 t @-`  P  
 >	 2G- `  Bp00 0   P  ka   00 X PP W	   
 0  S  @  T  
 @b  P
  0  S  A(h2A/ @`1 0@   0  S  
 0  S  
0001 S    ` 0 01 00 c0 S  @GQ@1 r? T :t1    U   ,   0z 030  
1  S0 @  a @  _  X  1   "     X    1  S	   ` `  P  
 `  Z
  0 040  S  
     Y  
 0  S    Q  
 `+b  P  T0  GD0 @   @  T(0 @[
 \6
 D	  9
 X6
 _ 9 D	 8
 P8
 A-1 ` 0 Pa  
1 p0  S\    P@  
pt` @P    _  P 	   _ PP   _  P P  
  
 Ia  T P   `  U   e R_ @P   _ 050&  0^  T  
  \`0  @   @  b_   x0 Pl0  @_ T_  } {  U   ^` P ` 0 P0 ` 9
 [
  ->	 t8
 X6
 0p@- Px@40  0 S  
 0 ^ \ Z 0 S	  <@ 0  S  0 00 0 05 q 0>0p[
 $9
 9
 V>	  >	 0@-  000a@D[
 @-0 @L7
 p@-   s	  0  S  
00S  S  
	 SD  <2  00C  S0   2   0  RZ s  0  S  0̠00v  @  T@  !1 0PP1 `40  S  
1 00  S  
1! 0 7 @  1, x1 0 0  d  ) @P	  0  S

0@ 0 _@    (1 0 0  S  
  T  0b ̠ 0 002  0 0P0@D  S    *`	  
 SP  0  0000	    Tp0  000  S0P0  L0@ 090  S  
 @ 0 0 a @0  00 p  \6
 [
    9
 [
 l8
 l[
 (0  00C  S0  0 0/L\6
 @-80  00C  S0  0 0>0 P
\6
   L0p@- P1  S  80 0  S  
@ T    "01 p  p[
 8
 >	 @-@  P  
     P  
0   (9
 0 7
 @- @  @]p@- P  @ N  0 @@p(9
 @- 0 00 000 00p8
 9
  Q@-(0 @  1 ! X` , 	 T0PM@p  P <  
 I`  U @      ?`
 8
 >	 >	 1A- p@` V  * <  P V0` U(  0 R%  
0  0000 @ p  Pe  P 00   `  h0   0 00000  Q  
 0 S
A  ^0   000[
  [
 40p@- @ `0Pc00e S  *  p[
 A- pS0@ `P        Q
  
  W
  
H0H 000S>0 S S~00@D  T0  d8
 :	  p@-@ P  ] pp@-P @]   p@@- @@ P]1  ` pb   SP#  
  ' SL  
  " SI  
$ SG  
J  \ SD  
 S  
= S3  
C   S  
   S  
 S  
;   S"  
  : S!  
5  0  ,  0/  `!1$
 Q P@  
     `0@0    @$ "0    V  
0 S0@  1,:0    0l\0    0  \  
Cp   Q0 0  S "00 0 00 p49
 >	 >	 >	 >	 >	 >	 >	 ;	 p@- @  T  
 0 S&  L K K K 0L K K K K |K DL pL L K L L K 0M lK 8M HM (M 0M @M tK tK K Ru  BR  0  R
  Rm  R	  @  @  Tt  
DQ  >@:@6 20  SP  
 *PA  %PA  |  pPhA   \ P [   4A   S    p@O  @ )  0  @   x  t @  T@P  P  P  P   P )a  00C S    ap@@Wp>	 >	 ?	 
?	 	 Y?	 ?	 ?	 ]	 ?	 ?	 $?	 ,?	 ^	 C	 1?	 8?	 >?	  E?	 J?	 	 U?	 X?	 C	 \?	 _?	 ^	 b?	 	 p@- @P
    U  4  ,  U  
0  S  
 @  Tp( 0A- 0 `p' \ @f D'P PL\P0 p S    PP0`' S
 /"@@e 7\@ 0 p  S 0 00 0 [
 @-@    @e?	 G-0  S G  P(1 0@    @  TP U;   =Z  P       P   0   \&  $   ` 00 	0 @ p  000  T  
0    N[ %c0 00	   oc @ c  c  @zP  U 8
 7
 <	 D	 [
 H0p@- P@  0?T 03  S  
 c pb0 p[
 (0@- 0 @0 Q    @[
 0A- 0 ` 0p 0 P @  00 S  0 00 P   00 @  TX0P 00 U:<0 00 P       X 0  00 0  `A`[
 [
 p@-1 ` 1 P1@ Q4  Z0 pbP       0 @A  S0 00  S00 B  Q! 0  S0 00@   T    08 00000 0Q 00A   0   
1 < S    ^   f  @   1ZX0X  0  S000 0 V0 @0@00  0 fb  p8
 9
  9
 8
    -@-0000  000 0Y @ @Ѝ/[
 @-4@ `p     `   0 0 0܀d8
 l?	 O- @ PP9 \ Pp  0 \}  *$ \  
  ! \  
# \  
  * \3  
- \  
  ? \  
@ \&  
}  2  2    2 0    2 0  P  
 P  B  P    t2 0010  Sp2P1 00 R*    T  
  |  02  0  0 p$"p 2  [00   
1R30 S S   
 1 0`  V P  j   WZ Y
 Y  P  
  0l0  S  W  

 Y YP
  
p1  X   
   L1   @  TI  Z  PE  $1  0 P@    P10 ` 00@@    W  
 =Y  h @P= Y  P  
`0e Z   
 [  P@ p  W  T   ` @  T  
 Z Y
 Y P  
  0	  40  
 Y Y$  00e  0    P [
 9
 [
 d8
   :	 O- PM   P3
     0 0 R 0000    @0 S 0000002` 0  S   c S0㓒*  
P  U	  @ Y P    
0  S      R  
 0- S  0  S  
- S  0  S}  
@     X   0: S   
:? p@  1   LZp?6  0: S   X0: S&   0  S   @  T   P: U	  T 
@` pH  01 0  &Zp`=   0  T    ` p4  0    0 p  T`*  
0 `c
 iB! P0   P@   0 @  
0@ @  
@ 00@ ` Ѝ p`? q?	 [
 ?	 7
 ?	 ?	 [
 S	 ?	 O-,p `@C P2  ,0    S 0 0  'Z  P (  
  Z  
 X  P  
@0* S       
	     Q  
0PA @\ S
   
 (@D  \  
PU  Z	  P PE@D`F	 T* @ G- $p @P  Z 0 ` 0   Y  P `	  
  Y  
 0 S@  V@P@ p@-P `  
0 S<C   R  

 P P  
0 S  
  X      @  
  H  @
    R
  <C4  
( p@ p@ @ p?	 ?	  p@-18M` 04  S     X PPR  T1  000D1 @    0 S  
!0. 0 S40 @0  r   
  \  
0 S  Q:  T	     P40 S  00C 0
    \  
0 0 R0  
 \     0T0 T 0  S  
@ 4 u  P  
8  0  4 C
  5 C 8Ѝp 9
 [
 8
 P8
 A- @pPpY `P    T  
 g$    '@    T
   1 0  S  
  |  P  00 00   U  
0   
1   S0 rW U  0  0a]0 l0P   00T00 `  0  S  W	  
80  @00    !_  ?	 P8
 [
  9
 [
 49
 0p@-   @000  2   P
o O0 P 
  
D0  80 0 0   
 X0 S    p[
 X6
   @-   P  0 0$0  S  
 "[
 1p@-  $0  S  0 e0   0  S  0    P P3  
0  S000 0 0$0  S
 `P   0% S
  
o0 @  T  
 0##0  S  
@  @   0  S
0 00 P0  S p[
 L8
 8
 @-0 `   000 000|00000
 	! 0 @P  S   sH   
 s  < & s4 
  Ѝp[
  X1  ?	 @	 @	 @-0  S  , @ 0@  S   7@	 G-4 `X @PG  
 p   
Vf     
0 P0@ 0@d p`@     
M^    p  X   
  V 
0
   S  @   \ S  
  
 S    R  \@  
 0/ S\00 00 0  S  00 ``   ;	 [
 d8
   QA- 0 Pp      0   S>0 0Aa  
 vX  P  
` @  T 0W0  T 0  S
  
 yV &^ 0   @0
 V0  `8
 9
 A- `| P  P `l0 P @ p  f V  
  P
  
v V  
    P  
0 S   @   P 
	 L8
 G- p   W   P   P 0  S: S  
% S
 2V0 `g @   0	 S: U@  
  <V /00@ 
bVT  0 0 0% SP P  
  P 0  S: S 0	 : S0 0 0G[
 8
 O- dM@P `  
  Vc   ! 0 |1 p 0 U`0   +0  
  S  
0 U  `0  -0S0B@  
  $! 0@!0  Qb*    V    Q     
    [ 00!   
   0 0 @ 0 V0 0 !0`@?`h 	 eV
 V	
 ]0 0 R0   dЍP	 K@	 8
 	 S@	 [@	 ?	 '	 c@	 p@- `P    P80 @	     
0   
  p@  Tp8
 p@- `  l P``l P  P`0   0  S
  
 PL0    @   R0  S  0    p赘 L8
 7
 p@-0@  P ` U ?U 0  0 0p\8
 p@- PP@S  
P  L1 @00 0 RG  Lk (k Xk Xk Xk Xk Xk Xk Lk Xk Xk @k Xk Lk dk dk k k k k k k k k k k k  0  0 0&           !        0    0  0    0  0      0 0 p9
 !<	 s@- P`	  40 @  @     P `  U P |9
 O- `tMP@    ? S* S  
[ S  0! S 0\ S 0  S/ S
  
0] S	  
\ S@  
/ S    P      @ 0  S  P    0\ S  00 0  S  U  
 B  Pa   ^   R  * 0\ S 0 R0 UT	  
0 U   0/ S<  
 00E S  P D  
 U/00E 0  S 0p0 0p\ S00 0. S "  0. S  Z     
@ wU  P    Y  
 T 
   	 0  S0  /0 0  m@0  @  T   U  P T  Y/00GtЍ?	 p	 [
 @- 0 S ` @-+ 0 S  @-pM P `PP|1  000S S\1 0 @  T'    U!  
P 81  01=00  0 100 Q ,0 P0@ 00L 
U*   M&   000C	 S  `   00B S   010 C 0  S   0 0;;0!&  P  D    S  Ѝt	 [
 L8
 ;	 ڑ ;	 m@	 f<	 s@	    P P   
Q /H1G- `0 z81 P @  T  P1  P  
B @ 2   PA U 5  0  
 S@P
p*  2 `P   !  0  000  T	  
 0- S  0  S@  
 Z @T0 1 R  T0040  V 01@  
  
p   P
 [
 L8
 @	 @	 A- MQ  Tp 0P {:< @x:< ` : @:? l:  0      PЍ<<	 @	 A- `   0`A PUQ  0  Rx0 00p    =R 0 @  S  
@  4 0l  Pe0 U:  Ѝ ( [
 @	 @-l   Q      0 @  000  ^ @P@  (0 0    P @  
 J [
 L8
 A- 0P p 0r S``  n P  p   P  p P"  
0 0 @  T  
 =Q PPP
       P0000      @  T      q  @	 L8
 E- PMp`  n0@ S  u u u u u u u u 0   |0 P  `  h0   `  T0 pP E  PD0D  @  00  p  P   VЍ8
 @	 L8
 @	 X1  H-0P  S `  
 d'T  P  
@  0% S   0M
   ,Є)T0@  S KÏ	 @	 0A-  P@p `  R  V  
 AQ 0 S        0  S  d  vYP0P   P0` @  S0 l[
  M ` p    Z P / P@  PP   
 
  0 P  pW
  Z0 0  S  
  @ T T   @ P  { P U   

 U~  ,0,    @  0 l[
 8
 9
 -C	  p@- P  P  
00 @ 05@4@0   0p[
 [
  G-pMh3  0 `  VX  
 0- S
  0  S  <  P03 ` 00`  / R(  
. R  0. S  
/ S!  
  S  
  0. S  2  R`  Pl   
p 00 @
 P>  P  0:	S    T: Tp   pl2 P000 X   T2    / R@  
 00 PK  
 @ 5Q @ 0  @/ SP	  
0P/ S/00 T  0/ S  	  0 / R  0/ S  
 P    0. S  0. S
  0  S  
  @D0T/ S	  
 T    S  
Q/0 @0  4R  P T@D 0 01 0   P @    @Q PP    0       0  S
  
 S
  0 0 0   0 0  S  00    R|0 0|0 Q:  U  
  l0  S^P    
$0@  03  pЍL8
  =	 [
 ?	 @	 [
 p	 8
 T6
 @	 v	 A- 0  `1fR  0 L1 p   X P   . P0  0@!&   P@ V0
  @N0  0000 S  
  00 X @  0   P   0  S 00 \  X @    @ 0  S  
0  S [
 L8
 @	 A	 7
 X6
  p@- `R` P@ 
  RZX0 0 0  P  S   p 0- S  0  S   00p  V  
  pl[
 
A	 O-h5M    P000P 
H5  000      
` PH P SP  VA yW4@   @0P 00 0C0`  00PE0  U@D 00   `0B S  p W 
	   P  
h$	0  \ 0  0B SS  X X < 0 L H @  ,P PP    @B=  3 0:0  S3  
@p :=  P  0:	S  #   #+   A#P PPo  +=  P  0:	S  
 p0 S   t0 S  h 0 S  l 0 SS  
 .P,#0   0P  @   @# O PPF  A  p NQ  P   0 S  0@ rO
P P    t W)   P    N @P"  p  P    
 N 0  S t   
D2tP @ PZ ,2    aW  Nt OpP V p    1 0      1 0    3	   PP@ p"  I   P	   P#  
	 W
    _P p @
  ,1  @	 T@  
  U   O @
	   PA0 V 1@`   U	     P   v 
  
  S
   V  
 M 0 V S  
 |O 0P S V 00  S`  X  00  [ 00  S0 0Ѝ[
 [
 l[
 y<	   A  A  A	 [
 d8
 )A	 ?A	 SA	 `A	 @-0M  0 00 101N @P   00 ~\0  T 0   
(0 S  
O0 1  00  S   0  S   
1 ލ[
 E-4kM  P   0 P100  
  [N P  
3  (0 S  
 N  @ T  ꘆ  H Ć Ć ܆ ܆ ܆ <    І $   Ph#F  d#    P\#A  0 H3 0@s @3     0  @P  0  2 @   o  "2 010  S  
0  P  
   P"   P"  @D A 2 00s 03 ST  
x2 0  SP     P 2/K  0 @2    RB   2 0  S   P    00  S0@/  
P! 1  000QA0 ` 0  ` @    SU1    1@  @  `00 P S   H @00堡@$1 P @    P !1  0 1 `! 00 0#  0  $0  S  
$@pP0  S  
0 01 0p 03 T     R    S   
 p0  P `  @A TP0   
 &,0  000  S   0  S   
%kߍ[
  X  9
 @   9
 L 9
 T8
 9
 \8
 O- M0	   0  
%5@   0H  
  0 S        0~ S   
:   T8  
  / T  
: T  
   T  
 T.  
     @  T 0 00   S   p  2O  P  
p  W  
 0  S  
4d @ P @ 0
@cM  0	 5 0   a  @h4 @ `4  0`c    @ N Pp  W  
 W   0'#P  U  
D   9    0Q0  [ 0  S @b  
 T     `0: W  
= W  
  W  

  @ H0@000x~ Sw
0G S،  |    D Ԏ \   [   , TK  P
  0 S  
 S  0 S   	  # { 3 @  QH@``@ 	     p 0W002 2  0P00 uX2 @T2  00c 0  U` @'  
 0 0KN  P     `Y  P  e 
M  P  
 M! 0   10 L1@ 0 9  T      0lP  $ P  K  T   L <1  1  1 0   R  0r
 S
0  W   `  0      0PH   00B@B   @D 0 S ` 0@pe &`0P  Q @  
 
 ," U 
   Ѝ:	 :	 :	  [
 d8
 :	 [
 D8
 A	 9
 O-D4  `84  QM (4 D 4P  4 0   e   8   0B 0  P  
  `3 0  
3 0  Sb  
3圃 P  0  0#0 0    [t30@ 0000B   0  S`` pJ  P@7  
  [  J P T 00  Y 0  S`P@%   0 "P  [0P     0p U  * 0  S@@ `mJ  P  
xhJ  P    Y  
P P@00 T:   X  [   0  S  

P  "P0   1     `0C  1 @2P  U#   "M  P  
0!0p0   P 4KPR   @d J0 U  
 J<1  R  ,A 0 ` #`   0 0          Rh        P0  `  V	      
 w 0     0  S  
0  000   @rJ  TL0  H0  @ 0  0   R 0  00Ѝ[
 D8
 d8
 89
 8
 (9
 [
 F	 [
 ;	 0@-Mv`  0   @0   _D0
  P80 P 0 0@0 0 Ѝ0[
 p8
 9
 [
 @-0   P    
 P  
  x0 00  h0 00@  X0 00@
 H0HP
` 0   @  J Q  
 j8
 [
 [
 [
 l8
 @-  0 @ 0  p0 0  S  
    Q~   0 000 00(0 000  @  T|8
 8
 p8
 9
 1  PA-        P pZ   p  P*  P
  
 P`  
L1   !  P @  
  `$1     @ P `@ 0 S0  
 S  
 P P0 0  Wp  
 0 P p T  \ $ | |     P   X  
  h0   X0   v   P  D0 0  S  
|     X    0    8
 8
 |8
 E-Tϟ QM @Hϟ P@ `0ϟ Q 4P @ @ $R  P   0  `PP<`$P(P,P0P ><  000b S   < 0.>000S10 S) ꀝ   ț ؘ  l  P   ĝ < D     <P  PA 
> @  000> 0  S  
 P<P @f    R  
0  S  
<~00<4 \ T 00  P 0  S 
  @
kH  P5  
 00B!a S
  @"  00@ S02   @Ty  x T  P"  00@	 S02    0a0C S  PUe U  
  022    @00 m @  ' T" T   
L<\0@0< hP  <0~  < 0 <0 
 P  8< 0  S  
 m   0$ P 00  S  
<0~  < 0 <0   R\ P  
` P$ P  
0  S" P  
<0~  < 0 <0;+ 000#40 S<~00<< 0 < 0p     Pw0< 
h     R	  
(0  S  $  \< @< 4[  
0 0  Q 0  04$   P  
0< |0  QA00$0< 0C$0?  <@(  < @,< ,5  ,   R  
<0 B@<0, ,  ) P  (\<0( <0"  < x00<   Q  <)00<  $   P  & T  9> P&0@  9 T  
<@<x  00C  S0  0@Ӥ0 @0 S\		  
   R  
9 0  S  \  4	#$   P(	 $<  0  S8 `P  > T pp> T< T  
8 T    \     P\  X8 $" 8<  8    0e00c 8  Pt8      RV
@8 T  V @0  S    P @	 T
 0 Ts_	  
CFP   U>
  
 P   
soO0 U 0 0 s/      Q  
 0  S
 0
 S    Q
  X7L  000T7  x7  s  0  S `  
 HH ` O  W P
  
00> P0)  
| P0&  
& P00'  !  6 T  000  < P  
> P  
& P  
   ,0 0 P 'F  P- P  00  
  0 0  00 0X&  V` P<&0  0  P @  ( P{ P  
_ P  
 0a0C0 S  ! @ R  532 	  ' T 4   
<$00<( T  ( P 
     P5<{ T  }00<0p0 # P @ `  } P 
 @
` T  _ T  
 0a0C0 S    pt P @'  _ P
  00B	 S 0a0C S   00B	 S
    p]00@0	 S @
  ! D P  430   
 Np @  h}PTP
 V P  U= z  V< 4  % T  
  # T  
  / T%  
: T  2$ P: P @  
00@0	 SP  `   Pc E  P
 0f0`  `   ` P  0` P	   / P`  

`      P  (  Q   
P2j  0 V0 T
$0 0  R$0  (  \K
0  0 G2@  080F  P
  
 8F2   2   G2  00082 <  @0pR  
 N   F`2  02@00S0  SX  
1 0P2 0  S  
 ` P @@  
  
 P/  
\ P  
5  <@ S2  !  
 P @  h1  000h1 0  S
 \ P` P  
$ P  
"0P0  \0  S  
\  P T  H0 0 0  0  0000  0    P  0 00 P  
  c<_   P @  T 0    Q P0 ` ` @  @  R,0 `    
 P  

 \6
 [
 <8
  :	 H8
 :	 >    rA	 A	 A	 09
 9
 p8
 8
 8
 8
 X8
 
A	 V<	 A	 8
 [
 [
 `8
  0  \@  
00    80 @   0 S 2@  S  
   Ep0@  000 `E 0 20( 8  0  P      P  
z00O{0 0   (00 S(0  < y0  \0	  
< 0 0<   7< 0 0 <  -< @< )ߍ`Hp@-! 0  S  
 0 01  p1 0  S  
 1 0 1  |1  00C  S00@Ӥ0   @	 T  T
H1 T
# T  
 P  
P\ T  
 P  
5  0 0   0 0  Q  
 T`  

 T  0  0000  0  P =D `P  
0e S  l P P`  
W& T> U  
P0P 0c $0  p&@   0p@:8
 8
 8
 \6
 <8
   H8
 U<	 O<	 E<	 @-0 @ 0     x @ T
 T"  0 0  S  0 0 
  
0    P  
p0 0cCAh0 @  L0 0   
D0  D P  
  0  S
0     8
 09
 p8
 , 8
 p@-(1 @ P  
   0 S0  1   1  R `0 00 P
   T
  
 T  
0 0000 S  
 @  T  O P  ڜ  |0  0 @0 0    0  S `p0C S  <0    p@Y+ p D  P
X8
 09
 8
 p8
 :	  A	 |8
 @-l0  0    , 8
 d0  @-  X0  P     
H0 @ @V  P     P   0    @8
 H8
 8
 G- 0M0@ @ P 񟗏  T T 4 4 4 4 4  4 4 4 4  4 4 4 4 4 4 ` \ 4 4 , , @  0 0 P    P  
   `    0  @ 0    P  `  P
6 0 S        005   @Q  5 P   0 S	0
0 0 G   P @  5 0  S  e  
  P    i0 0 0 P0`5 @ P@  
   [0 0,5 00,5 00  @ P
 0 0004 0 S S  
   A0 0404  0 S S4   4    P ~  Y@    '0 0 P P p 0  044 0044 00$4   x P
3 0 S Z`3   l P3  
3 0	 S   e 
0 @   p0    0   3  0 3  0 N P  0@I@3 0
 S|   <3    = P`  
 P
  0 0   0 P 0  
@     @ P  " 0p` 000'P2 0@ Sa  t  , , Ĳ Ĳ ,    VW  
X2 PT" 42   $2      P,  @E  P`  
D  P `1  X 00  
1    P P P 1 P Pp0  S$  
0 Z!  0  S  0  S  
 P  

 @   P  
   P  
 0 0   
40 01   j 4  0 @     @ @ @> @0 P00000"   P 0 @    0 0 0@ P
P0    0 00  S	  
 0 S  
 0(  P00 Ѝ8
 8
 09
 p8
 A	 8
 9
 :	 B	 ڟ	 D	 3	 X8
 B	 A-f
 P00    p p @[ P P   0 ` 0   P@ `0  @   @ D PP
 0 0@,0   W      0 8
 8
 @- @3  0   #0 00C S)  t t t t t t    

 J 000     P  

 @ 0  S  
   P  0 S  
0 .0 0 0  @  T&B	 O-6V @ 0 p`00I,M S  \     e  ` p`P Y@  
 Y  
 YR  
V  
   / @6  P VBX0   S0Epd      0 S pG 0E R: 0: S      0  S: S: S     X     X0  S  
 0 S  A  Q0h  S  
  X  \  
 0 S~00 0A0  QP4      
 T0h  f  4X  @t  R0   P `P  
 	 P0P ` PT p   3
 I 0`F Ra `  0  S     0  S  
/ S    \ 0  W\ S 0  0\ S   
    \ 0 3 0000   P  
2H 0 p$0w  X 
  0 $  P  $`B   X     R  
 0 S    p  $0 SPp UT  * 0* S
 Y P
    X   R  
 0 SPP  U: `  X$  \  
\ S  A p _  A   Y$  `0 SUp0  S
 Y  `  X $  R  
\ S  0A p >  A ` 8$  0 S5p0  S    U:P   '$0  P0 @ A0 0  0I @X0 R| @
   0</  P  
  T  
@`   @DA  0 00    ,Ѝ[
 D8
 d8
 [
  [ $\ O- p@$M  
0@ S   t2 0 0 Sd2 = 00L2  0cb?`  0  PP@ XP  
 X    U      Q<0 R  0H S    U     0 +  PB  
	 @T  Z4  ;    U	  l1 0=0  S  
   0
 X  Q!   X    Z  A    U$         0pb 0     P 	 0 G0  00	  0 0a X  
0    R`
|00 S    U   R  00 S RQ0   $Ѝ[
 [
 d8
 [
 D8
 0@-MP}
    G
 80 @  T    B p @^0    Ѝ09
 p@-@  T  
0  S  
d0P `   @ P  T  
  
 
0  c @ 0  p[
 9
 0M  00v?  P  
d0 0(0 SP0 00
  D0  0@0  T  
    >K  U >9
 [
 @- ` P
 W0 0  S  
0  0 @4   P  V    p  1 U 00  V0  S    P  30  S  
l P  6   R  1P01
 $4     P
 0 0       Ѝp 9
 7
 [
 2B	 9
 @-  P     @  T   
p@-uMF5    001F5     00 0π0~?0GFh5  dU @X5 P 0  @2 T  F$5  | F5  %  0t25   > PP1  
$4 @  @4 @@ 0@4  @4 @4tB (  P4     T P 
40  S 
0  S   P  x4
  } T  
 T  
 T  
 4 @00?  F$4     W= T=3# 0 G_@  0 0 @@ T3 P   ==  P  
 	P  U  
 @  T>"C   |x @P  
 0/ S  ~+  P  P+  P  !1 S  !1 S  !X2 S  !\2 S   
 @  <   0"  02 @0  Q10 R 0 0  P  
  P` 0  S    V  
pp=0702`" @408< S    >  P  
 >  P0401  50 S4050  1 0000  S 00 R  V  
t1   0 0  S  
  T1 070  S    u41  0 1  $1    0000P   1   00 00  S.  0 0- S0  0,00 0,0  S  
0 t20 t20t2t0 040  S  
  0P  
 0  S   
0t280 @   P  
 70  S  0  S   8[
 [
 [
  8
 8
  9
 \6
 9
 x8
 8
 8
 9
 7
 8
 OB	 7
 5	 =	 ?	 L8
  z	   @8
 ZB	 gB	 pB	 O-M0/` <  P  
 @ @  

 *  P @   0  `3  000 P 00  S0  8=`  P `
   @P
  
0 S0  
 S 00  @@  0  S  

 :  P   
 0 0      
    
  2 0  S    T  
0  S  
0 Sx2     h2 P 00]  P"P    P  
@   P  
0  Sg  M   K  "    PE  
 0 U/ S       U<  j    0 S S7  5   *  P(0:	S
0,  1 `  V  
 <  r 
 Q @P  
0 S  

 @ =  0  SP)  
 1  000
 9 @` -  	0 
 pP0  T 00  S   
N   
	 '
   1 0     R  000 0  p0  000
 
00  @ j0    000Ѝ[
 tB	 T6
 l[
 8
 C	 }B	 B	 [
 -C	  A-1 pQ P 0000   
 d  P  
  Wx N     @P
  
  W  T g L  <;    P0000    00 S  
 S  
  S+  @  T`    `3@TZ  W  
  X0  0 0       W       W
  
0x  0 0 X0h 00       W  
D    8   Ѝ[
 B	 B	 B	 [
 B	 B	 B	 C	 B	 C	 X p@-0   S  
 0- S `  
`Q @  t @   P p@- @  V P@  
v P@8   P  T  
$0 0    P  
D@X  %C	 L8
 G-l  P  
  /  T1T! 0 0  S ` PE  <1  p41 00   @  0  S  0P
00  `PUZ0   S 
 6 @  Tp0 0|0 W: P       P	  
   P  
 P  |0 0  S   &0 0 
8  0 rP0 00 0 @  T ЍП	 L8
 [
 8
 [
 	 a	 T6
 O- 0M     0   Sp1  000\1 ` P E  @ p  W
  0  S
  
 z  P  
0  0
 00 0  S  
 $=  P   ; Y
  2  P  	0  S   ;  U    q< ;  P  j< ;   U   ; P p   
; `  V0  S  
 d0  Ѝ[
 [
 A	 9
 A-d1M p @   kB< @  T0  S G  
$1/ `1 @0P0 |09  P  @ 
s(  P  0:	S  
 T  
 |  @P P@X  
h  |0     0 0  @ IX0   PVe  T  
00 @ h   0 00  Ѝh8
 [
 9
 )C	 @8
 E-,M P  @(0@#  $01 @`7  P2   0
 p0  @0  0         0 S    0 @ 0  @0 0  ; @
 ]  T  d0 0  S
   
	  P  U`  V  
,0 0  S
 G,Ѝ9
 d8
 [
 D8
 89
 9
 p@-  @` 0 P0 0 0 0  S  
 0 S    00C  S 0   0 0 S    00C  S 0 0 0   0	 Sd0 0  
0s 03  S	   40  40  R P0   P B  px8
 9
 8
 9
 p@-M P
 `0   #0@   # 0 0  S4  @  T0` @  0  @  @      3 g 0  S  
 S  |  00C  S 0   0 0	   S
  P  00C  S 0 0 0   @  T  00C 0
 Ѝp9
 x8
 9
 8
 @-oM     0gύ   1    0  19 pP%  1  0001 P001 pp @ 0!00 00 0\0  C0   0000  81  000(!  00C 0&   0 0@  T	  0   1 9 8  0$0  S     `  V  
 ;6/0    80000 8h P  UT0! @   Vgύ   0 000  10$   00 0oߍ[
 8
 [
 8
 9
 A- 0 `  S PP@  U     
0 00  S  
x0  000   p  P	  @  U@     U     O0  A[
 9
 @-0iM  0  18 pP  0   01000  pl0  p0 0`0  XPP`   @:0   0 9$0! 0   iߍ@8
 [
 8
 L8
 9
 7
 O-<M   X5    00 0@5 Q0 $0(0,00040(   
   P  
 0 0 `    `0 @    V4P  
   P 0    0  0   0  S@  T   
 0   00    P P4   040  S	  
<4 00s 03  X 0  S   004 `000 0 0 pP  ,@ ( j 0@ uP  Pp  U3 80  S  
@ ut   ]7(@`    W7 @L  TP U0@ 0 @  XB  
pp
P `@0     0 s   <   S3   v$0$  0 0`2 R*  
2 R&  p    R!  
 0- S  0  Q  
- Q  0  S	  
0p Q  Pr0  Q   Q  
0eCH@P
P `      Y  
 V   |1 b   @ TR  
 T  
 0   
0  S  
000 t   @  P  
 	1  F  ( / $ ( X1  P    
0x 03  V0  S  
  Z X   & $   P$  
(  P  
  P   
 P$0    V 00  P0  S0    
 7  ( 		   0$   P
 
0  S  
H    Q<Ѝ9
 4 [
 8
 [
 A	 @	 X    9
 h8
 7C	 O- `,Mp V 03 
F 
   P.  ZAF   `t p 0 Z    ` p     Z`p  
0J S` p  20J S ` p  1 Z  
	 [ 
 0 ZC 0V    Sp`     S `p ZH  
    P   Z`pB Z ZaH`p  
 Z   	   0!  P `	p  " Z	 Z` p   
b Z Z`& p'   
 Z   00  00`  
 Z   V   0   W  =  * Z   V   07   W  
4  K Z   U   0  -   T*   Z, Z    r   Z Z    j  + Z   W   0  n   V   Z   U   0  e   Tc    k Z	   W   0\     VY    0V   Z Z  7# `pR   Z
 Z  `pL   Z- Z  `VpF  0J SA  $ Z  	 [d  
AHH<   Z  6  aH6  / Z    U W     ` p,  @ P	  5!&@  P 0P	0    =  
# Z. Z    0  `p  C ZN Z	    0 `p  `p0
 S0 S S  
 S  0  S  
@0d  58   Z   0  
3 Z    0`p 0`0      ,Ѝl?	 O- $M48 0 60 0 0M<<  M 0
@(04  00  @  T  " Y  
0 P0 <0 (0 S  
4 0   0 0  <    P  
8<   40  <   
 T  T ``  
	 T  
8 00 p P  
 c 00M(0Ѓ(00 0p(0   (00(000D	 S  1 0K P(0` `0 (@.5  0  S(   0  0  S
   0  P  
0   S
  0C003 X X@  
  	 0  S X  
 T@  
  
 T1@  - T@  
3 T2@P0E U S$   X
`  4 T0V    SF  
  0 UP S0 S  :   U U  
 U  
 v<( K80  Pr@0 V4 T_
@00000I   0  KE	 l[
 "E	 A- P   P"  
  pP  
|0 `@     7  P   
@  T0D@ 00  0`   `     0  Ѝ<9
  P  
   0a0C S  _ R
   00@	 S 0a0C S_ P
 P   /  /@- 0   p   q    @)6    0@D5E	 I	 G-1          P1 `  
!4 pZ  
H P`
S P`
a PtQ  
  
 U|4U X5 
 
@@1pP U Pf Q7  0 P3   p
 b4 1 @  T	    A  T-  
 0- S*  
0 0 6  P     
  
 > 0  S  
 8   W  V`     
B6  P\ <   PL0 U  Ѝ  
t7
 l[
 F	 < E	  7
 E	 E	 E	  O-M`  0PĠp̀@
    @  P   t8` @   Q  U	  
 
 ]> P 84 0 0  S   Wp  

   O>4P  3 # 0 0  S   Rc  ?     X  
  
 :>  P   3 0 0  S    Z  
 4  P  
3
  $6:p3  Q  Y  0 !  
T@ 3         Y   
 Y	00k0`00`0 T  `0 h0`0000%5  Q  
<      p0  S
  
 )<0 `  R  ڐ b P      +;    - PK  @  TB  
  [  

 T:  :   00#\ T 00  SP 4  
 TP`7  
 0  S(  
 2  P   Z  P  
	0D  T S   J Z  
0P  S     P  
  0 0   2/	0D  T S 00  Sp p   pP    PY	`  
`P` 0  S  
@pW	  :T	0A  Q S   W2  P@D  00  03/@   2/   P  0h 03/   ` 2   
   }4  ,`   (` ЍE	 l[
 F	 7
 F	 '	 F	 F	 +F	 s@-    @   
    P     H2DDK  1   D2  U  
   >2 !1 ` Q *f@32  P	  0 0   R
 1 | 0 0@ 
2 0 P  S     T`P  

`d 00 0< S      P@ 0 0 @> S@ 0  S  
 0g1 @U
F	 Q)	 N t  G	  9
 l[
 G	 	  @-  @ 1     1 M1 
4G	 0 @ 2 ;9
 @- 1 p   9
 CG	 O- Md   2  4 p  
* 1!  P   :  4 p   
 +1p!0P   P p g1 p  `<1   R0 p0     \2   P  : R3 P   
P U P#   U   9 f3@WQ@ 9  T `   @e  U2  P2 0	0  P	   t0@  <4 '2 P	 U 10  S  1 > 	  9
 GENAPG	 jG	 G	 , 9
 G	 7
 @- 00 n1  39
 p@- 0 P00C	 S@  p@j2 0  P   p@   Q  pA-pc0q    
0   @     y1 P
@  !  @ 0  S. S     S `  
   , `P   	   .00  P     6/0 0 0!  R  
   0  S  

 S  0  S  
  B00@   0  P   @ `Pp  1 P 8   @\ 30p  S  (!02  G	 6
 G	 G	 `6
 G	 7
 	 9
 7
    @	 0@-tM n P 00t 01d  @P  
 l  0@ d1   7n  P7 0 tЍ0H	   O- lM @ D12  00  
2  D0  S+  
.   10 pt#  
`P`2 pD 0 @ X     ?1D0(   0 p  
  @c  11D  0`d0Pz91 P0  S    T   1 @H0 S+  
1H@ 0 11! @  Y1  P   ||a   P @@
  )9 TL  
 1I  Kf  P 0  |0:	S 00!0\0  00 `   R.  
0  S+  
0 S(  @  T!  
  0  
 M
p M@D
P   02  T	  
@D   02 /  / F1	Р    0W2
  @8   K[
 h[
 G	 G	 A
    	  G	 . p@- R M `P  0  S  0  S  	0: S  0: S  0  S  
@ 11 0@   00@P 000 0   
  0  Ec2,    V     ? R     0 R   0   1    \  t   P0 \ 10 080P   @L0E520  E Ѝp[
 h[
 @	 h6
 _^	 6
 	 
H	 0 0/   . [
 G- 08Mm 0$0@7@ ,05 P  ş E4  @0 ,( 0$ @p `
   7 @  x  0 0 8y0@ 0  0  S   
0  J     
,  $C4  0 @   
(  c 94 0 $   P  
$04  0$  $ 0< 0H
\4. 0L / 0  0   :HK(4 < @2 ,/  \.04  0+  
$/1 p   
  . pD   7 $ .$0D 	0C 0#1 p  
  3 0 0 S  x  1 p    plP@K p   3 0P` Tn	  . PP  ,3 0  S   7     U
0r  S
 SPE
" U 00  "5  
  -  P  

00x2 0@p:   @ 0 s  0  S  80 0cw S   t   P   
0   .      p    
   0 0 @0 ;. p1 0 h X  
    X  
Y X  
  j0H S    / 0 0p  W1 0 p`2  4   0< SL1 0%N  
  	9  0> S00?0  S  

 
  
 R  0 00	 R 00  S@ ^00  0   R0   0    S  % a: 
 P:p@0 0  SR
  /X0 @0 s  
D .  p  
  0   p  
  0Z/D0  
딄 h[
 [
 H	 !H	  [
 5H	 48 GENAJH	 QH	   l[
 WH	 ^H	 [
 H	   H	 @-   s@-  
0 T   @  
    -  P/  
    
  - 0	S900S40 5 `   -  P   d 6  

P @
 U  0< S@  
P@ 50 T
 U  

 5  |[
 UI	 [I	 aI	 A- p  PP   5-  P   0 `f V   p l1  C T   T  L  D  e T  81   .  f T  1   `	  
 0  S# S  
    - ~  @P ,  n T  0  y   s T
  0    1  0	   v T 00p`  - @P0  S  ,   < 80  ЍA yI	  I	 I	 I	 7
 Ԅ iI	 I	 7
 0@-@4M P   4Ѝ0@-DM@  00"DD1 @ <<1    @P    P`  
1<  1  ;0  @ P< 0@4P0  P- P(  
 5p<   
0@ p +-  U  
 s.   +  p l0$i3  @0 # -
 @6- p4 -  DЍJ	 [
 J	 J	 [
 7
 7
 K
	 
p$@J	 J	  PG- p  
  m Q	  0s S  
<3 `   0g S  s Qh Q  
e Q0m S   R W  h QP  
m QP  
e Q PP2 @G 
p` 
  ?7  ?  R  Q  
k1   U   0-	   U    ,    U   o. `  V  
(]5@Xp  T  
 $  `4.x  h P? Ps  
@ A0D  R 0@q Tm T  
s Th   R   XQ*  
   g  P   `+1N  q T   +  m T    .    .  P   
 Q<  
+ Q4  
0!01 Q1  ! 0+     q T    +	  m T    .    0[-  P  
 0  X  
 Q
  
   Q  
   Q  
+ Qx  
  h   hT0h  0`0 
\ , pP0 0 S  
/ ` l[
 K	 K	 'K	 7
 ;K	 LK	 `	 jK	 bK	 {K	 6	 AM	 K	 7
 @-!@ + +, ,  P l l , p-  P L L , {,  P , , , `-  P   @,K	 K	 M	 $S	 XS	 A-M   - P  44,  ,3 00C SK    8 p  ,  d -  P  d hl"%t0 u,  q,  0f,  b," 2&  |HT,tTp" ll2l  dH,\\ <"T2 A, p  D<,8! 02,($/,@ 
 1- PP[  a 0 S  UT   + 0 @ S  
 S$  
0    P   ,80  S  
8 ,,@0  Sx  
@ ,h+H0  ST  
H +H+'    P   +PT +  +  T     +2 4 X0  +p WڠЍK	 K	 9
  P	 K	 K	 P	 qL	 L	 ?M	 .M	 4M	 ;M	 :M	 	M	 @M	 DM	 M	 ~M	 O	 M	 _M	 M	 M	 S	 M	 M	 6	 _	 M	 M	 _	 M	 M	 N	 N	 N	 RS	 #N	 ( +N	   0N	 A-xM  P@  0+ P  ``+  X2 00C S9    4 p  00+  0  +  P~  dT`  pX0o+t  k+lt g+l  c+! 1X+  T+!1 
  \J+p X!|1A+ p@   0+ PP;  a 0 S  f4   * 0 @ S  
 S,  
    P    +40  S  
4 +  +<0  S   
< +  +   
+  T     + D *p WxЍPN	 K	 9
  P	 [N	 yN	 P	 O	 3O	 ?M	 JO	 4M	 ;M	 :M	 	M	 @M	 PO	 K	 O	 .M	 ~M	 O	 gO	 O	 
S	 6	 O	 O	 O	 N	 O	 R	 #N	 O	 O	 O	 A-Mh@   ) P  *  2 00C S@    < p     j)  P  *xp t0  t*hl 0l*  dP*\\\" XX2XT#  P*H(D" @@2@  8*00"(2 * p  |*! 1 q*@  ) PPR  `a 0 S  K   ** 0 @ S  
 S$  
0    P   Q*40  St  
4 N*dH*<0  SP  
< E*@?*D0  S,  
D <* 6*    P     -*X\  )*   %*  T     * L P0*p WڈЍO	 K	 9
 P	 P	 'P	 P	 P	 P	 ?M	 P	 4M	 ;M	 :M	 	M	 @M	 P	 
	 ~M	 6Q	 1Q	 Q	 =Q	 PQ	 S	 JQ	 VQ	 6	 Q	 ^Q	 LI	 O	 O	 N	 N	 N	 Q	 #N	 M	 M	 Q	 O-M | $W  P  `@  
| @ ` @ @ @ @  3   @ 3    3   3   3      
1  
$P  * ph  
0C,0 4H<h( d@l)L0  S  
( ) )T0  S  
T ) )\    X  
$  0)  PZ  H0(P,p  S04CXx  
$ t) ˠ ˠ0`@ d)P e)@ <" 88824 @V)$    0 )   0 ) p  0 ) 0 P  )0   J 0  ZI1 0 1)@X0 T:N   :  
$@  ' p  `1D  0,0 4@`( hdlp)H0  S   
$ )  )P0  S   
P (  (X0  S   
X (  (  + @
 \/   
I
 W/   
F
 R/   
	
 M/   Q	 9
 Q	 Q	 N	 DR	 WR	 R	 R	 3S	 ,S	 :S	 R	 c*	 j	 AS	 `S	 gS	 S	 S	 jR	 @-l1l$MP  \ 0/ T1 P p @a   Y  0
   P	    P  
0  S
     P:  
     0  P0 @ `  
 W   *  Q  
    P'       P  0   (  P  (*    P@  	 T   0  S  
 S   W O)   W
  $ j(  $ЍS	 [
 T	 7
 l[
 	 T	 @- @ $  0  @@  )T	  .T	 O-,M  @  P  n'`pP7  @ )  P    8/ `-   |)  P    S t#   X)  P    I $ E    $)  P    ; $ 7    )  P  $ 	/ P  0    P  0 0   
 0  '   0  'p0  V  0   
 \ \ '
 L. ' ' ,ЍCT	 I KT	 RT	 \T	 cT	 qT	  %T	 [
 T	 T	 	 @	 @- @ 0  @@#  ! T	 E-0Mv ( @Z  P ` &p'  0 S   8)  P&  
@ 2)  P   
  
    $)  P   . P   )  P   . pp p0    P    U	  

0 @  p' & & ЍCT	 I T	 T	 T	 T	  T	 T	 O-T14M0 L0"H1@  < 814 0A,+0 q P @( ` p@TP  0 ;'0   n  ,  +0   $',   @ 0+	  @-	 
/-0
 K	  @-	 <
 -	 % 4Ѝ'	 ^ [
 %U	 7
 9
 (U	 9
 [U	 U	 O- |M`&  P@  
>	 P    d   $B` P K& @       L0 
0L00W0VP@ 'ttl2    P  
\	 P~  
 0  	 #$  $tp +p0 @0Cp0``  Kr U 00  S>  
&<0   S    80  S  
	 2%cdL Q%0   0& -  #%@ A0D S 0@`!`&
 T  TP  
r Tq T  
@|& q T9  
!t @  p k+p0`0Cp0t0	 Z` V   
 Z00  S  
p0@ T  *
 U    `
 Z 00  S
 $  [	 $ p 	 $,0  S  
0  Sm@     '  |Ѝ 9
   $( 7
 П	 {U	 U	 '	 U	 U	 9
 @-
 ,0    	' '9
 E-dM0  `  p Po&80 @ 0 S   0 @@. Ѝl[
 9
 U	 G- `y ,$@ P 0 0 P $  P  01  Spp  P %' U0@ 0X0' U 0  S  
 P  U@  
 |% @ y% ,  T,0  0  @ %  Z
`,00 YW	  A- 0 pP  S1  
 0  S.  
)   W%, @ K$   P` `e@  &  P  0  S, S  
 ,9$  P@ 0H + @  $ @P   P 0, S
 0  S ,  U	 G-1(M P 0`p@ 
  
1 0 S  0 | a) @V  l!0X       pC 0 @40#  P 00  S*  
  Q)  
 + 0 (@ 1  01  W!     
0 !  0 p(0! 0 0 D @ ^$  T  
     P  
   h0 0 0
 S S  	  X  )`  T  
,0 0 0 S  , ) (Ѝ[
 9
 V	 l[
 3V	 P{	 B	 <V	  O-3AM  0,"  `  p   P  
&  P  @# #  P@     # S@   0# S  
< ! 00D @ 0 S  P   \0 0  @y     P&  $B@  T"  0:	S    Q  @    0   P  1 @ 0
 S S  (  , @e  	S     Pz    
 0  S  x10  S  
   @:  \0  S(  PQ0  P  
   4%  P   	0B  R S
   - 0* S# S  
  S  
{+    #	   @P0P U00P @   0 0  @P  
P  U  T  X  
  : H0 0 0 S 00  [ 0  S @    T  
 4  @, Aߍl[
 X	  0   fV	 9
 5W	 ~V	 YW	 V	 O- \M`+ 0T H0P0L0Py @   0- S  0- S  T b  @P  Q||ğ  L hğhH P0  P  H 2  T GH0  S   
T $?   
T :4 @1  S   /  $ @P  'P  Q  
  v%  P  $  # #3#  P     R  
0P0@  0T0 $0      P T  X
  
0ß 0    P  
+#2  	 x$  P   	+@ 0 o"`"@  `   V"" @@ 2#  pP P    Uu      U  
 p %  P
 %  P
p %  P
 %  P P   P
 b "  P
L 0  P0 P'  )  n S  0o SP   
  ,"@ pe  |$  P  0, S  S    X   ,!  P@  X
0  S  
0P 0  S   +*   Y   P	  
0 0  S
  
0   '   
  P ;"y 0  S  	  ' 
*0  TC    
 \ЍV	 [
 9
 V	 @	 V	 7
 	 П	 V	 V	 9
   '	 V	 V	 I
   V	 V	 !W	  P@-0   
% $  P      @-  &cX	 @-1!@   ? 1 `
  0
pQ" !%    
  @* P  
 & "   !<<("44     
  #  0 S  d &   m"  P  L *    " 4 "  [
 ^ X	 7
 t5 J
	 X	 X	 U|X	 X	 	 -tMp0l # ?  D(@0 00n S    #!   t!  P  
 t* tЍ d[
 p@- @  P  
 *# `P P   e* #  P  0 00n S   ]   P     P " @P  T0 0!  R   Z$ @P  0 P  S pq	 V	 П	 V	 d[
 X	 7
 A-hM
@` PK  P-   p X)   W'  0:	S!   J  `P    0. S  0  S
  
. S  0  S  
    @0 #! #  P @" "   !hЍA-M  00"pp1@  dT `1P 0a(H'@Pp'0 S  0 S  
" P    
#  P  0:	S  
   p p0  S S @@  
 % 0   : @" @P  
 )l '` '0  S
  
 ! & N( K( F!0 )X	 [
 X	 7
 p	 ?	 X	 X	 XY	 4Y	 q	 O-
<Mp( @8  @"  0   [12 ` 7" P   0
@  
tlZ% 4p   P
  
 ( @ U(   R(  P  =j!  P !  	1 0  
1  00  40  S	1  S@U#   T P  
  .( p  0  S]    U[  
    pP
@        "  P  
 "  P  
@  T    P   [  P  [  
 4!  P!  
   
  0 S 00  T 0  S
  
     !0K!0  P  $  0  Y  (   0T0&1  
    T  0  S   d"  P  
@  T  <ЍFY	 7
 П	 	 9 l[
 RY	 mY	 '	 Y	 Y	 @-(0   \  0    @9
 %	 x> p@- P80 @   G  P   p@' @  T p@9
 A-0 :
S;  ! P7  
    @P2     P
     P   0       P   0  S  a0  S	  
A  '% pa ' @ `   @ j    T   d'8@ P 0  @ 0  S '  `  r@9
 p@- PD0 @   0  S  
 !  P   p@B' @  T p@9
 p@- @ Ph  i!  P      D `!  P    @ 0 T    p  T  @ pY	 Y	 @-[X0 @  L   0  S  
8 	  0  S  
$  
 s& @  T@9
  Y	 Y	 @- @P  
  9  X  @@- @ ?' @7@- @  
   P"  
0  S       P  
0  S       P  
P  U      0 ?  80  P  
0  S  P  U "    `>褅 s@-   0  P&  @P  
<  `P	  l      m       |Y	 s@-@( 0 P @   P  
@ x   P   # 0 @  @P  
@ D  `P
  J@      C       |+  Y	 7@- 0+  P  @P  
80S S  90 S	  x    h &        >   0  S  
 S  
 ?0 S
  
0 S   04   04/  QZ  /O-M   0    `P  
  m  P  
R@  f  P5  
  `  P/  
6@  Y  P(  
 x S  P"  
 d M  P  
 0 S  0 S    S   04  

   R  
0B   0 S  S   Q  0 S   0tWW  
W
W  0  T   0! "# 48  0  $0% &' 48 0  G^.  
@	 `  b2 P(     0 )   Pr  

X @    0   `Pe  
  T  
    P  +@    P  
    'L  ,0-. / 	4 82P0d  
  0H B @' P5#   P5  
 @P  0  !0   P)  
 00Hs  Z
@    0   `P  
  T  
 |   P  G@ `   P  
    C 
          ЍY	 Y	 Y	 Y	 Y	 Y	   Z	 O-+LM 0    `P  
 0pB S<  0D S9  |0H S*  }0+ S'  P@~ 0 $4Č Ȍ̌"#,<(< "44 #+   0	0
  m  `P  

  $ 0B S  
 %7 
 t       0H S  0X S+ S  
 h  ) (0*+ 48 <(#̠̌"Č<@   
 "<<!4,4:@ P 0 00   Pj  
0  	$ (,
 p"
P`@8#,$̀Q  
  ,<(<"4,4!X   @H`!<0@#(,"<("41  
 T  *0
 ` p 0 P  P$  
   ^@a  
 04  
0 S  0  48 <S
  0
 Č 4,487          LЍA-HM) 0    @PI  
 0 { PP=  (    p"k ?    PP7  
 0 S4  
 S&  X@  a  P  
  [  P  
  U  P  @(  @0 P P)   G  P  
  L   kp W  	 0 7  P  
       HЍZ	 Z	 Z	 Z	 #Z	 p@-  SM@P `  R(  :  0   0  O  P  
  0 4h 8 < S   0 48@ <4  0          Ѝp  N+A- z `	   0 0
P  P  @P4  
   P0  
    P  
	    P  
	    P  
 	   P  t    0   @P  
A     D     ` Vp  )Z	 4Z	 ?Z	 IZ	 SZ	 ,  O-M   0    pPf  
    P`  H  " 0 140526@ 
P3`7p
$4  ^8( L  n020$0#    0   P6  
 j  P1   0 0   p
  4
8 0P`@$(Ć<  
 
 [  * q
  
` Q@ S@0#   X        ЍY	 ]Z	 @- 0|( p `a  PP9  
4@  #  P4  
 	   P#  
 	   P  
   @P	  $          * 0 p7   P  
4 D   P  
  d    T |          bZ	 kZ	 uZ	 Z	 G-) 0     P  
@    P#  
    P  
    P  
    P  
 t   P  
 `   P  
 L   P  "K P 0
      PyDz  
0  S P`  +@ 0PT  Ul  )  0 0
      Pb  
0  S_  
@    P
  
 l   P  
P@ U`M  
 $ 0    @PE  
 0 4 SB  0  0   48  @   
  0    P#  
  0d!  
0
  48 < S   VP  
@	 T:  0 S  
  @ 	   S  
  0L           Z	 Z	 Z	 Z	 Z	 Z	 Z	 O-  `p$@1      Y   Q,  
 Q  P
 U'  *   Q  *P
 U   *!3?= #=0  P
 U  *!!#? 
,?0
,  p@ X 00@- 0   0Ap@- @ P PP    0!PPpO-M8@P   Y   
X  0  S  
! 0` [0 @ P0  4  [0  0 Q0     P	  0` p Y     X  ``   A c! `      0  P   Q     z" P  
  U  T0305
     0 ЍO- LM R  HX @X 0X 8X 8X  @  @  @  @   $@     0  S    P:[   RX  Y Y X X X   0a < PJ   0 p@P`    0p@P`a  P@P`p0     08  @P`p	
D  @ 
 <  D0$@@P`p (<a <,84j   a 0`0   LЍZ	 Z	 Z	 p@- @P ` q O 0   |@	0B  R S     P   0 0pp@-(0M P @	  
  ; "    0"`  V     ~   t  l   P   Q $0    @`0"<    0"ЍpX #[	  E[	 @-MPR L"L2 @H    !0B 02      
t 2@p` 0 20  2 0  00 0 101@B\0Q 0  S10   e   Q  WZ  
 hP p  \ D! 0 P	  
R  P\ 	 \ Xv0 0 D `P"    0" 0   
1 01 0R p %  `P,  

 P0@ $0 00 00 0 0#!0 @-    ?  :# @  "  0" R   Ѝi[	 [
 w[	 7
 $?   9 D^  A  [	 $^ ] [	 p@-`P` @ `!  "  0"p@-0  N   P @- P    `$  0 @0  ` 00 @0 @ A@[	 p@-P. `c @P  
   P     
 ` p@-   
   00 R  0Z S  
 Z      KE 7zX[	   <   @; p@-. `8 PP  
@ t  P  
0Z S  0  S   0 0   @  P	   A. `r00a00    ` p[	 [	 @-    P      P  
     @; [	 @- @    P      P    
;    P	     L   P @       @ [	 [	 @- @    P     O-M   @  T  
 0- Sl  0  S@  
g   m  0  Ph  a 0 
  
 _  
    0  P P  V    TP  
 	;/ PP  PM   0    
e  0  P  
*    ?  P  
0 0     p p 03/ ` V   T  
 V  0  S  
 t|0pt0xp U    ,.0 0 r U  
  0  S  
0  S Ѝ   P P@ P[
 _ [	 [	 @- @T P0 00  S     }c S0  00 0$0$$    0 @[\	 d[
 [
 7
 ^ ^ $\	 @- @T P0 00m S     \c S0  00 0$0$$    0 @:\	 d[
 [
 7
 P_ ^ c	 @- @@ <0  80 0c S( ( 00 0 0@\	 d[
 7
 [
 \_ ^ Y_	 @- @@w <0  80 0c S( ( 00 0  0@'\	 d[
 7
 [
 T` h_ @- @ \ 0   0 @ts	 7
 ` ^ nf	     7_^	 @-@   0@D0   TO-MM  0  @00C P7  R   N0!$;0$;P Q @  @ = Q<  =0C Q   0!$;0C$;  Q20  @   R@00CP0 !!\ ! 0 !@#0!!0P# @0 P!      2@  0 1 0SPE 0@  P 0 @$0 @ P     2 !0!  
  Q     21 s
     2  0@0@0 S     P2 !0!    Q     21  S
     2  0
0 @   P  @ PP I@4P(4  @ 1,  c吡0j	 SB   Z  
 S  0FQ@q          Q  0 1 Y0A@DpGPE0D
 S0FAQ     	p     R   0 1 X0b LP@0L
 S  (@3088 (0   Q
1PA  
 Q
0 011 AA0

pP  0  0 00C Y'     10d  S1 0!p
E!   Y BA    P 10d  S  1P 0H    1P 0!P X0  0j	 g R 0 
	 b}0h e R @0  b	s0J	0@g@h j0d R,4 1 !  ڶ^0  吡 cA  ΍0  cA 吡   , 4 4  Q+ A     0 Q R  
  11  1@  0 \$@P 00e0$0$  0p 03 Q0  S
        R
N B 1 'P  \= 1ߍۍ    E-@  ` Q      0 R     0 R     0 R     0 R     0 R     0 R     0 R|     0 Rv   0   SH     0 Rj     0 Rd  @p   0 R]  0 0 QW  @   0 RQ  0 0 QK  @   0 RE  0 0 Q?  @   0 R9  0 0 Q3  @ 0 R-  0 0   S  
  S    @  0 R  0 0 Q   @  0 R  0 0 Q   P  0 R  0 0 Q  
   @ 0 T @h  P  h 0CpW 0Z  O-MM(ŝ pÍ,ŝ 00ŝ PD D,A1D @吱 30P T 00 k R0  Se  
  P    [   `ğ1  S B8@ M  8
  j!, L H  0 Y:  0 Pj40 @Lp0P(@HP	@`  04 ,@p4
 0D R @   @     (0    400  P ( !4EHPL 0P  SHPL
  @ 8 @A@ 8@  r4E 0  S    P1 @!0  1P!0 P 0  \   P !1@ p< `P  <p<< B Z+      000l  S1 0!`
D!   Z BA  @   0 @00l  S  1@ 0PE    	1@ 0	!@  U	  1ఔ吱  #D00Q  0k
 f R 0 
 bX0d
 e S0  c N0 Pe@fD  k0` R ࠡ࠱ n0dp p R$	`࠱
 g0n `$@D P R
  @0@ `,p ࠱1\! Dq d 尔$      PAߍۍą    0P08 @ D    0Rh0X00X0/00 S /40  S   /0@-0P @  P, @!<%14#P04 T00@ \0h@
  
 \  
 \  
  8  0P800808  0P800808  0P  8  0d@P80  080P80  080P80  080P804  0 B80 800800  @K (0 @0H L0$A@0H LL0  S/0@-@P  @( ,<0@0H L0$A@0H LLH Q 0a0d3 L H00p@-!,@ P$(  $$  @  p@!$p@- @ P@  p@G- $p 0Md0  h0  Sd 0d0h!< Qd0     0d2  R      d0 R P9  10S0@0  0ha R.  
  Q  
 A@0  
00l20l2  0h20h2 R@0B£  0 0  0   V< ac0c  0!  !P8  U  Q  
 A@0  
00l20l2  0h20h2 R@0B£ ʌ0᳀1 ` 01܍O- @d \M  $    	  00B0  Q  P  
 400,  `` V  ږV  KV  V pP  0 G   0   Q  0N R U R    U  
 01 Bc400  
   R 00  R 0  S 001A 0 RPE  U  ʓl̄`P `m `lp 00 0 R  P   51<P0   P4@P`0 UC  1 ZC  X`0   RCpᅀ`  0 0 F0! ^  p`
 Wڶ$  X`01S S 0 Q p	  0X $  - 1P01
 U  (, 80  
  ,`0  S0<0    Ql7 l >` >C    08   P= 0  =$01  R @ P-  =$0p  6 PH$P  P    =   !01!=-$0$ 1 Q    = 0-$ =$0!1 R= 0ࠡ= 0Q5 HP<  P<  P    =   !01!=-$0$ 1 Q    = 0-$ =$0!1 R= 0$   =-$0$ p  0 R =$  (0͌ 
q  (  0Q q 8p
  = 0 =$01  RqJ Xp     =(01  S80 R    Q0    \  
   0 C4?0040 `  R08 ,0,; 0 Q08 ,0`` V`  
   R0   R   pVR     R0    U0;0RP     \ 	P "  0R P  \0  Q 
  (`0  S 0 R  P  (`[l` ^(`P  400,    h  P @0 0<    PP  h P  V
  h0   0 Q  PU`     `    P0;0 0 U   `   V Pl`  P  
400|p     P 0 U    PE 0 U   p Xl Z` P`0 U  4 1p WpCp6$ `  0V P! U`4  4 \Ѝ     0p@-` @   L    
 p@20   0 0
<P<0< @  44 40@   @p@.\	 [
 1\	 [
 7
 9
 X de Y_	 O-MMX  $ 	 0x
 \@  0A $@P   ``0~4B$101Q @Z\!   `  00 " R   	 0  D4  R 0$  0u4"$10C1`A@TZ  ̌,  00   R [Ϡ0 Ġ=,0 ` p l(05%P 0$ 
@  (0  L@=,0 Q(P   =,0 0$  0  5 `0a S =`,0 Vq [ ,0 ` P5p@ V  
     06C \  ` \1  ` 0  S   06 0`V@p    $1  6 01P60C 450   0` S\AE @  0 1S  S  @=,0!` =,01 \@56!CC   0n S\!E0 @  0 1S  S  =,0!`B LN=,01 \ $1Q61.00a  X     
%5 &6b   0QS@0B0! A
  P> 8`#Ƞ0! Q\A @ B0Ѓ0ѳ  P,`X`,`LMߍ      @-08@M P Tp  `  	0" #0,0 `@0  S   0  008    1  S   
  RЍ'  p@-80 @P  S
  P0XT 0 Q/#P0 0T @008 X0 Q(0  \  0H0L0 80  S  ڌ   P       \  U  
 4 , T p@up0hZB&YA1YS  8ErP  A- @0 S0   0  S  
D @0 P  (0   0  0D0  0D000C0  000 !  0!D @0 Re  0 S  0  S     P[   000 S    Q0  
8<0 X,  00P4` p W  
 V  P, !<,1   4#P0h`800p080   V  
   U   0p0   040  000  00C00 S  
  Q  00 S   <00 040 Q    8 <0 R    *00u  QsA-	 Mu2 p `1 @ Єj 0" 00$0 c 0 00^    PE 0  , \`<P!<00 040  @N  *` `P  P!  K  `p @:00  V    S    R  
 %@  00
  00  S   8  P  
@ D0 S@   @ T T  
 T  
 0Zs  
   P	  
  Pl  0h   d  0     T  
  V
0  S  0v 03?
 Ѝ9
      T C\	 l[
 x   0`A-P `p@    5@TZ ? O-  M 0$ p3p 0   
           P  `  N  0/ S
 0. S  0/ S
    S  
 3X  0   
          P   P  
 h0

Q	Q   0(	Q:  
l0 S7   	P  U	  p X Ph  0   h0 S  l0 S  
 P  | @ J0
  0@|    YX   
h 0    R     0(  	h 
백p0 t@lP40<@ `h8@TPsD  pm P @ 
8 T 40< ` @P@D p$(`D  ? ? 0 #  
h0:

S     @Pu
 
$ ` "
   S @d( h D`p,   Z  $0 [
 Ѝ
 
![
 7
 ]	 \	 	 A-<2<"p0424B  AD ,0 0 P0   @5 < S2 ` @     z  
  P(  
    

 x  P    
    
   a`  
  
0 0n S    
T P!PD       ,1`0   
1
 01 0  000 0   
0  S0 0   0p @0 0@  00 0  0 0 @0  S   0$ J@   P
@ D0 r   s  
J  X  T
      Ѝ'	 U\	 [
 \	 [
 \	 7
   A      9 $?   7
 \	 ~ P  /  P  
00@	 S   0a0C S/  / 1  QA-``  P pp9   P   U@  
 ` @ P00@  P	 S 00B  R	 S   P 00 S
    00 S
        P a  @p`00D	 S  00A	 S  000C	 S      P   0  S    P'	 p@- @P   0  Q p  G- pP p p `:  
   @0`  S  
  	 S
  

 S  
  S-  
  : S    P@   0  S#   R  T@
   00  U 00  S    @ 0  \ 0  
    0  U 0       b  \Pd
p@- PP @    0@0 T:  p@pp@- PP @     @  P p@pp@- @B 0P `0    X`p]	 ]	 p@- PB 0 @  0  p谖 p@-0 @P  P   p@ O-   pP `   0@ @~ qP`
 U 	7   I3 0 @-l0
  P\0 ` p
  
  P 
  
 f  P==0 0@  P  ?  h[
 0p@-  g  1`P0A   X
 @ H	P @ U 0
    @ P  ph[
 (  ^	 @-|0
  pl0 ` P  0 =>010P
  P  
 f  P=?0 0@g<01  S   h[
 0p@- @
>  1P0g<01  S  
 U  
 U  

   @0    @  w  T   p  ph[
 a	 `	 O- M  0 	 00	 @ 	 @ s  %	 Z Z `   	  P  
   00 " p   C 0 8 <0 0	 u    p d 0 
 02 0 P S	  ( @P   0	00 0C  E	 @ A	 `P0    _	  P 000#  
  V	  P 0
00  
 d M	  P 000  
 D D	  P 000  
 $ ;	  P   0
00 0   @ 
	 @ 	 0 0   	 0 0  0 8 <0  W 00	 00   D  `P    @PS Ѝ ( >	 ^	 ^	 
^	 6	 ^	 ^	 \?	 ^	 ^	 (^	 p1G- 0 aQ: M 0P@  
 ` @ :C pP   
   T @3$  :P  T@      - p s- ` o  V 00  P 0 P0 ` @P   [ @  0J S  $ 0 8 H X      t  3  T     T    h[
 0@- p P`@ 
 p0  0 S   T  
    P    0b  S0'<00 =>0!  Rh[
 '  A- P  p   @ C   
 W `  Q6  
P 	 P 1  ꘤   Ȥ ؤ     (    #                             	 
         
      b   @ TT @  T   X      w(0M>@ P `Kq `	 ]	 h[
 A- ` @ P    p  T   
 T  
 T  
  p    D 
<0<  @1!g<0 PA  A+^	 h[
  p@- `, 
 @ P$0$   @( T p L^	 p@-`  H   P  P @    @   T  
  e
pL^	 e^	 p@-l 0  =>010AQ   `4 R , $   p@h[
 }^	 ^	 `	 a	 A-  `P @@P      ,u q @P I  pP    0p@- `L   @j  P H  U  p  [  .   P p@L^	 E- PlM p `       Z @       P@  
  Q 
%   P	  0:	S       p`P  U w  3lЍX1M-  
>  1@0aQ   x'00, M 
  T M
p  
   B 0 c x 0 P [ p @   P = ;  P p   X   	 @ ) ' 
 ( Kh[
 ^	 ^	 L^	 Ě ^	 ^	 ^	 1K- 0
>  ! aA   '   M  l  0
 
   @  N pP   P p  @\    <  @ 4  $ yKh[
 ^	 ^	 L^	 Ě ^	 `	 E-"0 P @=>010q [g<01 ` 0 0,4   P  =>01 0!2 0   
   #   !_   ` 00A  S  3 1@ TX   0 P0 0h10d1 0>  X\(1 0   @
   `F> 0P @0   	  0X@  0 00  00 00P0z>    P  @	    e
 QX0   X0   P % x  l 
  h[
 a	 ^	 [
 _	 _	 '	 L^	  7_	 (   <_	 ^	 D_	 P_	 ܮ p	 Ě `	 ]_	 @-0M ` 0 PZ:   P6  
  w pP1  
 @
     
   *   P
 P   # o  pX  u .:   P   , A@$  
   e  Ѝ?	 f_	 _	 p@-P @       0/ S
  0. S 0/ S    0. S
 0  S  
PD {
   #" 00     PP  0 @  @	PDp<	 _	 @- p` P 
 6@ P  T
  
 $  P
   0]P	 	 O-\DMp=P?  L?Lϟ H < T <?@     
<@( k  P　  
 e  P  
 _  P  > ?   
0B    
  +   p `%  
 
 P
   P  
@  @   
 @  ,>( @"(= >010g  Q
 	   P	  1 p   

]
[= PgKX@    R&  
0   Z=>01q 0a  

   5  P   0   i Sir    R    0R0 \ 0  S08
 O;@X0 T      
 P "  Q U  
 0@ 0 z   @0 X 4Q<  0<0<  iX0P0 0 A 0  St 
 
  0   p  Pm   0   ; `0=>0104g<01 P  S  
0  S   
 0 @00g<0 AH   $ D @   ?  
  @     0帠;M P>@1  S X` 
0 `   
 A0 W  P  
 R  P  =>01   
   
  
 C  P  1
09   000p0`G  SQ   P
 
  P1PA  
~ 0 $ 0   pP*  0!    0p S!       M>@1   S   	1 00 0#4010000  h  Pp9  m>`!0 W 	0  S8 D  0=>0q0pH @$	%  T `1  3  0Q  0 S)       
>  1  S  
0S+ @  T    	0 0=>01 V  P  
 0 h4#8!D  `0 V 	0  S<0,0,     P   
0#g<01  S  
 @  T p`  
  0Q 00@ S  S`  
      V   p`t 00 S S    W  
 0!#"0B Q  
D=>01  S  
 !
 p  3  P3  
 @      !   P'    =>0$"(@    \㴐     0 00p S   04#R	  
	 Q@t6 T   =>01  S
  `V      RQ  
   W    
 0  4 P#8&1 g5  5$   P"(  \a  
0  S  ş&   ^ P Z @l7  T  43  Uxş  
8.  Uhş  
,)  UXş  
T$  ULş  
(%<5  U	 0$ &0   V 00  SP`   Pp 0 [6,g;T0 Q, :  P@     
 0 !     
 0 z          
       
0 P@   U  @    }@  TL  ( , 3       P  
@  @   $ 	    P
  
@  @    @$ g<01 p  S  
0 a;  P  
  Q2  P  0!  +  P
&  0$ =>010   P0    }  g<01 0!    P`  U 0  SH  $<j  P  $$       48 4P   U,  
   P  
   P  80 8  P   84 u8P   U  
   P   \    P40 
      Q   ,	   I$ G	 E( H3  P@	@g  X h[
 [
 q]	 _	 7
 _	 _	 _	 [
 _	 _	 _	 X W _	 _	 !`	   1`	 ̛  ;`	 V`	 q`	 `	 ^	 `	 `	 ^	 `	 `	 `	 `	 `	 a	 a	 3a	 ka	 '  '	 a	 a	 X a	 b	 b	 )b	 `	 @b	 ]b	 wb	 b	 ]_	 b	 2c	 ?c	 Kc	 Tc	 	 P	 B `	 b	 b	 \c	 l[
 zc	 c	 b	 _	 0=>010 P X T  P   0   | g<01 0! @0  S( + )   p  0 0 0 S  
   v  DЍO- 0P0% `8  p8 h1@Xp0\    L  D  <  4  , (1(! $   1  @ 1i0  `P	  
0 Z
PP00 00` `   
0 0 000 0 00 0P 0
 U   
d	 	1     P `    V  
 `; l 8   谖 D_	 ]	 P_	 ]	 c	 c	 [
 c	 d	 7
   9 d	 1`	  $?      A0   Q0   /  @- 0. Q0   01   ?0  1   Q  p0M.    ! Q@H0 
0 0C00 ,00C0C0C  h[
        G-  0᳠ p
-    `0 P@1!0 Q  :	  0 Q=Q-000 0 Q   `0 10 R  :	  
0 Q=Q-000 0 Q  00  |4 \ڈ0᳠h[
 0@- 0$M `Q-p
   008#0 P P@
  0  Q  
 0 2R 02BY P@ U$Ѝh[
 4O-  4  `PM p4| @     R0    
|4    |0Q=00 |@ ^   [8 #Ƞ 4 |$  A   0Q=00A    V    
0 00b03 |$ R|4?@  	 C@D  Tp3	  `|4@ C10|$Q014 0C C0@ 0 @0QMQ-00 0@ 0(  Q 1Q="(00P	    
|4 Sʀ4  0C  4   0 0    @L2.    0  Q04   001 4p3  1  0a 010 0 P  \ !   1 \    000 P0b ҧt1    0  S02#0  
   000##0pW  XC  
!>0 D00   As  \
0.    0L	00. 00 0H  X0C0   >0     t0pG  P0  S  !0 S  
H  c 02# 0@L  \@D  T	 ЍOh[
 =      @-1    \ P p `  00  :   Q@   \1  
 Q   M>0  !000    \
  
  \  
 M>0  !000|0|    
 Qhl l   Ų000  T 0   
 \     00P` Uh[
       1@- P@  P00 @  .!000&  0Z=00 `@ V". !0tAt0003^=b=00 D1/ !   ,0`$1 0 000Q @0 0`00   0  00j= 0    `0 P0@:#:  S  <pH` | 0  Q ,L00 S  *0f0S  @0 T  
 00
S    h[
           d	    0p@-@ P   Ⱦ `  
 p@E   0 P0 00H Q   @
 
  	 $ (   00 00@  p@7(d	 [
 d	 [
 7
   h[
  de M_	 p@- P   =0@ s  P0  H@N  0@ 0!01!# P0  0 00ph[
 $1p@- @40< 8cPb uP*  
 1 R'  $ )8 <H0)BA9C8 H0<(0 0 00 	Q 3!"	R)B0 0 00 	Q 3!"RYP0 @0  S  <04 $    0@ s  00p40 040ph[
   (0@- @   R  
 (P 00h[
 |0p@- @t0 P ( R   (0 $ p
\    ( %$0
S 0  p@ph[
   p0p@- @ aP `1T Q!
  01DT0! cQ0C00Dp 00!Dph[
 O-PX1 
 U    00 
`G  @ Tp   U=  
 T  M>01 @T$    U  
 U`  
M>01 0 0 F  
 T  ʔ0 0 D  x0 0 D  W@0   
 U   @00P` Zh[
       O-L1  p@10  SF  
 ` 	0 j= 0 00 P`1   -  
0Z=00@<01  [0  Q  
f>01  `Q, 0P U03^=b=00@1  @T0  Q  
=
0 `7(00 V᪠1:; ЍO,h[
   d	 d	 @- @   $@`0@- 0 S  ڰ\
    S  ( !\0
S 0     0  01Bh[
 O-2  @2"0 0j= 0   	2
 >2 98 Pp20M>010  S  PE UH,2   ` )!,"p0
 2,
03< S 1 W   ^   X $  
 1
H P $H
  !  @H$
  x1  0(  
R    oPJ  Z>   S   K, 
(1( 0,   0@p0G
 } E  00@M>01 q	 T]PN@ 
  th 0 000  [  
6(0D  0000,  0 h[
       4  d	       9O- @ `tM)`` - ; )00 p)0  0  0P)K̈́, 00  0 p0 )M]p$P0P0  0  0 80Cp `` `P` 8` 00aD`8f.  0 1  d8 00Z=00L8 0Q \$8    00Z=/0(=
0     7 00^=00 7  0\  P7-
  0   7 00b=00 t7  00C\  P <7/T  0!00 \007/   	0!00\006/  0!00F\006/   0!00\00 U PH6KN
@ `0 A0P U    @)<@H@$ 0@ s04 HPF4@0@     5 R  40  S
 0D05 $ D0  ""))D 02#99D0X5 @0(  
R0    ( 0 
R0    P ! <$0D   002#99)D0 @@D0  \9080  T@P0  
@ 4 P  <$0d S~  $ Q~|A  < R P ppG0 P (4 0 0$0  [  0`S V  
`E     0 R@   0 R<    0  R%   0  R    0  R   0  R   0  R   0  R   	0  R   
0 R  
 Q: <j0J QL   08@3 Q  0`SP  P"8  8  0@ T  X 2  40 QP1P! U  8 <00b
S   Ph2 @@ QE   UC  < 0A @  c4 @0   c0C@04 2  <$0D < 00 2#99)D0   H@@ D0  P90@0 C  R@  0  ^00P3  
 P  \$0 l    0  0%    Y<   
$0  0S  P
  
H<    \$0  l 	<0H00  <400C40<  0<00  400C400 0H@C   z 0 R  40  S
t0 4 H@L  P  Y  
$0 0S    \$0  l D   ,   tЍh[
   d	   d	 d	    d  f  b      ~   0 R 0 000/ 0 R 0 000/0 R00 000/A- pQ`    H X$H  d0 V1!  \  
  0  \@Pp ,`l.  @* P  V    @- @Q     R  
  
,0   0 Q0 01 #  9
  000 0/p@- @  P`     p0
   /p@- @lI h0   `0 P0c ST  0	0 0 0 u S8  00 0 (0((    0p@d	 d[
 7
 [
 9
   p@-X0 @ 0   
. PP  
 4:  P  
$      p  p@[
 e	 
e	 e	 p@- @P      p@9
 @- 0  #  @-  @- 0#("<@-    0#("<@- @  </ P  
 Re	 O-8$M 7 0
p PP}  
 u  
U  ; P 00 @  P    P0 U    W   
XC0%P p0   
 0  
  T	  *0   
 0  
   W  	 d p	0d`   \  T@!#  *1P 0	  0   
  0 @0  
 
  0 @   0    P0 U@0 0	  0   
l  0 Pt0  
L   0 Pk  p~  $ЍC@ 'e	 Fe	 [
   0@-OMKO@	      	  @P  
K/
 {	<0)@Q   Pf   0 %
S  :1  P^   PZ   0( %
S  :)  Q   
 0 %
S  :  @P  * N?  0
1B( @ P 6  (0  S2  
 S  )0  S0  
   S  )0  S0  
   S !  )0  S  	0)0)00C S    @   
 U    @ 0 T:
T \ @ P$ 	  
   8 /0?I
 Oߍ0e	 Ue	 9
     fe	 p@- @P    p@*9
 @-  0 4"40`  @-0 c @- <(  <"4  4 0 @- <(  <"4  40!  O-$M0 ` 0 ` 0 \ 0 P`
i @L TP

  L @ T    T0  
  0     R
@ 0 P00  00  T`0@ T_   ;F0C!  b$1C 0  P 0`0  P @K  0 !B  Z1 c P9  
     Y 00  S  
 0 S   0 0 0 h/  %    R"  
 0 S    S  
	p@0 S   0 00 h  Y  
	  
$0 00    `   0 000`  ? T3  $1P0 F0c02C0 a  Zp  
 X 00 Y 0  S\ L  
    0 S    S  
	 X@   g 0     o   T  0  
  0     R
   0F!1C sCP  0  
  0     R
   05F 1CC PP  
y@  ZD  
0U X     Y X@ E    T
   0 S
   0 E0 0 g ,   Y 00  S&  
  T#   0 S     S  
	@0 S   0 g00p  Y  
	  
t0 0 0 `    0 @00 00Q@0` p @  0UE@  T  
  00  T 0p` V \0D  :P V U:  0b 0	    U0b 0    
 # 3$ЍG- P `H(0    S   
 S  
 S   p '  pO ?  Tn  
0   
   0  
    (0 S    0 p
    S    0 p    S
  )  0   P   
      Q  *(0 S  0@#   
  P  0 S  
      0   
	 0  

   R ! #!  *0   
 0  
     o    ЍC@ ve	 e	 e	 0@-MMK/  `1    0,00    
0,0  
0	0  0,00-0	40  
,0 S  0	0000	 0%= 0m>00    k   g   c, m- k p n l j0*P  @  \  T  
 >@$ ~Y Mߍ0[
   0   e	 9
 0 0    
[
  0     `/@-0 # 0@ 0  0   P  
  0 T  *| 0   \   1#,,!$<   \  0 48#8"   \    
  ЍD9
  H9
 L9
 @-0 # 0` 0  0 c  P  
  0 V  *0	 S S  
 S
  L 0 P  @     @P U    @ ЍpD9
  H9
 L9
 A- p` P  `  X  @L   @ 1 @6/ 0P   P\  ^  ]  <	 O-tM P@p  #  c0@ S.  t l     <   d    \ L   [
      [        0  P    (&A p6 0!140  R  0 w   2 0  `   0$0 0  8 8 5 R  r  D0@ #"̠̌ <.Č,Č 0  D @   @02,(03   g,0      ,,8,#$$('l8 $l#d|4  \ 0?C0C(*  0  ,0
HX
$%

 0   ,0@ 0B  R@00@D   @$  \   `   0  @$   R$  0 
3  3  P        0   @ P  @  0   @ P @Yh3   `  p  
PP  W  
D
B* <3 @$043 00 0     &   P
  	0	 S  `   P @ 0  Z  
 2  P @@   |}x2  P @L@v  X P:p0 # 8P 04"2 \ b  q [  j T  c   @I  X B R < L 6 F 1  
1p 0 0 P 0  0   P 0 ``  H`0@ S  
` S  
  S          
  
  
 @p    P U0000000  74 0   PtЍe	 7
 H9
 D9
 e	 L9
   ]   p	 ̧  9 `     e	 J  f	 f	   8f	 ?f	   ^f	 pf	   f	 f	 f	     f	 	g	 g	   -g	  
  \  ^  a	 p@- `P P  P@   @A|  P   {   p@"  0@- PlMh u   
 
   P  0:	S  4  @  ṩ    lЍ0
  ?g	 @-   
   d0 R  
\    "<<!L,4,L4,DDB  0$)  Ѝ莭Jg	 @- hM  P  
  ;  `   0 R !     `   0  d@)     &|0 R  
t0 Rp0  
l0 R      T0d  RL0  
H GD0  3/  P4   hЍzg	   BZ  K 7  zXZ tt g	  g	 0@- 0M 0   V o  P  / P 0 0 e  8  @P 0  S Ѝ0@-0 M Q    0  0
 b~ @P      C    
   P0 l h0  0 00   '0  S  
0 0  $  0Ѝg	 g	    P{	 l[
 q	 @-M  p@ `   P     V  
 0 P0
     W   0  @  PP  T+ w t+H   U  
\   V  
    I p  8   0      
P Ѝg	  9
 h	 *h	 O-#4M 0(  0,0$0' 0 0 p  P 0HHß@0 0 <<ß$`<P (0 @
 , P``@ Ͱ $0 P  S2 `20$0 S20 2 0 2 0  
d
 2 0 0"0 0 00 0   0 0 0 0@0 0 00< 090T2 H2@2
82 00 0   0 0 00   @  T a 	  /x0 P 0 0	 2 @   P0  S  0  S  
10L  
0  S x  t (  0- S  0  SP1 $0  
  Q  ]   P   ((/ ,   P   
  T  
  [   0  S 0 $ 0+0    8/  P
    #   P	  0  #   P  0  000   P4Ѝ	 2h	 [
 gi	 [
 ^h	 7
    9 $? uh	 P=    p t \ A  h	 ̧ 9 h	 p@-(MP@  ` , "  e 0  0 S 4(Ѝph	 A-P p T`V   8  @0@T  ?  Ah	 E- pM  PSP,@ 
 
 0@0 d  ?| P 
ᜠ e @dK K  4 
   
 
`ߍh	 g	 p	 G-M p@ ,
 `
d 
 "d  0 l   0z| 0t  t0 	 P  ?k L  B   I  ?  J   B P
  U  
10 d 0\ 1  S]  
   K  0|V  0:

S     @P p  
20 d 0C 1  S  
0  K d <  	S  c 500  R5  
 R<  /0 2@.  
S30  

S  400  R0 6  0 	  
S600  
	S
  400  S0	 Ӝ { m "  c0  S  
0  L:	S 00
   
0  S  
 0LL  SH0  D0  0:	S00
 ( ܍  h	 h	 '	 p	 7
 7
 a	 G- Pp   B 0  S  20 0 0/ S
  S  
0:	S
`A  
 000:	S)  
0 S  $   `0 S   d0 S    0 S   0 S  
   Q  Q     (0  0   &!  0 R   0 R  x `0 R  | d0 R  \
G  `     0/ S@  	   P=  
   T  
0T/ S  / R  
  	   P/  
@    R`  V+  0:	S  
  @P       @
  0  P  
 t  
#   0@ X  @dKK }   8N    0  S
P9
 i	 2i	 Ei	 9
 @-\0 @ $0C  P   ?  P  
4  ,%    0" "   P
 ̧ [	 L @-{ @     P  
 l @  ;G	 7@- @0P    p   q   0 Ѝ0@%Ѝ0O- 0IM p110 `P>   U$  
 U+  
  U@  o P  
  l P1  
n P  
 P
  
6  q P  
  v P'  
0  &  $  !  E P   >  `
   PG  
d P  
x P  P   P  F5 S   d P
  5P      p% p  V   " 0- S     P    Y   $U p @       @P T p 00
 p  0 0  X  
  Z	    Z  0  S  
4     0$ 0E  
 X4 Q  
P4 QL       Q Q(  >	@     /  ,z    P    P  
s    P  
0  S!  
>N/Hd{ x fX~j%X>K   0ELl/?8        [Z  
 /  P  
 (  p    0 S    Z  P       Pu  
a  80:	So  
.   (b  p    0 S'  
tE Y^  
80:	S   Y  
PRL@& P    P[  
n QJ  
  A Q
  
N QD  
[  r QH  
y Q  
V  
  i   Z    Q  /?(#  
0   ?/( 0y   Pp  ?/(10 R  
P/?8 ! R  1  S  
( [  
   ?  c      PO  P      2 { x$00$00 Z 00  S  
 $    Iߍ7
 uj	 l	 j	 j	 j	 l[
 PKPKj	 k	 k	 ?k	 ck	   ;G	 tk	  7
 k	 k	 A  k	 l	 l	 Dq	 &l	 k	 1l	 Ol	 O-$M 
 A  0      p 3+ 2( 2'! BH0)")a0 V"  :Q   
xS Y    0  S  
:\#: #H0a0 V  :Q  
 Y    0  S   0 S  0 S  0 S  
0 \H0  *0 QH0 -  
 pb W0Z00J   W0G 0ʕ   0 0@   00G  @0 T P0 G $  0@  00  W   0 R   0 S   0 S   0 S   0 S   0 S  
LY `
  I0 B12
 0G  	Y B 0 0ʕI  I9  S000 0 1       \  *	  0 S
	Y `
  ! R0BI 0 0 0! B   I	 R9    S00 B  S00 0	 B 00@ B R 0    0! !# 0 \: 
0a 00 a$ЍY;&Y84     O-
 QM 0@`  8   ` 0@  V1  
 V	 T 0000   
 V0T00D   V0F 0ĕ@   0p   00F
 E p0 W P
 @F< @0@@ 0f   00  V@00 000 0  i  ЍO-$M 
 A  0      p 3+ 2( 2'! BH0((a0 V"  :Q   
xS Y    0  S  
:\#: #H0a0 V  :Q  
 Y    0  S   0 S  0 S  0 S  
0 \H0  *0 QH0 -  
 pb W0Z00J   W0G 0ʕ   0 0@   00G  @0 T P0 G $  0@  00  W   0 R   0 S   0 S   0 S   0 S   0 S  
LY `
  I0 B12
 0G  	Y B 0 0ʕI  I9  S000 0 1       \  *	  0 S
	Y `
  ! R0BI 0 0 0! B   I	 R9    S00 B  S00 0	 B 00@ B R 0    0! !# 0 \: 
0a 00 a$ЍY;&Y84  @  O-
 QM 0@`  8   ` 0@  V1  
 V	 T 0000   
 V0T00D   V0F 0ĕ@   0p   00F
  p0 W P
 @F @0@@ 0f   00  V@00 000 0  i  Ѝ 0 R   *0 001 S0D!<2@02 501` 0 S01 00141D 0 S41 04181( 0 S81 081/0  S0C0  @-<1 @  S   E1DF!Q2#""X029#9;00  B 0;0 0 S   000C<1_   RG-p`0C  
 RQ
  A0B2 1 0 Q R   $0 S  ;A0C ! #10 	Q&  ! VA0F 0 0Ǖ    0 0 @   00"F
 : @0 T P0! F $
 / 0@  0	! )#  A	 R9	%  0F00 0   0 0@   00
F
  @0 T P0	 F $
  0@  0	! )#  G-  `@ S  Q 0000!  
 V0T00D   V0F 0ĕ@   0p   00F
  p0 W P0 F $
  0@@  00  V p@- PS @  
 $P p P&   P	  Q 00  R 0  S  
 R     PQ  Q P   R    	Q  ! P  ! @0  	Q  *	 P	 @   @0 P   0  0   0 /p@- 0@` S(   PU%  	 S   C  \  
\  1
  	U  	 S  
 S	  8  \  
\  0 080 0p" S   0C  \  
	\ 01 0pO-  S `pcQ+  ,   84QpG0DE!F3""ʅ!#29#9;00  *K @ @  P0 ;00P_  W 00  R  
   4@ DE1F!*2#""3 [29#9+ ; 00Pᴠ 0ⴠ0   :  T 0041":00  00  Q?0;00 x2 RY  
0  S000 S  00 RM  4q UP!0QO00 
RQ>  0Q0S Z1   0 R,  0 DD1 Q&   0 R"  	 Q  *  0  S
 d! R  *1  S01 R  0  R  
R  *:000 R  0S  
 *;00PE  U0 S  41  S<00b0 41  R: 00   
   Q   
4!0A R02;0a 0 0 P 84! 0Q?0;00 000    S0 0000 00b0_      O-TM| p A Q   0x` + P 000"4 T<1<0@P0 @G
)
08p4ppD@O
(
0@A0A4A 00b S0  
S;000   Q 00001 0010!3P R 001<!@1 S81<2020b81   0      P    P!    U( 00,L 0 RH   R  0u 03Q0  S
   U   X 00 R X  
  U 00  S  
 0   R  Q U   L0L0  S        @Q  0  S  
 LH L  P #	!  *H @  Z#@ pS   0  R0! 0  0  .( L0p RB  :  H ,0 S=  *0  S  
   ( ,  P/   X   
H    U    T0 0    U   T  0i  Q 0a @L0(   P 0 R  :  Q'   @0    H0    @
 W  *L $0 S @0  oL  H0   0   L  @P$0  SD  U  
 0    00      00l 0 TЍ     O- @ 0 @  \  L Q`@  	0b S :
 f0 R  : 0Q0 0L @-    \H    \
  
 P  
  
 P  
   R
0	 d0 R  :
 `0 R  : 0  P`p0 00 PP0@   \   ;D0C!,C  b \ 030# \03  S  	0d S  0 `0000@0{  ? \  ,!  0D0bQC U 030# U03  S   	0d SpA`"U  *   \  p
  
 P  
  
 P  
p   R
0p `0 D#13Pc2   \  p
  
 Pt  
  
 Pq  
p   R
0p `0 #13%Dc QYA  U   0 D,B1 Pc \ 030# \03  S[  	0d ST  0 `000@   U 030# U03  SI  	 d0 RA  : 0 00  00Q0 @0V  
	0d S+  :
 f0 R"  : 0 Q0  0 Q 000 
 P1i:   `@
 V:0h 0 0h
 V 0      * @0h 0 @0h 0 0h 0 @- 0lM ` P  
  / @P  
 0 0    ㌱ /0 0 0   
 0:	S<  
	S
     P  
 00   b  P  
  x p+  2 0 0 S"   $  
  
  p  2 0 0 S  
$ P0 S   0     B     T p  \2 0 0 S  
 P :	S     P   
 00    p   0 |  0    v  
S9  
  
S6  
	S  

S2  
=  

S"  
	S-  
	S7   0   ! @  6 *    m p&  P1 0 0 S!  
 S  
 0 H  
     p   0    D
    "v  p   0     8   7 0:

S(  
 0     p@     P  
  Pp   P  
  P@   } 0@       0   
$0   0 0   
_lЍl[
 l	 l	 l	 l	  m	 A  %m	 7m	 ;m	 Pm	 @-  P  
   0p@-@ P Qp@$ gm	 p@-@ P Ep@$ qm	 @-@<M p 0:	Sb  P    ,  `P4  d  `*           !   0 0 0 , a
  <0  ` , !0  r 0 _0  4  @ p  d 4    <C4< D    0<<  S  <$ r<Ѝm	 }m	  z	 q	 *h	 m	 m	 0 !4@-0  !$@- @<  @p@- @P `$   0 R   *}  P   H [ 00  Q  0  Pa1e 0 00   0  40     R  e 00   pA-Ȁ q P  @p`l     t@ `p000ϛ  H  @P   ;@10C S
  D D0## @0d0  P<    @      a O-zMM  H < @  g  P0    P {  @ w0P(0 L8 U T p0p	 
8(88 T U0  d  P    \0$  P  U0 p@PW4   
 J P2   
z΍0TC B0 r@D0 tP 20@ S   +  P 0    =0   R0`<P    T @   Pz΍0/CTS B  00=0 B0C R`LP V @  0l |`4 ,0   0@P@   U   P
  p-  0 B0 0@  000CP4 TJT  
  =00C0 S    S 0 P4 R, 5p =0! <,0  D @ (  
@    0 0   =00C0 S  p4#p=01  40 R 00 Q0	  =00C0z~!T00T04 Q(@ p0 @a 
   4p 0C  g0@D  \z.1T 1 B  1!D1Kn1,`,,  QYP + @ r0 =0  R `@0 [  <l3Ѕ1, 0  8    0 \   % P   0 0 4 
 2 ("  ^0 a    021P28 #<x0  0  U0h  X2! 00l 0     \  0 lUc02 P}  ,0#=01 \    Tp@ T|@:    T  
@ Tf  L5z  0TSz>!X7 0X7   @  P` p \   #   VJ  z.0US=0 Q=00 a Qz΍ 0TSL @!X70X7 `  Y<<T
IvP00C  Q 0     z~  1!X1 41X7 0X7 P  V  
$ ^   p 1$ C$0,0  (`  00 ߍۍP8 Er YS& YA1   -      G-(0p @  SpU  0<   S,@  
0C0 P.   U  0 ,00C  80 P#,!t !  P$"8 0@0 (0  S0C(0  
$0!0C  SBĠ$0  
  Q0$0  0  Q$0
0A0 `0 0 S/#8004  p40     P t  P  
 p pp(    080 ,  s@- @
`f   P0 " @P   * @P      T
   t  04 00 S@  
@    t  0 @  $   H |m	  m	 7@- P @f  0 R  
 
 >BZ  [	 O-dM( !
$U, 
R  O0 L,  ( ) P  , 0  RX P     0\03 <H000  R* @8 D @@L 	T@4@@!Pb   , 000 Q? U  , ( +T PT0@P  S  @ 
 @  a<  @0j1<0 @  H L0 R  X   Z 0:P0 D@ L0  0:@aD0, !0 8408D   qS 
@ P4s  
\ [ 00  R 0  S  
 , H@D@  1@aD0H L0	0 aH` [ 0    ,0, j!`@P0R @ pA? @L  4 FF80  B 00 0  SB aPU p4  [h UP  U      X   $   p g  RP   0 H P P  8 0  H0 H8<0 S^T   P4  X  $    @, &  $0 "   dЍ m	      $n	 Fe	 p@-P @  (
  P   000Ppin	 @-  @ R   :0 4004 0O-LM
 ; 
 P  ;P U   P 	  	@   00 0   J = <0>?48̃  \,4,(,=0> ?<?<=>@DED0 @@<=`@ A@FP >pG B4C?8$ (<   P !  <  2sN@      0  R$ P @   R  : m0P  U$ 0  0( 0( ` `$`, 04  $0Sp  * ^ 5 ^  *  00 `V2,;l2$ .  \0P_  
  $0  aP 2La`0 pv  :w  = <0>? 48 ,( 0`   0 S*Pp p<
0R`  *  5  Q   *;`20  0  b2@ b0 0ZP   U  0`S  *  5  Q   *;`20  0  b2@ b0 0P U$ 8`0$0<0= >? 48 <` [   <0= >?48< P           5 P  *;b2 0$00, ( Sf^0 0$04P0 ,  0a a"BS P0  * ! 5 P  *;b2Q 1P
  :  0a"B aS!`0-  :.   u  5 Q  *=0< >? $(;n20$0( , S0	0$00l   l l2N0 B  0 S*`o H! 5 P  *;b2, 1(0,0  0a"B aS!0  * . 5 Q
  *;n20 1,( 0, ( 
  l l2N4 1 0, (040 ,0( $  P^  $ P0S  *   5   R   *;l
"2 p0 %  ` `2LQ 0  *  5   \ 	  *!;a2  p0	  0` `A| 0p
`  0PS  *  5  Q   *;`20  0  b2@ b0 0`H  X :I$00 Qy   S0p36`  0PS  *  5  Q   *;`20  0  b2@ b0 0p`V*@ G R`I  0
 R `CP  ?G0C0a 㒃(  0S  * c0 `F0 R00c  030%0#P V p`  0PS  * G 5  Q   *;`20  0  b2@ b0` 0㊠pI  Y`(`Y  
$$ P= <0>? (48 < l     R*<0=> `? 4 8<` [    <0= >?48< P4        PU  
ED0F @ AG4B 8C <$(  S <   SED0@ AF 4BG$ 8(C  <  SP <i   Sf   P P   
 P    LЍxn	   ]n	 0@-<0 P   @  0  A "1 #  Q  0T9
 0@-0@ R"  *0 R  *  0 a SP1P!0e 00 \0Cl0%  0 @ 0@ \ PU0 S@5 0  000 0 000/ 0E-S`	  * 4 00  40 P @5 T  * 0 c200"  0a a 0 02C0 0S	  * 4 00  40 P @5 T
  * 0A+c20
0h0p
  0a a 0 0၏|2C00h0h@ 0PS	  * 4 00  40 ` 5@ \ 501+c220  :0a a 0 0@2C T0:
0g0h0O-  (0$M @ R  *h0  S  
 hT D. m>00]. 0 00  0x 0  ?.0 0h ▿0 5 t d0 2Q  * 4 0  00$  0 P  5 P  *   0+c2  0   \pL       a0a 0   02C0 0d S  :  ,0 $ d`  P0 PPp0l  Q02 b52,c&%    0PS	  * 4 00  40 p 5  \ 501+c220  :0a a 0 0 2C P06  T0 S c,0%    P0 0 0 	0
0\Pቐ	  * 4 00  40 p 5  \  * 0
+c2  0a a 0 0
 2C P0 0  $0  Sd0$5 S 0  	 S0C0Cd0  4 00  400`  5dp R  *\X T W;n
  20d \  P`X  h0 S0C     ee2NP0  *  4 00  40A?  P5 dp  U  *";a2P0  	  :  `2A `\0  %  :-    4 00  40   5 P  * 0+c20d0 h  S0	0d0 0a  a 0 02C0E   4 00   40>  5 ^  *;a2  0X *    bb2AP0@d  *  4 00  40G?  5 \P Q  *;`2  0   b2@ b  0` `PX0\0T0T X0d0   S00d0  0  c 0S	  * 4 00  40 P 5  \ 501+c220  :0a a 0 0 2C? P0@ @ RT   00
 RT0A4  8`  cb&T0P p 0S	  * 4 00  40   5P P  * 0+c20    a0a  00 P2C0T07T0p W:G  A 0S	  * 4 00  40 T  `? 00\	 T2T0p` 0S	  * 4 00  40?P  5` P;l22001 5
  :T 0  n'n2L`0  T p W T   P  
 (0 \  * 0 P 0 S 5541 05075 2 54005$Ѝ 0d0T0X0\0`0 x;00  Rln  G- @ p  P   0   0 P 0` 0      ᪼     0     U    V   00 0? S0  
   P:   p@-0G `l@ PG    { p0@- @P0 \    00   31 0  S  
 000 S0 000 0p@- `  @0P 0`@b T@!    0000 @ T 0@  0 pA-n P`耈 @0 S񟗡 m n n n o @o  p Tp s  0    Q 00 Q0  S  
  0Q0$ P    (   P0  S  Q  08 QH00@0 0Q0Ņ  Q0  Sy 0 QD0n  4k   Q    Ql 0@00D0`   H0  4H00    H0  00H00@0L  0  04L0 0  L0  00L0D0 0     P;  0t0    - B0t0 , Rt@-l  04 t0 0p0    	 B0p0  Rp@	[ 0 Sl  04 p00@0L0 S   	  P 
 0  04000C00  S  0,  H c0` Q! S 0(03(   \  L0  SC  L   n*0l   S 0! l s S@1@!n  L0  R	   n? d a  00   R K  0B p0p  P  
ß   0 R  L0  R0bL0  *n  b  2  000`0p   B P   0L0 0 P 0%05 0 0C20  P  
0L 0c S  0cL0 0b S  L@   S@1 \2@000 0,  S@a 0 00    HpG 0 d  R0000H   L0  SX  h0  SU  @  TR   =   0 RM  
  RA  D!L0  RE  :;   , g0` S0!l S0! Sp1p! 0gL0
    0$ 0 0 R$05  ,0 R 0 00      000 0 0 L@  T  @@  p  W
  * 0 P:    PW:@0 ST
     L0 @ 0CL0n  O-JLM      P   Ҏ     , 	!`:  80K:4 @0,q  P P `"  
p 
 pi @P  
  3<p408    TD  
 @0 @  @$@@@p 0 00@   `  0X@P ⨠0@P$  4 00 S	   	*  P<	4  04 00<000 0	 S@v v  w Dy z X{ { | T} |}  ,  P 
0 0
    Pp      @ D MD0 T 0  S  0 S0   Sp 0 40 R 
,00  S0 0000 
  01  0  80 ,v  P 
0  
 0C0 @ D D0 T  00? k  @   
 
 0 P       0":  S   
 0 P       0#   0b S 00  ! SC  00 S=   P 
0 00' RD4  0 0 #400  Rpz <0,  S  80 S  * 10 |  P 8 pj 
T& 0h00 P @0  0 00  R  0 Q:    0$ $  pM 00,0<0000  p0b@ P 0$$<D ,l@ P PDU   @ (0 RP 40 SM :  00 SI :0 S  08  c   W ( , r   q  
@0 S4 D0 S1 0 4 r   q  
H0 S( L0 S%  48@ P$  0  0@P&  0E& h %@  P0%0h  04,  00 S  
 000  R     0  0  0P0 00 S40   ,D P p  
   Q  
000# 0 P: 0000 0,@ , 40 P p  
   p0 S  
  : S  
#  0P 0 R  T0 S    (   0(0p0   )  0)  y( @  P0( pp 00   \   ,Y   000  R    4p,G0 0h   0  0 ,     Po  0 0 , P p2  00	0 0 ,  P+  
$  	  PX      .DP @
  D0 TK  x@|0 $A  O#QtD0 T?    U=  0  S:   0 Rp  
4    W  00 [
  <0  R  $ 0$0  Rp p   p 0$0<   R  
  85 0<0 W P  
  W W
t u P  V  
D   	  LЍ0 0xp0T9
 n	 (o  T n  n	 n	 Fe	 p@-8@0P`0 @<P@0DH@8`TX p萒  	  0 00#01"4#0 \:   0 /@-  @ @d   P@- @L P  0P0L0@-$00 @  00 000O-]MMQ  p0P%    @
  @D 0]Q!0@00D5 S  & 
   =01 Q  S
`   `F=010s 03  V 0  S & 0` S01  : V01  00!=0  00R  J  Q:]0 R,   J,  00 
$   =00 `V    1  S  
].1] 1!  P:@  B 0Qp$4 55P (  0   K02( 40     0@e 6  0e S 1 !  Q  000$   0 S  0b@  T: 0  S 00  U 0#  S @e]>	 
!0 0]p
   Z pHp  
%0 B 2#0c5H5ua150
].
1P [0 S0ic@#  *  0 S  * S, <@@   0n@00<    i06	Q	  ɥE0%0 %   0 P:40   `0  &0H,K>0 `  H 09 A S0  @ p0 ($  ($ 0 [I,   ^ S5    0    uߍۍ @ A- @`Pp.  0 40 R   :,0(   S      0 R    $   P 4   x0 0  Q   P 0"40 0 0400 $  0 00 0`0 0 0 S: ?  ?  n	 O-QMM 0 QN@0$P0  `ŝ0  0L 0 ō5   RC 0  0(  
  : Rj  
_ QN0a@0$0 0 ŝ0 P L  Sō 08%X#8 UE %0  B0tPx|   %<   00 	
R 	0@2 v? R0+  00G> 0 R0F.  00I> 0 RpğQ00. \4L@T$ @ 0   0x S,Q΍ ,  4P@  %  Q^P0%  0 *ŝ@ L 0 ō!ŝL @ 0 ō#5 [ Z0C   5p   BP, 0 <ß5Q P 0C! U 5A:  0QQ ! 0P 5 UL   0  Q  P  P  5" P00
 p0 5 L 0 !50A0a5  R  Q 1 %pM   R  0  0 5	 ^ 0C5i  0   p L | !A3   R  0  0 5	 ^ 0C5O  0   00 L | A  0  |0 5	 ^ 0C56  0   00 L | C p	 ^P1:L 5	@ 0ōP   
x0Q΍  P  hQ00.
P@L0 @  P  %     5Gߍۍn	 R   n	    o	  A-d0 P  S  D T0 @$8 L0@   Aa T  c TM  
 @D0@D1@  0bD0 0
2@@ 0   Aa @0D T3"@ 0cD  H0  	PH  0H0    T  
0  0<2 @  D0   0d\ D0 X0@ < P0@   aq V  c V    @D0@F1@  0bD0 01@@ 0   aq @D0 1@ 0lD000F@1@   H0D  0l0bf`0@@D`0H\ 88 Q c a`0 S019c S@1@! d P\ 
  :0H `   H0` 0 H0` 
  `0 H0 @T0H `H\ 	Q    R  0H0d    Rd 2H0   0  萒 s@- 	@  5  0     P 0l0d  @hP͇ 42 P0   Ph   p`|P 00 l0  S  
p@  T  
 0@p0K   Z l@h h0 s2  
 s"  
3    0x0 x 	\    x0@|#4A   x0|   x0| #4 Bx0| t 0@  Pt00x |0      @    T   Q   0l0  0 P  
|  @    T  0 S
  00$ 0C000  #4 B0      |Fe	  A- !`p0 @	00b $  D P$     A-040 @`Pl U   $   p$0p )e{ P4     2 0 S  3 #40T E- M!p   @ 0	"E `$ 400$ 0a 40 0 00  PP  
$00  00 0 R00D  0   
   P<  
0 $0 0000P  P-  
000000   
   P"  
00$ 00  S 0 S00
  W0 8 00 8  
 w  P  
00000/   n  P      00  S  
  `    0  S  
  ` U  P
  
$0 0 S  00 S000{
$   Ѝ 
 w `JFe	 l	 n	   X@-0  q   p  3p@-0 P  h    P  
0.  ^  P  
@ L
  PD0  
 <  P40  
 ,  P   0T0p pM_	  Y_	  c	 p p@-0 @  P   `P  
 p     P  
 p0  S p0@-MM @P          / S  0  S   / Q   P  :   Q  
<0 R      
  P  
@  T Ѝڍ0  p@- @P        P  
@  T pC-M `"@p  n 5  P   
n P  n "   0"  & PP  '010C S     0z
 Pl0 000000$00P0099 0         0/ S   0/ S
 0B ß 	0"   7  P
  " 0  04@D0[   0   :

S  t" 0       ֠ "  0"   0!0 S   0:	S    0 @000000000  P   PH0H@ 0b  
L0L@ 0 l    P        "  0" k  i 0 00 ?   b      0 0 H0  0 0$ 0 00000L   0 R  00   P     >
     Q   P    L0 0L@H@  T   0L0(L   P Ѝ o	  o	 Io	 mo	 o	     A- `  p0 @P 0 S  S  
0 S  P <,?@P  4$<$@ P@P`V o	 G-`!M p    0,0 Pt6t H  
Z'  0L P   S  e1  S  0   P000 
 ,P
} N 0@D00    P%  
    P  
0 5 RE
  
5 R  0h S  000C	 S
  E  j ?    4/  P
O dhL P0 0 Q@P0 0Q@P
  	2 0  S  S
    T  U   
    T  U  
0  S000U1娠  S
  
W eQB @U =A eQ 008 00J S @@ S  R  0  S  
  dA   P  
E  9 5  P  
M  1  $    x  p  
   
    40  S 00 S  
e1p  S  
 Y  "塁      D QW  
  3 Q0  
  1 Q"  
%  0 Q  5 Q.  
*  :6 Q.  
7 Q  
d  N Q  M QB  *K Q0  
L Q&  
[  V Q;  
  S Q  g Q6  
x Q4  
Q    /(  P   09 0J   0
: 0   0!C   0: 0: 09 0:4    4   8    8   ۞ "  0"rB! 0  0   0@ࢄPÔB  , ⾞    0	0T  40L   S 0 04080  S0 080 @   P  
   P  
 F / @  PP     T P  0  S  0  S  
  r      T"  0" M K I      !ލD6
  o	 o	    BZ   o	 o	 o	    p	 p	 p	 !p	 @-40 @0$0      0" 5  P
 ̧ lL @-d0 @$0  B 0 S  0 S  
4  ,o     0"   P
 ̧ Bp	  @-40 @0$0 \     0"   P
 ̧ Q   A-hM `,$   X  Z@  \p  W    p   @ P<@vΌ8@ 4@ P0 0,4 A@  Q  
 
 hЍ	 Up	 p	 @-h  @0 $0  00 0000$0舫 8?  T s@- P
 `= @P     6/    %|s@-@P `  
  p   q  40 0 0 S    0Ѝp@   VЍpl[
 p	 / 7@-@  P 剝  @ i  P  
0 + "   0" .    P
>p	 p	 p@-@ P ` 0A   P 0: @ P 0 $" 0"p0   p  3/ @-  p   p	 C-LM@ ` < p!< P   0
 S  ;   唝 "@  P0"G F0<@ P ` S  G
 Q  
B   0< F0  0 P/ S  
0  S   V
  / S  1A P         " 	0" M  @( 
   
$  
 "  0/ S   
0   0 P  : 0         @  0 0   P   X0  S  
X T  P
       !  0"  @ @ LЍp	 X9
 \9
 p	 p	 /@- u P p	  0' S
     R  
0' S  0  S /  U S  0+ S0 0H00 000C	 S  / U O-ßDM@ ß8 40 4唇 x3 4  P}@9 0!   P  
<  R   06 S  0 S
  0 S  p P[(	 X      000 00	 X @@  T  
  0G S    [  5` P @ P  U @` PX2T   pPP$(\
 0 S(  
	@h `    0@D48s#8  
0A AP  T  P   , 1 5  1Q`.0 N  
8 <↜  `P  8 <0S S@@  T  
<!<1  Q@@3   `*0 8Q#(8 $ @ p  , " P0  U 00?  P   ^0 0 P@ , 0w   Px0 T  
00 0 P  \0  DЍ[
 TC	  p	 7
 p	 q	 8q	 Oq	 hq	 rK  hK  qq	 gK  q	 jK  AK  q	  + q	 @-    P	  
   P  
 # @%   q	 D  @ PA-   ; @t pP `  U	  
   V  @`   P`@
00   P T0@- P @    q  3  Q  d   Q  
    q  3         0  S  0q	 C  S R 00   0    QG- p   T1	 X W  H1
    0410 Q00  X     PP   P0   0P0 B R0`G V   d㋪ @@  
V   @   @
G @〪 0[?C0C&100d  t0 P  @ H0`  X0  RP X@   {  P@@TPP  [
 q	 q	 q	   m  *	 q	 p@-P @  2@ 00DpA-0   0 P p #@0 t 00P   
 0  S  
c T`P  000 d. 0   d S P@
 $   P00 0 
H 0Pp W [
 s@-P@ `@`0 @0 0   |'	 q	 O-M@ M~ # ` 0  0 0Q  U
  N@ Z 00 pvn0`p   @  P@	  
   P   
       p  L#  `83#
 @  0n^↎P0(# |H >0 T  0(" H2   0 #=  6@ T@~^  W@D|P&  
  1 h0 E  0#͍`<<" P~N@ 1 0 0 0P0C Us    % 0   @SSP@@   TKP~ P `1  0.1 
 641 0  S  1 
 ,A
 0  #]0c01 !0  P? 0  S  0  7
 0㓷(     j @Px 	` 00c T:~ @00C 1# X  
~n`P @  00cp W  ׂ q	 [
 7
 '  q	 q	 	 q	 '	 	 X q	 q	 A-  X0 p R @@  L  PP    U`  
 2  V   p0  S 褍 @- @T 0   @	 7
 G- @H 1p   0!  R00  `    P.  	   P(  (  
 P0@~ T
     
 T      0D@ T  
 T     
$   	 T00   
@P    P
 U0  S [ q	 7
 	 9
    q	 q	 q	 p@-P `@   0- S  
$       Q p@`  \	 s@-P`   0- S @    Q  
   Pa0 0  
@  T0  | 0σ t0  T  -0 0a@ PT0T   00 ` 0⮙ 0  PP  S@ |lt	 X	 [
 mt	 7
 [
    Ss@-P `@  W   P    0:

S  
0 0!ۓ   P  ,    P  
 '      |r	  0p@-   0M@    z 0   0Q0|00  	`` @§ 	  X   0T   P@   P Ѝpr	 [
 X	 [
 r	 7
 L  D  \ @- 0  s0 r  @  P      p@- @P  P   8 0   S  $ G  P0    000$ p	 S  Dr	 O-0  pl|   0   S   P ` @ P  *    00  P&<#1d# @_    P   &<$0$%d,@ P0L0L   \  
0 m0  S  
0p  S	 /  9
    Gr	 Pr	 p@-h0  Q P @        Q         
     	    	  p@!p[
 E-0!01M@    孂 1 Pp 0`Aଢ    娢     U   Q
 =   U `   J 6  p  W0 0  V@@  T    PP    P p`1@  T
  
  & 1   @P  Ѝ\r	 [
 _r	 7
 !1E-  |!|1` @  pM V d1 P   P@a0dq T  414!  hG.  @P;   
\.   P6  
  
    0   
   
0p 030   `
  
  sy   @W  U   P   Ѿ
@      ay  @  @ `   y 0  P` S  
 Ỿ` Ѝr	 [
 cr	 [
 r	 7
 u hu s	  0   `/O-@ğ@<M0@  0,`   4  p
  
 	  
,0    R   
0  S  
]	00 -      	 R'  
P 0  S#  
, 彽 0  SP  
e  PPPE,   P	  
 0  SA  
[   P@@ T    @  Hs 1Q @   0  噽  P,   [
 3 1  S20  0$ 0$   |   P0   0     ꯾  [(0 02 @P p`    @ P
   0  S  X0 0(0 甽00@P T  
 Tp` W:`  0
 S    0 S  Y  10  R   s   QO  *!0 SK  0 R   7P 6 `  P  
`p P3   7   唿4  @  ( 6!P (0  S U 0Z0 U 0  S  
 0     S    Y  
 >0
  N  X0 00 @ T  (0  S  
 r`p(0  S V:
 $ 婽0 00夽 吀   P( i * $ 0  S$ W 6 [
 bs	 8s	 7
 ws	 s	 s	 s	 Cs	 	    t	  [
 7
  /  xSt	 G-ğM  ğ@0    嵀 3  P  	  
   P   
 w  P  A     P  
 0+ Sp   
 p
 1   `  V`,  
 L/ 0  S
  
. S#   000C	 S  000C	 S  0  S  P@ U     
5    U
  
@  Ἵ    ¾  峽 0  S   
  
 `00d00  l ]@    P  
 0@ 000  
 J  P  e 0 0U  e   
 ⓽  P    W L   y  
| 埽0  Y  
 | Z z %00 |  00p8   `q5  
| X冽0@% S '  
 墾 0 `  N S    V 0 00	P  
 ហ   P P	P	 e  
0 RZ f  0   @g p % PP    R0    
 x 㔾p   Plp0 P 8H 0  ܍[
 [t	 t	 [
 ot	 7
 7t	 ~	    }t	 t	 X
	 t	 t	 9
 	 t	    0p@- P   @P   , pHu	 p@-@  P    \  \0@ P       \  
40@ P   0    p9
 E-$MЀР!A  `@@a@fB   0 `奁    0 |Y" P1   `0  @P*  0ߥ *   0 `勁    0 ?$Ѝ9
 7
 Uu	 u	 .Au	 O-頕M@(  p ◻	  0 㒻`p`   =V PP  
 0 0H^v   P   Ӿ P@   ! 5ǟ  H   P   !4徟  p?   P  , 4 PP 0 0=v   P  $p0   U0p0(  
@  P   !t4土  p    P  p0 P 0p0    P   ,    P       P@  
 P@`@  T q X    
p0 0p0h 
 僚 0  S30  
      P$  
 0   p0 d   
A0  
p0   ! <#~  P
   G   P  0:	S  
	S  
  20  0  
!0#   }  Q      
 '  P  
  
   0  0  Q(    P  0_  
!0#  ^  QV    
 	 @P^  
  p0 m  
     0 i @ T   !   0!
   !   0p!   
 d  㒺@p0 
`    t 0` TP1P!   pt00 St0    0w  P<  t `@e  T  
  0j  P/  p0   
 w  P&  p0  
! x0  S|0 St  Q  
  ?  P    
     0   㶻  P      㰻  P @   @  X Ѝ9
 !u	 P u	  u	   A   O-ß3tM @l  } @     
l   P  ι2  P  
  R   0 0
    P  0   0   pl2l"   `!\2 0!10  R   @@ P  
 0&  $"  Y  
	 ᫻  P  	 ቻq  0 @  Tm  
 6| 0  P00  00    P  
 000     Y 00    
 0  S	  
#  X""00   0B0b` p@P   
d00d   0  @ O  P
 嵺 P  ڼ 尺 0^   婺!  R 0T   基 0M   0` 喺 tЍu	 [
 u	 u	 u	 u	 u	 u	 u	 v	 7
 	 П	 ?v	 Zv	 bv	 av	 '	 hv	 iv	 nv	 @-  #V@O-1!@ 0 lM |1|d \  | h1  P  0X1 ` P1  V Pp'  
 g  P   
  P
y 
 pᠸ p @  
Ի p   c {  P  
 T	  

 T   [  
 ܺ ٺ  p @  V  
 ᮸  P   ᪸  P   Ϲ] 
   E
 C 0  S  
0  S  lЍd[
 |v	 [
 v	 7
 7
 7
 v	 @-$0@, 0 ~    @9
 v	 A-hM
 p"   P  
  P@  1 0  
  
0  S !  
  0 R^   0 RZ  0@P:

S  dA 0 R   
   P  
 00F  0@P S101 0 	  0 S  
   P
@5  
  0:	S   ʿ P  0  (   s  `P
  
@0000 P 0C0ĸ ᱺ  P   L0 0   @00  S	  00 0 S   z    P hЍ[
 9
 A- q; @ 0  P< 00   10{ 0 `  0 06 0 ; 0 00 10  00!  P  p00"0 S @ P  K P 0  S  
 (2 z 9
 u	 v	 [
 v	 9
 7
 ?	 4	 A-`  p M  
 p   R B  
 0- S  
@  0  S
P@   P
0@  S0n S   
e S\p0P  S  W  0  嶺   P
  0c S  
0 S  0   S  
00C S  Ì ]0    P 0  S0  
  Q  X  

 LLv	 7
 7@- 0 0"0@  0 ={ 0 0!Q  R  
 0- S  0  S P   
&   ߆ ո0  S   ϸ  P  x P @  T  
 =A  P  L0 P  U  
   x @  P  _y  y v	 [
 [
 v	 v	 7
 v	 7
 O-2M   2@0  0e S  2    0z    2    02 z      t 2  0!  Rp2  0   0    P  y  
2 0 0e S  
^     
	 S  S  	 S
   0 0 e^  a1=P@ 0  S1   ]	 Vz  `PD  
@PP0p  S
	 S`   < 0a@&     @P  
 0 P	 㵶@T`
 W 00  S  
0!   , @ 0   p @  0  S P
 	 z  P
@ 	 x   P  
0    0 0 Y  	 ᧷ 0  S y`0  X  P  
0  x d[
 u2	 [
 v	 w	 #w	 Re	 [
 w	 7
  w	 '	 7
 q	 ' w	 7
  0  S   0    /     R /0 R  /0 s  3/@- 0 @  S    0 0 l?	 p@- @ P@pp@- P 0 @  0匾  p@-`<M p  0^ S   k@   (P F   B   ՝   0    P  
(  Q   0  S	  
00  S  40 00     ,    0  S  
,       @ G <Ѝ_w	 '	 A-  @ X    
 +0 ` p P  
 P  U  T P`      A-P@ `  P  
   P     + T `   @P  - T   @P@TP  * T @ 7# P   
0  D / T   0"  @P   0 @P w	 w	 @- 0 @ S    @
@-80 @ 0    P  
n  P    0   9
 p@-  @  P  00 0  P 	  P  
 @      P p9
 >	 A-R 0   Q  
Yp @   @ `  V  
t  P  
0 0 `X  P  
 00 0  8  P
  0 
     T0 0     P   僺0 0A T   @    `   T p	   @  ` } [   T      剷   `   @ 0 P Q  0 S   0  \ :   T9    P    P  
   P  
@ ڵ  T0      S    T         S  
0  S    0  S  l  `   7 `  0 @ 0  ;  "    9
 >w	 ^	 C	 w	 '	 p@-L `  L  00 0E @ p P  `   P p9
  A- p   @P	  t  @P  h  @P   T  00 0 `   @ P  +	 p	  9
 A- pp  @P  d  @P   P  00 0 `   @ P  V	 	 9
 A- p `P   `P   `P   `P
   `P	   `P   `P   x1       4 2@  0 S  
 0 S
       @_  < V   Q `-  -   P"  y V   U `&  $    T!  z V= V 00    T `   U ``  ^ V    T`   U  
  > V   U`	  	    T     Q`     P   ` : 8 ^	 ^	 6	 `	 w	 ^	 	 9
 p@-{  t  00 0u @ S  P   O  P  
     h P      P p9
 c?	 p@-p0pP      0  SX   
 0 @ 0  S  
<  0  S   ( ܴ   巵 u D6
 9
 x	 w	 x	  /D0 0 
  	 Q0 / Q   P/Q  
 Q  
 /  /[
 0  07
 O-@2MP@0   0- S   - R  0  S	  
00B	 S    @  Q  w ! 㠗 1    0	p!  R10       P Y  
 `PF  :#:  S   ⇻ p

 Z    P`3    0 `  U PP+  1 0 @E     0r	 S  S  @ Pd
  `  @   x@ ` T:@D  T
0 0  P~` ˲ p   U  
 r t   P  
  60  S	 t x	 x	 "x	 '  7
 	 [
 A- @v 0 p 0!  R   3 @ `  d  . p P`  
  W  
     P   P  
   <0  S T	 7
   G-  P@  R  
 0- S  0 00C	 S  PE `  n P
  
  c P  
  q P  
v P
   `
  $1   і    @
 `  a  q  P0    1 @  S00!0` S `P   pP  
0 0 W00  V  
 塳	@  
 P
00  S@D=  T  
 * p It   P  
 囻0,@  S Pt 7
  'x	 7
 /x	 	 7
  .x	 @-0  S   
F  s@;x	   P@-@  
0 0    δ 0   P 0 0    P     Rp@- P@  
x Tt0 000#  T0   
T IH0    R  
   
  T  
00  R  ;  p  R p蟕	 [
 	 o	 p@-P @Ul    p@p@-P @>l    p@O-2"@   u 2  0a  V  
 al pP   Ỵ p# & P  Y  
   Q    @  [@  
  @ Z
 p  	     Z @  
P
  @P@0 0%  0e  P	   ߹   0Y0  S   ` P    Y  
0 S  

 S  
  Y   @`P0 V    
 媶0	  S@ @  
  n     

 r @
  bs [
 @x	 mx	 7
 {x	 sx	 yx	 x	 ( x	  x	 O-ppM@ dd P   0L t D2   `  0
00,20Pb  
     
  ok    ꅱ    
 gk    0 e00 0
  0
 0s   P  (0:	S0  
0  U pL  c0  S  
 H    P@)  
>     

 3 @װ Ձ  S  Y
@  
 m 
 k  @  *l  0P$  @   
0P0 P0@   P  
 p  p    p


  
   p   P TpP  U Ѝ[
 x	 x	 [
 x	 7
   <  x	 x	 x	 x	 x	  P@-    0- S   {  ұ@Cꄋ	 O-1|Mx 0"1@ P  7t 1 e  00 UpA  p$ Ḹ p1`  00	   2x   P P
  
 妸 @  _k  P Ű  @ Ṟ   P  
 弞   P  0:

S  
 唹      
t  ߷ @   P	    0 S  
 ္ ᛰ   ᗰ     
 d   [`0 03/  P  
 j ᄰ0  S
 |ЍJ	 ^ [
 0y	 7
 l[
 <	   l  @-0@M  S   
i
 @㉱  P
@  
 뮷@Ѝ  I7y	 : 	S  I   /  60 /@y	 : 	S  I  /0 ("> /@y	 P0 
  
: 	S/ /		  
	S  I * /0 (">" /  /9
 @y	 @- @P         0:	S   Q  
   0. S  0  S  
. S  0  S   
 !  R  Q ` p@-0 @ P2S  $ P  SX0X   
Sh0h   
S  `0` 0b  S
   0  :	S 00*	R 0c0c 0     K0  
0   `p9
 @-`lMp0 P
<0  R@@  T  
Ý   P  
 ᧸00 @  
   P  
 ᝸00  x 㦷 @Pp
h E lЍ9
  0P/  зp@- PP@   pm    0 :	S    R  
   
   0. S
  0  S	  
. S  0  S  
    R    \p@-   |0 ` 0  l0 P  0"  @P  \ S" S  \ Pۮ ٮ@0  S" Ӯ Ѝp[
 7
 G- @pM p ă 0
  
:

S     0   
'0 `   
%t0b 
 `0   
  N  L `0   
8$ `0   
 3 0@   
( M    ( G  @, >    `0    
2 0@   
(د  (, ӯ `    
 0:
S
S 00	   @d  `忯    
 kt  @嶯    00屯 ` "  
`0l l0X0l0h0l00 P  
 圯 `  l0@@c1M@ T
`0  
 0  S  

 0 0孜 @ Q P B  Xu  ! 0 `  S  
<m0
-  
 0:

S 00  Z 0  S$  
_  0
0倜   P   7  0  S	  
@ $ P    H
  0 @  S  
 @0
 `g0
  
  Y  
	 ٭` pЍ9
 y	 y	 y	 y	 [
 y	 y	 y	 y	 y	 y	 y	 y	 y	 B y	 y	  z	 8 	z	 O-!$M  0 0 p07  @P    ⯂ t1  0      \ S" S 0  S T@1P   Q!0   0000ו  P  p    ϕ     p Sp2 	@#   	
P 0  0`` V
  *  U  
@e` ` P0 @ P Z:
 X000 Y:$Ѝ9
 [
 '	 w	 0 㛬< O-  |  0"	
  
   R  
 0   吮0 ᧴ `P p0P0b  
#  0. S  0  S  
1. S  0  
0  
 5h  @ự      P   ᔭ  00Pp     P y @P ᩮ  U5  
  `  PP   U  W*  
  +0  
  @ 7  P  
    _  V P    0  S  
 V TP@  T N0  S9
 z	 E-3sM` 0&  00 N00k  ;  0PCLßP  @@C@ß@PE @ 0P `kp   @  01  
0600200~90050@ 0600002!R f  P  
] 0P  
 0  S  
x\  P  
0 0  
 0n S 0  
 Dg  P   
 
 
 
 
 
  C  P  
0 007002200220 6SC>01!0 S00@      P  |1 @` 0!  Rd10 0 P  S0900D!    r  3   P 0@0` @  X  V/  
 0 P@@0  T0  
  6       @ PV @  
  !  T  

 
 u 3 Ѝ#z	 9
 sy	 [
 z	 [
 |y	 Ȇ z	 /   `   @ 7
 ?	  @ A- 1CMM 0@r  P P<  s T  
P} pP`  1 T  
 pP`  2 T  
͊ pP `  5 T  
 pP@`   
 *7/
 *@ P@D P	  
 5/  9
  P?  X  
 ! Ѝڍd[
 l  x7 5 6 5 Ez	 O- @@o 1 P 0!  R10!    s   J  
xw㶰   P  
d屰 `  ,  .  D  P
   4ެ  P     
 咰 ǫ`   @ 00 q P	  
&  P   
   劬      儬`	 ᫫ ᩫ n  pP  X  
   
 t d  @ `  H PP`  
P   e Ꭻ0  S ]z	 7
 	 cz	 z	 
	 	 K}	 z	 z	 z	 {	 s@-0 P 0 0
 0n   @	  
0  0!~   P  p  80``\0 0!  R   U @ P   { 0  PP  S |{	 [
 {	   r	 7
 p@- @ T0 ` 0!  R   6 @ P    P    P0  S p7
 G- @  0  p@g T2  a0  只  P+  
 0 p S0  
 T#     @!       P  @{       {   0   T
     0A
    P    7
 ){	 4 $"$2G-  "2P @  M 'n 2  0@a d T	  
 h8  `PPi    P
@  
 P   
 Ye h @(  `P R    V  
p   Ǫ  P     P   	  
H1H     P;  c   P6  
    P1  1 0 0 S    
    P        V  
 V   P
  
     P    H     P   I     We   P    "   P      P
 P   
e0
 S Ѝ1{	 [
 H{	 [
 D	 7
 7
 S{	 l[
 u h{	 {	 '	 z{	 {	 A- `  p Ṫ@ P  T     k  0- S
   0 n S  0   Sp        ` V   & ! P@    I  P    dk P	 {	 p@-0 P  0  S   
  w  P  
  $  < n  P  
  -۪  P
  | ] P  
dd ` @-  @ "<D 岮 Q  P  
 㓫   'k D6
 _ {	 A   {	 A- Pf p `   v P 00  
 = @P  
 0  S  
  W   
 f  f l2x" 0c l2 pf    ꪬ 8"3  P0  S  $ f  $f  2    q  Qx  
  + R  
0` Sr  00B	 S  x Rm   00B	 S   0a0C Se      0x S	    00B	 S   0a0C S    0 S  0x S  
   @   @  00B	 S 0a0C SP  @   @ 000C	 S P Q7  
 0. S    U
   
0    U   
 P    R   0  S  
b S4;$  
B S  5 ; %   0  S  
   0 
   Upx   

 U  d 0  0   h {	 |	 |	 |	 |	 @ )|	 7
 p@-0P  S @@  

  @0 0 @  P @  h  P@   
   P j 7
 @- 
  @l 0 0 0  S  
 ᵭ  l[
 	}	 p@- 0 P@' S" S`    P40  @ 0 06/    P  
 ᙭ pl[
 	}	 O-M @D@ `ϩ* p 00@ S2@  0  @0Rg S  e SY  *X S;  
  E ST  
G SR  
n  c S  
d S  
i  s S2  
  i S
  
o S  u S'  
x S%  
]    hY  x!   P   0!  YA    W   0 VG  
    W   0 L=  
  @7      Y    W  0  
 
    W    00!  
 0   gA  Y    W   0   
    W   0   @
  
00Ѝ}	 l[
     ! O- M@ p  
   R  
 0- S  0- S  0  S   
   R 	  T3 0 0p S  
D֬    00 p   % P  
\ P  
  @@ % P  
b P   0  S  

  \ P  0 0 | 4  20000    Pp   R  P00 PP 0* S  00  P  P  
p   00P  000C	 S   0. S  0P* S  00  P  P  
p    
  00P  000C	 Sς    0l S
h Q
z Q
pA 	  P  \YpKA   0d S`@ P
   x  @0 l0`P   \  
 	 
0 p   	 
0 0   0 0  b  000c S  
 | 렮00C0   ꛮ000    PH W   0  S> W  :0  S     Ѝd[
 }	 B}	 Z}	 G}	 '	 l[
 @-@  ܱ p@-P   @(0  0 0  S  
   ʱ pl[
 @-@↦ 0 0  S  
0"  0     0 l[
 @-  㓍  @P   趨 @G0@- 0M@   Mt?j p0  P 0`0     

   긍   P   Ѝڍ0 (0(     zh TC	 [
 h}	 7
 L6
 v	 	 0p@-  S   ȩ@ ` ~  PP  
z Ŧ   奯`0@  S [h  0p@- @  i 0``0 ` 0 `!  P  
P @  ت 0. S  0  S  
. S  0  S  T ]@    D   P@0  S       @ pK{	 [
 n}	 7
 t}	  0A- @  i 0 p 0!1  R   iP0 `  @   P	     
 0' S  
\ /`
     
 ץ 0 @. S0  S0  S }	 [
 x	 7
 l[
  O-H2,M( `0" @ 0i ,2  P$2@e p T 0 0  
 T	  
 T,     1  !    ⏥   0  0 0 ↥1   0   00 0 d0  wh1  0 0  S   0    R   
	`p @. : Pq0Pd X1  S  
  W p1  W  
pW0 
@P0 `А  	 0` @ᮦ Ҏ !   0
   $ @P   0a   P  
  V     V   P 000  S  V  

 ,ЍX }	 7
 l[
   ?'	 }	 O-0M  S  
p  `.   P/  
 Ⴇ 0   P01   @    0   S  0 0  S   
~0@EL010P 0U u   0
 ᰎ   0 	 P 
   C c   0 	᳍  p  ^ 	   0   P  
 	 0܏   P  
	   00J   0 	ᐍ   P0y ߏ  00  P @  PT 0 S
 Ѝ}	 l[
 t   AeA@-    000C	 S  
 㭥  P   }	 @-0@ 0  S <  `9
 G-0P @ Sp  0  S	  0  S  0  S  `20  S  
 tL2    1  Z `  !    Y0	  
  	 R0  
    R   	0B  R S  	0B  R S      R`
0 V:  P  P      	0B  R S  W    L \   q	0B  R S0  S  
0C0 S  Q  
0A0 S࠱ࠡ ^nn   @     	0B  R S  00B	 S   0a0C S        R        0B^ S ė     R      a0B S 0B     R  9
 O-3DM  3  @    	  Rh3 0   ?   	   90  S  , . , |, L. 
 ᤦ @  
 <⢣ `p 8❣<0 @P Z8    X   X  
  0᪎   P    0ᣎ u    0ᝎ   Pq  
 0  X    0㓎   P*  
    0㑎   P  
 0  ҍ    0ゎ   PZ  
    0『   PQ  R   0      0p   PD  
    0}   P?  <   0  宍    0^   P#  
    0\   P+  .  @ D
   P0 @  U  
  P  
   T@`    
 Ấ ` pᶤ @P  0G   P    01   P    @   @    @  0 Z  

 ᕣ   0 X  
 Ꮳ 0t 03  Y 0  S.  T  (0 0          `DЍ[
 `9
 }	   ?~	 ßE- ß,M$     0 f  t# 01 0M  
0    R  
0  S  
D'  @3  A  0 ` Gr  @ 6  p 1  P 0. S(  0 0
1 !  , Q    T@00  
R ᝢ  P  0  e>=0  S  T  P0    R 000000   Q0 0  S0  S,2 p 0!  R20    L a P1 0@   
  e    e   P @  
   @ p` nd 0  S1 0  S  00XA 0P  
` `@P
   @f P  @1 <   ;  P U6  1  メ 0   
 0 0`@  I  P 0P1    妢`@ V  X|0 0	  
   è1T0 @ 0@ P
P  l  `@ T  &d   ,ЍD6
 ~	 [
 }	 [
  ~	 9
 1~	 }	 7
 	   `9
 7
 D~	 + A    x	 O-tt$M  0 P e   `/ 0  
   0  @Q@ӆ   0`!`  
 弆   0!1 		1  P
  
 1  R``h  pg  
 ԩ  1a	1 ᮢ0   P   Va @ ѡ pZ `  p  \* PP G  
  	80    Z  ($
 B㦩
 ᄢ @   0y S0 0   Q Ba00 a   R  
 ? W     V   @`V   
 E  P@  
   0`p@h  UPU
 $Ѝ[
 S~	 Y~	  7
 0	  `~	 <	 9
 p~	 A  @-p0p  P@P"  Xe T0T   L0app@  7/ @ P  P t  3[
 ^ ~	 7
 8 8 p@- P@ 0 @0pO-k  
p &   % `P   7    iP  @ 000h0 p    Q  
% Q  
  p% 㰨    	0;/  W
 ` ЍO\~	 7
 0@-\M@
 PX  P  
P        T  808  0 00@@   
0 \Ѝ0~	 [
 ~	 V	 9 p@-` hM 0@
 0 P03/  P  
p       T   0 P@  0H :
S
S<0@@ , 
0y hЍp[
 u hu  u	 	 r	 d; p@-Ps @a p@ҡn Qp@-@` P'  
i T  `吢4  00  I  l T  <冢 8H  t T  $  A  T T     
   S  
 01  S0 1p@b T  f  "  f T  _!   a T  X!   S Ts T  dP   c T  TI"   d T  8B" p@uc p@o-	 7	 	 ć  @-0 # ᝟@ 0  C 9
    1	 n QA-@p` P5  
N T  s0:

S
   C  @P  
 8B Aj   d T  
D T      i T  &   a T   !  A T   hr   A>f T  ߡ   F T   0	Q  4 00 d"d2	QT

QL

QD

Q<


Q4
0"02	Qh T  嵡 q  u T  审 j  U T  E 姠  g T  塡 ]  G T  * 凡  P t T  `呡  T T  D务`  D  s T  偡#   B T  ,z 6  b T  s$ A覠o T  k 8'  x TH   
X T   ` H  y TP 
  
Y T   U P  z T  X eZ T  p H X   c AuM	  -	 m	 	 	 Z	 .s	 m	 	 	 	 	 z	 7	 I 	  P0   0ӗ /ᴆ	 p@- P`  @ P	  
 0    V0 00 0 0p# U  
0 U  0  V3>>a  
  0 U  0  V3>2>X  
>00U  0 U
      V-,0,0,0 p 0 U  00j00p(0 U'   " 00   0" P  `"P0   
   000	     
   000 0`VpP0 U  0  V00r  @0 U  0   V>  >  >00  0pH0 U  	   V >>> 00    L  ! U  
1 U"  1 U 00  V 0  S  d1 U  V 
   0 R>0   0p0 0 00 0#  00 U     V;; 0p80 U     V;;0p@0 U  
H0 U
   0   V0 0  0 p 0 U  0>0p(0 U   0 ; 000|0.000 p 	 < 4  @- 	Y   P0  	   @- X   P0   ׄ	 	  @- X    
0@ S  2	 0A- P pP  
0 P  
 @  T  
`  V  
 h  P  
 X廠  P  
^ T  ? V!@@     (0: @     @00@ֆ	 c	 f	  0 9
  -p@-M0  k`@~ V P   @   R  
0
 S
  
 0 S  :
 _ 00    Z@0  坠 0 S0
 R00 00Ѝp@Ѝ/9
 7
 @- @  
 ȣ  P
  
@0 0 0 S4     T  (    0  T   l[
 x	 z	 l	 s	 00  S/ 9
 X @- @ `p h
  @@2 P
P  
L0 0 0 S  @ @  V`͡    W$
 p͡   P  
 T  l[
 T  	 A- Pp @PPP`  
 ~  T8P8P ``  W 	PA}  @ >}    Acꣂ	 	 p@-(M P$ 0 @ P  $  `  0 @ P P  $0 P   0P  U0$0`@ 0 s  3     (Ѝp舅	 	 p@- P `A }  U @  
 ɟ  U  
 p@诞p0 69
  5 %O- 0P004M P
~   0pa- S5     P,  
0 m  
o  a R  
g R  
F R	  
e  $0P   p$P      Z`f  0   RX    V 0!  00  000   SG       RB   w  P=   ~  P
  
  V  ˡD P/   z   
  V
 P  ʂ P  0@ S     P  
 P	  

   !P3π        D k   D5 P  
 ᪀ ||  p  P		A  T|0 S  勡     S  Z  
2
   F  㺢D@ <  M  ڜ  Py  0_  
  ` f   2/   0`- S      P  K     P  
 D <    pP  
D 3     P  ʃ P   P  
 P  
 P  
   P  
 P  
  p :       Z  L 1  {  D       D 
  D`  P  P    P
A  T &  
Dp   @P	  `<  ӛ `  P  
    < 2  P
  
0 280   < &  P  
@   Ѝ 9
 M M 	  	  ą	 څ	 	 9
 	 N	 7@- @ 8  ̜P @@  Ɯ  TP
 Ѝ0@1z	 	 G- .  Y  
  @ T+  
*V 1000  ^!  
 ^1M N Å- t
 Å ^  0^  @    ~ ^?0 0̅0 ̕ 0̅ ! 0 0 y@ T r 0p @P )  ` V   
 
	0    S   0 0  S	    Y     
 U  x     Y  
     0 S  H U  D @0pU WGׄ	 	 	 9
 9
 	 	  	 Z	 Y	 O- ~  p P     `  Q   <q *L @P    U  
 e  P0    00#  T @@  T   " 6   Z  0q`0 Q   7  8  #8 h P&h  Z  
 Z  8l@#8&8@ P	P$!C+4@ 	  <<@ P8 @	P$%+%5 ܛ 9
   چ	 '	   	 p@- @D^ 0x0    1  S  \  @    Q 00 P  R0`@  z0 @  S t  3p	 7
 	 @-阙  G- 000   S81  0        P Pp  }  P-  
  0@   0	 m p `
  
    ⏢ P0
 V`@  
 0T0 v 0  S  
 ဢ P @  @i  vd0 0 0  S S  
 opG X       000  Q
 	 l[
  0- S   
+ S0    G~ 9
   @-    P   vn p@-pM`P @Z   P  <0  S    80  S  
 0    喛<0 S    80  S  *     0 娡  G @P   0    pЍpT 9
 O- IM0  R1 pP  
 0- S+ S  000C	 S   pG `  P
`hƟh d F/GύE? W]  (   
 `(    
 `(6  @   6       0pd0  0  0ߡ A<@  P     P  0:
S(  ( 5<  0 $P@<  |   P  (0@ \0 0  
<$ 0< 1 $ P U@$  Q  卞   R  (0   

Y3   	 ឡ$ 0 S0! 8, 8   404    R0   $   P  <04 , #l,   Q,  0    0 Κ  Q  #    P!  
(    
  V  
@ P  0 R0  S   00   ֠0  0x  ! P0  S    00  Ơ P
p\  0  S  
 W  !  *(00f      0 B
 S  p W  
  RD    RpA  p b 㶠;    V9  
(  
  
  PP P0   f
  ɚ*   @ 0TN@D
 S  ^ [ P   00S

@S@0f   0
 SL  \00Pa
  ᦚd: Y  *
  0 	 e  P0  S    
l8 4 $   P8 4 F:
 Ơ(0  [  
 ps 
( < @ `@1  
  T   @̆   PL   Æ   PG   @0 SC   D0 S?  !0 S;  !0 S7      㐙 PP  0  T   q    T   t0@P  T  $  0 Pp	    W  
 '  	
 p 	*' PP$  Z:$0  Iߍ ᖙ	 [
 	 7
 9
  		   /x	 .x	 	  	 )	 N	 O-@ `\ [ T1    PH1   
 ㍗
 ㊗ e  1  p 0 
@ ` 0P  0 00 0- S  0  S  
b{   P @  
0`0P  Y    P  @ 0|  J0  S  \\  PPP0
@0
D0 0 0  p0@  S Y K	 7
 i	 7
 9
     7
 D0@- @<0  P0
  
 , R   P  ' 0 00[
 m	 o	 J	   P   
 0  S  
 $ 屜   孜0   ͘  [
 p0@- @ 0 0
  Pᡗ 0 `p  S <    P  
Mw  0  S  
  Ѝl[
 	 E	 t2@- @M  0` 0     P  U   4 @0D S6    ` @ 0 S    V 0x   T 00t   S    V 0=   T:   S   Q 0h  5   P   S   T 0.  _    V
    S   T 0X  %    VU  "   Q 0  P   PN    0D S   ҙ T  0 00@   T  0 00:   T?7  
  Q 0  3   P1  
0/   hH   P)   
C   P$   0 S  P 0 S 00   S  P 0 S 00    h0 S   l0 S  ` 0 S  d 0 S   
 0 0    0 Ѝ[
 	 A-" PM P  ,4   0 0   P  
 ` p  ` p    P  
% P3   @  0 0     `p0 0 & P  
   @H    P  
 00  S  
00 S  
0  S   0 0  R  
 U 0   3 0 0 0 00s 03   U2 0 0  

 U2   0 0  '   @ Uh 0 `   Ḅ   P

e  
   ᪄   P   U  
 0B SH   Up  
 Upp
 P ᗄ   P6    U   W3  0I 0  0 S'  
`  V"  
m  V  
0  S  
1       001 @P [   ᰘ P 01 V  
  R   ꇁ0    0    0 F  0B S   U	  
 U
  
 U
  
	 U
  

 U		x0:  S   .  0B S
   U  
 Ux0        U  0    S    0  S  
   U  @   U  @  T            00 S  Z `   0 0 0 0S0` p Ѝ[
 	 
	 p@-t0 @P `  0 0   # P0B 0
  0 0    
0 000#  @_ p[
 p@-p0 @P `  0 0   $ P0B 0  0 0    0    @_ p[
 7@- @  ݙ 0[ S  0@D  S	  ! 0] S  0  S  
      P  
 m@,   01fȝ0        @P  0   S@  
 0  l0 P 0     @@ 0  S  
0 0  Q  
( B@0  v >!	 3	 +	 [
 6	 A- @X 0`  0!  R   \x0 @ P p   プ  P  
 0 S	    V
    B< .  P      -P0  S 蚈	 7
 l[
   A- PM p@`  ᖗ  P,0 @P aCT 
 ῕ ܍G-  ` P  <
 S   
 `     \ Q     i    0- S     P0      0BP0  S 000  [ Q   0  : S  0x S @ \gO  p @  T  
0 G
 T 0
 T R0   0000: S
P0D S  T S   A000[ SP T00  S  
 a000{ SP0D S  	0 T0  00 000 00 0 00P0D S     T   0B^ S  '0A	 S0   0a0C S   Q Q    	 T  0 S S   P 0R  ^#  
 A  0G Q0 P  = S  00  0  S  
0= S  0] S   
X0  00C00  0P0 0  S0 蟈	 E-
@: 
7  m 0 `00S!1   W 1 p 0Q  @  
   @   P  
 0  S  H
  " 00   Pч0  S:   0 00 \    0 00  \L   P    R  
  s  * P    
 Ӝ    0     
0  S   
 T  0  S0  S 0@ ^ [
 	 7
 	 T   /H0 p@-   8W  @  (0  P PP   T   j UU D6
 	 	 p@-0 @   MV 0 ` 01  S   
P`  P  V`@@D FcWs SlPh@h  	  
0T  B   Q  
U< `@
  U [
 #	 	 7
 '	 `	 	  A	 @	 G-M@  P 0 P PV 1  0A Z  
 0- S  0 S  
  g
     P  
0  S   
= 0- S  0  S  
((!eӚ P  P@ `  @   r r @D  T 0@  S Q 00  S   U
  $  P	   `0  U  pP  U  
  V00	      
L ֓ Ე   W(0
  P  T [
 	 	 7
 A    7
 ɉ	 @-   P   v ˒  P   
f A- 0 0"DD1@  8!V 41 0!  R$10   v  :  
 ֔  P
@ q
  
  Δ  P@p  
 Ồ(     H0 `  S
    "  P   
 0  S  
00 0   @- R  0  S  
u  @o ᖒ 7/   }U  PP( ^\	 [
 x	 7
 	 ω	 t ݉	 xs 7
 	 A- p;    P=  
@    0C?00B`0  S   cz 0e  S*    P"  < P &  0  P#21 0  
0  P#1200  
 0 @  P30 e 0b @ ,U  PP 
2Q	 	 	 E- P @'  
  p   `  ᙑ  P
 0= S	    U  0 TPC    P  
 S   U!  
P  0  f C@ P   @ T ` &} Tp'v T
  @o	 	 @-XM@:L!L1L p   ,U <1  P8! 41` `P  P !0 p  	  
 
 p 0++ 0  V  唒P - ƚ @P  
   圚0n  s 
 t0 V   t0   jy n ! 4 H H0  V  l 5S   Z	 [
 2G	 7
 	 k	 '	 	 	 T 7
 	 	 O- TM@T 2  P  0 !  Rt2tt" 0)0  S`2 0  T"0A D2       0x   t  pP  p  
 P0   `    ` $   0 $᱐ p @   d  P  
 !00  $   0$   0@^ S    PP`  	0@ S	 P0P  
L   R  H0 SL 5HP5
 T   #   0#   T   
 P# ? t#,0D S  :  (0 S   *B"  R0"R    p`0  
  ɑt 0 @p  W ` 廑   X Z0  |R $	 7
  ^k	 X *	  )	 4	 @-0  S   
ȓ뿏J ~@p@-P0P00  SP@80   K0  S  
  1
 . pd 	 7
 p@- P@2/  P  @0 0 0 S    p( q  p0:	S  pl[
    hu @-D0  @@"8
 0S    
  d  P  
 Ґ   5	 7@- @ݏ  P   
 0  S  000   S 0 P 0A  T   ; @ /я  P  
   
 J  @   
 ג  P  
   x  P         >0	 7	 [
 \	 <	 7
 B	 @-PQM `0  S  
h@  4 ᮒ  Y  PB    0 0 吒  P:  0  S!  
h@  ᘒ  C  P,   pp (ㄏ  P%  
@ )Ï  P  
 p ၐ P   k P  0  S
  
h@T  s 
}   P   0 S   ݗ 0  H Ѝ9
 M	 ^	 l	 G-ßs0M   ,  $@P`( 0P`S    
, o   P     @ 0(00  S(00   P  
10 0壗  $3  P   
 
 ;3  0 0  S  
 I  0  S  
 r  @P	  
   P    S $  2 0 0 S    `j Pt2  @ 0 0l   Q  P  
 
  0 `  S1 ᐐ  V(  
 M  
P  U  P  U    Q    Q  
取 P  ( @  T  1 0     *   1 0`    W  P    `|
 @  T`1 010#  X 00  S  
D @    Q  
, @  Tѐ  X   .      R  
0 0 &    !  (0
! 0@B  
 q     
 c 
  
 0 $00v   p   
  p   
( 導` (ӗ 0Ѝ[
 u	 9
 	 7
 l[
 	 	 )	 	 ؊	 	 
	 [
 (	 B	 ^	 	 C	 n	 q	 0 A- 0 PR 0  @, P   序묀a p @/ 0  P  
 P   P  
  h   ዖ ! @  P  P ᪎  U  
 Y ᤎ   p0  S =P ^ [
 q	 7
 @	  
     30b   \ /  \ R	  0
 S  (0  000    R	 R/  h[
   0   R 0 /0  00/h[
       P  
 0<S0 0 / 0 0/@- ざ=0 @ 0|  @- @   @ 0
   0 0  @- @ f0 @ 0000h[
 A-  P  0 0b 1ᓂ" 0 R	  0P 00 ` pF  Q  0 0  0 # 0   000h0  0 00 R:@ X@@@0  ,`  @    U00 0P 00ꫪh[
 @- @P  
 0 Q  P  @̕@- 0 @
    0   )   l  0A- P p(` P  0@(0$ 孕$   $ ;`0$0  0 \0  (0 VH0 `,0倀F W0@    \ @ PT0 T,ph[
 A- p `  0Q   @嘍 ᖍP  U0`P0 V: 00 0  /0p@- 0 `T@    P  <   `0 PT4 0 S  
  @4 G (0
  T0@ `TP$   ph[
 p@-!< P @ 0@   t   p@t p@- 0@ P<!S`    4  Ὅ P 0Օ 0     p   墌@-0   @0  S     0  Q   
 0  S  
  0   
   0  S  
 0< 0 0< 0   @- @ 0 9#  B  @- @  P  
    0w  p  3   P  
 0  S p@-   0 @Pw   P  
 w p! w   `pp@- @ `PCt A   =  P   p@  T pG- ` PP>      t 
 P"   Q  
 0Ⳡp
ݔ   0Q   @
t 10QP  Up0 W: 坌	  @! 	 P U	 t 0@100Q000  A- P `@kt q   ߎ  P
     0    0C 0 0  0Aep @  Tp@- @ P \ R @  a \ P     0 S  0 p@-LMp @P `l 0< 0 `p弌 P  ,   R  
040 Q  v>A B0C , 00ԋ     LЍ請	 k    0  0 4h[
 	 G-b(0 P  S  
 v  @u   0 v   P 
0     @  T  
0  Sh p  P  
 v 
 0  G0 b  P  
 
 bG S	 ʋ	 ы	 		 @-tP 0M pP U  \0 ` @  P @@ 夓 0 < 00   S Ѝ  h[
 '	 O- 0M @d  
1 pT  P5  |Sv     & @`   $ 
    T P  
  .P`   @  #0 Y  T 000 @8 0  00)  80 P 00$  
0 P  I  (0 P  ^  X0 P  `    -v $0<  0c1 TP  Q  [t   0 a  Ѝh[
 p@- @Pc P p  Q@- @  
 0  S  
       @@- 0< 0s@-   `00B	 S   0a0C S  _ R   =㔊  P         P 00P@    D0 @ 0  S 0$0 0D :  |h[
 p@-@` P !  )p@@- @`p 0 `0 0' Ѐ@- @  0.s   0 @  ?O-DM   妉    $ 0  P<02 0x1 000  < $  @@  YG  $ t2 `  x1<!S  0   S ,0 9  P2  0,0  S  .   0  S      
P  	  P   	 d   P  
 0fl  0000
 S
    P 0f     
 R
  RU    		0  S  $  
   0< $ k $ `<  	 B iS	p	 W  0 p 0  Rs 0   H V 0	 W	@0  WK  
0 P
@
P  
 0< 0\0
@@ 0P, @0 h <00$0 0 DЍ	ph[
 W l[
  Pp@-@ P  
)       \     
 ݑ  B pA- M@ Pt      嵊d2    @  (  0  S
00 0<!S9      P `  
` ً1 @ p 0 0   S  0 \  P
    R  0`  S0  0p  @0  S00  J  000p W 400  SK     P `  
  0`      Q:    P `4  
0  S
  
a0@  S 0@ A0B S 0   0 0 `S`   0   0` ҋ  P   h  0  S  
 P  0P 0    R  
	0B  R S0  ` 0 0  S  Ѝh[
 0A- @P  U*  00` L s8 fI` E l`0p`0   P p$@@ $ 0R<0` W,@ @T DT 0 0, +r T0 h[
   1A- @x   P   
v0  x    <  @@ P   `p0 Xq  0s   P  
t0  S  
  0P `  <  @D ' PP
 0  S
  P 8l  `  V
0t00 @0  x`h[
   ?7
 	 84G-     Q 00  p0  S  
d0h p   @ 73 @  000 0# S  
  @ 0
 S  S 0
 S3  000   XT  
" X  |3  @ 0 	    0@
 S  S  
 8 D  0" S 0 0R@   '  
/ X%  3P` 0P  
 S  S    @\ S0P   P $]    0\ S0  R 00P` 0/ S 0@ 0Pk  00H. X	 SpbPl2   @ "L2 0C@ 0. S  
RX   W`P"  
(20   
 0 S    P  P  10  S	  
 00B	 S   0a0C S  _ R  
! 0@   0  ` p  W 0  S+    00B	 S   0a0C S  _ RR  L1D 0 @00B	 S   0a0C S  _ R   D4	S 0 0  
 w @ 0( SS  
[ ST@S0   l@    R  
	*00  S  
00  S  

	  
t0  0p0 0dPh 0]L0 0P@0 0  l   P (0  H   P     , h[
 	 	 ̋       2!> #  ݎ	 G-,M  4 0 @    Z  
2 0  2 R  c肟 `   =21  
 P     P 0~4 \ 0 R  P
<%S4 0h2@   A0
 ` 0  
P 0<
S(	   0(4 0  P`r   `  &1 P 0  S@ `
Pāf  
؁W  

   WB  
   WN  
Y  WU  
WO  
T  W?  
  W  
N  W  
W  
I  '< 0L1 @@ Z  P; 000  D g 6  
 0`
8 0n /  '< 0 M 0  
 0`
P(C("   0`
P  @ @:     < 08 ; 	   G `@   T `     `
P@ 	P p@
 Ѝ%>h[
 ' %!>> >>@- 
 @#@-U @
0  00
  
@bh[
 A-	
2 @  	  0	  Rl
P\b`   V  
GL  82 p  < 	S  
  Sa  
Sw  
S]  
}  1S#  
  
S  
w  2S*  
3S  
r   @ T0 P00PW  T000 @   @ P   0 @0  D0 @   
 0<S  
 <0  0     000   @	 @     T@%  < 0 @ |0   0   
   0
0 0~ H0 00
  
AP0  L00AG%>h[
 %>%>    %>@  ݎ	       d1p@-  00 N  	L  @1 @ D0T00  U  
 0T0>  %  
(08 00. @ PPP  0 0@ $ 0 0        0 @T0@ 8  x00   S  
g
M P\  0
  
]  Ah00  U  Pph[
     %>  %?x0A- @ `l PpL) PlL iP @ P`L  0 0T0P 000PpLh[
     0p@- 0 `  0 P  :0 P P1  : ^  00 S   00 | z 0 0 0    @q   P PH0 0  0 U:`     $0   0  Q  
 0 R
ph[
 	    M p
 0    Q  00` 
  \0 P 0`C
  0A      P  
0  S   
Ą@  TPD 0 U: ᙇh[
 O- PLM       </0 @  00 pD   
,   
  4   
, $(   
4 0   
,  <0#40C' Su X ܸ        <    L X  , L      T p       \  خ ,   \ p h L 0 D  0<S     k   PA  
 06 0D0 c   P 06 0=  ]   ,   P0  
6  4 \, p ` 0+,;P 0 P Ɍ, 0 @ (  0  0Q    U P  U`0 V:` ,0   0 R  :@倄,@T   , 0M 0  S< `  
<0 0<  0 @  S  | W
  0 \  P    LD00  <<w W,0 #   ` R<  D0K  S @0D8@<0*   08 bІ'  D  0 p   
8<  hPR @ 0   0
<0h    DᲆD0  S  
8  <᪆D0  S(; 0$ 3ᡆ  D ?  @ᛆ  ` D  0<'SP
  
S  : 0 0!%  
z  0  S  
, 
D0  @ e  @ P*0  40 	 , ,*0  0*0  0	  
 nn v9  0, T0 R  l  9 0 0!!,0  S, 
, e0-  4 `(  P   0  9~ d9D 08 (   0D0@9D  @@   (0 ` $ V P   g! W     U  Z , 4l Z 0 0<S  
R, r  P 	  G 0  S  0  S
  ` 0 p P  D 3 @ C 0@!: 0<8P` 0 R  *D0  S7 @`p04P   R   	   R  	    74P @ ` D0|G  S  
 0(< \ 0 @  S  0
S  ( hʄ0  0  ( 6f      @H0  S  H  7 0H@ 0  S
  7 0  	l 0   H 
	   6 0   S6 080404 PP  D0  S  x6 @L P    W񟗓  $ 4 L \ l |     ( T  
 tm }  궄k 4&46l 4  
 @0  
 ᚂ,  
 v(  
 ᜄ$  
 ᣂ   5D  `  PP  

 gm     @ k @ ᦁU    ׃M  D0  S  <5 08 ( ( k E  ۉ(  Q>  
 0  S;  
 @5  D0  S4    
(   R
  
 0  S  
4 0<   ΂'  꽉%  4( `<  @PP  
0  S  
      忁 P a< (  U  
`4 0  \k   0H b Vk    0!	 !" 	  D t \  4 P W   
  - W PA,  
M W  
! W!  
  m W  
p W  
P@     3zj     |3 P@tj 
    d3oj  P@    L3 P@gj   04 "  4 
  PC P@ P 0  4 l B PP 08  
 @,0 U   #0$ 0C  0S  2 04 
  (00 	   ,   P     
  ,   P  <   }   4 %0G @P
 SD     ` ` `  x `  `  
  0j 1  
  0+  
  0j &     05l   P  
  0{k   
  0     0$l   P  
l 0
 hk 3l j  0j   0
 i  , 
 
Q	 0, l  P  
4 h  P  
, > @4 P:  0 i   ,  @4 X0 00  S  
  ـ    Ã\j 0 S  
 S  
  S      0k   h[
 7
 5	 ׋	 q	 	   ?	 	 П	 l[
     A'	 ݋	 	 h[
    0k      0k   P $ $    R  /j   0	 50S
Q  *p0 00  S    X 	 LЍA- 0 @P<!S㄀   00  SPP    p  0 `0   S@@ P  P  
  0h  X h[
 O-Mt@   T<2  ` 0P8@ `  R \  (0 
@$0 0  `   
 Y0  S6    0j@,  \ R  @&  
& R  
0  S/ R  9 R  & R0 pD 000B @   Qt0p@  @c0t  ` '@      0	   R 0
 R  
  Z   00 0  S  
@P 
 $0  pP
@    r ` '0  S40 0800  t0 R   / Ѝh[
 G-xM  0    P\ X  p`@   `0	   

P0   
P0 M@0 `P@p0 U     S    R(U  *@ T= \    8    @ @      ̾     P  @T P  0 v  U  h  0<!S
  
0h4   T4 0I p @ TP `pp @:  p d   @ T    @` H @T   3h hj  P  U_  X    eh ]j   േ6  P  @T     P     P  @T    P  @T    P  @T 4   P  @T   h   @ e     a0B S   T    \ 
 ,  Dp @` P  e  X  U  d2 00  S   v  P0 f  
   @  ᄀ  P z  
 P @  u   U  T i t   t ₀1  Ut  `A@@PR~  0   0 01
  0[  @ S  d  @ 00@ ` @开 P40 00 04041 0  P0@,D Q @0 h   0 #D G00 @4   ch   0 0 h   0
 0 V$   }!  X `PD@i    \0   X  0D`  P  XD`   0 Pg   0
 	 C
 xЍ輌	 h[
   ?	 	 	 O-4M0@ $   ^뜆    
pX  P 0  S
  
% S0% S
  * R  dP    R  
 0a0C S0h0, 
 0 @ $   TP 00 0 0-h  Tc T `   }  P  
 SAi          s T   @~,  
      ;   K0   W p 0 @  TP  _~ 
 >@4Ѝ	 0@- %@Hh[
 O-4<M P$04 % 0,P(Pkh4  @  009l0  &h < @ D `H !   @$ DP  XA  0 P 0 S  
         0!$0 0* S   0; 0$00$0`$0C P  U @ A( ?`< 0X3X 0 0< *H3H 0 0< $83 0 003   X`     =V} pP  
@ 002 0\ 
=0 0`P  U2B P8 2     @(,0 
 04 A 2   @  
 4l  , L }  P+  
,0  S(0pd  S!  
( L 1P @ 04 `  ` } @! 0  P P 00 | p }(0  Sp	    W   zd!1  40_   
0<41  @ Psf   0@ yD L!  D @d!  Rx 1l0  S  `   P.  
H0  S&  0H #   00L  0  Y   00P aL _l 0  S  \0 @H 8`  P  
0 0  |
$0 0H 0  H   P"	 ڌ	 h[
 )	 7
 4	 7
 @	 7
 7
  L	 0 [
 S	 7
   \	 f	 	 l[
 O-M  + P  
}  P  
B" 0    S40    l2  / @ `P  T  H} PP(  
 } pP   } @ Մ `  }  0~@  @ Ḅ `! 0~  P @ pp "| V  1 O[  x1P  @0P咄4     Z|0P04  	2  $1U @0T0  
 ̈́T  &  $  
08 00 @ PPP  0 0@  0 0       t 0 @T0@ x P  X  
    P  

A 
  h|0 040 Ѝd9
 h[
 ia	 П	   7
 	     %x?1 O-  !1@,M  1  00? 1$  0A _  l1   R   _   Y     ,Ѝ$08! `00,1 p    	 { @ { ` 0p  T P!  
 p @  
 t  	 k0 00 00T$0   0    S0 P`?}$0  S    
 T
    t   	 G D = D6
 	 [
 7
 	 7
 	 Ə	 	 	 7
  0  R   0 c /  P  
/ P/@0 0#300  S ( /  0 0/   |[
 	  	 p@- 0`@   @ 0/ S
4  b  P  @僃0  00p  p@-hM P @`à,  S   \  
       0   R  
P0 0  6 
 Pi  @ {  T  0:	S  
     hЍp[
 h[
 @- Q  0 S  
    0 0|A- pl4    | p  
  
	0@@ 0  P S S 00    ;`0
 R k   
A0B S  
  
  \     

  
  \  j  (0  \ ?0 `  
 [
    O-\M    gH0  P @@ p `  0  `{@`dP9  
  `;;0c sc 
0 S00  0H@P ۂ H0@0!2 0 2   
      0 0 l2   P P    Q     p`0L0  ἂ     2   00 \ XHL 0  
$0  $  $ $0 S  0$  R   p   0  R
p$ 0` W   0` W  $ @R  0g2 0A S
H0$  0 ` @0g P0 0  20 S @ 5<y TP@DPT   2 0 S 0305  :     2 P ^0    00 0  P02      2 B 0c 1a   0 0 0` R@
    P 0 1
 
      01  \    000  Qz 0Q         B  
  $   R0  0g R 00  1  0 R@    @ a   0 P0D P:3 0  0  P30 Kd  p , < P i  <  1  Sa  
   !01 `b!(804 {#0 VD  4   0s#0 S@    0@ T	  !0s#0 S   @0 T0d  T  !0s#0 S  , Z
  0
 
a , ,0 g p0
 T0@<00(  (   P  @8 `  V  ( 008 R1:<  < <  Q!  $  0 0  ! 0r!   R Oy My   0 1Fy Dy`>    1Q  S8  
 @0f 0     1 
 0c   !   @p  @
 0  p    ;;  S  
 0 00
`  0 V   P U
` 0 V  \Ѝ  [
 O-@b' `(傁:    w	 ex0 0  
	 _x P@    y p    ЍOz     0	 \ 	  x0 0  
@  Dx    ?x@P   P ? Q   Pp ZЍ[
 	 O-5lM   5 pd  `   [  p @W 
    0 y p   q   0 S  H`h  %y w PP  Lp y   Q    T    Z} y@ zy`0 p W `P*`0pz @*d0jz  T  
  T @P  T  
    40  Q  
: 0  S   `x40  SP R  U  
  V  
L4 0 @ 
 00`0 X0d0H (0     8X  0808  P   `0 !00 R
 `0 @0X< 0@0   <<  R  1  S
01 P CD   @0 S;  P3 x 0   
0  0 P  00@  R3   Pp80 A  H0 `   P P   Q   
`0@00 \P Up
  ^   8ax< X0 [D01ב xk  
82 0  
   Rd  
@ `  0  S
  2 @  Q  x  Q0}x{x1 ` 0p0 08  Pa UPPX01  V@+- T@ T  t@]x U  
0 eXVx` VpD.y8 <p
@ T ``  V 0P00C H  o  V  -0 0  Hg+0 0 0 L`0@ 00X0 [
 QwH OwL Mw	 Kw   R   @` 8 d 8  lЍ@00   00 07
 l[
 b	 <	 П	 9
 I
 [
 h[
   D	 L	 _	 T	 Z	 ^	 O-TM 0P@0$ L0pJ5 P  ş E00 @xşxEL0  @l PY: d5    PH @F  @T@@Q H0  S$%0 ` 0@  0- S  
} p  0  S d p D  0- S  0  S   d p  }4   W  	  
(0:	S  
0:	S  h{(0 :	S  :	S   @    LfvP@p `3 @@ 0  .w    #3 O  0   X  
  00@0 T  0y  PpG80 W`P\3 0  P0 P Q 0 Q$0 @A  U    T  
    T   
 x   X8P<@ pp  
3 0    P0!@0 <wa   P8`@ U  X@ 0(
  80 0 h0㓵!  Nd    0 2 0P U@`F  X  
 gh0㓲!P 1  8d (0*	R  0:	S  04 w'  	R	R0  0:	S	S  
4v  	R   	S00"  S  
  R 040 040  v  ( Y010 v4 vP 1  vP0"D0  X0D0gP @g1 uP0"D00D0\:	S   0:	S PP  
P 0%1@/ uP 10  P    j0 h0e!P 1 p| W    
@ @  X  
P 1 u0 0  TЍh[
 [
 q	 [
 H	 z	 7
 D6
 	   [
 	 _ Ð	 	 .s	 	 !	      0	 S  S
/ P@-  ڤ0 0 Q  ڔ ^z   0  S0 0p0   @    Q  
? Q      0? Q $       R    B Rh[
 E	 @- @  P0    0  @ h[
   P@-  ,0 00 P Q      z h[
 c	 A- `PP  ڬ0 p00 V  ژ z!   2} @  uP0 V       P   1u  0	 40 @  @ 0 0 00A  h[
 y	 O- Q   (2 P00 Y  y   u P   t  y  0 @@0uH|p1
 `@P  Vw  P  
 0dP	   @P   v X   0 0e0 )     T  
 mu0 001 P 0 S  0 O@|0 @  0  @0  b}0  p 0 0  W  
 ut up0 @   R  
	 Q  P   u    0 u, ,   \  
0 du h[
 	 	 '	 	 	 A-  @P pP0    `P,  
0   0 S
   S  0 U    T p   D0d l0   0 S0` 0T0 P  00`0   @0 PE0 @Vt`  U 0  00Ӓ	 h[
 @-MM @A 0\ \ d?   P  0. S  0
 S  	0  S  
  A   P@Ѝۍ  '	 G-   @cpP     ~v `P  
0f@ T  
 's  P  0 cP@D T  A-P @    P&   0   S   @  T @   xP    T  
t ht p I  P `	  
     0  P   `P U x P ڒ	 9
 	 	 G- ` M  @p   @  $0B S<   l l  l l l l l l   `1@ 0  =  L1@ 0 8    a0B S  (kx  D  1@ 01P!)  P
 Zt/
 s  P 0   
@0d@0
 @ 0 }  P   &  00B	 S @       @  `  
0"@ 00C0	 S  W  b ` 0+ S  
- S   p  p0   0  `ۍh[
 	 '	 G-  @  P,     Pp `"  %    Y    Ms     R  00
 S BP @    @G PE  U8 0 u  `p
 W    	 7
 &	 O-MMBN@@D	+ 04>   Po 0@ B>00C P    0p	 S  S
B @  @ @V94$H (H 0 S  0 S  0 0 ŃN@ .  P
4=4 0, S  .0  48  P
(8  S008$8  S8 00,80$8(8(84(  S8@ 0 008$8  S08,80k S4HN  
  c S'  
  = S 
  - S 
. S 
  S 
 a S  
 f S!  
i S  
d S  
 r Sq  
  p SG  
J  l S@  
 w Sd 
z S 
s S  
 0   0,0=n0,j0  S  
	 S  S  4 0pG  S   0  Q` \#tT @ lr[   4  a0B S  0  S  
 7 01,(P!>0,  0,    (84  S      P  
 6 000  S 
B 0A \=   P B  @4 0 0y S 
0  S  
	 S  SH  }4 0  S0} 
(84  S5 00080  P5 @0  S4y ,0%    P(  @r$@	 T  T  
  T  S (  @eq  PxL 
 PP ]q   PPT	 	  g S  
p S  
49 00 0  S%0  S   0  S  * 
  (@@D  T  
r@ " PP
 :r  7r   @p `   
0   `P
    T  
   P P @g  4 p 0  R0 000"     *r   R  
0     f c r0  00   R6    Y  
    P7   0  ay0 @  00 q   q0 
  f c q  0  0 @ 0@ 0 S@ Kq   R  
P	@    Y  
   P @p0 X  Wu0  S  
	 S  S   (84  S  0082 00,848 0  S1 00484  X(q  
0,"
 	 PP r pP   qKx
 ` @P`P      y0 P  
 p r @ `P
0	 S r  P   p dq0- S  
. S@  
  0   0    @*   0    
 @$   0      ((  R   0 0    |0 @   @  0 q(8  S  ,  D0 @   9  P
     Lx iu<Ѝۍ	 h[
 )	  :	 	 G	 X	 f	 w	 ٓ	 	 	 '	 Ɠ	 9
 	 	 	 	    	 -	 A	 P	 V	 p@- @xx0 P  ; 0hx  0   R$0  0
  
 Fx L  P  
0  S  
  000B  ph[
  0      /7@-P 
     U @  
5/   Lp0 S  
0  S>s@- @ `P  Fp  P
  ?    Ax P0
 S0@  U  
   D0
 S  |p@- P @x  @  R  
0 0   0 p     p|0p@- P @$  R   0 S  
 R ,  R  <o80 0    
$  $0o o p@oh[
 v	 [
 l	 0s@- `0  S  
0 Pl P0  04 0to0<00$0@ },@P( p p8 Rp8 o$P8P|h[
 w	 0 p@- `PMP  
 *x  P
@    
 4wڍp0A- `8   P  
(@,pw P#p 0   t0@  
  u u8 n8 o o 080  0  ,0(0h[
 O- 0M@ 00`w9 p  | x0 2 8 @  P!   
| <S 8    @ ( , x   1  S  
0   P  
R 0   P  
5w 2w  pP8 `0 
 PP 
 0  S  Mo4$w P W   0+ S  S     
- S    0+ S00C0 0- S7  00C0 0  S W7pp   00 07 `0  S  Qt0P p7 0 @    0  SL7 PP 0    
 4n @  T' 0   U     
  YY N  n 0Pt0   R|  
p6 `( 0 @00    T  
 Lq  P    X  |6 0 p*   h4 0in P  U  
H& 0
  S
  T 6   0    
 Vn  U 00	  SE  P   0    
  Hnt  `  U  
@ q  P  
5 0    
  4nh5t  P0$09t0  @ 0t0 }t`P T 0t0(5 0    
  0n P0)  U 00  S   `t0 V
p4
 ' @4 0$00$0 00t0  S  
  0 0t l4 0$ppj `p  P  
x Zp  P,   0  [``+ S    [p`p`  0  S    9n@  \ S  0   S    @ 0  S	 S  ov@
 @E P ą u     W   %p  P  0@0$@3ppt 
  Pn t  0, S   
 n @ 42
   Pn t  0, S   
 n 2 P 0(  0 r    [@@ 0 Ip  Pp`  
  [  
  X  

  0  S  
    [  
@   @    t@     2 0   
0 S	  
0/ Pt00 @t    P  Q  
n tu p^  1 0   
0 RV  ʄ 
p  X  P2  rn /Rm  Pt !  
 0 0P`/ V  V   00 [   P  0:	S  
 Xbl  P`  
Dcv0P  St0/    !s0 0(   ?n s( 0  P(`t8 l p @   @v U[  o 040,@0p,0  40040 Fm< Ѝh[
 	 7
 ( [
 	 	 	 R	 є	 ؔ	 	 	 0 U	 	 	 	 	 
	 	   '	   3	 v	 E	 p@- `P@   \ R    T0  
0 S0  
  0   00 \ 0 0pp@- @PP    @d       R
  ] S   R  
0@ R  0^ S      Q	  \ S	  
[ S r    
 S  p        0  S  qX	 s@- ` Pt @ 
n0  Fm	   t0  |G- ` p  V  X q@  P P@    f P Pg   g	 @-  `@00L	 Sp   
 Sm  (  $ \  0 0 "  
\ \ 00\ \/ \    S0 00/ 00u  @  P  ht40   @ S  nl000   f9
 p@-`     	0B  R S0P   P@  T
 T U  8 #qa
 T @@ Ft  T\0  0 p荕	 G-d `  Q  
  Pns @ 5l`@ l @       B  R  
0q\ S
0b 6 
0  S   s 0  0 C2  m 0 @  S' 
# S
  0 n S 00 0cn `P 
 ( -t p  [ 0  , S  @  R  PD
  
  tK  0! S  $0 0$0lK  P  U  ps U&P`T    P0 @ 09  00B	 S  0 0^ S2  
 !
 l0  @f*  	0B  R S $  g R  
  ; R$  
I R  
# R  
  w R
  
} R  
p R  
  0 0^ S   $00$0
  = @  P  l @  @    R0 0  S  
  s  R  `  j  P#  
0  S  0  S  
c U|  \ R
 R`  
	0B  R S` Is @  k   0  > k `n  j  P  
0  S  0  S  
o &0 `w SZ   aN 
0 %0T  j P
  
 J l @>m PP`G  
 5s` A  y U7     Pj@  k  0  P@ k  0  P k  ?s 
   00  0 0    \  
0 0  S 0`j j  | jj  P  h o0 p0 00 0  S j 009
 	 	 	 	 	 ̕	 	 	 V	 2	 P	 U	 f	 p@-r ` P 
Cj  P @  
        U  
0q\ S
0  
 DE  
/j 0 v  TP p@jp@-(@ P$  Q 0  Q p9
   @-  (0(  k j 9  @P9
 v	 p:
 p@-D@ P0 Q  @ lr0 @000 Pp9
 @-Tr  @9 p:
 @- p!  0 A Y-  `P  
00C r 3  R
 R    Q PP0  
 k p0  
j0   i000 P 0 P `0 0 9
 A- @ p
 T  TP`  

 k
@ l 0  Sx@ U    kx@   U  
 k@ Fl  P  
0    n @D6
 x O-4M 
0. /0   Q 
00  p0  0$ t`h $0 0P(     R  0  S  0  S  0  S    0  S  0  S  
 R    0 R  
   PU 
 0  jk  P0 p0  
I  $0@  T00$0+  
0  S  $9 0 000  S  
 s  $  \   S    0  S  
 0%  P  \   0 9k  P  
      $000$0&0$ { S   00$  S 
 0& { R0  
} R  0S 
 `  V0s   00$  S 0  Sp0&0=0C< S                        ,              8  D    h      ,               I   xj  
h @P	  
 0 0 
0/ 
0 0     
h  P 
 JD    R   p0  S0  dm  @p 
 L6 @j Po 
@ p@0@ 0@ 0  S
  $00s 03  Q 0  S  
 ^P   0   S    
 S @     Q@$0  T=   H@    @ 0 T0  0%  \ P   	 0p@	 W  0A tP     U@-1$0P T
  & P @P   
   U@$0P T    	   P 0$   S   0  S  
 

 x4 'j P P@P   T h娀  Q  
$0      
 / 05  Q  
 0% .      / 
0$0    / 
0   K  @P     I+   P o    0  S   / 0$0  S
  
 Fh0 p$  $    $ 8h 0$0  $  \  
 h @$ h  
p
0 0 $  h 0 p  $   0  S   z    Qw  @  Tw  
t`
  &0: S     P  
mj  Ph  
 `  Vl \0 0 0  
   Q    \U  
0   g0  S o I    X@  
 Xh@   P   
Sh  o T 0 0h li  Q
  0  
 ei
00+   g o %  P  U@  
 3h@  X  
 -h  o T 0  0 Ei  X  
 @i     P   o
  `  V 0  S  0 / G g$w0$  Q s 00 4Ѝ9
 [
 }	 P	 	 9
 	 '	 X O-鄂|Mpt00   P  
hi 0P  \`i  PP @x  0@"p0 4 p@* (2 `   
?U  000  t F6 nt0  S
  p ?6 XJ  P   :g &*  @P fp0  S     P   %jQ|x1 00 0  S `PG    Y  
TTkP1	`  c@   0- S	  0  S    Y  1  W/  (J  pP`*  
  Y  M&   2n %f p @   oJ   eT  Oi$   xf 2 =fd0  00n f 00P   P |Ѝ9
 	 ˖	 	 [
 	 7
 x" '	 7
  Dr	 7
 П	 v	 	 0   P/?g9
  0@- 0d@@D @N  ah[
 $0   0 R/0R B
 S /h[
 (0 0 0C R/! 0
 S00/h[
   0040    	0B  R S/
 R/00C Q:/h[
 ] Qp@-@  
  ) Q  
[ Q]  
  { Q  
} Q  
)   }   (  [   {  P0  ` P   0 S SL  \  
   U  0 P:  \  ph[
 0   0p000/h[
 ,0 0  Ra0D   RD / RU /h[
   g"	 80A- P pQ(@ ` pgB`A/f *n h[
 0p@- P  1NZf υ       X3L#
0,X3L#P3_#0P30c3 0b3l p@kh[
 @-Km0  1@kh[
 @0@- @  4 8k40S;400  80S;80h[
 0 uh7
   ꁘ	   8   p	 0  0` \ eh[
 p0p@- @P `\ e  ` m\     0e \ ~000F P0 0\ ph[
 -  PlM  

S   P0    
  lЍ 0A- p  QP 0"2 @!@1 Q `   : Q   T  : T  * Q  * a 3g0 f 0 T040@L" 0   \ 0 @   00 0 h[
  Pp@-`0 @P@ P  R   0
 S     0
 SP  
  Q00  0 $ V   p@ ph[
 A- pQ ` P)  ڨ0 @0  00  S P3  :
b$m X0  Pl0   X0 `<0  @  g ff   d 00 0 h[
 p@-P @ Pp -L07@- @D0_ 0e Zd f	0L0>@Ѝ/h[
 	 8 G-hMP
 pR   P  0:	S  
d	  X1  0 U  :0 U  < `8    e P	  1 ` 0  c  )  0@ } P
  m `P  0 0  c   D  V  
   V  fA 
x    00 0
 e  Y  
 d  P  0   0  000 hЍ莘	 h[
 	 l[
 	 Θ	 p@-M 0@0d  P0 R ``*     
 R R   R   Be@.      R R  @ ^0 R0?  0  Q  0  
 X-e@0P
 S0 0 00
00cv S     R 
;Ѝp	 8 	 	  -00@- @    c0L0@Ѝ/h[
 A- @ `d P  p    @d0  
 R@0   R 0   		 G-PD1 `    
 R  J  ZB    X  00C V<  *   0 V8  `p U @  	0D  T S0/  
 T 00+   U  	0B0 S S
 R 00   U  	0B0 S S 00   U  \ $d  0   U  00D	 S 0a0C S_ T
    S  h[
 +	 A-P @p`?d @ d  P@  
  d  P    W(   
  000  000h[
 0 00    
deh[
   Pp@-P@  d }P  AT sd `P P  @e@ Hl P ? e U P Pd pL	   1A- o_40XM7p V`C"80@  UPC"0 e 0T0 U 0  S  
@0f0
 S   "   00   d@D V   td@ Vp` d\08  1!d c7P @ c  T ! 1`OXЍh[
  `	 X 	 $0@- 0  4  @ @=h[
  @-lj,0    :  p   gh[
 d	 |0p@- Pp0  S  x0  S  
@  Tx0  | c|@x@p@t  @~ R      0 t0l ph[
 z	 80@- 0 @ P    d
 d  P    h[
 @- 0 0 0 P  0P
 S @@h[
 0@- @  h[
 p@-PX0 @   `   0
 S
  
	 S     S S  @ P  0 T: ph[
 0@- @  h[
 40@- 00@C P @!  * `
d  P @ h[
 @- 0 000C P  * 0
 S h[
 $0@- 0 @    @D Th[
 A- @ P`b U p  0  V 0 P@
    P      P  
@ T:   u  P0  V 0 P   v P@g      P  
@D T* @ h[
 0@- @  h[
 A- @ Q01  1@1D0 ` P p    0@
 SP T  00C T h[
 @-    `  P. Q  81P @ $:  ' Q    PA0B S 0 a0B  R:  0D     Q4  
    0  / Q  @ <b Pd i 0  / S0 pP @0 k P  
     a  $ Q  L0P @  @   00A	 S    0 Nb0P h[
 	 00p@- 0 @4 X PB  @' T:p@h[
 p@- P`    Vl@   @X    @X X PE  U80  0X S50 @0  S   p@h[
 0@- @  h[
 O- 1  @X P  *C `1X 0400C V @    X @X d1 P400C T:    X  )40 `0C P P  1P @X X 0F U0 ` p40X@PC   T  
 ` @ V:     0
 S  
	 S   Z  0  S     S S  @
 T:H0 P\0H  8 H00 P0b" 0 H0% Z   0	 S$  0  H00 0H0 ` 0c 0h[
 @-
0  0
  0$<   P   O-T3   `<0  S
  8P4@8 40Pb  @c@    @D eX` `  VH P~@F  0 X-  *@
 TG  
   
 T T   T   .@ T 00 T T  	 T0 Vn`  
   00FP`2 ` 0d@H @D Q @    S ^0l5@0P?@@0lE2P `d0 Z
   U  V 	 Kbd0
cPc0 X  *1 d08 0 U:! Z
00 c 0V~8 p P  * `   6`@0 S  * 
 cb  P D  8  \0A  R;%  ` `  
   0 R   ` V  @   ~0t R   A Q H0o S  Q! V `  P  
@P@f  `  L0  0 ba,0 p400C [H:@ D H00h[
 7
 0p@- P  `NN@ ` 0P0 9 ` @!  	
 P
 P  
 P  
0 l0 P P   
 P  @D  04X   T    0@ S   @0Eg T  0  N ph[
 [ 2@- @ML0  S  N      $0 ` R  
 A  0F 0$ 01    Q  d0 G  p   00`dph1hQh @d1T     P   RH!D1  ^ 8P `0 UP#o! pa 0? P 0  S @O    0  V:0  L0  S    Q!  P0 S  
P [x0 `_ L@  T  
  `80  d 0C P   0L0  ,  0  L00   0D@ Ѝ@fh[
 '	 	 	 	 	 	 @- @     0    0P0M@dh[
 @0@- 00   , @cf 
 .d @h[
 ϙ	  QG-P `  ^ @  ,"1 @  p 00 0^   Qx!   P @p@@0@P@0V
 SP  
  0 SM  K   l0 Q S   
 Q
  0V F
 S>  
  0 S:   G]
 Q
P0  p   
 @ o^  P  
 s  P    @ 
 ( @
 h0 00
 U 00  S  
 H `` PP
  
  @   i_p   p h[
 љ	 , p@- P0 ` @  ^
 fT0X    U    
 ^ fT   V`0   0
 @  h   0    @(0    0p $0 D^ ph[
 D0p@- @ P  P  : 0 R  PB4 @ U@!   */ ph[
 @-$ h
 P  

 P @ՙ	 O- 0GM @  S/ 
,: S 0 P110 p@C "T   @ 0	 S  S
% S  01 @A   E* @   @ 0	 S  S
, S   
	    0	 S  S
 @   @ 0	 S  S
  	0B  R S   A@     R 0 0   @ 0	 S  S PP
 ^ !cb  P P   P   pe   P  }_  ^ @P    P s7  `! V	   g]  P  
 ^  = V  0  S
  1  S  : 0  
 P  _  P  1  S  : 0@  p #   0JH: 0 +  @ _  PK  : @ 0 0S0  [ 0  S
	  0  S  T0  S  
 0  S  	d 	   P_ 0 S  (0  P  
]0  (0!9 @0 S  (0  P  
]0  (0!H9 @ A@ `	 TP@<ɟ  P8)   T090(	 @.   x_  P  1 s  1 s  
 8  R 0P  
 @T X] /eT    ]_  P  F!   Q_  P6  1  S  ,8 0@ G p  @^#  0 @  S  T T   T  AP.@  8 P   P T `` T T  ^ _d  V@0?@@ Yd  U   
+p W  _  P  
  _  P&    [  
q V 7 0, `7   7   0  S  
<7q V08B (',0  0Cbq V 00  Q 0  S5   Qn V 0  ^  P3  0  S&
1  S  \6 0  p    S  
 ( p06  `   @ PP  t 0d@E n 0   \ &  4 PR  Ub 
   T00]   ^  P  5  0 0S0  [ 0  S(0%0C 0 00F   ^  P\  0  S  
@ [  PP `M  5|E Pt     00  dD (  i^  P`  5 @  4 @  4 y4   r  G^  P  F/ "   \!0B S3 0d  ; ;  P 0  S  s VJ  @
 [  P  
  PP [ 0P  
 P 1 P  S  \3 @  P  1q  S11   `   0
v @P  

 m\@ B g Y P `   `\0 P 8  U: Dp P1 Wږ  P , ]  P  {    ]  P  
  ]  P
  
  ]  P  
x VM  0  SJ  0  S 2 `0 S  [   Z  
	e   b P 	  @P
   tY  X2 0  gZ	  DuP   g0	,P7 0 W  00C X T 0$0  x R
  
0q S  
n S  
X R  
Q S  
N S1   T/    0  0*  P  s]  P!  1  S  0 0@ i p  0  @  0 P(0[ @ 0    00 @       
 T
Gߍh[
 	 S	 Ӓ	 ǚ	 	 L	 '	 1	 	 =	 l	 O	 r	 Ě 	 {	 ~	 	 7
 	 	 ̚	  	 	 	 	 
N	 g	 ;	 >	 w	 	 	 	 	 	 	 	 	 	 rg	 	  қ	 
	 ՛	 l[
 	 	 	 	 "	 D0p@- P @ `00  0P@  Z Z `pl[
 h[
  r <0p@- @4  PZ$0 084  n Ppl[
 Q h[
 A-  M p  tZ0	 S   #p?0  S1  ? @0 S   w 
  0
 S00  
  W  0 S  S    W  
   0* ? @  ? @0 S   w 
  W  0 S  S 
 L  0N S񟗊  U U b ` LY i U W V Tg |U i |U U |U U U U U U |U V |U \V V |U |U |U |U \V |U |U V |U |U |U V |U V |U |U |U |U W |U 4W |U LY Y |U XW |U |U |U V Z Z $[ X[ h] h] h] h] h] h] h] h] h] h] ] Z ] |U ] X[ |U ^ ^ _ _ ^ |U P` |` ` ` |U Ta a [ <b @X |U b |U |U X |U ^ b d ,c |U |U |U c |U |U ^ c d d c  Z ` U ` V Tg W X \ \b @X |U |g b g |U |U g b d h ] $i <] 8i U  0 
0pd   0    04  @04    04  @   0P0   000C  S00   *   000C  S00   ; @H0D        C
    0 P0   000C  S00   gB  0 4  @    P0  S   J @@L ; 0P@   000C  S00    z  a @ P : 0  q  a @ P  *D0    0  S 0 P 5	 : ' P T: @|! 0P S  00C R
  x1 x!|1P P B  a @ P 9D  01X  @0(0  P    t	 
X  P  
P W  
  p W    0B  S   
  p W   89 0 0  P0(01  S* 
 +  @ q 0  0i 0 @(0 @@@   000C  S00  ڻ /8 @ U3 `0  LjX  P  
 n  P  
    00@0 T  * P
 U0 0
 S M  @h 7  000C  S00  ; 7  h0  S00   0000C Q *  
 R 
h0 R   000C  S00  , T7  h0  S00C   0A0 0 Q :  
 R 
h0 R   000C  S00  - (  @t0  S 0  Fl$ d`x |   0P 
0PO  0  S 
0xF  S   0  0  S P#   @ qX H`     000C  S00  N 6  00C00 0? S @0@  
    000C  S00  n }5  0000 0? S@  0 @005   P0  P H    0 t 000C0 0  P   
%5 t  0  S $  @   0  P  
wE @  0  P  
l:0 W  4 000  S x4 
00 00C000 P y  `      >   0 d  @  1 0  0 P   < W    0	 S       S @  
   @  0  S  d0 T  > W   	r PE   U "    0
 S00w    000C  S00   B W P  
W WP  
P2 00 	0B  R S  2  @0 b  0]W W  
x2  @0 G  @`  0 P
 S  z `  PPE0P   2C W 0 3  
Dpf Eg P    
g00  0
 0Z 1  00  S0001 @00 0C  P0  ڵ     400 X0C R00d1  000C  S00  + [  {0q    000C S00  J N1 @0 0C R*0     0      c  0	 S  S
 @<400  0C R000  000C  S00  - %     PX00   WP <0 @400C U:   C	 Z	 '	 a	 s	 	 	 W  h[
 ՛	 l[
 	 ͜	 М	 	 	 	 	 	 +	 m	 h[
  @  0P
 S  -d0
 @ } 
 
w 0   0 xp  000C  S00    X W 0 0  0
 S
  
X W0A 0   @0   s Wh
j|Z P  
7 D1 @ 0  S0 
P  UTd   T   B  P	   p 1 0  GU V|  0C PPw t   000C  S00   1b WP P @  0  Pb :00C P^   	0B  R S  e W 0% ,2 `@ 00A	 S   0a0C S  _ Q    0  |uV 0  S: 
  0 3 Y WyP  
 P  y  U `p#  
Y Wy W 00@#U P  
c W3   
   0 R	  0R B
 S  
   0	 S  S
0  \3 0   "  fU  P	  
0  p3 0    WU  P	  
0  a3 0     `p}P   V  P  
c W  4
 @ 0 0C P  
  d W  ' U  
c W   |zVd W   tVY Wy W   nV4 P `0(0A@ V @@   0
 S0P0 0 R0(0
V @E   0 7`  000C  S00   h     0
 S   00 0K @\h ; 0h  0 S    0h0p    000C  S00  w 5 P@ 00A	 S   0a0C S  _ Q    0   U 0  S  
  0 D6 0 0C R0205d6 @   	0B  R S;   0
b. P  6 0400CP  - P6 P 040PC6 @ &X   # @0 AE  000C  S00  ~ 5(7    a0B S 0B  A0B S   0 0 00 0SDt7 @  0 P  
 007 @ 0 P  
K 7` @ 1 R  :1 R  IT  P
  
7x! P|!@xA  /.00F	 S8( 0  00H8 P@  0 `
 S 00  P 0  S	  
0  S0D0    h0 R ЍO-\2 T p`T  P  
 @ P0p  @ T @e  S  P  
 P@[  S  P;  
 P 0 U&  @UE	0D  T S    	0B  R S  T 0  S  
t T 0  S  
00D	 S   0a0C S    00B	 S   0a0C S   1   0 R   0
 S0B00P 0@   S  P  
  @ eP
   S  PP@
  
 9 P V@ T01@1P1 T  d S  P@D    0
 S   
  R  0 P @ 0h[
 #	 )	 ͜	 +	 7	 <	 C	 83A- @0 P00408080  P<   
 :[  d U+ p
  88S80;802  2!8S40;402 0084  
 0   000D m h @ x|X RP RH R bR  P  Pp 0X001 @0d0P0PHP| SpP|PxPtP  @ 
S  P `  
   00@ `0
 S
 0  S  
   Vp1@p PSaT!0  A  T E  k  pm 0 P
  
@   P    40 @p0  S   |0  S  00s 03  W 0  S  
~ W  ʴ R  P  
0   R0t0l  F 0Ut X0  0p0 s@0 0  P  %  P  0H0 `0  S/h[
 K	   xr Q  r m	 Z	 A- `pQ[(1 @   0$0 J[ T0 0 }R 0P$  
 0  S!  
[  R P  
c P  
H P  
  0  000  0   0  S  
0 PCZ @T@@  U X uS p<0  D0 0,`(04@ 0 00 S 0  h[
 _	 7
 f	 7
 D0p@- @ P0 Q  Q0 0 T Ppl[
 Q h[
 @- @ Q0  bRxr h[
 O- P p  P `@  T   %	 
  0   P  SP% `
p  X % 0
  P   / + P   0    /- P   0   S   /:#:  S   /0P   S   /0`    R/d 0 R   /0   S   /0   S   / 0  0+ S  4 0   R  0 0/	  - S   40   R  / 00 R/ /0 0   R/4 0 R   / /0 + R  
- R 	    Q  # 3/ 0 R   /  Q   / 0+ S- S /A-h 0 p@Y 0  `QY 00 0!  00E- 0|M  t0p0h0Zl  d 	 P @0P    Ud  
    Ps 
 T
  p0l 0p0Yp0  l 0!h c  Tt00#t0^ 
 T  h  
 T  |  ht5  t    T\%
00
0I 
 T   0h< t0
   T
   5  
 h  
    4  T:  4 @h@ t@ P@    R  WV 0; S  0  S  
000   P  x bYp 0Ga
  0pG  @  @ <pR  P@`F  W  	 T!  
P0  S   %V  ( R  0  S) R0  SQ h 1 @ K3  0  
0D S  h " T 000   T   h\P  
 T  hD(    Y8    T"  h  0b S*  
c S*  
d S)  
p S*  
f S)  
l S
*  
s S  )0  S  
"U    T  h  0 @ 0 00 Pn$   P}  XX T	   hD 0 @ 0g   T	  h  0 @ 0[   T
  h 
 @ `WP00U   T	  h  @ 4  00&   T  h   @
  4[x1  0 0  S8  
 
    T  hL   @
   [(1  0 0  S$  
 
      T  h p 0 @ 0f4    T  h a 0 @ 0WJ4     ,U]S `  Vyl |Ѝ˝	   9
 t  l  ~	 c	 	  t C	    ,s  	 Hs r	 ~ p~ s s s l[
 t 8t \ t 	 O-ȡ M1
  |0xO00
0p
   0- S
  
! S  
( S  0  S  
p!  R WP1pG0	10P1  (
  P
0B0
0  
 X  @  T   ,X`  @  =   P ! @` T0 0@H T`   `  P   R3  1    P @  T P 
  L x
 0 )   PP@ T Ѝ9
 ?	 	 ڟ	 $ p@-  P@PP0  c+ \<0   0 Q   p- \    Q   p  Q    p<0 Q   pp@-  P@PP0  c`0+ \   := Q   p- \    Q   p  Q    p:= Q   pQ @- @   0 Q  P  0  S  00 s  3     Ѝ@-    Q p  3p@- @PzS P   
 0  S  @ Q  
0q/ S 0/ S    R   P p  3pO- M, 0 ( 100M0	*  , ( 0@O p O,  `0 G0 W4  P
  
 f@ O ( O`P "P P O4 00 , 0 Y0  0	11  PP  00  W @   N0  @  P u  3 Kc	 @-0 @:	S  rP   kO  P   W  @-   O x	 @-P G-P  @ p S`+  0 T*  ʬ       
0  S  
 pP0:	S  0 T  
  \    
   0 !1 R   0 R  
  P       9
 @- @0 V @A- PQ p`+  ڬ@0  S  0  S  
0  S  
$ 0E R  
x 4P 00  R$P  
,X  LOP0 0   
 < DO004  0 (0 R  
 AP9
 j	 x	 [
 [	    O- ,M  ꌔ (@P  x4 ` 0@   
   
  PM    PO   P    2  ,0   0,0   s5  $(  $0 O  P  3 0  
$0  S0 S  00B	 S   0a0C S  _ R  
(0   R  
00B	 S   0a0C S  _ R  0  S    0  S  
@  T0  R  
C3  0  S  
 M 0   
  YP 00  
, O  0	00  
 0 Q    {   P  R00C0A  U!  
 1  Spe@     5 p@1  S

  - % 0pM   0 15 @ 0  P1  0 
+  
@   
0  S  &  C  $  $ (@$  0PT0p  
 :   U1  
  Z P@   $0 O  P%  $0( 0 $0(  :   0  S  
 - A  0  S  
 0 dM 0 5  ZM 0r 03   7  
 0 Q  
    9  P\0 0  	  
H 0  S  
,@ N< N$0 0
  
0, N ,Ѝ9
 [
    P	 @-dßdcdM0   #  p@@P( 0 `c ,3   
00 2 3B0  S  
2          P   'U  2R 0(@10  T0  
  T  @  T|2 00     @ `L 20  @  A D     P0  S$2  0f S" 0@0 01  
00 0e S  
  
000 0( 001  R   A     P   O @  0  S  
0  S00\1p `  00 00  D1,   P @  
 0- S  0  S  1,0(  @ 0	  
:   P   0:	S   0 00, 0,	  P% |0`  , /  @P  x0 0   , IU00    ` 
  0  S  
0  S0  S    v  3Ѝ[
 9
 `	 {	 [
 %  9
 d[
 7
 7
 	 h p@-P @_/  `P
  L0 0    U80    p$0,@ @    K p[
 9
 p@-8@ P     T  0  Qp9
 O-(,M@
 00 P $  0 P    p  
0 0  S02  2  1b  S20(K@  P 00	P 0  S `i   
  !/  ` @P  VL  @ P  Pd  Y<0   S    
$ !/     S       0     P1! ` 0 0 0	 3/    P 0  S   0  S  
|rP Q  pA h @    \1  LT @  R@   
 Q@   
,. 1 P  NR J @   J
 P p JY Ty T     T.   P   0  OT  0 S`~`   P   0 |` 'P  
P   0-@|  P}`    P{` `{ V  V   y&  ,Ѝ9
 	 7
   ND	 	 l[
 	 A	 7
 @	  	 	 6	 A- P @`Kp PKJ p   U  
   P    `V  
@ U   @ 0 0 G- P @K p `P+J p   V  ;   U P  
 U   P pP/  
    	0B  R S   V  	  \ PP#  
" P' P(  
  P    U    W  
0' W O|0  Q  
 HM  P  I p`	   X  
@ P
 V   @ 0 0 pPR	 Y	 `	 9
 7@-  00   P     P0 Stt0t  
  @ CL       kI   @0 L  00I  P  
   >d[
 s	 Y [
 w	     P40    /  0 S   00/    P/h9
 @-@M@  J0x   0000c000000
000000 00<00002- 0P@Ѝ  ;  A-0 `pP @  ) L  P
  	 L  P   0 0   P 0  S 0  P @  T
   @,) d% 	   A_% KSR @h9
 @-  (  @)  M  KgJ @P   H J K -p@-M` P0~
  BI  P @1@#0  C  
h0   	J  T	IK   
0  
00L 0 0NRЍp@Ѝ/d[
 	 @-``T  PPJ    PP!y@ H@!u@ <0!q 0 !m $!i !e !a  ]  Y.  0 @  S  
 *  `P  0 0  S  
 0  S  
 3)   1  @    < 0  S  
 I   d x\0\ 
 z   P  蔠	 I 	 '	 ş	 ҟ	 X	  ݟ	 	 	 	 ~	 	 	 .	   p@- 0 @  S  
  J P  PP
  
D0 0  /H  00 H  pK K pl[
 `A	 @- 0M- S pp PKO `P@D  
  J I0  W@0000 00   I@   0  S1.1@|gH  P1.1  W  
  X  yI11 O
 @0@ 0  G  0( ߍ1	 H	 N	 z	 , T  l[
 W	 0@-M   '  0   
J   @I  P @        
 '  Ѝ00	PH p  P   
 0   
 `. Q   Q P  0
 SJ0  ()@ 0 @ r  H?	 ѡ	 j	 p@-0 ` @&  0 "  
g   
 0 Pc 	  
  P    qH  J  P
0 
  
0  S
  	0  S  
	 H  P     @  Tph9
 @- 0   0     P    0 P 0%  j0     00    R0 @  0  S     P  
}J @  TH@  0  @   0 0[H    P P [
 	 h9
 p@-#3M`     P  
tJ  P    UJЍpI P   
3K   G<G  P  0G  P  
$I @P	   I I O   [* GV @   }H  P  
  T  
 }J  P      T  IOGHHHH  Q  
'O xx" 7J  P  0  S@ P0@ P!  Q    P  * (   " " @  T  
 ;J  P
  
 6J  P  
 01 S  0  S   !i    @P 5H   G   .H    XG@  T%h[& d F 
 @JG II I41
  0& 
 &  &  &     P  @ I@ @ @@    AH PP  P@
) 0 |Y ' `[
 	 	 H	 	  .	 	 	 	 p	  	  ɠ	 נ	 	 	  	 	 '	 /	 Y	 x	  X	  4 P 48 9	 X0A- pP0 L ` PrF8@   P  
  L H fF P `l[
 [
 48 @-@ X@o P  ;I@  E H	  1I  @Eꍡ	 o	 .	 	 @-P0 @  0  S  4 E	   P  
)   @  Th9
 ͫ# @ T8@8   
4 40 T@@( (0    gE#	 !C#ͮ	 	 	 0@- lM  R@  
0  S    @y T  
n T   N PPl   

4   P    T  0L  H0 oH
  y T F  P  
 OI  lЍ0 	 
	 	 @- @    T  0 	 S  S 0@E p  

 Py T   /@-eMFO `pPF  F Uύ      `1 T^? U/@ T`13H   F0 
 0G  W  
 g%  G0@  HM 0  S   LN  0 @ P  \F  P P
    
0
 S  

 S  
@ T 00  W  
  F
 =%  F/ G
 MM eߍ 7
 l9
      p@- @  ^G P G  YG  e Ppp@-
 P  @P0 0 0  S  
 5/pl[
 @-G  P  @- @  P   @$K@-F  P  @- @  P   @K@- @F  P   J!	 @-  @- @iE  P   J0	 @- @- @UH  P   JA	 @- 0 D\    .H@- @  F p   N	H L @LQ	 @-
I  P 0 0p@- @P   "F  @PE  U pA- P F pP ` @      G  P  0  S
  
 v
  ` F  P@ 0  S@    @ p@- @` P	   G  P  
 E  @P 0  S P pX0  Pp@- PP@ /I    @ 0/ S
   \    0p@L'	 p	 ݋	   Q
  
 0. S  0  S  
. S  0  S   
  /l0p@- `  @ P	  
T0T  P0  0pF  P
  
 E  P   p   PM  pl[
 7
 b	 d[
 w	 O-EM@%  T5`0p 3/  P  ` Q  
   3   P  5 0 0 S  
D   p0 S   t0 S
  h 0 S	  l 0 S   H     0:	S^    
  
p    P    [  
0:	S  
I  E    C  P  
 E  
 E 2   P        C  P  p    @ X PP
  
 8 @,   P pD D F  P E  [   
ZD  P   UM  `   
#3@  @@4/  P  	 6 @  P   4/     
	S[    T  

SW  
p@ S  PP  
vF  P  	  @  P   jF  P ^     ~   LK PV  @2 *	R@ E p P   	 @\  U   IE     $K PP   ?E6   L p   qp   
 p 3E  P  (Lp +E0:	SD  
j    [
  
1   0	   @  Pa  ڀ :

S   *  PPX  
1D @ C  T  L  M   J  
  E  PD   <XL?  
S
S  
	S  

S	   )1   P p  Hp $  
0   0 0 E  P    L  E  P  0t ; 0{L wC  P   D DrL<C     Ѝ  u hu l[
 	 	 	 բ	 	  	 x	   l  *	   A	 W	 x	 w	 q	 D	   Pp@-lP  
P 0  SP  
T H `PP  
  @EPp P3 nC C    C p蕣	  | |0  Qp@-PP  P@  JK    T0<  T  
  S0     0   
0#Q1 Rp @-
 : C @P  ,0 0 0 S   H L'CLJ l[
  + @-  jC @P  ,0 0 0 S   G LC5J l[
  + A-P pk @ -C P   V    @ T   D @-  -0C S   00A	 S   0a0C S
  _ Q  
@ Q  
$ Q  0  S  
 G0  S蘣	 @-P K0D0 0000A- @ J0  S   
  0  S  p H"  0 P  S^  
 J0  0 0 `00C	 S @    @  00B	 S	0B  R S  / R$   C0  0%"  0/ S    "  000C	 S   @ 00B	 S	0B  R S  xC  "  0" S    @    S   SG@ 0" S`xJ   0  S 0p 
\ S  08  0 0 S 0 0  
0  S 	 ̣	 O- p;     R0`P*-  
1  % S)  @ A  P. T
  000C	 S   +C 000C	 S @ A  P 0h0`  s T`   
_ T  0p Sc S  
u S   `P 0  S0哦* p  W
 贤	 	 O-M   00   00   4J0   S     0  S% S  S;0  
0  S  
 fA  PP  @^A  P. T  000C	 S   B 000C	 SP    P @pc T  #00  Q  
 0 Q  
0  S 0  S'  TZ  l T  p@ /A  PO  
 00(3(# P<0"A  PA  P00"s T  0 U0  004   U0
]  _ T*   0c S  
  A S  
a S
  
   p S  
u S  
  000000 0d So S  
x S   0p  0  @00#0 0  <0p!:F 0 @ 0;IP  @   P `  V% V 00 U
   0@ Ag  0I pB `0 k   	  0  S  
0  S  
HF00 0  S%0  S  
   000   Q   Y 0@  T+  
 0  S   0 08   R
  0     Q  
  b) 0 000 S  0  0  S  	0B  R S 000    R  S0 @Ѝ賤	 	 &	 	 	 	 $	 ы	 (	 +	 T	 r	 @- `lM0    P  
@@@  P1P  'B  P   0  I0<@00@   RA  0@0
 0  S1  
  R  
0  
 p.   P  0:
S
S  

S  
@# S     R  @TP#  0@  |pp0     @  P  
 I   0   " #  0  S00 0  S lЍ7
 П	 .	 O- `<Mp@ P     @  U P  T8P@   T @  Tp@  #     0     P  (, 0.  
40 S+    00 S'  :  60  S"  0  q   p   p 0% S@  0@  S0C0   Q      ?  P0   S0 Y     R  0 00  SI  
   S  
   S  
 S  
   Sv  
 S'  
  SP  
  @ S@  
 SE  
{  Sb  
SC  
v   0r   o     0 S  
0  S 0B^ S I  @ eB :    R  
 R  
V  4 s@4 (   0  ( k@" @G    R0   040050 <   0  C^ Q.5   2   @0   0 S   s0 0 0 $   S   s0 0   ~ S x0   c0 0    R  
 R  
 R       040050   ( "@ (^@ Y  0  S   # ?#0 P  UI  Y   Z  #  [
H 8p  R	     0# VGH  GL    L0H0L @ P0  S  
D0  S  
 h  P   T\  
p  W
  
H L V>  P   WQ  
@N  H    ># ?"H00?   H  r   
 T    0'A  P	    AA  P  
0 G0D0  0D0 r0`0 @T  @ T  T  
H L >  P  
0DH S00
   T   @" 00 P   R0  S  
( ,00  004   
(0, 0@  0 S  
S  
   (?   ? @  T< <Ѝ  	 '	 ȣ	 	 ä	  	 	 7
 p@-@ PA0  P  p@x>i   @  $0$ $  0 0 S0~0 0 Gl[
 D6
 q	 @-hM @>  P
   
,   P  0:	S        hЍA-` p @   := PP 00 0  S	  
  @  P P   w>@  T p@- P@ @P, 0   0 0 0 U  
 = @ pl[
 7
 <0 @  >  P  
( >G$0 0  S  0 @,C @7
  `[
 D6
 O-M 0  >0 P  p`@   p > p `    T   
   T  Ȁ F T P`'@"  *  W`@ 	
 1=  P0  S@ E 000 P @ Ѝ@-0 # @-  R0 0"0   @-0  # O-lM
 +   P?  0 p:
S  ` p$`? P1  
)   @ C@  P#  
	 >@  P"  
	 9@  P  
  [    Z  
 
+   P   0 S  $0 S  
 
+   P   0 S  0 S  
 %? PP ?    P lЍП	 	 Zv	 0@- 0 P   0!  R S
  :@   0  @0@  PL 0A-  E `P p/  h  ?  P  v0  S  
@  T  
 =0  P    A?  P  
   P  
A?  P  
   P  
~A?  P    0l$ (0 p1`   PPQ   ! G- @ Pp   T  | E P  V`@  
 0Z0
 V 0  S  
  X  
 0 T0 0	  
00S\ S  @D	 < p `  Z @  U  
 D 0 P0   @-0  S  
 C 0
 S 00@-O-  Q +  
` p @Q   0 @p!    0' 
 Q     P   &  F  V%  00 	  $> p   q
  
  [  
	 h ND     0 3D @P 	    0 +D  U  	T  * A ЍB	 '	 X	  -O- EM d`$  `40`4`$d4  Q
K0B. @$0G<  BKJ! RX$ 0
 - S+ S	      X  
08  A0: R  $0 $  000: S
    \H5 @  T@5pT4E  
   <  @p   Q"0M` 
<4TdP @	  @ <  0  @000pWP   0  SKL  
  0 R  
     R X  08 0  R $0 $  00  0  S 4    4 `\d   0PdL4ps  : \  
? \   00@	 SpL4g  	  - \	  00@	 SP4`  - Pp]  
pZ  = \KA  0 @LPR   S  
  0  S: P  0: S0  
  + P  0  S: S  00  P: P  0\$ \$3  - P	  0  S: S   0`00'   P$0 $  0P 0@  ? Q   
- Q=K0C
   P  	   R  00 0  
 0    R   Q: QL   R  
   \2     dT     0- S  S  
< C-0 @0[<@ P  
   P1    4  -K   B    SV  
   0  S0 O  p  Q 0P0 00 S  D1   Q  
 {
    S   1    P
  
@Y        R  
0 0  S 00%0 %0`# `d	 T4 `; p     R  
0   
   
  0Z  S\4  S  
   
`0`$ 0 cP4 P  L$  R P@0 `  X4! S   
&> `  KOЍ/[
  [
 7
 7
 [
 p@- PH ; @P
  w< N<  <  P  
 C  p ?k	 u	 	  -M00;  :   U??  QO- @Pp  1 P  
0 @ P$5%%;  R @P1 P
 " 
 ` "   Z!   " PAPQd 0   S 0@" 
" 0 
  S0@" 
" 0 
  S0@" 00	03  c VЀ   r"  @Pd  T @ @@i" 
" 0 
  S0@"  
\" 
" 00  
 T"  0
   S 04@@v"  .00 0	00
00蟆 	 ~	 E- ` @p ,I  
 Tp `p  RP  
0   0o%  P `pܠ܀#  ;
 #;Ȁ&5;'Š,"U`p  WV*
 U    0`p P  T	   UPl   ` 0`pPP@ 0  S   !B  4@    0 <  @	 ˥	  	 å	 p9
 0@- M
 R  
 a0     0,  88  S  
@0  8   0  S  0  S	  0  S  0  S  	T T   P @ 0 @@@8 P  
$ >    AЍ0l[
  	 ԥ	 p@-(M@ P   ` 9 
  $0%: @P  
8  >    $0  Z:$ w9 (Ѝp	 E-0  S  
0!a0 p   0E    \	  :#:  S  	  A p7  :#:  S  
 8 !70    0 S  0
 S 
    P  Z	  
  w:  P  
  \A pP   8WA p 9 jA<`  @ P P  1: @ l[
  	 t9
 0A-0 00@p P;  P    @ 9 `P  
    W
  
 w;  P  
0   9  l;  P  
0   9     -7@-P 0  S  
0   0Q8 @P   0   
 L 98<0 0   
c@0
  A 9>@Ѝ/L6
 	 A-0 @ P  U  
d``pl  0 $   0 S  0 S	    0 R   0 R       P  x9
 7  A- P
    @8 0@Dp 0@  TP,`,0   @P@ U @  Ta8 @x9
 6  0  QG-PP @ =9І  @  `!\p & y9 0  S  < @   	,  0# 0! 0 0`'	 x9
   7  @- @RhM
@  Q  
&   &   P    0:	S   hЍ@- @ @ @  T0A- P|app@ `  :2n2N@P  A:[
 G-   5 . 0 2΀   R  @0   P  0  \ S
   4.  @0<0@P0  S   8C8" S' S    P   
  S    
    P$ S  
<0>4 `   R   >0  \0 (G?00B(   & R @@& R; R  
| R  8CR  T  
< P> P  | R> P  >0   P @  ` R   
  ` P0   l
     P  Q  
d  P@  @D@>0 0  R8
S 
S{S    Q  P@J   >0  Q  >00) S       } S 00  S  
  R  PE@D/ 2>00  S    U     T 0	]      S   0  S  Q  
   p  8C8  S     S< S  
> S    W 00  S  
x100c S
  h100d S  p0  S   p     0  S>0   S< R  R  
| R> R  
& R0C     @  Q*@0" S' S
>0</ S   0 0~ S/ S @
     C800 T 02>  08Z  P 00,0  0  c       [
 B  D    <0p@- P$0 0  S  
 0@@7$  P>p[
 L0p@- 080  S  p8 0D<070 P<@  T8 68@p[
 40@- @( 60 64 0 P   
6 @6[
 6	 L0p@- @D0(  o9(>P` 00     p[
 7
 G-M  > @  T 43   Pp(3 p 0[    0@0P\ U@   _ 0 P S   P  U  
0] U0  
  W UJ  
  $ U)  
E U  
! UM  
  X UR  
[ Uv  
{  u U  
  e U  
h U  
s  w U  
x UC  
n  Pl  828" @ 000 S00d   .  @6 0 0\  i5  P#PW  1p 04` 6 @PO  
  u8  PI  0`  S/ SD   6
P15  :=  p /6  P  W 00,  3  T1\ 0,= @ ,   P0@` 0 0 0 06 P  00d S  0  00B  0 V00P   6P?P00   U  [ X[]   @ P6] Xp0   0 00	 =7  	6  0  SH$0 W  
  60 0(Ѝ [
 '	 	 S	 A- pm6  > @P `	  4 \5  P\000@P0@  Q 	   =H0@- @   0 	  
0  S  
   00C0  [
 H0@- @  0 	  
 0 S    0    [
 l0p@- $0    P0   00<0  P0@@c<  T   K70   00p[
 	 0 0 0 S/![
  0@- @    0 R:[
 @-0 00  S  

 @<[
 0A- 0 P `1`!  V'  
 0f0 R  :0f V0   <`Vd   P`b F @p @g  f< @( 6  Q  
 A6[
 	 	 %	 X0p@- P@  T  
$  d 600C0 5   dp@p[
 p	 $0@- 00  S  
 @[
   P@-@   $ 5
 S<" 5 @	 p	 @-0 `   0   p:d0  V P  
@    0 P 1d1< V   40 0 pl[
 [
 l O- pKM@`<> P  P000,0>  405  P  0 
   l>   4  P @ 
 35 @ @>Vl  T@(` @ ` 0 00= @ P@@$       0 @000 K0 0@@D: 3  y3%5 @P  
  [<0  X<4   010;      P P 
   pa 
  	 p?  
  E p] 
D p{ 
  p 
 p 
  p4 
   pL 
 p   P 
 PH 
 p 
  P 
  	 P#  
   P; 
 P  
 
 P  
 P 
z  P 
  
 P  
 P 
r  P  
 P  
 P 
k (< @ p 
   <  0 0 
  \^  @$  N I  80  S  ; / 13  P=    Q pn>     0  P  pa3 P  U'  
 0  S$  
: S  0  S  
 @:a3  P  
0   S@; @ ;`  p:P3  P
  
 0 00  S  
ppn   
h ;Jo  &p   a  	 2  P X  
Q   0  S
  0. S  0  SH  
. S  0  SC  
@
 %4
   5  P:  	 80 P!   P  
 !   P*  	0 S  
 S4@0:	S   4 00S @/ S  
 f;/  0    P   0 S  
<9T @8 <  <08 Q<00<0   i3 V5  P 4 Q> V  
  W3 U3 S38 08   P#  
< p`  A  T  

  Q	  
 5 PAp   9380`08 <08P0C V:1 1< 8 P<@ T-  
H8   P
  :  @
  8010  S 00    R:   P<  0  S   3   
 p 20 0t3 `  80   pm3 00d 0 `/ S 0 0` 006$! P0 0b0 S  $0@@ 3$! $0  b   L5$ I3 $1c$0 a 2G80  SD
<0  SA
 P@$8<  80+3@  U P  TP Pl  P P     P    QP `  0㓅"80p@ 	30 `5]3   W  ,	0e S0 080`+4 V  , p$   bT 5(   0$00043  134   0 b  z/  4    P  
 @ ` $  3 ,     R  
$00 S	0B  R S      R  
$00 S	0B  R S  N  P  I  ^  P  
3(  @ $ 001  SI
 $ 2     |   >  3 @$P   Q  
  Q
?2 0  S00S  Qu  
d52 0  Sp   |0  Sk  
3 @$P0  Qc  
  Q  
!2 0  S  J0  Q  QV  
2 0  SQ  >2 0 XI  ?G  0  S  
 U  C p 0  0  S  
 U  @2 0   R  d2 0   0p"  0%  n}   0E Sz  (0 C1 p0 Ss  `   V$   P0$   00e  @ f -3$0P    dY  p1 P0  S  9    @ 0 2  
 0  S.  
`  V  
03  P&  
j1 0 @ VD  0 0 0 `10 ` 0 V   110  @ P(90 0   0 ,00,0 W	  h0 
0 0  0  0( 640  @b0x8@4 Kߍ	 UD
  [
 6	 7
 { l ?	 @	   <	 +	 '	 p	 2	 +	 l[
     0      P /p@- @P    q3  P  
@  T p@-     R@  
0 @  00 p@- @P   @ 0  S 9   Ppp@- @ P8 0   P0p@-0 @/  T    ,@ / J1  0  S 1 D	  p@- $@ P M3  J38 p@07
 ڦ	 p@-)M @`1  @\0^2   PPZ  
R  
 P  
0!!1% P\ Pc&   S1n P 0  

  h P  
  D P   
d P!  
4  l P 3  
m S  
.  s P
  
  o P  
r P
  
&  t P  
v P #  
   H        @  C @  S @  w/cO@D 0p l   n/cOTX @D 0 2   )1`80 2 1 p /7)ލp裕	   7	 	 7
 p@-  1 PP@    0 @ S1 pL  O-aM   01  P     1  P    2 0 0 Pc{   1 P  0   XZ0[  Z	  2   @PU  1:
SQ   
0 `P
    0 S?   0 `P9  p L R0 PP!  
  0 S     /@ P  0 000 40<0 @P    60  P P  
  /0
   P22  P  00  S  40  S   
 P 0  0  S    UY   P 0  U
    0  S  Z 70  Pz P3 aߍl[
 T	 L  L  L  0@- Mt0 PP @  @ 8/  P @  8"   6 @ 0 Ѝ0L  	 O- 0lM p. S     P @T  
 `@P  Q  / S  / X
    X      @ 0  SB   v
  /0 P`  
 `/   U  
 /` +.  P  0 0 0 S    Z  
 
:   P  0:	S    X  

    X   {  
 .  PT     D @ 7 @    @ U  
 o/ lЍ   l[
 	 	 	 4/A- @QP  
 0n S  0o S@ P   
Pp ~/ `  1  P  0, S  S  
 ,h.  P@P%  0  ! 000 0000000/#EgܺvT2O- 0TM 000  0 @ Q ` @ ,,0 !2  0$0 0#  a \r!0`Pp@D`P @ Z0!1 @00,  0 0#  a Tr1 `PHH@Pp  Z0 !1  00' 0#  a \r 0 Pp@̠̀` @ P Z0!0 P00  0 0#  a Ur0 @` 0 0   00 TЍ&	  f	 G	 @ W	  G-0@     b -0 18 Q>p!\p0 ` P M P@ U8 ` W  
 - *
  G.A-@!  0`! p   @0` VP1P!    .00@ S0   	 00p`e  V  60 0p@- PL      ` -00d0`@0 0 R :S0  
0 0 P  00 P pv	 9
 	 p@- @P+-  P
  
 ,  P   ,  P p pA-` P p r5 @.       0p0  Q @.@` P   `  *- - O- Q @  

 - P   XO   
   PDI   0  S  

   P$@  f  @
  ` Z-  V5  00Ppa0G SP  A0G SP  00G	 SPP
  @,  P  
 @0 T  	 X U6`  B V YX
    [  
 0  S	  

   P  
,, -      蚧	 	 	 ɧ	 ݧ	 	 	 	 p@- @ P -P -PpO-"$$M  Pp m  
	1000  ,
     @P^  
@0  S  
 C0
 S 0080  
 . @    R
 0 S
  
 4  `0I V0A     0   S. @
    -0 @  S  
 P@ u+,  P 0   S 0 0  
  R 00  
 . @  `  R  
 0 S	 V0 V   4 `1   
q1  [
 , ` $Ѝ,	 @- @P  
s  + @,@-1/ @P    4 @ xJ G- 0 `00C S
   , 
P 030#    R0  S  h  
i   pa  , S`^  
     ` 0 S  0p!  Sl1 b!U  
0  S + Z- Z  
= ZJ    X010p $! 0  S  1`0c 1PII_ PI IP    QP   0 S  X Q  00  S  
00c 1P0  S  
0  S  U  
  X@   W, @U,@- Zpp 0  S, S 0  S p      T	   U	 Y	 I@  ̎   40@-  P|M   
 , PP  
   P    0:	S   P0  R    
j@- 0 d
0 0  4 ,|Ѝ0A    [
 G- ` @pP  0   
  V@ 8 ,0
`p %,  @P 0  S '	 <	 = 
Sp@- @P  H &.@@ T{@  
 T@@   T  ?@^ - p@-q	 p@-0 @    R    T0a0 00!   R  ~ R0 K3 `   0  S  
 0C^ S?0 0   T0f0 00,@,P 0]+  00 0a p|9
 9
 0@-   P @ 0x S     00A	 S 0W0C  S  : P   \   B \   4! Q   \ @
    \
   0 S   
0  S
@   0`	         000C0	 S'0C0 0  S  /   00 C  0 B
0     R0 0/0  SQ/@-$M@ P` |pp-  F4  P   0 0   P  :0r  S
  0 S 0 0 PAZ   0 ,$ЍM	 %	 @- @  +   P   
+ * * @*@- @  * 00 0@-  @9
 9
 p@-` + PP @    * @ +/ 00 p  G- `PJMM  &- P| 2 @ {1`  P000
0C	0u  
   P  
t, @P
   +@  m, @P   `f   
 55 P 0 0  S  W  
0  S	  M
@  d , G1 	  h *0(PF 
FN@   ,  p  
 G   P4804<04F^P0  Ss  

 * 
  P)
 ) 0( 0
 ) h ^ 4JN@0d0400$ ,  0  4  8@$@6*  "* @ D      0- S  
  P  0 4 P`JN@ $ $     	0  0x   S  d0Z SW0    0  Ue0<0  N0 0f0	  

 *F   Px    
 
 +  P
  
 <	 J>0 # P@ P f  
 
 +  P
  
 +	 J>0 # T@ T U  
 ` +  P
   	 J>0 # X@~ X D  
   +  P
   		 J>0 # \@m \ 3  
 -(  P-  
JN@ 0 0P$ M P J$ 0e #Upa   @l+  P   h+  P  w WH00 H0  
- WL00 L04+  P`00 `0
 	 (P  PPE	 (  

 ) 7)F   00  S  
 -) 00
 )F 
nP  PPE  8  
@  1
  )  0
 0  Ѝۍ)	 l[
 t	 	 .~ 9	   	 	 	 	 	 	 ̨	 ר	 $    A-p `P    0" R    Q00 D     r  @8/R@@     00      H 9
    ꀥ 9
 ? . / P  
 P  . /% P5 ; /@-*@0A-P ps* @  ) @@`P804@@D  DPU `P 
f _n<O-0M    12 @ 0 0   P   0 s       P0 0  
 	 t1  P  PP @  
	  * T4  
 P@ P   @p U   2 v   Py  
2     S1 P   0 Sl  
 r  P  0  R    0  S`
   p 0 00@_^  @a 0  S0`I   2 B   PE  
H1 p  @  p1 P   0 S8  
 p>  P U0   0[ S-   0R S*  000C	 S&  p 
 ( @  0; S  000C	 S   
 (0 0R S    P  T   
0	S  *8 8  0@P  ` U U P@ P   0 0N @ P Ѝl[
 	 @- @R  
0 P  
 , 7@-P  @ \0 R  
T0 RP  
L0 R     00 R,  
( ,$ b>  BZ  K 7  zXZ tt g	  p@-  @~( PP   .S'  P  
@ d)  P   Ta   H)  P	  
 8)  P  
 ()  P    pc	 Q M_	 Y_	 $\	 @-  E-lM Q   0
 p #pe 00 `@#55  WP1P! =/ `
  `0 p   P'     P @
  :  W  1p`#550S 1(# !/  X 00 @lЍ p@-@ P `P    p @P   / ?( p1	 p@-@ ' PP    p @ /( pX0@- p @`P  0  P   0 S   
0
    @0 l[
 G- PQ @  
 m' @  X㠠   ` V  @p .@ P``	   P  
 T	   &   0
 S  

 W@: 0  X 0 0ee 0G.  /O-|M⤠`  Z  S  R1!@ 0 P3/  P  @ Q  
l1 0 0 SL      PG     0:	S  
  
0;/       
08/ @8    	    
08/  P)  
 P@+  
 % P@      ' pP  
 0   P  @g&	 T(  P	 '   R  
 
0 8/  P   @ @   5/ |Ѝd" hu u l[
 A-hM`
 PH   P	  1 0 0 SP   p  K  0:	SL     *D  @   <&  P   &  P   	  
x1x  t1  0\'o  PN  
 &% P)  
 @
    pP  
  P  @& '  P $'  P    	  
0  0  05'H  P(  
 x'  P$   . @  @   %  P  0:

S  
 D&  P   	  
L0`  H0  0'$  P  
 O&  P @ hЍl[
  F	 7
 Y	 d[
 {	 	 {	 	 p@- `Q @  
H % P@ &$ U%  V @  
 $  U  
 E&$ p躩	 St	 p@-,  P@ D%0  , 0 0p轩	 	p$p@- 0 @P  S  @   f&  P  0   `&  P  0 0  p@+pɩ	 ҩ	 ܩ	 0@- M  PP@!  
  
 %   P  
 |@	0B  R S 0   00B
 H g'  P@  

  $  P
@ @ $ Ѝ0	 	  Pp`         R  
 0  S  (-  U @  
 0  S   P U)  X    
 p ^,    Wd00p  V! 0     0  Q 0 1% - Y	 z	 q	 -cM  @$G1A  SQ  ,cߍ F	 @-bM@@D $C0A  S A ,bߍF	 T0A-  p`@  R& PP   0  T@D S
 S
 - l[
 	   0  S0 /  R/ B 00$p@- ` P@-&  P  
0   + })   
 $ @#  T  
x + p0p  Rl +     
0  S  
L  +D  +8 +4 p@+pp	 7	 	 .	 
  @	  /	  S @- L8  L!̠#D̌8#ČČ    4  O-( pSM    "<<!4,4  0 @ P<0  ,4 0#0# 0#?0O? \ 0 @0` P0!   @- !P Th0 	P
` @ P 81 @00P *=! Tea
0	P 	@
P   000 =d!@P`  0 P   0 & "00d=@P` S? P  0
  00   SߍyZnܼbO- GM p(@0 #,,!$<$ @ \8P  480@()"0 %"l!0!00P> U   ` 00@@PP@0  1Ph00!j  @	0+! 
0@,P	   0#j,  00 00`V    
0@  
    0@`0 
 0P
@P	 00 `  @PGߍu O-M PP  'ah؁	")cj؃ @ 0 @ TN  h`)&᠉1q` >~!#h0lpdd&DP)p	቏ - 3Cᆟf  !` dpd LSp!N'N   *0   	+0!  0!? ^ Ч pP`@"9"'ᴀWi'9''
*XPP`	YdG+\@TPH`(0 0 2O+^  *A
Rl੔4@,P'Hc "0#LE؊ ` e@$P%
`p	c؄i@$	P%*؉ 0	$h'Ѓ`p "()D @$P%# "0# $,b (0)Ќ,Hᴐ  0 @P

Y,jKᴐjhᘀP @x |
0h  
P`0 p 	 P@؋ЬgI*m' g@
@PA+С؁ b`	Bp @#P	  0 
#  0#,  bB #ߍu  0  ",0h0(0 0$00 000000/+ #EgܺvT2@-  @<   00  0  \    0$$  O-@0` 0 ȰP  P pb    ! W  D@  { L0HD QAᢎ^ p   W  @ g @@ T  ЍOx"A- 0@ ?0 p( 0``@Pc(     {! U  $  E  h U 0h  L0 R0  P#,,!$<$ : !AA"+ G-` p$@P W D     V   $   0$@l	  
  $" 	d(@  YP * 
	 G"A-`"@ P? Bp P@@b
    " pdPh@@   W( *  A!400@- P@     0  "0h00 - 0  /[
 A- Pp `@     
 Pr `@  U@-M
  
 
@#Ѝ0@-M P
 
 !
   
@"Ѝ0  @R   ! !0@-M P
 
 !  
  
@g"Ѝ00@-M @
 " 
  
P["Ѝ0  c"p@-M@ P`     `Ѝpp@-M@ P`    2 0`Ѝpp@-M@ `     P@@     
 `P@  VЍp    0/ S   0/ S  
. S  0  S/ S  
. S	  0  S/ S   P  0p/ S   00   0   S P  
 0/ S   
  0 0/p@- 0 P/ S  l( P      @# P    p@-   R  
0  S   
w#       	0B  R S/     0  S  S/	0C S/@-  @q"  P@ 	   @0 P  0    R88/  R  /̒ p@- ` P(0@   V  
PT U @ p̒    A0B S 0     R/@-$@ 0  S  
 !0@ T>	 	  P  0 00  Q  
 /?%7	 p@- 
  `*`0 0 0  S  
 L ,!DP  P` @ {  P   p@  TP  pl[
 	 7	 @-LM$P @@D    `dp`0 $0h0 (0@0,0000040 080! @P   80 S  4   0  S  0 S  0000  ) S	  02 S  
000     $ !  P LЍO-\M℠ p \
 \ PP`刐  
@<5  @   TPp? 4 ; P0<0 R08@04`D@HL	  0 S  0   $ 0
  
 R  0
 S    	  0   0  4H0k\Ѝs@-4@ `P0   P! 0)2  P!|{ O-M 4  P @ 
<&  `(y&   _  0P0 @  
3  @ P-
    P$    0 S  
@T
' @    (
   P  8$ {!$ @D  0 0$   `F-0 
 0  P  
83 0 0 S  
0
'+000 @ P9   0
 J9I   P  '09 p  PPO  
    `P  
   A    Y2/  
 0 0a S  : #x  Pt2t 0  ,  : | @`  <b@
  	 "!  Pp  
  b  @P
 %    0 0p S
  0:  0   p   W"    Y  
x1 0 0a S  x P#T1 0 0d S  X	 G#01 0 0a S  Y 00p  0   p
   4 0    0    `  @$  P @@ @  
   P  
  @   w@  @
  
 G E C Ѝ 
V   P8:	   l[
  w	 	 F	 v	 d[
  '	 _	 	 g	 !W	 a	 @- @Pp`  PE u    
 u   0" #1!?  00020,30 00@  U 0 0   @0P0  U B A- p  
 
%   
  
  	  @P    $    @ T`  $ PP  
 G          
@D Tp	 _  @-  @b/4 S!,0  !$0  !0  !0  Y
 d[
 D6
 [
 `[
 @-b/@ @<80 0100 01(0 01 0  01!Y
 d[
 D6
 [
 `[
 0H-1M0: #:0  0  0 0    1  S  @P  0
P !00M
 
 \0  @Р  D0 T @  0     K0$   d[
 `[
 7
 D6
 Y
 Px Rp@-M` P
 
  
@ލp@- }$ 00  P      i40o  0 000  S 0     0Ѝ l[
 p@- @    PP  T0 0

  

  
p@  P  $0    :  p@"$ D6
 (0( @-   P   !П	 5	      $5	  $П	  }5	  zП	 p@- Pv @P   % p,0 P  
 0- S  0  S  
 #  / @-  P   !40 P00    
 0- S  0  S  
 / 7
 П	 @-  P   
!G-  + \- \0`=  
	0L  \ S 7  0  @ p  0 P  S,  0 X)  
  V pp
       P    E  P   *  `@  T0 0  S  
 U 030#	 U 0  S  
 Ѝ 
 0  4! 1!l[
 	 	 @- `  @p- P+ P 1  0 - S11     0- S  ` P 00 P0  S  
_ ? @
!(	 @- 
!1 @-0  
 @- 0   
v @-0  
 l@-       !@- 0 0
Y@-   0 RO-M @ D0+ \- \  0HpV  
	0L  \ S P  H1  `   0 @P  SD  0 ZA  
  W      9  P   p    0  U&      T#   @P  p`  V0 0  S   Y 0     [   0   U     T    0   
 Ѝ
  	0 h 
 e l[
 	 	 0@-M @ P   0
@Ѝ0 0@- M
B@~Ѝ00
 S / S   /0
 S  
 S//@-0M @ S` l    
 SPp 0P  P       
 %#  0
 S   :  P      r"ЍM	 X	 : 
 A- PQ p@   
 i `P
P@  P   !
 U `@@ ?#   @P @-$M @0 0$`
  p6/  P P     *#   P R      6/  
  $Ѝ    h  O-  <M(  `  P  r #n0 00 P0l     0[ S  P ]< @P  
0: S  S
  
D+   :u @P*  
 :+  T%  Pp e00M
  0 P: S  
 0@  S  

   3%1P  3 # 0 0  S   R   
[ \  
?  P
 Z  
 ,K  P	  
 "0 000,0 P0?   Z  
<@K
    P
    "0 0
00 P  +  \@K      @ (0KXT\@  P  (   R     P  
+@0 S  
@  T@  5"0 P0 	8 #!#(     P  K`	 g	 l[
 x	   0>  0;  0806 04A- `PpP   
l0
   @ $  P 030#  R0  S
  
 N  P  ("48#8"   l[
 @-@  P
  0 S      " "苬	 7	 p@- P @     `   p@- 0 ){ @- 0  { p@- P @     `     p 0P7@-@P  
 0  S  
 0   0r  @     t8 @# !#*    U   >  p@-(M@ P `0     @P  
 I" (Ѝp訬	 l0A- p P@@@ O! P `P   0" S
 a$ 0"   A;!l[
 ì	 @- @}  P   F蟕	  ]p@- @ `PPP %! @  
 p   8 @  0 U 0 0 pp@- @ PP
  ,0 0   P     
    pl[
 ʬ	 ج	 A- p @#    PP  0 0 0 S S  
  pW    @   0/ S  
z `   @/  @ j` l[
 A-0@q0G` P
  0$D0 0 PV ~ A- p* `PP  
  0 @  P  0 @-@  P  
   	   !K-@ p:  `PP  
` d00M
 
P  X  
  
 *#0 @ 0 0  S    /  P@@   	  P  
0 000  V  
  X  
  
 #@0 0 0  S         P0 0     Kl[
 @- @  P   3	 p@-@ P.   P   :  P  
  :0 0   @)  p P   (" p0  S 0 p@<   Q/#  : P     
?o/o C02   P @  ! P @  !!P!@ #!!P@ !!  P#2! /   //o b0/  P  ,   Q
@-@ A/  Q0  
  aB Q  
 0 0`B S      
/oo  B     S0C  ! S0C  !!S!1C "!S1C !  S""!  \  `B/  <  `B/  3 //o b  \3  `B/  P   Q
@-@ A/ 0R b0A1QA1/ 0R b0AQQAQ/ 0R bAQ0A/!   1#0@-@P 4 0 y  
JZt Pe  @  0!  "#  0!6 U0Ơ!  
  p 6#6  
  r 0 4W  
@D u  Π2 S   PE  RΠ#SQ  Z |   Q  :Q  :` l@*rU  *\  0  @D  1   ?o 00C  S      b1    b0@T0@@T
  @  @  d010@d  d0010  46#!@PE  
 4 0  
  0 1   0ʰ   #0E208Q  0 0  FV 10  0 /0@-K2@ P   0 /0@-K2@Q  `B  a43!/  23/0@-MQ /0@- P   /0@-Q  Z  p K2@!˰\
   ! 0bà01@Op@-̌!J#Z 4 5o  @`!:VV6  
 P! `S  <@DVL  *P`
T\  ^  pa !@TPtp @TX  6 t  p @d @T  @  @ Pd50!1p@d Pd40 p Pd04511p  4  a @D
  5/a 0PE
0/ 4#Z 5  
``!  p` `  
 4  f   5  f   !  p>pp@-̌!J#Z 4 5\  @D!VK  
6R#2"<$!R \ d U V@L  *0b `VP0b ǠV`F P! !0b V`F P! !0b V`F P!,!0b V`F P!!
  
R&^b1>!,°        T\JUV   p!@Ptp @T:8#Z 4 5
 4  F 5  5  Vm
 ``M@xPc{      -  
Ѝ 1 0  /  p 1 QQ P!1 /  Ɛ  ƒ
 /   0@-  P  pC-   - 3  #-   -   - 3  # &  *	  Z>>*S
  51:3  `/  /  /  / 
  *&
  *  Z>>*S  J51:3/  /    /  / 2RS"|"  !R /  .&/* b b<0 55320:  6// Q   / P  3 /  S  R    Q  P      M `-?  Ѝ /  S  R    Q  P     M `-   Ѝ /@- p@-  L0 @P `  00  0      p  =  G-p` @Pb , 	0@TP 0@G-p` @P	  , 	0@TP 0@O-e  Q @P`M     @t P   S     r       Qp0  P   P=  P  * P0 0  P030#5  cp400 R 0b;3rR% 4  Zx+8'x
H T  *@J  * TJ2@0@b  ` E8#88 S  *0`F  * S`F2
    P   
 PU  * U0 0  U030#5  cd300R@e p3  
 0i7C;39Y% 0  x'x
,8H T  *@J  * TJ2@0@b  `  8#8 P  * `F  * P`F2 0 @d
x%
 
  +8(	H T  *@I  * TI2@0@b
 
 ` 8#88 S  *0`F  * S`F2	i   \e  \  * \0 0  \030#<  c100R   W [	p! #R  *O   0i5#7C;39i& 0v  Yx'x
,8H TP  *@J  * TJ2@0@b ^ P  8#8 P  * PE  * P 0PE2  b
P Ƞ%8H8".8 S   00	Q     Rp  
 @ p   p    0  \  
  r 0 Ѝ  4  O-dp  S`M P@   R=  R  * R0 0  R030#5  cT400 R 0b;3BR%   "x+8'x
H T  *@J  * TJ2@0@b  ` 
8#8 P  *0`F  * S`F2
Ȇ    R    PU  * U0 0  U030#5  cH300R@e p3  
 0i7C;3yY% p  x 'x"8
H T  *@J  * TJ2@0@b  `  8#8 P  * `F  * P`F2 0 @d
x%
 
  +8(	H T  *@I  * TI2@0@b
 r
 ` 8#8 P  *0`F  * S`F2	Ȇi   Se  S  * S0 0  S030#<  c100R   W [	p!#R  *O   0i5#7C;3yi& p>  dY xP'x"8
H T  *@J  * TJ2@0@b & P L 8#8 P  * PE  * P 0PE2  b
ȅP,%8 H8".8 S   00	Q     P p  
L p   p Ѝ 4  /G-p DD0D 0a CQ 	  
` @
  @ T:  0  0   R  갻 8     >      -M l 
0  Ѝ @-    "(ט/Be#D7q/;Mۉ۵8H[V9YO?m^BؾopE[N1$}Uo{t]r;ހ5%ܛ&itJi%O8GՌƝew̡$u+Yo,-ntJAܩ\SڈvfRQ>2-m1?!'Y=%
GoQcpn
g))/F
'&&\8!.*Zm,M߳
8ScTs
ew<
jvG.;5,rdL迢0BKfpK0TQlReU$* qW5ѻ2pjҸSAQl7LwH'Hᵼ4cZų9ˊAJNscwOʜ[o.h]t`/CocxrxȄ9dǌ(c#齂lPyƲ+SrxqƜa&>'!Ǹ}xnO}orgȢ}c

?G5q}#w($@{2
<L
gCB>˾L*~e)Y:o_XGJDllf lf     D[ <h p  @ `  @d @d L  < l   |     ȿ   # d+  t 0      t    ,      8  p Ȉ t    Ȉ |  4 ` X P P   Ȉ d \ p  L   d L ؒ < \V    L 	 ,  ԩ ȩ     T >  TF       \ tW P ! c c h h  
   X  L# { 8^ $ / I     8  t     H     @5  
 p     L! 5 |! ," p T  " |# `d      `$  LJ  
 
 
 & / 3 } h6 J @H |  |Q D7 D7  9 $R   4R T  [   lf LM  g Dl ,( Ln Tn  Ľ d
 : n e  o  c h 8c | D q q u p3 p HS \w ( ,z $ 8c 8c Tz d 6        +   (0 add (0 -    0 sub  0 *   / mul / /   / div / **  2 exp 2 pow 2 %   d/ mod d/ and ,/ or  . not . eor . xor . p   2 f   2 o   1            ms                            i 	   p 	   t 	    	    	    	 Ҕ  	    	   	 P   	 P   	    	   a8	    	    	    	   	 	    	    	    	    	     A Y	       pA  	  	 " 	 C 
	  	   	  i	 $ 
	  +	  6	  ?	 q ?	 q ?	 q F	  N	 6 F	  $ 4~ } ~ ~     S	 W	                        #	 o	       h             J	       T `          	           ` X                 (	 /	         h ܡ                     m	 #	 
                            (	 /	     h             `	 	 	 	 	  	 
	     p	 	 	 6	 ;	                       T~ ~ ~     D pQ o o 4U t t pt '	 	 		 	 	 %	 /	 9	 ?	 J	 S	 Z	                                          	 	 	 	 &	 	 	 	 	 	 	 k	 	 	 ^	 		 	 	 	                      / H)	 Q)	 	 X)	             _)	 l)	 e)	 i)	 o)	 	   | 0   	                        @         D C            	  9
 T1	 2Q	  9
 a1	 	 0 9
  o1	  9
 z1	 ~1	  9
 1	 1	   :
 1	 1	  :
 1	 1	  :
 1	 1	  9
 1	 1	 0 :
 0	 1	 0 :
 1	 1	  :
  <	  9
 '	 1	  9
 '	 1	 0 :
 '	 2	 0 :
 '	 	2	 0  :
 '	 2	 t $:
 '	    F	         p    9C	        @C	        GC	        NC	 # C	 g:	 p:	 }:	 :	 :	 :	 :	 :	 :	 C	 C	 C	 :	 :	 C	 C	 C	 C	 C	 D	 :	 :	 :	 D	 :	 :	 :	 
D	 D	  D	 | D	 P~ D	 P~ D	 PO $D	 | (D	 * /D	 y 3D	 y :D	 X CD	 * MD	 y SD	 x YD	 x _D	 D eD	 lt mD	 t tD	 | xD	 W D	  D	 8 D	 i D	 \v D	 @c D	 2 D	 Xv D	 8 D	 du D	 lt D	 $ D	 s D	 $ D	  D	 P~ D	 pr D	 q D	 | D	  D	 p E	 (o E	 ( E	 e E	 Xa WC	 `C	 hC	 sC	 C	 C	 C	 C	 C	 C	 C	 C	 C	 Y:	 ]:	 :	  	f ~F	   t CF	 
d VF	 
s iF	 	c yF	 
m F	 
l F	  p 	  n =	 	
v F	 
 w u	 CI	                   @                   b      k      m              I	 J	 ,J	 KJ	 iJ	                @   @                         @                              @  @  @  @           M C XB  Q ,R K G  O       
   (   y   l  E    q&  Ts  Y 
 ) }$ <_	 ^	 ^	 ^	 Ě _	 c	 ^	 `	 c	 m	 3 m	 m	 1	  m	 m	 q	 q	     c      w      b      kD    k      K      MD  @B M      GD   ʚ;G      @        b      k      m                          @  `                            0      @   !      `      P `                          `  G|	 WJ	 I	 J	 8J	 Y|	 p|	 |	 |	 uJ	 |	 |	 |	 s      m   <   h     d   Q         b      k      m      g      @          	   	 }  	 Q  	 S  Ɓ	 JFS1Ё	 BSFXԁ	 I؁	 `  ݁	  @  ݁	 @  ݁	   	   	 h$  	 x$  	 DM  	 @  	 LV  !	 ii  (	   *	 {Q  ,	 /0	 /6	 /<	 /B	 T F	 m/J	 NTFSN	 .Y	 sIeRS	 E=(\	 ur  c	 Xc	 hsqsi	 reebr	     I b      k      B                                                                                                                                  0       0      0       0 0                  @                                                      @                                                                             @                                                                @ @   @                                                   @                                                b      k      m                       !  a 
 w 
 | 
 p&	m&	P&	M&	 ' J+"J-"J*"J/"J%"J&"J+-&"J&/%&*'' '''!-~- 7 ;?%@: C 1 P  %+&-&!&                     0   1   2      	                 #  
  3       
 A     
              	 
  	    $         I I                  c      w             b      k              
         #!CgE#	                     xjVp $ν|*ƇGF0FؘiD[\"kqCy!Ib%@@QZ^&Ƕ]/SD!7Ç
ZEogL*B9q"am8D꾤K`Kp~('09|eVD")*C#9Y[e}]O~o,CN~S5:*ӆ  	  8     $     I   I         ɼ;ʄ+6_тl>+kAy!~g	jgrn<:ORQhك[ 00     $ ( ,05 ; C I O S0W \ b h n u {               0     1!!%,117=!BGL1RW^ekpw|!1ׁ݁2 "#(/52=EM"PV\bhmrz2͂CC'-8AJ3QT3X^gpw3333# $,3?4DKS$W\`dks4x}4D45	#&/285?%EHN5RW 
      
       "         	      !              @              !    
         	

 T wp

",f`    @                                         	 
   ! 1 A a    0@`      	 
  
       # + 3 ; C S c s                ?   ?  A    ?     2  K  n        , X	 
  `	 
 %  K [ [[ addgroup adduser ar arp arping ash awk basename blkid bunzip2 bzcat bzip2 cal cat catv chgrp chmod chown chroot cksum clear cmp comm cp cpio crond crontab cut date dc dd delgroup deluser df dhcprelay diff dirname dmesg dnsdomainname dos2unix dpkg dpkg-deb du dumpleases echo ed egrep env expand expr false fgrep find fold free fsync ftpd ftpget ftpput getty grep gunzip gzip halt head hexdump hostid hostname hwclock id ifconfig init insmod install ip ipaddr ipcalc ipcrm ipcs iplink iproute iprule iptunnel kill killall klogd length less ln lock logger login logname logread losetup ls lsmod lspci lsusb lzcat lzma lzop lzopcat makemime md5sum mesg mkdir mkfifo mknod mkswap mktemp modprobe more mount mt mv nc netmsg netstat nice nohup nslookup ntpd od passwd patch pgrep pidof ping ping6 pivot_root pkill popmaildir poweroff printenv printf ps pwd rdate readlink realpath reboot reformime reset rm rmdir rmmod route rpm rpm2cpio sed sendmail seq setfont setsid sh sha1sum sha256sum sha512sum sleep sort split start-stop-daemon stat strings stty su sum swapoff swapon switch_root sync sysctl syslogd tac tail tar tee telnet telnetd test time top touch tr traceroute true tty udhcpc udhcpd udpsvd umount uname uncompress unexpand uniq unix2dos unlzma unlzop unxz unzip uptime usleep uudecode uuencode vconfig vi watchdog wc which whoami xargs xz xzcat yes zcat zcip   multi-call binary.
 
No help available.

 
Usage:  --help must be suid to work properly busybox Copyright (C) 1998-2009 Erik Andersen, Rob Landley, Denys Vlasenko
and others. Licensed under GPLv2.
See source distribution for full notice.

Usage: busybox [function] [arguments]...
   or: function [arguments]...

	BusyBox is a multi-call binary that combines many common Unix
	utilities into a single executable.  Most people will create a
	link to busybox for each function they wish to use and BusyBox
	will act like whatever it was invoked as.

Currently defined functions:
 ,
 --list : applet not found
 h11AY&SY*@ _rpw`VG \= ﾾp40T%Uf:n2 
`/np$\[,GvpYuϱu]r0Ouz.seuvR
)Cysz"t6k8{+sjk6VMP+_nHY|(On}ҥ.խvov34 @ F4	MPAԙPjzhA
z~hhG42H$2SLyF&
    4 P$5Ojҧꍒ&4z H	i1hT6SڛSGSh4"  hLi=L)	OzL dҟ"e"o_fMH=.A;O~R;f"~՗n?lF_?tܢ6+dNOz~YFHxޕwE]4v0\!*uQwq^P5? ^
7rpM?kv6qWÏnx:ۧҔZKm#u-xE͚H~mv,ó	eўJ;תw.xOtlM	xH! Vum<*Dyu@V
fu|ŧ:Nq?_gH4Ks'鷩Ѫ4֊U^MRIoɃW7g}{
YO|s@l^wO֨D:A ?}&0-pSAd+I<?EGVPUל~Y1-88UK
ufVxizTY2J,5:d\?/&h:NqL/O X:ONt8Nujۀ6BͷAǝivmz		lpjG风Pwg4"4.KA+RKҫ?nLlmW53j oǪ׸
&mMMe$l5̼9W%zz]ӡMkA=<l,lbιyLҜ}^W"UkP♡X#]A]dW62~?d	GJR?yK,9
 T/;.N1-.{P	E_nIwL=HGݯYς56? iKY"SUOg`nm>*eV`@DQpmr4cTw. /GB^"C_(i.\1g-M'>Xd%iWp5X</~|h'NC  "}U<H)B!#zBn%#/eJ{U~2?a+FUF%Z$&Ɣ6SqfVry@taG8vM+u7.	fnwn6v`fDJKeX 9(,;EWd`YT\'S|,J-D0ODَ({&:e] ua})V~?DWv)<6_@-˾e᯻፴}:rؠ>a֏)@?~X'&̘֝Y=̙UFFy>a\DS']y~*<l?.Yxaz
äfBx&cy׺;T
&f^k|FBY3{r1JWkZzn>#i7MޮGv"/3es"]YS)߁]ٿ_MvB @¥@D@⃄NP2|@Ks3ӻh+4j|"sfkۃ&pCIv2r
jЊ}~%z>8Aޫ?TDvƽ>uH~'?l'/{m-LOU'̄^q 6FNwqH$l~lYuj`P)=/ֹJ|t4uI.ssSd<k]M6%=pg\=W\+ܕ+4nSR3cG)#=7Xk$DZkVMުDMMx4h|A$r`RDr>?anǃ5v0e	O?im
W
`WlVZjŜZSA˼]=9/8]f~i+ܳ+-8
^//L}@ŝ*zl63.v g 0ִ"HySu	%,4%EH[;)Xr}%XE%{7<Kt
, :L9BG=-/o\Қt,8wt</Y7ADW hJM
Kt	?qTueDƪp
Uw~s}[ڑ%Ye 	9ҷrp{&#0*yi|Ԥ_eZQc"`ކTX.>p@C,_}3!P`jkIjlcڢ Y	:?Usb"nXR<{$|םCcMU5mthz%pMRqG9/.t8闾7MX1.րR$. _{F6X32څ-~NnYY~#|(Ϫm2-J($ROgkǁ|?-e>b?Suq>8jPyg|ʢWđ$m(`}@J?plSc韭̵7aG!"y&L[2KEUȧT[OH3nFaTa]
f:錳#뢨0^>:1A]pu@=5:<1wZm\`}lic:
+N*c@p,f^WTT5X2~|I,\'BENV0'ؒLF
)&O5TCfLũ\gwܼu
wщG@^$6;;xb

<;z_!1Z{2C	 z@0ǂApٮ̔_زf2Z2΄-JwkO%W[/>9R`a
(n3M޷	PU敌i>@c︒lp;*dajwP_SR.Ƌ3)PG,
 J_zd
ϞGξCԳ'CkпU$9: }jZҡ2ʄ"l!%.;8soZ9{5:WgaJk26[KXb#f{~*
qZ#~߄)ź>SF
ھΈ%,P>
IyṘ$N]@V¢BX.4	V
BB]7QdY/I/jz$շ24(<	9Sӎ3qwZ\z̫1B
~O
9)P-~0c)~v=kxX݃ʂ(s5y+\$Y3^жVOe$i2}-oH%9
GlFQeE#nqeOOfN
8'`& <r6SayUJӢWL_5SZ-Dɰ[F\ w~6av&PeKvd3麘7Zp(ORJFpH,xɈl^fm˛d	:5yq5h.Ջ=d.mTa
abu,}tϨ#8ѩs7
eI'(0%CVr3aDD$k+@iEmiaU8H.~BՔRLyp.Q5tP0m&=Yh`ml},mxEphGi	* sEkؾp@WDf79w(5ZfLwq45yT#+*~aQ
{u#pǫhD,&Bב(zg\]uf鑼{TpMQF7HF>k|zA},e`!4Uӿ|FuWCBVKN>B2J oac(q?f}{ݢ:EߔnV'$XoT[sq,,aGq;A9ʘdYtڶ[ߐq24Ț,2#^šOht4V[v_eN"'U`R!-h<3sY=<;i0X#rzWxW_$Wź{AGqkVfZSגӁP*Ux\_=cߜ4}F	'ovnaQ>8үҖzu$tW뿪 P) e$uo]QD2
W2y/y2^Yp
AɻRI$!X#|m2rlt|وof=[hҮqo_([^n.V^a|:B@Otnm
 լ1ox!ӯ*}ӻ"0~nŨZ
σ.eC/D[L
ֽ1C6`~cÞp5">w.k<J
GHF\O	shOW9{zQe҇cȸR,"CZ)5;Tv{wJn8?/usf㸡AC
\r$Dʫhnp^ҿW@~ѲrShX<UCGѭz<B?3B֒P`VDh<OQ-:|t۳b~ɮ>}o;5DOXt8:ssemN`G~5OM	lcJ,&C>W$dgRN/Oja/ "볣	#WlW<^eVGzBy<iT/-V@K,u;ʺO~mr33H<("dPL:mEo}D$.I/@o K
0-Wʯ/xqy*pNL-k
}q~o@uV};tR<aPYbeeGMK0Ya(z3C)-("V?yBiٟ?|~4BԠ+8(`,
Hll
rcl[
NCB*ne&M"AYG5h$6(J\o
qS2d
k
TZ,.:~7&Cv)(;7lQT-Ds>۩
IG|1<	,D'IGx@5Jœ2w6-&0#EGo{1k<S:(1\l0
C!b8 y0{B_hFȷ(]΄y}8F _	-vF⸶TnG]ܘ@XHTRA-;V	~#"{j',A3n5n4Peky;~U7\=~u
/EYNJC$Zr.(z Or_z၄oaSѨ\|/b0\*W3,,Rc;!M56!]+@1n?l֮pNӥj+mV`(e냕l4pu`FKH3G9IsnX`IOoV*.Mu`ʡU>vŋrDBJg:rxh}C =Qw"13~\hc3`Z?K4V?_i#YZYSH ̭=lR3HP<xǔ#1(EX-;k:?(bB}>Wg-PȦ^3~Gg^!|.zɴ	 SVe XdUƍIրi}wpDI;P'OVm7ev\"iVw:egv̨8PQm-![MC잻vлiP-''/Ir0]X]0]gZF<`ͨ"DDS9[>)0]l[Ի8_H=pػtʁɣ՛JZ5hFxp@=72(	!Pb@'#ԇO{eqOQwҦҦK5$`Ye)c%lK&Ҕ"Pg-˝̂?-@jniq
pڅAq	Qa)h*9m]C*c~G4/9w}>\e
U;[7d8JҀpd3rqF=Sfq@OֶWZ|ss?1/HwR{A4<O4sT20
7\W=֠Yixw;ӣ2/Dn%cyT-D	?JrrQB]%M
f,<,?3a3t$Oxz9tHb1OjG?ч
aO^(k?DkAK_CKk]GolY59ц=d	!Ga
/6|s#e8H	ϤE頨n<MMldR!ϯRtY~3[vY$ƥv1X*0*22K*"ɈRLZPf^@I6@P&t	b
Q-
*|s尺[=<@(HǜGYwÁ]Tp%-z1釓R,tSSNaƹ98AT\O3	DDR~b}؁iӦpEbqI촆}b\IL=af+Qx܁oB飘0qS߇v<66b
`	uD{ W&xRCts88Ε@3m	צ
!kyC23h(n=GY5A!ەbb>wA
5>
ɨ[%q$@7nlL[i$&Hg)R4'js,=ak[dʖ<,=؍A5T.ew
AqEG٩
|B
W)GtUI3=Yo@@b"(ETUV (]^GHckW/ى$H."╎4;|<BqxdԸXΊX[izD ^zs[Pj hAMTaSzPM;&b (rSƆsZynןdHE3)wel
,Cl<xC"@h8U(Ke{T)QZd&҉aϪCjCvcf縰Iꄵ4Vt4KE| V|!X	(QVAEX|6r=nJ}W_S0[RAȇV0ٍ14Kq416y
(
s2Hr.[Th;߿j uMs_Aqr![V^S|;[@dk
H6WJ놌Z ~i<ϏB<=m5U<J|* 2tо7Fh_
M !
1/AsA&PKZy&A	"#Y@
c@P8/AbXQ`,,YUF
I(@hip5WDR+"~:mHĈ2+Ƕ`S9>PڪEy_9߱	pJ?PՈ d0g!3}{^<x盳|Xrݬ/HS#ִ>-~GKņfWhiW	=͍
l^
{J<ya?`ވ1ҿUe׋UyW"4mݯ.-OVѩd>XdHָM'>fO[wG(meng`2Nn!k3Oh[TvZܤXh"m_\z ɀ`g+.3
tI4 н+GQB~i~[8 [ΕH
E)
wG<YP {iITN'Z3P 5*㖪ՠ>`8U7l;ksT+/R,7>5\1	+^w й򲉤:6u>Q!} <^O4(p( M¤"_`"??c`F6Л}z?iAYa

S45|_<G!2ShhǮia+E-_v*IkTN+Y,lJnYxDpPu}k2u{0Hl0LO Nl^iCM 6E~`|$m{;O.[+[R*M31
k0tƅ(ZK9ZiF>0^KTi}\!a_L=,cV/CJr5ܚWiiq
t>o,W?A|zCVX`TM'
TP0~Ogwp1Y @DA>,{əY	"h0CQYU)5zFB{2 
x"Q=
W^np9\]Bt< HC@=Ha cs	=TQ6L~OyG}L#QZ|)&Q:x0wPU`Tw!z81z#]eL#삂ȊG(Ty
o8nsFPl[C8#1fDӇ'1>'9翺|qHAKcNMeΖ-<éX4[k\+TJ`XģFa%5!lEG'#`"%,b"H{І1`
!dp!xmy1J m$'W4ؘߕ3pΘ l)n 2$bIY8L<c4})fCbD">0M6m	bĤH]nBeo9d4b|rӥnm7 8V,)ðw,FDÖܕN40aw(-GD$	-Qd54e|Rə9&_@lX-EBY᪼8c
#3ud`}kf~S3K_v~ou˖wd2K(ҋ!icOFUT,;=C8ҁ^h`G}8'Nԓo 64TeQU1۵\{%^jU 0Z:r,XAcUa@P6B!R%һZ@~!s<s{q^
iϬ*.J/G
K%]֎p {}^ua\GR舛ݩ/ۓs@v@+ שbv)ΒMWBtBp1;Fu\.&083
8+Ppw2E\YY6$J.iq['Y&( 4Y.7=+&!8'd90z5<A
x2NR5-#.)Pl6">JY0|&BlTxZ txJ,0ʖeZe0ReEBmdC073P
!,,p. Pӡ@lJ1p%트)3(Cp`5$q)hWEжmh<{o!$5z܅mMi(Dk}+1/T/hcd0UFSjA,GW uƬp< Y
EeAUQ @l(ͭUs/C/#иF4msj$ *_`.'&3N drS*Wji >ü5etȳ
(Gf[U$<zК0Z5$"E'CV;Xޒ)9A,m8F>w3M~#4qRL\A
a~DR'Kv6`ʍzt2CZ#c
.ϧ}C82JJ= HG,u;\4yMBL;p
}ƻTQnF2TH$km0ن9#@b\jqhmj7vn`.cCM;1cbBEmc..\8=R~w@R\@YBlȍxGY%`C)J:T5*JS%Rp`7{e }Fj+hoTK;37^~Y8UN8o ,aGRTWВ^WHSXCPJ6tY(6wR*S9q ̼kapĜ^Y`#+)}Z _`Z$xLY`>;tQq˦KXnm1UIyƝw;s];5b
ȀƢ ]
uVhٓ(7pA7
:Pd-e2!@K;,/FX7ՊZ':&V(7عM[VQFq)֬a9`RAJ	db(,FjɌ"b8|
d$8oNoE pݲIUŢ&OAZ;
?ſRf2=q2)mȁZ1o|٦i!ڧA6"uK2cCtIw?UI>x|>O4Wg
_?{E&~TɄj
Db.b&!烧d}^ LLM'~KS-P͓aB2
c$
߲DAKTEoP
#`"kHQʃ bd,8
z+KQ1@:+&0*1I
*Hi]ɺ-b,PD+gZV
q68
XET 8;Hcla&ɑEO{ړRh;Qx&`:^"6x!$1*أՑEU%(X#0JYb.;b<;'c@Ma%2}n.[o\$`FA4"C'ET|PCWEd*r~#9/#2VB?{}Ip886lW{!`4EL?'f@w0I$N|!My9ϰhXS
	f)㓼;6&w41C9E	 HJZJBHMwՒ|\):GN6lm;>B羞BHm\1L utqTBIA!ԨZQ[n=|^Mm
~*	R
O=y!('LC,!SjB\RB͡Ӭw\{x pޟ-|}{kE(M
O(i!ORūRӋ0"*$x2iR^nMJpE>VBp$Df`fxxˉ`dT@Q))=~'ǩO*9y:h/*(Y]xH 
l]!FTu[)dPH3s
1`616ag`*REbSm+e7Aw#ܚ
DNv:39
Jd;13k
`a&Kv/^~<]8kn@N`5eJҲU!( 	uuc(hJ\e<ޣQ
0=HlkoCX* ta9<9	\6VV9_3'~}a{UB,b"nN
aij0ı1d1yu`˕p'_=尰zxJPY+AxC;Z?^J.mGz6~ʁ4̢0gl`*VQ?r q1;)xYؓ)R
)
d!dh`z25X7Ezoagj

_HC<J|YJC">zMw>vz8CQI-!FLfiACV)MSI:`oϟx֢:0II@OV2 {kݕLpeއ0W<:-$@BN&k~Ho3{80({34VHfȆjToq$].J3xM'px8ei\x5$)g-L`Bҿ90koJ״#dL2[!-o	a2%srhA&%! Y<'4lchhQXIȴc1Trb(`]{"E9XV9$[֣#"bTwF+.| ᴱ(<	jؖHP_IEnDV>"&Λc[ٓEh"vU=,&cpm=Yയg5a;x9??yvbtI'7GjM9@H$m"vCȧudGv,WCvM!J"]701b̄$)75C
DPb018Pg.\L8R
,1n,uEGmY^F&1-!85zlh1"nR*|qM4๟^ЃaYLlHS6ˡMê1lg7vʱbbƅ\YG!QP*HUSʆ13ve		"Q?M2xFs%h`Sn.@Wh@J&MʈX	Z4;(&NQ.OIfV侬cགྷf( V.m'	W~h;ɦ <Oa3'8Mbpbk`-(ܗ[jl D֍Jifa=9h5!""bL ņ 2&-u$<x%' 1ǅI>x)B
8m@g`E'ITc%ܲ$E%*Yٯ.7^(Ex`3M$;ۛⴄ@0΍{|?s%3YdA65tRO 	
]qIWAI"'	v/c1_wְ[ТDis~  ${`=SقTQ`'EHy3Xy@3aS:@Eg9pYT8p'K9<PCD
" *p<aͅU"aSto!~N`CM$>aZ?cEAD3Z)}q8JHz4zl=ur[ /Yy,G<wL%aRH@d.8Lא<	 h#K&9,wq3曑R(D_nXDˉ

?R	||JQF%<MA۞_W#0uvl}01ERO8٫Ӷ
nߙ-dkY@~<<PϰYAM=qvj *͇^;ĳ5t=	2=n28y
90 I]9P:mMq#pw7vT
#J0[|Ĥ1Y/lMCĮMaD.¡I
ՓMZ
Q!s(8P7t^ҹV4m?g/zI[K?
Rks}O&)iItc$OuI9ⓈXݓo#"ZUzZȄ\b12 HN`_+&Ƶ٨wgBRdZ<eeL"ŐΨQQ+&6pJBx%Yzf@D[kAPgXͶQQ&"K#""	JqH Df\Qh{&sRINԟ!VaUhUOEtDq!M*UeO1 *UW.+I.LYC-,:ug~pٴh;F	" 4m[Zܜ
,czыa8O7H',͟ug=dOy$QU_"ц)i=yJS
&0-1a5"" -
fI(Qq1,# db5$h#I;֙H9!Ңtٺ>^ǿ{gyWO(CPEfQz!C^D J"&i`Po	ؖ-6F8Oݦf-@[քJ&v<R#gʘLZT+a}@=_ #ccfPET2X5tzZ-5'Fc-%S泎'IhYQ
b5ZlȣX`
.=D
Hܧ$lTBDF(mXJXбib.pT +@'?7<0"|oyk0ӥ 5/ANT+' .F`/D;N& U^ٺH<eC1_}Kp2u `=l4ٸ+l1 Mȸ
SLÄ֭1e3f &j,jxNÝU{;<l+(<]vP3AN(f^K@Q}@,=v#0LpܐACy9,Fƒ'Յm
lWK/{4TGνj8WC&Fԃpcg$#'1ʶ
 +.j95A+}X05~N'T$bOԙJ/b[;]lnpP&;:Krz;WdP0"r(cƘ"`/Ɇ=hoڡru^c4#nJT \WAmZ	cn($D"|N
`KU.56r,WHgafQEZ
eCXrY	]kjhtNQh꜔Mazּc*F0嬣9?SHtOq/66Է)3J>jj) gݱaD(Fx,Q036,aMn 1	4r*qD:ʢ1tFPx1{dT8MR˵E$l!~KhԂJ&1H`	6k`ˌK7v2afE%FZKX2""੦`%PTƅ3ha4safݮ2o+a5Qnt6.$AR<"H1	0Xf&2&s}4Dpc|J@r;*6K (^e`(gtE7.jd< 4s (JsHnPLև@D'1(SE,Ϗ6R1OXK\1{
v [E.{zD0+ld0[0PY'b֜l5a[ lD	j $HXm$2sɔy+·\	yT׊2/5&HmN5/3lN,+&%0wgFq.*GIBm#5DE
]3>V
DXar-R(VDM7id"!R-˦MqgnC^XUxfm^lx6L[aI 0/-INd۫X;@$,7 @㹾wPlHRZu#*zĮ36Q},MC˘<w,+qz$fVC00/7'L0l9IK>-" Gם8'9֨muAgHt<hW +'9
 yL !3 LQvЗZH+Qd%NŌ7$hg0+D~B"̲zsC֙/U`.g's1D.Aqmmh"
}_,MI,x3J}
C N@a,Ɇ]ߣ]Xc{:އ%@ô3 (DT"EQQ@* &aH:%Sa0x݉3	Qgxn+!ߧu4P;'=^.%U̭ɋu!amQ,P0n1%;'ꨚ'R).,,<X׉fśHiE@;
Ձ:2%^s߈C+Ў@K"RLi(J#6(N',EݐT$ha	~cGS҇.a{I(*-?KQ{w}G;ȶwbɔYe`#׊|q˾+De}bG
=<$kF^P&D-Z,!MƋN@@h\d 
*H"m-Ybu6
iMⱬ-Xm󗔆H٬	HǸۧfvQflD;
I.P+dAvuOQ !U'|u#F&oּʦVtҕ7b(vrE8P*@memory exhausted 0123456789ABCDEF BusyBox v1.17.3 (2011-09-09 14:52:02 CST) (unknown) permission denied (are you root?) /etc/group /etc/motd can't create raw socket you must be root read error /dev/null /proc/self/exe write error /etc/passwd %s requires an argument standard output standard input default invalid date '%s' -/bin/sh invalid argument '%s' to '%s' PATH=/sbin:/usr/sbin:/bin:/usr/bin LINES COLUMNS can't open '%s' close failed /dev/urandom SELinux support is disabled can't stat '%s' sendto listen bind NETLINK INET6 INET socket(AF_%s,%d,%d) can't change root directory to %s setuid setgid %s: I/O error lseek(%llu) lseek short write can't duplicate file descriptor can't create pipe can't move '%s' to '%s' can't remove file '%s' short read %u.%u.%u-%u:%u%c %u-%u-%u %u:%u%c %2u%2u%2u%2u%2u%c %4u%2u%2u%2u%2u%c gid gsystem  S -1:?2:g+ g:S %s '%s' in use no %cids left x:%u: home hgecos gshell singroup Gdisabled-password  Dempty-password  Dsystem  Sno-create-home  Huid u Linux User,,, =1:SD:u+ h:g:s:G:DSHu: /home/%s nogroup /bin/false user x:%u:%u:%s:%s:%s addgroup '%s' '%s' addgroup -g %u '%s' %u:%u chown /etc/skel passwd /proc/self/exe can't execute passwd, you must set password manually /bin/login tty1 /etc/issue -2:t+ bad speed: %s too many alternate speeds /dev/%s stdin is not open for read/write %s: TCGETS %s: read %s: input overrun %s: TCSETS %s: can't exec %s    I:LH:f:hil:mt:wn f:h:p -f is for root only UNKNOWN  on '%s' from '%s'  on '%s' Login incorrect invalid password for '%s'%s root login%s 
Login timed out after %d seconds
 a:lud %s can't change password for %s can't change locked password for %s Changing password for %s
 Old password:  incorrect password for %s Incorrect password New password:  Retype password:  Passwords don't match $1$ password for %s is unchanged !%s can't update password file %s Password for %s changed by %s password for %s is already %slocked mplc:s: none %c %s %s:%s incorrect password SHELL using restricted shell %%llu.%u.%s Content-Type:  ;"	
 text/plain multipart/ mixed boundary= header: %s no support of content type '%s' charset= Content-Transfer-Encoding: 7bit filename= CONTENT_TYPE CHARSET ENCODING FILENAME 8bit no support of encoding '%s' 

 x--X:X--x:m:: x:Xdeis:r:c:m:h:o:O: c:e:o:C:N:a:m:j: %u-%u-%u Mime-Version: 1.0
Content-Type: multipart/mixed; boundary="%s"
 
--%s
Content-Type: %s; charset=%s
Content-Disposition: inline; filename="%s"
Content-Transfer-Encoding: base64
 
--%s--

 %s failed: %s -1:dd:t+:R+:L+:H+ bdmVcasTkt:R:Z:L:H:M:F: APOP %s USER %s PASS %s STAT RETR %u TOP %%u %u tmp/%llu.%u.%s delivery helper DELE %u QUIT RCPT TO:<%s> Bad recipient: <%s> f:w+:H--S:S--H:a:: tf:o:iw:H:S:a:: SMTPHOST 127.0.0.1 NOOP INIT failed EHLO %s HELO %s AUTH LOGIN MAIL FROM:<%s> To:  Bcc:  To: %s DATA User:  Password:  no username or password timed out helper killed by signal %u helper exited (%u) sunmontuewedthufrisat Iuser %s: parse error at %s # 	 user:%s entry:%s MAILTO=  command:%s Iuser %s: too many lines cron.update chdir(%s) ignoring %s Ican't get uid for %s USER HOME Ichdir(%s) /var/spool/cron child running %s can't exec, user %s cmd %s %s %s Exec failed: %s -c %s
 can't vfork %s/cron.%s.%d /etc/crontabs f-b:b-f:S-L:L-S:d-l:l+:d+ l:L:fbSc:d: crond (busybox 1.17.3) started, log level %d /var/run/crond.pid  	
 wakeup dt=%ld Itime disparity of %ld minutes detected file %s:  line %s  job: %d %s user %s: process already running: %s To: %s
Subject: cron: %s

 can't create mail file %s for user %s, discarding output USER %s pid %3d cmd %s sendmail -ti janfebmaraprmayjunjulaugsepoctnovdec VISUAL EDITOR vi ?1:dr u:c:lerd user %s cannot read %s %s.%u %s.new can't create %s/%s can't append to %s/%s stack underflow stack overflow syntax error at '%s' error, base %u is not supported %g
 %x
 %o
 
 

 @ABCDEFGHI@KLMNOPQRSTUVWXYZ[\]^_ [%u;0H[K [7m%.*s[0m [%u;%uH [7m%s[0m %7u  %07u  [K%s (END) [7m%s (file %i of %i)[0m No previous file No next file   Examine:  Cannot read this file EMmN~I missing filename /dev/tty Log file:  Error opening log file Done  : :%c Usage: %s [-suw] <filename>
	-s	Use shared locking
	-u	Unlock
	-w	Wait for the lock to become free, don't acquire lock

 Can't open %s
 Can't lock %s
 bsf bsfm bsr bss datacompression eom erase fsf fsfm fsr fss load lock mkpart nop offline rewoffline ras1 ras2 ras3 reset retension rewind seek setblk setdensity drvbuffer setpart tell wset unload unlock eof weof  /dev/tape unrecognized opcode %s At block %d
 afon: {%s}:  %7llo  real	%E
user	%u
sys	%T 	Command being timed: "%C"
	User time (seconds): %U
	System time (seconds): %S
	Percent of CPU this job got: %P
	Elapsed (wall clock) time (h:mm:ss or m:ss): %E
	Average shared text size (kbytes): %X
	Average unshared data size (kbytes): %D
	Average stack size (kbytes): %p
	Average total size (kbytes): %K
	Maximum resident set size (kbytes): %M
	Average resident set size (kbytes): %t
	Major (requiring I/O) page faults: %F
	Minor (reclaiming a frame) page faults: %R
	Voluntary context switches: %w
	Involuntary context switches: %c
	Swaps: %W
	File system inputs: %I
	File system outputs: %O
	Socket messages sent: %s
	Socket messages received: %r
	Signals delivered: %k
	Page size (bytes): %Z
	Exit status: %x -1 +vp Command terminated by signal %u
 Command exited with non-zero status %u
 %\ %uh %um %02us %um %u.%02us %u%% ?%% %u.%02u real %e
user %U
sys %S VFt:T: WDIOC_SETOPTIONS WDIOC_SETTIMEOUT .ko /lib/modules vqs can't insert '%s': %s /proc/modules %-24sSize  Used by Module /proc/sys/kernel/tainted     Tainted: %c%c%c
     Not tainted %-19s %8s %2s %s
 options include blacklist module %s not found in modules.dep can't unload module %s: %s /proc/cmdline 
	  can't load module %s (%s): %s q-v:v-q:l--ar:a--lr:r--al vqsalrb rmmod /etc/modprobe.conf /etc/modprobe.d invalid module format no such module unknown symbol in module, or unknown parameter module has wrong symbol version kernel does not support requested operation "%s"  wfas can't unload '%s': %s pub priv temp trail dontpub auto dev netmask  /proc/net/arp %s 0x%x 0x%x %s %s %s
 ether %s (%s) at  *  <incomplete>  %s [%s]  netmask %s   on %s
 No match found in %d entries
 inet %s: %s not supported address family A:p:H:t:i:adnDsv %s: unknown %s hardware type %s: kernel only supports 'inet' %s: %s without ARP support need host name need hardware address cant get HW-Address for '%s' protocol type mismatch invalid hardware address feature ATF_DONTPUB is not supported feature ATF_MAGIC is not supported 255.255.255.255 SIOCSARP No ARP entry for %s
 SIOCDARP(priv) SIOCDARP(pub) PERM PUP TRAIL  Sent %u probe(s) (%u broadcast(s))
Received %u repl%s (%u request(s), %u broadcast(s))
 eth0 interface %s %%s =1:Df:AU:c+ DUAqfbc:w:I:s: SIOCGIFFLAGS is not ARPable invalid source address %s setsockopt(SO_DONTROUTE) no IP address configured is not ARPable (no ll address) ARPING to %s  from %s via %s
 recvfrom Broad Uni %scast re%s from %s [%s] for %s  for   %u.%03ums
  UNSOLICITED? 425 Use PORT/PASV first
 ftpd 213-File status:
  Directory listing 421 Timeout
  FILE: uniq.XXXXXX  Ok to send data t+:T+:vv:SS vSwt:T: Operation successful
 Error
 %s[%u] 215 UNIX Type: L8
 -Features:  EPSV
 PASV
 REST STREAM
 MDTM
 SIZE
  Ok 213 %llu
 213 %04u%02u%02u%02u%02u%02u
 211-Server status:
 TYPE: BINARY
211 Ok
 0.0.0.0 227 PASV ok (%s,%u,%u)
 229 EPSV ok (|||%u|)
  Opening BINARY connection for %s (%llu bytes) 503 Use RNFR first
 500 Unknown command
  to  unexpected server response%s%s: %s cmd %s %s %s %s
 ftp anonymous busybox@ -2:vv:cc cvu:p:P: Connecting to %s (%s)
 r+ PASS TYPE I PASV SIZE REST %llu RETR STOR continue cverbose  vusername upassword pport P domain  dfqdn  ffile  F sethostname dfisF:v ether  bad: '%s' SIOGIFINDEX SIOC%s invalid hw-addr %s SIOCGIFMAP SIOCSIFFLAGS metric mtu txqueuelen dstaddr netmask broadcast hw pointopoint keepalive outfill mem_start io_addr add del trailers promisc multicast allmulti dynamic SIFMETRIC SIFDSTADDR SIFNETMASK SIFBRDADDR SKEEPALIVE SOUTFILL SIFMAP SIFADDR DIFADDR error: no inet socket available SIOCGIFCONF compressed Device not found %s: error fetching interface information: %s X bytes:%llu (%llu.%u %sB)%s %02X- [NONE SET] %-9s Link encap:%s   HWaddr %s   Media:%s (auto)           %s addr:%s   P-t-P:%s   Bcast:%s   Mask:%s
 /proc/net/if_inet6 %s:%s:%s:%s:%s:%s:%s:%s           inet6 addr: %s/%d  Scope: Global Site Compat Host Unknown %4s%4s%4s%4s%4s%4s%4s%4s %08x %02x %02x %02x %20s
            [NO FLAGS]   MTU:%d  Metric:%d RX packets:%llu errors:%lu dropped:%lu overruns:%lu frame:%lu
              compressed:%lu
 TX packets:%llu errors:%lu dropped:%lu overruns:%lu carrier:%lu
           collisions:%lu  compressed:%lu  txqueuelen:%d  
          R   T Interrupt:%d  Base address:0x%lx  Memory:%lx-%lx  DMA chan:%x  %02X:%02X:%02X:%02X:%02X:%02X %n%llu%u%u%u%u%n%n%n%llu%u%u%u%u%u %llu%llu%u%u%u%u%n%n%llu%llu%u%u%u%u%u %llu%llu%u%u%u%u%u%u%llu%llu%u%u%u%u%u%u 10base2 10baseT AUI 100baseT 100baseTX 100baseFX DARPA Internet IPv6 unspec UNSPEC loop Local Loopback Ethernet ppp Point-to-Point Protocol IPv6-in-IPv4    Ki Mi Gi Ti UP BROADCAST DEBUG LOOPBACK POINTOPOINT NOTRAILERS RUNNING NOARP PROMISC ALLMULTI SLAVE MASTER MULTICAST  address route r link tunnel tunl rule  netmask  mbroadcast  bnetwork  nprefix  phostname  hsilent  s -1:?2 mbnphs bad IP address: %s use prefix or netmask, not both bad netmask: %s NETMASK=%s
 BROADCAST=%s
 NETWORK=%s
 PREFIX=%i
 can't find hostname for %s HOSTNAME=%s
 listening on %s ...
 accept connect from wrong ip/port %s ignored IP options: %s
 connect to %s from %s (%s)
 can't execute '%s'  %8.8x  select net timeout
 net read bogus buffers: %u, %u too many output retries -e ?2:vv:w+ hnp:s:uvw:li:o:z bad local port '%s' no destination udptest first write %s (%s) open
 sent %llu, rcvd %llu
 punt!
 usage: %s <ip> "<message>"
 Opening socket setsockopt() sendto() fd socket:[ [0000]: %s: bogus data on line %d %s   %6ld %6ld %-23s %-23s %-12s laentuwxrWp 
Proto Recv-Q Send-Q %-23s %-23s State        %s   %6ld %6ld %-51s %-51s %-12s 
Proto Recv-Q Send-Q %-51s %-51s State        can't scan /proc - are you root? showing only processes with your user ID Active Internet connections  (servers and established) (only servers) (w/o servers) Local Address Foreign Address PID/Program name     /proc/net/tcp /proc/net/tcp6 /proc/net/udp /proc/net/udp6 /proc/net/raw /proc/net/raw6 Active UNIX domain sockets  
Proto RefCnt Flags       Type       State         I-Node  Path /proc/net/unix %X %*p: %lX %lX %lX %X %X %lu %n DGRAM STREAM RAW RDM SEQPACKET FREE LISTENING CONNECTED DISCONNECTING [  ACC  W  N  %-5s %-6ld %-11s %-10s %-13s %6lu  %08X%08X%08X%08X %*d: %64[0-9A-Fa-f]:%X %64[0-9A-Fa-f]:%X %X %lX:%lX %*X:%*X %*X %d %*d %ld  %.20s ESTABLISHED SYN_SENT SYN_RECV FIN_WAIT1 FIN_WAIT2 TIME_WAIT CLOSE CLOSE_WAIT LAST_ACK LISTEN CLOSING %-10s %s
 Address %u: %s%c can't resolve '%s': %s Server: Name: send failed executing '%s %s' %s=%u stratum %s=%ld freq_drift_ppm poll_interval %s=%f offset dd:p::wn nqNxwp:S:ld46aAbgL recv malformed packet received from %s: size %u settimeofday %a %b %e %H:%M:%S %Z %Y setting clock to %s (offset %fs) step adjtimex update peer:%s, offset:%f, clock drift:%ld ppm recv(%s) error malformed packet received from %s reply from %s: not synced, next query in %us reply from %s: reach 0x%02x offset %f delay %f status 0x%02x strat %d refid 0x%08x rootdelay %f sent query to %s timed out waiting for %s, reach 0x%02x, next query in %us poll %us, sockets:%u, poll interval:%us periodic  (DUP!) %d bytes from %s: seq=%u ttl=%d  time=%u.%03u ms 
--- %s ping statistics ---
 %lu packets transmitted,  %lu packets received,  %lu duplicates,  %lu%% packet loss
 round-trip min/avg/max = %u.%03u/%u.%03u/%u.%03u ms
 =1:q--v:v--q:c+:w+:W+ qvc:s:w:W:I:46 PING %s (%s) : %d data bytes
 setsockopt(ICMP6_FILTER) Destination Unreachable Packet too big Time Exceeded Parameter Problem Echo Reply Echo Request Listener Query Listener Report Listener Reduction unknown ICMP type warning: got ICMP %d (%s) can't set multicast source interface Source Quench Redirect (change route) Timestamp Request Timestamp Reply Information Request Information Reply Address Mask Request Address Mask Reply add del delete /proc/net/ipv6_route Kernel IPv6 routing table
%-44s%-40sFlags Metric Ref    Use Iface
 Destination Next Hop %32s%x%*s%x%32s%x%x%x%x%s
 fscanf %-43s %-39s %-5s %-6d %-2d %7d %-8s
 resolving %s SIOCADDRT SIOCDELRT gateway %s is a NETWORK netmask %.8x and host route conflict bogus netmask %s netmask and route address conflict /proc/net/route Metric Ref    Use   MSS Window  irtt Kernel IP routing table
Destination     Gateway         Genmask         Flags %s Iface
 %*[^
]
 %63s%lx%lx%X%d%d%d%lx%d%d%d
 %-15.15s %-15.15s %-16s%-6s %5d %-5d %6d %s
 %-6d %-2d %7d %s
 -net -host A:ne 	metric 
netmask gw 
gateway mss 	window irtt dev 	device 	 reject !mod "dyn #reinstate GHRDMDAC #net #host status %u/%u %s%s=%s -3:i--i:ph:vv:b+:c+ +c:C:i:x:u:l:Eb:hpt:v listening on %s, starting, uid %u, gid %u listening on %s, starting can't look up hostname for %s concurrency %s %u/%u start %u %s-%s start %u %s-%s (%s-%s) UDP TCP TCPORIGDSTADDR PROTO LOCALADDR REMOTEADDR LOCALHOST REMOTEHOST TCPCONCURRENCY got signal %u, exit ?exit end %d %s %d 
Entering character mode%s'^]'.
 
Entering line mode%s'^C'.
 
Console escape. Commands are:

 l	go to line mode
 c	go to character mode
 z	suspend telnet
 e	exit telnet
 continuing...
 telnet Connection closed by foreign host
 
Escape character is  /etc/issue.net f:l:Kip:b:F -1:x-x FIlnrdvxt:i:m:p:q:s:w:z:f:4 SO_SNDBUF setsockopt tos %d traceroute to %s (%s) , %d hops max, %d byte packets
 %2d setsockopt ttl %d sent %d octets, ret=%d packet too short (%d bytes) from %s
 OUT-OF-RANGE 
%d bytes from %s to %s: icmp type %d (%s) code %d
 %2d: x%8.8x
   %s (%s)  %d bytes to %s   %u.%03u ms  !  !N  !H  !P  !F-%d  !S  !A  !C  !V  !U  !I  !T  !<%d>   * ICMP 1 ICMP 2 Dest Unreachable Redirect ICMP 6 ICMP 7 Echo Router Advert Router Solicit Param Problem Timestamp Info Request Info Reply /proc/net/vlan/config ioctl error for %s  VLAN_PLUS_VID VLAN_PLUS_VID_NO_PAD DEV_PLUS_VID DEV_PLUS_VID_NO_PAD  add rem set_name_type set_flag set_egress_map set_ingress_map script %s %s failed, exitcode=%d =2:vv:vf fqr:v invalid link address SIOCGIFHWADDR start, interface %s iface %s is down deconfig inet inet6 link  protocol family 
oneline family 4 6 0  to scope up label dev  peer remote broadcast brd anycast scope dev label local  LOOPBACK BROADCAST POINTOPOINT MULTICAST NOARP UP LOWER_UP  peer anycast scope need "dev IFACE" "dev" (%s) must match "label" (%s) broadcast can be set only for IPv4 addresses can't send flush request nil ifname Deleted  %d: %s @NONE:  @%s:  NO-CARRIER, ,M-DOWN mtu %u  qdisc %s  master %s  state %s  SIOCGIFTXQLEN qlen %d %c    link/%s   peer   brd  wrong nlmsg len %d %u: %s     inet      inet6      family %d   peer %s/%d  brd %s  any %s  scope %s  secondary  tentative  deprecated  dynamic  flags %02x  valid_lft forever valid_lft %dsec  preferred_lft forever  preferred_lft %dsec        %s flush can't flush link addresses add delete list show lst flush  UNKNOWN NOTPRESENT DOWN LOWERLAYERDOWN TESTING DORMANT UP  on off  up down name mtu qlen multicast arp address dev  argument of "%s" must be "on" or "off" qlen "dev" SIOCGIFINDEX wrong address (%s) length: expected %d bytes SIOCSIFHWADDR SIOCSIFNAME SIOCSIFTXQLEN SIOCSIFMTU link name type dev  add delete set show lst list  /proc/sys/net/ipv4/route/flush protocol dev oif iif via table cache from to all root match exact main  Not a route: %08x %08x %08x
 default  from %s/%u  from %s  from 0/%u  via %s   src %s   metric %d  %c    cache  /proc/net/psched %*08x%*08x%08x%08x  expires %dsec  iif %s need at least destination address not a route? wrong len %d can't connect the route "ip route flush" protocol table can't flush routing cache can't send dump request unknown command %s add append change chg delete get list show prepend replace test flush  from iif oif dev notify connected to  src via mtu lock protocol table dev oif to metric  preference TOS fwmark table ID %u:	 from  %s/%u 0/%d to %s/%u  to 0/%d  tos %s  fwmark %#x  iif %s  lookup %s  realms %s/ map-to %s  masquerade from to preference order priority tos fwmark realms table lookup dev iif nat map-to type help  add delete list show  mode ipip ip/ip gre gre/ip sit ipv6/ip key ikey okey seq iseq oseq csum icsum ocsum nopmtudisc pmtudisc remote any local dev ttl inherit tos dsfield name  add change delete show list lst  SIOCGETTUNNEL %s tunnel mode you managed to ask for more than one can't guess ikey okey TTL TTL must be <=255 gre ipip keys are not allowed with ipip and sit broadcast tunnel requires a source address SIOCCHGTUNNEL SIOCADDTUNNEL ttl != 0 and noptmudisc are incompatible tunl0 gre0 sit0 can't determine tunnel mode (ipip, gre or sit) SIOCDELTUNNEL ipv6 any %s: %s/ip  remote %s  local %s  SIOCGIFNAME  dev %s   ttl %d   ttl inherit   tos  inherit %c%s   nopmtudisc  key %s  ikey %s   okey %s  %c  Drop packets out of sequence.
 %c  Checksum in received packet is required. %c  Sequence packets on output. %c  Checksum output packets. wrong format of /proc/net/dev %lu%lu%lu%lu%lu%lu%lu%*d%lu%lu%lu%lu%lu%lu%lu can't get type of [%s] deficit %d, rta_len=%d! can't talk to rtnetlink OVERRUN EOF on netlink sender address length == %d truncated message malformed message: len=%d! ERROR truncated RTNETLINK answers unexpected reply! message truncated remnant of size %d! dump terminated "%s" is invalid lladdr :%02x can't find device '%s' if%d generic loopback ether infiniband ieee802 tr ieee802.11 ieee1394 irda slip cslip slip6 cslip6 ppp ipip tunnel6 sit gre void eether ax25 pronet chaos arcnet atalk dlci atm metricom rsrvd adapt rose x25 hwx25 hdlc lapb ddcmp rawhdlc frad skip ltalk fddi bif ip/ddp pimreg hippi ash econet fcpp fcal fcpl fcfb0 fcfb1 fcfb2 fcfb3 fcfb4 fcfb5 fcfb6 fcfb7 fcfb8 fcfb9 fcfb10 fcfb11 fcfb12  [%d] database %s is corrupted at line %d main default /etc/iproute2/rt_tables /etc/iproute2/rt_dsfield /etc/iproute2/rt_realms global nowhere site /etc/iproute2/rt_scopes /etc/iproute2/rt_protos redirect kernel static gated mrt zebra bird local nat broadcast brd anycast multicast prohibit unreachable blackhole xresolve unicast throw  unicast blackhole unreachable prohibit throw nat xresolve ??? either "%s" is duplicate, or "%s" is garbage duplicate "%s": "%s" is the second value command line is not complete, try option "help" an %s %s is expected rather than "%s" "%s" may be inet %s, but it is not allowed in this context prefix  "
 $@clientid cclientid-none  Cvendorclass Vhostname Hfqdn Finterface inow  npidfile pquit  qrelease  Rrequest rscript stimeout Tversion  vretries ttryagain Asyslog  Srequest-option Ono-default-options  oforeground  fbackground  barping  aclient-port P Sending renew... Sending release... Packet with bad magic, ignoring %s%u.%u.%u.%u %s= %s%04X interface=%s ip= mask=%d siaddr= boot_file=%.128s sname=%.64s Unicasting a release of %s to %s Entering released state /usr/share/udhcpc/default.script udhcp 1.17.3 c--C:C--c:O::x::T+:t+:A+ c:CV:H:h:F:i:np:qRr:s:T:t:SA:O:ox:fbaP:v %s (v1.17.3) started Sending discover... leasefail No lease, forking to background No lease, failing Sending select for %s... Lease lost, entering init state Performing a DHCP renew Received SIGTERM Read error: %s, reopening socket no message type option, ignoring packet no server ID in message no lease time with ACK, using 1 hour lease Offered address is in use (got ARP reply), declining Sending decline... Lease of %s obtained, lease time %u bound Received DHCP NAK nak fSvP: /etc/udhcpd.conf max_leases=%u is too big, setting to %u Received SIGUSR1 MAC length != 6, ignoring packet not a REQUEST, ignoring packet no or bad message type option, ignoring packet Found static lease: %x no free IP addresses. OFFER abandoned Sending OFFER of %s Sending ACK to %s bad server IP absolute  aremaining  rfile f /var/run/udhcpd.leases =0:a--r:r--a arf: Mac Address       IP Address      Host Name           Expires %s
 expired %u days  %02u:%02u:%02u
  %-16s%-20s too many leases while loading %s can't parse line %u in %s 192.168.0.20 192.168.0.254 max_leases 235 auto_time 7200 decline_time 3600 conflict_time offer_time 60 min_lease lease_file pidfile /var/run/udhcpd.pid siaddr opt notify_file sname boot_file static_lease %s belongs to someone, reserving it for %u seconds socket(%s) bind(%s) connect MSFT 98 can't send signal SO_BROADCAST is interface %s up and configured? can't enable bcast on raw socket   malformed hex string '%s' option 0x%02x did not fit into the packet can't add option 0x%02x bad packet, malformed option field unknown option '%s', known options: %s , 	 , 	/- 11!	
(!)1*!,368BC+wx	y	

259<=  subnet timezone router dns lprsrv hostname bootsize domain swapsrv rootpath ipttl mtu broadcast nisdomain nissrv ntpsrv wins lease serverid message tftp bootfile search sipsrv staticroutes msstaticroutes ip6rd ip6rd wpad        %13s%13s%13s%13s%13s
 total used free shared buffers %6s%13lu%13lu%13lu%13lu%13lu
 Mem: %6s%13lu%13lu%13lu
 Swap: Total: unknown signal '%s' bad signal name '%s' you need to specify whom to kill %s: no process killed can't kill pid %d bad pid '%s' %d %s
 s+:P+ vlfxons:P: o:: so: %PPID -:ww Tw   PID USER       VSZ STAT COMMAND  mgtpezy %5u %-8.8s %s %s   error: '%s' must be of the form name=value error: malformed setting '%s' error: '%s' is an unknown key sett error %sing key '%s' %s =  error reading key '%s' +neAapw /etc/sysctl.conf /proc/sys # 	= 	MemTotal:  MemFree:   Buffers:   Cached:    
SwapTotal: 	SwapFree:  Dirty:     
Writeback: 
AnonPages: Mapped:    Slab:        100%  meminfo MemTotal: %lu %s
 Mem: %lu %lu %lu %lu %lu %lu MemFree: %lu %s
 MemShared: %lu %s
 Buffers: %lu %s
 Cached: %lu %s
 Mem: %luK used, %luK free, %luK shrd, %luK buff, %luK cached [H[J%s
 CPU%s:%susr%ssys%snic%sidle%sio%sirq%ssirq loadavg Load average: %s   PID  PPID USER     STAT   VSZ %MEM CPU %CPU COMMAND %6ldm %7ld 
%5u%6u %-8.8s %s%s%3u.%c %3d%3u.%c  Mem total:%s anon:%s map:%s free:%s [H[J%.*s
  slab:%s buf:%s cache:%s dirty:%s write:%s Swap total:%s free:%s   PID   VSZ VSZRW   RSS (SHR) DIRTY (SHR) STACK COMMAND 
%.*s can't read /proc/stat d:n:bm no process info in /proc cp%*s %llu %llu %llu %llu %llu %llu %llu %llu  %02d:%02d:%02d up  %d day%s,  %2d:%02d,  %d min,  load average: %ld.%02ld, %ld.%02ld, %ld.%02ld
  vi  pipefail  newline  redirection  word  ;  &  &&  ||  |  (  !  case  for  if  in  until  while  {    nrbtfavx\01234567 =: @= 







































































	





















































































































































 *?[  ugorwx   }  -  +  ?  =  %  %% #  ## :  /  //            
 
 	
 
()&|; }-+?= line %d:  Illegal number: %s %d: %m syntax error: %s parameter not set  or null %.*s: %s%s illegal option -%c no arg for -%c option %s: %s not found
 LP No previous job No current job %s: no such job %s: ambiguous job %s not created under job control %.*s: is read only %.*s: bad variable name OLDPWD illegal option %co %s %-16s%s
 set %co %s
 illegal option %c%c Built-in commands:
------------------
 %c%s out of file descriptors can't set tty process group (%m) can't access tty; job control turned off 

%s %s
Enter 'help' for a list of built-in commands.

 built-in shell (ash) You have stopped jobs.
 unexpected %s  (expecting %s) "$(...)" $(...) ${ ${# "} $(( )) >| <<... while   &&   |   ||  if  ; then  ; else  ; fi until  ; do  ; done  in  () { ... } )  ;;  >> >& <& %s=%s
 %lld usage: getopts optstring var [arg] OPTARG Illegal option -%c
 No arg for -%c option
 OPTIND  (core dumped) Done(%d) can't fork exponent less than 0 divide by zero expression recursion loop detected expression expected [%d]    Running 
%*c%d  %s%*c%s%s %.4o
 illegal mode: %s trap -- %s %s
 %s: invalid signal specification %lum%lu.%03lus%c %s%s%.*s%s
 np p:u:rt:n:s IFS  -%u CDPATH can't cd to %s [%d]   | %s bad fd number pipe call failed nonexistent directory can't create %s: %s no such file can't open %s: %s missing '))' unterminated quoted string missing '}' bad substitution EOF in backquote substitution illegal eof marker for << redirection bad for loop variable -o bad function name redir error 
Use "exit" to leave shell.
 PS1=\w \$  /etc/profile .profile ENV %builtin func %s not defined in %s  is a shell keyword alias   is an alias for %s  a tracked alias for  is%s %s  is a shell function special   is a %sshell builtin : not found
 pvV %s: not found _ PS1=$  PS2=>  PS4=+  OPTIND=1 eerrexit fnoglob Iignoreeof iinteractive mmonitor nnoexec sstdin xxtrace vverbose Cnoclobber aallexport bnotify unounset end of file ) ;; ` do done elif else esac fi then } 3. 3: 2[ 2[[ 6alias 2bg 3break 2cd 0chdir 2command 3continue 2echo 3eval 3exec 3exit 7export 2false 2fg 2getopts 0hash 0help 2jobs 2kill 0let 4local 2printf 0pwd 2read 7readonly 3return 3set 3shift 3source 2test 3times 3trap 2true 0type 0ulimit 2umask 2unalias 3unset 2wait <<= >>= << >> ,|| && != *<= k>= K== 
|= B&= "*= /= #%= C+= -= -- 3^= b++ ** /! 0< > += | & 	* / .% N+ 
- -^ ~ , ? : $) 4(   unlimited -%c: %-30s  bad number error setting limit read: '%s': not a valid identifier invalid timeout REPLY invalid count invalid file descriptor cpu time (seconds) data seg size (kb) stack size (kb) core file size (blocks) resident set size (kb) locked memory (kb) address space (kb) IFS= 	
 -HSaf::t::d::s::c::m::l::p::n::v::w:: c:n klogd started: %s klogd: error %d in klogctl(2): %m klogd: exiting semop[SMrup] can't find syslogd buffer can't access syslogd buffer can't get access to semaphores for syslogd buffer semop[SMrdn] p:st: unknown %s name: %s facility priority SMwdn SMwup /dev/console %s %.64s %s %s
 =0:R:: m:nO:l:Ss:b:R:LC::D /var/run/syslogd.pid shmget shmat semget syslogd started: BusyBox v1.17.3 read from /dev/log syslogd exiting alert crit debug emerg notice panic warn warning auth authpriv daemon kern lpr news security syslog uucp local0 local1 local2 local3 local4 local5 local6 local7 /var/log/messages s+:n+ cs:n: klogctl bcdoxCe:f:n:s:v "%07.7_Ax
" "%08.8_Ax
" "%08.8_ax  " 8/1 "%02x " "  " 8/1 "%02x "  "  |" 16/1 "%_p" "|\n" "%07.7_ax " 8/2 "%04x " "\n" "%07.7_ax " 16/1 "%03o " "\n" "%07.7_ax " 16/1 "%3_c " "\n" "%07.7_ax " 8/2 "  %05u " "\n" "%07.7_ax " 8/2 " %06o " "\n" "%07.7_ax " 8/2 "   %04x " "\n" r--ws:w--rs:s--wr:l--u:u--l lurswf: RTC_SET_TIME %s  0.000000 seconds
 localtime  lutc  ushow  rhctosys  ssystohc  wfile f invalid id: %s can't remove id %s resource(s) deleted illegal key (%s) permission denied for invalid unknown error in %s %s (%s) q:m:s:Q:M:S:h? %-10d %-10o  %-10s kernel not configured for %s
 shared memory ------ Shared Memory %s --------
 max number of segments = %lu
max seg size (kbytes) = %lu
max total shared memory (pages) = %lu
min seg size (bytes) = %lu
 segments allocated %d
pages allocated %ld
pages resident  %ld
pages swapped   %ld
Swap performance: %ld attempts	%ld successes
 Segment Creators/Owners %-10s %-10s %-10s %-10s %-10s %-10s
 shmid perms cuid cgid Attach/Detach/Change Times %-10s %-10s %-20s %-20s %-20s
 owner attached detached Creator/Last-op cpid lpid Segments %-10s %-10s %-10s %-10s %-10s %-10s %-12s
 nattch %-10d %-10.10s %-10d %-10d Not set  %-20.16s  %-20.16s
 0x%08x  dest  %-10o %-10lu %-10ld %-6s %-6s
 semaphores ------ Semaphore %s --------
 max number of arrays = %d
max semaphores per array = %d
max semaphores system wide = %d
max ops per semop call = %d
semaphore max value = %d
 used arrays = %d
allocated semaphores = %d
 Arrays Creators/Owners semid Operation/Change Times %-8s %-10s %-26.24s %-26.24s
 last-op last-changed Arrays nsems %-8d %-10.10s %-8d %-10d   %-26.24s %-10d %-10.9s %-10d %-9d  %-10o %-10ld
 message queues ------ Message%s --------
 s: Limits max queues system wide = %d
max size of message (bytes) = %d
default max size of queue (bytes) = %d
 s: Status allocated queues = %d
used headers = %d
used space = %d bytes
  Queues: Creators/Owners msqid  Queues Send/Recv/Change Times %-8s %-10s %-20s %-20s %-20s
 send change  Queues PIDs lspid lrpid  Queues %-10s %-10s %-10s %-10s %-12s %-12s
 used-bytes   %5d     %5d
  %-10o %-12ld %-12ld
 i:aqsmtcplu shmctl 
Shared memory Segment shmid=%d
uid=%d	gid=%d	cuid=%d	cgid=%d
mode=%#o	access_perms=%#o
bytes=%ld	lpid=%d	cpid=%d	nattch=%ld
 att_time=%-26.24s
 det_time=%-26.24s
 change_time=%-26.24s

 semctl 
Semaphore Array semid=%d
uid=%d	 gid=%d	 cuid=%d	 cgid=%d
mode=%#o, access_perms=%#o
nsems = %ld
otime = %-26.24s
 ctime = %-26.24s
%-10s %-10s %-10s %-10s %-10s
 semnum ncount zcount %-10d %-10d %-10d %-10d %-10d
 msgctl 
Message Queue msqid=%d
uid=%d	gid=%d	cuid=%d	cgid=%d	mode=%#o
cbytes=%ld	qbytes=%ld	qnum=%ld	lspid=%d	lrpid=%d
 send_time=%-26.24s
 rcv_time=%-26.24s
 ?2:d--of:o--df:f--do do:f /dev/loop%d  := mknv /sys/bus/pci/devices /uevent DRIVER PCI_CLASS PCI_ID PCI_SUBSYS_ID PCI_SLOT_NAME %s "Class %04x" "%04x" "%04x" "%04x" "%04x" %s Class %04x: %04x:%04x /sys/bus/usb/devices DEVTYPE PRODUCT BUSNUM DEVNUM \/= Bus %s Device %s: ID %04x:%04x
 SWAPSPACE2L: Setting up swapspace version 1, size = %llu bytes
 UUID=%.8s-%.4s-%.4s-%.4s-%.12s
 --More--  (%u%% of %llu bytes) 
%*s
 (Enter:next line Space:next page Q:quit R:show the rest) mount('%s','%s','%s',0x%08lx,'%s'):%d %s,%.*s would do mount('%s','%s','%s',0x%08lx,'%s') mount.%s %s is write-protected, mounting read-only can't setup loop device nodev mounting %s on %s failed ?2o::vv o:t:rwanfvsiO: rw no %s %s on %s type %s (%s)
 /etc/fstab can't read '%s' swap according to %s, %s is already mounted on %s can't find %s in %s /etc/filesystems  /proc/filesystems loop defaults noauto sw swap _netdev nosuid suid dev nodev exec noexec sync dirsync async atime noatime diratime nodiratime mand nomand relatime norelatime loud union bind move shared slave private unbindable rshared rslave rprivate runbindable union ro rw remount  timeout connecting to time server sp %s did not send the complete time current time matches remote time can't set time of day noauto -2 +c: /init /init is not a regular file root filesystem is not ramfs/tmpfs error moving root fldnravdt:i can't remount %s read-only %s busy - remounted read-only forcibly  can't %sumount %s UUID= LABEL=  LABEL="%s"  UUID="%s" XFSB _BHRfS_M NTFS MSWIN FAT32    FAT16    MSDOS FAT12    NO NAME     CD001 %/@ %/C %/E CDROM SWAP-SPACE SWAPSPACE2 S1SUSPEND S2SUSPEND ULSUSPEND FILE ReIsErFs ReIsEr2Fs ReIsEr3Fs ReIsEr4 NSR02 NSR03 BEA01 BOOT2 CDW02 TEA03 %02X%02X-%02X%02X %02X%02X%02X%02X%02X%02X%02X%02X %02x%02x%02x%02x-%02x%02x-%02x%02x-%02x%02x-%02x%02x%02x%02x%02x%02x '%s' is bigger than ar can handle %-16.16s%-12lu%-6u%-6u%-8o%-10llu`
 --:-1:p:t:x:r vocptxr !<arch>
 %.15s/ %s %u/%u%7llu %s %s
 invalid magic tgz error inflating %s: unknown suffix - ignored compressed data not read from terminal, use -f to force it cfvdt xz cfvdtn s2 cfvdt123456789qzs internal error %d extract  ilist  tcreate  oformat Hpass-through  pverbose  vquiet  to-stdout   070701%08X%08X%08X%08X%08X%08X%08X%08X%08X%08X%08X%08X00000000%s%c ?1 it0uvdmLF:oH:p %llu blocks
 TRAILER!!! Package Version Pre-Depends Depends Replaces Provides Conflicts Suggests Recommends Enhances  configure  Cforce Finstall  ilist  lpurge  Premove  runpack  uforce-depends  force-confnew  force-confold   control.tar.gz control.tar.bz2  
 ANY  ( <=> << <= >= illegal operator  ) DEBUG ONLY: this shouldnt happen /var/lib/dpkg/info/%s.%s %s failed, exit code %d Setting up %s (%s)...
 postinst Removing %s (%s)...
 prerm conffiles postrm config-files Purging %s (%s)...
 Preparing to replace %s %s (using %s)...
 md5sums Unpacking %s (from %s)...
 ./%s preinst data.tar.gz data.tar.bz2 unpacked Warning: Creating %s as %s.dpkg-new
 %s.dpkg-new *.dpkg-new CilPruF: depends confnew confold /var/lib/dpkg/status Status:  
	     Name           Version +++-==============-============== %c%c  %-14s %s
 ./control can't extract control file invalid control file in %s install reinstreq not-installed reinstreq package %s is uninstalled or unknown %s is already removed deinstall %s is already purged purge no package files specified package %s conflicts with %s fatal error, package dependencies corrupt: %d != %d - 1 Have a provider but no package information for it pre- package %s %sdepends on %s, which cannot be satisfied is not installed or flagged to be installed is installed is marked to be removed is marked to be purged is in an indeterminate state is marked to be installed package %s %sdepends on %s, which %s
 /var/lib/dpkg/status.udeb Package: ok Status: %s

 ALERT: cannot find a control file, your status file may be broken, status may be incorrect for %s Package: %s
 Status: %s
 Priority Section /var/lib/dpkg/status.udeb.bak can't create backup status file no status file found, creating new one shlibs templates data.tar.lzma control.tar.lzma c--efXx:e--cfXx:f--ceXx:X--cefx:x--cefX cefXx ./DEBIAN stdout  cto-stdout  cforce  fverbose  vdecompress  duncompress  dtest  tquiet  qfast  1best  9                          cfvdtq123456789n  	

    		



cfvdt123456789CF %s.out %s.lzo checksum error this file is a split lzop file corrupted data bad magic number header_error %d internal error internal error - compression failed internal error - optimization failed LZO 

iqpldc error reading rpm header %s-%s-%s
 (not relocateable) Name        : %-29sRelocations: %s
 (none) Version     : %-34sVendor: %s
 %a %d %b %Y %T %Z Release     : %-30sBuild Date: %s
 Install date: %-30sBuild Host: %s
 (not installed) Group       : %-30sSource RPM: %s
 Size        : %-33dLicense: %s
 URL         : %s
 Summary     : %s
 Description :
%s
 %s.rpmorig invalid RPM header magic or unsupported version invalid RPM magic no gzip/bzip2/xz magic error unpacking 0000000 0000000 0000000 00000000000 00000000000 bzip2 gzip can't stat tar file error exit delayed from previous errors waitpid --:tt:vv:?:X::T::::c:t:x:c--tx:t--cx:x--ct txC:f:OopvkchjaT:X:zZm TAR_FILETYPE=f empty archive %s: not found in archive %0*llo ustar   ././@LongLink can't store file '%s' of size %llu, aborting %s: unknown file type removing leading '/' from member names %s: socket ignored %s: file is the archive; skipping list  textract  xdirectory Cfile fto-stdout  Ono-same-owner  osame-permissions  pverbose  vkeep-old  kcreate  cdereference  hbzip2  jlzma  afiles-from Texclude-from Xgzip  zcompress  Ztouch  mto-command numeric-owner  no-same-permissions  overwrite  exclude  -d:lnopqxv can't open %s, %s.zip, %s.ZIP Archive:  %s
   Length     Date   Time    Name
 --------    ----   ----    ---- invalid zip magic %08X unsupported method %d zip flags 1 and 8 are not supported %9u  %02u-%02u-%02u %02u:%02u   %s
    creating: %s
 '%s' exists but is not directory replace %s? [y]es, [n]o, [A]ll, [N]one, [r]ename:  can't read input '%s' exists but is not regular file   inflating: %s
 inflate error crc error new name:  error: invalid response [%c]
  --------                   -------
%9lu                   %u files
      .zip .ZIP can't remove old file %s can't stat old file %s not created: newer or same age file exists can't create %slink from %s to %s hard can't make dir %s sym can't create node %s unrecognized file type TAR_%s=%s TAR_%s=%llu TAR_%s=%lo MODE '%s' returned status %d '%s' terminated on signal %d REALNAME UNAME UID GID CRC error bunzip error %d compressed with %d bits, can only handle 16 bits insize:%d posbits:%d inbuf:%02X %02X %02X %02X %02X (%d)     unexpected EOF bad lzma header 7zXZ  YZ     @@@    		



         ccunexpected end of file incorrect length  	

07070 unsupported cpio format, use newc or crc %8x%8x%8x%8x%8x%8x%8x%*16c%8x%8x%8x damaged cpio file TRAILER!!!      corrupted octal value in tar header ustar invalid tar magic invalid tar header checksum warning: skipping header '%c' unknown typeflag: 0x%x /../ name with '..' encountered: '%s' invalid gzip magic %s %s/%s %9llu %4u-%02u-%02u %02u:%02u:%02u %s  -> %s seek failure !<arch> invalid ar magic invalid ar header can't resolve long filename  / [H[J m:C: unsupported psf file mode input file: bad length or unsupported font type input file: bad length bad character size %dx%d KDFONTOP PIO_UNIMAPCLR PIO_UNIMAP map format c(K[J[0m[?25h stty sane %*s%*s jy %B %a %*s%s
%s
 
%s%*s%s  etv ^? M- ^%c invalid mode '%s' Rh recursive  Rdereference  no-dereference  h -i %u %lli
 %u %lli %s
 =2 123 archive  aforce  finteractive  ilink  ldereference  Lno-dereference  Precursive  Rsymbolic-link  sverbose  vparents   -2:l--s:s--l:Pd:rRd:Rd:apdR pdRfilsLHarPv with --parents, the destination must be a directory b:c:f:d:sn  only when operating on fields b--bcf:c--bcf:f--bcf expected a list of bytes, characters, or fields the delimiter must be a single character suppressing non-delimited lines makes sense%s a delimiter may be specified%s missing list of positions date hours minutes seconds  TZ=UTC0 d--s:s--d:R--I:I--R Rs:ud:r:I::D: can't set date %Y-%m-%dT%H:%M:%S %a, %d %b %Y %H:%M:%S  %s%0*u%s %Y.%m.%d-%H:%M:%S rfc-822  Rrfc-2822  Rset sutc  udate dreference r notrunc sync noerror fsync  bs count seek skip if of ibs obs conv  writing '%s' %llu+%llu records in
%llu+%llu records out
 %llu bytes (%sB) copied,  %f seconds, %sB/s
 conv k-mB:m-Bk:B-km kPaiB:hm POSIXLY_CORRECT      Size    Inodes %s-blocks Use% Capacity Filesystem           %-15sUsed Available %s Mounted on
 %s: can't find mount point rootfs 
%-20s  %9s  %9s %3u%% %s
 u--d:d--u du %sXXXXXX %s	%s
 h-km:k-hm:m-hk:H-L:L-H:s-d:d-s:d+ aHkLsxd:lchm neE ignore-environment  iunset u u:: +iu: putenv initial  itabs t it: ft:a %s%*s %*s%.*s first-only  itabs tall  a quote length match index substr  warning: '%s': using '^' as the first character
of a basic regular expression is not portable; it is ignored non-numeric argument division by zero syntax error != too few arguments %lld
 80 -w%s bsw: n:c:qv 
==> %s <==
 %lx
 ?1:u--g:g--u:G--u:u--G:g--G:G--g:r?ugG:n?ugG rnugG  gid=  euid=  egid=  groups= can't get groups s--d:d--s cvbDdpsg:m:o: strip -p can't change %s of %s permissions ownership directory  dpreserve-timestamps  pstrip  sgroup gmode mowner o sfnbS: getlogin ##%"%## %$%#%%      |  /     @ =    color  Cadil1gnsxQAkcetuSXrvFpLRhT:w: %7llu  %4llu  %-10s  %4lu  %-8.8s %-8.8s  %-8u %-8u  %4u, %3u  %7s  %9llu  %.24s  %.6s  %.5s   %.4s  [%u;%um  ->  %s:
 T+:w+ LS_COLORS always yes force auto tty if-tty  algorithm not supported scwbt -%c is meaningful only when verifying checksums only one argument may be specified when using -c %s: OK
 %s: FAILED
 WARNING: %d of %d computed checksums did NOT match %s  %s
 m:p mode mparents  p pcub interactive  iforce  f -2:f-i:i-f mv: overwrite '%s'?  can't rename '%s' non- can't remove '%s' can't overwrite %sdirectory with %sdirectory setpriority(%d) nohup.out appending output to %s aBbcDdeFfHhIiLlOoXxv "%07.7_Ao
" "%07.7_ao  " "         " "%07.7_ao  " 8/2 "%06o " "\n" 16/1 "%3_u " "\n" 4/4 "     %010u " "\n" 2/8 "          %21.14e " "\n" 4/4 " %14.7e " "\n" 4/4 "       %08x " "\n" 4/4 "    %11d " "\n" 8/2 " %6d " "\n" 4/4 "    %011o " "\n"  	


	%s: invalid number .* usage: printf FORMAT [ARGUMENT...] -+ # %s: invalid format diouxXfeEgGcs fnvsq fiRrv can't remove '.' or '..' parents  pignore-fail-on-non-empty   +ws: %s%0*.*f 0123456789. ngMucszbrdfimS:T:o:k:t: bad field specification unknown sort type %b o--o:t--t:k:: bad -t parameter unknown key option Check line %u
 ?2:a+ l:b:a: suffix too long suffixes exhausted ftLc: #-+.I 0123456789 can't read file system information for '%s'   File: "%n"
    ID: %-8i Namelen: %-7l Type: %T
Block size: %-10s
Blocks: Total: %-10b Free: %-10f Available: %a
Inodes: Total: %-10c Free: %d %n %i %l %t %s %b %f %a %c %d
 %n %s %b %f %u %g %D %i %h %t %T %X %Y %Z %o   File: %N
  Size: %-10s	Blocks: %-10b IO Block: %-6o %F
Device: %Dh/%dd	Inode: %-10i  Links: %-5h Device type: %t,%T
Access: (%04a/%10.10A)  Uid: (%5u/%8U)   Gid: (%5g/%8G)
Access: %x
Modify: %y
Change: %z
   File: %N
  Size: %-10s	Blocks: %-10b IO Block: %-6o %F
Device: %Dh/%dd	Inode: %-10i  Links: %h
Access: (%04a/%10.10A)  Uid: (%5u/%8U)   Gid: (%5g/%8G)
Access: %x
Modify: %y
Change: %z
 llx %Y-%m-%d %H:%M:%S.000000000 '%s' -> '%s' regular empty file block special file character special file fifo symbolic link weird file affs devpts ext2 ext2/ext3 jfs xfs hpfs isofs minix minix (30 char.) minix v2 minix v2 (30 char.) msdos fat novell nfs smb xenix sysv4 sysv2 coh ufs xia ntfs reiserfs cramfs romfs squashfs sysfs %s %s: no size information for this device %lu
     speed %lu baud; %lu %lu
 ispeed %lu baud; ospeed %lu baud; evenp parity oddp nl ek sane cooked raw pass8 litout cbreak crt dec decctlq tabs lcase LCASE parenb parodd cs5 cs6 cs7 cs8 hupcl hup cstopb cread clocal crtscts ignbrk brkint ignpar parmrk inpck istrip inlcr igncr icrnl ixon ixoff tandem iuclc ixany imaxbel opost olcuc ocrnl onlcr onocr onlret ofill ofdel nl1 nl0 cr3 cr2 cr1 cr0 tab3 tab2 tab1 tab0 bs1 bs0 vt1 vt0 ff1 ff0 isig icanon iexten echo echoe crterase echok echonl noflsh xcase tostop echoprt prterase echoctl ctlecho echoke crtkill  intr quit erase kill eof eol eol2 swtch start stop susp rprnt werase lnext flush min time  line rows cols columns size speed ispeed ospeed  ^- undef %u %u
 rows %u; columns %u; %lx:%lx:%lx:%lx%n :%x%n only one device may be specified -F invalid argument '%s' verbose and stty-readable output styles are mutually exclusive modes may not be set when specifying an output style %s: cannot perform all requested operations %lx:%lx:%lx:%lx :%x <undef> %s = %s; min = %u; time = %u;     
	

 %d %llu %s
 %05d %5llu %s
 sr s+:Ff fc:n:qs:vF no files been replaced appeared %s has %s; following end of new file %s has become inaccessible w a -r -w -x -e -f -d -c -b -p -u -g -k -s -t -z -n -h -O -G -L -S = == != < > -eq -ne -ge -gt -le -lt -nt -ot -ef ! -a -o ( )  out of range argument expected closing paren expected missing ] missing ]] %s: unknown operand         	     
       
  !"#$%&cfma alpha:] alnum:] digit:] lower:] upper:] space:] blank:] punct:] cntrl:] xdigit:]  +Ccds STRING2 cannot be empty not a tty snrvmpioa all  akernel-name  snodename  nkernel-release  rrelease  rkernel-version  vmachine  mprocessor  phardware-platform  ioperating-system  o GNU/Linux f+:s+:w+ cduf:s:w: %7lu  begin-base64  begin  no 'begin' line short file -base64 begin%s %o %s 
====
 
`
end
 lwcL  %9llu TMPDIR /tmp dqtp: tmp.XXXXXX /proc/%u/cmdline /proc/%u/stat /proc/%u K:S:K--S:S--K:m?p:K?xpun:S?xa KSbqtma:n:s:u:c:x:p: open pidfile %s nothing in /proc - not mounted? process in pidfile '%s' process(es) owned by '%s' internal error, please report no %s found; none killed
 warning: killing process %u stopped %s (pid %s is already running
%u
 Not an array Possible syntax error %u %u %u %u %u %u %d %s:%i: %s diouxX eEfgG popen %s%s%s %a %b %d %H:%M:%S %Z %Y RSTART RLENGTH %*x formats are not supported /dev/stdin /dev/stdout /dev/stderr v::f:: F:v:f:W: cmd. line warning: unrecognized option '-W %s' ignored awk Could not open file.
 Internal error Too few arguments for builtin %.6g %.6g     
 
      Unexpected end of string Division by zero ()/>>>|++--++--$===+=-=*=/=%=^=+-**=**/%^*!=>=<=><!~~&&||?:in,|+-!]{};
ifdoforbreakcontinuedeleteprintprintfnextnextfilereturnexitwhileelseandcompllshiftorrshiftxorclosesystemfflushatan2cosexpintlograndsinsqrtsrandgensubgsubindexlengthmatchsplitsprintfsubsubstrsystimestrftimemktimetolowertouppergetlinefuncfunctionBEGINEND  Unexpected token Call to undefined function Invalid format specifier CONVFMT OFMT FS *OFS ORS RS *RT FILENAME SUBSEP $ *ARGIND ARGC ARGV ERRNO FNR NR NF *IGNORECASE *ENVIRON   %.0s%.0s%llu %3o %3o
 cmp: EOF on %s
 sl -1:?2:l--s:s--l %s %s differ: char %llu, line %u
 Files %s and %s differ
 Files %s and %s are identical
 
\ No newline at end of file mkstemp --- %s
 +++ %s
  %c%d ,%d  @@ /tmp/difXXXXXX =2:L::U+ abdiL:NqrsS:tTU:wupBE can't compare stdin to a directory Only in %s: %s
 Common subdirectories: %s and %s
 File %s is not a regular file or directory and was skipped
 File %s is a %s while file %s is a %s
 ignore-case  iignore-tab-expansion  Eignore-space-change  bignore-all-space  wignore-blank-lines  Btext  aunified Ulabel Lshow-c-function  pbrief  qexpand-tabs  tinitial-tab  Trecursive  rnew-file  Nreport-identical-files  sstarting-file Sminimal  d line number %d does not exist bad line range for %s inserting at bad line number bad line for read "%s",   (incomplete) %d lines%s, %d chars
 delete search no previous search string can't find string "%s" bad mark name print $
 bad file command No file name bad quit command Really quit?  bad read command no file name bad delimiter for substitute missing 2nd delimiter for substitute unknown option for substitute no substitutions found for "%s" bad write command no file name specified %d lines, %d chars
 no arguments allowed unimplemented command DO %d: %s
 Hunk %d FAILED %ld/%ld.
 Rup:i:Nx HUNK:%s
 MATCHEOF=%c
 Possibly reversed hunk %d at %ld
 INEOF
 IN: %s
 NOT: %s
 MAYBE: %s
 ---  +++  /dev/null @@ - removing %s
 creating %s
 mkpath '%s' patching file %s
 no temp file +- -+ unmatched '%c' bad format in substitution expression empty filename %s
%s 

 no address after comma missing command bad option in substitution expression aic only a beginning address can be specified for edit commands command only uses one address :btT dDgGhHlnNpPqx={} unsupported command %c unterminated { no previous regexp can't find label for jump to '%s' --version This is not GNU sed version 4.0 e::f::nn irne:f: can't create temp file %s ; 

	 -IR- These features are available:
	Pattern searches with / and ?
	Last command repeat with '.'
	Line marking with 'x
	Named buffers with "x
	Readonly if vi is called as "view"
	Readonly with -R command line arg
	Some colon mode commands with ':'
	Settable options with ":set"
	Signal catching- ^C
	Job suspend and resume with ^Z
	Adapt to window re-sizes [7m "%s" %s "%s" Not a regular file Trying to insert file outside of memory can't read all of file "%s" (NULL) '%s' is not implemented Put %d lines (%d chars) from [%c] !"#$%&'()*+,-./:;<=>?@[\]^_`{|}~ No current filename [A can't read user input last_modifying_cmd overrun %d%n No file  [Readonly]  [Modified] %c %s%s%s %d/%d %d%%  )]} [Hit return to continue] 
shell returned %i

 No write since last change (:edit! overrides)  [New file] "%s"%s%s %dL, %dC No address allowed on this command features $
 quit next No write since last change (:%s! overrides) %d more file(s) to edit No more files to edit No filename given "%s"%s %dL, %dC rewind No write since last change (:rewind! overrides) no %sautoindent %sflash %signorecase %sshowmatch tabstop=%u autoindent  ai flash  fl ignorecase  showmatch  sm tabstop= 1.17.3 2011-09-09 14:52:02 CST wq "%s" File is read only "%s" %dL, %dC yank Yank %d lines (%d chars) into [%c] :s expression missing delimiters Nothing in register %c ()[]{} Pattern not found search hit TOP, continuing at BOTTOM search hit BOTTOM, continuing at TOP Write error: %s wW ^0bBeEft%$ lh cdykjHL+-{}
 Change Delete Yank %s %d lines (%d chars) using [%c] cdy>< ^%$0bBeEfth H-k{ L+j}
 ^0bBh [999;999H[6n %d%c EXINIT hCRHc: cCdDJoOpPrRxX<>~ -exec unpaired '(' -type unrecognized: %s -follow -xdev -mindepth -maxdepth  -a -o ! -print -print0 -depth -prune -delete -exec ( -name -iname -path -regex -type -perm -mtime -mmin -newer -inum -user -group -size -links  %i%c H-h:C-AB:e::f::m+:A+:B+:C+ lnqvscFiHhe:f:Lorm:wA:B:C:EaI (standard input) +trn:s:e::E:px0 can't fit single argument within argument list size limit argument line too long  ?... %s: exited with status 255; aborting %s: terminated by signal %d double single unmatched %s quote hpr d:nfwi sysinit wait once respawn askfirst ctrlaltdel shutdown restart  reboot umount -a -r swapoff -a /dev/tty2 /dev/tty3 /dev/tty4 /etc/init.d/rcS /dev/ Bad inittab entry at line %d #: ~`!$^&*()=|\{}[];"'<>? exec  -/bin/sh can't run '%s': %s starting pid %d, tty '%s': '%s' reloading /etc/inittab -q CONSOLE TERM=vt102 TERM=linux HOME=/ SHELL=/bin/sh USER=root RUNLEVEL init started: %s Low memory, forcing swapon mount -t proc proc /proc swapon -a process '%s' (pid %d) exited. Scheduling for restart. The system is going down NOW! Sent SIG%s to all processes KILL poweroff halt Requesting system %s 
Please press Enter to activate this console.  ttyname is n is y unknown gid %u unknown uid %u unknown group %s unknown user %s can't set groups %s: overwrite '%s'?  can't create '%s' '%s' and '%s' are the same file recursion detected, omitting directory '%s' target '%s' is not a directory can't create directory '%s' can't preserve %s of '%s' can't create link '%s' error writing to '%s' can't create symlink '%s' unrecognized file '%s' with mode %x aa illegal character '%c' cdiouxXeEfgG  \0 \a \b \b 
\n 
\r 	\t \v  bad format {%s} bad byte count for conversion character %s   %%s requires a precision or a byte count bad conversion character %%%s byte count with multiple conversion characters  -0+# %03o diouxX .#-+ 0123456789 nul soh stx etx eot enq ack bel bs _ht _lf _vt _ff _cr _so _si _dle dcl dc2 dc3 dc4 nak syn etb can em _sub esc fs _gs _rs _us image size is too big image is too small /dev/ptmx ptsname error (is /dev/pts mounted?) can't find free pty  123456789 %llu.%u%c %llu%*c  KMGTPEZYgetnameinfo failed getaddrinfo: %s: %d ~%s  `"#$%^&*()=+{}[]:;'|\<> [%uD 
[%uA [%uC %s%-*s [H  %A, %d %B %Y ENV BASH_ENV HOME IFS SHELL LD_LIBRARY_PATH LD_PRELOAD LD_TRACE_LOADED_OBJECTS LD_BIND_NOW LD_AOUT_LIBRARY_PATH LD_AOUT_PRELOAD LD_NOWARN LD_KEEPDIR   login:  %H:%M:%S %llu %s set permissions of create can't %s directory '%s'  	

 
	


 	 

		
?pc?d?b?-?l?s???rwxSTst/proc/mounts too short similar to username similar to gecos similar to hostname too many similar characters too weak similar to old password Bad password: %s
 bad line %u: %d tokens found, %d needed augo rwxXst abefnrtv\ 

	\\/proc/%u/task /proc/%u/ smaps Shared_Clean: Shared_Dirty: Private_Clean: Private_Dirty: /dev/zero
 [stack]
 OOOOOO[[[[[[[1[2[3[4[5[6[7[8[1;5ü[1;5Ļ read error from '%s' %s: is a directory %s: descend into directory '%s'?  can't close '%s' %s: remove directory '%s'?  %s: remove '%s'?  TZ RTC_RD_TIME /dev/rtc /dev/rtc0 /dev/misc/rtc /var/lib/hwclock/adjtime UTC poll can't chdir to home directory '%s' LOGNAME EXIT   HUP    INT    QUIT   ILL    TRAP   ABRT   BUS    FPE    KILL   USR1   SEGV   USR2   PIPE   ALRM   TERM   STKFLT CHLD   CONT   STOP   TSTP   TTIN   TTOU   URG    XCPU   XFSZ   VTALRM PROF   WINCH  POLL   PWR    SYS    SIG %s+ warning: can't create backup copy '%s' warning: can't lock '%s' %s%s%s
 ,%s `!"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=
 number %s is not in %llu..%llu range invalid number '%s' number %s is not in %lld..%lld range local:%.*s [%s]:%s local: bad address '%s' bad port spec '%s' can't connect to remote host can't bind to interface %s getcwd not a symlink %s: cannot read link: %s bad regex '%s': %s unknown user/group %s                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     @               f            X  
   u     0
          0
          (            
   
                  1
    H
                ȭ     H         oh  o   o                                                  0
         d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d  d      	 @6
        X    8
 H	    H	    H	    H	     H	    
	    z7	    /    H	    H	     H	    H	        H	     H	 P    H   H	    N X   H	     H	 0       F!	    H	 8   H	     H	 (       I	 @   I	    I	    I	     I	    'I	    .I	    5I	    <I	        A&   aeabi    5TE 	GCC: (GNU) 4.3.3  .shstrtab .interp .hash .dynsym .dynstr .gnu.version .gnu.version_r .rel.dyn .rel.plt .init .text .fini .rodata .ARM.exidx .eh_frame .init_array .fini_array .jcr .dynamic .got .data .bss .ARM.attributes .comment                                                                                    (  (  	                          
  p              !              
                 )   o     *                 6   o   h  h-  `                E   	      ȭ  -  H                N   	        .  H
     
         W         X  X8                    R         d  d8                  ]           G                  c         u                    i         u  J8                q     p   	 .	                  |         $	 $.	                             0
  0	                            0
 0	                            0
 0	                            0
 0	                          1
 1	 <                         @6
 @6	 @                          7
 7	 ($                      p        7	 '                        0       7	                                7	                                                                                                                                                                                                                                                                                                                                                                                   pre_diag/toolsmvl/uuidgen                                                                           0000755 0000000 0000000 00000121506 12667754516 014623  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   ELF          (    ̌  4       4    ( & #   p"                     4   4  4                 4  4  4                           "  "           "  " "              "  " "                H  H  H                Qtd                          /lib/ld-linux.so.3           GNU              %   5       1   +                     	   .          /          %   $   !   )   2   ,                              0   (       -   '   #      4                                                                                                                                           
   "                      &               
      *   3                     t                                                i                                   Ȋ         %               4                                       ,           H                                  F  (           4         U  @            L            X           d         [  p            |                     3                       @                      %  ċ            Ћ            ܋         p                      h            -           T              $         x  0            <            H            T           `           l            x         9  $                                                    M           ]                libgcc_s.so.1 __register_frame_info __gmon_start__ _Jv_RegisterClasses __emutls_get_address __deregister_frame_info libc.so.6 socket fflush exit execl sprintf setlocale ftruncate dcgettext connect strncpy puts fork time abort getpid rewind jrand48 getppid memset __errno_location read getopt memcpy fclose umask stderr ioctl getuid fscanf fwrite gettimeofday srandom waitpid fprintf fdopen syscall fcntl __xstat bindtextdomain access __libc_start_main sysconf GCC_4.3.0 GLIBC_2.4                                                                        `_'	           u          ii
         $ 	  $ .  #   #   #   #   #   #   #   #   # 	  #   #   # 
  #   #    $   $   $   $   $   $   $   $    $   $$   ($   ,$   0$   4$   8$   <$   @$    D$ !  H$ "  L$ #  P$ $  T$ %  X$ &  \$ '  `$ (  d$ )  h$ *  l$ +  p$ ,  t$ -  x$ /  |$ 0  $ 1  $ 2  $ 3  $ 4  @-  -L   Ə	ʌL Ə	ʌD Ə	ʌ< Ə	ʌ4 Ə	ʌ, Ə	ʌ$ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ| Ə	ʌt Ə	ʌl Ə	ʌd Ə	ʌ\ Ə	ʌT Ə	ʌL Ə	ʌD Ə	ʌ< Ə	ʌ4 Ə	ʌ, Ə	ʌ$ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ Ə	ʌ$ 
  - - 0-td뀠      0 0  Q/lꨖ     @-,0 0  S   0  S  
 0   $       80@-  S  
, ,=(  0  S  
0  S   
3/      $ "     p@- `8MP |  y I  @  i p  
r P  
t P  
0    @ PD   v @@ T  
 T  
(P 
 @ m  i  8Ѝp(P   (P  0      8  $    @-$qM 0 s
`  

   0#@  
@T  Ѝ 
   
` p  (  
    P  >  P  0   70 @ 0# 0##( @`  0@$@ PD @P%P0  0@$DH@   $ H  $ X  E-M pP P=    X=  @ `  @`  T P `
   
   P V    T` P@C$@P X   ` 
  P  @ @$@
 @C$@` Xd v
 Ѝ  X@ m  
 $ fP  @ `@$@$   QA- P M  
 `  V  ` @
p  
\ 0 9*9)@
 0 5  VP Ѝ-M00!Ѝ G-Pp   +  U`  
 `  Pd  U`p   
 
 $ @P{ 0 S S  
  T   X    U   V ` G- 0 p FM  1 PP9  @2@F@D ,  n   P+   WpO  
` @   P   E   P   X  
   Fߍ   W 0 0 `	   X  
  Xa0 s*  
0Da  S<1  x   P 0   
!0 S00 `P  
   n |  P@  
` 0      P 
 h PP  @  @ U    T@ K  00 00  d  $ <  $           A- BM M   q `P>  [  @
 N@D B. T$Dn  P-   t  W   @[$  2  ^ @  P
  4  S  4  S  4  S  4  S	  
  X   W a  (Ѝۍ4  S4  S
 T    < L   '  O-EDM0   S  
 0 s  
 0 0000  0  S  @  l   <  P( E 0 S S
<  (   0 0 0  S  P  U  
(`  (p 0 W  
  
 0 0 0  ,P  ,P0 U   @	 Td0 0TP$P4P'  ̟  Z)  
  Q&  P@P4OBAd P``APEO`z Pw3BId Pq 00 0l3`b`lf 0  S2  \a  VL] `dZP8W @,T0$ 0P0 0   @F  kB    Pn  ;@@  / #d4   -)Ƞ@ʌ 	P0
 92ἑO  DЍ   P  00 0 s  1.B P( @ @ &   9 @  T @  5 0 0@@@@,(` @t0H900 @$ 00C 0	  0,     @ 0 090  0  S 4< 80   0 P <090T 80 0D 4008 00 0 000u$ $ $ % (%  @ gfffC@B %   $   ̡    С  p@- Pv 0  S     @dn 00 T  Hh 0 08d? 0(`   W  P0  
X   p@L Q `  V L @ I@  T @   C@ @@H$H  T@   8 @ 5000h 00F 0` ,p@   p @@ % @8 "  1    @  00C 0p8% H% X% @- @  P   @ @@-   "L"4" 0 @ 00#40  "$ 0	0#40
  
 @- @  0 $4 Č  @0 4 00 40 0
 4 0 G-8MP(@B,Ġ3`4p5672 ( 2PPP`p 8Ѝ0  D  0 D  0  D  /G-p nDD0D 0a CQ 	  
` @
  @ T:  @-  e2fsprogs   /app/usr/share/locale   Usage: %s [-r] [-t]
    tr  4          /dev/urandom    /dev/random /var/lib/libuuid/request    /var/lib/libuuid    /dev/null   uuidd   -qT 300 /var/lib/libuuid/clock.txt  r+  clock: %04x tv: %lu %lu adj: %d
    clock: %04x tv: %016lu %08lu adj: %08d
                    
    /usr/sbin/uuidd L    %08x-%04x-%04x-%02x%02x-%02x%02x%02x%02x%02x%02x    %08X-%04X-%04X-%02X%02X-%02X%02X%02X%02X%02X%02X           l  (               u      T  
        "          "          h     (     ؂  
                     #               Ĉ                   ot  o   o
                                                  "         `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `  `              A&   aeabi    5TE 	GCC: (GNU) 4.3.3     ,               $   T                               $              8                       O         l                      L                        ؟             $    !       \                        2  o  main         8      uuid__generate_random 	  uuid_generate_random   uuid__generate_time   uuid_generate_time   uuid_generate         O  `     uuid_pack           j     uuid_unpack     M          uuid_unparse   uuid_unparse_upper 0  uuid_unparse_lower                    /usr/src/openwrt-rd6281a/build_dir/toolchain-arm_v5te_gcc-4.3.3+cs_eglibc-2.8_eabi/eglibc-2.8-r8587-final/csu/crti.S /usr/src/openwrt-rd6281a/build_dir/toolchain-arm_v5te_gcc-4.3.3+cs_eglibc-2.8_eabi/eglibc-2.8-r8587/libc/csu GNU AS 2.20.1 .        r  ~            0   J     <  E       int p   @      8a          u     o          -i  	  Z   # 	      #	      #	     #	     #	(     #	x     #	3      #	      # 	O     #$	|     #(	      #,	  "  #0	   $  #4	   &Z   #8	c  *Z   #<	   ,z   #@	   0>   #D	  1L   #F	)   2  #G	]  6  #H	   ?   #P	:  H   #X	A  I   #\	H  J   #`	O  K   #d	V  L%   #h	  NZ   #l	]  P  #p 
           # 6    #  Z   # p          
     i       
   '         ,  7     
    V  e               W           	+  
     r   o         %Z               $Z   ,   m  $  J   c &Z         'Z      str (  uu )  `V  (   ;c          
  
   $ "    k    f        a    	        Y    0   J     <  E       int p   @      8a     9h   p  z     0     0     E     0     0          u     o     Z        @          a     g  Z   @  6  <      -  	  Z   # 	   6  #	   6  #	  6  #	  6  #	(  6  #	x  6  #	3   6  #	   6  # 	O  6  #$	|  6  #(	   6  #,	  "A  #0	   $G  #4	   &Z   #8	c  *Z   #<	   ,   #@	   0>   #D	  1L   #F	)   2M  #G	]  6]  #H	   ?   #P	:  H  #X	A  I  #\	H  J  #`	O  K  #d	V  L%   #h	  NZ   #l	]  Pc  #p 
    A     A  # 6  G  #  Z   # 
  C  <  ]  
       <  s  
   ' y  <  i          J     '  5      "  :    n    	,  
I  c
    
{  a    b  h      w  2      Y  z      	  J       $  !V  "(  #1  $J  %z  &w  '
  (  )`  *&  +  ,
  -  .  /  0  1  2  3  4Q  5  6R  7  8n  9  :k  ;	  <	  <%  =S	  >  ?J         
   !
   =   X   
      3   
   
      _               7         3         T   
      
                  4                  a       (   
   ;
         J      {	         >
         N         5   d            
        m  B    
    #  6  
    E  '	            `
    j	  d  l          	  H
      U  ^  ]    :	  *    i
      ;              I    =  #    e        T    c    	  
    J          
        \  
     H     	M     Z   >   	  
    7   *	  
      
}	  
  
S   #   
S   #  
   #D  
   #"  
   #   F	    G   # 	  H   #   	z	    	{   #   	|   #   X%
    &   # :  '>   #	  )   #  -   #  .   #  /   #	  0   #[  1   # A  2>   #(  4   #,A  8
  #0L  ;  #4  F	  #8  G	  #@  H	  #H  UE   #P  VE   #T   )
  >  L      }  Q  
   
>     /    
  # :  /  # <  ?  
   
 d  nh     
  #   !h  # <  x  
   k q  q  w  rE   #   sE   #  t>   #irq u7   #
dma v7   #6  w7   #   	     <    
      |    W                  S   X  Z     Z   t  x  {        %
  +   Y     A    # r    #     +  
       C  
    Z   # 
    #   17     2>     40     ;h   !
     g   w
    
      p    .      )-  +
  ,
  .  /
  2  3/
  :	  ;S
  <            W    Q      ,
  7      
      2S    3
  #   4
  #  5
  #  6
  #N	  7S  #
 
  c  
      Z     x  s  ~     	       i Z   max Z    	  Z     $       tv }	  `i Z     fd Z   $  |  $    E    buf   p    Z     i Z     n Z     fd Z       Z     cp   $     
	  Z 7   !B  q  $  B    "out p  m  "num p    #buf r
  X#uu s   H$i tZ     #n tZ   V Z   !q  $  D    C  "out     #num Z   q| %1  ~  D        "fd Z     "buf 6  7  &
  %   U  #ret ~  T#c ~  V'  Z   X %p  Z       s    "op Z     "out     "num     '    (0  Z   $s Z     $ret ~    )]    *  )    X  '  ?  }#st 	  ~pid   *  #  +c  @     ,  ,v   -    H    .  H  /  T/  U  '    <  '  Z   $ '  Z   $  <  $  
   ? 	  Z       v    	  ܋    sd Z   Vifr   @0    ifc   `buf   wn Z     i Z     1a    <    2    3
  3Z   z  
  1z    1z    2  4num 2  tv 9}	  fl :*	  (  ;"
  (v  <  len =Z   5  z6cl [0   tv1 \E   tv2 \E   a ]Z     
  
  !L
  *    	    "out )  5  "num )  S  #uu -   (  .
  +  X   <a  ,  ,  ,  ,  7   /  @/  8  q  8*    96  :B  .d    8K    8V    8b  @  8n  l     '	  +	  $ '  ,Z   $  !-  E        "out D    $now J     !          "out      s  0y  m
	  ;"  G  ;k  G   \   s    )      L  
  J         int p     1/     2h   <    4%   @   E   u       2     3o   #   4]   #  5]   #  6]   #N	  7   #
 R      	,    
  '  L  ;  J  uu &J  Z  ptr &Y  x  tmp (o     
out )Y   P       /    f   7    '    L  ؟    J         int p     1/     2h   <    4%   @   E   u       2     3o   #   4]   #  5]   #  6]   #N	  7   #
 R      	,    
  'L  ؟    M  in &M    uu &X    ptr (^  %  tmp )o   Y   
S  /   
   
d  R               ؟        0   J     <  E       int p   @      8a          u     o          -i  	  Z   # 	      #	      #	     #	     #	(     #	x     #	3      #	      # 	O     #$	|     #(	      #,	  "  #0	   $  #4	   &Z   #8	c  *Z   #<	   ,z   #@	   0>   #D	  1L   #F	)   2  #G	]  6  #H	   ?   #P	:  H   #X	A  I   #\	H  J   #`	O  K   #d	V  L%   #h	  NZ   #l	]  P  #p 
           # 6    #  Z   # p          
     i       
   '        17     2>     40     2X    3  #   4  #  5  #  6  #N	  7X  #
   h  
    =  4؟  P  w    uu 3    out 3     fmt 3      5  P   7   0  JP  `  ]  uu I    out I   	   L  E`  p  ]0  uu D  	  out D   +	   i  @p    ]e  uu ?  >	  out ?   Q	   _  'v  D    |  *v  H  "    k          ^     /usr/src/openwrt-rd6281a/build_dir/toolchain-arm_v5te_gcc-4.3.3+cs_eglibc-2.8_eabi/eglibc-2.8-r8587-final/csu/crtn.S /usr/src/openwrt-rd6281a/build_dir/toolchain-arm_v5te_gcc-4.3.3+cs_eglibc-2.8_eabi/eglibc-2.8-r8587/libc/csu GNU AS 2.20.1  U%   %   :;I  $ >  $ >  $ >      I  :;  	
 :;I8
  
 :;  
 :;I8
  I  
! I/  & I  :;  ( 
  .:;'    :;I  .?:;'I@   :;I  4 :;I  4 :;I  4 :;I
  1UXY   1  4 :;I?<   %   :;I  $ >  $ >  $ >      I  :;  	
 :;I8
  
 :;  
 :;I8
  I  
! I/  & I  :;  ( 
  :;  
 :;I8
  :;  
 :;I  .?:;'I    :;I  .:;'   4 :;I  .:;'I@  4 :;I
  4 :;I  .:;'@   :;I   :;I  4 :;I   4 :;I
  !.?:;'@  " :;I  #4 :;I
  $4 :;I  %.:;'I@  & :;I  '4 :;I
  (4 :;I  )4 :;I  *
 :;  +1UXY  , 1  -1XY  .  /4 1
  04 :;I  14 :;I  2! I/  3.:;'I   4 :;I  5
 :;  6  7U  84 1  94 1  :
 1  ;4 :;I?<   %  $ >  $ >  $ >   :;I  :;  
 :;I8
  I  	! I/  
.?:;'@   :;I  4 :;I  
4 :;I   I  & I   %  $ >  $ >  $ >   :;I  :;  
 :;I8
  I  	! I/  
.?:;'@   :;I  4 :;I  
 I  & I   %   :;I  $ >  $ >  $ >      I  :;  	
 :;I8
  
 :;  
 :;I8
  I  
! I/  & I  .:;'@   :;I  4 :;I
  .?:;'@
  4 :;I?<    U%          
      /usr/src/openwrt-rd6281a/build_dir/toolchain-arm_v5te_gcc-4.3.3+cs_eglibc-2.8_eabi/eglibc-2.8-r8587-final/csu  crti.S       /0////  T  -/         W  
      /usr/src/openwrt-rd6281a/staging_dir/toolchain-arm_v5te_gcc-4.3.3+cs_eglibc-2.8_eabi/lib/gcc/arm-openwrt-linux-gnueabi/4.3.3/include /usr/src/openwrt-rd6281a/staging_dir/toolchain-arm_v5te_gcc-4.3.3+cs_eglibc-2.8_eabi/lib/gcc/arm-openwrt-linux-gnueabi/4.3.3/../../../../arm-openwrt-linux-gnueabi/sys-include/bits /usr/src/openwrt-rd6281a/staging_dir/toolchain-arm_v5te_gcc-4.3.3+cs_eglibc-2.8_eabi/lib/gcc/arm-openwrt-linux-gnueabi/4.3.3/../../../../arm-openwrt-linux-gnueabi/sys-include ../lib/uuid  uuidgen.c    stddef.h   types.h   libio.h   stdio.h   uuid.h   locale.h       $f5gggild.JjMtf L   
  
      /usr/src/openwrt-rd6281a/staging_dir/toolchain-arm_v5te_gcc-4.3.3+cs_eglibc-2.8_eabi/lib/gcc/arm-openwrt-linux-gnueabi/4.3.3/../../../../arm-openwrt-linux-gnueabi/sys-include/sys /usr/src/openwrt-rd6281a/staging_dir/toolchain-arm_v5te_gcc-4.3.3+cs_eglibc-2.8_eabi/lib/gcc/arm-openwrt-linux-gnueabi/4.3.3/include /usr/src/openwrt-rd6281a/staging_dir/toolchain-arm_v5te_gcc-4.3.3+cs_eglibc-2.8_eabi/lib/gcc/arm-openwrt-linux-gnueabi/4.3.3/../../../../arm-openwrt-linux-gnueabi/sys-include/bits /usr/src/openwrt-rd6281a/staging_dir/toolchain-arm_v5te_gcc-4.3.3+cs_eglibc-2.8_eabi/lib/gcc/arm-openwrt-linux-gnueabi/4.3.3/../../../../arm-openwrt-linux-gnueabi/sys-include /usr/src/openwrt-rd6281a/staging_dir/toolchain-arm_v5te_gcc-4.3.3+cs_eglibc-2.8_eabi/lib/gcc/arm-openwrt-linux-gnueabi/4.3.3/../../../../arm-openwrt-linux-gnueabi/sys-include/net /usr/src/openwrt-rd6281a/staging_dir/toolchain-arm_v5te_gcc-4.3.3+cs_eglibc-2.8_eabi/lib/gcc/arm-openwrt-linux-gnueabi/4.3.3/../../../../arm-openwrt-linux-gnueabi/sys-include/netinet ../../lib/uuid  gen_uuid.c    stat.h   stddef.h   types.h   libio.h   stdio.h   unistd.h   types.h   time.h   fcntl.h   time.h   stat.h   sockaddr.h   socket.h   un.h   if.h   stdint.h   confname.h   in.h   uuid.h   uuidP.h        3)3g-Mifhd1-/0gKKu JK01Ky.6xJ/KG1+.z.i-g>htJMt)kgh/-/-/0y.5+/0y.6x.
.vJ
JKi/~J.kg
v..-/t./K1+.wJ	J$J4z..r..JxJ6i/-Ke/L,0gMMfirJ/0H+3LKkLJP.0.P.1f-/lg	jg-/JJJKK*}tfd..gMd//j/c.JvbJ$Jiuf`#4z.4z.4z.4~.-3-+//+3󠃃`gփs֊x.P0Ke/-LL/K,/g!-K.K-KK~..0/-K~J.1+L-0/goJ	~JKI/K-//i+5*///J-Kg( _-fl
,.5g/-e.-//-//	fw.q.*./g1+0/-       
      /usr/src/openwrt-rd6281a/staging_dir/toolchain-arm_v5te_gcc-4.3.3+cs_eglibc-2.8_eabi/lib/gcc/arm-openwrt-linux-gnueabi/4.3.3/../../../../arm-openwrt-linux-gnueabi/sys-include  pack.c    stdint.h   uuidP.h        &2*.)0/,2z.6/0L/0L/0Lg-       
      /usr/src/openwrt-rd6281a/staging_dir/toolchain-arm_v5te_gcc-4.3.3+cs_eglibc-2.8_eabi/lib/gcc/arm-openwrt-linux-gnueabi/4.3.3/../../../../arm-openwrt-linux-gnueabi/sys-include  unpack.c    stdint.h   uuidP.h      L  &3I0-1+/L-/x..--0-/1/,0-/1/0,0H1- {   L  
      /usr/src/openwrt-rd6281a/staging_dir/toolchain-arm_v5te_gcc-4.3.3+cs_eglibc-2.8_eabi/lib/gcc/arm-openwrt-linux-gnueabi/4.3.3/include /usr/src/openwrt-rd6281a/staging_dir/toolchain-arm_v5te_gcc-4.3.3+cs_eglibc-2.8_eabi/lib/gcc/arm-openwrt-linux-gnueabi/4.3.3/../../../../arm-openwrt-linux-gnueabi/sys-include/bits /usr/src/openwrt-rd6281a/staging_dir/toolchain-arm_v5te_gcc-4.3.3+cs_eglibc-2.8_eabi/lib/gcc/arm-openwrt-linux-gnueabi/4.3.3/../../../../arm-openwrt-linux-gnueabi/sys-include  unparse.c    stddef.h   types.h   libio.h   stdio.h   stdint.h   uuidP.h      ؟  3J1+1/,
JKzJKzJK        
      /usr/src/openwrt-rd6281a/build_dir/toolchain-arm_v5te_gcc-4.3.3+cs_eglibc-2.8_eabi/eglibc-2.8-r8587-final/csu  crtn.S     \              |
          $  DHH      |
    0     @  DH     0   $  l  DD(    0        HH8     0   $      DD    0   D     D  $   0       D P $   0     T  DHH $   0     0  D$	Hh   0       D    0     ,   D     |
        l   D       |
      L     D       |
 $     ؟  x   D DX       P          `          p     __off_t _IO_read_ptr _chain __LC_COLLATE _shortbuf _IO_buf_base long long unsigned int __LC_MESSAGES __LC_CTYPE long long int /home/arm/e2fsprogs-1.41.14/misc uuid_t _fileno _IO_read_end __LC_NUMERIC do_type _IO_buf_end _cur_column __quad_t _old_offset __LC_MONETARY GNU C 4.3.3 _IO_marker stdin _IO_write_ptr _sbuf short unsigned int _IO_save_base _lock _flags2 stdout usage _IO_write_end _IO_lock_t _IO_FILE __LC_PAPER _pos _markers __LC_ALL __LC_TIME unsigned char progname short int _vtable_offset __LC_NAME _next __off64_t _IO_read_base _IO_save_end __LC_TELEPHONE __pad1 __pad2 __pad3 __pad4 __pad5 _unused2 stderr argv uuidgen.c _IO_backup_base __LC_ADDRESS argc __LC_MEASUREMENT main _IO_write_base __LC_IDENTIFICATION __u_quad_t _SC_LEVEL3_CACHE_SIZE st_ctim _SC_INT_MAX sa_family _SC_MAPPED_FILES _SC_CHILD_MAX _SC_CLK_TCK st_blksize st_blocks _SC_SIGQUEUE_MAX __ssize_t ifmap mem_start _SC_DEVICE_IO tries _SC_LEVEL4_CACHE_ASSOC _SC_JOB_CONTROL IPPROTO_MTP _SC_CHAR_MAX __gid_t lose_counter SOCK_RAW st_mtim _SC_TRACE_INHERIT _SC_XOPEN_VERSION IPPROTO_ENCAP IPPROTO_ROUTING _SC_GETGR_R_SIZE_MAX _SC_PII_SOCKET _SC_CHAR_MIN _SC_SAVED_IDS ifru_addr ifru_newname _SC_SCHAR_MAX nbytes _SC_ARG_MAX stat time_mid _SC_TIMEOUTS _SC_CHAR_BIT _SC_AIO_LISTIO_MAX time_low _SC_MB_LEN_MAX _SC_THREAD_PRIO_PROTECT _SC_PII_INTERNET op_len _SC_THREAD_PROCESS_SHARED _SC_PII _SC_AIO_PRIO_DELTA_MAX __dev_t __path _SC_MEMORY_PROTECTION IPPROTO_UDP _SC_OPEN_MAX _SC_THREAD_THREADS_MAX _SC_READER_WRITER_LOCKS _SC_STREAMS _SC_MQ_OPEN_MAX time_hi_and_version l_type _SC_FIFO _SC_2_C_VERSION uuid_generate_time __caddr_t _SC_BC_DIM_MAX ifreq _SC_THREAD_ATTR_STACKADDR jrand_seed _SC_UINT_MAX _SC_2_PBS_LOCATE srv_addr __blksize_t _SC_LEVEL1_DCACHE_LINESIZE IPPROTO_IGMP st_uid uint64_t _SC_TRACE_EVENT_FILTER _SC_NL_LANGMAX close_all_fds _SC_V6_LP64_OFF64 _SC_NL_MSGMAX ifconf _SC_PII_OSI_CLTS st_rdev _SC_LEVEL1_ICACHE_ASSOC ifru_slave ifru_netmask _SC_DEVICE_SPECIFIC_R _SC_NZERO _SC_XOPEN_XPG2 _SC_XOPEN_XPG3 _SC_XOPEN_XPG4 _SC_ULONG_MAX _SC_XOPEN_ENH_I18N __socket_type IPPROTO_IP ret_clock_seq _SC_INT_MIN _SC_2_UPE SOCK_STREAM _SC_PAGESIZE ifru_dstaddr _SC_FILE_SYSTEM ifru_map SOCK_SEQPACKET _SC_2_VERSION IPPROTO_PIM timeval _SC_RE_DUP_MAX _SC_LEVEL3_CACHE_ASSOC __mode_t IPPROTO_IPV6 _SC_2_FORT_DEV uuidd_path get_node_id _SC_IOV_MAX gen_uuid.c _SC_THREAD_CPUTIME _SC_SYSTEM_DATABASE node _SC_PII_INTERNET_DGRAM _SC_FILE_LOCKING _SC_SCHAR_MIN _SC_UIO_MAXIOV st_ino _SC_VERSION tv_usec IPPROTO_NONE ifrn_name _SC_SPIN_LOCKS get_random_fd _SC_LEVEL1_DCACHE_SIZE st_gid _SC_RAW_SOCKETS _SC_THREADS _SC_THREAD_SAFE_FUNCTIONS _SC_WORD_BIT _SC_REGEXP IPPROTO_DSTOPTS _SC_ASYNCHRONOUS_IO IPPROTO_ICMP _SC_CHARCLASS_NAME_MAX _SC_LEVEL1_DCACHE_ASSOC IPPROTO_ESP clock_high _SC_LEVEL3_CACHE_LINESIZE _SC_THREAD_STACK_MIN _SC_XOPEN_UNIX uuid_generate _SC_NL_TEXTMAX _SC_PII_INTERNET_STREAM _SC_V6_ILP32_OFFBIG IPPROTO_MAX reply_len IPPROTO_HOPOPTS _SC_SEMAPHORES _SC_LEVEL4_CACHE_SIZE expected timespec _SC_MULTI_PROCESS _SC_NPROCESSORS_ONLN ifrp sun_path ifru_broadaddr _SC_USER_GROUPS __unused4 __unused5 _SC_2_LOCALEDEF _SC_LINE_MAX _SC_PHYS_PAGES _SC_XOPEN_REALTIME _SC_SIGNALS __blkcnt_t _SC_MONOTONIC_CLOCK _SC_RTSIG_MAX _SC_FILE_ATTRIBUTES __ino_t _SC_USER_GROUPS_R _SC_XOPEN_XCU_VERSION ifru_mtu _SC_PII_XTI _SC_XOPEN_REALTIME_THREADS _SC_LONG_BIT _SC_XBS5_ILP32_OFFBIG ifru_data IPPROTO_ICMPV6 _SC_UCHAR_MAX uuid__generate_time _SC_PIPE _SC_TYPED_MEMORY_OBJECTS _SC_LOGIN_NAME_MAX _SC_THREAD_KEYS_MAX get_clock _SC_ADVISORY_INFO count ifc_ifcu IPPROTO_RSVP IPPROTO_FRAGMENT ifcu_req _SC_COLL_WEIGHTS_MAX _SC_PII_OSI_M _SC_2_C_DEV _SC_SYSTEM_DATABASE_R __suseconds_t _SC_USHRT_MAX _SC_IPV6 _SC_HOST_NAME_MAX _SC_BC_STRING_MAX access_ret _SC_THREAD_PRIORITY_SCHEDULING op_buf try_again SOCK_RDM _SC_2_SW_DEV st_nlink _SC_REALTIME_SIGNALS IPPROTO_TP fail _SC_XBS5_LPBIG_OFFBIG _SC_2_PBS_ACCOUNTING _SC_THREAD_DESTRUCTOR_ITERATIONS _SC_TRACE_LOG _SC_MEMLOCK _SC_PII_OSI _SC_DELAYTIMER_MAX _SC_2_FORT_RUN _SC_NPROCESSORS_CONF _SC_SHRT_MAX IPPROTO_RAW __pid_t _SC_AIO_MAX _SC_BARRIERS _SC_REGEX_VERSION _SC_LEVEL2_CACHE_LINESIZE st_dev _SC_DEVICE_SPECIFIC _SC_SHARED_MEMORY_OBJECTS SOCK_DGRAM IPPROTO_SCTP sockaddr_un IPPROTO_PUP get_random_bytes _SC_XBS5_LP64_OFF64 sun_family sa_family_t uint8_t _SC_NL_ARGMAX uint16_t clock_reg _SC_SINGLE_PROCESS _SC_AVPHYS_PAGES _SC_XOPEN_SHM _SC_THREAD_SPORADIC_SERVER IPPROTO_IDP sa_data uuid__generate_random ifru_ivalue _SC_NL_NMAX get_uuid_via_daemon sockaddr __time_t l_start tmp_seed _SC_2_PBS_MESSAGE _SC_SEM_NSEMS_MAX _SC_T_IOV_MAX _SC_PRIORITIZED_IO IPPROTO_GRE _SC_V6_ILP32_OFF32 ifru_flags IPPROTO_EGP _SC_STREAM_MAX read_all _SC_TZNAME_MAX _SC_2_PBS_CHECKPOINT _SC_SPAWN _SC_MEMLOCK_RANGE _SC_BC_SCALE_MAX mem_end _SC_SYMLOOP_MAX IPPROTO_COMP _SC_2_CHAR_TERM _SC_SHELL _SC_FD_MGMT ifru_hwaddr _SC_XOPEN_CRYPT _SC_LEVEL1_ICACHE_LINESIZE _SC_C_LANG_SUPPORT_R l_pid _SC_TIMER_MAX port _SC_2_PBS _SC_CPUTIME SOCK_PACKET _SC_SPORADIC_SERVER uuid_generate_random _SC_CLOCK_SELECTION _SC_XBS5_ILP32_OFF32 clock_mid _SC_NETWORKING _SC_LEVEL4_CACHE_LINESIZE clock_low tv_nsec _SC_ATEXIT_MAX _SC_PII_OSI_COTS _SC_MQ_PRIO_MAX _SC_SEM_VALUE_MAX _SC_C_LANG_SUPPORT _SC_TIMERS _SC_PASS_MAX _SC_FSYNC _SC_SELECT save_umask _SC_TTY_NAME_MAX start_attempts ifcu_buf st_size _SC_POLL l_whence st_mode __uid_t _SC_MESSAGE_PASSING /home/arm/e2fsprogs-1.41.14/lib/uuid IPPROTO_IPIP _SC_LEVEL2_CACHE_ASSOC _SC_BC_BASE_MAX ifr_ifrn _SC_LEVEL2_CACHE_SIZE _SC_EXPR_NEST_MAX ifr_ifru _SC_SYNCHRONIZED_IO IPPROTO_TCP uint32_t _SC_SHRT_MIN _SC_2_PBS_TRACK _SC_NGROUPS_MAX _SC_V6_LPBIG_OFFBIG _SC_LEVEL1_ICACHE_SIZE base_addr _SC_EQUIV_CLASS_MAX has_init _SC_BASE _SC_PRIORITY_SCHEDULING l_len _SC_SSIZE_MAX _SC_GETPW_R_SIZE_MAX _SC_XOPEN_LEGACY __statbuf _SC_THREAD_PRIO_INHERIT __nlink_t _SC_TRACE _SC_NL_SETMAX tv_sec ifc_len flock _SC_2_C_BIND st_atim IPPROTO_AH _SC_THREAD_ATTR_STACKSIZE uuid_pack uuid_unpack unpack.c uuid_unparse uuid_unparse_x uuid_unparse_upper fmt_lower uuid_unparse_lower fmt_upper unparse.c         ]       }   $   }                 P   $   V                Q       U       U       U       U        @   D    PT   x    P       P       P      P        @   |    T       T   $   T                ]       }   @   }         4   P    T       R       R        @  D   ]D  H   }H     }(        @  T   PT     W        @  T   QT     X        t     P     P     U  X   V        l     T        \     ZX  l   Z        p     V        X     UX     U             ]     }  @   }8             P  @   U             Q0  @   Q          8   T        @  D   ]D  H   }H  `   }        @  X   P        `  d   ]d     }         `  t   Pt     Z        `  x   Qx     W        `  |   R|     U             ]      }       }             P     W          ,   Q,     Y          0   R0     Z        <  ,   U             V  0   V        4     }  (   t(     }             V     V             ]     }     }     }             P     X             W     W        $     T     T             ]     }$  4   }           $   P$  4   [          $   Q$  4   Z        	  l   XY     XY  
   XY        8   	   U	  \	   U`	  l	   U  |   U
  
   U             p|  @
   p
  
   p             l|  @
   l
  
   l             h|  @
   h
  
   h             S     d|  @
   d
  
   d        4  8   ]8     }        4  @   P@     U        \     Tx     T             ]     }             P     T                ]   l    }                P   l    \            d    Q               R       S   ,    P,   4    S<   D    RL   T    S                ]       }                P            @    Q@       T           0    P0   L    RL   d    Pd   |    Q            $    R$   <    S                ]       }    x    }                 P                Q   P    U                R   (    T        x       P        x       Q               P               Q               P               Q                  (  T  \              h   |                 T  X  \  h          $  \    
      `  d          $  |  
  
  ,  T
               `  d     \  
      
                      \  `               .symtab .strtab .shstrtab .interp .note.ABI-tag .hash .dynsym .dynstr .gnu.version .gnu.version_r .rel.dyn .rel.plt .init .text .fini .rodata .ARM.exidx .eh_frame .init_array .fini_array .jcr .dynamic .got .data .bss .ARM.attributes .comment .debug_aranges .debug_pubnames .debug_info .debug_abbrev .debug_line .debug_frame .debug_str .debug_loc .debug_ranges                                                     4  4                    #         H  H                     1         h  h  p               7         ؂    P              ?         (  (                   G   o   
  
  j                T   o   t  t  @                c   	                          l   	      Ĉ                  u         T  T
                    p         `  `
  l                {         ̌    $                                                                                     p     "                              "                             " "                             " "                             " "                             " "                           # #                            $ $                             $ $                         p        $  '                        0       $                                 $                                 %  4                              '  "                              I                   ,             P                   8             `  H                 E     0       (c                  P             z  d	                 [                                               (  i                                 P  %            	              Ԛ  r                                     4            H            h            ؂            (            
            t                        Ĉ       	     T       
     `            ̌                   
                                         "           "           "           "           #           $           $                                                                                                                                                   !              "                                                    T        
            
                 H            ̌                                 "                                       \        
            
              )            4           G   "          $           (         T   (           `         j   $         "        y   "          l            l                       $         "           "          $                                   ̎            0                                                   @                   $            $  l                              D                  l                     (    T                               М                                                <         4  <       D  @          $        Y  $      a  $         H            $        q  $        $        $        $        $        $        %        %        (%      1  8%      E  H%      _  X%         @          r                                   y              L                                   ؟           ؟  x        \            `            l            p            |            D           D         H          L                                                        )                                     "          "         #        "         "         "         `            p            t           $        "  t         2         H              ^           o                                 ̌                                Ȋ                                                #           6           H         
 N           n                                 (           4           @           L             ,       p         X         %  d         7  $       D    0    X  p         p  `         $        |                                 $                                       	             ċ         -  Ћ         B  ܋         U  P       b  $      o             h%          l       h%                                                     $           $      
  0           h%      (  <         =  L       I  H         Y  h%      ^  T         p  `           l           x           $          l               $                                                *           =    $    B  T       
 H           Z               initfini.c $a call_gmon_start $d init.c crtstuff.c __EH_FRAME_BEGIN__ __JCR_LIST__ __do_global_dtors_aux completed.2949 __do_global_dtors_aux_fini_array_entry frame_dummy object.2957 __frame_dummy_init_array_entry uuidgen.c gen_uuid.c get_random_fd get_random_bytes read_all get_uuid_via_daemon get_node_id uuidd_path.4317 __emutls_t.last.4197 fd.4072 access_ret.4318 __emutls_v.jrand_seed start_attempts.4319 has_init.4356 node_id.4355 __emutls_v.state_fd.4198 __emutls_v.state_f.4199 __emutls_v.clock_seq.4200 __emutls_v.last.4197 __emutls_v.adjustment.4196 __emutls_v.num.4374 __emutls_v.last_time.4376 __emutls_v.uu.4375 pack.c unpack.c unparse.c uuid_unparse_x fmt_lower fmt_upper elf-init.c __FRAME_END__ __JCR_END__ _GLOBAL_OFFSET_TABLE_ __init_array_end __init_array_start _DYNAMIC data_start open@@GLIBC_2.4 uuid__generate_random __register_frame_info abort@@GLIBC_2.4 connect@@GLIBC_2.4 random@@GLIBC_2.4 __libc_csu_fini _start sysconf@@GLIBC_2.4 __xstat@@GLIBC_2.4 __libc_start_main@@GLIBC_2.4 __gmon_start__ _Jv_RegisterClasses rewind@@GLIBC_2.4 strncpy@@GLIBC_2.4 fclose@@GLIBC_2.4 _fini __emutls_get_address@@GCC_4.3.0 memset@@GLIBC_2.4 bindtextdomain@@GLIBC_2.4 _IO_stdin_used getuid@@GLIBC_2.4 read@@GLIBC_2.4 write@@GLIBC_2.4 jrand48@@GLIBC_2.4 uuid_generate uuid_unparse_lower dcgettext@@GLIBC_2.4 access@@GLIBC_2.4 __data_start uuid__generate_time gettimeofday@@GLIBC_2.4 uuid_unparse_upper __bss_start__ socket@@GLIBC_2.4 execl@@GLIBC_2.4 umask@@GLIBC_2.4 uuid_generate_random fflush@@GLIBC_2.4 ioctl@@GLIBC_2.4 __exidx_end getopt@@GLIBC_2.4 memcpy@@GLIBC_2.4 setlocale@@GLIBC_2.4 getppid@@GLIBC_2.4 uuid_unparse __dso_handle waitpid@@GLIBC_2.4 __end__ __libc_csu_init __bss_end__ fdopen@@GLIBC_2.4 srandom@@GLIBC_2.4 close@@GLIBC_2.4 fwrite@@GLIBC_2.4 time@@GLIBC_2.4 __bss_start fprintf@@GLIBC_2.4 _bss_end__ ftruncate@@GLIBC_2.4 uuid_unpack puts@@GLIBC_2.4 _end getpid@@GLIBC_2.4 textdomain@@GLIBC_2.4 fcntl@@GLIBC_2.4 fork@@GLIBC_2.4 stderr@@GLIBC_2.4 uuid_pack uuid_generate_time _edata __exidx_start syscall@@GLIBC_2.4 exit@@GLIBC_2.4 __errno_location@@GLIBC_2.4 sprintf@@GLIBC_2.4 main _init fscanf@@GLIBC_2.4 __deregister_frame_info                                                                                                                                                                                           pre_diag/pre_diag.sh                                                                                0000755 0000000 0000000 00000007731 12667755020 013461  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   #!/bin/bash
#the prepare diag script for burnin test
#created by Happi


function init_test()
{
	cd $WORK_PATH

	export UPDATE_STATUS=update_status
	export ALIVE_DAEMON=alive_daemon
	
	killall $ALIVE_DAEMON >/dev/null 2>/dev/null
	sleep 2

        if [ "x_${mvl}" == "x_yes" ];then
            if [ -e "/usr/bin/wget" ];then
              WGET=/usr/bin/wget
            else
              WGET=/usr/sbin/wget
            fi
            GET_DIAG="get_diagmvl.pl"
            GET_MD5="get_md5summvl.pl"
            DIAG_WORK=diagmvl 
 
	else
	  if [ "x_${BIT64}" == "x_yes" ];then
#		if [ -e "/usr/bin/curl" ];then
#	       		CURL=/usr/bin/curl
#		else
#	       		CURL=/$WORK_PATH/tools/curl
#		fi
		if [ -e "/usr/bin/wget" ];then
	       		WGET=/usr/bin/wget
		else
	       		WGET=/usr/sbin/wget
		fi
		GET_DIAG="get_diag_dc64.pl"
		GET_MD5="get_md5sum_dc64.pl"
		DIAG_WORK=diag_dc64
	  else
#	       	CURL=/$WORK_PATH/tools/curl
		if [ -e "/usr/bin/wget" ];then
	       		WGET=/usr/bin/wget
		else
	       		WGET=/usr/sbin/wget
		fi
		GET_DIAG="get_diag.pl"
		GET_MD5="get_md5sum.pl"
		DIAG_WORK=diag
	  fi
        fi

	if [ "${HOST_DOMAIN}" == "" ]||[ "${HTTP_PORT}" == "" ];then
		#fail to get the host domain
        	exit 1
	fi
	
	if [ -f $DIAG_SN_FILE ];then
        	OS=`read_config.sh ${DIAG_SN_FILE} os`
	else
	        sed -n '1p' /app/appversion | grep 'M[0-9]\+\.[0-9]\+' > /dev/null 2>/dev/null
        	RET=$?
        	if [ ${RET} == 0 ];then
                	OS="S"
	        else
        	        OS=`sed -n '1p' /app/appversion | sed 's/-/ /g' | awk '{ print $2 }'`
                	if [ $OS == "" ];then
                        	OS=NULL
	                fi
	        fi

	fi

	grep "^AF" /app/appversion >/dev/null
       	RET=$?
       	if [ ${RET} == 0 ];then
		DIAG_PATH=/mnt/diag
		mkdir -p ${DIAG_PATH}
        else
		DIAG_PATH=`read_config.sh ${CONFIG_FILE} diag_path`
		if [ "${DIAG_PATH}" == "" ];then
			DIAG_PATH=/var/ramfs
		fi
		mkdir -p ${DIAG_PATH}
	fi
	
	mount | grep "${DIAG_PATH}" >/dev/null
	RET=$?
       	if [ ${RET} == 0 ];then
		report "ramfs already mounted.skip it."
	else
		mount -t ramfs ramfs ${DIAG_PATH}
	fi
	
	DIAG_TAR_FILE=${DIAG_PATH}/diag.tar
	${ALIVE_DAEMON} &
	sleep 5
}


function download_and_check()
{
	parms="?version=${version}"

#${CURL} -s --connect-timeout 10 -o ${DIAG_TAR_FILE} -v http://${HOST_DOMAIN}:${HTTP_PORT}/cgi-bin/${GET_DIAG}${parms} >/dev/null 2>/dev/null
	${WGET} "http://${HOST_DOMAIN}:${HTTP_PORT}/cgi-bin/${GET_DIAG}${parms}" -O ${DIAG_TAR_FILE} >/dev/null 2>/dev/null
	ret=$?
	if [ ${ret} != 0 ];then
		return 1
	fi
	
#${CURL} -s --connect-timeout 10 http://${HOST_DOMAIN}:${HTTP_PORT}/cgi-bin/${GET_MD5}${parms} > md5_ori.txt 2>/dev/null
	${WGET} "http://${HOST_DOMAIN}:${HTTP_PORT}/cgi-bin/${GET_MD5}${parms}" -O md5_ori.txt >/dev/null 2>/dev/null
	ret=$?
	if [ ${ret} != 0 ];then
		return 1
	fi

	MD5_GET=`md5sum ${DIAG_TAR_FILE} | awk '{ print $1 }'`
	MD5_ORI=`awk '{ print $1 }' md5_ori.txt`
	
	report "got MD5 for ${DIAG_TAR_FILE}: ${MD5_GET}"
	report "std MD5 for ${DIAG_TAR_FILE}: ${MD5_ORI}"

	if [ "${MD5_GET}" == "${MD5_ORI}" ];then
		return 0
	else
		return 1
	fi
}

init_test
report "-------------------------------------"
report "---------prepare diagnostic:---------"
report "  DATE:`date`"

${UPDATE_STATUS} 0 "Downloading the ${DIAG_TAR_FILE}......"
i=1
while [ 1 ]
do
	if [ $i -gt 1000 ];then
		break
	fi
	download_and_check
	ret=$?
        if [ ${ret} != 0 ];then
		report "Fail to download the ${DIAG_TAR_FILE} or md5sum check failure!"
		report "Try to download again after 3 seconds. current try ${i}"
		${UPDATE_STATUS} 0 "Count ${i}:Try to download the ${DIAG_TAR_FILE}!"
		((i=i+1))
		sleep 3
                continue
        else
		report "Download and md5check pass."
		cd ${DIAG_PATH}
		rm -rf ${DIAG_WORK} >/dev/null
		tar xf ${DIAG_TAR_FILE} 2>/dev/null
		cd ${DIAG_PATH}/${DIAG_WORK}
		chmod +x *.sh
		./autorun.sh  >/dev/null 2>/dev/null &
		touch $DIAG_RUN_FLAG
		exit 0
	fi
done
${UPDATE_STATUS} 2 "Fail to download the ${DIAG_TAR_FILE}!"
exit 1


                                       pre_diag/tools64/                                                                                   0000755 0000000 0000000 00000000000 12667754516 012663  5                                                                                                    ustar   root                            root                                                                                                                                                                                                                   pre_diag/tools64/curl                                                                               0000755 0000000 0000000 00000777420 12667754516 013577  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   ELF          >     @     @                @ 8  @         @       @ @     @ @                                      @      @                                          @       @                                  c     c                               8     8c     8c                                    @     @                            Ptd          C      C                        Qtd                                                  /lib64/ld-linux-x86-64.so.2          GNU           	          Z          PZ   ]   a   |BE)fUaqX8                                               :             $                          H             @                    l       s                     t             %                                                                                                                                                  .      Y              5       N             .       I                                 $      5             
                                                                [             )      [                                  ;                           R             T                                                                                                     K                    7                    y                    g                           ,                                        E             =       v             >       L              3       #                    M             %                                                             +      Z             U                     w                                       :                                              z                                 e                                       t      m                   H             F      1             J       o                                                            ;                                 (       $                    x                    j             .                          	                                       ;             %       1              V                   %                     y       A             c      j             u      +                                        c                                 (                   9                                              6                                         >                     d             %       h                                           c                c                 c            r    c               c             *    c               
 h@             m    
 8A              libcurl.so.4 __gmon_start__ _Jv_RegisterClasses curl_getdate curl_mfprintf curl_version curl_global_cleanup _fini curl_strequal curl_free curl_easy_init curl_easy_setopt curl_formfree curl_easy_strerror curl_strnequal curl_mvaprintf curl_msprintf curl_global_init curl_version_info curl_easy_escape curl_mvfprintf curl_mprintf curl_easy_getinfo curl_mvsnprintf curl_getenv curl_slist_free_all curl_easy_cleanup curl_easy_perform curl_formadd curl_slist_append curl_msnprintf curl_maprintf curl_easy_pause librt.so.1 clock_gettime libc.so.6 fflush strcpy setlocale fopen ftruncate strrchr pipe __strdup getpwuid mkdir realloc stdin strtok isatty fgets calloc strlen memset strstr __errno_location tcsetattr fseek poll stdout fputc fputs lseek memcpy fclose __strtol_internal malloc strcat __ctype_b_loc sscanf stderr __fxstat fileno fwrite fread gettimeofday geteuid localtime strchr utime tcgetattr fcntl fsetxattr __xstat memmove access __libc_start_main __strtoul_internal _edata __bss_start _end /usr/local/lib GLIBC_2.2.5 GLIBC_2.3                                                                                                                                                     ui	                    ii
        ui	         c        
           c        ]           c        _           c        \           c                    c                   (c                   0c                   8c                   @c                   Hc                   Pc                   Xc        	           `c                   hc        
           pc                   xc                   c                   c                   c                   c                   c                   c                   c                   c                   c                   c                   c                   c                   c                   c                   c                   c                    c                    c        !           c        "           c        #            c        $           (c        %           0c        &           8c        '           @c        (           Hc        )           Pc        *           Xc        +           `c        ,           hc        -           pc        .           xc        /           c        0           c        1           c        2           c        3           c        4           c        5           c        6           c        7           c        8           c        9           c        :           c        ;           c        <           c        =           c        >           c        ?            c        @           c        A           c        B           c        C            c        D           (c        E           0c        F           8c        G           @c        H           Hc        I           Pc        J           Xc        K           `c        L           hc        M           pc        N           xc        O           c        P           c        Q           c        R           c        S           c        T           c        U           c        V           c        W           c        X           c        Y           H  :    H5# %# @ %# h    %z# h   %r# h   %j# h   %b# h   %Z# h   %R# h   %J# h   p%B# h   `%:# h	   P%2# h
   @%*# h   0%"# h    %# h
   %# h    %
# h   %# h   %# h   %# h   %# h   %# h   %ک# h   %ҩ# h   %ʩ# h   p%©# h   `%# h   P%# h   @%# h   0%# h    %# h   %# h    %# h   %# h    %z# h!   %r# h"   %j# h#   %b# h$   %Z# h%   %R# h&   %J# h'   p%B# h(   `%:# h)   P%2# h*   @%*# h+   0%"# h,    %# h-   %# h.    %
# h/   %# h0   %# h1   %# h2   %# h3   %# h4   %ڨ# h5   %Ҩ# h6   %ʨ# h7   p%¨# h8   `%# h9   P%# h:   @%# h;   0%# h<    %# h=   %# h>    %# h?   %# h@   %z# hA   %r# hB   %j# hC   %b# hD   %Z# hE   %R# hF   %J# hG   p%B# hH   `%:# hI   P%2# hJ   @%*# hK   0%"# hL    %# hM   %# hN    %
# hO   %# hP   %# hQ   %# hR   %# hS   %# hT   %ڧ# hU   %ҧ# hV   1I^HHPTI` A Hp A H@ wHH# HtHÐUHSH=#  uD(c H- c HHXH|# H9vHHl#  c H^# H9wZ# H[ UH=w#  Ht    Ht0c IAÐHH
#      pA H
#      hA H
Ϧ#      (A H
#      A H
#      A H
~#      
A H
c#      `A oH
H#      0A TH
-#      A 9H
#      A H
#      A H
ܥ#      A H
#      `A H
#      XA H
#      HA H
p#      A |H
U#      A aH
:#       A FH
#      `"A +H
#      8$A H
#       &A H
Τ#      'A H
#      )A H
#      H+A H
}#      -A H
b#      .A nH
G#      0A SH
,#      x2A 8H
#      P4A H
#      6A H
ۣ#      7A H
#      9A H
#      ;A H
#      =A H
o#      ?A {H
T#      XAA `H
9#      PCA EH
#      8EA *H
#      GA H
#      HA H
͢#      JA H
#      HLA H
#      0NA H
|#       PA H
a#      QA mH
F#      SA RH
+#      UA 7H
#      WA H
#      xYA H
ڡ#      `[A H
#      0]A H
#       _A H
#      `A H
n#      bA zH
S#      `dA _H
8#      PfA DH
#      @hA )H
#       jA H
#      kA H
̠#      mA H
#      oA H
#      qA H
{#      XsA H
`#      uA lH
E#      vA QH
*#      xA 6H
#      XzA H
#      |A  H
ٟ#      }A H
#      A H
#      hA H
#      HA H
m#      A yH
R#      A ^H
7#      A CH
#      pA (H
#      8A 
H
#      A H
˞#      A H
#      A H
#      xA H
z#      hA H
_#      @A kH
D#      A PH
)#      A 5H
#      A H
#      hA H
؝#      @A H
#       A H
#      A H
#      A H
l#      A xH
Q#      ȩA ]H
6#      A BH
#      PA 'H
 #      0A H
#      A H
ʜ#      A H
#      A H
#      xA H
y#      `A H
^#      8A jH
C#      A OH
(#      A 4H

#      ȿA H
#      A H
כ#      `A H
#      @A H
#      A H
#      A H
k#      hA wH
P#      A \H
5#      A AH
#      A &H
#      A H
#      A H
ɚ#      pA H
#      8A H
#      (A H
x#      A H
]#      A iH
B#      A NH
'#      A 3H
#      A H
#      PA H
֙#       A H
#      A H
#      A H
#      A H
j#      XA vH
O#      8A [H
4#      A @H
#      A %H
#      A 
H
#      @A H
Ș#      A H
#      A H
#      A H
w#      A H
\#      pA hH
A#      hB MH
&#      PB 2H
#      @B H
#       B H
՗#      B H
#      
B H
#      xB H
#      PB H
i#      B uH
N#      B ZH
3#      B ?H
#      B $H
#      XB 	H
#       B H
ǖ#      B H
#       B H
#      B H
v#       B H
[#      `"B gH
@#      P$B LH
%#      @&B 1H
#      (B H
#      )B H
ԕ#      +B H
#      8-B H
#      /B H
#      0B H
h#      2B tH
M#      4B YH
2#      6B >H
#      8B #H
#      (:B H
#      <B H
Ɣ#      =B H
#      ?B H
#      AB H
u#      CB H
Z#      pEB fH
?#      XGB KH
$#      (IB 0H
	#      KB H
#      LB H
ӓ#      NB H
#      PB H
#      XRB H
#      8TB H
g#      VB sH
L#      WB XH
1#      YB =H
#      h[B "H
#      ]B H
#      ^B H
Œ#      `B H
#      XbB H
#       dB H
t#      eB H
Y#      gB eH
>#      iB JH
##      @kB /H
#      lB H
#      nB H
ґ#      pB H
#      rB H
#      htB H
#      vB H
f#      wB rH
K#      yB WH
0#      {B <H
#      }B !H
#      xB H
ߐ#      XB H
Đ#      HB H
#       B H
#      B H
s#      B H
X#      B dH
=#      B IH
"#      hB .H
#      XB H
#      B H
я#      ؓB H
#      B H
#      B H
#      XB H
e#      (B qH
J#      B VH
/#      B ;H
#      B  H
#      B H
ގ#      B H
Î#      B H
#      hB H
#      0B H
r#      B ~H
W#       B cH
<#      B HH
!#      xB -H
#      @B H
#      (B H
Ѝ#      B H
#      B H
#      B H
#      B H
d#      PB pH
I#      B UH
.#      B :H
#      B H
#      B H
݌#      B H
#      pB H
#      0B H
#      B H
q#      B }H
V#      B bH
;#      pB GH
 #      @B ,H
#       B H
#      B H
ϋ#      B H
#      B H
#      B H
~#      xB H
c#      PB oH
H#       B TH
-#       B 9H
#      B H
#      B H
܊#      B H
#      B H
#      HB H
#      0B H
p#      B |H
U#      B aH
:#      B FH
#      B +H
#      xB H
#      XB H
Ή#       B H
#      B H
#       C H
}#      C H
b#      PC nH
G#       C SH
,#      C 8H
#      	C H
#      C H
ۈ#      
C H
#      C H
#      C H
#      xC H
o#      8C {H
T#      C `H
9#       C EH
#      C *H
#      C H
#      xC H
͇#      ` C H
#      "C H
#      #C H
|#      %C H
a#      'C mH
F#      )C RH
+#      p+C 7H
#      H-C H
#      @/C H
چ#      (1C H
#       3C HAWAVIAUATAUSLH   A(   I`  HT$HD$ uOD$@ H  HH  H|$ D$  A   AvHĈ   1[]A\A]A^A_D$ 5C w  
-# HHD$0HT$8HD$`HT$hB  H-# H|$xHl$x<HT$hD@H|$@H   H$D4C 1HAv#  #  [D$85C =#  L  HL$ H|$   L1M  o# g#  M  M1   I  Ll$@0
HL9  HT$<
u=#  uH|$ RC LI4C 1H|$HHL$ H޺   H)HH؄#  띀=΄#  vq   tHT$ H;# [H;# N=#  uHŀ5C H|$ HT$@I4C 11H|$ O4C 1 b#  Z# HL$H|$ HT$@4C 14C AD$,   @   ED$,H|$ HT$@MM4C D$,1M   D|$,E1H|$ 1L4C AC  D$,   M9   L1U    HD$HB<_v.   H|$ 1C 5A   HI9v@LJ\% L)H9t0AuHCI9vHT$H8
u|
uID$L)L$(Ht$ 
   M0M9&H|$ 4C 4C 4C a4C r4C fD  HCI9HHD$|
8|
-ID$L)L$(e    T$,RH\$1L%H|$ 4C 1HHL9JD% I9wHL$       4C 0H  C    H# H  H  HH|$  z,4C H1N  }    1H)#    H# HH)=#     H|$HL$    HHHT$   B|2
1HD$B|0
Hŀ5C H|$ HT$@I4C 1H  5C tH`  H   H  ?C vƃ   H  H|$ HT$@RC I4C 1x'AW1AVIAUILATUN$/SHMHy HL$HD$tIwLl$HD$H[]A\A]A^A_H   5C :  tAnI^M|$@t$L9sH @DPuH+@uL9wV;C 	   Ht.L9s@;tHL
D  >;t	HH9u.HHk	LHL)H)H{1HI5HHHWA A,$@'t}@"twL;   /   L<Htx HX   \   HHtILp@Lu    @8t7H t*{ HSt<\uHI\$D  Iބu 
   LHt  
   LHt  M9tL
HPLLHD$Ll$L @@	@
 H@    LH\$Ll$HHl$Ld$ILt$H8H    HG    HG    HG    HG     ~P tHFxHG 5C HHtkHt$1ɺ
   HLd$IL9tH-HD I9tCCO   HI`  Hl$Ld$ Ll$(Lt$0HCH\$H8CO   fM~DsD  AUH,H,ATIUSHX  HW HHH,HH,L,HI9IMŃH   L9o   H*OI*;   Hl$^*Y,=   N1~1H #H9uH$   H5C D (   1H$$HI|$H޸   f(Y} PI|$vMl$HX  1[]A\A]HGH  HHII  H
MIIH
H9}H1H)I|$1_?C HH9uHH9SH~HHxHCƀ=   [HfD  1҃8u     HC  ƀ=  ѐH?EHHÐLl$IH\$LHl$Lt$L|$Ld$H8La1IIHHMMH$tCHy    HKHLLII9H   A$=   uEA$<   u+H,$H$H\$Hl$Ld$Ll$ Lt$(L|$0H8H{uI<$1AƄ$=   YA$<   tH9Htd? t^A$h   tg=C )HtXHL   HH26C L1-G  UHC A$=   3s5C L1G  )H;A=C Ht!C	C
HCHC     HC(    48-HH6C L1F  ATUHSH?Ht
HE     H}Ht
HE    H}Ht
HE    H} Ht
HE     H}(Ht
HE(    H}0Ht
HE0    H}8Ht
xHE8    H   Ht_Hǅ       H   HtCHǅ       H   Ht'Hǅ       H   HtHǅ       H   HtHǅ       H   HtHǅ       H   HtHǅ       H  HtHǅ      H  HtHǅ      H  HtcHǅ      H   HtGHǅ       H(  Ht+Hǅ(      H8  HtHǅ8      H@  HtHǅ@      HH  HP  HtHǅP      Hh  HtHǅh      Hx  HtUH{L#Ht
HC    H{Ht
qHC    H{Ht
[HC    HLHMuH  Hǅx      Hǅ      Hǅ      Hǅ      HtHǅ      H  HtHǅ      H  HtHǅ      H  HtHǅ      H  HtHǅ      H  HtzHǅ      H  Ht^Hǅ      H  HtBHǅ      H  Ht&Hǅ      H  Ht
Hǅ      H  HtHǅ      H  HtHǅ      H   HtHǅ       H  HtHǅ      H  Ht~Hǅ      HP  Hǅ      HtWHǅP      Hp  Hǅ`      Hx  H  H  H  Ht0Hǅ      H  Hǅ      H  H  HtHǅ      H   HtHǅ       H(  HtHǅ(      H0  HtmHǅ0      HP  HtQHǅP      []A\ÐH\$Hl$HLd$Lt$ILl$H(   HIt!H#HxJHHu'LH$Hl$Ld$Ll$Lt$ H(  7C LHHtS17C HIt?HHuAA$: tNHH1H0tMLfD  1HV_H<H麠7C C 1IH麠7C C H10뤾  Hu ft\.
      HھP6C L1   cp$tCzfD  uHھ87C L1   7DHھ6C L1   (Hھ6C L1   Hھp6C L1   Hھ6C L1   HH=
r# H=	r# Hq#     H=q# Hq#     H=q# Hq#     H=q# Hq#     tHq#     H@ AVAUIATUSLP  Mx  = A:$t  = A:D$b  H-+q# E11H88C c  1w7C HHh:C HHuHq# HtH1u7C HH[HuH=p#  t61>C HHp# HtH1u7C HjH[Hu1>C HRHp# Hu<@ 1u7C H1H[Ht H: u1>C HH[HuHyp# HtH1u7C HH[Hu?C 11w7C HH:C HHuEtH[]A\A]A^?C LA   ]HL⾈8C L1s<  ĐSHH?$Hu[    H1[f     H?C (c t	H@ {7C (c u侓7C (c Hf.     H=Xo#  S   ?C (c bu.8C 1D  H4;C HHt(c 5t[Ho# Hu
fH[HtH3(c tҾ?C (c u7C (c uH=n# `Hn#     ?C (c u[7C (c f7C (c H\$Hl$   Ld$H   IHT$0HL$8H    5Y@ LD$@LL$HHHH)H$   )x)p)h)`)X)P)H)@H$   $   D$0   HD$HD$ HD$@HHtLHH߉H$   H$   L$   H   ÐAW1AVAUATIUDSH(;C HH  HT$(HT$@HL$ (t&1 <C L9     HĘ  []A\A]A^A_þ=   HHtHxHHD$0  HD$08@   @}  HD$@Ǆ$@        H$H     HT$0:<u	@&  PHL$0HHt$ HH|$(A   Ǆ@     HH  HcH$@  H   Ǆ@     1p  1{;C L8  H|$0@   @t  H$@  H$  HHǄ$      HǄ$      HD$8HT$HL$H|$8;   H|$8,   HHtH9HBH  E H]E  <;  H  },  D  ˿E1IE1IHDB u   H޿;C   I  LkH$@  H$  1A;C L_  H$  H! tH$@    DHFHD HH+t$H! t  DHAHD J.HH+L$1H{;Hk  1ۀ}  tH]E  tHt	;,HH|$8L$  H$  LL4  H]  HtHl$8}  ;H$  H3  1H@Hu{HRHHd  I$`  `;C 1rH|$0ؽH$  H$  34     zHT$@   Ǆ$@     H$H     H\$0HHt$ HH|$(A   Ǆ@        HHH  HcH$@  HǄ@     1躼I  1Hھ;C L5  H|$0   	   H޿V;C 躠  Ls	;   L衾HHtO HR
   HU;C {     H{;   `H  Hź   ,   L=HHuH|$0;C qHHD$@Ǆ$@     Hҹ   H$H     hHBǄ$P     H$X      BI$`  2;C 苿   HH|$0߻1HE1E1`1;C LK4  H|$0豻H$  H$  2     SH$  t"1HH9މHQHIHPuH$  H$  H(   1  Ht$ H|$(HL$@1IA      $   藺1{;C L3  HH|$0   1`;C Le3  H|$0˺H$  H$  &1     mHĺ   HAWAVAUIATUSH(  Ht$HT$HL$?-   L|"<C    LID$08   A1E1HD$     D$/ D$L     HIH     I$PC LLD$HaD$tLH    D$LI$ PC AD$/HD$ ID$0 f-HG  HD$ AD$0D$/ HT$ HD$E  x,E1IcE1H@<PC  i  C<[w5$FC 11fHHH   tH PC 8uAy   H(  []A\A]A^A_À|$0 p  HD$H  HtӸHT$Hǂ      =r  K        HT$HH  R  $  ttEC H11  HD$ǀ$     |$/ u)Eu$HD$ HD$ 8 tHT$A: 1&AD$/H@H PC HD$ E|$/ 
  HT$ HD$Db  |$L@LogHD$H    
  HT$H  @ Hu
)B   HHD$HH  uH|$hs  HH,  o|  |$0 H@    `  H M |$0 (FC H1DHc# Hx@ tL1s<C *Hc# H@@H0HtH1K4C HsHHu?C Hzc# @    <C 11̸HH     HBc# @ _C tH _C K4C 1蔸HD$H   Ht\HT$Hǂ       H|$   	   .HT$Hǂ     HD$Hǀ0     AD$<5Q
  $IC AD$<W$pKC D$0HT$8  aAe  Ao  D$0HT$d  8H|$Ht$Hǘ   q     mD$0HT$`  D$0HT$@  T$0HD$P@T$0HD$^  |$0    (  D$0HT$>  D$0HT$]  {H|$^<C H   HT$Ƃ\    HT$H   Ht裴HD$Hǀ       H|$ GH|$]HT$H   AeHǄ$      HǄ$      ^  HT$:@  H|$HHH$  t
=H$  HD$H   H  H$  H   HH5HT$HHH   
  HųH$  Ht	   誳HD$Hx0Ht蒳HT$HB0    H|$ 9H|$OHT$HB0HD$8@  HHD$HD$Hx8Ht6HT$HB8    H|$ H|$HT$HB8D  D$0HT$Ata  b  vHt$H|$o  _HT$H|$DC 1>+  DHT$^     DC H1   +  vT$0HD$Hǀ_  HH  &     :H|$HǨ  Ht$Lh  ŅHD$ƀ?  HL$HT$AsHt$H|$AAH  H°  IuHT$H|$   H  %  MaAD$<
  $0NC HD$H   Ht耱HT$Hǂ       H|$ $H|$:HT$H   D$0HT$[  HD$Hx Ht!HT$HB     H|$ H|$ްHT$HB HT$Hǂ     vHD$Hǀ     aHT$Hǂ     LHD$Hǀ     7H|$C =7  H|$Ht$Hxh  HD$@Q HD$@PHD$H   V  HT$H  @ Hu(B W  HHD$HH  uH|$k  HHP ЃC HD$8   S lHT$H   Ht軯HD$Hǀ       H|$ _H|$uHT$H   @ AaD$0HT$l  |$/ (  D$0HT$1<  +|$0    γD$0HT$BHT$<+  <-
  H|$Ht$Hp  d  D$0HT$   XH|$H  v|$0   HD$ƀp  ƀZ  HD$   D$0HT$    蛮HHD$HE DP  HD$t+Hu HDFu-t	,V  QHuHT$H   HtHD$Hǀ       H|$躭HT$H   dHD$H   Ht賭HT$Hǂ       H|$ WH|$mHT$H   HD$8@  HD$HP  HtXHT$HǂP      H|$HT$HP  HT$H   HtHD$Hǀ       H|$ H|$ѬHT$H|$H   [f  Ht$n<C H   c  D$0HT$Y  DH|$Ht$H   h  HT$H    Hǂ      HT$<-H  <=5  <+HHD$HT$ǀ     1گH|$H$  H$  HT$H  Ht$HT$P     H$   HT$H  `D  H|$Ht$H   g  #HD$H    *Hǀ      HD$H(  HtiHT$Hǂ(      H|$ 
H|$#HT$H(  ǂ0      D$0HT$X  D$0HT$p  H|$  yHT$1E1 |$/ B
  H|$    HD$E1 k?C    蕩H HHx  HH  HT$ǂ$       H|$-   HH|$DC H$   "  H|$11
   質i<C HH1    HT$H   HtHD$Hǀ       H辩HT$HH   @ H|$HEC 1?"  H|$:   [HtJ  HT$HXH  HtyHD$Hǀ      H H8HT$H  HD$H  Ht6HT$Hǂ      H|$ H|$HT$H|$H  zb  D  ` HxHt
٨HE    H|$ H|$蛨e HEbHD$H     HT$H  @ Hu(@ B tjHHD$HH  uH|$Ld  HHHxHt
BHC    H|$ H|$K HC    HH{HtfHC    H|$ɧHC{HT$Ƃp   ƂZ   :HH|$=   qH_HT$Hz(Ht蕧HD$H@(    H|$^HT$HB(HD$H|$Ht$Hǀ  t]  #H$  HT$H   H$  H   D$0HT$<  HD$HT$ǂ     HD$Hh  HtHT$Hǂh      H|$ H|$蚦HT$Hh  DHC HHD$CtmH8R# A<C H|$HHP  Na  HۉtH;R# tHFHT$HP   H|$L⾒<C 1  Ld$>C LpHHD$XFC Hǀ      1}  HHmHT$H   &H   H$  H$  HH<;9HD$HH   H$  C 艥H$  HtwHǄ$      H$  HT$HH   HT$BQHBx    HC HHT$ң   HP# Ab   H$  H_  H$  Ht
H$  HtH;P# tHWH$   =  uA      HH$  rBH$  H$  H^  뉿   謣H  H|$=C 蟣HH HT$H|$PDC 1  H|$HHHT$Hx  Z  HP# @ ~T$0HD$  iD$0HT$BSWHeP# @ "   HD$H  Ht蕣HT$Hǂ      H|$ 9H|$OHT$H  HP# @!@t]HD$H  Ht;HT$Hǂ      H|$ H|$HHD$CC H  謡   H|$Ht$Hǰ   tZ  gHHpO# @ tD$0HT$E  @HD$ƀ  /HT$ :uq :BueH1N# HT$H`  HD$H   HtJHT$Hǂ       H|$ H|$HT$H   H|$&<C dHHt2HD$h   tH`  rHT$H`  Ƃh  eHT$H|$)<C 1D  J|$0 t6HD$HHH4|$0 t/H;N# @  HD$HHH
HT$HbHHT$HbH|$0 t6HM# @ HHD$HHH|$0 tHD$HHHHT$HbHHT$HbH|$0 HD$H@HwT$0HD$B  bHT$ƂA  QH|$Ht$HǨ   \  3Ht$ HT$ Hz A   Ht$"   豟HusHD$Hǀ      HL# @!@BHD$H  Ht HT$Hǂ      H|$ H|$ڟHT$H  f % 8HD$H  HtɟHT$Hǂ      H|$ mH|$胟HT$H  -HD$H  Ht|HT$Hǂ      H|$  H|$6HHD$HH  YH HT$H  HtHD$Hǀ      H|$ H|$ΞHT$H  xHK# @!@HD$H  Ht趞HT$Hǂ      H|$ ZH|$pHT$H  D$0HT$h  HD$H  HtTHT$Hǂ      H|$ H|$HT$H  HD$H  HtHT$Hǂ      H|$ H|$HT$H  kHD$H  Ht躝HT$Hǂ      H|$ ^H|$tHT$H  HD$H  HtmHT$Hǂ      H|$ H|$'HT$H  HD$H  Ht HT$Hǂ      H|$ H|$ڜHT$H|$H  dV  zHD$H  HtɜHT$Hǂ      H|$ mH|$胜HHD$HH  &d<C   HT$Ƃ  HD$H  HtRHT$Hǂ      H|$ H|$HT$H  HD$HD$ǀ     D$0HT$c  H|$=   蝝H  IL+t$8@HX  H$  Ht譛HǄ$      HXHpHHH$     藛H$  H$  HtrHD$$  H8^H$  IHt9HǄ$      ML<J\0IH\HH  L@	=  
        DHH$  HǄ$      H|$Ht$H`  V  /HD$HxHt|HT$HB    H|$ #H|$9HT$HBH|$Ht$HǠ   uV  HD$H  HtHT$Hǂ      H|$ H|$̙HT$H  vD$0HT$BRdHD$H  Ht賙HT$Hǂ      H|$ WH|$mHT$$  H  vCC H1  HD$ǀ$     HT$H  Ht?HD$Hǀ      H|$ H|$HT$H  $  ttCC H1  HD$ǀ$     vH|$H$  11UH$  HÀ}     =C H$  E B<+w\$ŠNC |$0 tH0E# @ D$0HT$BAHHT$H  H  HH
H|$ DC 1     H9Hl?C H$  ZD$0HT$BB|$0 tzHD# fx  HD$HHH ^D$0HT$BSIHT$HzHt蛗HD$H@    H|$ BH|$XHT$HBHT$HbHH|$1HT$H|$H   P  Ht$?C H   eM  D$0HT$BRHHx  HH  THHx  HH  HL$HT$1H|$=<C H   H   rN   HT$   +      
E<C H1     QHD$H  HtCHT$Hǂ      H|$ H|$HT$H  ǂ     HD$ǀ      HD$H0  HtؕHT$Hǂ0      H|$ |H|$蒕HT$H0  <|$0 tHCB# @ D$0HT$  D$0HT$I  |$0 tHA# @ PD$0HT$  HT$D$0    ǂ     HD$HP  HtHT$HǂP      H|$ H|$覔HT$HP  PD$0HT$X  ;D$0HT$Y  &D$0HT$\  HD$H  Ht]HT$Hǂ      H|$ H|$HT$H  ǂ     H|$@   ͕H0H\$E18HD$ƀ\   -H޿C 艒tDH~?# H$  H$  HfM  HۉtH;X?# tH.'H߾=C HHt_H$  H$  HM  MtrLD$HMLV<C H1NHCH$  L:H$  HT$H|$PDC 1  H$  H$  1L  KLHL$  HT$H   HZ躒HD$Hǀ       @HT$H  Ht菒HD$Hǀ      H|$ 3H|$IHT$H  ǂ     D$0HT$  D$0HT$F  D$0HT$G  H|$Ht$H  9N  mH|$Ht$H  N  iJH|$Ht$H   M  F'HD$Ht$ƀ  HF  HT$  H&># @  xD$0HT$D  HD$H(  HtAHT$Hǂ(      H|$ H|$HT$H(  D$0HT$H  D$0HT$(  {D$0HT$H  fD$0HT$C  QHt$H|$GF  HT$8  2HD$HT$H@`HHXZH  H HT$H|$BpHHT$Hh-H  HH|$H   Ht$H|$D  HT$Hx  HD$HP  HtHT$HǂP      H|$ H|$诏HT$HP  YD$0HT$[  DHD$H  Ht蓏HT$Hǂ      H|$ 7H|$MHT$H  ǂ     |$0 tH;# @ FT$0HD$  H|$Ht$H@  OK  HD$H@  HtHT$Hǂ@      H|$ H|$讎HT$H@  XH|$HH  vD$0HT$BT5HD$H8  Ht脎HT$Hǂ8      H|$ (H|$>HT$H8  HD$H(  Ht7HT$Hǂ(      H|$ H|$HT$H(  ǂ0     D$0HT$Z  |   'H  @S   ߾c (H:# ߺ`c 1H9# H:# H9# H9# %9# H9# H9# H9# H9# H9# H9# H9# H9# H9# 9# 9# 腋[   Éߺc    m[   fD  H\$Hl$HLd$Ll$ `C Lt$IH(11I<Ÿ   D1H5g8# HALL׋H~VBD( Eu,tLH$Hl$Ld$Ll$Lt$ H(H58# 
   :   ~AE  멐S`C 1H<ݨC HHu[Ã	w$pC fnC øC ø`C øC øC øC øC øC ø|C f.     Ht9t1HC 6     HÉ21HÐHwHu1HÀ8 tHHJf.     S1C HHtH[fD  1ŋC HHu׊HtHx Htǀ? t[AT   USrHH7#    tfH@@H7#     HtPH8 tJL% HML@C u$HH3HtH} m  tHCH	B7# HEHHu1[]A\ÐAU  AATI1USH  HH$  ƈH5# Ǆ$      Ǆ$      H$`  $  v$  t
tu4H׊yLDHu  H˻HĨ  []A\A]f$  ZŐHHtHPHHHf     ATIUHSH?HtH_uHHuMHE     tI$    []A\ H\$Hl$HLd$Ll$   Lt$IH(   IIL腋H    
   HhHHLDMt,      PHti    LhHHLMt,      Ht8    LpHHLHH$Hl$Ld$Ll$Lt$ H(HL1ԐHl$Ld$HH\$H   IHT$0HL$8H    @@ LD$@LL$HH)H$   H)x)p)h)`)X)P)H)@tKH$   H      C $   HD$HD$ D$0   HD$葊HLH#HﾸC 1$H$   H$   L$   H   @ Ld$H\$IHl$Ll$Lt$H  H$0  H$8  H    @@ L$@  L$H  H)H$  )x)p)h)`)X)P)H)@Z   t7H$  H$  L$  L$  L$  H      H$   H$   HH   Ǆ$      H$  H$   Ǆ$  0   H$  肇qII$`  	      C F~uoHE   AD DA uulӅI֍CHcu
EF   AE   I$`     L)ÈI$`  
   Ol5jI$`  LHz0w!   H   
 H   Ht1ɉD  H\$Hl$1Ld$Lt$ILl$L|$Hx  L$P     LHƄ$    HH0# L$h  H$`  96  tUI$`   C 1A   DH$H  H$P  L$X  L$`  L$h  L$p  Hx  t!I$`  (C 1A   -5  fD  ;HHD$0 u"I$`  XC A   q5  aHD$0?C    I$4IǄ$   AǄ$   AƄ$?   AƄ$A   IǄ$   2   ID$XAD$` ID$hAD$p #)  HSHsC HT$   ;u
H{?-9)  L1`@  A   D$CC McJHHT$ :-t<H0H$?  LÒC A   AD9~,|$C uIcHHֿC w  D$C I$x  H *  Hx )  I|$  *  I$   =*  I$   H  A$?   b  訂I$   HD$8Ht豂IǄ$       H|$8 *  A$_  I$  LA   .  H|$8cL4  H|$0I$    蔾$Z   tH$`  Ht踄$X   tH$P  HtHǄ$P      A$    tI$  HtsL+A$h   tI$`  HtN2  E1A9}	HD$J4H|$ H$?  L(  $?   AI$     LA   HD$8    躾='  A$   &  I$   HtC ))  I$x  E1HHT$(  HD$(Ǆ$8     HǄ$       Hx %  HT$(HzH3&  荀HHD$PF&  HD$(A$>   H@HD$Hu@Ht;A$   1ɅtI$`  Ht$HH$8  H$   q[  A'  D$8  E0  H|$H D$D    D$DT$DHǄ$      HǄ$      Ǆ$4      E|$ tu9H$   H!  H$  P  A8#  H$     A$>   =   E$   1EtI$`  HD$(H$4  H$  HpZ  A.$  H|$P   H|$PC }  D$4  E  H$   E1D$\    HD$H|$1۹   HH$  HǄ$      HH*# L$8  HH$0  a  H$   O  A  D$`    D$g A$   t7$    H$   K  I$`  1D꾼C  A<u   $*   (  H$0  H  ҀEu';  I$`     ˝C 1A   要$(   tH$   Ht}HǄ$       H|$1   HH$  Ht}HǄ$      H$   Ht}HǄ$       |$g   $4    Du
AD9YH$  Ht\}HǄ$      H$  HtNJ  HǄ$      $8    DzuD$D;\$DD]H|$P t
H|$P|H$   HtI  HǄ$       HT$(HzHt|HD$(H@    HT$(HzHt|HD$(H@    HT$(HzHtx|HD$(H@    HT$(B     uHD$(H HHD$(ZH|$8 @ $)   u H$0  HtEE A|$ @ $)   H$    H|$0H$  1   HǄ$  8zH$  HH$   H$  H$  H$  2zWE  HT$(Hz6{HH$     H|$P tH|$P{HH$    HD$(@ u#H$  H   C y   H$  H  H$  Ht,H$  HI  HAzE  H$  A$A     A|$Q   I|$x .  HǄ$0      H$   Ƅ$)  H$  H  H-    H$  H  H-  t\It$H11HHt uA$H   u~C L1wH$  /8C x  D$`    D$g HD$h1H$   tA|$Q <  H$  ID$xH$   HM-  t/H$0  Ht"w@xtAƄ$q  AƄ$p  $4  ~KA$Z   u@L$  I$`  [C L$   AWdC MLD1||$\  H|$8    H$   *C HyHxH/   HD]yHH  ?   HA&   ^zHz  HxH|$8HxH|wHHU  H  H$   LD$8HA;C 1Q{H$   Ht/xHǄ$       H$   I$`     A$   t-H|$011A   Ay   C L?>  A+H|$0L$   11A'  C L>  AH|$011A`K@ A+N  C L=  AD$`H$  H|$01A'  ԓC ILL$  $  1=  AH|$011AJ@ A,N  C Lq=  A]H|$011IA'  C LG=  A3H|$011A@K@ AN  C L=  AI$  H  H|$ht,LL$hH|$011Au  3C L<  AL$   H|$01A'  LC L   <  AE$p  H|$011A+   XC Ls<  A_A$_   ^  H|$0A   11A,   kC L7<  AA   H|$011A*   zC L
<  AM$(  H|$01A'  C L   ;  AM$   H|$01A'  C L   ;  AE$X  H|$011A=   C Lv;  AbI$(   t0Mc$0  H|$0A`C e   ĔC L{6  A'I$  Ht]H|$0IA'  1C L   ;  AMc$  H|$0A`C e   ĔC L6  AA$H   I}  A$D   A   h  A$E   A   S  A$F   A   >  A$G   )  M$8  H|$011A'  C L>:  A*E$]  H|$011A-   C L:  AE1H$   H|$0A.   C LA119  AE$`  H|$011A0   C L9  AE$Y  H|$011A2   /C Lw9  AcA$c   A   u A$d   uI$h   ;  A   H|$011A3   >C L9  AI$h  Ht*H|$0I11A'  LC L8  AE$[  H|$011A5   _C L8  AM$   H|$01A'  tC L   8  ArM$   H|$01A'  C L   T8  A@H|$0L$   11A'  C L%8  AM$   H|$011A
   C L7  A<#   E$a  H|$011A4   C L7  AE$b  H|$011Ai   ͕C L7  AuA$  i!     M$   H|$01A '  'C L   =7  A)E$\  H|$011A:   7C L
7  AML$ H|$01A"'  KC L   6  AM$  H|$0''  ]C LD9  AM$   H|$011AD   pC L6  AqI$0  H  ID$HH  E$Y  H|$0A   C LLHA$Z   LELHA$[   LE116  AA|$A T   A|$B    M$   H|$01A!'  C L   5  AM$   H|$011A   C L5  AM$   H|$011A   C Le5  AQM$  H|$011Au  +C L65  A"M$  H|$011Au  HC L5  A1A|$P tID$xH|$0I11Au  eC L4  AM$  H|$011A)'  C L4  AM$  H|$01Af'  C L   m4  AYM$  H|$011Ag'  C L>4  A*M$  H|$01Ah'  C L   4  AM$  H|$01A*'  ŗC L   3  A # 0]  I$  Ht-H|$0IAQ'  1C L   3  AI$  Ht-H|$0IAq'  1C L   Y3  AEI$  Ht-H|$0IA'  1,C L   3  AH]# @ tfA$@     H|$0E111A@   <C L2  AA   AQ   SC H|$011L2  A# 0tA$@     A$_   uA|$ t-H|$011A   AE   C LT2  A@E$  H|$011A   C L$2  AM$p  H|$0,'  C L4  AM$x  H|$07'  C L`4  AM$  H|$0m'  ԘC L64  AID$(Ht-H|$0IA&'  1C L   o1  A[ID$8Ht-H|$0IA/'  1C L   81  A$ID$0Ht-H|$0IAb'  1C L   1  AEL$@H|$011A`   C L0  AM$  H|$0AC     /C L+  AE$  H|$0A@C !   BC L+  A`M$  H|$011A"   XC LE0  A1M$   H|$01A4'  jC L   0  AM$`  H|$011A5'  C L/  AM$   H|$01AN'  C L   /  AM$  H|$01AO'  C L   /  AlH$  LHbA$8  uA$p   uA$Z     M$  H|$0V'  C L1  A
ML$H|$01A\'  C L   .  AML$H|$011A]'  
C L.  AM$   H|$011AN   C L.  AI$  Ht-H|$0IAc'  13C L   Z.  AFA|$R   A|$S }  A$$    I$  HtZH|$0IAi'  1C L   -  AH|$011A   AZ   C L-  AE$B  H|$011An   `C L-  AI$   H
  I$  A   HtHA   tE1H|$011Aq   C L@-  A,A$   A     A$   A   m  A$   X  A$   t0Mc$  H|$0AC    C L(  AM$(  H|$01A'  )C L   ,  AE$H  H|$011A   =C Lj,  AVE$C  H|$011A   [C L:,  A&E$8  H|$011A   tC L,  AA$   t\H|$0A11A   C L+  AE$   H|$01A   C L   +  AM$0  H|$01A'  C L   q+  A]A$I     A$X     A$\     H|$011A   A   C L+  AI$`  Ha  I$@  H!  I$@  Ht-H|$0IA'  1DC L   *  AI$H  Ht%H|$0I'  VC L-  AuA|$T =  A|$`   A|$p   HT$(B tA$h   <  H|$0E111AoN  C L *  AE1I$    MEH|$011A-'  C L)  AI$  Ht%H|$0I'  ќC LG,  AH# @!@   I$  Ht-H|$0IA'  1C L   l)  AXI$  Ht-H|$0IA'  1C L   2)  AI$  Ht-H|$0IA'  1C L   (  AI$x  H
  A$     I$P  Ht-H|$0IA'  1VC L   (  AI$    HtHi  I$  HHD$p%?  H$   H$   H$  H$  耞A,H|$0;cA$h   At/H$0   t$A$Z   uH$   HthC 1cH|$p   I$    
  A
  A
  A
  A
  E	  A$]   tAf	  H|$0H$  1   _H$  H-  Hc
     HS㥛 LD$pLHHH?HHH)pC H C 1HH-  I$   uHD- '	 H='	 HNH$@  Ht~H$    tsA$Z   uI$`  C 1cH$0  
dH$H  H$0  ^Hމb  H$0     1_HǄ$@      Hl$p&H$    y    E\    ]|$`b^f$HǄ$       <D$`    D$g HD$h$4  CH$   E1D$\   HT$OǄ$4     A   D$`    D$g DbHE A?   D  vI$`  H軖AD$`    D$g |$H$  2  H|$H^HH$  I$`  2;C A   2H$   H$  H|$0  HH$   H$  11aD$`  H$  ƿ   `Z  $  D$gHD$h%   =   LH$  HT$h:I$`  C  C C 1cahH$  H޿   ]   H$  H$  ID$xC L1D$`    D$g H'	# I$`  VH$  +C H\H  H$0  H$  ID$xƄ$*  H$H  A   aH$   yC C 1_H$   H$    teAD$`    D$g H$  ID$x    %H$   HL$8HǾC 1_FI$`  2;C 1H$  Ht	; A$h   I$`  C 1A   D$`    D$g 1   @  <^8\1H@C L1yD$`    D$g HD$hH$  I$`  .C 1A   L|$`CZD$`    D$g +H$  I$`  .C 1A   D$g H$  I$`  .C A   D$`    D$g H$  H[DHǄ$      ifHxHtZHT$(HB    HD$(HxHtZHT$(HB    HD$(@     Y1Lj  I$x  HI$`  1A   $HD$P    q   '\HI$`  2;C A   H|$0H$(   @ 1HǄ$(      E1XH$(  '  H$(  ZI$`  Až2;C 1~A   H|$0AC o   ֔C L&  AE1 E$^  fH|$0I11Ab    C L  AA$Z   A   I$`  C 1\H|$P H|$PYA$   I$`  ɒC 1A   E1vI$`  HT$ HC 1AUMI$   A$@   ܒC ZHHtSHXXHI$  tiHsXq  HID$ NI$`  2;C A   C ZHH   HWHI$  uH
XI$`  2;C 1A   xI$   A=C )WHHtHI$   Ƅ$Y  Ƅ$Z  H$`  H$P  C YHHI$   C L1A   H|$0H$    1HǄ$      UH$  H      ۋC :     H|$0H$  1   UH$  H  Hwx   Htl      3  H$  HH$   H$  H$  HH$   H$  2  I$   Hi  H9A$8     I$P  HtH|$0H$   3  EA$p   $*   H$0  HjTH|$0n7  W8VHC HL1X]$  _H$  
   UHH|$011A   A   BC L  AH|$0IA   1(C L     AML$hH|$0AC    C L  Ac
ML$XH|$0AC    }C L  A1H|$011A   A   hC L  AH|$0APF@ 11AoN  C L  AL$   H|$0I11A   /C L  AH|$0I11A   C L{  AgM$`  A   C H|$011LL  A8AE1A   C H|$0E111A   ЛC L
  AH|$0E111A   C L  AH|$0E111A   C L  AMA   H|$011Aw   C L  AnvH|$0I11Au  ٚC LS  A?H|$011AP@@ A~N  uC L!  A
H|$011MAo'  C L  AH|$011A   A)   C L  AH|$0E111Aj   `C L  ATH|$0E111AU   KC Ll  AXH|$011AI@ AXN  C L:  A&H|$011IAI'  ˙C L  AA   A@   <C -%HHA   Hƺ/8C 1jC THHX  H|$0IA'  C L   1  HA6QA0  HQEaM$  H|$01A'  חC L   >  A*M$  H|$01A'  C L     AM$  H|$01A'  @C L     AH|$0IAC k   C L  A?H|$0IAC T   C L  AfM$   H|$01A'  C L   C  A/M$   H|$011Au  C L  A M$  H|$0('  C L  AqH|$011A   A   ҖC L  AH|$01A?C Av'  C L   ~  AjwHOfD  HA   N?MD  fD     QfD  UHSH*C HH    HOHPH/   HEH(OHt
x HxuH1[]INHHE    uH[]fATIUSHx  HtUH{H+Ht
,NHC    H{Ht
NHC    H{Ht
 NHC    HHMHu[]IǄ$x      A\    Ld$IHl$Ll$Lt$*C H\$IH(LINHxH/   ID(NHHtH}     /   LNHHǾ\   IDHMHHp   1LGLHItWLGMLH<MH|bLHHt}HtMHLL⾩C 1 PLLMtLLILH$Hl$Ld$Ll$Lt$ H(HLL C 1O뱐HCHLHELLLMtLE1uL SC HK   t	[D  H߾/8C J[1҅     HSHtH   &C /  t[   H޺   .C /  [        SH7C JHtH31u7C MH[Hu[[KC J     H=  u      HM   JHtHcurl/7.2@6.0 HHÐH\$Hl$HH`C Hb.  1҅tH\$Hl$HHH޿eC =.     uH޿lC '.     uHھC Hn1f.     H\$Hl$HHsC H-     uH޿{C -     tH\$Hl$HfHھC H    f     UHC SHHz-     uH޿C d-     tH[]fH޿C C-     uHH0C H   []fD  fD  SHH?$JH	   tH0[ÐHl$Lt$IH\$Ld$HLl$H(  H>H  :   DKH   H$     1$   GH] HmILL$   IغhC    HI1L5K   LHH! tH}   DHCHD HL)ItKIĸ	   MtK|,HSLC,:=JLe 1H$   H$  L$  L$  L$   H(      1fD  fD  S1H1H1HHHH1Hv
1J1҃8"[D  Lt$H\$IHl$Ld$Ll$L|$H8HH<$   HGHI   C HJHH  GIIE1Aun-tB=tT+tZLD  G   H\$Hl$Ld$Ll$ Lt$(L|$0H8 A   H@    A    E1H5 Ht?C fD  HHu Ht%H;*  tAterYAthH}   uAt:H<$HھC 1e1C IHHLF1(I    HEI	HEHI!HEI    HSHtFHH¾    [D[        AW1IAVAUATE1USHHH|$Ht$   E1A   1E1MLIuHHH   H| LLH)   GHHt3HtL9uAIA6uHE	   H[]A\A]A^A_L9ID  tKHuHHHtHu=HD  t
HvE1HT$L"HT$HH1[]A\A]A^A_HHtIM	   tL4EH	   []A\A]A^A_AWE1AVIAUATUSH  HH|$   Ld$E1   
   LFHt  
   LFHt  LH! tL  DHAHD HL)Il
 HuiGHHtGJ<(LIIFL   LCHXHD$L81H  []A\A]A^A_M	   tLD	   ՐS(   H   mFHH  HtHtHl  H  B [HÐHx      H\$Ll$HHl$Ld$H8HIt1Ht$1ɺ
   HDHl$IH9tHCHH9t   H\$Hl$ Ld$(Ll$0H81Me ߐAWIAVAUATUSH8  HH4$3  ? *  a A:]  R A:GL  L5" M      Ll$ D$    1E1   LBLHƋH! tL  DHAHD HL)HtgEH  LHIC
   LDHH   L   LAH   M\LfAHIu1L;5" tLDH8  []A\A]A^A_臶HHA C HAH=    HA A:>C L@IHt MpD$A$]  AH0L@ H] <  DF u/Hl$w   H$    HH  U t,DF   =  :  HU uԉHtGDF    =   :   "X  E HfDF uHuH 1;    @  H$H|$H$/  11ׅt; A:   t&5LD$L$IH<$LC 1趸@t
HtH@L@4MHU   H
E  HU L? A:G<C LDhH$H|$H$/  H	; )$/      Hn?HHEHHD$p?Hx>H   HHEHT$t<"t<\tHHu    rH<rtc~F<ttd<vuF   ?    H$   MA7C HC    H1I@t<nt!H@1Hf
   	   ߾
   fL   q>ZH\$Hl$HLd$Ll$1H(IՉLML =HP   tfHtau]I$Ht"I9l$LuaHBHH9tTHJHuHL(C H\$Hl$(c Ld$Ll$ 1H(S{ H\$Hl$Ld$Ll$ H(LPC fD      AW1MAVILAUATULSHHX:<HP   At
Htt@ HXD[]A\A]A^A_L1C P   HI4?IH   LD  HSHHH   HҸ7C AC H!վC HLD(c 1dz   H   LH!ကtȾC H  DHBHD ɹ?C H1L)?HHHUHHH⾲C (c 1yAAD  AW1MAVILAUATULSHHX:HP   At
Htt@ HXD[]A\A]A^A_L1C P   HI=IH   HLfHUHHH   HҸ7C AC H!ӾC HLD(c 1y   H   LH!ကtȾC H  DHBHD ɹ?C H1L)%>HHM HTHHH⾼C (c 1txAAH        AUE1ATIUSH:H<   9Ht}A$IHńu-h:H DP@   ] HA\$It=
tJ
tU	t~\   "fufE \"E HA\$IufE  HL[]A\A]fE \nE HfE \rE HHӾŤC 1H<h fE \tE HRfE \\E H?f.     Hl$Ll$DLt$L|$IH\$Ld$H  H$   A'  IIL$X  Ǆ$  (   H$  H$0  H$      H(Ǆ$  0   Ld$HˤC Hپ   L1;1HL7Hۉ   M   E1E1IP   tTuPuLE@ J  E_  Lǽ   HHt!H(c LxC 1vH߉{8H$  H$  L$  L$   L$  L$  H  ÐA/u  v<H$   Ǆ$  0   Ld$C H(HHM1E1E1"H$   Ǆ$  0   H(AN  Hw(H   @   AC A   1E1 H   AФC A   1E1ɉL1LD$D$Q6D$LD$LLC 0c 1tLLC (c 1tIE11A   E1E1   E1{H\$Hl$HLd$Ll$1Lt$IH(LM5HP   tMuH$Hl$Ld$Ll$Lt$ H(Åu݋" 1
C c ډ" tu1ھ)C  c su1ھ9C 8c su1ھ)C 8c sf0I1ھC  c suEMd$Mt#L6I<$8HIu   LC (c 1`sL5H\$Hl$HLd$Ll$1Lt$L|$IH8LMY4HP   tMu(H\$Hl$Ld$Ll$ Lt$(L|$0H8 uԋV" 1WC c ډ?" ru1ھuC  c ru1ھC 8c rv1ھuC 8c krY  C  c p7ME11ھ8C  c &rK  IW1XC  c r,  MMtL]4I|$HI:  ID$PL򾀣C uL򾨣C uLأC 1 c q   I|$X t<L3I|$X2HI   H¾C 1 c bq   I|$8 t8L3I|$8HI   H¾0C 1 c quPMd$HMC  c ou$M?ML`C (c 1pML03C c <oE   113AWAVIAUATUSHHp  L`L9w2   LHI<Ht
2I    IM9p     AtMILHJ0zPHBPuHzXHt@ŃxEHcIH    IEXH<HtH2IEXH    HuI}XHuII2KD7X    M9p  cI  Ht1Iǆ      HL[]A\A]A^A_1        AWAVAUATUSHxHt$(H|$H    H|$(HT$1LxL0H   O  H\$(I1N  HT$PE1E1HD$     HT$cHl$(IA   HD$ I,L9rL|- LIw4H  IHT$ LI| L2H\$(   Hl$ <#Hku1SH HkDPzHt$(1ɺ
   H~0H]HL$HPHp  HH9AHH
HPPH@PHD$0HJt$0HL$8HBHD$@HBHD$Ht[tt   C 1V2L.0   Hx[]A\A]A^A_HB* HL$1L)L/   D$:Lt$PA   D$Q D$PL$@DD$DH|$PLd$P@C    11A$I! tLt$P  DID$LD IL+d$2H)HD$BL4Lq/If     Hl$H\$HLd$Ll$Lt$L|$H8H<$H$L  Hx  H           Ɔ  Hp      LoE1D  AtbLHHHD(P0    5  C 10   H\$Hl$Ld$Ll$ Lt$(L|$0H8LLLH躎4C HL 1[0HII)IL9p  bA H  .H$HH   t1Hp  HHHH;p  sHHHT(P2      /Hz Bf;BfBfB     f@
AIMHD@LL@C 1/HII)&HPHH@HHk-ILLHٺ4C 1MM)=/BB
:B	B
,BB
HBB;BB
BBfD  fD  H\$Hl$HLd$Ll$ILt$L|$HxHL$HD$HH      tG{tB[t=}  ]  \HN  H HHufD   I$p  I$  HHT$,HT$HI~  I$p  HI$p  <[t3E1<{  DH\$HHl$PLd$XLl$`Lt$hL|$pHxfI$p  L}D$<   LsHHHI$p  HJl P+SIH P    HD$FHT$8HL$4LL$@LD$GE    fE  C H$L1,@  D$8;D$42  EED$4E|$G:z     EA>0:  ]   L,H  HpHL$<LHL)LAP    } o  EHT$E1+ED$<I$  HC P   1A   ~,qHLuI$  HI$  LkJl"PfE  fE  HE    I$p  E    HD$AE <\t;m  <,  <[ t  t  IUIՈIAE H<\uA} IUtIEIIHAE HD$FHL$8HT$4LL$@LD$GE    LH$}C 1U*   L$4t$8@8}w@)ЃiD$G<]2  <:A  I$  MxC P   1A   3+QH{t[t}t	]HHI$  LHC P   1A   *fHT$I<H(HD$I        <{t<}t3<]LaC L C H|$P   1A   w* H}HK  uHcH2+HHD$    HT$ HUHEH3  H]I$  H'HUHMHH< '  BfEA} }   I$  III$  LC P   1A   )I$  2;C P   A   )LEC f} q  HME11H<HtO'HEH    HMAHfD9}HtH#'HE    fE  fE     P&HEIuHL$8IVLA  EHT$D$8IE @aHfEVIE HDPu}|$F]fD  lD$@hD$<   I$  C P   1A   T(oE	UE1)HT$D$<&   EMM
@u	u|$F]u݋D$@HMI$  2;C P   1A   'f~2E11H<Ht%HEH    HMAHfD9mHtH%HE    fE  fE  2;C H|$P   1A   c'~f} ~\HME11H<Ht0%HEH    HMAHfD9uHtH%HE    fE  fE  HMD  Hl$Ld$HLl$Lt$IL|$H\$HHH    HII$Hx#HI        &HHu7Lo$   H\$Hl$ Ld$(Ll$0Lt$8L|$@HH    HHǀp      M$HL$H   HHx  L  ƃ   #tgMt/   t&      H  EоC L1Y'L#H#A      :@    ,D$I] A1H)HS㥛 IHL)H?Hi  HHH)H9H9H|$Ht$HT$HL$t'H)H)H*H*^߶ Xf(fD  H)H*^
 f(D  fD  HfD  fD  HH   Ht$
&u>HD$HL$HS㥛 HD$ HH?HHH)HT$(HD$ HT$(HHH|$ 1!㐐AWIAVAUATUSH8HL-" Ht$tttmHIfC<r   <tf   <n*  L\   "{L!HHt&t<%t*<\ tLH!HuH8[]A\A]A^A_CHk<%   <{t.L%   H!} L!L
   {!뀾}   H<#HIt H=  LcD$A    H5 11HpC HHtgLtHcHhC vrD$I^AL	    L
    L%   H H=" L`C 1I^F$D$AhC $ŠC HT$  0 1LeD$ C L   #HHT$  0 HT$  0 HT$ ! 0 HT$  0 HT$  0 HT$  0 1LD$ C L   #HT$  0 HT$ 	 0 AHT$ 
 0 2HT$(   1L@HT$(C L&#vHT$(   HT$(   1LNHT$(C L"7HT$(   HT$0  1LH|$0HLd HT$0  HT$(   yHT$  0 SHT$(   [HT$0  HT$0  HT$(
   4HL$HH4C L1"oAW1AAVAUIATE1USHLt$fIcHH C Ht](C 1LLHD$    u0H\$Ht&H;E1HHHD7 uAA1D  H[]A\A]A^A_ÐG@<w$PC Y   fD  úA   B   C   D   f޺E   ׺F   fκG   ǺH   f뾺I   뷺J   f뮺K   맺L   f랺M   뗺N   f뎺O   뇺P   f{Q   qR   gS   f[T   QU   GV   f;W   1X   'Z   fD  fD  AUIATUSt[Hu[@ EIt?A] Ht>AA8tA} []D8A\A]1~AqAfD  fD  Ll$Lt$IH\$Hl$ILd$L|$H0D'EtO.@tGH   IA@8u#EgIIEtAm I@uG MtKAA} 8H$Hl$Ld$Ll$Lt$ L|$(H0Mx    f     ATHIUHSHu[]A\;aA$IHtHu[]A\ÐH\$Hl$H11   Pt!H\$Hl$   1H+ݐ        Ld$Ll$L%" Lt$L|$IH\$Hl$H8AIH^" I)IMt1HÐHLLDHI9uH\$Hl$Ld$Ll$ Lt$(L|$0H8ÐUHSc HH" HtD  HHHuH[ÐHH                                                                          _   _ ____  _
  Project                     ___| | | |  _ \| |
                             / __| | | | |_) | |
                            | (__| |_| |  _ <| |___
                             \___|\___/|_| \_\_____|

NAME
       curl - transfer a URL

SYNOPSIS
       curl [options] [URL...]

DESCRIPTION
       curl  is  a tool to transfer data from or to a server, using one of the
       supported protocols (DICT, FILE, FTP, FTPS, GOPHER, HTTP, HTTPS,  IMAP,
             IMAPS,  LDAP,  LDAPS,  POP3, POP3S, RTMP, RTSP, SCP, SFTP, SMTP, SMTPS,
       TELNET and TFTP).  The command is designed to work without user  inter-
       action.

       curl offers a busload of useful tricks like proxy support, user authen-
       tication, FTP upload, HTTP post, SSL connections, cookies, file  trans-
       fer resume and more. As you will see below, the number of features will
       make your head spin!

               curl is powered by  libcurl  for  all  transfer-related  features.  See
       libcurl(3) for details.

URL
       The  URL  syntax is protocol-dependent. You'll find a detailed descrip-
       tion in RFC 3986.

       You can specify multiple URLs or parts of URLs  by  writing  part  sets
       within braces as in:

        http://site.{one,two,three}.com

       or you can get sequences of alphanumeric series by using [] as in:

        ftp://ftp.numericals.com/file[1-100].txt
           ftp://ftp.numericals.com/file[001-100].txt    (with leading zeros)
        ftp://ftp.letters.com/file[a-z].txt

       Nested  sequences  are not supported, but you can use several ones next
       to each other:

        http://any.org/archive[1996-1999]/vol[1-4]/part{a,b,c}.html

       You can specify any amount of URLs on the command line.  They  will  be
       fetched in a sequential manner in the specified order.

              You  can  specify a step counter for the ranges to get every Nth number
       or letter:

        http://www.numericals.com/file[1-100:10].txt
        http://www.letters.com/file[a-z:2].txt

       If you specify URL without protocol:// prefix,  curl  will  attempt  to
       guess  what  protocol  you might want. It will then default to HTTP but
       try other protocols based on often-used host name prefixes.  For  exam-
           ple,  for  host names starting with "ftp." curl will assume you want to
       speak FTP.

       curl will do its best to use what you pass to it as a URL.  It  is  not
       trying  to  validate it as a syntactically correct URL by any means but
       is instead very liberal with what it accepts.

       Curl will attempt to re-use connections for multiple file transfers, so
       that  getting many files from the same server will not do multiple con-
           nects / handshakes. This improves speed. Of course this is only done on
       files  specified  on  a  single command line and cannot be used between
       separate curl invokes.

PROGRESS METER
       curl normally displays a progress meter during  operations,  indicating
       the  amount  of  transferred  data,  transfer speeds and estimated time
       left, etc.

       curl displays this data to the terminal by default, so  if  you  invoke
           curl  to do an operation and it is about to write data to the terminal,
       it disables the progress meter as otherwise it would mess up the output
       mixing progress meter and response data.

       If you want a progress meter for HTTP POST or PUT requests, you need to
       redirect the response output to a file, using shell  redirect  (>),  -o
       [file] or similar.

       It  is not the same case for FTP upload as that operation does not spit
        out any response data to the terminal.

       If you prefer a progress "bar" instead of the regular meter, -# is your
       friend.
OPTIONS
       In general, all boolean options are enabled with --option and yet again
       disabled with --no-option. That is, you use the exact same option  name
       but prefix it with "no-". However, in this list we mostly only list and
       show the --option version of them. (This concept with --no options  was
              added  in  7.19.0.  Previously  most  options  were  toggled  on/off on
       repeated use of the same command line option.)

       -#, --progress-bar
              Make curl display progress as a simple progress bar  instead  of
              the standard, more informational, meter.

       -0, --http1.0
              (HTTP)  Forces curl to issue its requests using HTTP 1.0 instead
              of using its internally preferred: HTTP 1.1.

       -1, --tlsv1
                    (SSL) Forces curl to use TLS version 1 when negotiating  with  a
              remote TLS server.

       -2, --sslv2
              (SSL)  Forces  curl to use SSL version 2 when negotiating with a
              remote SSL server.

       -3, --sslv3
              (SSL) Forces curl to use SSL version 3 when negotiating  with  a
              remote SSL server.

       -4, --ipv4
              If  libcurl  is  capable  of resolving an address to multiple IP
                    versions (which it is if it is IPv6-capable), this option  tells
              libcurl to resolve names to IPv4 addresses only.

       -6, --ipv6
              If  libcurl  is  capable  of resolving an address to multiple IP
              versions (which it is if it is IPv6-capable), this option  tells
              libcurl  to  resolve names to IPv6 addresses only.  default sta-
              tistics.

       -a, --append
                    (FTP/SFTP) When used in an upload, this will tell curl to append
              to  the  target  file  instead  of  overwriting  it. If the file
              doesn't exist, it will be  created.   Note  that  this  flag  is
              ignored by some SSH servers (including OpenSSH).

       -A, --user-agent <agent string>
              (HTTP) Specify the User-Agent string to send to the HTTP server.
              Some  badly  done  CGIs  fail  if  this  field  isn't   set   to
                    "Mozilla/4.0".  To  encode  blanks  in  the string, surround the
              string with single quote marks. This can also be  set  with  the
              -H, --header option of course.

              If  this  option is set more than once, the last one will be the
              one that's used.

       --anyauth
              (HTTP) Tells curl to figure out authentication method by itself,
              and  use  the most secure one the remote site claims to support.
                    This is done by first doing a request and checking the response-
              headers,  thus  possibly  inducing  an extra network round-trip.
              This is  used  instead  of  setting  a  specific  authentication
              method,  which  you  can  do with --basic, --digest, --ntlm, and
              --negotiate.

              Note that using --anyauth is not recommended if you  do  uploads
               from  stdin, since it may require data to be sent twice and then
              the client must be able to rewind. If the need should arise when
              uploading from stdin, the upload operation will fail.

       -b, --cookie <name=data>
              (HTTP)  Pass the data to the HTTP server as a cookie. It is sup-
              posedly the data previously received from the server in a  "Set-
              Cookie:"  line.  The data should be in the format "NAME1=VALUE1;
                      NAME2=VALUE2".

              If no '=' symbol is used in the line, it is treated as  a  file-
              name  to  use to read previously stored cookie lines from, which
              should be used in this session if they match. Using this  method
              also  activates  the "cookie parser" which will make curl record
              incoming cookies too, which may be handy if you're using this in
                     combination  with  the -L, --location option. The file format of
              the file to read cookies from should be plain  HTTP  headers  or
              the Netscape/Mozilla cookie file format.

              NOTE  that  the file specified with -b, --cookie is only used as
              input. No cookies will be stored in the file. To store  cookies,
              use  the -c, --cookie-jar option or you could even save the HTTP
                   headers to a file using -D, --dump-header!

              If this option is set more than once, the last one will  be  the
              one that's used.

       -B, --use-ascii
              Enable  ASCII transfer when using FTP or LDAP. For FTP, this can
              also be enforced by using an URL that ends with ";type=A".  This
              option  causes  data sent to stdout to be in text mode for win32
              systems.

       --basic
                  (HTTP) Tells curl to use HTTP Basic authentication. This is  the
              default  and this option is usually pointless, unless you use it
              to override a  previously  set  option  that  sets  a  different
              authentication  method  (such  as --ntlm, --digest, or --negoti-
              ate).

       -c, --cookie-jar <file name>
              Specify to which file you want curl to write all cookies after a
                  completed  operation.  Curl  writes  all cookies previously read
              from a specified file as  well  as  all  cookies  received  from
              remote server(s). If no cookies are known, no file will be writ-
              ten. The file will be written using  the  Netscape  cookie  file
              format.  If  you  set  the  file name to a single dash, "-", the
              cookies will be written to stdout.

                 This command line option will activate the  cookie  engine  that
              makes curl record and use cookies. Another way to activate it is
              to use the -b, --cookie option.

              If the cookie jar can't be created or written to, the whole curl
              operation  won't  fail or even report an error clearly. Using -v
              will get a warning displayed, but that is the only visible feed-
                    back you get about this possibly lethal situation.

              If  this  option  is used several times, the last specified file
              name will be used.

       -C, --continue-at <offset>
              Continue/Resume a previous file transfer at  the  given  offset.
              The  given  offset  is  the  exact  number of bytes that will be
              skipped, counting from the beginning of the source  file  before
                    it is transferred to the destination.  If used with uploads, the
              FTP server command SIZE will not be used by curl.

              Use "-C -" to tell curl to automatically find out  where/how  to
              resume  the  transfer. It then uses the given output/input files
              to figure that out.

              If this option is used several times, the last one will be used.

       --ciphers <list of ciphers>
                  (SSL) Specifies which ciphers to use in the connection. The list
              of  ciphers  must  specify  valid ciphers. Read up on SSL cipher
              list          details           on           this           URL:
              http://www.openssl.org/docs/apps/ciphers.html

              NSS  ciphers  are  done differently than OpenSSL and GnuTLS. The
              full list of NSS ciphers is in the NSSCipherSuite entry at  this
                      URL: http://directory.fedora.redhat.com/docs/mod_nss.html#Direc-
              tives

              If this option is used several times, the last one will override
              the others.

       --compressed
              (HTTP) Request a compressed response using one of the algorithms
              libcurl supports, and save the uncompressed document.   If  this
              option  is  used  and  the server sends an unsupported encoding,
               curl will report an error.

       --connect-timeout <seconds>
              Maximum time in seconds that you allow  the  connection  to  the
              server  to  take.   This  only limits the connection phase, once
              curl has connected this option is of no more use. See  also  the
              -m, --max-time option.

              If this option is used several times, the last one will be used.

       --create-dirs
                 When  used  in  conjunction with the -o option, curl will create
              the necessary local directory hierarchy as needed.  This  option
              creates  the dirs mentioned with the -o option, nothing else. If
              the -o file name uses no dir or if the dirs it mentions  already
              exist, no dir will be created.

              To  create remote directories when using FTP or SFTP, try --ftp-
              create-dirs.

          --crlf (FTP) Convert LF to CRLF in upload. Useful for MVS (OS/390).

       --crlfile <file>
              (HTTPS/FTPS) Provide a file using PEM format with a  Certificate
              Revocation  List  that may specify peer certificates that are to
              be considered revoked.

              If this option is used several times, the last one will be used.

              (Added in 7.19.7)
       -d, --data <data>
                     (HTTP) Sends the specified data in a POST request  to  the  HTTP
              server,  in  the  same  way  that a browser does when a user has
              filled in an HTML form and presses the submit button. This  will
              cause curl to pass the data to the server using the content-type
              application/x-www-form-urlencoded.  Compare to -F, --form.

              -d, --data is the same as  --data-ascii.  To  post  data  purely
                 binary, you should instead use the --data-binary option. To URL-
              encode the value of a form field you may use --data-urlencode.

              If any of these options is used more than once on the same  com-
              mand  line,  the  data  pieces specified will be merged together
              with a separating  &-symbol.  Thus,  using  '-d  name=daniel  -d
              skill=lousy'  would  generate  a  post  chunk  that  looks  like
                     'name=daniel&skill=lousy'.

              If you start the data with the letter @, the rest  should  be  a
              file  name  to read the data from, or - if you want curl to read
              the data from stdin.  The contents of the file must  already  be
              URL-encoded.  Multiple files can also be specified. Posting data
              from a file named 'foobar' would thus be done with --data  @foo-
              bar.

       -D, --dump-header <file>
                     Write the protocol headers to the specified file.

              This  option  is handy to use when you want to store the headers
              that a HTTP site sends to you. Cookies from  the  headers  could
              then  be  read  in  a  second  curl  invocation by using the -b,
              --cookie option! The -c, --cookie-jar option is however a better
              way to store cookies.

              When  used  in FTP, the FTP server response lines are considered
                     being "headers" and thus are saved there.

              If this option is used several times, the last one will be used.
              IP "--data-ascii <data>" See -d, --data.

       --data-binary <data>
              (HTTP)  This  posts data exactly as specified with no extra pro-
              cessing whatsoever.

              If you start the data with the letter @, the rest  should  be  a
              filename.   Data  is  posted in a similar manner as --data-ascii
                  does, except that newlines are  preserved  and  conversions  are
              never done.

              If  this  option  is  used several times, the ones following the
              first will append data as described in -d, --data.

       --data-urlencode <data>
              (HTTP) This posts data, similar to the other --data options with
              the exception that this performs URL-encoding. (Added in 7.18.0)
                      To  be  CGI-compliant,  the <data> part should begin with a name
              followed by a separator and a content specification. The  <data>
              part can be passed to curl using one of the following syntaxes:

              content
                     This  will make curl URL-encode the content and pass that
                     on. Just be careful so that the content  doesn't  contain
                     any  =  or  @  symbols, as that will then make the syntax
                             match one of the other cases below!

              =content
                     This will make curl URL-encode the content and pass  that
                     on. The preceding = symbol is not included in the data.

              name=content
                     This  will make curl URL-encode the content part and pass
                     that on. Note that the name part is expected to  be  URL-
                     encoded already.

              @filename
                       This  will  make  curl  load  data  from  the  given file
                     (including any newlines), URL-encode that data  and  pass
                     it on in the POST.

              name@filename
                     This  will  make  curl  load  data  from  the  given file
                     (including any newlines), URL-encode that data  and  pass
                     it  on  in  the  POST.  The  name part gets an equal sign
                             appended, resulting in name=urlencoded-file-content. Note
                     that the name is expected to be URL-encoded already.

       --delegation LEVEL
              Set LEVEL to tell the server what it is allowed to delegate when
              it comes to user credentials. Used with GSS/kerberos.

              none   Don't allow any delegation.

              policy Delegates if and only if the OK-AS-DELEGATE flag  is  set
                            in  the  Kerberos  service  ticket,  which is a matter of
                     realm policy.

              always Unconditionally allow the server to delegate.

       --digest
              (HTTP) Enables HTTP Digest authentication. This is a authentica-
              tion that prevents the password from being sent over the wire in
              clear text. Use this in combination with the normal  -u,  --user
                  option to set user name and password. See also --ntlm, --negoti-
              ate and --anyauth for related options.

              If this option is used several times, the following  occurrences
              make no difference.

       --disable-eprt
              (FTP) Tell curl to disable the use of the EPRT and LPRT commands
              when doing active FTP transfers. Curl will normally always first
                   attempt  to use EPRT, then LPRT before using PORT, but with this
              option, it will use PORT right away. EPRT and  LPRT  are  exten-
              sions  to  the  original  FTP  protocol, and may not work on all
              servers, but they enable more functionality in a better way than
              the traditional PORT command.

              --eprt can be used to explicitly enable EPRT again and --no-eprt
              is an alias for --disable-eprt.

               Disabling EPRT only changes the active behavior. If you want  to
              switch  to  passive  mode  you need to not use -P, --ftp-port or
              force it with --ftp-pasv.

       --disable-epsv
              (FTP) Tell curl to disable the use  of  the  EPSV  command  when
              doing  passive  FTP  transfers.  Curl will normally always first
              attempt to use EPSV before PASV, but with this option,  it  will
              not try using EPSV.

                 --epsv can be used to explicitly enable EPSV again and --no-epsv
              is an alias for --disable-epsv.

              Disabling EPSV only changes the passive behavior. If you want to
              switch to active mode you need to use -P, --ftp-port.

       -e, --referer <URL>
              (HTTP)  Sends the "Referer Page" information to the HTTP server.
              This can also be set with the -H, --header flag of course.  When
                   used with -L, --location you can append ";auto" to the --referer
              URL to make curl automatically set the previous URL when it fol-
              lows  a  Location: header. The ";auto" string can be used alone,
              even if you don't set an initial --referer.

              If this option is used several times, the last one will be used.

       -E, --cert <certificate[:password]>
              (SSL) Tells curl to use the specified  client  certificate  file
                    when getting a file with HTTPS, FTPS or another SSL-based proto-
              col. The certificate must be in PEM  format.   If  the  optional
              password  isn't  specified, it will be queried for on the termi-
              nal. Note that this option assumes a "certificate" file that  is
              the  private  key  and the private certificate concatenated! See
              --cert and --key to specify them independently.

                    If curl is built against the NSS SSL library  then  this  option
              can  tell curl the nickname of the certificate to use within the
              NSS database defined by the environment variable SSL_DIR (or  by
              default  /etc/pki/nssdb).  If  the  NSS PEM PKCS#11 module (lib-
              nsspem.so) is available then PEM files may  be  loaded.  If  you
              want to use a file from the current directory, please precede it
                    with "./" prefix, in order to avoid confusion with a nickname.

              If this option is used several times, the last one will be used.

       --engine <name>
              Select the OpenSSL crypto engine to use for  cipher  operations.
              Use  --engine  list  to  print  a  list  of build-time supported
              engines. Note that not all (or  none)  of  the  engines  may  be
              available at run-time.

       --environment
                 (RISC  OS ONLY) Sets a range of environment variables, using the
              names the -w option supports, to allow easier extraction of use-
              ful information after having run curl.

       --egd-file <file>
              (SSL)  Specify  the  path  name  to the Entropy Gathering Daemon
              socket. The socket is used to seed the  random  engine  for  SSL
              connections. See also the --random-file option.

       --cert-type <type>
                  (SSL)  Tells curl what certificate type the provided certificate
              is in. PEM, DER and ENG are recognized types.  If not specified,
              PEM is assumed.

              If this option is used several times, the last one will be used.

       --cacert <CA certificate>
              (SSL) Tells curl to use the specified certificate file to verify
              the peer. The file may contain  multiple  CA  certificates.  The
                  certificate(s)  must be in PEM format. Normally curl is built to
              use a default file for this, so this option is typically used to
              alter that default file.

              curl  recognizes the environment variable named 'CURL_CA_BUNDLE'
              if it is set, and uses the given path as a path  to  a  CA  cert
              bundle. This option overrides that variable.

              The  windows  version  of  curl will automatically look for a CA
               certs file named 'curl-ca-bundle.crt', either in the same direc-
              tory as curl.exe, or in the Current Working Directory, or in any
              folder along your PATH.

              If curl is built against the NSS SSL library  then  this  option
              tells  curl the nickname of the CA certificate to use within the
              NSS database defined by the environment variable SSL_DIR (or  by
                    default  /etc/pki/nssdb).   If  the NSS PEM PKCS#11 module (lib-
              nsspem.so) is available then PEM files may be loaded.

              If this option is used several times, the last one will be used.

       --capath <CA certificate directory>
              (SSL) Tells curl to use the specified certificate  directory  to
              verify  the  peer.  Multiple paths can be provided by separating
                 them with ":" (e.g.  "path1:path2:path3"). The certificates must
              be  in  PEM  format,  and  if curl is built against OpenSSL, the
              directory must have been processed using  the  c_rehash  utility
              supplied  with OpenSSL. Using --capath can allow OpenSSL-powered
              curl to make SSL-connections much more  efficiently  than  using
              --cacert if the --cacert file contains many CA certificates.

               If this option is set, the default capath value will be ignored,
              and if it is used several times, the last one will be used.

       -f, --fail
              (HTTP) Fail silently (no output at all) on server  errors.  This
              is  mostly done to better enable scripts etc to better deal with
              failed attempts. In normal cases when a  HTTP  server  fails  to
              deliver  a  document,  it  returns  an  HTML document stating so
                      (which often also describes why and more). This flag  will  pre-
              vent curl from outputting that and return error 22.

              This  method is not fail-safe and there are occasions where non-
              successful response codes will  slip  through,  especially  when
              authentication is involved (response codes 401 and 407).

       -F, --form <name=content>
              (HTTP)  This  lets curl emulate a filled-in form in which a user
                      has pressed the submit button. This causes  curl  to  POST  data
              using  the  Content-Type  multipart/form-data  according  to RFC
              2388. This enables uploading of binary files etc. To  force  the
              'content'  part  to  be  a  file, prefix the file name with an @
              sign. To just get the content part from a file, prefix the  file
              name  with  the symbol <. The difference between @ and < is then
                    that @ makes a file get attached in the post as a  file  upload,
              while  the  <  makes  a text field and just get the contents for
              that text field from a file.

              Example, to send your password file to the server, where  'pass-
              word' is the name of the form-field to which /etc/passwd will be
              the input:

              curl -F password=@/etc/passwd www.mypasswords.com

                   To read content from stdin instead of a file, use - as the file-
              name. This goes for both @ and < constructs.

              You  can  also  tell  curl  what  Content-Type  to  use by using
              'type=', in a manner similar to:

              curl -F "web=@index.html;type=text/html" url.com

              or

              curl -F "name=daniel;type=text/foo" url.com

              You can also explicitly change the name field of a  file  upload
                part by setting filename=, like this:

              curl -F "file=@localfile;filename=nameinpost" url.com

              See further examples and details in the MANUAL.

              This option can be used multiple times.

       --ftp-account [data]
              (FTP) When an FTP server asks for "account data" after user name
              and password has been provided, this data is sent off using  the
              ACCT command. (Added in 7.13.0)

                     If  this option is used twice, the second will override the pre-
              vious use.

       --ftp-alternative-to-user <command>
              (FTP) If authenticating with the USER and PASS  commands  fails,
              send  this  command.   When  connecting  to  Tumbleweed's Secure
              Transport server over FTPS using  a  client  certificate,  using
              "SITE  AUTH"  will tell the server to retrieve the username from
                      the certificate. (Added in 7.15.5)

       --ftp-create-dirs
              (FTP/SFTP) When an FTP or SFTP URL/operation uses  a  path  that
              doesn't  currently exist on the server, the standard behavior of
              curl is to fail. Using this option, curl will instead attempt to
              create missing directories.

       --ftp-method [method]
              (FTP)  Control  what method curl should use to reach a file on a
               FTP(S) server. The method argument should be one of the  follow-
              ing alternatives:

              multicwd
                     curl  does  a  single CWD operation for each path part in
                     the given URL. For deep hierarchies this means very  many
                     commands.  This  is  how RFC 1738 says it should be done.
                     This is the default but the slowest behavior.

                      nocwd  curl does no CWD at all. curl will do  SIZE,  RETR,  STOR
                     etc and give a full path to the server for all these com-
                     mands. This is the fastest behavior.

              singlecwd
                     curl does one CWD with the full target directory and then
                     operates  on  the  file  "normally" (like in the multicwd
                     case). This is somewhat  more  standards  compliant  than
                       'nocwd' but without the full penalty of 'multicwd'.
       (Added in 7.15.1)

       --ftp-pasv
              (FTP)  Use  passive mode for the data connection. Passive is the
              internal default behavior, but using this option can be used  to
              override a previous -P/-ftp-port option. (Added in 7.11.0)

              If  this option is used several times, the following occurrences
                  make no difference. Undoing an  enforced  passive  really  isn't
              doable  but you must then instead enforce the correct -P, --ftp-
              port again.

              Passive mode means that curl will try the EPSV command first and
              then PASV, unless --disable-epsv is used.

       --ftp-skip-pasv-ip
              (FTP) Tell curl to not use the IP address the server suggests in
                    its response to curl's PASV command when curl connects the  data
              connection.  Instead  curl  will  re-use  the same IP address it
              already uses for the control connection. (Added in 7.14.2)

              This option has no effect if PORT, EPRT or EPSV is used  instead
              of PASV.

       --ftp-pret
              (FTP)  Tell  curl to send a PRET command before PASV (and EPSV).
                      Certain FTP servers, mainly drftpd,  require  this  non-standard
              command  for  directory  listings as well as up and downloads in
              PASV mode.  (Added in 7.20.x)

       --ftp-ssl-ccc
              (FTP) Use CCC (Clear Command Channel)  Shuts  down  the  SSL/TLS
              layer after authenticating. The rest of the control channel com-
              munication will be unencrypted. This allows NAT routers to  fol-
                 low the FTP transaction. The default mode is passive. See --ftp-
              ssl-ccc-mode for other modes.  (Added in 7.16.1)

       --ftp-ssl-ccc-mode [active/passive]
              (FTP) Use CCC (Clear Command Channel) Sets  the  CCC  mode.  The
              passive  mode  will  not initiate the shutdown, but instead wait
              for the server to do it, and will not reply to the shutdown from
               the server. The active mode initiates the shutdown and waits for
              a reply from the server.  (Added in 7.16.2)

       --ftp-ssl-control
              (FTP) Require SSL/TLS for the FTP  login,  clear  for  transfer.
              Allows  secure  authentication, but non-encrypted data transfers
              for efficiency.  Fails the transfer if the server  doesn't  sup-
              port SSL/TLS.  (Added in 7.16.0) that can still be used but will
               be removed in a future version.

       --form-string <name=string>
              (HTTP) Similar to --form except that the value  string  for  the
              named  parameter  is used literally. Leading '@' and '<' charac-
              ters, and the ';type=' string in the value have no special mean-
              ing. Use this in preference to --form if there's any possibility
              that the string value may accidentally trigger the  '@'  or  '<'
                 features of --form.

       -g, --globoff
              This option switches off the "URL globbing parser". When you set
              this option, you can specify URLs that contain the letters  {}[]
              without  having them being interpreted by curl itself. Note that
              these letters are not normal legal URL contents but they  should
              be encoded according to the URI standard.

       -G, --get
                When  used,  this  option  will make all data specified with -d,
              --data or --data-binary to be used in a HTTP GET request instead
              of  the POST request that otherwise would be used. The data will
              be appended to the URL with a '?' separator.

              If used in combination with -I, the POST data  will  instead  be
              appended to the URL with a HEAD request.

                      If  this option is used several times, the following occurrences
              make no difference. This is because undoing a GET  doesn't  make
              sense,  but  you  should  then  instead  enforce the alternative
              method you prefer.

       -H, --header <header>
              (HTTP) Extra header to use when getting  a  web  page.  You  may
              specify any number of extra headers. Note that if you should add
                    a custom header that has the same name as one  of  the  internal
              ones  curl  would  use,  your externally set header will be used
              instead of the internal one. This allows you to make even trick-
              ier  stuff  than  curl would normally do. You should not replace
              internally set  headers  without  knowing  perfectly  well  what
              you're  doing. Remove an internal header by giving a replacement
                    without content on the right  side  of  the  colon,  as  in:  -H
              "Host:".  If  you  send the custom header with no-value then its
              header must be terminated with a semicolon, such as  -H  "X-Cus-
              tom-Header;" to send "X-Custom-Header:".

              curl  will  make  sure  that each header you add/replace is sent
              with the proper end-of-line marker, you should thus not add that
                   as a part of the header content: do not add newlines or carriage
              returns, they will only mess things up for you.

              See also the -A, --user-agent and -e, --referer options.

              This option can be used  multiple  times  to  add/replace/remove
              multiple headers.

       --hostpubmd5 <md5>
              Pass  a  string  containing  32  hexadecimal  digits. The string
               should be the 128 bit MD5 checksum of the remote  host's  public
              key,  curl  will  refuse the connection with the host unless the
              md5sums match. This option is only for SCP and  SFTP  transfers.
              (Added in 7.17.1)

       --ignore-content-length
              (HTTP)  Ignore  the  Content-Length header. This is particularly
              useful for servers running Apache 1.x, which will report  incor-
                   rect Content-Length for files larger than 2 gigabytes.

       -i, --include
              (HTTP)  Include  the  HTTP-header in the output. The HTTP-header
              includes things like server-name, date of  the  document,  HTTP-
              version and more...

       -I, --head
              (HTTP/FTP/FILE) Fetch the HTTP-header only! HTTP-servers feature
              the command HEAD which this uses to get nothing but  the  header
                  of  a  document.  When used on a FTP or FILE file, curl displays
              the file size and last modification time only.

       --interface <name>
              Perform an operation using a specified interface. You can  enter
              interface  name,  IP address or host name. An example could look
              like:

               curl --interface eth0:1 http://www.netscape.com/

              If this option is used several times, the last one will be used.

            -j, --junk-session-cookies
              (HTTP) When curl is told to read cookies from a given file, this
              option  will  make  it  discard all "session cookies". This will
              basically have the same effect as if a new session  is  started.
              Typical  browsers  always  discard  session cookies when they're
              closed down.

       -J, --remote-header-name
              (HTTP) This option tells the -O, --remote-name option to use the
                     server-specified   Content-Disposition   filename   instead   of
              extracting a filename from the URL.

       -k, --insecure
              (SSL) This option explicitly allows curl to  perform  "insecure"
              SSL connections and transfers. All SSL connections are attempted
              to be made secure by using the CA certificate  bundle  installed
              by  default.  This  makes  all connections considered "insecure"
                  fail unless -k, --insecure is used.

              See    this    online    resource    for    further     details:
              http://curl.haxx.se/docs/sslcerts.html

       -K, --config <config file>
              Specify  which config file to read curl arguments from. The con-
              fig file is a text file in which command line arguments  can  be
              written  which  then will be used as if they were written on the
               actual command line. Options and their parameters must be speci-
              fied  on  the  same  config  file line, separated by whitespace,
              colon, the equals sign or any combination thereof (however,  the
              preferred  separator is the equals sign). If the parameter is to
              contain  whitespace,  the  parameter  must  be  enclosed  within
              quotes. Within double quotes, the following escape sequences are
                    available: \\, \", \t, \n, \r and \v. A backslash preceding  any
              other letter is ignored. If the first column of a config line is
              a '#' character, the rest of the line will be treated as a  com-
              ment.  Only  write  one  option  per physical line in the config
              file.

              Specify the filename to -K, --config as '-' to  make  curl  read
              the file from stdin.

                  Note  that  to  be able to specify a URL in the config file, you
              need to specify it using the --url option,  and  not  by  simply
              writing  the  URL  on its own line. So, it could look similar to
              this:

              url = "http://curl.haxx.se/docs/"

              Long option names can optionally be given  in  the  config  file
              without the initial double dashes.

                  When curl is invoked, it always (unless -q is used) checks for a
              default config file and uses it if  found.  The  default  config
              file is checked for in the following places in this order:

              1)  curl  tries  to find the "home dir": It first checks for the
              CURL_HOME and then the HOME environment variables. Failing that,
              it  uses getpwuid() on UNIX-like systems (which returns the home
                 dir given the current user in your system). On Windows, it  then
              checks for the APPDATA variable, or as a last resort the '%USER-
              PROFILE%\Application Data'.

              2) On windows, if there is no _curlrc file in the home  dir,  it
              checks for one in the same dir the curl executable is placed. On
              UNIX-like systems, it will simply try to load .curlrc  from  the
              determined home dir.

                    # --- Example file ---
              # this is a comment
              url = "curl.haxx.se"
              output = "curlhere.html"
              user-agent = "superagent/1.0"

              # and fetch another URL too
              url = "curl.haxx.se/docs/manpage.html"
              -O
              referer = "http://nowhereatall.com/"
              # --- End of example file ---

              This  option  can be used multiple times to load multiple config
              files.

            --keepalive-time <seconds>
              This option sets the time a  connection  needs  to  remain  idle
              before  sending keepalive probes and the time between individual
              keepalive probes. It is currently effective on operating systems
              offering  the  TCP_KEEPIDLE  and  TCP_KEEPINTVL  socket  options
              (meaning Linux, recent AIX, HP-UX and more). This option has  no
              effect if --no-keepalive is used. (Added in 7.18.0)

                      If  this option is used multiple times, the last occurrence sets
              the amount. If unspecified, the option defaults to 60 seconds.

       --key <key>
              (SSL/SSH) Private key file name. Allows you to provide your pri-
              vate key in this separate file.

              If this option is used several times, the last one will be used.

       --key-type <type>
              (SSL)  Private key file type. Specify which type your --key pro-
                vided private key is. DER, PEM, and ENG are  supported.  If  not
              specified, PEM is assumed.

              If this option is used several times, the last one will be used.

       --krb <level>
              (FTP)  Enable Kerberos authentication and use. The level must be
              entered and should be one of 'clear', 'safe', 'confidential', or
              'private'.  Should  you  use  a  level that is not one of these,
                   'private' will instead be used.

              This option requires a library built with  kerberos4  or  GSSAPI
              (GSS-Negotiate) support. This is not very common. Use -V, --ver-
              sion to see if your curl supports it.

              If this option is used several times, the last one will be used.

       -l, --list-only
              (FTP) When listing an FTP directory, this switch forces a  name-
                      only  view.   Especially useful if you want to machine-parse the
              contents of an FTP directory since  the  normal  directory  view
              doesn't use a standard look or format.

              This  option  causes  an  FTP NLST command to be sent.  Some FTP
              servers list only files in their response to NLST; they  do  not
              include subdirectories and symbolic links.

       -L, --location
                    (HTTP/HTTPS)  If  the server reports that the requested page has
              moved to a different location (indicated with a Location: header
              and  a  3XX  response code), this option will make curl redo the
              request on the new place. If used together with -i, --include or
              -I, --head, headers from all requested pages will be shown. When
              authentication is used, curl only sends its credentials  to  the
                    initial  host.  If a redirect takes curl to a different host, it
              won't be able to intercept the user+password. See  also  --loca-
              tion-trusted  on how to change this. You can limit the amount of
              redirects to follow by using the --max-redirs option.

              When curl follows a redirect and the request is not a plain  GET
              (for example POST or PUT), it will do the following request with
                      a GET if the HTTP response was 301, 302, or 303. If the response
              code  was  any  other  3xx code, curl will re-send the following
              request using the same unmodified method.

       --libcurl <file>
              Append this option to any ordinary curl command  line,  and  you
              will  get a libcurl-using C source code written to the file that
              does the equivalent of what your command-line operation does!

                    If this option is used several times, the last given  file  name
              will be used. (Added in 7.16.1)

       --limit-rate <speed>
              Specify  the  maximum  transfer  rate you want curl to use. This
              feature is useful if you have a limited pipe and you'd like your
              transfer not to use your entire bandwidth.

              The  given speed is measured in bytes/second, unless a suffix is
                     appended.  Appending 'k' or 'K' will count the number  as  kilo-
              bytes,  'm'  or M' makes it megabytes, while 'g' or 'G' makes it
              gigabytes. Examples: 200K, 3m and 1G.

              The given rate is the average speed counted  during  the  entire
              transfer. It means that curl might use higher transfer speeds in
              short bursts, but over time it uses no more than the given rate.
                      If you also use the -Y, --speed-limit option, that  option  will
              take precedence and might cripple the rate-limiting slightly, to
              help keeping the speed-limit logic working.

              If this option is used several times, the last one will be used.

       --local-port <num>[-num]
              Set a preferred number or range of local port numbers to use for
              the  connection(s).   Note  that  port  numbers  by nature are a
               scarce resource that will be busy at times so setting this range
              to something too narrow might cause unnecessary connection setup
              failures. (Added in 7.15.2)

       --location-trusted
              (HTTP/HTTPS) Like -L, --location, but  will  allow  sending  the
              name + password to all hosts that the site may redirect to. This
              may or may not introduce a security breach if the site redirects
                      you  to  a  site  to  which you'll send your authentication info
              (which is plaintext in the case of HTTP Basic authentication).

       -m, --max-time <seconds>
              Maximum time in seconds that you allow the  whole  operation  to
              take.   This is useful for preventing your batch jobs from hang-
              ing for hours due to slow networks or  links  going  down.   See
              also the --connect-timeout option.

                  If this option is used several times, the last one will be used.

       --mail-auth <address>
              (SMTP)  Specify  a  single address. This will be used to specify
              the authentication address (identity)  of  a  submitted  message
              that is being relayed to another server.

              (Added in 7.25.0)

       --mail-from <address>
              (SMTP)  Specify  a single address that the given mail should get
              sent from.

                    (Added in 7.20.0)

       --max-filesize <bytes>
              Specify the maximum size (in bytes) of a file  to  download.  If
              the  file requested is larger than this value, the transfer will
              not start and curl will return with exit code 63.

              NOTE: The file size is not always known prior to  download,  and
              for such files this option has no effect even if the file trans-
                  fer ends up being larger than this given  limit.  This  concerns
              both FTP and HTTP transfers.

       --mail-rcpt <address>
              (SMTP)  Specify  a single address that the given mail should get
              sent to. This option can be used multiple times to specify  many
              recipients.

              (Added in 7.20.0)

       --max-redirs <num>
              Set  maximum  number  of  redirection-followings allowed. If -L,
                   --location is used, this option can be used to prevent curl from
              following  redirections  "in absurdum". By default, the limit is
              set to 50 redirections. Set this option to -1 to make it  limit-
              less.

              If this option is used several times, the last one will be used.

       -n, --netrc
              Makes  curl  scan  the  .netrc  (_netrc  on Windows) file in the
                  user's home directory for login name and password. This is typi-
              cally  used for FTP on UNIX. If used with HTTP, curl will enable
              user authentication. See netrc(4) or ftp(1) for details  on  the
              file  format.  Curl  will not complain if that file doesn't have
              the right permissions (it should not be either world- or  group-
              readable).  The  environment variable "HOME" is used to find the
                    home directory.

              A quick and very simple example of how  to  setup  a  .netrc  to
              allow  curl to FTP to the machine host.domain.com with user name
              'myself' and password 'secret' should look similar to:

              machine host.domain.com login myself password secret

       -N, --no-buffer
              Disables the buffering of the output stream. In normal work sit-
                 uations,  curl  will  use a standard buffered output stream that
              will have the effect that it will output the data in chunks, not
              necessarily  exactly  when  the data arrives.  Using this option
              will disable that buffering.

              Note that this is the negated option name  documented.  You  can
              thus use --buffer to enforce the buffering.

       --netrc-file
               This  option  is similar to --netrc, except that you provide the
              path (absolute or relative) to the netrc file that  Curl  should
              use.   You  can  only  specify one netrc file per invocation. If
              several --netrc-file options are provided,  only  the  last  one
              will be used.  (Added in 7.21.5)

              This  option  overrides  any use of --netrc as they are mutually
                   exclusive.  It will also abide by --netrc-optional if specified.

       --netrc-optional
              Very similar to --netrc, but this option makes the .netrc  usage
              optional and not mandatory as the --netrc option does.

       --negotiate
              (HTTP)  Enables  GSS-Negotiate authentication. The GSS-Negotiate
              method was designed by Microsoft and is used in their web appli-
                cations.  It  is  primarily  meant  as  a  support for Kerberos5
              authentication but may be also used along with another authenti-
              cation method. For more information see IETF draft draft-brezak-
              spnego-http-04.txt.

              If you want to enable Negotiate for your  proxy  authentication,
              then use --proxy-negotiate.

              This  option  requires a library built with GSSAPI support. This
                     is not very common. Use -V, --version to  see  if  your  version
              supports GSS-Negotiate.

              When  using this option, you must also provide a fake -u, --user
              option to activate the authentication code properly.  Sending  a
              '-u  :'  is  enough  as  the  user name and password from the -u
              option aren't actually used.

              If this option is used several times, the following  occurrences
                make no difference.

       --no-keepalive
              Disables the use of keepalive messages on the TCP connection, as
              by default curl enables them.

              Note that this is the negated option name  documented.  You  can
              thus use --keepalive to enforce keepalive.

       --no-sessionid
              (SSL)  Disable curl's use of SSL session-ID caching.  By default
              all transfers are done using the cache. Note that while  nothing
                    should  ever  get  hurt  by attempting to reuse SSL session-IDs,
              there seem to be broken SSL implementations in the wild that may
              require  you to disable this in order for you to succeed. (Added
              in 7.16.0)

              Note that this is the negated option name  documented.  You  can
              thus use --sessionid to enforce session-ID caching.

       --noproxy <no-proxy-list>
                    Comma-separated  list  of hosts which do not use a proxy, if one
              is specified.  The only wildcard is a single * character,  which
              matches all hosts, and effectively disables the proxy. Each name
              in this list is matched as either a domain  which  contains  the
              hostname,  or  the hostname itself. For example, local.com would
              match  local.com,  local.com:80,  and  www.local.com,  but   not
                    www.notlocal.com.  (Added in 7.19.4).

       --ntlm (HTTP)  Enables  NTLM  authentication.  The  NTLM authentication
              method was designed by Microsoft and is used by IIS web servers.
              It  is a proprietary protocol, reverse-engineered by clever peo-
              ple and implemented in curl based on their efforts. This kind of
              behavior  should  not be endorsed, you should encourage everyone
                      who uses NTLM to switch to a public and  documented  authentica-
              tion method instead, such as Digest.

              If  you  want to enable NTLM for your proxy authentication, then
              use --proxy-ntlm.

              This option requires a library built with SSL support.  Use  -V,
              --version to see if your curl supports NTLM.

              If  this option is used several times, the following occurrences
              make no difference.
        -o, --output <file>
              Write output to <file> instead of stdout. If you are using {} or
              []  to  fetch  multiple documents, you can use '#' followed by a
              number in the <file> specifier. That variable will  be  replaced
              with the current string for the URL being fetched. Like in:

                curl http://{one,two}.site.com -o "file_#1.txt"

              or use several variables like:

                      curl http://{site,host}.host[1-5].com -o "#1_#2"

              You  may use this option as many times as the number of URLs you
              have.

              See also the --create-dirs option to create the  local  directo-
              ries  dynamically.  Specifying the output as '-' (a single dash)
              will force the output to be done to stdout.

       -O, --remote-name
              Write output to a local file named like the remote file we  get.
               (Only  the file part of the remote file is used, the path is cut
              off.)

              The remote file name to use for saving  is  extracted  from  the
              given URL, nothing else.

              Consequentially,  the  file will be saved in the current working
              directory. If you want the file saved in a different  directory,
              make sure you change current working directory before you invoke
                      curl with the -O, --remote-name flag!

              You may use this option as many times as the number of URLs  you
              have.

       -p, --proxytunnel
              When an HTTP proxy is used (-x, --proxy), this option will cause
              non-HTTP protocols  to  attempt  to  tunnel  through  the  proxy
              instead  of merely using it to do HTTP-like operations. The tun-
              nel approach is made with the HTTP  proxy  CONNECT  request  and
                requires that the proxy allows direct connect to the remote port
              number curl wants to tunnel through to.

       -P, --ftp-port <address>
              (FTP) Reverses the default initiator/listener  roles  when  con-
              necting  with  FTP.  This  switch makes curl use active mode. In
              practice, curl then tells the server  to  connect  back  to  the
              client's specified address and port, while passive mode asks the
                    server to setup an IP address and port for  it  to  connect  to.
              <address> should be one of:

              interface
                     i.e  "eth0"  to  specify which interface's IP address you
                     want to use (Unix only)

              IP address
                     i.e "192.168.10.1" to specify the exact IP address

              host name
                     i.e "my.host.domain" to specify the machine

                   -      make curl pick the same IP address that is  already  used
                     for the control connection

       If  this  option is used several times, the last one will be used. Dis-
       able the use of PORT with --ftp-pasv. Disable the attempt  to  use  the
       EPRT  command  instead  of PORT by using --disable-eprt. EPRT is really
       PORT++.

       Starting in 7.19.5, you can append ":[start]-[end]" to the right of the
           address,  to tell curl what TCP port range to use. That means you spec-
       ify a port range, from a lower to a  higher  number.  A  single  number
       works  as well, but do note that it increases the risk of failure since
       the port may not be available.

       --pass <phrase>
              (SSL/SSH) Passphrase for the private key

              If this option is used several times, the last one will be used.

       --post301
                  Tells curl to respect  RFC  2616/10.3.2  and  not  convert  POST
              requests into GET requests when following a 301 redirection. The
              non-RFC behaviour is ubiquitous in web browsers,  so  curl  does
              the  conversion  by  default to maintain consistency. However, a
              server may require a POST to remain a POST after  such  a  redi-
              rection.  This  option is meaningful only when using -L, --loca-
                    tion (Added in 7.17.1)

       --post302
              Tells curl to respect  RFC  2616/10.3.2  and  not  convert  POST
              requests into GET requests when following a 302 redirection. The
              non-RFC behaviour is ubiquitous in web browsers,  so  curl  does
              the  conversion  by  default to maintain consistency. However, a
              server may require a POST to remain a POST after  such  a  redi-
                    rection.  This  option is meaningful only when using -L, --loca-
              tion (Added in 7.19.1)

       --proto <protocols>
              Tells  curl  to  use  the  listed  protocols  for  its   initial
              retrieval. Protocols are evaluated left to right, are comma sep-
              arated, and are each a protocol name or 'all',  optionally  pre-
              fixed by zero or more modifiers. Available modifiers are:

                +  Permit this protocol in addition to protocols already permit-
                 ted (this is the default if no modifier is used).

              -  Deny this protocol, removing it from the  list  of  protocols
                 already permitted.

              =  Permit  only this protocol (ignoring the list already permit-
                 ted), though subject  to  later  modification  by  subsequent
                 entries in the comma separated list.

                  For example:

              --proto -ftps  uses the default protocols, but disables ftps

              --proto -all,https,+http
                             only enables http and https

              --proto =http,https
                             also only enables http and https

              Unknown  protocols  produce  a  warning.  This allows scripts to
              safely rely on being able to disable potentially dangerous  pro-
                      tocols,  without  relying  upon  support for that protocol being
              built into curl to avoid an error.

              This option can be used multiple times, in which case the effect
              is  the same as concatenating the protocols into one instance of
              the option.

              (Added in 7.20.2)

       --proto-redir <protocols>
              Tells curl to use the listed protocols  after  a  redirect.  See
                   --proto for how protocols are represented.

              (Added in 7.20.2)

       --proxy-anyauth
              Tells  curl to pick a suitable authentication method when commu-
              nicating with  the  given  proxy.  This  might  cause  an  extra
              request/response round-trip. (Added in 7.13.2)

       --proxy-basic
              Tells  curl  to use HTTP Basic authentication when communicating
                    with the given proxy. Use --basic for enabling HTTP Basic with a
              remote  host.  Basic  is  the default authentication method curl
              uses with proxies.

       --proxy-digest
              Tells curl to use HTTP Digest authentication when  communicating
              with the given proxy. Use --digest for enabling HTTP Digest with
              a remote host.

       --proxy-negotiate
                   Tells curl to use HTTP Negotiate authentication when communicat-
              ing  with  the  given  proxy.  Use --negotiate for enabling HTTP
              Negotiate with a remote host. (Added in 7.17.1)

       --proxy-ntlm
              Tells curl to use HTTP NTLM  authentication  when  communicating
              with the given proxy. Use --ntlm for enabling NTLM with a remote
              host.

       --proxy1.0 <proxyhost[:port]>
                     Use the specified HTTP 1.0 proxy. If  the  port  number  is  not
              specified, it is assumed at port 1080.

              The  only difference between this and the HTTP proxy option (-x,
              --proxy), is that attempts to use CONNECT through the proxy will
              specify an HTTP 1.0 protocol instead of the default HTTP 1.1.

       --pubkey <key>
              (SSH)  Public  key  file name. Allows you to provide your public
                 key in this separate file.

              If this option is used several times, the last one will be used.

       -q     If used as the first parameter on the command line,  the  curlrc
              config  file will not be read and used. See the -K, --config for
              details on the default config file search path.

       -Q, --quote <command>
              (FTP/SFTP) Send an arbitrary command to the remote FTP  or  SFTP
                   server.  Quote commands are sent BEFORE the transfer takes place
              (just after the initial PWD command in an FTP  transfer,  to  be
              exact). To make commands take place after a successful transfer,
              prefix them with a dash '-'.  To make  commands  be  sent  after
              libcurl  has  changed  the  working  directory,  just before the
              transfer command(s), prefix the command with a '+' (this is only
                    supported  for  FTP). You may specify any number of commands. If
              the server returns failure for one of the commands,  the  entire
              operation  will  be aborted. You must send syntactically correct
              FTP commands as RFC 959 defines to FTP servers, or  one  of  the
              commands  listed below to SFTP servers.  This option can be used
              multiple times. When speaking to a FTP server, prefix  the  com-
                    mand  with  an asterisk (*) to make libcurl continue even if the
              command fails as by default curl will stop at first failure.

              SFTP is a binary protocol. Unlike for  FTP,  libcurl  interprets
              SFTP  quote  commands  itself before sending them to the server.
              File names may be quoted shell-style to embed spaces or  special
              characters.   Following  is the list of all supported SFTP quote
              commands:

                      chgrp group file
                     The chgrp command sets the group ID of the file named  by
                     the  file  operand to the group ID specified by the group
                     operand. The group operand is a decimal integer group ID.

              chmod mode file
                     The chmod command modifies the  file  mode  bits  of  the
                     specified file. The mode operand is an octal integer mode
                     number.

               chown user file
                     The chown command sets the owner of the file named by the
                     file  operand  to the user ID specified by the user oper-
                     and. The user operand is a decimal integer user ID.

              ln source_file target_file
                     The ln and symlink commands create a symbolic link at the
                     target_file  location  pointing  to the source_file loca-
                     tion.

                     mkdir directory_name
                     The mkdir command creates  the  directory  named  by  the
                     directory_name operand.

              pwd    The pwd command returns the absolute pathname of the cur-
                     rent working directory.

              rename source target
                     The rename command renames the file or directory named by
                     the  source  operand to the destination path named by the
                       target operand.

              rm file
                     The rm command removes the file specified by the file op-
                     erand.

              rmdir directory
                     The  rmdir  command removes the directory entry specified
                     by the directory operand, provided it is empty.

              symlink source_file target_file
                     See ln.

       -r, --range <range>
                    (HTTP/FTP/SFTP/FILE) Retrieve a byte range (i.e a partial  docu-
              ment)  from  a  HTTP/1.1,  FTP  or  SFTP server or a local FILE.
              Ranges can be specified in a number of ways.

              0-499     specifies the first 500 bytes

              500-999   specifies the second 500 bytes

              -500      specifies the last 500 bytes

              9500-     specifies the bytes from offset 9500 and forward

                     0-0,-1    specifies the first and last byte only(*)(H)

              500-700,600-799
                        specifies 300 bytes from offset 500(H)

              100-199,500-599
                        specifies two separate 100-byte ranges(*)(H)

       (*) = NOTE that this will cause the server to reply  with  a  multipart
       response!

       Only  digit characters (0-9) are valid in the 'start' and 'stop' fields
               of the 'start-stop' range syntax. If a non-digit character is given  in
       the  range, the server's response will be unspecified, depending on the
       server's configuration.

       You should also be aware that many HTTP/1.1 servers do  not  have  this
       feature  enabled,  so  that  when  you  attempt  to get a range, you'll
       instead get the whole document.

       FTP and SFTP range downloads only support the simple 'start-stop'  syn-
            tax  (optionally  with  one of the numbers omitted). FTP use depends on
       the extended FTP command SIZE.

       If this option is used several times, the last one will be used.

       -R, --remote-time
              When used, this will make libcurl  attempt  to  figure  out  the
              timestamp  of the remote file, and if that is available make the
              local file get that same timestamp.

       --random-file <file>
                 (SSL) Specify the path name to file containing what will be con-
              sidered  as  random  data.  The  data is used to seed the random
              engine for SSL connections.  See also the --egd-file option.

       --raw  When used, it disables all internal HTTP decoding of content  or
              transfer  encodings  and instead makes them passed on unaltered,
              raw. (Added in 7.16.2)

       --remote-name-all
               This option changes the default action for all given URLs to  be
              dealt with as if -O, --remote-name were used for each one. So if
              you want to disable that for a specific URL after --remote-name-
              all  has  been  used,  you  must use "-o -" or --no-remote-name.
              (Added in 7.19.0)

       --resolve <host:port:address>
              Provide a custom address for a  specific  host  and  port  pair.
                     Using  this,  you  can make the curl requests(s) use a specified
              address and prevent the otherwise normally resolved  address  to
              be  used.  Consider it a sort of /etc/hosts alternative provided
              on the command line. The port number should be the  number  used
              for  the  specific  protocol the host will be used for. It means
              you need several entries if you want to provide address for  the
                    same host but different ports.

              This  option  can  be  used many times to add many host names to
              resolve.

              (Added in 7.21.3)

       --retry <num>
              If a transient error is returned when curl tries  to  perform  a
              transfer,  it  will retry this number of times before giving up.
              Setting the number to 0 makes curl do no retries (which  is  the
                      default).  Transient  error  means either: a timeout, an FTP 4xx
              response code or an HTTP 5xx response code.

              When curl is about to retry a transfer, it will first  wait  one
              second  and  then for all forthcoming retries it will double the
              waiting time until it reaches 10 minutes which then will be  the
              delay  between  the rest of the retries.  By using --retry-delay
                you  disable  this  exponential  backoff  algorithm.  See   also
              --retry-max-time  to  limit  the total time allowed for retries.
              (Added in 7.12.3)

              If this option is  used  multiple  times,  the  last  occurrence
              decide the amount.

       --retry-delay <seconds>
              Make  curl  sleep  this  amount of time before each retry when a
              transfer has failed with  a  transient  error  (it  changes  the
                 default  backoff time algorithm between retries). This option is
              only interesting if --retry is also used. Setting this delay  to
              zero  will  make  curl  use the default backoff time.  (Added in
              7.12.3)

              If this option is  used  multiple  times,  the  last  occurrence
              determines the amount.

       --retry-max-time <seconds>
              The  retry  timer  is  reset  before the first transfer attempt.
                    Retries will be done as usual (see --retry) as long as the timer
              hasn't reached this given limit. Notice that if the timer hasn't
              reached the limit, the request will be made and  while  perform-
              ing,  it may take longer than this given time period. To limit a
              single request's maximum time, use  -m,  --max-time.   Set  this
              option to zero to not timeout retries. (Added in 7.12.3)

                   If  this  option  is  used  multiple  times, the last occurrence
              determines the amount.

       -s, --silent
              Silent or quiet mode. Don't show progress meter  or  error  mes-
              sages.  Makes Curl mute.

       -S, --show-error
              When  used  with  -s  it  makes curl show an error message if it
              fails.

       --ssl  (FTP, POP3, IMAP, SMTP) Try to use SSL/TLS for  the  connection.
                  Reverts to a non-secure connection if the server doesn't support
              SSL/TLS.  See also --ftp-ssl-control and --ssl-reqd for  differ-
              ent levels of encryption required. (Added in 7.20.0)

              This  option  was formerly known as --ftp-ssl (Added in 7.11.0).
              That option name can still be used but  will  be  removed  in  a
              future version.

       --ssl-reqd
                     (FTP,  POP3,  IMAP,  SMTP)  Require  SSL/TLS for the connection.
              Terminates the connection if the server doesn't support SSL/TLS.
              (Added in 7.20.0)

              This  option  was  formerly  known  as  --ftp-ssl-reqd (added in
              7.15.5). That option name can still be used but will be  removed
              in a future version.

       --ssl-allow-beast
              (SSL)  This option tells curl to not work around a security flaw
                     in the SSL3 and TLS1.0 protocols known as BEAST.  If this option
              isn't  used,  the  SSL layer may use work-arounds known to cause
              interoperability problems with some older  SSL  implementations.
              WARNING: this option loosens the SSL security, and by using this
              flag you ask for exactly that.  (Added in 7.25.0)

       --socks4 <host[:port]>
              Use the specified SOCKS4 proxy. If the port number is not speci-
                    fied, it is assumed at port 1080. (Added in 7.15.2)

              This  option  overrides any previous use of -x, --proxy, as they
              are mutually exclusive.

              Since 7.21.7, this option is superfluous since you can specify a
              socks4 proxy with -x, --proxy using a socks4:// protocol prefix.
              If this option is used several times, the last one will be used.

       --socks4a <host[:port]>
                Use the specified SOCKS4a proxy. If the port number is not spec-
              ified, it is assumed at port 1080. (Added in 7.18.0)

              This option overrides any previous use of -x, --proxy,  as  they
              are mutually exclusive.

              Since 7.21.7, this option is superfluous since you can specify a
              socks4a proxy with -x, --proxy using a socks4a:// protocol  pre-
              fix.

                   If this option is used several times, the last one will be used.

       --socks5-hostname <host[:port]>
              Use  the  specified  SOCKS5 proxy (and let the proxy resolve the
              host name). If the port number is not specified, it  is  assumed
              at port 1080. (Added in 7.18.0)

              This  option  overrides any previous use of -x, --proxy, as they
              are mutually exclusive.

                    Since 7.21.7, this option is superfluous since you can specify a
              socks5 hostname proxy with -x, --proxy using a socks5h:// proto-
              col prefix.

              If this option is used several times, the last one will be used.
              (This  option  was  previously  wrongly  documented  and used as
              --socks without the number appended.)

       --socks5 <host[:port]>
                    Use the specified SOCKS5 proxy  -  but  resolve  the  host  name
              locally.  If  the port number is not specified, it is assumed at
              port 1080.

              This option overrides any previous use of -x, --proxy,  as  they
              are mutually exclusive.

              Since 7.21.7, this option is superfluous since you can specify a
              socks5 proxy with -x, --proxy using a socks5:// protocol prefix.
                  If this option is used several times, the last one will be used.
              (This  option  was  previously  wrongly  documented  and used as
              --socks without the number appended.)

              This option (as well as --socks4) does not work with IPV6,  FTPS
              or LDAP.

       --socks5-gssapi-service <servicename>
              The default service name for a socks server is rcmd/server-fqdn.
              This option allows you to change it.

                    Examples:  --socks5  proxy-name  --socks5-gssapi-service   sockd
              would  use sockd/proxy-name --socks5 proxy-name --socks5-gssapi-
              service sockd/real-name  would  use  sockd/real-name  for  cases
              where  the proxy-name does not match the principal name.  (Added
              in 7.19.4).

       --socks5-gssapi-nec
              As part of the gssapi negotiation a protection mode  is  negoti-
                     ated.  RFC  1961 says in section 4.3/4.4 it should be protected,
              but the NEC  reference  implementation  does  not.   The  option
              --socks5-gssapi-nec  allows the unprotected exchange of the pro-
              tection mode negotiation. (Added in 7.19.4).

       --stderr <file>
              Redirect all writes to stderr to the specified file instead.  If
              the file name is a plain '-', it is instead written to stdout.

                 If this option is used several times, the last one will be used.

       -t, --telnet-option <OPT=val>
              Pass options to the telnet protocol. Supported options are:

              TTYPE=<term> Sets the terminal type.

              XDISPLOC=<X display> Sets the X display location.

              NEW_ENV=<var,val> Sets an environment variable.

       -T, --upload-file <file>
              This  transfers  the  specified local file to the remote URL. If
                   there is no file part in the specified URL, Curl will append the
              local file name. NOTE that you must use a trailing / on the last
              directory to really prove to Curl that there is no file name  or
              curl will think that your last directory name is the remote file
              name to use. That will most likely cause the upload operation to
              fail.  If this is used on a HTTP(S) server, the PUT command will
              be used.

                    Use the file name "-" (a single dash) to use stdin instead of  a
              given  file.   Alternately,  the file name "." (a single period)
              may be specified instead of "-" to  use  stdin  in  non-blocking
              mode  to  allow  reading  server  output  while  stdin  is being
              uploaded.

              You can specify one -T for each URL on the command line. Each -T
                  + URL pair specifies what to upload and to where. curl also sup-
              ports "globbing" of the -T argument, meaning that you can upload
              multiple  files  to  a single URL by using the same URL globbing
              style supported in the URL, like this:

              curl -T "{file1,file2}" http://www.uploadtothissite.com

              or even

              curl -T "img[1-1000].png" ftp://ftp.picturemania.com/upload/

       --tcp-nodelay
                    Turn on the TCP_NODELAY option. See the curl_easy_setopt(3)  man
              page for details about this option. (Added in 7.11.2)

       --tftp-blksize <value>
              (TFTP) Set TFTP BLKSIZE option (must be >512). This is the block
              size that curl will try to use when transferring data to or from
              a TFTP server. By default 512 bytes will be used.

              If this option is used several times, the last one will be used.

                     (Added in 7.20.0)

       --tlsauthtype <authtype>
              Set  TLS  authentication  type.  Currently,  the  only supported
              option is "SRP",  for  TLS-SRP  (RFC  5054).  If  --tlsuser  and
              --tlspassword  are specified but --tlsauthtype is not, then this
              option defaults to "SRP".  (Added in 7.21.4)

       --tlsuser <user>
              Set username for use with the TLS authentication  method  speci-
                     fied  with  --tlsauthtype.  Requires  that --tlspassword also be
              set.  (Added in 7.21.4)

       --tlspassword <password>
              Set password for use with the TLS authentication  method  speci-
              fied  with  --tlsauthtype.  Requires that --tlsuser also be set.
              (Added in 7.21.4)

       --tr-encoding
              (HTTP) Request a compressed Transfer-Encoding response using one
                     of  the  algorithms  libcurl  supports,  and uncompress the data
              while receiving it.

              (Added in 7.21.6)

       --trace <file>
              Enables a full trace dump of all  incoming  and  outgoing  data,
              including descriptive information, to the given output file. Use
              "-" as filename to have the output sent to stdout.

              This option overrides previous uses of -v, --verbose or --trace-
              ascii.

                If this option is used several times, the last one will be used.

       --trace-ascii <file>
              Enables  a  full  trace  dump of all incoming and outgoing data,
              including descriptive information, to the given output file. Use
              "-" as filename to have the output sent to stdout.

              This is very similar to --trace, but leaves out the hex part and
              only shows the ASCII part of the dump. It makes  smaller  output
                    that might be easier to read for untrained humans.

              This option overrides previous uses of -v, --verbose or --trace.
              If this option is used several times, the last one will be used.

       --trace-time
              Prepends  a  time  stamp to each trace or verbose line that curl
              displays.  (Added in 7.14.0)

       -u, --user <user:password>
              Specify the user name and password to use for server authentica-
                     tion. Overrides -n, --netrc and --netrc-optional.

              If  you  just give the user name (without entering a colon) curl
              will prompt for a password.

              If you use an SSPI-enabled curl binary and do  NTLM  authentica-
              tion,  you  can force curl to pick up the user name and password
              from your environment by simply specifying a single  colon  with
              this option: "-u :".

                  If this option is used several times, the last one will be used.

       -U, --proxy-user <user:password>
              Specify  the user name and password to use for proxy authentica-
              tion.

              If you use an SSPI-enabled curl binary and do  NTLM  authentica-
              tion,  you  can force curl to pick up the user name and password
              from your environment by simply specifying a single  colon  with
              this option: "-U :".

                 If this option is used several times, the last one will be used.

       --url <URL>
              Specify  a  URL  to  fetch. This option is mostly handy when you
              want to specify URL(s) in a config file.

              This option may be used any number of times.  To  control  where
              this  URL  is written, use the -o, --output or the -O, --remote-
              name options.
       -v, --verbose
                     Makes the fetching more  verbose/talkative.  Mostly  useful  for
              debugging.  A line starting with '>' means "header data" sent by
              curl, '<' means "header data" received by curl that is hidden in
              normal cases, and a line starting with '*' means additional info
              provided by curl.

              Note that if you only want  HTTP  headers  in  the  output,  -i,
              --include might be the option you're looking for.

                 If  you think this option still doesn't give you enough details,
              consider using --trace or --trace-ascii instead.

              This option overrides previous uses of --trace-ascii or --trace.

              Use -s, --silent to make curl quiet.

       -w, --write-out <format>
              Defines what to display on stdout after a completed and success-
              ful  operation.  The  format  is a string that may contain plain
                     text mixed with any number of variables. The string can be spec-
              ified  as "string", to get read from a particular file you spec-
              ify it "@filename" and to tell curl  to  read  the  format  from
              stdin you write "@-".

              The  variables  present in the output format will be substituted
              by the value or text that curl thinks fit, as  described  below.
                      All  variables are specified as %{variable_name} and to output a
              normal % you just write them as %%. You can output a newline  by
              using \n, a carriage return with \r and a tab space with \t.

              NOTE: The %-symbol is a special symbol in the win32-environment,
              where all occurrences of %  must  be  doubled  when  using  this
              option.

              The variables available at this point are:

                     url_effective  The URL that was fetched last. This is most mean-
                             ingful if you've told curl  to  follow  location:
                             headers.

              filename_effective
                             The  ultimate  filename  that curl writes out to.
                             This is only meaningful if curl is told to  write
                             to  a  file  with  the  --remote-name or --output
                                  option. It's most useful in combination with  the
                             --remote-header-name option. (Added in 7.25.1)

              http_code      The numerical response code that was found in the
                             last retrieved HTTP(S)  or  FTP(s)  transfer.  In
                             7.18.2  the alias response_code was added to show
                             the same info.

                http_connect   The numerical code that was  found  in  the  last
                             response   (from  a  proxy)  to  a  curl  CONNECT
                             request. (Added in 7.12.4)

              time_total     The total time, in seconds, that the full  opera-
                             tion lasted. The time will be displayed with mil-
                             lisecond resolution.

              time_namelookup
                               The time, in seconds,  it  took  from  the  start
                             until the name resolving was completed.

              time_connect   The  time,  in  seconds,  it  took from the start
                             until the TCP connect  to  the  remote  host  (or
                             proxy) was completed.

              time_appconnect
                             The  time,  in  seconds,  it  took from the start
                                 until the SSL/SSH/etc  connect/handshake  to  the
                             remote host was completed. (Added in 7.19.0)

              time_pretransfer
                             The  time,  in  seconds,  it  took from the start
                             until the file transfer was just about to  begin.
                             This includes all pre-transfer commands and nego-
                               tiations that are specific to the particular pro-
                             tocol(s) involved.

              time_redirect  The time, in seconds, it took for all redirection
                             steps include name lookup,  connect,  pretransfer
                             and  transfer  before  the  final transaction was
                             started. time_redirect shows the complete  execu-
                                 tion  time  for  multiple redirections. (Added in
                             7.12.3)

              time_starttransfer
                             The time, in seconds,  it  took  from  the  start
                             until  the first byte was just about to be trans-
                             ferred. This includes time_pretransfer  and  also
                             the  time  the  server  needed  to  calculate the
                                   result.

              size_download  The total amount of bytes that were downloaded.

              size_upload    The total amount of bytes that were uploaded.

              size_header    The total amount of bytes of the downloaded head-
                             ers.

              size_request   The  total  amount of bytes that were sent in the
                             HTTP request.

                 speed_download The average download speed that curl measured for
                             the complete download. Bytes per second.

              speed_upload   The  average  upload speed that curl measured for
                             the complete upload. Bytes per second.

              content_type   The Content-Type of the  requested  document,  if
                             there was any.

                num_connects   Number  of new connects made in the recent trans-
                             fer. (Added in 7.12.3)

              num_redirects  Number of redirects that  were  followed  in  the
                             request. (Added in 7.12.3)

              redirect_url   When a HTTP request was made without -L to follow
                             redirects, this variable will show the actual URL
                                   a redirect would take you to. (Added in 7.18.2)

              ftp_entry_path The initial path libcurl ended up in when logging
                             on to the remote FTP server. (Added in 7.15.4)

              ssl_verify_result
                             The result of the SSL peer certificate  verifica-
                             tion that was requested. 0 means the verification
                             was successful. (Added in 7.19.0)

               If this option is used several times, the last one will be used.

       -x, --proxy <[protocol://][user:password@]proxyhost[:port]>
              Use the specified HTTP proxy. If the port number is  not  speci-
              fied, it is assumed at port 1080.

              This  option  overrides  existing environment variables that set
              the proxy to use. If there's an environment variable  setting  a
              proxy, you can set proxy to "" to override it.

                      All  operations that are performed over a HTTP proxy will trans-
              parently be converted to HTTP. It means  that  certain  protocol
              specific operations might not be available. This is not the case
              if you can tunnel through the proxy, as one with the -p, --prox-
              ytunnel option.

              User and password that might be provided in the proxy string are
                    URL decoded by libcurl. This allows you to pass in special char-
              acters such as @ by using %40 or pass in a colon with %3a.

              The  proxy host can be specified the exact same way as the proxy
              environment variables, including the protocol  prefix  (http://)
              and the embedded user + password.

              From  7.21.7,  the  proxy  string may be specified with a proto-
               col://  prefix  to  specify  alternative  proxy  protocols.  Use
              socks4://,  socks4a://,  socks5://  or socks5h:// to request the
              specific SOCKS  version  to  be  used.  No  protocol  specified,
              http:// and all others will be treated as HTTP proxies.

              If this option is used several times, the last one will be used.

       -X, --request <command>
              (HTTP) Specifies a custom request method to use when communicat-
                    ing with the HTTP server.  The specified request  will  be  used
              instead  of  the  method otherwise used (which defaults to GET).
              Read the HTTP 1.1 specification for  details  and  explanations.
              Common  additional  HTTP  requests  include  PUT and DELETE, but
              related technologies like WebDAV offers PROPFIND, COPY, MOVE and
              more.

              (FTP) Specifies a custom FTP command to use instead of LIST when
               doing file lists with FTP.

              If this option is used several times, the last one will be used.

       --xattr
              When saving output to a file, this option tells  curl  to  store
              certain file metadata in extened file attributes. Currently, the
              URL is stored in the xdg.origin.url attribute and, for HTTP, the
              content  type  is stored in the mime_type attribute. If the file
                 system does  not  support  extended  attributes,  a  warning  is
              issued.

       -y, --speed-time <time>
              If a download is slower than speed-limit bytes per second during
              a speed-time period, the download gets aborted. If speed-time is
              used, the default speed-limit will be 1 unless set with -Y.

              This  option  controls  transfers  and thus will not affect slow
                 connects etc. If this is a concern for you, try  the  --connect-
              timeout option.

              If this option is used several times, the last one will be used.

       -Y, --speed-limit <speed>
              If a download is slower than this given speed (in bytes per sec-
              ond) for speed-time seconds it gets aborted. speed-time  is  set
              with -y and is 30 if not set.

                    If this option is used several times, the last one will be used.

       -z/--time-cond <date expression>|<file>
              (HTTP/FTP)  Request a file that has been modified later than the
              given time and date, or one that has been modified  before  that
              time.  The <date expression> can be all sorts of date strings or
              if it doesn't match any internal ones, it is taken as a filename
                   and  tries  to  get  the  modification  date (mtime) from <file>
              instead. See the curl_getdate(3) man pages for  date  expression
              details.

              Start the date expression with a dash (-) to make it request for
              a document that is older than the given date/time, default is  a
              document that is newer than the specified date/time.

              If this option is used several times, the last one will be used.

               -h, --help
              Usage help.

       -M, --manual
              Manual. Display the huge help text.

       -V, --version
              Displays information about curl and the libcurl version it uses.
              The  first  line  includes the full version of curl, libcurl and
              other 3rd party libraries linked with the executable.

              The second line (starts with "Protocols:") shows  all  protocols
              that libcurl reports to support.

                   The third line (starts with "Features:") shows specific features
              libcurl reports to offer. Available features include:

              IPv6   You can use IPv6 with this.

              krb4   Krb4 for FTP is supported.

              SSL    HTTPS and FTPS are supported.

              libz   Automatic decompression of compressed files over HTTP  is
                     supported.

              NTLM   NTLM authentication is supported.

              GSS-Negotiate
                      Negotiate authentication and krb5 for FTP is supported.

              Debug  This  curl  uses a libcurl built with Debug. This enables
                     more error-tracking and memory debugging etc.  For  curl-
                     developers only!

              AsynchDNS
                     This curl uses asynchronous name resolves.

              SPNEGO SPNEGO Negotiate authentication is supported.

              Largefile
                             This curl supports transfers of large files, files larger
                     than 2GB.

              IDN    This curl supports IDN - international domain names.

              SSPI   SSPI is supported. If you use NTLM and set a  blank  user
                     name,  curl  will authenticate with your current user and
                     password.

              TLS-SRP
                     SRP (Secure Remote Password) authentication is  supported
                        for TLS.

FILES
       ~/.curlrc
              Default config file, see -K, --config for details.

ENVIRONMENT
       The environment variables can be specified in lower case or upper case.
       The lower case version has precedence. http_proxy is an exception as it
       is only available in lower case.

       Using  an  environment variable to set the proxy has the same effect as
       using the --proxy option.

       http_proxy [protocol://]<host>[:port]
                     Sets the proxy server to use for HTTP.
       HTTPS_PROXY [protocol://]<host>[:port]
              Sets the proxy server to use for HTTPS.

       [url-protocol]_PROXY [protocol://]<host>[:port]
              Sets the proxy server to use for [url-protocol], where the  pro-
              tocol  is  a  protocol  that curl supports and as specified in a
              URL. FTP, FTPS, POP3, IMAP, SMTP, LDAP etc.

       ALL_PROXY [protocol://]<host>[:port]
                Sets the proxy server to use if no  protocol-specific  proxy  is
              set.

       NO_PROXY <comma-separated list of hosts>
              list  of  host names that shouldn't go through any proxy. If set
              to a asterisk '*' only, it matches all hosts.

PROXY PROTOCOL PREFIXES
       Since curl version 7.21.7, the proxy string may  be  specified  with  a
       protocol:// prefix to specify alternative proxy protocols.

              If  no  protocol  is  specified  in  the  proxy string or if the string
       doesn't match a supported one, the proxy will  be  treated  as  a  HTTP
       proxy.

       The supported proxy protocol prefixes are as follows:

       socks4://
              Makes it the equivalent of --socks4

       socks4a://
              Makes it the equivalent of --socks4a

       socks5://
              Makes it the equivalent of --socks5

       socks5h://
                   Makes it the equivalent of --socks5-hostname

EXIT CODES
       There  are  a  bunch  of  different error codes and their corresponding
       error messages that may appear during bad conditions. At  the  time  of
       this writing, the exit codes are:

       1      Unsupported protocol. This build of curl has no support for this
              protocol.

       2      Failed to initialize.

       3      URL malformed. The syntax was not correct.

         4      A feature or option that  was  needed  to  perform  the  desired
              request  was  not  enabled  or was explicitly disabled at build-
              time. To make curl able to do this, you  probably  need  another
              build of libcurl!

       5      Couldn't  resolve  proxy.  The  given  proxy  host  could not be
              resolved.

       6      Couldn't resolve host. The given remote host was not resolved.

       7      Failed to connect to host.

         8      FTP weird server reply.  The  server  sent  data  curl  couldn't
              parse.

       9      FTP  access  denied. The server denied login or denied access to
              the particular resource or directory you wanted to  reach.  Most
              often  you  tried to change to a directory that doesn't exist on
              the server.

       11     FTP weird PASS reply. Curl couldn't parse the reply sent to  the
              PASS request.

              13     FTP  weird PASV reply, Curl couldn't parse the reply sent to the
              PASV request.

       14     FTP weird 227 format.  Curl  couldn't  parse  the  227-line  the
              server sent.

       15     FTP  can't  get host. Couldn't resolve the host IP we got in the
              227-line.

       17     FTP couldn't set binary.  Couldn't  change  transfer  method  to
              binary.

       18     Partial file. Only a part of the file was transferred.

            19     FTP  couldn't download/access the given file, the RETR (or simi-
              lar) command failed.

       21     FTP quote error. A quote command returned error from the server.
       22     HTTP page not retrieved. The requested  url  was  not  found  or
              returned  another  error  with  the HTTP error code being 400 or
              above. This return code only appears if -f, --fail is used.

            23     Write error. Curl couldn't write data to a local  filesystem  or
              similar.

       25     FTP  couldn't  STOR  file. The server denied the STOR operation,
              used for FTP uploading.

       26     Read error. Various reading problems.

       27     Out of memory. A memory allocation request failed.

       28     Operation timeout. The specified  time-out  period  was  reached
              according to the conditions.

        30     FTP  PORT  failed.  The PORT command failed. Not all FTP servers
              support the PORT  command,  try  doing  a  transfer  using  PASV
              instead!

       31     FTP  couldn't use REST. The REST command failed. This command is
              used for resumed FTP transfers.

       33     HTTP range error. The range "command" didn't work.

       34     HTTP post error. Internal post-request generation error.

         35     SSL connect error. The SSL handshaking failed.

       36     FTP bad download resume. Couldn't continue  an  earlier  aborted
              download.

       37     FILE couldn't read file. Failed to open the file. Permissions?

       38     LDAP cannot bind. LDAP bind operation failed.

       39     LDAP search failed.

       41     Function not found. A required LDAP function was not found.

       42     Aborted by callback. An application told curl to abort the oper-
                ation.

       43     Internal error. A function was called with a bad parameter.

       45     Interface error. A specified outgoing  interface  could  not  be
              used.

       47     Too many redirects. When following redirects, curl hit the maxi-
              mum amount.

       48     Unknown option specified to libcurl.  This  indicates  that  you
              passed  a weird option to curl that was passed on to libcurl and
                 rejected. Read up in the manual!

       49     Malformed telnet option.

       51     The peer's SSL certificate or SSH MD5 fingerprint was not OK.

       52     The server didn't reply anything, which here  is  considered  an
              error.

       53     SSL crypto engine not found.

       54     Cannot set SSL crypto engine as default.

       55     Failed sending network data.

       56     Failure in receiving network data.

           58     Problem with the local certificate.

       59     Couldn't use specified SSL cipher.

       60     Peer  certificate cannot be authenticated with known CA certifi-
              cates.

       61     Unrecognized transfer encoding.

       62     Invalid LDAP URL.

       63     Maximum file size exceeded.

       64     Requested FTP SSL level failed.

       65     Sending the data requires a rewind that failed.

       66     Failed to initialise SSL Engine.

            67     The user name, password, or similar was not  accepted  and  curl
              failed to log in.

       68     File not found on TFTP server.

       69     Permission problem on TFTP server.

       70     Out of disk space on TFTP server.

       71     Illegal TFTP operation.

       72     Unknown TFTP transfer ID.

       73     File already exists (TFTP).

       74     No such user (TFTP).

       75     Character conversion failed.

           76     Character conversion functions required.

       77     Problem with reading the SSL CA cert (path? access rights?).

       78     The resource referenced in the URL does not exist.

       79     An unspecified error occurred during the SSH session.

       80     Failed to shut down the SSL connection.

       82     Could  not  load  CRL  file,  missing  or wrong format (added in
              7.19.0).

       83     Issuer check failed (added in 7.19.0).

        84     The FTP PRET command failed

       85     RTSP: mismatch of CSeq numbers

       86     RTSP: mismatch of Session Identifiers

       87     unable to parse FTP file list

       88     FTP chunk callback reported error

       XX     More error codes will appear here in future releases. The exist-
              ing ones are meant to never change.

AUTHORS / CONTRIBUTORS
       Daniel  Stenberg is the main author, but the whole list of contributors
           is found in the separate THANKS file.

WWW
       http://curl.haxx.se

FTP
       ftp://ftp.sunet.se/pub/www/utilities/curl/

SEE ALSO
       ftp(1), wget(1)

LATEST VERSION

  You always find news about what's going on as well as the latest versions
  from the curl web pages, located at:

        http://curl.haxx.se

SIMPLE USAGE

  Get the main page from Netscape's web-server:

        curl http://www.netscape.com/

  Get the README file the user's home directory at funet's ftp-server:
    
        curl ftp://ftp.funet.fi/README

  Get a web page from a server using port 8000:

        curl http://www.weirdserver.com:8000/

  Get a list of a directory of an FTP site:

        curl ftp://cool.haxx.se/

  Get the definition of curl from a dictionary:

        curl dict://dict.org/m:curl

  Fetch two documents at once:

        curl ftp://cool.haxx.se/ http://www.weirdserver.com:8000/

  Get a file off an FTPS server:

        curl ftps://files.are.secure.com/secrets.txt

         or use the more appropriate FTPS way to get the same file:

        curl --ftp-ssl ftp://files.are.secure.com/secrets.txt

  Get a file from an SSH server using SFTP:

        curl -u username sftp://shell.example.com/etc/issue

  Get a file from an SSH server using SCP using a private key to authenticate:

        curl -u username: --key ~/.ssh/id_dsa --pubkey ~/.ssh/id_dsa.pub \
            scp://shell.example.com/~/personal.txt

  Get the main page from an IPv6 web server:

            curl -g "http://[2001:1890:1112:1::20]/"

DOWNLOAD TO A FILE

  Get a web page and store in a local file:

        curl -o thatpage.html http://www.netscape.com/

  Get a web page and store in a local file, make the local file get the name
  of the remote document (if no file name part is specified in the URL, this
  will fail):

        curl -O http://www.netscape.com/index.html

  Fetch two files and store them with their remote names:

             curl -O www.haxx.se/index.html -O curl.haxx.se/download.html

USING PASSWORDS

 FTP

   To ftp files using name+passwd, include them in the URL like:

        curl ftp://name:passwd@machine.domain:port/full/path/to/file

   or specify them with the -u flag like

        curl -u name:passwd ftp://machine.domain:port/full/path/to/file

 FTPS

   It is just like for FTP, but you may also want to specify and use
   SSL-specific options for certificates etc.

        Note that using FTPS:// as prefix is the "implicit" way as described in the
   standards while the recommended "explicit" way is done by using FTP:// and
   the --ftp-ssl option.

 SFTP / SCP

   This is similar to FTP, but you can specify a private key to use instead of
   a password. Note that the private key may itself be protected by a password
   that is unrelated to the login password of the remote system.  If you
   provide a private key file you must also provide a public key file.
      
 HTTP

   Curl also supports user and password in HTTP URLs, thus you can pick a file
   like:

        curl http://name:passwd@machine.domain/full/path/to/file

   or specify user and password separately like in

        curl -u name:passwd http://machine.domain/full/path/to/file

   HTTP offers many different methods of authentication and curl supports
   several: Basic, Digest, NTLM and Negotiate. Without telling which method to
      use, curl defaults to Basic. You can also ask curl to pick the most secure
   ones out of the ones that the server accepts for the given URL, by using
   --anyauth.

   NOTE! Since HTTP URLs don't support user and password, you can't use that
   style when using Curl via a proxy. You _must_ use the -u style fetch
   during such circumstances.

 HTTPS

   Probably most commonly used with private certificates, as explained below.

PROXY

      curl supports both HTTP and SOCKS proxy servers, with optional authentication.
 It does not have special support for FTP proxy servers since there are no
 standards for those, but it can still be made to work with many of them. You
 can also use both HTTP and SOCKS proxies to transfer files to and from FTP
 servers.

 Get an ftp file using an HTTP proxy named my-proxy that uses port 888:

        curl -x my-proxy:888 ftp://ftp.leachsite.com/README

   Get a file from a HTTP server that requires user and password, using the
 same proxy as above:

        curl -u user:passwd -x my-proxy:888 http://www.get.this/

 Some proxies require special authentication. Specify by using -U as above:

        curl -U user:passwd -x my-proxy:888 http://www.get.this/

 A comma-separated list of hosts and domains which do not use the proxy can
 be specified as:

        curl --noproxy localhost,get.this -x my-proxy:888 http://www.get.this/

        If the proxy is specified with --proxy1.0 instead of --proxy or -x, then
 curl will use HTTP/1.0 instead of HTTP/1.1 for any CONNECT attempts.

 curl also supports SOCKS4 and SOCKS5 proxies with --socks4 and --socks5.

 See also the environment variables Curl supports that offer further proxy
 control.

 Most FTP proxy servers are set up to appear as a normal FTP server from the
 client's perspective, with special commands to select the remote FTP server.
    curl supports the -u, -Q and --ftp-account options that can be used to
 set up transfers through many FTP proxies. For example, a file can be
 uploaded to a remote FTP server using a Blue Coat FTP proxy with the
 options:

   curl -u "Remote-FTP-Username@remote.ftp.server Proxy-Username:Remote-Pass" \
    --ftp-account Proxy-Password --upload-file local-file \
    ftp://my-ftp.proxy.server:21/remote/upload/path/

 See the manual for your FTP proxy to determine the form it expects to set up
         transfers, and curl's -v option to see exactly what curl is sending.

RANGES

  With HTTP 1.1 byte-ranges were introduced. Using this, a client can request
  to get only one or more subparts of a specified document. Curl supports
  this with the -r flag.

  Get the first 100 bytes of a document:

        curl -r 0-99 http://www.get.this/

  Get the last 500 bytes of a document:

        curl -r -500 http://www.get.this/

        Curl also supports simple ranges for FTP files as well. Then you can only
  specify start and stop position.

  Get the first 100 bytes of a document using FTP:

        curl -r 0-99 ftp://www.get.this/README

UPLOADING

 FTP / FTPS / SFTP / SCP

  Upload all data on stdin to a specified server:

        curl -T - ftp://ftp.upload.com/myfile

  Upload data from a specified file, login with user and password:

        curl -T uploadfile -u user:passwd ftp://ftp.upload.com/myfile

    Upload a local file to the remote site, and use the local file name remote
  too:

        curl -T uploadfile -u user:passwd ftp://ftp.upload.com/

  Upload a local file to get appended to the remote file:

        curl -T localfile -a ftp://ftp.upload.com/remotefile

  Curl also supports ftp upload through a proxy, but only if the proxy is
  configured to allow that kind of tunneling. If it does, you can run curl in
  a fashion similar to:

                curl --proxytunnel -x proxy:port -T localfile ftp.upload.com

 HTTP

  Upload all data on stdin to a specified http site:

        curl -T - http://www.upload.com/myfile

  Note that the http server must have been configured to accept PUT before
  this can be done successfully.

  For other ways to do http data upload, see the POST section below.

VERBOSE / DEBUG

  If curl fails where it isn't supposed to, if the servers don't let you in,
      if you can't understand the responses: use the -v flag to get verbose
  fetching. Curl will output lots of info and what it sends and receives in
  order to let the user see all client-server interaction (but it won't show
  you the actual data).

        curl -v ftp://ftp.upload.com/

  To get even more details and information on what curl does, try using the
  --trace or --trace-ascii options with a given file name to log to, like
  this:

        curl --trace trace.txt www.haxx.se


   DETAILED INFORMATION

  Different protocols provide different ways of getting detailed information
  about specific files/documents. To get curl to show detailed information
  about a single file, you should use -I/--head option. It displays all
  available info on a single file for HTTP and FTP. The HTTP information is a
  lot more extensive.

  For HTTP, you can get the header information (the same as -I would show)
  shown before the data by using -i/--include. Curl understands the
        -D/--dump-header option when getting files from both FTP and HTTP, and it
  will then store the headers in the specified file.

  Store the HTTP headers in a separate file (headers.txt in the example):

        curl --dump-header headers.txt curl.haxx.se

  Note that headers stored in a separate file can be very useful at a later
  time if you want curl to use cookies sent by the server. More about that in
  the cookies section.

POST (HTTP)

         It's easy to post data using curl. This is done using the -d <data>
  option.  The post data must be urlencoded.

  Post a simple "name" and "phone" guestbook.

        curl -d "name=Rafael%20Sagula&phone=3320780" \
                http://www.where.com/guest.cgi

  How to post a form with curl, lesson #1:

  Dig out all the <input> tags in the form that you want to fill in. (There's
  a perl program called formfind.pl on the curl site that helps with this).

         If there's a "normal" post, you use -d to post. -d takes a full "post
  string", which is in the format

        <variable1>=<data1>&<variable2>=<data2>&...

  The 'variable' names are the names set with "name=" in the <input> tags, and
  the data is the contents you want to fill in for the inputs. The data *must*
  be properly URL encoded. That means you replace space with + and that you
  write weird letters with %XX where XX is the hexadecimal representation of
   the letter's ASCII code.

  Example:

  (page located at http://www.formpost.com/getthis/

        <form action="post.cgi" method="post">
        <input name=user size=10>
        <input name=pass type=password size=10>
        <input name=id type=hidden value="blablabla">
        <input name=ding value="submit">
        </form>

  We want to enter user 'foobar' with password '12345'.

  To post to this, you enter a curl command line like:

         curl -d "user=foobar&pass=12345&id=blablabla&ding=submit"  (continues)
          http://www.formpost.com/getthis/post.cgi


  While -d uses the application/x-www-form-urlencoded mime-type, generally
  understood by CGI's and similar, curl also supports the more capable
  multipart/form-data type. This latter type supports things like file upload.

  -F accepts parameters like -F "name=contents". If you want the contents to
       be read from a file, use <@filename> as contents. When specifying a file,
  you can also specify the file content type by appending ';type=<mime type>'
  to the file name. You can also post the contents of several files in one
  field.  For example, the field name 'coolfiles' is used to send three files,
  with different content types using the following syntax:

        curl -F "coolfiles=@fil1.gif;type=image/gif,fil2.txt,fil3.html" \
        http://www.post.com/postit.cgi

        If the content-type is not specified, curl will try to guess from the file
  extension (it only knows a few), or use the previously specified type (from
  an earlier file if several files are specified in a list) or else it will
  use the default type 'application/octet-stream'.

  Emulate a fill-in form with -F. Let's say you fill in three fields in a
  form. One field is a file name which to post, one field is your name and one
      field is a file description. We want to post the file we have written named
  "cooltext.txt". To let curl do the posting of this data instead of your
  favourite browser, you have to read the HTML source of the form page and
  find the names of the input fields. In our example, the input field names
  are 'file', 'yourname' and 'filedescription'.

        curl -F "file=@cooltext.txt" -F "yourname=Daniel" \
             -F "filedescription=Cool text file with cool text inside" \
                http://www.post.com/postit.cgi

  To send two files in one post you can do it in two ways:

  1. Send multiple files in a single "field" with a single field name:

        curl -F "pictures=@dog.gif,cat.gif"

  2. Send two fields with two field names:

        curl -F "docpicture=@dog.gif" -F "catpicture=@cat.gif"

  To send a field value literally without interpreting a leading '@'
  or '<', or an embedded ';type=', use --form-string instead of
   -F. This is recommended when the value is obtained from a user or
  some other unpredictable source. Under these circumstances, using
  -F instead of --form-string would allow a user to trick curl into
  uploading a file.

REFERRER

  A HTTP request has the option to include information about which address
  that referred to actual page.  Curl allows you to specify the
  referrer to be used on the command line. It is especially useful to
      fool or trick stupid servers or CGI scripts that rely on that information
  being available or contain certain data.

        curl -e www.coolsite.com http://www.showme.com/

  NOTE: The Referer: [sic] field is defined in the HTTP spec to be a full URL.

USER AGENT

  A HTTP request has the option to include information about the browser
  that generated the request. Curl allows it to be specified on the command
  line. It is especially useful to fool or trick stupid servers or CGI
         scripts that only accept certain browsers.

  Example:

  curl -A 'Mozilla/3.0 (Win95; I)' http://www.nationsbank.com/

  Other common strings:
    'Mozilla/3.0 (Win95; I)'     Netscape Version 3 for Windows 95
    'Mozilla/3.04 (Win95; U)'    Netscape Version 3 for Windows 95
    'Mozilla/2.02 (OS/2; U)'     Netscape Version 2 for OS/2
    'Mozilla/4.04 [en] (X11; U; AIX 4.2; Nav)'           NS for AIX
    'Mozilla/4.05 [en] (X11; U; Linux 2.0.32 i586)'      NS for Linux

          Note that Internet Explorer tries hard to be compatible in every way:
    'Mozilla/4.0 (compatible; MSIE 4.01; Windows 95)'    MSIE for W95

  Mozilla is not the only possible User-Agent name:
    'Konqueror/1.0'             KDE File Manager desktop client
    'Lynx/2.7.1 libwww-FM/2.14' Lynx command line browser

COOKIES

  Cookies are generally used by web servers to keep state information at the
  client's side. The server sets cookies by sending a response line in the
   headers that looks like 'Set-Cookie: <data>' where the data part then
  typically contains a set of NAME=VALUE pairs (separated by semicolons ';'
  like "NAME1=VALUE1; NAME2=VALUE2;"). The server can also specify for what
  path the "cookie" should be used for (by specifying "path=value"), when the
  cookie should expire ("expire=DATE"), for what domain to use it
  ("domain=NAME") and if it should be used on secure connections only
  ("secure").

     If you've received a page from a server that contains a header like:
        Set-Cookie: sessionid=boo123; path="/foo";

  it means the server wants that first pair passed on when we get anything in
  a path beginning with "/foo".

  Example, get a page that wants my name passed in a cookie:

        curl -b "name=Daniel" www.sillypage.com

  Curl also has the ability to use previously received cookies in following
  sessions. If you get cookies from a server and store them in a file in a
          manner similar to:

        curl --dump-header headers www.example.com

  ... you can then in a second connect to that (or another) site, use the
  cookies from the 'headers' file like:

        curl -b headers www.example.com

  While saving headers to a file is a working way to store cookies, it is
  however error-prone and not the preferred way to do this. Instead, make curl
  save the incoming cookies using the well-known netscape cookie format like
  this:

           curl -c cookies.txt www.example.com

  Note that by specifying -b you enable the "cookie awareness" and with -L
  you can make curl follow a location: (which often is used in combination
  with cookies). So that if a site sends cookies and a location, you can
  use a non-existing file to trigger the cookie awareness like:

        curl -L -b empty.txt www.example.com

  The file to read cookies from must be formatted using plain HTTP headers OR
         as netscape's cookie file. Curl will determine what kind it is based on the
  file contents.  In the above command, curl will parse the header and store
  the cookies received from www.example.com.  curl will send to the server the
  stored cookies which match the request as it follows the location.  The
  file "empty.txt" may be a nonexistent file.

  Alas, to both read and write cookies from a netscape cookie file, you can
  set both -b and -c to use the same file:

             curl -b cookies.txt -c cookies.txt www.example.com

PROGRESS METER

  The progress meter exists to show a user that something actually is
  happening. The different fields in the output have the following meaning:

  % Total    % Received % Xferd  Average Speed          Time             Curr.
                                 Dload  Upload Total    Current  Left    Speed
  0  151M    0 38608    0     0   9406      0  4:41:43  0:00:04  4:41:39  9287

  From left-to-right:
        %             - percentage completed of the whole transfer
   Total         - total size of the whole expected transfer
   %             - percentage completed of the download
   Received      - currently downloaded amount of bytes
   %             - percentage completed of the upload
   Xferd         - currently uploaded amount of bytes
   Average Speed
   Dload         - the average transfer speed of the download
   Average Speed
   Upload        - the average transfer speed of the upload
        Time Total    - expected time to complete the operation
   Time Current  - time passed since the invoke
   Time Left     - expected time left to completion
   Curr.Speed    - the average transfer speed the last 5 seconds (the first
                   5 seconds of a transfer is based on less time of course.)

  The -# option will display a totally different progress bar that doesn't
  need much explanation!

SPEED LIMIT

       Curl allows the user to set the transfer speed conditions that must be met
  to let the transfer keep going. By using the switch -y and -Y you
  can make curl abort transfers if the transfer speed is below the specified
  lowest limit for a specified time.

  To have curl abort the download if the speed is slower than 3000 bytes per
  second for 1 minute, run:

        curl -Y 3000 -y 60 www.far-away-site.com

  This can very well be used in combination with the overall time limit, so
      that the above operation must be completed in whole within 30 minutes:

        curl -m 1800 -Y 3000 -y 60 www.far-away-site.com

  Forcing curl not to transfer data faster than a given rate is also possible,
  which might be useful if you're using a limited bandwidth connection and you
  don't want your transfer to use all of it (sometimes referred to as
  "bandwidth throttle").

  Make curl transfer data no faster than 10 kilobytes per second:

           curl --limit-rate 10K www.far-away-site.com

    or

        curl --limit-rate 10240 www.far-away-site.com

  Or prevent curl from uploading data faster than 1 megabyte per second:

        curl -T upload --limit-rate 1M ftp://uploadshereplease.com

  When using the --limit-rate option, the transfer rate is regulated on a
  per-second basis, which will cause the total transfer speed to become lower
  than the given number. Sometimes of course substantially lower, if your
      transfer stalls during periods.

CONFIG FILE

  Curl automatically tries to read the .curlrc file (or _curlrc file on win32
  systems) from the user's home dir on startup.

  The config file could be made up with normal command line switches, but you
  can also specify the long options without the dashes to make it more
  readable. You can separate the options and the parameter with spaces, or
  with = or :. Comments can be used within the file. If the first letter on a
     line is a '#'-symbol the rest of the line is treated as a comment.

  If you want the parameter to contain spaces, you must enclose the entire
  parameter within double quotes ("). Within those quotes, you specify a
  quote as \".

  NOTE: You must specify options and their arguments on the same line.

  Example, set default time out and proxy in a config file:

        # We want a 30 minute timeout:
        -m 1800
        # ... and we use a proxy for all accesses:
               proxy = proxy.our.domain.com:8080

  White spaces ARE significant at the end of lines, but all white spaces
  leading up to the first characters of each line are ignored.

  Prevent curl from reading the default file by using -q as the first command
  line parameter, like:

        curl -q www.thatsite.com

  Force curl to get and display a local help page in case it is invoked
  without URL by making a config file similar to:

        # default url to get
           url = "http://help.with.curl.com/curlhelp.html"

  You can specify another config file to be read by using the -K/--config
  flag. If you set config file name to "-" it'll read the config from stdin,
  which can be handy if you want to hide options from being visible in process
  tables etc:

        echo "user = user:passwd" | curl -K - http://that.secret.site.com

EXTRA HEADERS

  When using curl in your own very special programs, you may end up needing
      to pass on your own custom headers when getting a web page. You can do
  this by using the -H flag.

  Example, send the header "X-you-and-me: yes" to the server when getting a
  page:

        curl -H "X-you-and-me: yes" www.love.com

  This can also be useful in case you want curl to send a different text in a
  header than it normally does. The -H header you specify then replaces the
  header curl would normally send. If you replace an internal header with an
     empty one, you prevent that header from being sent. To prevent the Host:
  header from being used:

        curl -H "Host:" www.server.com

FTP and PATH NAMES

  Do note that when getting files with the ftp:// URL, the given path is
  relative the directory you enter. To get the file 'README' from your home
  directory at your ftp site, do:

        curl ftp://user:passwd@my.site.com/README

  But if you want the README file from the root directory of that very same
         site, you need to specify the absolute file name:

        curl ftp://user:passwd@my.site.com//README

  (I.e with an extra slash in front of the file name.)

SFTP and SCP and PATH NAMES

  With sftp: and scp: URLs, the path name given is the absolute name on the
  server. To access a file relative to the remote user's home directory,
  prefix the file with /~/ , such as:

        curl -u $USER sftp://home.example.com/~/.bashrc

FTP and firewalls

    The FTP protocol requires one of the involved parties to open a second
  connection as soon as data is about to get transfered. There are two ways to
  do this.

  The default way for curl is to issue the PASV command which causes the
  server to open another port and await another connection performed by the
  client. This is good if the client is behind a firewall that don't allow
  incoming connections.

        curl ftp.download.com

      If the server for example, is behind a firewall that don't allow connections
  on other ports than 21 (or if it just doesn't support the PASV command), the
  other way to do it is to use the PORT command and instruct the server to
  connect to the client on the given (as parameters to the PORT command) IP
  number and port.

  The -P flag to curl supports a few different options. Your machine may have
  several IP-addresses and/or network interfaces and curl allows you to select
    which of them to use. Default address can also be used:

        curl -P - ftp.download.com

  Download with PORT but use the IP address of our 'le0' interface (this does
  not work on windows):

        curl -P le0 ftp.download.com

  Download with PORT but use 192.168.0.10 as our IP address to use:

        curl -P 192.168.0.10 ftp.download.com

NETWORK INTERFACE

  Get a web page from a server using a specified port for the interface:

           curl --interface eth0:1 http://www.netscape.com/

  or

        curl --interface 192.168.1.10 http://www.netscape.com/

HTTPS

  Secure HTTP requires SSL libraries to be installed and used when curl is
  built. If that is done, curl is capable of retrieving and posting documents
  using the HTTPS protocol.

  Example:

        curl https://www.secure-site.com

  Curl is also capable of using your personal certificates to get/post files
          from sites that require valid certificates. The only drawback is that the
  certificate needs to be in PEM-format. PEM is a standard and open format to
  store certificates with, but it is not used by the most commonly used
  browsers (Netscape and MSIE both use the so called PKCS#12 format). If you
  want curl to use the certificates you use with your (favourite) browser, you
  may need to download/compile a converter that can convert your browser's
         formatted certificates to PEM formatted ones. This kind of converter is
  included in recent versions of OpenSSL, and for older versions Dr Stephen
  N. Henson has written a patch for SSLeay that adds this functionality. You
  can get his patch (that requires an SSLeay installation) from his site at:
  http://www.drh-consultancy.demon.co.uk/

  Example on how to automatically retrieve a document using a certificate with
  a personal password:

              curl -E /path/to/cert.pem:password https://secure.site.com/

  If you neglect to specify the password on the command line, you will be
  prompted for the correct password before any data can be received.

  Many older SSL-servers have problems with SSLv3 or TLS, that newer versions
  of OpenSSL etc is using, therefore it is sometimes useful to specify what
  SSL-version curl should use. Use -3, -2 or -1 to specify that exact SSL
  version to use (for SSLv3, SSLv2 or TLSv1 respectively):
    
        curl -2 https://secure.site.com/

  Otherwise, curl will first attempt to use v3 and then v2.

  To use OpenSSL to convert your favourite browser's certificate into a PEM
  formatted one that curl can use, do something like this (assuming netscape,
  but IE is likely to work similarly):

    You start with hitting the 'security' menu button in netscape.

    Select 'certificates->yours' and then pick a certificate in the list

    Press the 'export' button

     enter your PIN code for the certs

    select a proper place to save it

    Run the 'openssl' application to convert the certificate. If you cd to the
    openssl installation, you can do it like:

     # ./apps/openssl pkcs12 -in [file you saved] -clcerts -out [PEMfile]


RESUMING FILE TRANSFERS

 To continue a file transfer where it was previously aborted, curl supports
 resume on http(s) downloads as well as ftp uploads and downloads.

 Continue downloading a document:

             curl -C - -o file ftp://ftp.server.com/path/file

 Continue uploading a document(*1):

        curl -C - -T file ftp://ftp.server.com/path/file

 Continue downloading a document from a web server(*2):

        curl -C - -o file http://www.server.com/

 (*1) = This requires that the ftp server supports the non-standard command
        SIZE. If it doesn't, curl will say so.

 (*2) = This requires that the web server supports at least HTTP/1.1. If it
        doesn't, curl will say so.

        TIME CONDITIONS

 HTTP allows a client to specify a time condition for the document it
 requests. It is If-Modified-Since or If-Unmodified-Since. Curl allow you to
 specify them with the -z/--time-cond flag.

 For example, you can easily make a download that only gets performed if the
 remote file is newer than a local copy. It would be made like:

        curl -z local.html http://remote.server.com/remote.html

 Or you can download a file only if the local file is newer than the remote
     one. Do this by prepending the date string with a '-', as in:

        curl -z -local.html http://remote.server.com/remote.html

 You can specify a "free text" date as condition. Tell curl to only download
 the file if it was updated since January 12, 2012:

        curl -z "Jan 12 2012" http://remote.server.com/remote.html

 Curl will then accept a wide range of date formats. You always make the date
 check the other way around by prepending it with a dash '-'.

DICT

  For fun try

              curl dict://dict.org/m:curl
        curl dict://dict.org/d:heisenbug:jargon
        curl dict://dict.org/d:daniel:web1913

  Aliases for 'm' are 'match' and 'find', and aliases for 'd' are 'define'
  and 'lookup'. For example,

        curl dict://dict.org/find:curl

  Commands that break the URL description of the RFC (but not the DICT
  protocol) are

        curl dict://dict.org/show:db
        curl dict://dict.org/show:strat

        Authentication is still missing (but this is not required by the RFC)

LDAP

  If you have installed the OpenLDAP library, curl can take advantage of it
  and offer ldap:// support.

  LDAP is a complex thing and writing an LDAP query is not an easy task. I do
  advice you to dig up the syntax description for that elsewhere. Two places
  that might suit you are:

  Netscape's "Netscape Directory SDK 3.0 for C Programmer's Guide Chapter 10:
  Working with LDAP URLs":
         http://developer.netscape.com/docs/manuals/dirsdk/csdk30/url.htm

  RFC 2255, "The LDAP URL Format" http://curl.haxx.se/rfc/rfc2255.txt

  To show you an example, this is now I can get all people from my local LDAP
  server that has a certain sub-domain in their email address:

        curl -B "ldap://ldap.frontec.se/o=frontec??sub?mail=*sth.frontec.se"

  If I want the same info in HTML format, I can get it by not using the -B
  (enforce ASCII) flag.

ENVIRONMENT VARIABLES

        Curl reads and understands the following environment variables:

        http_proxy, HTTPS_PROXY, FTP_PROXY

  They should be set for protocol-specific proxies. General proxy should be
  set with

        ALL_PROXY

  A comma-separated list of host names that shouldn't go through any proxy is
  set in (only an asterisk, '*' matches all hosts)

        NO_PROXY

  If the host name matches one of these strings, or the host is within the
         domain of one of these strings, transactions with that node will not be
  proxied.


  The usage of the -x/--proxy flag overrides the environment variables.

NETRC

  Unix introduced the .netrc concept a long time ago. It is a way for a user
  to specify name and password for commonly visited ftp sites in a file so
  that you don't have to type them in each time you visit those sites. You
  realize this is a big security risk if someone else gets hold of your
        passwords, so therefore most unix programs won't read this file unless it is
  only readable by yourself (curl doesn't care though).

  Curl supports .netrc files if told so (using the -n/--netrc and
  --netrc-optional options). This is not restricted to only ftp,
  but curl can use it for all protocols where authentication is used.

  A very simple .netrc file could look something like:

        machine curl.haxx.se login iamdaniel password mysecret

CUSTOM OUTPUT

         To better allow script programmers to get to know about the progress of
  curl, the -w/--write-out option was introduced. Using this, you can specify
  what information from the previous transfer you want to extract.

  To display the amount of bytes downloaded together with some text and an
  ending newline:

        curl -w 'We downloaded %{size_download} bytes\n' www.download.com

KERBEROS FTP TRANSFER

  Curl supports kerberos4 and kerberos5/GSSAPI for FTP transfers. You need
   the kerberos package installed and used at curl build time for it to be
  used.

  First, get the krb-ticket the normal way, like with the kinit/kauth tool.
  Then use curl in way similar to:

        curl --krb private ftp://krb4site.com -u username:fakepwd

  There's no use for a password on the -u switch, but a blank one will make
  curl ask for one and you already entered the real password to kinit/kauth.

TELNET

          The curl telnet support is basic and very easy to use. Curl passes all data
  passed to it on stdin to the remote server. Connect to a remote telnet
  server using a command line similar to:

        curl telnet://remote.server.com

  And enter the data to pass to the server on stdin. The result will be sent
  to stdout or to the file you specify with -o.

  You might want the -N/--no-buffer option to switch off the buffered output
  for slow connections or similar.

        Pass options to the telnet protocol negotiation, by using the -t option. To
  tell the server we use a vt100 terminal, try something like:

        curl -tTTYPE=vt100 telnet://remote.server.com

  Other interesting options for it -t include:

   - XDISPLOC=<X display> Sets the X display location.

   - NEW_ENV=<var,val> Sets an environment variable.

  NOTE: the telnet protocol does not specify any way to login with a specified
        user and password so curl can't do that automatically. To do that, you need
  to track when the login prompt is received and send the username and
  password accordingly.

PERSISTENT CONNECTIONS

  Specifying multiple files on a single command line will make curl transfer
  all of them, one after the other in the specified order.

  libcurl will attempt to use persistent connections for the transfers so that
  the second transfer to the same host can use the same connection that was
        already initiated and was left open in the previous transfer. This greatly
  decreases connection time for all but the first transfer and it makes a far
  better use of the network.

  Note that curl cannot use persistent connections for transfers that are used
  in subsequence curl invokes. Try to stuff as many URLs as possible on the
  same command line if they are using the same host, as that'll make the
  transfers faster. If you use a http proxy for file transfers, practically
         all transfers will be persistent.

MULTIPLE TRANSFERS WITH A SINGLE COMMAND LINE

  As is mentioned above, you can download multiple files with one command line
  by simply adding more URLs. If you want those to get saved to a local file
  instead of just printed to stdout, you need to add one save option for each
  URL you specify. Note that this also goes for the -O option (but not
  --remote-name-all).

  For example: get two files and use -O for the first and a custom file
      name for the second:

    curl -O http://url.com/file.txt ftp://ftp.com/moo.exe -o moo.jpg

  You can also upload multiple files in a similar fashion:

    curl -T local1 ftp://ftp.com/moo.exe -T local2 ftp://ftp.com/moo2.txt

IPv6

  curl will connect to a server with IPv6 when a host lookup returns an IPv6
  address and fall back to IPv4 if the connection fails. The --ipv4 and --ipv6
  options can specify which address to use when both are available. IPv6
          addresses can also be specified directly in URLs using the syntax:

    http://[2001:1890:1112:1::20]/overview.html

  When this style is used, the -g option must be given to stop curl from
  interpreting the square brackets as special globbing characters.  Link local
  and site local addresses including a scope identifier, such as fe80::1234%1,
  may also be used, but the scope portion must be numeric and the percent
  character must be URL escaped. The previous example in an SFTP URL might
       look like:

    sftp://[fe80::1234%251]/

  IPv6 addresses provided other than in URLs (e.g. to the --proxy, --interface
  or --ftp-port options) should not be URL encoded.


MAILING LISTS

  For your convenience, we have several open mailing lists to discuss curl,
  its development and things relevant to this. Get all info at
  http://curl.haxx.se/mail/. Some of the lists available are:

  curl-users

    Users of the command line tool. How to use it, what doesn't work, new
          features, related tools, questions, news, installations, compilations,
    running, porting etc.

  curl-library

    Developers using or developing libcurl. Bugs, extensions, improvements.

  curl-announce

    Low-traffic. Only receives announcements of new public versions. At worst,
    that makes something like one or two mails per month, but usually only one
    mail every second month.

  curl-and-php

    Using the curl functions in PHP. Everything curl with a PHP angle. Or PHP
      with a curl angle.

  curl-and-python

    Python hackers using curl with or without the python binding pycurl.

  Please direct curl questions, feature requests and trouble reports to one of
  these mailing lists instead of mailing any individual.
 %02d:%02d:%02d.%06ld  Failed to create/open output %s%s  [data not shown]
 <= Recv SSL data => Send SSL data %s== Info: %s => Send header => Send data <= Recv header <= Recv data %s%s, %zd bytes (0x%zx)
 %04zx:  %02x      * < { }     B@     B@     D@     D@     D@     &D@     0D@     eA@     eA@     A@     3B@     3B@     3B@     3B@                     4C     4C     RC     4C     4C     4C     4C     Content-disposition: COLUMNS 
%%-%ds %%5.1f%%%%       Y@Remote filename has no length!
 Failed to create the file %s: %s
 Refusing to overwrite %s: %s
 Error creating directory %s.
   You don't have permission to create %s.
        The directory name %s is too long.
     %s resides on a read-only file system.
 No space left on the file system that will contain the directory %s.
   Cannot create directory %s because you exceeded your quota.
   %s
 curl_easy_cleanup(hnd); hnd = NULL; */ ret = curl_easy_perform(hnd); hnd = curl_easy_init(); #include <curl/curl.h>   CURLcode ret;   CURL *hnd;   return (int)ret;    them yourself.        /********* Sample code generated by the curl command line tool **********       Failed to open %s to write libcurl code!
       /* Here is a list of options the curl code used that cannot get generated        * All curl_easy_setopt() options are documented at:     * http://curl.haxx.se/libcurl/c/curl_easy_setopt.html   ************************************************************************/      int main(int argc, char *argv[])        /**** End of sample code ****/     as source easily. You may select to either not use them or implement         88C     9C     @9C     x9C     7C     ?C     9C     4C     7C     7C                     ?C     8C     4C     9C                                     8C     :C     8C     ?C             %255[^=]= out of memory
 %127[^/]/%127[^;,
] ;filename= Error building form post!
 curl_formadd failed!
 ;type= Illegally formatted content-type field!
        curl_formadd failed, possibly the file %s is bad!
      Illegally formatted input field!
 no- wt Failed to open %s!
 %d - %d bad range input
 %.*s=%s ;auto list %ld- host Protocols:  Features:  <stdin> Failed to read %s *a random-file *b egd-file *c connect-timeout ciphers *e disable-epsv *E *g trace *h trace-ascii *i limit-rate *j compressed *J tr-encoding *k *l *m *M ntlm-wb *n *o *q ftp-create-dirs *r max-redirs *t proxy-ntlm *u crlf *v stderr *w interface *x krb krb4 *y max-filesize *z disable-eprt *Z $a ftp-ssl $b ftp-pasv $c socks5 socks $d tcp-nodelay $e proxy-digest $f proxy-basic $g retry $h retry-delay $i retry-max-time $k proxy-negotiate $m ftp-account $n proxy-anyauth $o trace-time $p ignore-content-length $q ftp-skip-pasv-ip $r ftp-method $s local-port $t socks4 $T socks4a $u ftp-alternative-to-user $v ftp-ssl-reqd $w sessionid $x ftp-ssl-control $y ftp-ssl-ccc $j ftp-ssl-ccc-mode $z libcurl $# raw $0 post301 $1 keepalive $2 socks5-hostname $3 keepalive-time $4 post302 $5 noproxy $8 proxy1.0 $9 tftp-blksize $A mail-from $B mail-rcpt $C ftp-pret $D proto $E proto-redir $F resolve $G delegation $H mail-auth $I post303 http1.0 tlsv1 sslv2 sslv3 ipv4 ipv6 append user-agent cookie use-ascii cookie-jar continue-at da data-ascii db data-binary data-urlencode dump-header referer Ea cacert Eb cert-type Ec Ed key-type Ee pass Ef engine Eg capath  Eh pubkey Ei hostpubmd5 Ej crlfile Ek tlsuser El tlspassword Em tlsauthtype En ssl-allow-beast fail form Fs form-string globoff get help include head junk-session-cookies remote-header-name insecure K config list-only location Lt location-trusted manual netrc no netrc-optional netrc-file buffer remote-name Oa remote-name-all proxytunnel ftpport ftp-port disable Q quote range remote-time silent show-error telnet-options upload-file U proxy-user verbose version write-out X http-request speed-limit speed-time time-cond progress-bar ~ xattr AsynchDNS Debug TrackMemory GSS-Negotiate IDN IPv6 Largefile SPNEGO SSPI libz CharConv TLS-SRP       --trace overrides an earlier trace/verbose option
      --trace-ascii overrides an earlier trace/verbose option
        unsupported rate unit. Use G, M, K or B!
       Couldn't read data from file "%s", this makes an empty POST.
   --include and --remote-header-name cannot be combined.
 error trying read config from the '%s' file
    A specified range MUST include at least one dash (-). Appending one for you!
   Invalid character is found in given range. A specified range MUST have only digits in 'start'-'stop'. The server's response to this request is uncertain.
      -v, --verbose overrides an earlier trace/verbose option
        curl 7.26.0 (x86_64-unknown-linux-gnu) %s
      Illegal date format for -z, --timecond (and not a file name). Disabling time condition. See curl_getdate(3) for valid date syntax.
     Re@     ;e@     #b@     #b@     #b@     #b@     #b@     $e@     #b@     #b@     #b@     #b@     #b@     e@     d@     j@     jj@     Uj@     #b@     @j@     #b@     #b@     #b@     #b@     #b@     #b@     #b@     #b@     #b@     #b@     i@     i@     j@     i@     i@     $i@     i@     h@     h@     h@     Uh@     0h@     k@     k@     k@     _k@     )l@     l@     ^l@     j@     d@     c@     #b@     gm@     n@     #b@     #b@     #b@     #b@     #b@     #b@     #b@     rn@     g@     g@     f@     Pf@     ;f@     &f@     f@     e@     e@     e@     e@     e@     je@     ec@     p@     b@     l@     l@     sl@     n@     <b@     m@     o@     po@     n@     #b@     #b@     #b@     p@     @     r@     r@     r@     r@     3@     r@     r@     E@     r@     r@     r@     r@     r@     r@     r@     r@     r@     r@     r@     r@     m@     r@     r@     r@     r@     r@     r@     @     @     @     @     U@     r@     g@     ہ@     U@     @     y@     y@     y@     z@     7z@     r@     Tz@     iz@     zz@     ix@     x@     x@     x@     tw@     Fx@     bw@     {@     b@     b@     b@     b@     b@     b@     b@     b@     b@     b@     b@     b@     @     @     @     ~@     :@     @     b@     b@     @     @     b@     b@     b@     b@     b@     b@     b@     &@     s@     @     @     Ċ@     @     @     %@     r@     b@     b@     b@     b@     b@     b@     b@     b@     b@     b@     @     b@     b@     b@     b@     b@     b@     b@     b@     b@     b@     b@     b@     ދ@     \@     @     @     @     @     !@     D@     g@     @     @     b@     ى@     &@     ;@     P@     e@     z@     e@     ׄ@     B@     @     @     ԅ@     @     .@     |@     }@     `}@     }@     }@     Q~@     ~@     Q{@     {@     |@     S|@     z@     w@     <w@     Ђ@     @     @     @     @     @     @     @     @     @     @     ̂@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     Ђ@     @     @     @     @     @     @     @     @     @     @     ̂@     4C     ŒC            <C     <C            <C     <C            <C     <C            BC     <C            <C     <C             <C     <C             <C     <C            <C     <C            =C     =C            =C     =C             !=C     $=C             0=C     >C             3=C     O>C             6=C     t=C             9=C     <=C             D=C     >C             G=C     q>C             J=C     M=C             ]=C     Q=C             C     `=C            k=C     n=C             y=C     |=C             =C     =C            =C     =C            =C     =C            =C     =C            =C     =C            =C     =C             =C     =C             =C     =C             =C     =C             =C     =C             =C     =C            =C     =C            =C     =C             =C      >C             
>C     >C             >C     >C            %>C     (>C            4>C     7>C            F>C     I>C             Y>C     \>C            h>C     k>C             y>C     |>C             >C     >C             >C     >C             >C     >C            >C     >C            >C     >C            >C     >C            >C     >C             ?C     ?C              ?C     ?C             ?C     ?C             ?C      ?C             0?C     3?C             ??C     B?C            S?C     V?C            ^?C     a?C             e?C     h?C             p?C     s?C             }?C     ?C            ?C     ?C            ?C     ?C             ?C     ?C            ?C     ?C            ?C     ?C            ?C     ?C            ?C     ?C            ?C     ?C             ?C     ?C            @C     @C            @C     @C            @C      @C            +@C     .@C            8@C     ;@C             f?C     C@C             q?C     K@C             ~?C     Q@C             ?C     W@C             ?C     ]@C             tCC     b@C             =C     g@C             ?C     n@C            =C     y@C            ?C     @C             =C     @C            ?C     @C            =C     ~4C            @C     @C            @C     @C            +C     @C            ?C     @C            =C     @C            @C     @C            @C     @C            @C     @C            @C     *AC            @C     @C            AC     
AC            AC     AC            AC     AC            $AC     'AC            .AC     1AC            <AC     ?AC            GAC     JAC            RAC     UAC            aAC     dAC            pAC     sAC             >C     AC             @C     AC            AC     AC            >C     AC             @C     AC             &>C     AC             ,@C     4C            5>C     AC             9@C     AC             @?C     AC             "=C     AC             G>C     AC             AC     AC            4=C     AC             C     AC             BC     
BC             Z>C     =>C            :=C     BC             i>C     "BC             (BC     +BC             AC     :BC            oCC     EBC             z>C     B4C            C     LBC             XBC     [BC             >C     kBC             C     wBC            C     BC            >C     BC             BC     BC            >C     BC            C     BC             >C     BC             C     BC             >C     BC            >C     BC            >C     >C            BC     BC            ?C     BC             ^C     BC             ?C     BC            ?C     ?C            BC     CC            BC      CC            C     
CC            1?C     CC            T?C     $CC            _?C     .CC             ;CC     =CC                                     CCC            MCC     @       SCC             _CC             mCC            qCC            vCC            C            C            CC            C            CC            =C            CC            CC            CC      @      /dev/tty        Usage: curl [options...] <url>  Options: (H) means HTTP/HTTPS only, (F) means FTP only       --anyauth       Pick "any" authentication method (H)        -a, --append        Append to target file when uploading (F/SFTP)           --basic         Use HTTP Basic Authentication (H)       --cacert FILE   CA certificate to verify peer against (SSL)             --capath DIR    CA directory to verify peer against (SSL)   -E, --cert CERT[:PASSWD] Client certificate file and password (SSL)         --cert-type TYPE Certificate file type (DER/PEM/ENG) (SSL)      --ciphers LIST  SSL ciphers to use (SSL)        --compressed    Request compressed response (using deflate or gzip)         -K, --config FILE   Specify which config file to read       --connect-timeout SECONDS  Maximum time allowed for connection      -C, --continue-at OFFSET  Resumed transfer offset       -b, --cookie STRING/FILE  String or file to read cookies from (H)       -c, --cookie-jar FILE  Write cookies to this file after operation (H)       --create-dirs   Create necessary local directory hierarchy      --crlf          Convert LF to CRLF in upload            --crlfile FILE  Get a CRL list in PEM format from the given file    -d, --data DATA     HTTP POST data (H)      --data-ascii DATA  HTTP POST ASCII data (H)             --data-binary DATA  HTTP POST binary data (H)           --data-urlencode DATA  HTTP POST data url encoded (H)           --delegation STRING GSS-API delegation permission       --digest        Use HTTP Digest Authentication (H)      --disable-eprt  Inhibit using EPRT or LPRT (F)          --disable-epsv  Inhibit using EPSV (F)      -D, --dump-header FILE  Write the headers to this file      --egd-file FILE  EGD socket path for random data (SSL)          --engine ENGINGE  Crypto engine (SSL). "--engine list" for list     -f, --fail          Fail silently (no output at all) on HTTP errors (H)         -F, --form CONTENT  Specify HTTP multipart POST data (H)            --form-string STRING  Specify HTTP multipart POST data (H)      --ftp-account DATA  Account data string (F)             --ftp-alternative-to-user COMMAND  String to replace "USER [name]" (F)          --ftp-create-dirs  Create the remote dirs if not present (F)            --ftp-method [MULTICWD/NOCWD/SINGLECWD] Control CWD usage (F)           --ftp-pasv      Use PASV/EPSV instead of PORT (F)   -P, --ftp-port ADR  Use PORT with given address instead of PASV (F)         --ftp-skip-pasv-ip Skip the IP address for PASV (F)
     --ftp-pret      Send PRET before PASV (for drftpd) (F)         --ftp-ssl-ccc   Send CCC after authenticating (F)       --ftp-ssl-ccc-mode ACTIVE/PASSIVE  Set CCC mode (F)             --ftp-ssl-control Require SSL/TLS for ftp login, clear for transfer (F)     -G, --get           Send the -d data with a HTTP GET (H)        -g, --globoff       Disable URL sequences and ranges using {} and []    -H, --header LINE   Custom header to pass to server (H)         -I, --head          Show document info only     -h, --help          This help text          --hostpubmd5 MD5  Hex encoded MD5 string of the host public key. (SSH)      -0, --http1.0       Use HTTP 1.0 (H)        --ignore-content-length  Ignore the HTTP Content-Length header      -i, --include       Include protocol headers in the output (H/F)        -k, --insecure      Allow connections to SSL sites without certs (H)        --interface INTERFACE  Specify network interface/address to use     -4, --ipv4          Resolve name to IPv4 address        -6, --ipv6          Resolve name to IPv6 address        -j, --junk-session-cookies Ignore session cookies read from file (H)        --keepalive-time SECONDS  Interval between keepalive probes             --key KEY       Private key file name (SSL/SSH)         --key-type TYPE Private key file type (DER/PEM/ENG) (SSL)       --krb LEVEL     Enable Kerberos with specified security level (F)       --libcurl FILE  Dump libcurl equivalent code of this command line       --limit-rate RATE  Limit transfer speed to this rate        -l, --list-only     List only names of an FTP directory (F)         --local-port RANGE  Force use of these local port numbers   -L, --location      Follow redirects (H)            --location-trusted like --location and send auth to other hosts (H)         -M, --manual        Display the full manual         --mail-from FROM  Mail from this address        --mail-rcpt TO  Mail to this receiver(s)        --mail-auth AUTH  Originator address of the original email      --max-filesize BYTES  Maximum file size to download (H/F)       --max-redirs NUM  Maximum number of redirects allowed (H)   -m, --max-time SECONDS  Maximum time allowed for the transfer       --negotiate     Use HTTP Negotiate Authentication (H)       -n, --netrc         Must read .netrc for user name and password             --netrc-optional Use either .netrc or URL; overrides -n         --netrc-file FILE  Set up the netrc filename to use         -N, --no-buffer     Disable buffering of the output stream          --no-keepalive  Disable keepalive use on the connection         --no-sessionid  Disable SSL session-ID reusing (SSL)            --noproxy       List of hosts which do not use proxy            --ntlm          Use HTTP NTLM authentication (H)    -o, --output FILE   Write output to <file> instead of stdout        --pass PASS     Pass phrase for the private key (SSL/SSH)       --post301       Do not switch to GET after following a 301 redirect (H)         --post302       Do not switch to GET after following a 302 redirect (H)         --post303       Do not switch to GET after following a 303 redirect (H)     -#, --progress-bar  Display transfer progress as a progress bar             --proto PROTOCOLS  Enable/disable specified protocols           --proto-redir PROTOCOLS  Enable/disable specified protocols on redirect     -x, --proxy [PROTOCOL://]HOST[:PORT] Use proxy on given port        --proxy-anyauth Pick "any" proxy authentication method (H)      --proxy-basic   Use Basic authentication on the proxy (H)       --proxy-digest  Use Digest authentication on the proxy (H)      --proxy-negotiate Use Negotiate authentication on the proxy (H)         --proxy-ntlm    Use NTLM authentication on the proxy (H)    -U, --proxy-user USER[:PASSWORD]  Proxy user and password           --proxy1.0 HOST[:PORT]  Use HTTP/1.0 proxy on given port    -p, --proxytunnel   Operate through a HTTP proxy tunnel (using CONNECT)             --pubkey KEY    Public key file name (SSH)  -Q, --quote CMD     Send command(s) to server before transfer (F/SFTP)      --random-file FILE  File for reading random data from (SSL)         -r, --range RANGE   Retrieve only the bytes within a range          --raw           Do HTTP "raw", without any transfer decoding (H)    -e, --referer       Referer URL (H)     -J, --remote-header-name Use the header-provided filename (H)   -O, --remote-name   Write output to a file named as the remote file         --remote-name-all Use the remote file name for all URLs     -R, --remote-time   Set the remote file's time on the local output      -X, --request COMMAND  Specify request command to use       --resolve HOST:PORT:ADDRESS  Force resolve of HOST:PORT to ADDRESS      --retry NUM   Retry request NUM times if transient problems occur       --retry-delay SECONDS When retrying, wait this many seconds between each        --retry-max-time SECONDS  Retry only within this period     -S, --show-error    Show error. With -s, make curl show errors when they occur  -s, --silent        Silent mode. Don't output anything      --socks4 HOST[:PORT]  SOCKS4 proxy on given host + port         --socks4a HOST[:PORT]  SOCKS4a proxy on given host + port       --socks5 HOST[:PORT]  SOCKS5 proxy on given host + port         --socks5-hostname HOST[:PORT] SOCKS5 proxy, pass host name to proxy         -Y, --speed-limit RATE  Stop transfers below speed-limit for 'speed-time' secs  -y, --speed-time SECONDS  Time for trig speed-limit abort. Defaults to 30           --ssl           Try SSL/TLS (FTP, IMAP, POP3, SMTP)             --ssl-reqd      Require SSL/TLS (FTP, IMAP, POP3, SMTP)     -2, --sslv2         Use SSLv2 (SSL)     -3, --sslv3         Use SSLv3 (SSL)         --ssl-allow-beast Allow security flaw to improve interop (SSL)          --stderr FILE   Where to redirect stderr. - means stdout        --tcp-nodelay   Use the TCP_NODELAY option  -t, --telnet-option OPT=VAL  Set telnet option      --tftp-blksize VALUE  Set TFTP BLKSIZE option (must be >512)        -z, --time-cond TIME  Transfer based on a time condition        -1, --tlsv1         Use TLSv1 (SSL)         --trace FILE    Write a debug trace to the given file           --trace-ascii FILE  Like --trace but without the hex output             --trace-time    Add time stamps to trace/verbose output         --tr-encoding   Request compressed transfer encoding (H)    -T, --upload-file FILE  Transfer FILE to destination        --url URL       URL to work with    -B, --use-ascii     Use ASCII/text transfer     -u, --user USER[:PASSWORD]  Server user and password        --tlsuser USER  TLS username            --tlspassword STRING TLS password       --tlsauthtype STRING  TLS authentication type (default SRP)         -A, --user-agent STRING  User-Agent to send to server (H)       -v, --verbose       Make the operation more talkative   -V, --version       Show version number and quit        -w, --write-out FORMAT  What to output after completion             --xattr        Store metadata in extended file attributes   -q                 If used as the first parameter disables .curlrc     `C     0`C     h`C     `C     `C     (aC     paC     aC     aC     8bC     hbC     bC     bC     8cC     pcC     cC      dC     @dC     xdC     dC     dC      eC     XeC     eC     eC     fC     @fC     pfC     fC     fC     0gC     gC     gC      hC     8hC     hC     hC     iC     PiC     iC     jC     HjC     jC     jC     kC     `kC     kC     kC     kC     HlC     plC     lC      mC     HmC     mC     mC      nC     HnC     nC     nC     oC     PoC     oC     oC     pC     XpC     pC     pC     qC     8qC     hqC     qC     qC     (rC     hrC     rC     rC     0sC     psC     sC     sC     0tC     ptC     tC     tC     (uC     xuC     uC     vC     `vC     vC     vC     0wC     pwC     wC     wC     8xC     xxC     xC     xC     HyC     xyC     yC     zC     HzC     zC     zC     zC     @{C     {C     {C      |C     H|C     |C     |C      }C     p}C     }C     }C     (~C     h~C     ~C     C     XC     C     C      C     (C     pC     C     C     C     XC     C     C      C     HC     C     ȂC      C     (C     XC     C     C     C     (C     hC     C     ؄C     C     XC             out of memory unknown error is unknown is ambiguous requires parameter is badly used here       had unsupported trailing garbage        expected a proper numerical parameter   the installed libcurl version doesn't support this      You can only select one HTTP request!
  0@     6@     `@     Z@     T@     0@     N@     H@     B@     <@     CURL_HOME dict ftps gopher http https imap imaps ldap ldaps pop3 pop3s rtmp rtsp scp sftp smtp smtps telnet tftp                ʋC            @BC            C            ϋC            ԋC            ۋC            C            C            C             C            C            C      @      C            C            C            C            C             C            C            %C     @       ,C                            curl:  Warning:         curl: try 'curl --help' or 'curl --manual' for more information
        error initializing curl library
        error retrieving curl library information
      error initializing curl easy handle
    Remote file name has no length!
        Using --anyauth or --proxy-anyauth with upload from stdin involves a big risk of it not working. Use a temporary file or a fixed auth type instead!
    CURLOPT_SSH_HOST_PUBLIC_KEY_MD5 CURLOPT_FTP_CREATE_MISSING_DIRS CURLOPT_FTP_ALTERNATIVE_TO_USER CURLOPT_HTTP_TRANSFER_DECODING  If this HTTPS server uses a certificate signed by a CA represented in
 the bundle, the certificate verification probably failed due to a
 problem with the certificate (it might be expired, or the name might
 not match the domain name in the URL).
If you'd like to turn off curl's verification of the certificate, use
 the -k (or --insecure) option.
   More details here: http://curl.haxx.se/docs/sslcerts.html

curl performs SSL certificate verification by default, using a "bundle"
 of Certificate Authority (CA) public keys (CA certs). If the default
 bundle file isn't adequate, you can specify an alternate file
 using the --cacert option.
    Error setting extended attributes: %s
  Transient problem: %s Will retry in %ld seconds. %ld retries left.
 option %s: %s
 --url no URL specified!
 CURL_CA_BUNDLE SSL_CERT_DIR SSL_CERT_FILE Failed to open %s
 bad output glob!
 ab Can't open '%s'!
 fcntl failed on fd=%d: %s
 <stdout> 
[%d/%d]: %s --> %s
 --_curl_-- %s%s
 %s%c%s %s/?%s CURLOPT_TCP_NODELAY CURLOPT_WRITEDATA CURLOPT_WRITEFUNCTION CURLOPT_READDATA CURLOPT_READFUNCTION CURLOPT_SEEKDATA CURLOPT_SEEKFUNCTION CURLOPT_BUFFERSIZE CURLOPT_INFILESIZE_LARGE CURLOPT_URL CURLOPT_NOPROGRESS CURLOPT_NOBODY CURLOPT_HEADER CURLOPT_PROXY CURLOPT_PROXYUSERPWD CURLOPT_HTTPPROXYTUNNEL CURLOPT_PROXYTYPE CURLOPT_PROXYAUTH CURLOPT_NOPROXY CURLOPT_FAILONERROR CURLOPT_UPLOAD CURLOPT_DIRLISTONLY CURLOPT_APPEND CURLOPT_NETRC CURLOPT_NETRC_FILE CURLOPT_TRANSFERTEXT CURLOPT_USERPWD CURLOPT_RANGE CURLOPT_ERRORBUFFER CURLOPT_TIMEOUT CURLOPT_FOLLOWLOCATION CURLOPT_UNRESTRICTED_AUTH CURLOPT_POSTFIELDS CURLOPT_POSTFIELDSIZE_LARGE CURLOPT_HTTPPOST CURLOPT_REFERER CURLOPT_AUTOREFERER CURLOPT_USERAGENT CURLOPT_HTTPHEADER CURLOPT_MAXREDIRS CURLOPT_HTTP_VERSION CURLOPT_HTTPAUTH CURLOPT_POSTREDIR CURLOPT_ACCEPT_ENCODING CURLOPT_TRANSFER_ENCODING CURLOPT_FTPPORT CURLOPT_LOW_SPEED_LIMIT CURLOPT_LOW_SPEED_TIME CURLOPT_MAX_SEND_SPEED_LARGE CURLOPT_MAX_RECV_SPEED_LARGE CURLOPT_RESUME_FROM_LARGE CURLOPT_SSLCERT CURLOPT_SSLCERTTYPE CURLOPT_SSLKEY CURLOPT_SSLKEYTYPE CURLOPT_KEYPASSWD CURLOPT_SSH_PRIVATE_KEYFILE CURLOPT_SSH_PUBLIC_KEYFILE CURLOPT_CAINFO CURLOPT_CAPATH CURLOPT_CRLFILE CURLOPT_SSL_VERIFYPEER CURLOPT_SSL_VERIFYHOST %s/%sssh/known_hosts CURLOPT_SSH_KNOWNHOSTS CURLOPT_FILETIME CURLOPT_CRLF CURLOPT_QUOTE CURLOPT_POSTQUOTE CURLOPT_PREQUOTE CURLOPT_COOKIE CURLOPT_COOKIEFILE CURLOPT_COOKIEJAR CURLOPT_COOKIESESSION CURLOPT_SSLVERSION CURLOPT_TIMECONDITION CURLOPT_TIMEVALUE CURLOPT_CUSTOMREQUEST CURLOPT_STDERR CURLOPT_INTERFACE CURLOPT_KRBLEVEL CURLOPT_PROGRESSFUNCTION CURLOPT_PROGRESSDATA CURLOPT_TELNETOPTIONS CURLOPT_RANDOM_FILE CURLOPT_EGDSOCKET CURLOPT_CONNECTTIMEOUT CURLOPT_SSL_CIPHER_LIST CURLOPT_FTP_USE_EPSV CURLOPT_FTP_USE_EPRT CURLOPT_DEBUGFUNCTION CURLOPT_DEBUGDATA CURLOPT_VERBOSE CURLOPT_SSLENGINE CURLOPT_SSLENGINE_DEFAULT CURLOPT_MAXFILESIZE_LARGE CURLOPT_IPRESOLVE CURLOPT_USE_SSL CURLOPT_FTP_SSL_CCC CURLOPT_FTP_ACCOUNT CURLOPT_IGNORE_CONTENT_LENGTH CURLOPT_FTP_SKIP_PASV_IP CURLOPT_FTP_FILEMETHOD CURLOPT_LOCALPORT CURLOPT_LOCALPORTRANGE CURLOPT_SSL_SESSIONID_CACHE CURLOPT_HTTP_CONTENT_DECODING CURLOPT_TCP_KEEPALIVE CURLOPT_TCP_KEEPIDLE CURLOPT_TCP_KEEPINTVL CURLOPT_TFTP_BLKSIZE CURLOPT_MAIL_FROM CURLOPT_MAIL_RCPT CURLOPT_FTP_USE_PRET CURLOPT_PROTOCOLS CURLOPT_REDIR_PROTOCOLS CURLOPT_HEADERFUNCTION CURLOPT_HEADERDATA CURLOPT_RESOLVE CURLOPT_TLSAUTH_USERNAME CURLOPT_TLSAUTH_PASSWORD CURLOPT_TLSAUTH_TYPE CURLOPT_GSSAPI_DELEGATION CURLOPT_SSL_OPTIONS CURLOPT_MAIL_AUTH curl: Saved to filename '%s'
 Throwing away %ld bytes
 failed to truncate, exiting
 curl: (%d) %s
 (%d) Failed writing body
 HTTP error FTP error               <C     C     C     %s/%s http:// https:// Build-time engines:   <none> curl/7.26.0 none policy always passive active singlecwd nocwd multicwd , unrecognized protocol '%s'
        unrecognized delegation method '%s', using none
        unrecognized ftp CCC method '%s', using default
        unrecognized ftp file method '%s', using default
       Enter %s password for user '%s':                                                                                                                                                                                                                                                                                        gBC     ۋC            C            C            ϋC            C            C             %C     @       C            C            ʋC            @BC            ,C            C            C             C      @      C            C            C            C            ԋC                            .curlrc %s%s%s %s:%d: warning: '%s' %s
 curl_easy_setopt(hnd, %s, %ldL);        curl_easy_setopt(hnd, %s, (long)%s);    curl_easy_setopt(hnd, %s, "%s");        curl_easy_setopt(hnd, %s, %s);  slist%d = curl_slist_append(slist%d, "%s");     curl_easy_setopt(hnd, %s, slist%d);     struct curl_httppost *postend;  curl_formadd(&post%d, &postend,              CURLFORM_COPYNAME, "%s",                CURLFORM_FILE, "%s",                    CURLFORM_FILECONTENT, "%s",                     CURLFORM_COPYCONTENTS, "%s",                    CURLFORM_FILENAME, "%s",                CURLFORM_CONTENTTYPE, "%s",        curl_easy_setopt(hnd, %s, post%d); curl_easy_setopt(hnd, %s,   | %s(long)%s%s %*s %s%luUL); %s%ldL); \%03o %ldL functionpointer objectpointer (curl_off_t)%ld %s set to a %s struct curl_slist *slist%d; slist%d = NULL; curl_slist_free_all(slist%d); struct curl_httppost *post%d; post%d = NULL; curl_formfree(post%d); postend = NULL;              CURLFORM_END); CURLPROXY_HTTP CURLPROXY_HTTP_1_0 CURLPROXY_SOCKS4 CURLPROXY_SOCKS5 CURLPROXY_SOCKS4A CURLPROXY_SOCKS5_HOSTNAME CURLAUTH_ANY CURLAUTH_ANYSAFE CURLAUTH_BASIC CURLAUTH_DIGEST CURLAUTH_GSSNEGOTIATE CURLAUTH_NTLM CURLAUTH_DIGEST_IE CURLAUTH_NTLM_WB CURLAUTH_ONLY CURLAUTH_NONE CURL_HTTP_VERSION_NONE CURL_HTTP_VERSION_1_0 CURL_HTTP_VERSION_1_1 CURL_SSLVERSION_DEFAULT CURL_SSLVERSION_TLSv1 CURL_SSLVERSION_SSLv2 CURL_SSLVERSION_SSLv3 CURL_TIMECOND_IFMODSINCE CURL_TIMECOND_IFUNMODSINCE CURL_TIMECOND_LASTMOD CURL_TIMECOND_NONE CURLFTPSSL_CCC_NONE CURLFTPSSL_CCC_PASSIVE CURLFTPSSL_CCC_ACTIVE CURLPROTO_ALL CURLPROTO_DICT CURLPROTO_FILE CURLPROTO_FTP CURLPROTO_FTPS CURLPROTO_GOPHER CURLPROTO_HTTP CURLPROTO_HTTPS CURLPROTO_IMAP CURLPROTO_IMAPS CURLPROTO_LDAP CURLPROTO_LDAPS CURLPROTO_POP3 CURLPROTO_POP3S CURLPROTO_RTSP CURLPROTO_SCP CURLPROTO_SFTP CURLPROTO_SMTP CURLPROTO_SMTPS CURLPROTO_TELNET CURLPROTO_TFTP             ǥC             ֥C            C            C            C            C                                            7C     DC     UC            dC            tC            C            C            C             C            ʦC                                             ئC             C            C                            C             3C            IC            _C                                            uC            C            C            C                                             ҧC             C            C                            C     !C            0C            ?C            MC            \C            mC            |C            C            C             C            C            ʨC      @      ٨C            C            C            C             C            $C            4C     @       EC                            %0*d unmatched brace at pos %zu
 illegal pattern at pos %zu
 %c-%c%c%d%c %d-%d%c%d%c missing ']' curl: (%d) [globbing] %s       internal error: invalid pattern type (%d)
      unmatched close brace/bracket at pos %zu
       nested braces not supported at pos %zu
 error: bad range specification after pos %zu
   error: unsupported character (%c) after range at pos %zu
       illegal character in range specification at pos %zu
        .A%03ld %.3f %.0f url_effective http_code response_code http_connect time_total time_namelookup time_connect time_appconnect time_pretransfer time_starttransfer size_header size_request size_download size_upload speed_download speed_upload content_type num_connects time_redirect num_redirects ftp_entry_path redirect_url ssl_verify_result filename_effective    curl: unknown --write-out variable: '%s'
                       @     @     @     @     @     @     @     	@     B@     N@     ]@     l@     @     @     @     @     !@     -@     <@     K@     Z@     f@     r@     @     C            C             C            .C            ;C            FC            VC            cC            sC            C            C     
       C            C            C            ʯC     	       ٯC     
       C            C             C            C            C            +C            8C            JC                            user.xdg.origin.url user.mime_type              C           C                           s@     z@     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     @     	@     @     @     )@     5@     ?@     e@     I@     ;  S   k  0  0  pH  `h       @     О  0  `H  0x  `          0  Ph         P         8  `h          p     0@  @X  Pp    @      0   p  0  @H  `  0  P          	  !H	   #	  P#	  #	  (	  )
  *H
  P,
  p-
   0
  P1
  4   40  P5h  7  0:  0B  C  C0   DH  0D`  Dx  H  0I  @J 
  J(
  KP
  Kp
  @L
  PL
             zR x        @ i    D    4   4   P@@    BBE B(D0A8J     4   l   PF@ 8   BDE I(A0E8DP            H@     JY@ ,      I@ `   BLD A(G             J@ T    J       @K@     D    $   $  `K@    Ed@          L   M@    BAD    l  R@    JML0      U@ |    D    ,     U@    BBE A(A0           PW@ '    A       W@ F    D         W@     I       X@               4  X@     JQ    4   T  Y@    BDB B(D0D8R     4     `@ ,   BBB E(A0A8G          p@     D       0@     JWG0      @      A        @ F              ,  p@ -    D       D  @ &    D       \  Џ@ Y    A     t  0@     BFA ,     @     BJF A(G            @                 @ =    BDD      @     JWG0     В@     JO       <  @    JY   \  @ +           $   t  @ 6   VT           P@                 `@ 
                p@ n    ADL        @ y    BDA      `@ ]   E\G0   ,  @ 8    A     D   @ B    D     \  P@ 8    A     t  @ H    D         @ v    N      `@ g    N      @ t    AIG        P@     A       p@ T   J\     @ ;    A  $   ,  @    J[@          T  @ "    D  4   l  @ 0   BGB B(D0A8DP      4     @    BEE B(A0A8G           @ I    A       p@ z    JQ@   4     @    BEB B(A0A8G$        L  @     JS0   4   l  @ [   BGH B(A0D8I     4      @ b   BGH B(A0D8I     $     p@    BED A(D0$     @    Ja         ,   @ O   JTG0$   L  p@    JYG@         t  0@            4     @@ "   BBE B(A0A8D@      4     p@ w   BBB B(A0A8D     $     @ T   J[@       $   $	  P@    JMQ     $   L	  P@ \   JMQP         t	  @ 0              	  @ U              	  @@               	  P@ c    DP    4   	  @    BEB B(A0A8Dp      4   
  @     BGB E(D0A8DP         D
  P@           $   \
  `@     BEA A(   $   
  @     J^8          
  @ =    BGD    
   A J    JF               zR x        >           $   4   >    JQQ@                                                                                                  h@     
       8A     o    @@            @            @     
       
                                           c            (                           @@            @            `       	              o    @     o           o    @                                                                                                             8c                     @     @     @     @     @     @     @     @     @     &@     6@     F@     V@     f@     v@     @     @     @     @     @     @     @     @     @     @     &@     6@     F@     V@     f@     v@     @     @     @     @     @     @     @     @     @     @     &@     6@     F@     V@     f@     v@     @     @     @     @     @     @     @     @     @     @     &@     6@     F@     V@     f@     v@     @     @     @     @     @     @     @     @     @     @     &@     6@     F@     V@     f@     v@     @     @     @     @     @     @     @     @          GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  .symtab .strtab .shstrtab .interp .note.ABI-tag .gnu.hash .dynsym .dynstr .gnu.version .gnu.version_r .rela.dyn .rela.plt .init .text .fini .rodata .eh_frame_hdr .eh_frame .ctors .dtors .jcr .dynamic .got .got.plt .data .bss .comment                                                                                    @                                          #             @                                          1   o       @@     @      D                             ;             @           0	                          C             @           
                             K   o       @                                       X   o       @           P                            g             @           `                            q             @@     @      (                          {             h@     h                                    v             @                                                     @            8                                          8A     8                                                `A     `                                                C                                                     ȶC     ȶ     D                                          c                                                      c                                                      0c     0                                                8c     8                                             c                                                     c                                                    c                                                     c                                                                   D                                                                                                            H              G                 	                      8                                                               ,@                  c                   c             -     0c             :     c            H      c            W     P@             m     @             y     c                  C                  0c                   A                  c                 c                 	c                 c                 5C     8            U@     |           `:C     X           :C     (       !     ;C     (       )     PC           1     _C            7    p@            ?    c     <       M    `c     <       Y    C           b    @     &       i    @C     `          @                @     +            C                 C     `          p@               P@               `C                C     0           c                 c                 c                 c             '    c             :    c             K    c             ^   8c                    @                   @                   @@                   @                   @                   @                   @                   @                  	 @@                  
 h@                   @                    @                  
 8A                   `A                    C                   ȶC                   c                    c                   0c                   8c                   c                    c                   c                   c                                   g    @K@            t     c                  @     b          @C     P                              @     "                    $           @     0          0@                @c                @               @                              ,    ` A            <             @       N     @             U    @            f             l       y                        C     `          R@               P@                Dc                @     t                    %                                 @     I           0@                P@     c       '                    ;     A     J       J                      Y                      m                                            @                          .                   5           U@               @     i            @     F           C     P                    .            @     O      '   
 8A             -    @            :                    L             $      `             
       s                       В@                 c                @@                P@     \          PW@     '           p@     w          8c                `@     ]          @     8           @                                  @@     "      +                   >    `@     ,      K             )      a                    v             ;           p@     z           `A                                             T                               H@                                                       @     ;                           0    c             =             K       R    @     H       _             7       x             y           P@     8                    g          PF@     8          @               Y@                                   c                                    c            
    @               `@     g       $                    C    p@           X             =       m             >                    3                                        %                                                   P@                        +      	             U       	    C            $	    c            -	             w       ;	                   O	   hA             \	    I@     `      m	    (c            z	             :      	                    	   (c             	    p A            	                    	                    	             e      	    @     =       
    @     0       
                    )
    0c            9
             t      N
                   b
             F      u
             J       
                    
    @     T      
    c            
    C     @       
    @     y       
                        P@@              c                 @     v       &    @     =       4                    C    @           O    `@     
       Y    0@            g                    t             (           X@                                                        p@     -                    .           @     U            @     B           p@     T                             Џ@     Y       "                    4   c             9                   M    C     @       f     M@           y    @                c                         %           @                         V          @     6                   %           W@                P@            
             y       
             c      )
    p@     n       ;
             u      P
                   g
   c             n
                    |
                    
    `@            
             (      
    J@     T       
    `C     p       
             9      
    X@            
                                           W@     F       /                    A                    P                    ^    c            r             %                               @               
 h@                 `K@                                   @     [       call_gmon_start __CTOR_LIST__ __DTOR_LIST__ __JCR_LIST__ dtor_idx.6147 completed.6145 __do_global_dtors_aux frame_dummy __CTOR_END__ __FRAME_END__ __JCR_END__ __do_global_ctors_aux known_offset.4935 epoch_offset.4934 newl.4939 traced_data.4940 s_infotype.4936 easysrc_free srchead srcend srchard aliases feats ttyecho withecho.5251 noecho.5252 helptext GetEnv possibly_built_in.4723 AppendNode is_fatal_error m.5945 protos.5048 c_escape glob_word replacements mappings __preinit_array_start __fini_array_end _GLOBAL_OFFSET_TABLE_ __preinit_array_end __fini_array_start __init_array_end __init_array_start _DYNAMIC tool_seek_cb data_start tool_setopt_flags setopt_nv_CURL_TIMECOND tcsetattr@@GLIBC_2.2.5 cleanarg fileno@@GLIBC_2.2.5 file2memory getpass_r easysrc_form_count warnf tool_setopt memset@@GLIBC_2.2.5 __libc_csu_fini curl_easy_getinfo _start tool_setopt_enum close@@GLIBC_2.2.5 curl_strequal setopt_nv_CURLPROTO create_dir_hierarchy main_free easysrc_slist_count ftpfilemethod utime@@GLIBC_2.2.5 curl_easy_setopt new_getout get_libcurl_info tool_tvnow isatty@@GLIBC_2.2.5 curlx_nonblock __gmon_start__ _Jv_RegisterClasses puts@@GLIBC_2.2.5 fseek@@GLIBC_2.2.5 tool_help curl_easy_escape curl_global_cleanup dumpeasysrc hugehelp param2text setopt_nv_CURL_SSLVERSION gettimeofday@@GLIBC_2.2.5 tool_setopt_slist _fini fwrite_xattr read@@GLIBC_2.2.5 malloc@@GLIBC_2.2.5 fopen@@GLIBC_2.2.5 __libc_start_main@@GLIBC_2.2.5 helpf easysrc_data tool_tvlong glob_url easysrc_add glob_match_url easysrc_clean add_file_name_to_url stdin_upload file2string curl_formadd glob_cleanup fgets@@GLIBC_2.2.5 getparameter getpwuid@@GLIBC_2.2.5 geteuid@@GLIBC_2.2.5 curl_easy_init str2num _IO_stdin_used __strtoul_internal@@GLIBC_2.2.5 __strdup@@GLIBC_2.2.5 fputc@@GLIBC_2.2.5 progressbarinit free@@GLIBC_2.2.5 curl_free str2offset strlen@@GLIBC_2.2.5 __data_start __xstat@@GLIBC_2.2.5 my_useragent __ctype_b_loc@@GLIBC_2.3 curl_slist_append list_engines curl_easy_pause tool_header_cb ourWriteOut formparse curl_mvaprintf built_in_protos curl_mvfprintf stdin@@GLIBC_2.2.5 proto2num ftpcccmethod __strtol_internal@@GLIBC_2.2.5 tool_setopt_httppost strrchr@@GLIBC_2.2.5 curl_slist_free_all curl_version sscanf@@GLIBC_2.2.5 pipe@@GLIBC_2.2.5 poll@@GLIBC_2.2.5 strerror@@GLIBC_2.2.5 Curl_raw_toupper strstr@@GLIBC_2.2.5 curl_mvsnprintf setopt_nv_CURLAUTH curlinfo curl_formfree strcat@@GLIBC_2.2.5 __dso_handle tool_progress_cb easysrc_code fputs@@GLIBC_2.2.5 lseek@@GLIBC_2.2.5 __DTOR_END__ __libc_csu_init curl_easy_perform tcgetattr@@GLIBC_2.2.5 memcpy@@GLIBC_2.2.5 Curl_strntoupper tool_tvdiff curl_easy_cleanup easysrc_toohard memmove@@GLIBC_2.2.5 strchr@@GLIBC_2.2.5 fread@@GLIBC_2.2.5 __fxstat@@GLIBC_2.2.5 getenv@@GLIBC_2.2.5 glob_next_url easysrc_decl setopt_nv_CURL_HTTP_VERSION clean_getout __errno_location@@GLIBC_2.2.5 tool_debug_cb __bss_start delegation FreeMultiInfo curl_msnprintf parseconfig main_init tool_go_sleep curl_mprintf fsetxattr@@GLIBC_2.3 easysrc_init strcpy@@GLIBC_2.2.5 strtok@@GLIBC_2.2.5 SetHTTPrequest curl_getenv tool_tvdiff_secs output_expected checkpasswd calloc@@GLIBC_2.2.5 homedir curl_version_info _end fclose@@GLIBC_2.2.5 setopt_nv_CURLFTPSSL_CCC free_config_fields Curl_raw_nequal stderr@@GLIBC_2.2.5 ftruncate@@GLIBC_2.2.5 AddMultiFiles curl_getdate operate access@@GLIBC_2.2.5 easysrc_perform add2list curl_global_init fwrite@@GLIBC_2.2.5 get_url_file_name realloc@@GLIBC_2.2.5 setlocale@@GLIBC_2.2.5 _edata curl_msprintf localtime@@GLIBC_2.2.5 Curl_raw_equal curl_maprintf tool_read_cb setopt_nv_CURLPROXY clock_gettime@@GLIBC_2.2.5 easysrc_addf fcntl@@GLIBC_2.2.5 curl_easy_strerror easysrc_cleanup open@@GLIBC_2.2.5 curl_strnequal curl_mfprintf stdout@@GLIBC_2.2.5 mkdir@@GLIBC_2.2.5 time@@GLIBC_2.2.5 main _init tool_write_cb fflush@@GLIBC_2.2.5 tool_setopt_bitmask                                                                                                                                                                                                                                                 pre_diag/tools64/netcat                                                                             0000755 0000000 0000000 00000130114 12667754516 014067  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   ELF          >    @     @                 @ 8  @         @       @ @     @ @                                      @      @                                          @       @                                       `      `                               (      (`     (`                                    @     @                            Ptd   8y      8y@     8y@     4      4             Qtd                                                  /lib64/ld-linux-x86-64.so.2          GNU           	          E          ! E   F   H   )fUa92                                     %                                               *                                  %                                        l                                                                     5                    *                                         ~             %       (                                   !      s             :       &                                        -                                        l             $      E              
       F                   _              %       a             (                    l                           Z              T       l                   :             l                    %                    7       3                     O                    R              =                    9       =                                                    (                    %       t                     H             e                   t                                                           %       )                                         j                     ^             .                                                           p                                          1                    %                     u      ;                    c              U                          X                                        |              
                                               !                                  0      3     `                 `                `            K      `                `             __gmon_start__ libc.so.6 socket fflush exit execl sprintf setlocale fopen optind strrchr __strdup perror dcgettext connect inet_ntop strncpy time putchar listen select realloc abort stdin inet_pton __assert_fail fgets calloc sigemptyset memset __errno_location bind read getsockopt dup2 shutdown vsnprintf stdout gethostbyaddr memcpy __strtol_internal setsockopt malloc strcasecmp getpeername __ctype_b_loc recvfrom optarg getservbyname stderr gethostbyname getopt_long usleep sigaction srandom close strchr fprintf getsockname accept fcntl memmove bindtextdomain recvmsg strerror __libc_start_main write getservbyport free GLIBC_2.3 GLIBC_2.2.5                                                                                              ii
   q     ui	   {      `        
            `        H           `        F           `        I           `        G            `        E           ؁`                   `                   `                   `                   `                    `                   `                   `                   `        	            `                   (`                   0`        
           8`                   @`                   H`                   P`                   X`                   ``                   h`                   p`                   x`                   `                   `                   `                   `                   `                   `                   `                   `                   `                   Ȃ`                    Ђ`        !           ؂`        "           `        #           `        $           `        %           `        &            `        '           `        (           `        )           `        *            `        +           (`        ,           0`        -           8`        .           @`        /           H`        0           P`        1           X`        2           ``        3           h`        4           p`        5           x`        6           `        7           `        8           `        9           `        :           `        ;           `        <           `        =           `        >           `        ?           ȃ`        @           Ѓ`        A           ؃`        B           `        C           `        D           H    
I  H5n  %n  @ %n  h    %n  h   %
n  h   %n  h   %m  h   %m  h   %m  h   %m  h   p%m  h   `%m  h	   P%m  h
   @%m  h   0%m  h    %m  h
   %m  h    %m  h   %m  h   %m  h   %m  h   %m  h   %zm  h   %rm  h   %jm  h   %bm  h   p%Zm  h   `%Rm  h   P%Jm  h   @%Bm  h   0%:m  h    %2m  h   %*m  h    %"m  h   %m  h    %m  h!   %
m  h"   %m  h#   %l  h$   %l  h%   %l  h&   %l  h'   p%l  h(   `%l  h)   P%l  h*   @%l  h+   0%l  h,    %l  h-   %l  h.    %l  h/   %l  h0   %l  h1   %l  h2   %l  h3   %zl  h4   %rl  h5   %jl  h6   %bl  h7   p%Zl  h8   `%Rl  h9   P%Jl  h:   @%Bl  h;   0%:l  h<    %2l  h=   %*l  h>    %"l  h?   %l  h@   %l  hA   %
l  hB           1I^HHPTI\@ H \@ H>@ HHi  HtHÐUHSH=k   uD` H-` HHXHk  H9vHHk  ` Hk  H9wk  H[ UH=wg   Ht    Ht ` IAÐAWAVAUIATIUSH  H  H|  D$`	  ^D$X    D$\     L$`9L$XHǄ$      HǄ$      j   D$kMD$XD$dHc?HL$DHD$H   HHHcL$XHT$8I  HT$I$  HHL$PI$  HT$I  HL$L$XH$?HL$4HD$(H$p  HHD$ =xj   Ǆ$       =_j     1    HǄ      HHu0HǄp      HHuE$  E1EuHL$HHD$8A   H	  E  E  E1E$  E~H$   uH$     E  H$   Y  H$  |$dH$p  H$  1I *  uHǄ$      HǄ$      HL$PA   H  L$4H  E  E~!I$  zK  I   S  A$  ~G5
i  M$  HcӅx  H$   !  HT$B  HT$H:   EtHL$HH  L$DH  A$  ~:=h     HT$B~!I  J  I$     A     M  |$\HcLGLcL5h   Hŉh    9  9N؀=h   \$lt?A|$u
=g     H=g  ^@ 1H=g  LL<     H$D$l)AHHAA  I   V  =g      |$k |$`    |$`AEA$t|$X   |$XAE f  HĨ  1[]A\A]A^A_HD$HHT$8H	p  H$   L1H$   C6=kf      HT$PHL$(H	  H$   A>
L     9O  BH<
uHcHcƉH$  |$`L~H  H)f  9N=Sf   Hc  HL$)iHYHT$BUH:0HL$H    HA    HA    ;=e  A|$  H\$p|$`   HK L    A$  IǄ$      I$  ҉T$\T$XC@`@ $  ]@ 8]@ @`@ X  ]@ ^@ H$   |$XHt$p         =e  f  =e     A   d   @`@   ]@ ]@ 
I  HL$I$  HAHBHAHBIǅ      HA    HA    L6:      W  rd   I$  HL$I  HAHBHAHBIǄ$      HA    HA    HL$pA   A  Iǅ      I  D$k Y=c   
H\$p|$`L$  L$p  1ɺ   HHǄ$p      HǄ$x      .H=c  t]@ 1H=c  HL>     HL$)iHY68  118F]@ /   UA   D$k I  )H$Iǅ      HB    HB    _Hc}HL$HHcQHqHHT$HHB HD$HcxFHL$HI  HcQHqzI  HT$HBnHc
HI$  HD$HcPHp@I$  HT$HBHcӉHcH$HI  HcQHqI  H$HBsH|$ $r  f/  H=a  HDÉ꾩]@ 1      <a   9]@    @`@   ]@ +]@ ]]@ p   ]@ \   i]@ H   nfD  H\$Hl$   Ld$HH(   +     f$ J  IfD$f|$ p  D$ut   HxFf$      LfD$  AD$xHl$H\$Ld$ H(É>         AWIAVAUATUSH  H5  G    _      Ǆ$     \$           H*  ÉE  CH$     fǄ$   D$$AJ  f$  Ap  $  }  H$  1A      i  fAH   M   uRH$P  H$  Ǆ$     a  $R  1Lf.  fAH   *  ILL$ 
  A-     Hþ]@ 1UHHƿ    1H$   c  HcD$ HǄ$x      H\$H$p  1 ID     HHuDu E~1u 1ҿ   LHHc?HHH	 
  BH9~E1|$ H$p  |$$LLM11WtTDe EyHD$(    HD$(DDIcDH?H 
  HuID$(HD$(9E 4: n   H4  AE'HĨ  D[]A\A]A^A_H|$1   =]  H$   H$P  HHD$0DHǄ$P      HǄ$X      HǄ$@      H$`  H$`  ҃HǄ$H      H$   H$  H$   Ǆ$     HǄ$h     HǄ$     H$   HǄ$(     H$@  H$   D$%4  $  f$B  $  f$@  ,  H$P  H*  H$
  Hƺ   ?H$@  $B  fHz*     8_@ 1ID$R  H$
  HDfAMAο   1  =>\   $  HcT$Ht$0   -LcL5[  I  ;D$(  =[   H$P  $R  fH)  H=[  HDDþ]@ 1H=[  HT$0L<     H$P  D$R  fAHr)  1Hú   ^@ AHHڿ   1  
J  Hp  o   &  A  fAH   M   uKH$  H$  DǄ$       M   $  1fL@*  ILL$  (     Hþ]@ 1HHƿ    1  I  HD$oHt$I}      I}$  fL(     Hþ_@ 1HHڿ    1
     DDDǄ$     #  AH$  LA  Pc  t$  f  BI}$  f'  1Hú   ]@ HH1     =mY   5Dm1   ^@ DHƿ  1  O`@   ]@ ]@ =H$0    1iAG\$$4  AGA  HcH߉$<  H$D  H$  H$L  H$  H$T  H$  H$\  H$   $B  f$z  ff$x  $R  f$  ff$  H$`  HHI  I  H/  H$0  A1DA``@    ]@ ]@ ,^@    ``@   ]@ <^@ D  Ld$H\$IHl$Ll$Lt$H   H  GtI   +A,$H$   H$   L$   L$   L$   H   Ëp    Hp  DJ  E1Dw   H     LED#    1HD  H    HHuH$   HcAHA?E1AHDLMIcƍ}H$      1H1HǄ$       H	HHy    HDǄ$      H  H$   L$         *  $   y  $   ~H$      }k     yA$$   Qtn8HÃ<  8`@ H¿  1	  HI$L  I$  #  1Hú   v^@ HHƿ   1  HÉ   n   b8Hh_@   1}  ;8`@ H¿  1W  p`@   ]@ ]@ |`@ a  ]@ _@ `@ j  ]@ R^@ `@ t  ]@ m^@ @HL=T  MtCH=9T  1Ht.11A tD  ) uHH9tH։Hù`@    `@ `@ ,@ HL
S  M   pHS  HH9   f   ։AfAtFHcDA<udAfD9uTuMfD9tE։уufHcAt,D1xDu09u1҉Hfw΍AIHufvѹa@ a   `@ `@ a@ `   `@ `@ f.     HH5R  Ht-HR  HH9s3f0Hù0a@ Q   `@ `@ 0a@ R   `@ `@          HH=R  HtFHR  HH9sLȃf@H8t   Hø    Hù@a@ C   `@ `@ @a@ D   `@ `@ fD  USHEH=Q   tW1xE%*H*YZY-  ,؃t1nu1
H[]ù`@    `@ `@ cD  fD  HH=P      t
HfD  G1ҨH<HH=P  t1t1HHP  tHP  1H5   HÐ   HP      HÐHPa@ Va@ 11   a@ HH1fD  fD  S   Hc@ 1Pa@ H1   ra@ 1sH1y   1c@ XHH1[   1 d@ :HH1=   1Hd@ HH1
      d@ 1H1   d@ 1H1   f@ 1H11   (h@ H1   h@ 1H1
      j@ 1cH1i[
   ^fD  UHSHHtaHHtYHfHHDA uHڄu HU HH[]    HtHDA t HHE a@ Ha@ []fD      Hl$Ld$   L|$H\$ILl$Lt$HX  HH|$a@ 1HtH=M  H¾a@ 1H=M  bHM  H|$   M     H$  c1   HIH.|$ I$   L$  M   A   LH1; upHEAH; tA~IcLH2HL$AUIH$(  H$0  L$8  L$@  L$H  L$P  HX  @ HfD  
   ^fD  DD  fD  H'  j@ v6IS㥛 fD  9TtH  HHIHH'  wD1HѺa@ f     H\$Ld$DLl$Hl$Lt$H  H$0  H$8  H    c8@ L$@  L$H  H)H$  )x)p)h)`)X)P)H)@=K   L-K  u@ S  tK     DALE-K  
A@   H$   H$   HH   Ǆ$      H$  H$   Ǆ$  0   H$  0=   ty      D  A   Af   H$  H$  L$  L$  L$  H  ú   HƄ$   0=   u   a@ 1!DHH1a@ LAp  $a    =J   E=   t2=   )   a@ @H⾟a@ L1O   a@ c   Qf     AW    AAVAUATUSH   HI  Lt$@LL|$@ u  @ H{ HkuL%I  MuHI      HH<$ u
   D  H{ HkuL%dI  Mur1   Xj@ AHHL1 HĈ   []A\A]A^A_HH DPjLa@     H1NXHH DPwLa@     H1o[j@    a@ a@ j@    a@ a@ AWAVIAUE1ATUSHhHH|$H$D$^    L|$1'IcAD>.H@u	AE  IAtZL9tnAAt1H$La@ \ 1HIōC<^wIcA\>먉a@ L1bHN,8fH|$1Lna@ L9uHl$LڃtFHcHD> AE     Iu	AE  IuH|$H1na@ ڃuH|$Hh1[]A\A]A^A_ÐH=eG   t=F   UG  u'H1   j@    H1ɿ   Jf=F   uG  ÿ   D  ATSHHH         ;1A%;~1   1   HF  /   HHpHHٺj@ j@ HDE11   D8L%F  Hú   j@ 1HHL[A\Hƿ  1v@ l   j@ j@ G         H=E   t=E   E  u'H1   k@ %   H1>ɀ=E   u1   
    fD  AWL   AVAUATUSH  L$  |$,Ht$ 1H$  L$  LH$ 
  1x  H$  1x  H$  1  H$   1  wH|$0  1fa@    Ǆ$     Ǆ$     k@ 'k@ 'k@ H{_1H޿   Ǆ$(      HǄ$  `>@ )1H޿   HǄ$  <@ 1H޿
   HǄ$  @=@ 1H޿
   HǄ$     1H޿   |$,  fD  Ht$ |$,Mเs@ l@ Ǆ$        zw$Šo@  HD$ 1   @n@ H   H1H%듋
C    =C   l  H=1C  :   HHt} H@  hm@ 1     H1H$   H5B  Hǈ  &  .  H$   1HHL      B  B     $  B  $  H$   H5uB  1H   7  HXB     m@   H$   H5:B  H  iH"B     n@   iB  G1sLB  /AB  #H=SB   t l@ 1   p  H1H=A  HB  HD$ H81kA     \A     A  H=\A  11
   A  H9A     `k@    A  ^=kA  	  iA  EH=@  QPA  H[A  &H5@  1L  
H@     Ik@ 9A  H5@  H$ 
    H@     m@ 1"HHƿ  185@  d  @     @  zH=3@  11
   }@  WH@     .k@ @ =X@   t*H=g@   t hn@ 1     H1  =@   b  =
@   B  H=@  H}  vk@ HH?  ^  
i?  ;L$,q  =?    =?   &  7?  H$  H$ 
  x  H$  ?  $  UH$  H$  H$  H$  H   Hǈ  H$
  H$  HBH$  HBH$  HBH$  HB H$  HB(H$  HB0H$  HB8H$  HB@$  BHx  H$  F  >  3     H$      H$   H$  E11BH  D[]A\A]A^A_E  H 1   m@   H1w1   @m@ c  H1|o1   m@ >  H1W==c=  H  D  8A   FH$   H$   HHL  Hǈ    HH¾j@    1
=  ;L$,H=  HL=  HD$ HcH$  HЍA<  H)  c  
<  ;L$,QHT$ HcL<A<  L-   HIHH   E  1A}  uk} LuA     A}  u
A> [  D9f   NA9}L[Ht$ H|$,L$  OH$@  1L    } $  LuA  sH$@  1L    D$  K:   LHHH$@  1LV    $     |.11   n@    H1y10;   H=;   t-    o@ 1    H1H$  5Ht$0H$  A   1   m@ _HHƿ  1uH:  1   m@ 0HHƿ  1F$ 
  :       C D$\  ,  H$   H$   Dl$E1A   HH   HD$H$   H  HD$H$   HL  H$a  D9  H|$H$ 
  x  $  ":  $  H$  H$  x  H$   H$  HEH$  HEH$  HEH$  HE H$  HE(H$  HE0H$  HE8H$  HE@$  EHH|$UH<$1A  H$      =O9      H=Z9   t-    o@ 1w    H1H$   Ht$0H$   a=8   -  E1An=8   AD   E1AZ뿃$    |$       L8H4$H|$I  LH¾j@ 1iLZ    o@ 1   HL1   ==8   t@O8n  81Hú   k@ ;HHƿ   1Q    1   xk@ HHƿ  1v1   @m@   H181Hú   n@ HHƿ  1k   Po@ 1A   Hƿ  1HD$ 1   k@ HN1H1HgHD$ 1   @n@ H&   H1H<E1Fv@ =  j@ xo@ v@   j@ k@ v@   j@ k@ A   1zAW1AVAAUATUSH   ID  I    HHuMcEIA? J   HcH=6      >6  H'6     DA^HH	J
8ubE1` LEH11҉xJDHtH11DHĈ   []A\A]A^A_t=5       D|v@ Q   w5    n   fD  S1HLx^HA   
      $   D$    x>HL$A         D$   xH[ÐH[É߻_D  H\$Hl$Ld$Ll$H8tHl$ H\$Ld$(Ll$0H8 HH$    HD$    f$ fT$tD$      x   HAx   7yA7HD xDDe T@x@   v@ v@ f     H\$Ll$DHl$Ld$HHHMR  tH\$(Hl$0Ld$8Ll$@HH@ HD$    HD$    fD$ fL$D$xM   H$    HD$    f$ f\$      H   11    xY   1	xBHt$   %8sHAu$ftfD  XAHÉD#x@DD#AE D$HAHʹ`x@ fv@ v@ W`x@   v@ v@ >fD  H   `    !f     HH   xLd$H\$IHl$HH   H   `     ?    L   Hv@ _  @` 1HH@` ` IL$@1Hk@ HH)A<$ tHcLv@ H1H)HH$Hl$@` Ld$Hùzx@   v@ v@ .fD  H   k@ _  @` 1[HH@` ]D     v@ 1_  H¿@` 1#HH@` %fD      H\$Ld$踃l@ Ll$Lt$Al@ Hl$H8=/  HAԺL   ILE1谿H   ; u 1H\$Hl$Ld$ Ll$(Lt$0H8Ht$1ɺ
   H^HHD$8 uHBH=  w1LPH9uHL3HHtH0@   LKCfAEJffAEHHfE\fEeHDLffA}JHHtAEJ;Au4H1@   LAMHI}@]@    1趾   x@    v@ 0w@ CD  fD  H\$Ld$HHl$Ll$ILt$L|$HX  Ht> ux@ /   v@ w@ fH$  1x  HH  =.   t:1H$(  H$0  L$8  L$@  L$H  L$P  HX  HHHt   HLHEH HtQ1A    I`  HJ#      HHEIUJHtALI뷀=-     A$`     M$   I$`  E1D$ MIHL̽   |$ g  UAWIHII         H\HtHHu1   Pw@ nLHƿ  1뒋$  M$   HM$`  A$`     HLs=,         6@ H|$   HFH|$Ƅ$   dHILPMM  E1!ODAQMIi     HLu1   w@ 聾LD$HLL   1   HL袾D$      HHK  H0   LmL蕻HH   LPE1MM      LLODAQMIuк    x@ 1贽LHƿ  1HCH8>   Hþw@ 1肽IHMLL   1   1Lx   x5+  ,% I1   xw@ $LHHڿ  17B1   w@ LHƿ  1{   Pw@ 1ѼHHƿ   1   AWL  AVIAUE1ATUSH  L     1HcB tK,     =,  AHc` $,  tx ,  <wj$Ÿx@ ~[$D$+  A>H   D$蹼E+      ~'{D)D))HcD)HcHcLLE1b9AD)A/H[]A\A]A^A_Ã~$D${AD)HB 념AUATUHSHVHID(t.E ~1ۋ|x襸CH9E }HE,$H[]A\A]f.     HW(HuHvH H@ tHyt6HHvHLHHHAL9wHHHHI9s먋AF1Ð        Ld$Ll$L%#  Lt$L|$IH\$Hl$H8AI9H#  I)IMt1HÐHLLDHI9uH\$Hl$Ld$Ll$ Lt$(L|$0H8ÐUHS ` HH;#  HtD  HHHuH[ÐHOH                        core.c nc_main && nc_slave fd_sock >= 0 fd_stdin >= 0 select(core_readwrite) read(stdin) write(net) Sent %u bytes to the socket
 read(net) write(stdout) Received %d bytes from %s:%d
 ncsock Listening on %s Connection from %s:%hu ncsock->local_port.num != 0 Received packet from %s:%d write_u(stdout) write_ret == recv_ret get_len == sizeof(get_ret) ret == 0 %s open   (write_ret > 0) && (write_ret <= data_len)      Received %d bytes from the socket
      Couldn't setup listening socket (err=%d)        Unwanted connection from %s:%hu (refused)       Received packet from %s:%d -> %s:%d (local)     Couldn't create connection (err=%d): %s ((((&outs)->__fds_bits)[((sock) / (8 * sizeof (__fd_mask)))] & ((__fd_mask) 1 << ((sock) % (8 * sizeof (__fd_mask))))) != 0)    Critical system request failed: %s              core_readwrite core_listen      core_udp_listen core_connect    core_tcp_connect flagset.c flagset port < (flagset_len * 8)            >        netcat_flag_rand                netcat_flag_count               netcat_flag_next                netcat_flag_get netcat_flag_set 0.7.1 netcat (The GNU Netcat) %s
 Basic usages:
 Cmd line: %s  %lu%c Error: %s %s%c Warning: Notice: misc.c str_recv[0]  (%lu) str_sent[0] %08X   %02hhX        Copyright (C) 2002 - 2003  Giovanni Giacobbi

This program comes with NO WARRANTY, to the extent permitted by law.
You may redistribute copies of this program under the terms of
the GNU General Public License.
For more information about these matters, see the file named COPYING.

Original idea and design by Avian Research <hobbit@avian.org>,
Written by Giovanni Giacobbi <giovanni@giacobbi.net>.
  GNU netcat %s, a rewrite of the famous networking tool.
        connect to somewhere:  %s [options] hostname port [port] ...
   listen for inbound:    %s -l -p port [options] [hostname] [port] ...
   tunnel to somewhere:   %s -L hostname:port -p port [options]
   Mandatory arguments to long options are mandatory for short options too.
       Options:
  -c, --close                close connection on EOF from stdin
  -e, --exec=PROGRAM         program to exec after connect
  -g, --gateway=LIST         source-routing hop point[s], up to 8
  -G, --pointer=NUM          source-routing pointer: 4, 8, 12, ...
  -h, --help                 display this help and exit
  -i, --interval=SECS        delay interval for lines sent, ports scanned
  -l, --listen               listen mode, for inbound connects
        -L, --tunnel=ADDRESS:PORT  forward local port to remote address
  -n, --dont-resolve         numeric-only IP addresses, no DNS
  -o, --output=FILE          output hexdump traffic to FILE (implies -x)
  -p, --local-port=NUM       local port number
  -r, --randomize            randomize local and remote ports
  -s, --source=ADDRESS       local source address (ip or hostname)
        -t, --tcp                  TCP mode (default)
  -T, --telnet               answer using TELNET negotiation
     -u, --udp                  UDP mode
  -v, --verbose              verbose (use twice to be more verbose)
  -V, --version              output version information and exit
  -x, --hexdump              hexdump incoming and outgoing traffic
  -w, --wait=SECS            timeout for connects and final net reads
  -z, --zero                 zero-I/O mode (used for scanning)
     Remote port number can also be specified as range.  Example: '1-1024'
  Total received bytes: %s
Total sent bytes: %s
           kMGT           netcat_printstats Terminated. netcat.c ncsock && (ncsock->fd >= 0) -c /bin/sh Couldn't execute %s: %s Exiting. /usr/local/share/locale netcat Invalid interval time "%s" Invalid local port: %s Invalid wait-time: %s w Couldn't resolve host "%s" Listen mode failed: %s netcat_mode == NETCAT_TUNNEL opt_proto != NETCAT_PROTO_UDP %s: missing hostname argument close debug exec gateway pointer help interval listen tunnel dont-resolve output local-port tunnel-port randomize tunnel-source tcp telnet udp verbose version hexdump wait zero     cde:g:G:hi:lL:no:p:P:rs:S:tTuvVxw:z     Cannot specify `-e' option double       You can specify mode flags (`-l' and `-L') only once    `-L' and `-z' options are incompatible  Invalid target string for `-L' option   Couldn't resolve tunnel target host: %s Invalid tunnel target port: %s  Invalid tunnel connect port: %s Couldn't resolve local host: %s Couldn't resolve tunnel local host: %s  Try `%s --help' for more information.   `-e' and `-z' options are incompatible  Debugging support not compiled, option `-d' discarded. Using maximum verbosity. Failed to open output file: %s  Invalid port specification: %s  Passing control to the specified program        No ports specified for connection       connect_sock.proto != NETCAT_PROTO_UDP  @@     B@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     P@@     @@     @@     @@     @@     @@     @@     @@     @@     A@     @@     @@     A@     A@     @@     	B@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     @@     B@     !B@     -B@     @@     P@@     oB@     C@     @@     @@     C@     @@     C@     C@     *C@     @@     VC@     bC@     B@     B@     B@     B@     B@     @@     B@             l@                     c       	l@                     d       l@                    e       l@                    g       l@                    G       $l@                     h       )l@                    i       2l@                     l       9l@                    L       @l@                     n       Ml@                    o       Tl@                    p       _l@                    P       kl@                     r       |l@                    s       ul@                    S       l@                     t       l@                     T       l@                     u       l@                     v       l@                     V       l@                     x       l@                    w       l@                     z                                       main ncexec select(sock_accept) network.c tmpret >= 0 addr host && port %s [%s] any address  (%s) name && name[0]   %s -> %s  BUT  %s -> %s     dst->netnum == servent->s_port  Inverse name lookup failed for `%s'     This host's reverse DNS doesn't match! %s -- %s Real hostname for %s [%s] is %s Host %s isn't authoritative! (direct lookup failed)     Host %s isn't authoritative! (direct lookup mismatch)           netcat_socket_new_listen        netcat_socket_new_connect netcat_strid netcat_getport           netcat_resolvehost      Z@     Z@     Z@     Z@     Z@     Z@     Z@     Z@     Z@     Z@     Z@     Z@     Z@     [@     [@     )[@     ;4  %   P      x  ȶ   8  h0  H  x`      غ  8  ȼ  H  (  H  x      (  (     X      x  (  H  X   @  (`      h    0             zR x  4      @ J
   BBB E(D0A8G        T    #@     TG0     4   t   #@    BEB B(A0A8G           ,@ O   JY       0@ l    D          p0@ &   D          1@ q    D          2@     D       ,  2@     AAD      L  @3@     D       d  3@ 4    D       |  4@ Z   A       p5@     ADD   $      6@ u   YT            7@ W                7@ W   J\4     @:@ p   BJB B(A0A8G     4   L  ;@ 9   BBE E(A0A8D          <@ N    D         @=@                 `=@     BAG        `>@ j    D    4     >@ >   BGB B(A0A8G      4   $  N@    BDE B(A0C8G        \  0O@     AF           |  O@     JS@        P@    JQP        `R@                 R@                 R@ C   JL           S@ u   YO@ $   ,  `U@    Ja      4   T  Z@ +   BIE E(A0A8DP      $     @[@ V    BBA D(D0     [@ j                  zR x                   $   4       JQQ@                                                                                                                                                                   @     
       \@     o    @@            h	@            x@     
                                                 `            H                           H
@            @                   	              o    @     o           o    @                                                                                                             (`                     @     @     @     @     @     @     @     .@     >@     N@     ^@     n@     ~@     @     @     @     @     @     @     @     @     @     @     .@     >@     N@     ^@     n@     ~@     @     @     @     @     @     @     @     @     @     @     .@     >@     N@     ^@     n@     ~@     @     @     @     @     @     @     @     @     @     @     .@     >@     N@     ^@     n@     ~@     @     @     @     @     @     @               GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  GCC: (GNU) 4.1.2 20080704 (Red Hat 4.1.2-50)  .symtab .strtab .shstrtab .interp .note.ABI-tag .gnu.hash .dynsym .dynstr .gnu.version .gnu.version_r .rela.dyn .rela.plt .init .text .fini .rodata .eh_frame_hdr .eh_frame .ctors .dtors .jcr .dynamic .got .got.plt .data .bss .comment                                                                                @                                          #             @                                          1   o       @@     @      8                             ;             x@     x                                C             h	@     h	                                   K   o       @                                       X   o       @           0                            g             @                                       q             H
@     H
      H                          {             @                                         v             @           @                                         @           D                                          \@     \                                                  ]@      ]      8                                           8y@     8y      4                                          pz@     pz      $                                           `                                                       `                                                       `                                                       (`     (                                              `                                                     `           0                                         `                                                       `                                                                     (                                                   $                                                          P               N                 	                      آ      t
                                                          @                   `                  `             -      `             :     (`            H     0`            W     @@             m     @             y     `                  @                   `                  \@                  @`@                  #@                 O`@                 ``@                p`@     
       +    `@            D    H`            L    P`            X    `@            q    a@                 0a@                @a@                `@                j@                <@     N           @=@                `=@                v@                `>@     j           s@            !    v@            :    `            F    `            X    @x@            q    `x@                `                @`     _          zx@     
            x@                x@                `                `                 `                  `             
   `                   `             4     `             G     `             X     `             k   (`                    @                   @                   @@                   x@                   h	@                   @                   @                   @                  	 H
@                  
 @                   @                   @                  
 \@                    ]@                   8y@                   pz@                    `                   `                    `                   (`                   `                   `                   `                    `                                   t     `                 m`                l`                @[@     V           7@     W                   %           c`                                                   	    \@                                /             %       E    @             L                   c             l       v                                                                                                                                                           %       !                    3             !      N             :       f                       
 \@                 `                                                                                   $                   
                              0O@            #             %       4    P@           N    `            ]    `U@           p    R@     C      }             (           1@     q                    l                              ,@     O          `                 ]@                2@                         T                          ,    a`            7    p0@     &      H     `            \    `             i    @     J
      x             l          k`                7@     W            0@     l                    %                    7                               `                                6    [@     j       O             =       d    R@            u    #@               @3@                         9                               ;@     9                            ]@                          (       	   `             	             %       .	     \@            >	                    S	    `            g	    O@            	    `            	     2@            	             e      	    j`            	    X`            	             t      	                   	                    
             %       
                    1
    i`            ;
    @`            F
    n`            R
                    p
    p`            }
   `             
                    
    S@     u      
    x`            
    h`            
    b`            
    d`            
     6@     u      
    N@           
    p5@                8`            )             .      D                   X    `R@            i   `             n                        @:@     p                   p                               3@     4           `                Z@     +          4@     Z          `                         1       4             %       F             u      [                   r    t`            ~             U         `                                     o`                                                                 
                          
    ``            
     `            (
                    :
    >@     >      ?
   
 @             E
                    Y
             0       call_gmon_start __CTOR_LIST__ __DTOR_LIST__ __JCR_LIST__ dtor_idx.6147 completed.6145 __do_global_dtors_aux frame_dummy __CTOR_END__ __FRAME_END__ __JCR_END__ __do_global_ctors_aux __PRETTY_FUNCTION__.4871 core_udp_connect __PRETTY_FUNCTION__.4851 __PRETTY_FUNCTION__.4500 __PRETTY_FUNCTION__.4843 __PRETTY_FUNCTION__.4702 flagset flagset_len __PRETTY_FUNCTION__.4555 __PRETTY_FUNCTION__.4521 __PRETTY_FUNCTION__.4481 __PRETTY_FUNCTION__.4579 __PRETTY_FUNCTION__.4548 got_term got_usr1 ncexec __PRETTY_FUNCTION__.4970 got_int long_options.4998 __PRETTY_FUNCTION__.5052 timest.5046 timeout_init.5045 __PRETTY_FUNCTION__.5030 __PRETTY_FUNCTION__.4997 my_buf.4969 buf.4923 __PRETTY_FUNCTION__.4925 __PRETTY_FUNCTION__.4775 l.4464 getrq.4463 __preinit_array_start __fini_array_end _GLOBAL_OFFSET_TABLE_ __preinit_array_end __fini_array_start __init_array_end __init_array_start _DYNAMIC data_start opt_telnet opt_udpmode udphelper_sockets_close ncprint dup2@@GLIBC_2.2.5 commandline_need_newline printf@@GLIBC_2.2.5 memset@@GLIBC_2.2.5 __libc_csu_fini snprintf@@GLIBC_2.2.5 shutdown@@GLIBC_2.2.5 _start inet_pton@@GLIBC_2.2.5 close@@GLIBC_2.2.5 abort@@GLIBC_2.2.5 gethostbyname@@GLIBC_2.2.5 __gmon_start__ _Jv_RegisterClasses recvmsg@@GLIBC_2.2.5 textdomain@@GLIBC_2.2.5 select@@GLIBC_2.2.5 getpeername@@GLIBC_2.2.5 exit@@GLIBC_2.2.5 __assert_fail@@GLIBC_2.2.5 strcasecmp@@GLIBC_2.2.5 bindtextdomain@@GLIBC_2.2.5 _fini opt_exec putchar@@GLIBC_2.2.5 execl@@GLIBC_2.2.5 read@@GLIBC_2.2.5 malloc@@GLIBC_2.2.5 fopen@@GLIBC_2.2.5 __libc_start_main@@GLIBC_2.2.5 netcat_socket_new dup@@GLIBC_2.2.5 netcat_socket_new_connect opt_outputfile netcat_resolvehost netcat_strid setsockopt@@GLIBC_2.2.5 netcat_flag_get srandom@@GLIBC_2.2.5 fgets@@GLIBC_2.2.5 core_connect use_stdin _IO_stdin_used netcat_flag_rand __strdup@@GLIBC_2.2.5 free@@GLIBC_2.2.5 got_sigint netcat_flag_next optind@@GLIBC_2.2.5 __data_start core_readwrite gethostbyaddr@@GLIBC_2.2.5 opt_random netcat_snprintnum netcat_flag_count listen@@GLIBC_2.2.5 __ctype_b_loc@@GLIBC_2.3 sprintf@@GLIBC_2.2.5 stdin@@GLIBC_2.2.5 __strtol_internal@@GLIBC_2.2.5 udphelper_ancillary_read strrchr@@GLIBC_2.2.5 netcat_inet_pton core_listen netcat_flag_init usleep@@GLIBC_2.2.5 strerror@@GLIBC_2.2.5 netcat_fhexdump sigaction@@GLIBC_2.2.5 __dso_handle getsockopt@@GLIBC_2.2.5 __DTOR_END__ getsockname@@GLIBC_2.2.5 __libc_csu_init connect@@GLIBC_2.2.5 optarg@@GLIBC_2.2.5 netcat_socket_new_listen opt_proto netcat_flag_set memcpy@@GLIBC_2.2.5 opt_numeric output_fp memmove@@GLIBC_2.2.5 strchr@@GLIBC_2.2.5 getopt_long@@GLIBC_2.2.5 socket@@GLIBC_2.2.5 vsnprintf@@GLIBC_2.2.5 opt_debug bytes_recv opt_hexdump __errno_location@@GLIBC_2.2.5 opt_interval __bss_start dcgettext@@GLIBC_2.2.5 netcat_getport opt_wait opt_eofclose got_sigusr1 netcat_mode netcat_commandline_read netcat_socket_accept netcat_string_split bytes_sent getservbyport@@GLIBC_2.2.5 calloc@@GLIBC_2.2.5 netcat_inet_ntop _end recvfrom@@GLIBC_2.2.5 netcat_printstats random@@GLIBC_2.2.5 strncpy@@GLIBC_2.2.5 netcat_printversion signal_handler netcat_telnet_parse netcat_printhelp stderr@@GLIBC_2.2.5 sigemptyset@@GLIBC_2.2.5 bind@@GLIBC_2.2.5 realloc@@GLIBC_2.2.5 setlocale@@GLIBC_2.2.5 opt_verbose perror@@GLIBC_2.2.5 _edata fprintf@@GLIBC_2.2.5 opt_zero write@@GLIBC_2.2.5 accept@@GLIBC_2.2.5 inet_ntop@@GLIBC_2.2.5 fcntl@@GLIBC_2.2.5 got_sigterm stdout@@GLIBC_2.2.5 time@@GLIBC_2.2.5 main _init fflush@@GLIBC_2.2.5 getservbyname@@GLIBC_2.2.5                                                                                                                                                                                                                                                                                                                                                                                                                                                     pre_diag/error_level.txt                                                                            0000755 0000000 0000000 00000000015 12667754516 014431  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   error_level=0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   pre_diag/tools32/                                                                                   0000755 0000000 0000000 00000000000 12667754516 012656  5                                                                                                    ustar   root                            root                                                                                                                                                                                                                   pre_diag/tools32/curl                                                                               0000755 0000000 0000000 00001233215 12667754516 013560  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   ELF              4        4    (      4   44                                                    5	 5	  <            5	5	               (  ((              PtdH H#	H#	<   <         /lib/ld-linux.so.2           GNU                                O   Y          r                     1   x      0                   7           R         u                 N   8   p                       }                               s   o      @                          5               
                      ]                     6                                                                                               +                C                           3              F                 n   j                                                w                L   S   "              k       |   '                               K       
                                      h   [                 a                                                                                                                                                                                                       &           )   #                                       (                           ;                  A                                          4                       H   G           P   -   2                                              =   \   /       !              ,       %       Q          y       V           M           z   <                  B               v   ^   c                 .   g                      I               T   m   D              9   ~   >       _       J           l       	               E             $      W       i                                              {                                   *                              `       d               q               :   X         t   b                    e          f                    Z       ?   U                   v  8      p  аx     
  :                                F     ?  0S      |
  @g       P        `D         p         N       |      '   0      1         s
          б        =      >   5	     #  W                q      
           0        @.      0  Pd      
  `     G   pX       8                     f  8        z        вZ      ;  x      L
  2         Q      U            q      
  0=        @      
  P     \   `        p      ^        e         n        v   i     '           г|     (                
          _        $     2  00         @      F  P=      V  `         p7      ,
  9      
          6                          дx              %
  :      >        j          I        0      
  @y             
 1  P9      4  `     K  pM      g                 6      r  <        a        е
      I       
  X         x                        0M       @9        P.        `     
  :	       :	     *  pc              6  %        5                9        ж        <      
                 M  E                0       @"      k  P@      e  `        p      	  S       =      m                  +     
  зF               G      )   4              5   5      
  0        @?       P
      P  `
      
  p     ^  P      j        
          H                 и             t
        1                            0      G  @D        P        `5        p      O                 K     R        
  :	               й@      b
        i  5        R               D        0       @k        P9      	  P     
 
  `s      "  p'              
        v                       
  к9             !  W         G        
      	   U      	  00      2	  @
      
  P5        `>      Y  p:      w  ^                              H	  =        л             B
  J      =
         3                  0     8  @4      
  :	     J  PP     f  6	     -	  `      
  \=	     |  p      q  x      Q	          )      e	          q      
  м:      )  5             p   C      u	        	   O        0>      	  @      e  P       `x        :	       p&        
             
  k                     K  н     S
         x      *        8                 	   7      
  0x      H  @        P4      
  `q     -  p      R  &      	  u      D  9      f                q      x         	  о     
  D     ;  &      	   i      S  k      	        }  0      i   @|        P6      	  `      
  p     z        
  C      
  &              	                     
  п0       libldap.so.2 ldap_get_dn SSL_CTX_free X509_free SSL_shutdown _DYNAMIC SSL_get_error sk_num ber_free SSL_read SSL_new SSL_CTX_new SSL_library_init ldap_get_values_len ldap_first_entry SSL_CTX_load_verify_locations ldap_unbind_s SSL_pending SSL_CTX_set_verify ldap_simple_bind_s ldap_next_attribute CRYPTO_free SSL_load_error_strings SSL_CTX_set_cipher_list BIO_new ldap_free_urldesc sk_value X509_get_subject_name ERR_error_string ldap_search_s X509_STORE_CTX_get_current_cert ldap_set_option EVP_cleanup ldap_err2string _fini ASN1_STRING_data ASN1_STRING_length SSL_get_current_cipher SSL_CTX_use_PrivateKey_file _GLOBAL_OFFSET_TABLE_ SSL_CTX_check_private_key ERR_free_strings ldap_url_parse SSL_CTX_use_certificate_file SSL_connect ldap_memfree X509_get_issuer_name SSL_free ldap_first_attribute SSL_get_peer_certificate ldap_next_entry ldap_init ldap_value_free_len _Jv_RegisterClasses SSL_write ldap_msgfree __gmon_start__ libssl.so.4 SSL_CTX_use_certificate SSL_set_fd SSL_set_connect_state SSL_CTX_callback_ctrl BN_bn2bin RAND_add SSL_peek SSL_get_shutdown SSL_CTX_set_default_passwd_cb X509_get_pubkey TLSv1_client_method X509_verify_cert_error_string BN_num_bits SSL_get_privatekey BIO_free BIO_ctrl SSL_SESSION_free SSL_get_certificate SSL_CIPHER_get_name SSLv23_client_method EVP_PKEY_copy_parameters SSL_get1_session SSL_CTX_add_client_CA RAND_bytes SSL_CTX_use_PrivateKey SSL_CTX_ctrl ASN1_INTEGER_get ERR_get_error SSL_CTX_use_certificate_chain_file SSLv3_client_method SSLv2_client_method SSL_set_session SSL_CTX_set_default_passwd_cb_userdata SSL_get_verify_result CRYPTO_malloc SSL_get_peer_cert_chain EVP_PKEY_free libcrypto.so.4 RAND_load_file X509_load_crl_file ENGINE_load_private_key ENGINE_get_first ENGINE_finish ERR_error_string_n ENGINE_set_default ENGINE_free DES_set_odd_parity inflate ERR_remove_state UI_OpenSSL PKCS12_free PKCS12_parse ENGINE_load_builtin_engines MD4_Update inflateInit_ X509_NAME_print_ex SSLeay RAND_egd ENGINE_init RAND_file_name i2t_ASN1_OBJECT ASN1_STRING_print MD4_Final MD5_Init X509_EXTENSION_get_critical X509_NAME_get_index_by_NID RAND_status CRYPTO_cleanup_all_ex_data ENGINE_get_id DES_set_key X509_EXTENSION_get_object MD5_Final ASN1_STRING_type X509_NAME_ENTRY_get_data ENGINE_get_next PKCS12_PBE_add ENGINE_by_id X509_get_ext_d2i X509_STORE_add_lookup X509_NAME_get_entry GENERAL_NAMES_free X509_get_serialNumber MD4_Init ASN1_STRING_to_UTF8 DES_ecb_encrypt BIO_s_mem PEM_read_X509 X509_STORE_set_flags d2i_PKCS12_fp inflateEnd X509V3_EXT_print PEM_write_bio_X509 MD5_Update X509_LOOKUP_file X509_check_issued libresolv.so.2 libgssapi_krb5.so.2 libkrb5.so.3 libk5crypto.so.3 libcom_err.so.3 libdl.so.2 libz.so.1 zlibVersion inflateInit2_ libc.so.6 strcpy stdout utime recv geteuid inet_pton __xpg_basename memmove __strtok_r getenv __rawmemchr __strtol_internal fgets __strtoll_internal memcpy isatty siglongjmp recvfrom socket __strtoul_internal fflush strncasecmp send freeaddrinfo gmtime_r alarm __sigsetjmp pipe accept strrchr __ctype_tolower_loc calloc strcat bind setsockopt fseek stdin strstr strncmp strncpy strcasecmp sendto realloc __strdup strtok listen sscanf sigaction fread __xstat64 gettimeofday localtime memset srand tcgetattr poll getpwuid gethostname sprintf fclose strerror_r setlocale gethostbyname_r stderr getifaddrs fputc __ctype_b_loc getsockopt freeifaddrs getaddrinfo fwrite access __errno_location exit inet_ntop fileno _IO_stdin_used __libc_start_main lseek64 strchr fputs fcntl tcsetattr mkdir __fxstat64 getsockname fopen64 ftruncate64 liblber.so.2 _edata __bss_start _end GLIBC_2.1.2 GLIBC_2.2 GLIBC_2.1 GLIBC_2.3 GLIBC_2.0                                                                                                                                                                                                                                                                                                                                                                                                                          
         ri	   
     ii
   
     ii
        ii
        ii
         :	  :	^  :	_  :	  6	  6	  6	  6	  6	   7	  7	  7	  7		  7	
  7	  7	  7	
   7	  $7	  (7	  ,7	  07	  47	  87	  <7	  @7	  D7	  H7	  L7	  P7	  T7	  X7	  \7	  `7	  d7	   h7	!  l7	"  p7	#  t7	$  x7	%  |7	&  7	'  7	(  7	)  7	*  7	+  7	,  7	-  7	.  7	/  7	0  7	1  7	2  7	3  7	4  7	5  7	6  7	7  7	8  7	9  7	:  7	;  7	<  7	=  7	>  7	?  7	@  7	A  7	B  7	C  7	D  7	E  7	F   8	G  8	H  8	I  8	J  8	L  8	M  8	N  8	O   8	P  $8	Q  (8	R  ,8	S  08	T  48	U  88	V  <8	W  @8	X  D8	Y  H8	Z  L8	[  P8	\  T8	]  X8	`  \8	a  `8	b  d8	c  h8	d  l8	e  p8	f  t8	g  x8	h  |8	i  8	j  8	k  8	l  8	m  8	n  8	o  8	p  8	q  8	r  8	s  8	t  8	u  8	v  8	w  8	x  8	y  8	z  8	{  8	|  8	}  8	~  8	  8	  8	  8	  8	  8	  8	  8	  8	  8	  8	   9	  9	  9	  9	  9	  9	  9	  9	   9	  $9	  (9	  ,9	  09	  49	  89	  <9	  @9	  D9	  H9	  L9	  P9	  T9	  X9	  \9	  `9	  d9	  h9	  l9	  p9	  t9	  x9	  |9	  9	  9	  9	  9	  9	  9	  9	  9	  9	  9	  9	  9	  9	  9	  9	  9	  9	  9	  9	  9	  9	  9	  9	  9	  9	  9	  9	  9	  9	  9	  9	  9	   :	  :	  :	  :	  :	  :	  :	  :	   :	  $:	  (:	  ,:	  0:	  4:	  8:	  <:	  @:	  D:	  H:	  L:	  P:	  T:	  X:	  \:	  `:	  d:	  h:	  l:	  p:	  t:	  x:	  |:	  :	  :	  :	  :	  :	  :	  :	  :	  :	  :	  :	  :	  :	  Ua      56	%6	    %6	h    %6	h   %6	h   %6	h   %6	h    % 7	h(   %7	h0   %7	h8   p%7	h@   `%7	hH   P%7	hP   @%7	hX   0%7	h`    % 7	hh   %$7	hp    %(7	hx   %,7	h   %07	h   %47	h   %87	h   %<7	h   %@7	h   %D7	h   %H7	h   p%L7	h   `%P7	h   P%T7	h   @%X7	h   0%\7	h    %`7	h   %d7	h    %h7	h   %l7	h   %p7	h  %t7	h  %x7	h  %|7	h   %7	h(  %7	h0  %7	h8  p%7	h@  `%7	hH  P%7	hP  @%7	hX  0%7	h`   %7	hh  %7	hp   %7	hx  %7	h  %7	h  %7	h  %7	h  %7	h  %7	h  %7	h  %7	h  p%7	h  `%7	h  P%7	h  @%7	h  0%7	h   %7	h  %7	h   %7	h  %7	h   %7	h  %7	h  %7	h  %7	h   % 8	h(  %8	h0  %8	h8  p%8	h@  `%8	hH  P%8	hP  @%8	hX  0%8	h`   % 8	hh  %$8	hp   %(8	hx  %,8	h  %08	h  %48	h  %88	h  %<8	h  %@8	h  %D8	h  %H8	h  p%L8	h  `%P8	h  P%T8	h  @%X8	h  0%\8	h   %`8	h  %d8	h   %h8	h  %l8	h   %p8	h  %t8	h  %x8	h  %|8	h   %8	h(  %8	h0  %8	h8  p%8	h@  `%8	hH  P%8	hP  @%8	hX  0%8	h`   %8	hh  %8	hp   %8	hx  %8	h  %8	h  %8	h  %8	h  %8	h  %8	h  %8	h  %8	h  p%8	h  `%8	h  P%8	h  @%8	h  0%8	h   %8	h  %8	h   %8	h  %8	h   %8	h  %8	h  %8	h  %8	h   % 9	h(  %9	h0  %9	h8  p%9	h@  `%9	hH  P%9	hP  @%9	hX  0%9	h`   % 9	hh  %$9	hp   %(9	hx  %,9	h  %09	h  %49	h  %89	h  %<9	h  %@9	h  %D9	h  %H9	h  p%L9	h  `%P9	h  P%T9	h  @%X9	h  0%\9	h   %`9	h  %d9	h   %h9	h  %l9	h   %p9	h  %t9	h  %x9	h  %|9	h   %9	h(  %9	h0  %9	h8  p%9	h@  `%9	hH  P%9	hP  @%9	hX  0%9	h`   %9	hh  %9	hp   %9	hx  %9	h  %9	h  %9	h  %9	h  %9	h  %9	h  %9	h  %9	h  p%9	h  `%9	h  P%9	h  @%9	h  0%9	h   %9	h  %9	h   %9	h  %9	h   %9	h  %9	h  %9	h  %9	h   % :	h(  %:	h0  %:	h8  p%:	h@  `%:	hH  P%:	hP  @%:	hX  0%:	h`   % :	hh  %$:	hp   %(:	hx  %,:	h  %0:	h  %4:	h  %8:	h  %<:	h  %@:	h  %D:	h  %H:	h  p%L:	h  `%P:	h  P%T:	h  @%X:	h  0%\:	h   %`:	h  %d:	h   %h:	h  %l:	h   %p:	h  %t:	h  %x:	h  %|:	h   %:	h(  %:	h0  %:	h8  p%:	h@  `%:	hH  P%:	hP  @%:	hX  0%:	h`   %:	hh  %:	hp   %:	hx  %:	h  %:	h  1^PTRhhȧQVh'USP    [v   tЋ]ÐU=:	 u)(5	t(5	ҡ(5	u:	ÉU6	t    th6	w?ÐUWVS  E    te[^_ÍEPuh   S萱  Ɖ~ՐE  j	jhuF~jE   ;fB%    fuEtKE   E  jCPW-XZE  j
+|;)ރQu뼃E  Wa1ؐUj苴  ÐU鋵  v UUMt9thu   Ív 1
UWVS}ut Vjjhv]SWV0  h V迲  e[^_Ív UV5 S1ۅt 4Cue[^Ív UVS]uu#tVe[^É    PωUVSE   t+C3uGCu0CuSu׍e[^ÃPىPsPc뫉UWVSjuI   t!1   ׅt     Be[^_Ív    UWVSj}uÃ1   EC    C
   ut&jt`@        CxË}t)jt3@    UC    PUtXE؍e[^_ÃSF1USP]t؋[P&u]ÉUS]ht3h5  [u]E]UWVSP  Rh]ESHth`u   e[^_Ãj=STt˃@P%   <@y  1ۀ c  hƨǄ      t)Bǅ        <t~jPjuuǄ   Ǆ   Ԁ   uk1hͨuZH    ujPjuFuǄ   Ǆ   H   pSVhu
Y   =1 zBǅ    ǅ    j;ǅ    UZYj,Dt9sÅǅ    	  1;,SH! O  ,   kfB%    ftFPjVhǨ  M  ShWhV  1Ή߹)΋D2x   p@   <,Sj,VHÅt CPP/   ۉt	; 1RFu   P   19sˋBDA9Rr   ijSjPjuu}   t.hͨu$n^b   SOMh  虫  X%_   hu/XX   V1s1HhuXXg   Pj	Vh蒫  	j;VOt	 Fj,-ubv j,hM  y  UE	w-$ ø+8CViٸ`Ҹ˸wUWVS  E1ǅ       v Wuh   S   j
SGt  j
S2t  1э|GPtSP{ut	   e[^_ËE1UWVSE11   tIv th9tdu)Pj>Pƃu9> tFPW#tǅtE0E81e[^_ÃWI1܉@xCPWtztW	   뭍v UWPUt1PIQj R}Ív UVS]1t fP%   fu   e[^j j
j SUUSPj j j uEPȉЁ	t5   	u
h8"t1]ø   UWVS  Utj:Pte[^_Vh   <j PM1߉$uhh   IS  h   PSel  ׹΋Y[D2PM1R:RVRDPRM(USu]3x  	   t1҉Ћ]ÐUS]Shn     tЋ]ÃShn     u߃Shln     uPSh u   믉US]Sh3n     tЋ]ÃShn     uPSh`us   UWVSu  EE]E   t
e[^1_ÃjEPj	jSY xk  t҃j}WjjS5 x2jWjjS y     hV     h˩     hΉUWVS   UǅP    ǅLƅK ƅJ ƅ8<-  <-$  $׊JLI4ǅ0    ֹ   u$ƅ8 1ǅ(    P4$(D认    F   (vŃ0     L      K w  P1ۅtP1E  L  LR<H t(K   Py   AMƅJÃ#W  $(E5  $EuPK ǅLu&J uPP8 tU: 1ҍe[^_Ê8UB*몊8MA+뙃Eu낃EuHPX   uhEu   L8}O*DEu   PM   w}Ǉ      hQۃE   uPU   tthRMǁ      j j dPu֋d: updB+w7$`}\  `  T  X  G

׃h u   _1Ivw8UB!8 tMI$}g$8 t!:	@ tEH$   Ub$8 t:	@t֋MI$u}g$i8 tEH$TUb$H8 ;MA$,v }   u      t_t#@tU   t>@uuu/ÃuCP[K1ƉM   빊8U
  MƁ	  EuL:	@8U
  KMƁ   <}?-u tchut4E    uU  Ƃ     Wuhu:	M  Eu`:	@"   Eu   yEuPP8UB+Z8U  E#W4$ 8}|  8}  8U  8M  Eu  PeMǁ     Eu  "8U  Eu   qEu   PMǁ      QEu  PUǂ     +UB\uMA\    PEu  P}Ǉ     8U  8}  8U  Eu  Eu   Eu  Eƀ  uPuU  E:	@ 8}  %Eu  	8U  8}   8U  8}  uu_U  EhPEdPhu   Ht"}Gh+GdGhdh	W#MAh   GE  uPEǀ     Eu  8U}  8M  8U~  }  8  Ǉ     Eu  v Mǁ      {}Ǉ0     iEǀ0     WUǂ0     EMǁ4     3}Ǉ4     !Eu8U   hu胚  t!}G)G,    G0    E@(Eu,P   MA) ɃEuXa.  $pEu   TEu   AEu   .Eu   Eu   PXuE   uPM   hP3a  }Ƈ   Eu   Eu   E   uPE   61Qv j:ut  @PE   PEu   <sPEH  PED  Puu EWP  Pju   A}Ƈ  Eu@  PU8   VP  P8@PR뙃uu>  DSuh`^8Et      8 L     08U  a   U   u         t#@tM   tf@uuuƃqot#8 F    t
NNOfuFPf1랋}   듊8}  Eu\M+t--tEu$  ?AEQ(  M*EEu,  8UB8}O|U   u      tqt#@tM   tR@uuu)JȃBE8 uJuB1벋}   맃]uÄ   SxXu^_ShB8 |  Y[Ph藔  :	P ud@hp  1ۃT:	PuCvh%C4hg)  ̃h&  :	X uh%:	d3hgړ  uɍv Eu   EutP   Epx@x      8U   dM9@t6j=utEu.EuAMEueǅ\      E8@   u\P{\Ep4uMY41҈щ ߹ы S>UB4t0\Vh2SPg  VX\K\	   q@PhǅX    E谒     5:	btbV\PÃt;5:	tVu*\jj9Ã\PVXP\PuËMXy8A<    넃huNPuhu(5j=uǅ`      +M,C<@   S\P\1I`R`S}7y  X\`b1򮋽,)W8ú	   ,t;Vu,h8WSO   Vc{  \[VSG҃Sh訐  tM5:	QV`P\Pt;5:	tVۉ\hSRuSuhux댃j@u]1ǅ,    ]Wh@ut}Ƈ     Eu@#Eƀ    ㊕8M   8M  8 M8U   8}O 8}  8U   EuDot8}   h8U   T8U   @>}Ӌ fP%   f   j-Wt]MypۋuuuWfB%   fu
-t,uFuŃh u밃huj j
j W$PhFj ]S|  }SpWEYv UzpK8 t%MƁ   Ɓ   8UB|$}Ƈ    Ƈ    كEuL  i]uSYuXZSh+8 u}Ǉ       E   hPDU   tth ReMǁ      mE8@tEu  I@PhE׌  t]5:	EV  Pt;5:	tV
ۉ5U  PVhKRh$uoƃ뒃Eu   PPMǁ       EuxPl   }GtoGt   cU-   -   +   Mǁ8     j Y[TTPu  U<  @RhPuj@tE}<  Mǁ8      h`QEs=jEǀ8     Eb}Ǉ8     v E   E '1@:t"F   vLv L⋽Pv $D0ƅKcR  u@PL(@PLǅ0   $<z-$BPUVSEҋMt"t\t@At"u [^Ð@ڃrt7rtكnt	@Aɾ
   ttvu   ߾	   ؾ
   ѐUWVS,  uǅ    t	UuBE]>O     1I    VdU<-u
Ex   h$u+ǅ    F  ;    ƅ t) fP%    ftFÃ/w$tY fP%    fu=t
:tFՄt. Ft" fP%    fu=t܀:t׀"   t fP%    fuF t? u    1uPWt? t u   tEU:-u
z uEet+PZYPuhmu  uxXWg܃WYGF1Q9tPVƅ	ǅ   ;:	tP5e[^_ǅ   :	h]hϱVhh   S߃  ] ]"Uuj j UWVS}GEGuuh7-GtOwuVu$u9Ɖt'E   ue[^_Ðw1GWωP7huu1ۃUuuuE0;!Ѓ@ÐUEEPuE0aH!ЃUWVSl  ٽffE٭߽٭E٭߽٭E٭߽٭EE$HX٭߽٭׋ߋ9|9vU   WVEH,$߭Q$٭۝٭1
9ݝ}Ƅ(#@9|Qhj(SƄ( [  XZPSh   S4  ShUr<  MqMAQe[^1_Åx	 MQҋA   É֋

ɋxd

9򉅐9q9ihEp荂   9=9w0      dUWVS]1   ߋu~( tF,V0SChİj  t-j j
j PC<$l    Ce[^_ÉCO   v UWVS$EEEEHЋU}@UEWWuuh̰u莁  E     9}rUUe[^_%Quhu[  }   1;usS9}sN]v }   PEB<_.   wQhu  }t5F;usE9ruj
EE9}iQC9sċE؀x
ux
u+uUTU뵐C9kE<
^|
S+uUTː1;uyE9s'RUPhuM  F;urv ujjhܐUWVSH}  EEPF  E]Puĉ]      E    z  EEX     t{}w!M$puEPhu  e[^1_øSu   uuuPEPҸڸ)Ӹ6̸CŸT뾍v 1}  U$}1O9sM<
ttC9r=,5	 tBu)jCPEP}1tMU|

t,5	-5	 /U4TEPheu~  란=,5	 t*u)j@PEPs,5	 \E4TEPheuY~  부=,5	 t0ujuuu1SUM|
?M4TEPheu ~  밀=-5	 V    tE;:	>;:	2=,5	 t#hku}  ,5	 -5	U4TEPheu}  뽉,5	 h}W*   h}  t:	   \T   h}  t  ˃h   }   Ƈ   묍v RV0pphjEPz   USP]C  Cr     P     .       C4                 Ch  CI     '  CX  C\  Cp           D  d     B                  C        y  C`Z    8                              C@us   uY$  KY  X,  ?Y  X(  3Y  X@  'Y  YL  Y  u]ÐE]l~  P7뙉P'|v Pav P?v Pv Pv Pv Pv Pv Pvv PsTv P_2v PKv P7v P#v Pv PM  v Piv PGv P%v Pv Pv Pv Pov P[v PGhv P3Fv P$v Pv Pv Pv PϿv P軿}v P觿^v USQUҋ]tPjSh@  t   Ћ]PjSh@  1҅tۍv UWVS  }'  ƅ v  /u  >  N  ]      Shh   P@u  ƅVSWu'z  ƋE  ts ıu%PP uѱu%Ph u   tP5:	T  u   tSa  e[^_ǅNULLƅ Ptf<Q Cf<A Cf<A ShSh   P6t  uV]Shձh   Pt   V]Sheh   Ps  UWVSu  :	ۉE   E ;-u
{    hSAEEE   E    t<v ޿      Pj@huku  EEuǋEt#WE0hu=u  E@Eu݃huu  } u:	Ee[^_XS  uݺPShqPSh V:	EUWVS     1ًuǅ    ǅ    ǅh    ƅ_ƅ^ ǅX    ǅP    w  T&  TP󫉖  j}\  :	XZh%jƅ St"h`     e[^_ÍF8F<F|Ɔ   Ɔ	   Pf:  p  xt  PB:  x|}d  h  FL2   ~)WjMqhs  uUB8-%  Vj }e%  ǅL   M9L}^_ tLU;-$  VPLM4h1P!  LE9L|  ($  H   HDtHu
    #  F#  ƅ^   u   u
   "  F4tU   "  P<XXv4蝹P  F4    P1    @PV訾d"  h75:	O  :	)"      !  FX   lt8-u
x !  l  l@ǅ0    8<R!  :	lBǅ    ǅ       lI   4u?t;~|      PP4P,  Pf   ǅ@    @u
4t4/   @   ǅh    h     ǅ`ǅd  ~|     PP<P0,  P  0ǅ,    th0\p  t~
ǅ,   ǅL    F  L  ǅ8    8  0ǅ(      0芵 l@u$ ts ho  uY   -  	     ~)    V0F,	9  ǅ    hƅ'   hh$o    h8ұ  j/S致t
C;    j/hd_  j\PH)  @Wj T"W  ty18ʋу)Qi3    8hBWam  [X  Y8%8j h<(@t RP(j   PhhU  1(t(o   ugǅP   8t8r t W' uL(P)  ǅ    끃P)  ǅ    \ƅ'`dht~) tF,F0h8
t  ~K    uB   R8PL@Phg  k  , =  X   h8ͮƅ?  j/P}tj?Pŧtƅ&18ʋXу)Q謫v  I  XP8hSj   8^8  u:	      Ph'  h|VThh+N  hVTSh'  hV(Tshh,N  hVTUSh'  hʲVT;hhN  h۲VT`  \  у 	  d`hu  hVT8h'  h	VT   h'  hVT    4     Pj+h#VTr       jj,h6VTJjj*hEVT2   Pj-hTVT1h Pj.hhVT   Pj0hwVT   Pj2hVT     ,        jj3hVT   Pj4hVTb   PjihVTD   Pj5hٳVT&   h'  hVT   h'  hVT   h'  hVTvph'  h#VTPh'  h1VTvDj
hEVTtP     ~  v@h '  hUVT=   Pj:heVTvh"'  hyVTv\h!'  hVTvtjhVTvxjhVTX  T  hu  hʴVT`  \  hu  hVTk~( z  F,V0RPhu  hVT@vh&'  hVT$@  h''  h-VT   h)'  h@VT   hf'  hPVT   hg'  hdVT   hh'  hsVT   h*'  hVTj   h'  hVTK   h'  hVT,   h'  hVT
jjQhϵVT    
     t#
  jj@hVT    D
      u~ tjjEhVT vLjDhVTg   Pjh VTI$  h,'  h-VT*(  h7'  h;VT,  hm'  hMVT1~X H!Ph-'  h^VTvh/'  hrVTF   F Pj`hVT{0  j hVT_8  j!hVTC<  j"hĶVT'   h4'  hֶVT  h5'  hVT   Pj=hVTv`hN'  hVT   hO'  h%VTVS  
  L  hV'  h6VTQvh\'  hLVT5vh]'  h`VTvHjNhrVT     	     	  ~* 	  ~+ j	  F$@	          ǅP      P  ~| t:    PPh  a  P<    t$h ea  u
uj~ R|Ph   Td  |ptpP~|PMhh hB  F`  8P,  1~! H%%Phv'  hVTG
  Pjnh`VT)           
               VTFP	\  4  C  0  j jqhVT }     |     ~            @    h'  hVTA  Ph   hϷVT   Ph   hVT  h   hVTFd t    h'  hVT1   Ph   hVT                tPh   h9VTC  P$  v T`  _PXhK5:	;    K      1Pv  P  PC{    MbDыDS)Q4hVD-  KuѥDD'	 ~
ǅD'	 		    t^d躚$jj ǅ    ǅ    RPhi  J\  닐HD  t1  uPPT  ًtŃj
茠밍v PPh   T_  Q)ȃJ   @v QPh  Tǅ    _  
RjhP[  PPh   TX_  =  t=  -        RP!  X!    9'_ǅP   \h$hN  hVTVh'  hVT ,j h   hVTj h   h VTf Ph   hѸVTDvhh   hVT( NPh'  hVT  jehVT   h   hVT Mjjwh VT  jރj׃jjRPhu  h0VT^ jjohJVT> Qjރj׃jЃjɃPhi'  h\VT jjZhnVTP >hh~N  hVTVho'  hVTjj)hVT PjkhVTk j jjhѹVTK vj jUhVT+ LPjThVT #Phc'  hVT     e    XhhXN  h(VTShI'  hAVT Phb'  hVVTn j j@hVTNjjQhϵVT6 Phq'  hhVT :PhQ'  hwVT    
11v4h'  hVTv<v8hu  hVT ?D  h('  h׃j jv    P   jehVT@ RPjbhƺVT  jjyhٺVT  X8hSUU  h  ~   8Q8hh3U  jP`$H)Ɔ   Ɔ   8hQthh8Lhh/U  ǅ(    ^h 
P hU  Z   iRP juDHV0F,'F,    F0         @   P S   $Z hVkX8/ǅP   u&hth @Py  ǅ    h8u   j/P,t@8 uQǅ      t : h   џ[8ǅP   S)P՘ 륋8xv ǅ     ,8蟘8P;  担  0t0ϙlBj  lAH  lB&  lQ舙ۉlvXtX_      TlU  :	       t;:	tP_^ uY    t
   u8VS    uPL  
݃P뺃v蟘뗃h)P.  ZP{%PjPYPHP
  ǅ    >1Sǅ   o4萖hP-  V0V0迗@18P70V轝̍v lB:	UWPh @ Tǅ    S  [$Y-  ǅP    bVHǅP   JX   rPP  PjV   R_hA7  t,S   P蒜S9  hP7  tP   뼃h]w7  u{6  Ph`h   S|L  ^;VLXZhkǅH  ShN  tƅ_ EH19L}
LETVPRSFPu EL:1t#PuPSh~  ך    V莛v    j jqPcPVGUSE    }E    wE]S'x+}vCttރtكu~Ysu]ËE]ttu몉UVS  Ph  (j S:	DSVuuSƉ$e[^Ív UWVS  11ۍPuh   V9   tn1߹ʉуL
QS葑t0VP螑j
S蠈t ؍e[^_ÃS術1됃V#Ã1t뻅uUVS薋 u]tU4
t%tPShVK  e[^PShQSh ސ$tzuPSh@RShPSh븍v UWVS}WE    EUҸ   1уIQË     hϱu3tRhϱj t2>    E8/toPShZVJ  j V@t&uV?[u6Ee[^_Ív h  V蚆E@uÃVuShϱhB닍v ShϱVhVI   tuȑ뎐UWVSLj8hrj}WEH  E*E    E    E    te[^_Ív h   ctJjWE   usw5:	   j+EPV"KuăVW7느UWVS(E     U@P(U]uE @(   fB  fB
  j 跉UBE   \B  \  ,tP,;tv CGF} t1e[^_VhxEjP
  PF     ۉ[uVh ڍv  UB   PrˍUBtzE  荎EUJERUfB;}tE  CTEPFVCSu  HtUBEUE&E   Phw({<{]Vh}#C]t+]*,t![t1 tCFv {t}ԉUWVS}   BE   @   1M fP%   fs(b     fC  C(   fF  EQPEPEPEPEPhud ~
EU9~$uh@jP
  PD     e[^_Ð}:FFV      FM90ttj]utSCEP+EEPSWR  Ht/>tF+F@E܋M1VF)@E܋UE   RhMfB%   flCfFL}]BE?v uhv C(   SEPEPEPEPEPhȜQ E]8ÈE)ЃE<]tO<:t"uPhjP
  P-C  t   F^^UۈV}]uE<:uѐUWVSU]uE       Eҋ  t:{t5[t0}   ]   \   CAFt<{t<[u E     躊U   t%E   [tH[~{t'uu
Ue[^_ÃU4ًuFVCSuEuFVCSuC<{t<[t
<}t	<]<CF/   됐UWVS1}QbƋU          jh`     ǀ       }1EPjuIS    ƃ   CtT}t	
   u'Vϊ$ǊU      e[^_Í
  PjhԜuC  뾉EUE1ʍv Vw   UWVS}   r9s+v       @    x(t%N9r؃  }e[^_@0KxMUD,4Ky@t,Չ   뙉4UWVSE  A  EUM耸   %  ƀ     19ss      M@H(@(   wHu_AQ
1RhZuuYh?  ])]FM;   rE  U  Ee[^_y1h "A  $   nuރqAPhuu>  E)E 뎐UABU|v U4hZuu>  Ov E   X9˾   sC[MB(1t~w]HuOfB2@f;B0fB2t3Kt!E   9rȉe[^1_ËEjfB2     r(uB<B8;B0B8~B,B8ӐB.B0:B-B.~B,B.뼉UWVSh1E    }QM|E]1tmu> tX>#twFu   E48;ur6Ѓ@PuUt5ERWEESP+uu> uEM Ee[^_Ãu13 VfP%   flj j
URFP*PMM   9:4Rt(}   Etxw:Hu EU1эyuh >  YLuuEPhj]Sl<  1эy E]ȈEE UWVS,:	E܋ut'<%   <\t$uP͂Fuۍe[^_Ív VrtJr6nt&uP薂XZuFP臂붃uj
鐃tuʃuj	كuj
ύv F<%  <{t%uj%<Y[uFP-Yj}VyEtE U  1ۅu1} tuԊEۋUFWVh5:	$=  ؍v 4V=  uC݀u멋DEw$@PEPh  u@  xEmuPYPEPh 0 u@  <uuhmuv<  PEPh 0 PEPh 0 PEPh! 0 PEPh 0 PEPh 0 SEPh 0 uN@  uuhrWEPh 0 QEPh	 0 WREPh
 0 HPEPh   u?  zPuhw;PEPh   PEPh   u?  CPuheWEPh   PEPh  SEPh   REPh 0 QEPh   PEPh  YPEPh  JPEPh
   pv uj%yUWVS} ]uFh:	SH ;	:	   h ;	%,;	j Sye[^   _ÉPh:	jUWVSj hʠuL   Sj kXZ5:	ua}uVSĄ~ID utSxe[^_Ív 5:	j
~ZYSjÐ 뷍v    tUubxt8 u1ÉEv USj hӠt؋]Ãj hؠuA$xtʋXt; u1뺃SyÃ몐USj EP]EUS؋] v UWVS]U؋u)ЋM)ˍ<MbUUE)[^_ÐUMVSE])ƋU)P<$4$$[^UEUEPw
$A   øB   C   D   E   F   ۸G   ԸH   ͸I   ƸJ   뿸K   븸L   뱸M   몸N   룸O   뜸P   땸Q   뎸R   뇸S   뀸T   vU   lV   bW   XX   NY   DZ   :UWVS}ut> u.P$8e[^_ÉP$8uGFt> u룊럐UWVSU}utT? tOu   e[^_ÉPd$W8uEUNGt? t	u븍v tUP!$8덍v UWVSu}]u
e[^_ÉPGCtNuؐUWVSjj4}u]45	   x1tuvэABEBEBEBEBE BE(B E,B,E0B0ۋE$B(tC$B$S$Ѝe[^_ÐM<uE8E<v 1UWVSjj@u}]5	1t&trtz1B    tC<B<S<Ѝe[^_Ív UWVSEE   Et=1 E    1}эQ߹I9sFEvыEe[^_ÉS}ʉ߹ыE)P:5  tE싀(EEdUWVS}1uMtV}эy   8Px5	Ã1tRWuSyt ؍e[^_Ãh%5	UWVS$jj@E    E    E    E    E u5	EU1ۃҸ      }v } "  UERU    $h}    E   Mt   { uo{ uX{ uA{0 u*]t؋[<P|5	uEe[^_Ãs,|5	Ńs|5	뮃s|5	뗃3|5	끅q뇉 Et	EIE   =u} u t݉EE   O ɋGu} u GEGuƀ} u tGEO ՋGu} u GEO v} u< 0P5	Gt
O GXE   LEƀ} ug Wt4G RWj P5	$맅P5	GtO yE뛀} uE OtG 댅t$P5	GuE   O E   E뽋G$O  ^} u G$YEG(1} u G(4E} u] Ot&G RWQP5	_ZPj P5	G}GE륀} u O8G8E} u3 W,rP5	G,G0iEE   XG4O @1} u G4_Ev E v  U]1   tCuB  Ct
C 1  S Ѓ		   C$uЃ00  Ѓ

   tC   C    u	;]   kussHCtaCuuVs4s,s8s ss(s$sss3K@t%CtE[<u!E   ts3tCC QusP5	CtCE   UEPuuÐUWVSxjux5	Ã۸   tL}       u}1эqFPx5	CuS|5	   e[^_ÉRVuP!sCs MUStY}t}t1ҋMQ1뮃sh-  uQEPsjquϋEU뿍v E뤐ECUS  EPuh   Sb*  Yuj Sj u]UWVS}t#{3v$S|5	u    e[^_Ív s|5	ˍv UWVS,   Pj uP  u<t!~tMSvvuU9Fu6uߍPG1e[^_ÍP.v VPP  Ph    WP\  tPSWuU9u
    tutPbqyUVS]tKC$3   C(   uSufHuCuJCu3C,uS|5	ue[^ÉP|5	ՐP|5	뾐P|5	말R|5	C(눉PSdv UVSu5	ƃ1tVkn$5	É4$|5	؍e[^ÉUWVS,  E}ǅ         1ǅ    ǅ    ǅ      Q  Ҹ     Em  Phj R D  	t&PhPR  hQP  VhRQ[  Pwwj R(   ShVQP
n  G$    B,1ۅ]  uPh PRƃ t
S|5	   B  Z t/3hQPR   [u҅   QhRQ   G(   n     E  @  Pww0jRƃ u8R$҉tG$uG$   ?t&PX|5	e[^_hRQKuMQ|5	U1h̡QPX|5	;Dv QwwjPRwwjQph&     :	tz;:	t%S4l$j pjaSh   jQ4gRQPPjR t`PZ|5	E        Ohr&lÃ3PhաQP rtA,P{X|5	   G(Q   G,t+1ۅuPhQPƃIwÃG,  Ph`RQG$UMɋU   t
B    B    1ÉUWVSuxE} ]}urNuhpjFt'vWjSet9v} t ڍe[^_Ív viF    ԐpWjSVUWVS}EEE1E    tWBvnSOu)+u9w@KSREEQP
iB+GEG    txvEe[^_KRVEEQPhwEQuuWEuvUVSu1tESK[^Ív UWVSj)x5	Ã1tOj 6e\;	B$\;	Ji   1߹эq'vC( ؍e[^_ÐSlx)ЊF'vЍv P␐UU1tBt
@uÍv UVSjux5	tHu5	t)C    tVXe[^Ív S|5	1UEVSt ÉsuS|5	ue[^ÐP|5	֐UWVS]ۋu      ER     PVj
u`ÉE   uH9Éus>E   uuaEUMT  X   EMC9MrƋE9EsU<
tC;]s +Ee[^_
MƁR  ۉU<
t뭍v 
륍v ˋU:
tEƀR   ,Q^S@PRzaMT  X   ރʉUWVS  ut	   ue[^_ÍEPuh  S  1I$    QSj V   뻍v UWVSEPu]h @  x  V@    t	   tR   t?1ЍH?  wƄx  
Ƅx   j QVj SM   e[^_ÉVhZh   P  ƃ  둍v UWVSE EEPu'  Eu   taE    }1эYu萃EPSVuu    uE쀸   u#E9t)ʃu|5	e[^_ÃuuVjPv   ƐUVSh @  uuuE   fte[^Ív ] t$tPVe\  Ph£6A1UVSM   19EЃ   u]t=  t#E1He[Ƀ7^Ív SVRQ3SVRQl  UU   9EuuPRU@HɃ7Ív UWVS}uGVEx5	Ã۸   t/PVuSbE    E     1e[^_Ív UWVS}UEuEu1эy   td;  t
8   e[^_Ë  EP  5	ƃ   tω  RWuPbE쉳    1   tDB0t
  A      1=     9tWPh SC   ^tX  u
   ttI   WjuЃ=  t9shӣ먋E}EE   ]e[^_NT  믋E}Eu  WjuT  CQWuSǃ$Uj uuudtE1Ív Zt
8   uލv UWVSu@E    E X  E;   U}            )Ћ]9vÅ   U @  v @    ?   tr  tLEx} uU1ҍe[^_ÐQP  u_E    ʍEPRQuuERQWVSi  Et뉐  WSRu_  EƆ\   oH  t$9E}UMH  u @  吁}?  ~ᐃP;:  Ev UWVS]d  U}uu=v1e[^_É  jjR?Pb  jVWb ɐ  VWRS빍v UWVS   ul   Etutq   tg1҃}   }wt}tatF   RQhh   HS  1у IQSj V	uuuuVe[^_ù 듐}t}uC|UWVS`;	߾T   E   f1߹эA)E}`;	w"TPhcuS  e[^`;	_ÐEHPCPg  t @)E뻐UjPh@<	fg  T5	@<	T\5	@5	ÐUuUt8 u1ÉP5	UΐUEZA}0	w   1aUuuj    Ív Uj uuj    ÐUWVSE   }1MUEPEE    x5	ǃ1tBut.UPE<t%U:BUNEuҋE8 e[^_ÐEE9EvPWE5	t!uhȤUj:P  E롃W|5	1@E8UWVS,E   U1փVx5	EЋMЃ1E    t=N~E%t6ŰEЈNBEU}ЋE8 UtUEЍe[^_O_URUˋfQ%   ft}WfA%   ftj jUٍUR}؊EWEE XÃEcp,UEt
P|5	UWVS]^18v fG%   ft
tPCtC$t
1[^_ËEv UE Zw$H   Ð1UWVS,EEE    E    8 u}tCE;%7  À; uE    E9E}Uv ]C;]}UЍRƃx	H   UЍRƃ	w$EЍ@ Dv E9É]|E܍e[^_ËUЍR    T%@  =@  t@   tP DT밉%   =   t    u    tTD    z D붋EЍ@P DTOUЍR   = AQ{%  URPEE    u];]~]E    E    v E PJ  E @ZEw$ܦMǃMEPuM @  EtEuUUE9E~UU눃M낃MerM   E8*t j j
URPM   UECU@RPM   EEEuEEU9UEEE   uM   j j
EURHPM    +UEM   M@ME    uM K]Ћ]]E3  $HMUЍR   UЍR    EDUEE @  TDt/HDEЍ@	   D    D    D    E   t3EЍ@EHD@	   D    D    D    E؋U@UFUЍRM     =UЍRM     $UЍRM      UЍRM      UЍRM      UЍR   UЍRM      UЍR   UЍR   UЍRM      qUЍR   _UЍRM      FUЍR    3UЍRM      CEUWVS|  uSuPVǅǅ    ǅ    |> t=:%tIuPU@t%P@t<%ù: uËe[^_Ív Bx%  PRy|  @H @  ;  @@   
  G@ϋ   $D   _w   u;~+uj U@ՃuPU@@t<~,uj U@ՐR   ǅ
   uD   ǅ   u2        ǅ u
ǅǅ   ǅ    o  	߉taVS= VSO: ÉЃ	؉u+))t
  ~9)I~ 0Kt
>  "  G   t  u;~+uj U@Ջ  A     k  t
  G%  =      9vVCuj U@RuPU@9vnFuj0U@^uj0U@.Ct ujXU@ujxރuj U@uuj+ރuj-ԋBX0J3ǅ   ǅ
   BSۃ Gv wR  1эYt9s)      u;~+uj U@ՉKu~Q   tD~4uj U@sՋSuj"U@6uPUF@KuXuj"U@Pt	~ȃB   %1Gt9   ǅ   ǅ u
ǅ1ǅ   Tt;~+uj U@$ՠt$uPU@Cu܋@YEuj U@@   tKQ    tBuC8Bff$f1   󫍵fǅ!   )Q    ǅ  [fx ǅ  X     T     )  
  1򮋕хҍ\x"heS  )xhdSi  ÃP    tlPC   tgC   Eue rrVSM"uPU@~Cu   tC   GugfC닃hV4IhVIShiVHQhVHPb   MG@/ @  G@v fx yXǅ[HuPj%U@!UUSB9B]sBË$ÐUuEuEEh,rEEPE    Et;Et
E  ËE@ v UEPuuuÉUWVS]3}tRKAS9sCe[^_ÃPV5	tcK̐C   ʉj x5	t1C    C    땉UEPuhrEPE    E    E    E    @tEt Eu1Ðu|5	v MtEU EӉh%5	UuuhrEPE    E    E    E    @tEt!Eu1Éu|5	v EtEU E҉h%5	UUE
UEPuhptEPU ÐUEPuhp5:	ÐUEPuhpuUuuhptEPU ÉUuuhp5:	ÉUuuhpucÐUuuFÉUuuuGÍv UEWPV}uSt> tJAt9 u)։)u1эD[^_Ív ? tv tJAC; u) 3ՐUÍv U1ÐUSP<	@<	1H]tЋ]Ð   x5	`|5	`5	5	5	0u    t   u<	1I     tЉUWVS]ۋu}tbt^EtWtSMtL<	t
1e[^_Ãu)uU5	Ux5	5|5	=5	5	   빐U<	t
H<	tÐSR  <	   ut<	    H  <	ސU<	uj1҅uEP蚺  1҅uUÉUUҸ+   tQEPuRH  ÉUSP]ۺ+   tbCt@u,   tCtHtn0Q  t	C   t=`  u'jj '  `     u	Ћ]É]]鰇 C   W     t몃3}  C        sUEt  ÉUEUBtÉǂ\      US]h   Cj P&DC C$]UuuuY ÉUWVSjh  u5	Ã1ۿ   tqh   x5	p     tJtF`  tPtlp  uSP  u:X  u!S膱  $|5	1ۃ؍e[^_ÃP|5	ЃP|5	뷃P|5	랃PĶ  농v ǃt     VSH  I  d    Ҋ  ǃ`      ǃl    uwP  uIX  t"P5	X  ƃ\  SD1ǃ  P5	P  ƃT    Pd  rVs  d  t\v UVS]d    ǃd      Y|  Я  ǃ|      $  hH  j   VA4$贵  h   j h  PA$b  ǃ|  ǃ  e[^UWVS]U   1   H	E    t       E  EtzUǋ    Eǂ       @  v @  SWuU  Eu U  t9u))ߋ]uuu|5	Ee[^_ÃVP5	t U  RVWP=E  봃E  |5	Uǂ      E   USS]۸+   t   uhkS   ]ÉQuEPSr
  uUt	E1ӃhUSEPEPu]t	Ћ]ÉE    PuuuuJ @Q   t΋E8   t1USEPEPu]E    t]Ív E    PuuuuM ¸7   tȅu	ɸQ   t뵐UWVSM11҄ËEK0 l   }~   t   ~trUJtN1tt"    w7>J  )É؍e[^_ÍEPI  EUEU}뾉봃u  9Љ|럍v   USj j]S;UtQ
   PjSo;]ÉR%Uuuj<  t   t1ҩ   Ív UWVS0  E   fL  P  h   j hiPǅ    ǅ    b=  Ph   j hP==t1I   N  }  PhRu::yxN~2QPhYCfhuffj'48  Wu2  PWh?l-   e[^_Ph   j Wǅ   S<PWu:x#VPh]Eƀ^  138  Wu1  PWh effǅh fjǅ   h   hRuq  X  }X  3  Pj umJ  H   X  u{ǅ~}t"PhmPhPhRj/1~ffǅh fjǅ   Wh   hR0G  ZY phPuh@%YM  ǅ   (Ru)1  ǂX     uhPh1ǅ   Qjju3 a18Wu/  PWhH i1f2OUVSEPEPjju]E    E   2    t
0 EEtjt1te[^ÐUWVS}u   A/EǄ     u(F8Xtv uj SV4  u[ue[^   _É   ^8UWVS}E   E  Q   7E    t*  1҅tRV^(  E 1e[^_ÉQjj Wa  PV,(  XZj SF   t0E    tjhVuuWuE|/ E쉆  PW-  P      hVE    뺃EPSE쉆  ZYPW-  PhqEPSE  hVuuWDuRhV%   v UVSu  EjEPjju0 xhƬSve[^ÃT.ZY0V,  Ph Ӎv UWVS,  UE0BXM   \B`B=   Xdv
ǅd   QdrhP3t  M :  RSj x  Љǃ	  X   h   hSPR4     |  l  tRj Wp  Ѓ   PXWuuzjWSE      1ۃ      PWuuMKt@  Pu:+  PhVW7+e[^_Ãh׬׃E hV|փ\  sT, t;st6Pu*  PPhV  uWSdhQW4ÃWu,pQShVShZj.  SES<P6*v Sj뼍v W`\X5v UWVS8E EԍEP]E@?  _EUE؉UXU EjPu   Pu]#  ^35@  љEȋEԃ\  H!Eȅۉ]tVuuuuEЃ@u<UR>  uu؋uV]S>  )xWM̋Iɉ]؉u܉MuUЋEBt"]tE̋MU  1e[^_Ãhu   h0u   ʃhUSPEl  ]Mt6`   t't       tR9  u1]jjEP   Q3אUSP]Cu%uS|5	]ÃPEP␃P|5	̐UWVS}uEUM            F    VNF    ~Px5	tc19|
1v e[^_Ãh#| tC9|Ktj 4K} t6|5	v    롐UWVSu}tYMtRUtKtGjx5	tWuuVP u
؍e[^_ÃS|5	1ۃ1UWVSj}x5	t,Wx5	t$PWuV-Es{e[^_ÐS|5	1UWVS}wuuWۉEt"v 3uuvvWu^[uPuuuBt;PVEpPz tGEe[^_Ãv|5	4$|5	1܃uWϐUWVSuv}WuVۉEtWuppVu[u   e[^_PVSuz 1v UWVS}wuuW0t!uussWuvu1e[^_Ëv UVSu1;^}#v V4z     C;^|6|5	e[^UWVS}E    W9U}=MۉEt#v s0uUuuWE9U|če[^_PWSuy OԐUSP]tS3$|5	]ÐUMVS]9ًu  sv A19r1[^Ív UMW;MV}ut	1^_Ð8u98¹   tUUE9BtBtËB@HDUWVSjuV}Wte[^_Ãjj5	Ã1tEECSjVWtS|5	1벍v UVSRj]SuVt
PjSV6e[^UEt
P|5	UEE9Ív UE }UhPhlhh  EÍv USjj|5	Ã1t m?  CPuS|5	1]ÐCXusPY׉jj4  C`t
CCC뻃sXXv UWVS]1t; t   e[^_ÐE  t   UJujj85	EUҸ   tChtU9P8s  ƉuEUPj PEPBt
z  tBuCPB   `     x   `  @   UCCBSBSuCUBP  Y^jrg  C<@C<K`;A~Sdt9};A!CDCt    Cx    S  1RPQu  t̓uS}      P趝  EPC``  )C``  PEP    B    P|5	t>}{huUWVSuEt> t
   e[^_Á  t   Xt{KEE tC9  } tNDt-    @BvvwCƁH  j s  CxF  Ct+} !  PEPsCP  StCsVi     S`  xtzC   SV&  _Xj sSttPCǀP      @    CuS|5	N<4$w  1P|5	ՋKǂ`      q} g    @BMA,AC\  PV  Ps起       @    EHUE@\UEP  t@    Ív UEMu1Ív    U1U   H%    UEu1ÉE   E   v UWVSEHQ   }uuYXtRPBww@$Hu}][^_  u}][^_Au}][^_  v [^1_Éu}][^_  u}][^_9u}][^_^ v UWVS<EEt8 t
   e[^_Ëx9ǉEt{v PjEPW1ۃtDȉMTȍKtDȉMTȃt;U~UC~?;}uEUĉ1aUWVS]S  E E E    t   e[^_ÐQ   E   KAwC   w$|sk` C&  Kt\{t0CSƂQ      }    jS\Kt }tEZjs  CuًCxtHjx5	Ҹ   CBCBuC   B       SF@     @    멃s跱  C    Iƀ   ƀ     Ró  Y^C  s谳  Zs  jSdCEǀ\     js;  EPEPCPs   Css?  Ch} uC} Eu CU   u
jS끃jEx\ PۃjԐEPsE      MɉCuCESu}	  XZEPs  Ct	C    뿀} Eu#CU   tjS$떃jM1y\ Pٍv PEPj s} Cu[C\} ;} uCU   ju~\ PSE:EPs  C뎃EPs@r  S]   Ct2K  t  KƁ   C    jEGU   v(EPs  Cu} u0{Eso] j sCP2  EeEx\  C     s  Cƀ  jC   t(CƀH   jSCC    E    EPsVP  Cu0} t#CP   t
j	S뻃j
Qjs{\ j sV
EPs"  C} VEPjsA} Cs  Cpss  Ys
  XZjC     sV  Cƀ  jkv K  ҋ  x    9׋  4|9w.  ҋ  x(    9׋  |9v
j
EPs0T CC      u
Cƀ   u
Cƀ   Ct1C@0uƀH  sZ j sCP  }EPs` XsZ Y_C  s  C     s]  S      tT   Pj j CP  Ct"{u
ju|5	 PVusK] Cɋ   u
jEǂ       VjPR] CtՃu|5	Đ[   Eǂ       Ij 05
  	 8 sI7  K    փ	ƉMt  9׋  |9M؋    	t  9׋  |9jfC  s[  Ys
  C\   j Hj ECPr  CXZjC    Th  ShRֳKtjSEC    KCƀQ   C    <UWVSuE    t> t
   e[^_Ë^~9tSV6tE9u}]W''  SvTuuu%  U҉FTtBǀ$      ǀ(      u]VDEۉ~EtV  Uv UWVS}t? t   e[^_Ív     wP^wX1ۋG`;XGP    GX    } t
@0   C;Z|wht1F`   ǀ\         V|5	ۉuуw`  G_9ÉEtBCx3tYǀ`      j sCu(S|5	;uuW|5	1v P|5	ɐ     @    또Ps  Iv P[  W`    v UMVɋuS    t9 t1[^ÐA@tQY9tv Bu9u1tԋA@HA@BHBUWVS   1}ȃL1DG~PjEPu'1  E      v DȉEPjURMqXE    Ɖ   EtE      EtM  E9Ft+1tFPEpLuuċUrPHEF G       O	ЅESE}H419   ET 1;EUy  v ;T[  @;E|B   PjEPUrXE"  BXt>  txvM;QE      txvM;QE tx} tj1tFPEpLjUurPHuċEpXUJ4G9M} uMUJ4e[^_ËEH4ɃPR  t   @ c   PR  t   @    E EUPUruċMqXUGv UWVS1ۀ} }uE    v  }   RjEPwX9     t
   e[^_ËP  Bt;   t  t u   tA  t tP  BtL  P  W=EP  @t
ǀL      E   1ۍutP  WE~\EP   VUwT  REP=  GTEtXǃ$      ǃ(      uGDUEP  W됃P  WWuWw_9EtSWr9u뜍v UU1ɅҋEt: t	   É='  ta='  w&tt	   ۋEBdEB\=!N  t%=!N  w='  uϋEBp=$N  uEBl뽋EBH뵋EBLUVSuj uj uV ~e[^Ív V?  UVSuuuj uVH ~e[^ÉV   UVSuj jjuV
 ~	e[^ÃV   UWVS}OTuUe[^1_ÉEP  XZwT55	55	]uD  P9ډGT|/	P9|&~$VSpp  Uu   듍v E     념UEt8 t
   Ív FUVS]Clu1ҍe[^Ív EPSuۋExҋKTQCt9|qCx9|    ~QASxCtVspuSSl뙐UWVS]    r}pWy  tt   tw  E}e[^_x    UWVSE  
  ]Mp  rE    uui]  ɋ<   9sKtGv rRSU  ] XZj3R)  FME䋁  9stE  뽐]uEe[^_ÍEP  E]U쉃      9E   tƃ   Q0h3sXZj   0   떍v USS]  ҋMt9
tRu]Ë  pPR  \    tƃ   Q0h3    E   E]!   UEtE9Ív 1UWVSE@U$  }EUteuE$  uZtMEQTPE,  PUrTw  u4h֮uDEUǀ$      B    e[^_ÉRPh u븍EP  Mbщ)э)Ǎu4ƍ]~CƋU$  uEx   U(  $  VS  VEQT}P,  WEpT  u*EUp@  EWpTVS  UBTRPh@u#U,  뵐U1҃}tPjEPEpXDҸ   tEB1UES@`1;P]} t9t
B;Q|1[@0t   UWVSjj5	tEUCBhZhExht?v UB`1;HE } tC9tfA;N|} 3t߅uče[^_PshuCǀ\      $}  t7S|5	봋EphEUET  $ø 6۸QԸl͸`Ƹ뿸븸뱸몸룸Я뜸 땸뎸뇸`뀸vl&b4XHNaD :`0z&°԰ ` `  |@rh^ TJ-@H6`,"cpα `$ @x;nUE@w@$øI^&r۸Ը͐;ŐUEw-$ øԲ&ِUWVS  g ]}  ƃ   Sh   PWytjQh   PVU
XZƆ    j
Vtt)H~ j
VXt	)~  ;te[^_Ív Whh   V됐UE     ɸ   ÐUE     ɸ   ÐU1ÐUWVS}}E v;13WuF~E؃eH	[^_EUWVS}E  13W蝈uF~E؃eH	[^_EUWVS}E `1ېVWRu*C*v} tF@e[^_øEٍv UWVS}7t	 fPfuFۃ[^_Ív UWVSEPE   l  UUz   ~*щ)эI)M)N]   ۉxvQUEE))ƋEU)؍0#ҍ؋MAQ@@Q H@[^_Ðs녍v Kv   )*׉ș)׍}))=v UWVS   EEEEEEEEEE    |ǅx    8    EPƅw .] fP%   fZ     ft}}	  j j
EPS[}pL  ]})؃  w u1Eu
}K  w u}   w    }x; t
x)}   }   }   }t~}  ~e[^_ËEEȋEE̋EEЋEEԋE-l  E܍EȋUPU7t1}H#E~9Ѹ|ʉ똍v E    E    E    G}	pk  uƅwF~El  1}H!EE  pHwpMƅwE   }i}_}Uhpыp)Mp)Q뉕d`d)HEp)p)ƅwUv }])؃px  9|K+t	-zQp֋p)֍vp)ƍR+ƅwU+ډU!v EPEPEPhS t]EÉE0E1}   fuRVhSwу}Ytkw u"}tAw u}tw wEyVE@tƅw΃ViE@tƅw뤃SVE@tƅwvU/UWVS}1txx|EP:
  EUE؉U܃QSj j 9u7
 tu'uuRUR  Xuu
  )Ã1H	e[^_    UWVS<1}}E    E    D  ~EЃP  EЋUԉEU}E    tUUfE fE  E   }tEċUTfD fD  @EĐ   1H!QVučEP$u; tu+~uuERP  ^uu  )ƃ۸xY1tS1Ƀ}E    tfEީ   t   "tE   }tEfTމЃft8tȍe[^_Ð8}WؐUWVS}1ۅuE    E    t1;]sM<   @;Er   ~EP
  EUE؉U܃xh1H!QSuuu; tu+~uu؍ERP
  [uu
  )Ãe[^_É뛃V1RUUҋMttQR~Ð1uuUVS]u9t1ҍe[^ËC9FuC9FusvtЃsvuts v `ts$v$Kts(v(6   unUVS]uC8F8CFCFC   CumC(uNC$u/C u   e[^ÉP5	1҅F t؃P5	1҅F$t빃P5	1҅F(t뚃P5	1҅FtxP5	1҅FwQUS]sj  Ysj  Zs(j  Xs$j  C E]j  U=5	 t   Ð5	  v U=5	 uÍv   5	 UUVSuRƀ   ǀ      RV  te[^Éj6$  v UUMRƄ     UWVSED   0t8E    0  9E}1  Su!EP9E|E        e[^_Ã3U   {tfCUf9   t0  뭃CP  Pt݋  @  uCUCtCU1USS]Cu
   ]Ív P  CC    C    $Y3h  1    UWVSE8  SU   5	EMɸ         0  9}-  PTt PP;U}UAP9}Pu9tw  ECEC  CuAEUf   fCCP  P>He[^_ÃP|5	밃S뇍v UWVS]  tN1;0  }(1PG|P;0  }
  މ  |5	ǃ      ]e[^_5  Us  v UVS]SuV  P   u[ƀ    ǀ       1ҍe[^ÐU{  v U7  v U  v U  v UEPuuuuE    tÍv 1} HUVS]  ut1e[^ÉVjP5	Ҹ   t݉0    ǃ     ÉU  v U{  v Uuu'  ÉUVES    t19|v|5	    e[^ÉF4C
;|UWVS<M1ɋ]u   EE    E    EĉǉQ9ڸ   A9   xY~3Qt,B9|	B9}AB
t
OϋI롋WAUĉẺEȉAȃ<[^_ËtڋB9|9r~BJыtUĉ
Mċ	Lf   ZUWVS}M]utS   RQVS@9@|>Q97|5_wA5	G5	O9AQv e[^_Ét<9|"9q~O    _wG    ɐAGA    ߍv G        ͐UWVS]ۋu}   QSWVË@9|?9{~/uE     ؍e[^_ÐRSppÃ@9|9{̋KtCSACAQE뱋uKQPWVCA֐E     1낍v UWVS]ۋu}      5	F9|=;5	F9|.,Ҹ   tFBFt    1e[^_PSvvÃ9   u݋KtCSACAQ뺋uKVPssCA׍v    덐USj EP]EUS؋] v UWVS]U؋u)ЋM)ˍ<MbUUE)[^_ÐUMVSE])ƋU)P<$4$$[^UEU<	1t<	t1҉Ív h$hThjh<	 u<	   뽍v U
<	uÉh<	<	    UU1tR@uÉUExt1Ð@uuPjUuuh	BUUMB+A;|At1É   UEEEhEEPuÍv USP]D  t6t0Cu>EPuD  3Cu]ÃjSUG PjjSG UWVSu]tD  tu1ҍe[^_ÉEP@D  YEXV}W1҅tRhW3D   뵐UWVSuuEU1tl1}jj5	։tf@    ESVuE0#t)EPEFFXu|5	e[^_ÃS|5	Xu|5	1v UWVS$EM E        uuEEƺ   1MEˋH[  WSVM1zY[PuE\tE    Et
@E    EP   V|5	UtMUe[^_ÐuE] tލEPuuu?] tmMyuSuuSu-EEHu$Ut	E    낃S~ UnjPD VjjQnD 띋EtуEPu_0U1EjPeD RjjPD Ujh<	rUWVSL  UU    11   JE!Љt=  ~<   jh<	Dt%h(~e[^_Ív SVj jX#   󥍅j PjǅLbMb)ȉ$cƃuuuuǋ         U      RP@XZMb)tv3w+j[^h>VP됃j Qj XPjcKv UVS]Cuu&Nue[^E   ]e[^B v PjjSA CǐUSP]t3{ $|5	]ÐUh$hThj萻ÐUWVSUE҉EUw  j h  uu UuE   j hQ uu ։))Ej Uh  uui EU~ VShXj	ux e[^_Ðx  wPuuVSh_΋]x
}cBEU+EUEUM)j ]j<SQM؉] YӉΉ)u}uuRPuuhnj	u赠08}x	 yU--:-B-:--B v UWVSUE҉EU}<  }J|	}pw?MɋEUx#RPhjW) e[^_  Ӊ}Z]VEUx?)EUj hfffuu RPVSh? 뷍v }	  /MɋEUxRPhS? }' $h   j uu* RPhh   j uu RPhv Ux= wuuhu]x	}? w-MɋEUx

RPh   EPEx
}?<]VEUxB)EUj h uu- RPVSh  봉USEǃh      P  ǃX      ]ÐUEǀ      ǀ      ǀ      ǀ      ǀ      ǀ      ǀ      ǀ      USDE]w*$EPoEU    ]    ERP=Yuuݛ      ERPYuu|ݛ      ERPYuuRݛ      ERPYuu(ݛ  z    ERPYuuݛ  M    ERPbYuuݛ   v US ]EǃX      P+EU    ]UEUM|    ÉUEUM    ÉUUME҉l  p  x~  @Ív  w  UUME҉t  x  x~   Ív  w  UWVS  E ,X     pP(ǅP    ǅT    ǅH    ǅL    ǅ@    ǅD    ǅ     ǅ$    ǅ    ǅ    ƅ t\p,X\+  X+  P<$$$ݓ  ٽnfnfl|    $P٭l߽0٭n,$E!  ٭l߽`٭n,`d  ݀      ً  E߭  ٭l߽٭n,X9h      J  9h  ƅ
|9s,(X\    (  ,  X  AX  ~   H    Ȼ   ֋,,  (  \Xu
ǅ   ,(  +          SQٽn0,$fnڽfl,٭l߹  ٭n,       `    1    ,   xEx  t  	  ,h     
            ,  ҋ  xt.  ,x  t  xV  RPWVH j jdWV $. RP,     HL@   ,  ҋ  xt  ,p  l  xVS  RPVS j jdVS RP,  |   PT;$|; s $P    ؉+04RP}W
VESP40xR,      7  t  ϋx       @  , l   p    |  ȉ8څ<xHc  j jd 3 RP<8 @DEP,    PEPxRMQEЋ,P    oPVEP,    OPEP,    0PLHQ],S  |  PTPEP PD@h,  RD,  1e[^_Ã d,|     Ƌ׉ 0,      ?11Fd sdC 5RPh   mQ,,ߪ  \$ߪt  \$ߪ|  \$ߪl  $  Ѓ0uh,5u7A DȉډӉΉߙRPWVh ,    ,1i,        9
|9sȉڋ,    KUSP]C   C   CukCuTCu=C(u&C$uS|5	]ÃP|5	␃P|5	ːP|5	봐P|5	띐P|5	놐P|5	lP|5	MUWVS1}ыuYэA19ve[^_Ð0)Pus[1҃؍v UVSu`  tXQjjV0   Pd  3V  [ۉd  uڃjV0 Z`  qǆ`      e[^Ív UWVSX  Ej ]ǅ    ^_jj0ƅ 5	1      ǅ    ޿8
   u
B.;#   j
Sxt  j
S]t  ۉ  <	u  1ۄt!ӊCRtB<	O  utj:St|5	1e[^_É1ۀ    w<$(9.  5	Fuƅ<	y  1Ʉt!ъARtB<	T  uCɉt
 p     tƅ s  ]Ku{ tVF	  EۈN-ƅ    rsXt~CtQ7  u~uƅ tECtQ    v  ƅ    WEx t?rrrrr rCuLPhu.o0 utUBu⋅x- u
{-    s|5	C   C   Cu{CueC$uOC(u9   |5	uP|5	븃P|5	뢃P|5	댃P|5	sP|5	ZP|5	=v ƅ =RPGV"RP,VV믃h%5	Auƅ   B B<	t{A9hRU@ 8R   tW   uMhϱ5	AuƅChR3UF,5	Bj j
j AQ|5	FQ5	B4B B<	tjh  x5	j;St<   <	  j=SY  t9   RQh]Sƅ    1ItȊP m  	d  t< 8  <	0  PhI|S  V5	B    9   CtFt< D  <	<  j;S1;        xu*ut#u5	Buƅ uRYuEMt>j/u;t*+EXPx5	Fu<ƅ|5	 @+RSuPZF 봉j Sv C< t<	tǅ    ƅv QhtQ   .      j.PtG@uO~w.tkEtuVkt3>.t'P5	AXA FWVƅh uWhFPVh`ƅݍFXPhIPtV5	B$'Qh{qPtQV5	F(8"t+j j
j PBJ@҃PhPuRHR5	A4$5	V҉FYv V5	BPƋAqv F< t<	tI@ ȊP t	twv PhhS:hTNt@,hNiB.ZCj< t<	t]UWVSEU]UE  ƅF    hS臆   =:	E EF   h  x5	tPWh  S{t]PjShvNtBKt
 t	tj j QPVu At߀ t	tӉ1뽃S|5	} uFe[^_ÃW; u1.h$Sǃjj5	ƃ1tۉtP5	FUWVS8]Ej E?ۉEE      3
  SKM	щUt$E9UԉE؉UU9U   9E   {, t
}    Ct6{  tusu{  ucsufLtNSt!1PIQuRJu&j0x5	t)   ǉME'Ee[^_ËEtuV|5	ۉ]uv 1USP]tj3       C    ]Ív USREUUt} tPۉu]ÐP|5	UWVSUtCEƉv QA	ǋu>9Mt29t*QEHۉuϋ}U:e[^_Éԉ]ɉUVuSt1Fu1tv PIۉuV|5	e[^ÃP|5	USMAu%Pqqqy, trRPAuϱPY ۸RuWPAuRt2t.8.t)	Py. t8Phe]ø%鐸%ՐW댐UWVS]ۋuE t{u
1e[^_ÃVh   =:	EtNWh   jh3t3Vt:QPhW-$|5	6uπ} wWfhW} t
   GWhVKǃ   DUWVSEd  1tPu
1e[^_Ív 0E    t;Vt2PWG^ǉ$|5	tEt
6uŉ멉}u|^땐UWVSu1E  хۍytPWV3Hu[u1e[^_ËUWVSUt<:t
Bt	<:utB։t} fP%    ftF߃j
VtXv 9vG fP%    ftK)xPx5	Ã1tRWVS ؍e[^_Ãj
V耻uj VLÃ1t|UWVSUE҈U0   l  U苐      PRh?h@  x  S|| EP1߹IQSVe tCUuNV} uOu%PhV|U[u|5	Eu   e[^_Ív 1P|5	룐x  U苐      ?UM#Q   tA   A       tA   v    tA   ύv t	A   A   @1볍v UWVS]3|  EE   C0           H$M슋V  P ɉUM   E    E    E#E@ƃW   tM9M
|2U9Uv*v   t@   t7ƃH  F    F    MMue[^1_É]e[^_  E+EUUx~4  t} uƃW  뺀H   uRPhV$\=  vÉtGw+,D  H  !@UM
    ӋPHUWVSu   B11ɃcE E    v   t 1t   HHe[^_Ív L   t;  tV   t*+  "  Pu
ƃ  v M   t?   =  tV   t)=+  "  P;Eu	ƃ  u
}       1  XP  5	      &  tt	W   t6Vy  uMP   hSZE   ڃVE믐   +     uV   t  ttP  5	      hƃ  OUWVSUBu]>E          HtiEtVtG   u%PuruxPh WfYU z B
1e[^_É   뷋E@
 v tDM   u	E@끃hW,uPVEMuŀL   thÐuuPVE dPVEǯ& ىUWVSuK  EɈEE        t	M   uL   u1GBe[^_Ív t	 uGt	z uBtE8T  tiB   tZ   u  tv   tj uuWV EE뀃     ?@uGڃjuuRV E?vUWVSU}  EUG  p}E    Ete fP%    ftFPjVhǯ!@tbU
Ot
e[^1_S1}  VPuM! HtEƀ   ̓h`uVUƂ  QjVh?tGGthuV΋EO1R}  VPu
 TPjVhN?9EO%G    Lv }   p  UUWVSut      u
1[^_Ív 1  ~x  t  	t	  tA  t.     u  t	  뭀M   u   띀L   t1  u놉UWVSE|  EOEWΉE1	tsL  19]x|9wrPwwuOHWD΋G	։Et>G@GWG8U  GLG<O  GD    GH    Ee[^_ÐG    G    Puwu腺u1w)wWƍv Ujj5	ÉUWVSEME   |  MEE qEM+EA0E   @  v @  yD  RSuPEyD  UEPSuuuV E   M;Mv])؋UE܋      E܅tE1G W$E   9tgU)
U  G8  G<GG@GWGDE  WHǀ  $U1OwG    WPGL   e[^_ÉGL   Uuu|5	EՍv P|5	97   uMƁ   뿃RSujPZM 9uEuPjM1Y MUWVSEPu]qt/Qǹ1IQVS?   É4$|5	؍e[^_ÉuS|5	   ߐP|5	ߐUWVS}uЋ^9rnɉMtFH9v>xx?Ѝ9snEtVSu5	t&^^SWuP芷~1e[^_Ð6'  4$|5	   ݉Sx5	뫍 UWVSU1эYSRuVD:1҅tVސtM fP%    ftF߃j
V輭tQ)UE1эY9]s1ҍe[^_Ív PSuV9uMF9]sԺ   σj
VYuj V'덉UWVS|UE:fEҋ  OE    M̉EuEȀ6 MU   UE    E    E E E    Ɓ]   MU     EPuhWE P     Z~  Puuh	nEu  jPhu   U%   E%]-  EhWuuh!nE  hWUu hW;u   tMp  MSuUl  u%Puuuuh@V9M0ɉtM9 5    1  u|5	4$$  ۉ  EƀU  U      ERP[Xuu{M)B  \    EƀU   Ex  E   uuE    E       U      MSQYuuU)҉  =  R~  PjuY  tmMܸ @  Q+EPVuuR xa  U܅  U}  MME    u  Й)EUEP  u*   u }?  w!EtE8   e[^_ËEuꁿ     t$uuϋMH   tE}          =   t7VPh`WL} {   mUƂ]  ^Ml  "  Eǀl      Ƈ  XZhW6LƇ    1#   nEU   蕪MEǄ   @Ex
} v E    EPRVuE      @tPuhWK\hWKE    E    9U4E>
tFE9U|     w      t   uuPukNZ  U<
  <
  UMUE RjPh3tÚzp  #  Pjuh3tḾyp     Pjuh%3t<j j
Ej PEUEUMFUE    uSh5hutEQh;hCut hVW
JZuE  Ph5hu|uẼpPEPhquyGŰBp  6PuEppuḾyp  E    u   EEE   uj} pŰEƂ   +ESPh~W+IMy
t+EPE+EPE@Pu  @eQuGAME̍v uuh WHE+E)EU{v uuujWO S,  E    t  tEƀ]  6E   hv WHh`E   hWHE   +Pj juUhW_HhWJH3Vu
  hVuj   PuVÃ Q|5	V|5	Yu|5	   SE	VމP|5	Ǉ       9UWVS]T   }3ƃH   t
K      U   uZ   u+  uh   5	     t(C0t\  t#j S蓲u1ҍe[^_ÃWSY   u߃P|5	뉍v    P   j SuFUE   Eɸ   USuj ]SWtƃH  ]UUSB0]t1}    tAtt1$Ë      싂      UWVSU2EE\  |        @    |    1tR_P     tvt]Eu0} u(ES   uF<F@O_)Ӆ~
1e[^_Åx whVSE4   ڋG W$GWV0F,돋G GW$WF,V0W58G0fPªG0    Nv 3|5	$|5	GP    UM   1҃tHtE   t
tL  
tÍv UVS]ƃP   uS1ue[^Ív hS
u߃hu?uƃP  뽐UWVSU  tpj:7TtTv FtJ謭 fP%    fuE  uNU  t(P7hmuu	u1e[^_Rj
7h',uQj7h,u뚉UWVS   E 44h  x  EUx|EUEM4      uME%]E    E    E    e  4|    EMA0   t4|   tE   4  Eu14z   .  }  U$Ev h4tMp    j uuu)  4	   u
   d  }Z  }P  EƀV  M    4X    Eǀ      4    h4:u4    hC4u  Wh;hCPl4  M    [^h4Y  4   t"E     ((  Sú     8   j:Pt  U  n  M  ]ǃ      ]K   }  T  oi  ڋ      9ˉhb  4P  SV/d
  o߹Ih`׹I\I\+`@PXx5	T  d)RSVP \UT   P)X`)XXATdQ\`RP袤4T   2  T4ƉP  ƇT  4   u>  v }  h4sH%
UBE!  4x  t  	  g  	   4      ]    ǅH    ǅL    4t  +H @  v @  4  Sju\  1HL9  4t  x  L13H	u4  ҋ  x1>  4+t  x  ҉      v 4l      }j  }`  }   h4   }|    4  
  4x  t  	u
      RPRPp  h #[}|   M|  u   v e[^_Éu4u	u|   tu}K   t
T     %R4X  t
U  u%P4  t8 t}t  uv %PUBu%PM  u%P4   t8 tUp  u%P4l   t
}|  u%PUx  u%PMl  u%PSEPuuh@|;4]x    ǃx      u4d  uU
  1ۅǅD    
  tq@CtKD
  Dss'u%Ph*| uDuj @]tIuED
  u3Du'u%PhB|(DDt#tlVjh|mƃu݋4     EP  P0ZY0ppPl  RP4 p@u   hh?  u0W4  0	  v	  Puh2|>|uwMA    Sj j 4}q  }  }   Sjh|=j 4j   Pu| t_hJ4{8]S$C 	LQRP4_up**    MU 1y H!R1y HPȃPjjjj u@  ƃ v}V  ǅp    ǅt    uX4D  H  !Aptu34<    Ipǅt    4   uh%P4  h4  t  t  V|u4jU4<    P   ut   ]Cpt}SKCL   Ǉ  $  PQR4vjh|ƃj 4u  Pu|` t
hEpU H!RU1z HPtxp  Rjh|H'4   u1Pp<  |ƋtpEUPphf|ltpt M]Pp4<  |uPjhk|ƃ뢐Pjh|iH4H  D  	fWtpptu
RP4膶EV   !EUptBJZp   =4ƂP   Mh |+tphs|Tǅp    ]}MV   $  ǅp    ǅt    p#t@t4      P|u4Pjh|Ptp4"4$      j Pu|/ t
hsUt pH!1RHPEtphs|4    pt]t}V   t`h|Sj 4j   Pu|E t
hj j2]P(SJ-  U4  M   A4  ǂ  QAL   u#qqhs|Q|u4EPSE    5.   RuP|Pjh|yPUrr44$      j Pu| t.h40Hu#E PEj Pjjjj u  ƃ h@4l0"   hVuhWuhh|)ƃh|<zPjj4  UB0P4h    uEP4d  j4  Vh4< ?54    p  hMU|          RPhuM]|  MP|5	h 4U|  u*4p  h(M]|  P|5	ǅx	 h4m.    LHh 49.   j RP  уYh:ǁt      ǁx      11|EPQh4P4  u!#hPW-WjVhn/   hƨu蔐t@t{ t:~41o   a   PhujEPJLPXDtD	At1롃ISjuh~VP  |5	4P  P|5	.v }G0   f   f=t]P}N  ru%Ruu%RhJU   M  MN  ru%Ruu%Rh]J]  먋Uf   fPLMA0t 4|   t    !@t,4ƀ   4   bEVQSt	ƃ  ǃh`4V+   }t  '  XZ  hIt     whRZ4  MFv hS	X  hI}  v UƂV   P|5	]ǃp      4EEEjjT5	E   U4|  JUEt
P|5	USP]S&  @u]UVSu1ۉ  C#ve[^ÐUVSu]u'tS5	Ã۸   t1e[^ÃP|5	    čv UWVSU1E    t]j:u膅tu+uFPx5	tNPVuS臎 YE0EUt
Ee[^_ÉGPu!EܐE   ˍv uuېUWVS]u       h   j ô  S膐1E  Su	F#vݍe[^_ÐUVS]  u   `  uyQjjS  XZ  d  #u<t#Ct@9d  td  E   ]e[^  P  hSN'뭐S_vv t
`  u
QjjS_  ˃P%v USP]Ct
SPt`  ǃ      t@q  \  tƃ`  1]Ð{-  m   	  d  X|  $X  Y  $蓖\      T   u~p  XZjSF$  X  fX  ZCuS$|5	-QjjS!  SBHBXZjSM  ăP  |5	kX  |5	Jp  |5	3_C        SX`  [  rv UUVSEuexWjj5	ƃ1t'?v?Sj5	t
^e[^ÐV|5	1   뢐y
   딍v UWVSu}   t|;w}/4Cz  ;_|E9l  
ǀl  ~:    P75	Ҹ   t_9}
    C9|w1e[^_ÃVj U`  Hо   Nv UVSut01;^}v 4C\  ;^}6|5	V|5	e[^ÐUE:	P:	P:	@L`@T@8    @t    @x    @|    ǀ       ǀ   ǀ   @<@@@,ǀ      ƀ  ƀ  ǀ\     ǀ<  <   ǀ(     @8  ǀ8      @    @$   ƀk  ǀ     ǀ     ǀ  ƀ4  ǀ    ǀ    ǀ@    ǀD    h   PÐUVSh  j5	Ã۸   tOǃ  h   x5	p     uCt7p  uS$|5	e[^ÃP|5	ӋEᐃSE  $ǃt     ǃl    ǃ|  ǃ  mUWVSE1='  ]u  ='    [  [  3u  3=  "'  "      we
tJ
w t   e[^_Ë$  tuۋ  ؋    ǋ  뱃tGwu    덃 t!x  r  e  U  H-)  -   *tw*w)  +t+,z       s  t    w  /td/r.0t2p  q  r|  tǃ     R1z   Ltǃ     ƃz   %ǃ     t    E  E  ;   ;wL5t75r"6T:y  u  o  =   =r(@tDj4  d  WU싓H  ;UE苃D  |;Es  9<  tEU쉃D  H  j   Pǃ<      ɋn    P   PwsJt^Jw"GW6`  SǃKt"N  s  c  STtGTwQ9  3UtZSps6     ǃ     ƃ|   6m    =   .  =   9  o  o  e   ewq`t\`w\lD  fbtcQ  HH  H=?  4ǃH      %  jtrjwiv  ktnh     
  tt(       @  y   yw_qtMqr/rtwT  N\  `  :  !X  =   tN=   w=     =   t=   d             t,  m=     =      =      =   wZ=   tC=   r/=   t=     <  P    =   t@=   r2=   t=     6    =      =   w}=   tX=   rD=   t=   WD  QtH=ƃ  8ƃ   ,     8  9  =   tL=   w=     =   t='    L  H  =    ffL  t  d=w'    =w'  >  =5'    =5'    ="'    ="'  n  ='  V  ='  wy='  tb='  w!='  6  P=='  t='  6  P<  P8  P64  RP0  ='     ='  w='  s  m= '  t5=!'  T6  Pǋ  r  1\   u$6  Pǋ  X  bX  |5	ƃ\   <  j   Pǃ       =*'    =*'  wo=''  t[=''  w=&'  6  =('  t=)'  `6  k  ǃ       3=-'  tw=-'  w=,'    
=/'  t=4'  6  6V`  Ҹ   `     6  6   =c'  <  =c'  0  =Q'    =Q'  w=I'  tk=I'  w=7'  @  :=N'  t5=O'  !6  Pǋ    6    =\'  tx=\'  w=V'    =]'  tB=b'  6  PH  Pd  j Sl d  r6  v6  f6  V=m'    =m'  w}=g'  tf=g'  w=f'  6  =h'  t-=i'  6> VS /6  6  =q'  J  =q'  w=o'    =t'  t.=v'  p6t> tP  oFC6   s<RjjSq  SB@BBt{tGBC   Btd  uBd  jSf  ?P`Sփ3&MS막QjjS  {t;Sd  9Bt!BHBjS  C    2ǃd          C    붃6  b  A6  E  !:	  ='  -  ='    ='    ='    ='    ='  wb=}'  tN=}'  w=x'  T  ='  t='    6  8  p='  P  ='    ='  H6EhTVtd  έ{hXVtd  Sh]Vg   d  tfV5	tIPjVht(j j FPjd  S!V|5	j j Vj ٿ   ljj j SLd  냐j Sa='  t='  +6  6p  6  6  	='    ='    ='    ='  w='  6$  ='  t='  |  6tD  H  !@u0V  Pǃ  <  ǃ     J v   كj   PXH  D     tD  Qx5	EtH  D  	uE䉃  QD  Vutx  ='  tT='  w='  6,  ='  t='  68  64  |60  l6(  \6  L=N  H  =N    =oN     =oN     =+N  ti=+N  w='  6@  =,N  t!=XN  `    \  ǃ\  T  ǃT  `}=N  tK=N  w=~N  ]d  W=N  t=N  >  8h  +4  X  =u    =u  w_=N  tK=N  w=N    =N  t=N  @  t  l  =u  t}=u  w8=u  t=u  yV\  +V    Z=u  t!=u  AV    2V    NU苓H  9ʉM싃D  ;UV    6<  L  v T   u$6   PNǋ   P  P  |5	ƃT   USR]H     tPi   tPi   pX   dX   XX   LXl  @Xp  4Xx  (Yt  Z|  X  X  X  X  X   X   Y  XZj   赾  YXj   覾  XZj   藾  YXj S1yXZjS'y  $u$|5	]Ív UVuS      j S3b$1҃   1Ƀ   t  ƃ      t  ƃ     utƃ   V        `  @,   F,t&RPhcSG	`  tV,     j Vx$   uVǃ      e[1^Ã  *  X    Y    빐VЃbP|5	ǃ       3USj juou1Ë]ÉUSQ]Cu	1]ÉP;It狃  tu׃   tθ   UE@u1҉ÉPH   uUuEpP[  HÍv UMUt
9t@u1Rj PQ苻     UE 1҅tUWVS]   uE    1   ua  V~t
} tƃ     V[t
tƃ     Eue[^_/v   R9u   냃  69_EVUWVS}t27t,^ƀQ  PGj VWk  ۉu֍e[^_ÉUWVSuUE1`  ;x}zv  E tb  @  EBE{,-  }   Eu/   t	H   t2Ps,h`uU`  G;y|1e[^_Ív MQ0C0  @ %  @ 9tE`  ȊJ  8J  u} u{( uۋMK   #    K   tT   t
T      t   U9   ts} Ouu{( tE   C(B   ct؋EQWhP$U`       v       8n   M9   YEP      t   U9   tJ  CpPEpP   M   f   Uf9   B0  @ uk   uOE  ?   U   p$   M   N$  P  PYm   MA0[  X  tVQ.DP0Cv {,UWVS(EPEEvE`  1ۃҋu}t!;Z} tx( tMC҉t;Z|Ex.UUP`U`   U    Ee[^_Ð      WVUv;E~E]E`  UE@( UWVSu`  1ۋA9Ë}}
< tC9|;Yt#_,G(t
`   <7e[^_ÃVt`  pShV밃h UWVS]J  ҋu}      s,   P|u%Ph`V7uEP   PWS5 uIEC8@  {4wF$Sj    P            tE  e[^_ÐhV   Ӄj Sj    P        뫃jۉ   UUr,   B<PJ   t   Ph2: Ë   UU`  @ u1ÉQuuRUUt
`  @$u1ÉQuuRUSSU1ۅҋMt
`  @u
؋]Ã QRЉÃv USPU1ۅҋMt
`  @u
؋]Ã QRЉÃv UWVS}] Q  E    3t'R   t`  @u1e[^_ÄujVm   uaR   u`  @uEuƃR  E뱍EPrEU쉓      `  <$SPE뺉S+둉UUBBÉUShP  j5	Ã1tLEǃ`  ǃ   ǃ   C,ƃH  PrEU      ؋]UWVSEh  ]PpShUP  Ee  E  PU   ShMP  ]e H  j@U   @Za  @j?P)Z,  ǉ1ˋ}RQUKuDP^SEV@PcM/ <?   U   8[tUD  tMAl1e[^_ÉhP^`tj Pj
EPRfU:]thuP1QRS]M   mEplbP}1QEu@P]M/'Uf/ v j?M   XuE   hUP  c   VjM   htE@pftp EH0   	SjU   htMApDICTAt QjE   hitUBpLDAPBt 뗋MAphttphu   6hS?M</tNj/uWt"x/t/W1QRu5\MApfileAt B΀y/t</uލQP1QRu[UԉUÍv UVSu    э\  	    u        ue    	t?QRPh         t	ƃ  1ҍe[^Ð  5	뽍v   |5	ƃ   Ív UWVSEǀ         xpW3u%uPWh u   e[^_ËC4UH  tր   tL  tŋE`  Cu!C0U   fC0f   C4	B01먃uЃuU`  ŋExpoUWVSut> u1ҍe[^_Ív Vh2   u1؉Ij:uM1U   EU)UE    E9EsU9Us!}7PhTtE׋]E9\v ;]s3PhTuCߋU<2.t^+}E9ǉ}vC}9]rv UP)W}R7PUt͋E9Et	Uz.u   BU뜋U׈IMUWVS   h]O 1dC  d   \   h`Cp{pt6v    `G`=     rT u`   fhPtW; t(ދdtd|5	e[^_ÃhiuăhSƃ밃hPh
tuPh   hPPh$
Ãҍv  hdUWVS$  h}WVYtxj@WqR   PSh!Wƅ D]   U   ǅ    j j SuU    y  ǅ   uBEƀM  FP5	2  u|5	߃]tu|5	e[^_Ð?[   j:PvQt_  j j
j @PXU   W5	U      Zu|5	E   H{j/WQt  U  tGt*M^ fP%   fu:t
%t.uFЀ]thu Fǅ   E   j j RuU    YJv UWVS  h   j 8Pu}[h   j P[8     <  uVj j SV[      u
e[^_Ív j j PV+1҃J則   ɉRh   PP[ƅ 닐Qh   PS[E aUWVSu] E  C05   t_j@   O   tB@   E  t/ƃL  ::   uVh!RY> udE8 u
1e[^_j j Pu9Ã۸   t1I   vS|5	뵃Su\j j VuÃ۸   t1I   vS|5	XSV\Suh*-v UWVSEPh@}   XH  j:   fWƃE$         f$  f   t K   u
1e[^_Ã_pShm>1      Eh  ϱu%P   PN  ru%R   u%RSh4Ã ۸   lET   uUP  ƂT  IP  |5	׃ShI?j j
EP^SYU9: =  w f   VPhGu   }]\   @ƇN     j]PL  F>:@19UWVSE]E0  u}   4  uh  ƆZ   ue[^_Ív   Wu   ;h  uƆZ  ƆL  ɋ   EE]e[^_Rh   PWWƇ    |Qh   PuWEƀ    Qv USP]C0t	L   tIu5	   Xu5	      t
   u   ]É1hb5	   $l밍v UWVS}  1ۅuE    J    ttt9|uӀI   t3EJ        u
Ee[^_ÉQ   PVWR   PVW   t8 uo      ESPR   V}f t=t/EtUP   h|WdE   EE   UP   PVWAE$P      Vf t'tEuP   hWE   됋E 닐  UVS]   u    PWL  L  A  M  M     J         |5	                        XƆI     X   X   X   Y^j     XZj   ԟ  ^Xj   ş    Ee[^   |5	o   X   v            ǃ       ǃ          2X   &            ǃ       ǃ       qP|5	3UWVS  Eu     E  P  ǅ    ǅ    u   e[^_ÐÅۋE   t@       1҅3t8 t1҈J  t   wK  8  M  n  T  0  L    X    Y  FtP*t    hZ蹜    $Z觜    $Z蕜    ɉ  j    \  T  P  1эy   w   d  E<$x5	d     h  Wx5	      e     SVEM   s    7    @      8   d  8 U  C0     wЃC0ƃK  ƃJ     t4PP  CpPh  P  ƆT  c0SV  tWSV3C0       @ tK   tƃT  PPSVSVPPSVPPS        (    ,       $    (    ,    P  P	Q   "            1   S$|5	   E҉      Ps,hVC<P  P0Q4$h\        @    |    uuSVL   zSVrQPSV`  PSRt3ƃQ  SV!4$tV`  j WSPj jj j jjjS訒  ǃ 몐6뙃&   ƃJ   ƃK   ƃM   ƃT   C0P|5	ǅ    NP   |5	ǅ    SP5	hVy<SVrqjh @  5	     CUWVS$ujSd1F1tE1 e[^_ÐE     Ɔ]      C<    ǃT      ǃX            EPuVSE } uVƆQ   ]   t  t  ƃ   밅cEPVUE艆      >uVluƆQ  듃jScXZjS	cEƆQ      tV뀃p  ĸYX   h*p     v UWVSu EVP}Wuu&  @u
  @t/E tue[^_ÐP    Eu> uQuPRÃEttPu\U1ÐUWVSEEE3j V9XZSV[   u)    @Bt   uH   u
1e[^_É   ƃ[  3     	  C4   `  P   1S`        u`H   uW} uQ{,tKSC,K   l  t(   Ps,h V E     :   փSOu؅tԉЃP|5	ǆ      cPEPuS҉ǃ3PVV[C4    v P|5	ǆ       P|5	ǆ       UVSE0ƀ[   ƀP   ƆP   VE^$SEUC0C8x     yD     p  CLS4S<C@C    C    ƃ    $   V_4$  j j Vaj j V`e[1^ÉUEh  d  9Ɓ    Ɓ   }B   ÐUWVSu8PEU`  @1ۃu
e[^_ÃuRЃ7tuߋE8 t׃ujǋEI   t؃h@WSEƀH  j j7EPt7uEPEPVWEe} Et4j P1=BEPuA&E`  uPRÃ&v UVSu`  @1ۅut	e[^ÃVwVЉÃ֍v UVSu|  t9  tP|5	ǃ|        e[^UWVSEPj uuN1ۃ1tRED P=t7t< ~8<t4<'t0<"t,<\t(3BCuW3 De[^_Ív 3\CѐUWVSE EE   EEh  ,EE jhsS]11  j:S8tOj:CS8t1  Gj:W8t  Fj:V8t  t; uh{ut? ut> u	SuÃ۸   tCSVWh uuSLCt%huu1e[^_Éj juj jjj u  ƃ ЉPjhS"PjhS	QjhS   j:S7t7j:CSu7t  Gj:W]7t  t; uh{ut? uSu@Ã۸   SWh`RjhS9IPjhS 0j/S6B1Ʉt<:t AuRhuuT ڐUWVS8EPuE    ,;x+]ԅtCt 9tuuDEЍe[^_Ãust̠E؍EىEǹ   1fCuuPV@uEЍEPu
UEǀd      ǀh      UWVSU]U싓  E҉Ex
  uL  UMd  h  u1e[^_É  PS0Ӎv h  d  Mt    9  |9zh  d  uuELMb)  9~P  hSW   ?QVUWVSLE EE h:N  h*huE    E    E    E    E    E   E
   E    zUP  h3RcXZEPMP  ?1ۃE   P<PhCuE>   E܅uq}tUEu@Eȅtu7j jj j jjju舄  EƀH  EЍe[^_ÃP9Ruh u땃PA끃EhRpPt   PXubPh@uXEPhP  j ;uVjj ;M  PML  1҄t   R1҄t	E   RuK6ۉE    SEPj Eppppu: Et+t&P_;PhluE'   tuuE    -5ETuuE    :2jh|juE j ujuxjh#jugURuu!>E  v QuuuQ4E      Ív jhjuj uju jh/ju1}Iv%}ыU|
      0pjuj h#ju}3Xu>jh#juQYu<uuu5Eu<E؃u$uu2=EEBj Pq2̍EP0pM1  -Puju_u|5	
WVjuE   8UL  1҄t	M   R1҄t	E   Ruf3Ẽu̅ u8PhuME&   E      v<EU      hu E   rUWVSMɋUuE1۾I9M
1e[^_Ív Ru=؋}эA؍v Puh5:	\뺍v U5Ív UWVSEx  h   UE  uP.   U        ǹ1IP$$QS/$|5	4tU h @  R3E8 th   Pw-uhue[^_ú   P2Cu1U=5	 Et  u
  tP5	1Ív USS]t; u   Ћ]Ív hS   u܃hnSظ   uhS辸*   uhS褸1҃J+UWVS}E]0    E    G  S:  
  HtWShV1e[^_ÃWu6Ht
h ԃut*   t
h멋]u:M   RPuu7HtEtPuhou$.toP"1Eu3W7Xu6t
v    #h P|.É<$R/ZYPSY2$!9뤃h@}9v *t!+]Lh      {-}tU: u
hx  Pu   *t>Pu%3HthVU$i83S[8h h@ v *  +hWE    M4  j P7E$3E  W2EPEPEP  u- u0j S3$@1PhVuYu,Ru,XZuuK)Ht%h V;_uN7^u)uu1Ht	PWhƃux4   EtP*1ۃu#u6Xup)E   u*9}˃SuS/Pj ju1t-Su0/ZYPuu0tCPWh h@SWhPWhPWh h v PjWu 4 v Pu4XZh u*UWVS]3$+.h   j uPy,ǃ EPj jsV,U9s2QSru0E 4$,1e[^_ÉK͐U  u0h   RP.$REÐUS]uSu(؋]Ív Uu+,)ÐU2 0-UjEPE   (Ҹ   ~É1HUWVS  }Wu(/      u]S+t   1e[^_ÐS'Ph   PS0$PWh`VB   뼐P&X   ?'ǆ       |PWhV5   뀐USP]   u
1]Ív h  P&~"   ,PhS뿃   ,PhS\6   띐UWVS%11t1S,ZYPVt%tSp-uωe[^_Ð߃W1v USPE@E   Cu&Cu]ÉPC%C    v P[%Xs%Xs)1C    볐UWVS   }U   `1  ǅd    \  `@   Ph'  jU   .f  SjxUhP   &ZYP   Z%        (.A'0PhPSa+Ph1U2   V\   u/`p/`B    de[^_Ã`r%t/Huh \똃uh@h׉   \thH\`-h^\Hv t,$&0h\ǅdhs\a`r#U'v US]j /$   u
1]Ív P"X   C#ǃ       UWVSE	E    E    H     |
Z  1҉
0<	   B	~QB1TAQB-  U      AQBUAQBUAQ	Y
BC<	w Q/~9ÍҍBUUҸu%PuWuuu썆l  Ph uui1ۍv e[^_û   E   v UWVSu}Gt_<*t-P被$蕫F8t1ҍe[^_À? u   > tWVFH   tπ> u1Ҁ> 뾐UVS]ۋut; t	t> u1ҍe[^ÃSV   uSV81҃ʍv UWVS0Eu }V   jE E   E    EE    !tE   E   j j jUu/(EtZP\!9E؉EE    }1uu%ËE9  EȋE9E}} tуu.)} t%Pu   hunE؍e[^_ÃuE%&tPWj
V%x鐅xAWV(P&tP&   WEP)u%   uh`u$3   N}   Vu^E܃  ~7   uhPE3   EP?#u   uh uAQuhE    1RW'-Vh  h@P*EW'SPV&E s&}EtA}s ';E]ЍU9މEu   u֍v UEUuWwJ$lø۸Ը)͸6ƉB뽐uw$J뤸K띸X떸l돸x눸끐UUt#tttÍv UWVS  E uU   8   d     }      1H?tvǅ%ESVSPhh   Sj PSj Wj 1}uuPWe[^_ÅtRyǅ2   [UWVSEU2   U@UVE       c  u  ~[  G   ËG$  SG  d  t
     j h  j w%#  X            u     P    wK    t:  uP  uPh@V菽M   e[^_ÃhV  uP  uPhV(     'Y[PGp"tRj(  P#Ht&P(  uPhVR   QhVi[XjGp
%(  uPh.V<Qh1   PwM4    G   wGuh VB   PG    Ej Pu(uRuw.#u,j P\"$Ph`Vٻ#   Eh=V]uwtG   1j P!$DPhV랃P$R8  wVЃhVDhv Pw<hqV;   s        wub :   <j h   j wv Qhj
PuhV?uj jwf%h ΐh@v P  UWVS(  Eu@   >s&"   PsN      C   ǅ     =   = 	tyǅ#   #tBVh   SPKStPhBWXe[^_ø%ߍv u      h`W%#   ̉ǅǅ<   xv C   1룐C   v C   s$PhW[ĐUSP]۸   xPuSu9]ÉUWVSE  E}1E    эqUӃSUx5	ǃ   t`uhSWuuD>PMD9 XZWUBM4õt!MAMW|5	Ee[^_ËUBM4E   ːUWU1IQRuuu}ÉUWVS8  uuhj P1 ;]   |>PRhu˶PRuube[^_ÉUPhWVC;]|띍v UWVS  u     ǅ`    u9`  `uE$\$Xh   hRPS.u%RhPhu踵 j j S\  dPj js\1ۋd;s)v J<
%   <    ;rQC;rQRhu5PhRuu\`FPXW)¸   h	)PXX di;[FC< L;rCC-s\1ҍe[^_ÐUWVS  }1;|5SPhu4Phuue[^_ÐGP)¸   h)PVCƃ;|뚍v UVS uP$XZuS+EPj jsS=EphV虳XE0phuVZSye[^ÉUWVS]uS#  Y  [jV5	   tG1ҍe[^_ÉUWVS8  E Epb   t.bZYP^   t
e[^_Ãh襲ǅ    9A  h   RPǅ    $Ph& Rh0h   P$pRh8ʱPhG]0PÍ@PhN脱 Shgh   PRhk8  ƅ x    19E    ƅ    2Ph   PF0rw  @Sh   R0Phs膰Rh@h   RpPh-Rhh   PF 0b
  %
    I  tnWv$r91|BpPhBpPh	h   P RhxBP  P;  P  P%  P   P$  P(   @,Pxd  PBp,UY_SPhhƄ+  DP뗃Rrxk  ~BNPBp(XZSPhhƄ+ U 륍P됃R
xk  ~BPBp$RY_SPhhƄ+  륍P됃Rr
xk  ~B8PBp 
XZSPhhƄ+ U 륍P됃Rxk  ~BPBpR
Y_SPhhƄ+  륍P됃Rrxk  ~B"PBp	XZSPhV	hƄ+ U 륍P됃Rxk  ~BPBpR	Y_SPhhƄ+  륍P됃Rrxk  ~BPBpXZSPh?hƄ+ U 륍P됍v tBP
  P  P   Pup@wP
xP  SPBpXZSPhhƄ+ P뫃RE
xk  ~BbPBpY_SPhhƄ+ ( 륍P됃R	xk  ~BPBp%XZSPh	hƄ+  륍P됃RE	xk  ~BPPBpY_SPhhƄ+ ( 륍P됃Rxk  ~BPBp%XZSPhhƄ+  륍P됉BP  P   Pup@PxP  PBp|XZSPhƄ+ hk"P뫃Rxk  ~BbPBp
Y_SPhhkƄ+  륍P됃R-xk  ~BPBpXZSPh	hkƄ+  륍P됃Rxk  ~BPPBp
Y_SPhhkƄ+  륍P됃h蓥v QRh#pPh@ av WRhU0Phq Lv PhPRhˤv Z19HЃ:PFPhjW 9Éډ||ƅ-Xv Ps
PPh O Shgh   PQeUWVS  }E=   uǅ      ǃ     v7
Fu- u3   e[^_Ív h SݐhS袣h   RvK$t5 uvx #   F    닃h`S谣PPhS4F @h   R0PhSF @h   Rp^PhS͢  tvWdK  Ph   Rv~$tJ u.ǅ#   vqF    F   yhS螢PPhS",     h$,  m  j j j Pu
  WXZvtH u(vXF    S   P,  hSաP,  h SZX^v
  ta  t6 uǅ3   PPPh@S\PPiPhSڠfh耽 u$v$    <$Q,  hSŀ uvW,  h S ސv]F    VW2UWVSE]@   j EPSE    U[1uBE싈  u%Rj VSuF   e[^_Ív PjVS׉vj PS
th%u뱉UWVS}EUUER      V҉E#  BvKt+tU F    1e[^_ËUF   uWu֋V뽍v Pjj WQx|VBw51ɃIMJUP1} H!PQR~'uWcVBv:u+} tE  <hAu贞   $.0hu萞#    Pjj WxuWVv UujuuZUEPj uuE =1H!UE@E   u1ÃPUVS   Euu@u   8x	e[^ÉP   	C1}׃tPRhX6ixRP	Pht҉uă0h@뷍v UWVS   Eu@Uu4   } x؍e[^_ÉP   MD|
Ѕt60PhPSV Ph1E0臜ăUE M=_ w4p E PEPPPRhuuÉ  t`EÐUh  j5	Ҹ   tKE |      ǂ      ǂ     ǂ     ǂ     ǂ     1ÉUWVS}|  1ۉ  t*  tC'~e[^_ÉPjSW  RjSW  ǐUWVS]   }UMtj         {t)   t   tt1   ptO'7 tPVWhSk e[^_ÃQVWhv 1   H%뽃QRWh뿾뙐w E}Ee[^_M}E]v UVS]E3h @  EEjEEPE   xuuh3e[^ÐQ0hVUSM}]|  tx  tH~
t&t$Ë  tHuǄ        uǄ     Ǆ     ]E   M$v   t~tt놅uǄ     ]E   USP]M|    t   t?t]Ð  tHuǄ     Ǆ      Ǆ      ǐ  t+HuǄ     Ǆ      PQh   S/Ǆ     냐z  uǄ     PQh   USR]M|       ~
tSt]Ð  t-HuǄ     Ǆ      PQh   SÐǄ      뵍v   tHuǄ      Ǆ      댉Ǆ      PQh   USM}]|  ttDtK~
t)t$Ív   tHuǄ      ݐ  uǄ     D   ]E   M$Dt~tt늅uD   ]E   USP]M|  Dt~t:t]Ë  tHuD   Ǆ      D    ΍v   t(HuD   Ǆ      PQh   SD   뎍v u  uD   PQh   ɐUSP]M|  Dtx~
tJt]Ë  t)HuD   Ǆ      PQh   SZȐD    뽉  tHuD    Ǆ      또D    PQh   볍v UWVSuEU1ۀ   EU}l     P}<tPhV詔   EX   @E  hVs'}  b  P4hgVE}'2  E-     PU4hZVXZhV  U<'  Ѓ#  #  w  R4 hV赓UBA  &       U#t\#wtR   9r)Uu
e[^_ÉE#ue[^_BQUPh,VC+9r빉E QEPh2V또'uUz uhV   ߒ9kUЅt*JtRPhVC賒9r>h8hكh<V腒hBhNփhR̍v Q4 hZv 'cPUPhXfEeQuh	PE4 PShxP4 =   QUWVS  EdL   |  Y  d  tlhhRWh|3(  h^Wyt?PjhP  PaƆ'   ǆh     [u1ҍe[^_ÉhWyt+PjhR(  P
Ɔ   ǆ     몉hWNyt@hP5	   tP    ǆ     SQ3hdԐ0   BR3hd跐1   %   hh   hPIXZhR  A  ǆ     _UWVS	  E |    +  P  Pj<  @#    #   te[^_Í  1h   h   Rj jh   h   hh   SS0h @  VSE   x&PPj>ZR0h;뽉'2Vj j'h   h   hh   P辬   ۾   t ;1э<1  v[uh   h      h)PPd h @  VPE   xFQ0hdۍv PhPh3PjhPj    h)PPʫ -(  1h   h   Rj j#h   h   hh   Sj0h @  VSE   #xW0hmUWVSE} OE    EE|  t_EU  w@$Xǆ      u`ExE+EPEEPjuЏEOEuMxE)EEuEPju蚏e[^_ËEyċUU뼀t 
tEyEEǆ     ǆ     ]-   w$|ǆ     eǆ      Ph   hu<    ǆ     !ǆ     ǆ     ǆ     ǆ      Sh   hu_   YXSuǆ      kSh   hu)   XZSu,Sh   hu    YXSuSh   hu   XZSust!    9  ǆ        ty    9s#   @9Љ  s  @        Ph   hu Xuǆ         91  #    9s$   @9Љ  s   @        u<UWVSEH1҉E@}tTUEBU   ty1ې   EPjjEPfE @7   wu
9|M؃}ue[^_ÉEP)PD+P   WE    ]܃ E   yUS]|    7X|  |5	ǀ|      ]1ÐUWVSH}   7Eȍx  EE WEte[^_Ð|  WEbuڋEȉEfE E    fE Ph  jEP7  tfEf   fEރfux  u!} uj jj j jjjWW5  [EЃP      uu;  |hVɇ   E 뒃EPh?  uuWcẼ ~AQPuW&EKH@WE@   %E v Sh   uj PuWEPuE UWVS,  Eǅ   8 M1ɉǅ    ƅ ƅ ƅ ƅ ǅ    d  h$uƅ    v     PVh   StsPPhSFtE8 tE8     n  t}RPhj  u	ufV u( ue[^_Ãu|5	|5	Đ t9t!Sumƅ OPj?Su〽 t/u
uQj?Suƅ 	Sh0mtƅShmtƅShl   ǅ    v Shlv   lSult   ǅ    E1>ƅhؠtpƅҸMhhϱh]Eƅ9 u
|5	Q$t@rUSPUh    @P    @T    @X    @\    @h    @l    @p    @t    @8    @<    @x    @|    C(ǂ      C    Cu%C(    C    C    C$    1]ÉP|5	̐UWVSE111ME    +   t-ʁ                  t+   e[^_Ëu+   t   `     x     _               wO  t?  w#  uP  u%v 1s  bL    ؁   t6   r&   t   .  믋  􋀰    듋D  닁         w4   t$   r   0  륋  띋  땁   t=   r*   t     f  [  P  E  :  /
 0   
 0     0     0 wL 0 t6 0 w#   
      Wv     0 t? 0 r) 0 t	 0 ߨ  7ߨ|      ߨ  ۋ    닁 0     0 wf 0 tJ 0 w% 0 P  @tߨl  넁 0 +    %   tߨt  S @ t^ @ w! 0      @ t" @   UAPdU+P&苐    ߨ  Rj SPzŁ  0 t   @ YUU} +   ^}+   O]+   ?UWVSE8   ]t
   
  Sj     =      =     9wt   u	   uE01e[^_PhfjURË   )؉   USRP   9f
tƇ   E     h`W}   뇉       t   
U    ^v hW}E     *   <v UWVSET  E t+1R;IQu3eu4[u׀}tPjuh.etEEe[^_EUVSE<     ƀW           @     h  uB\  thS|A   e[^Qj j   1@uR  jSЃPhS{uv 1PVh 랍v j j j |  ЃtQPh@zv USPE1@00   t
   ؋]Ðj PuUU  +E  Ƃ\  ÉUWVS<EE      UH  u @  ]ǋK!@t!{@ uE+Xp19|9s߅  E    ]SC	uS$C 	Z  ]UE uE   uE  M       y@ AT  ]CT  {@   E  U      }    MA0   ]   t*H   3  UƂ   h4uzMx  t  	tExd u
    U    p  u5]   W    }  t	7  9
  M   M@U      t2ZD  urPp  jQ耀] {D  U      Urz!@  U]MĉUKM[]9}ĉMȉ]|K9urDEXMHE)ȉEtE      )؅E  M   ЙEŰMAQQRPul]       E  CDu}    tM    K  wPM   -  ]            h`ubxE=   E܋]CD    u<v } t
E   u
nU   t
1e[^_ËMH   thuw]   ˋM    pPuQu#0  EX9E    CupTjukzΐU     PuRu/.  1qP]p  ju,zE3UBDUBDgE    1SRuuWVp0Mh  uh Qv(uuUBMRYEȉŰIUBRỦEȋUEPurTuK%  @@M   EX$RSh0v^_SuttQPhu@v8   +hPu&v   uusTju| ZuuEpT݃h uyuEU Ƃ  9]   h`uBuM]ƃ  U       .hQgu!   RE    =} 
hEPEPQuuE     E} } U   v juC|EPMEUSxCtkEPWU   Md  QHy _EgUWVSEpTUrXMP1j
V]C\
  )@M)]EBCT)uFPM؋t  9rL@49sƃEUxLp  VP)5	_
  Mp  t  uFLVSEpXpL(UBL؉BLZP  BLB\MZHp  ۉB`u
zP  ]K`
	  
	  ]CH@CHHP  ]    uu     Pj
uv`h[&  M   
  k  
"  Ph5huv`!   EƀH  uw      t   E   ueMqPq`Sukuu=]CPu  F<p  CLCP    E8 uUBT8 1ҍe[^_Ív uUrPr`jPx |Ph;hCUr`3 t MƁ   uw   v Wj]s`hdeZtuƆ   Vj	s`hm?ZuQjEp`hw%Z
  U     Mq`t fP%    ftFPjVhYt]ǃ       ]PjVhYtuǆ      6PjVhOYtEǀ      PjVh\YuPjVhGYtUǂ      Pj
Vh YӍv WjMq`hXtk]s`t fP%   fuFj j
j V0uFhVlux  t  11ȃ	<E@d0Ud  tSjMq`hkX  Pj]s`hMXt_u  u	m   tIj [^EEPUB`P]Mm        Qjuv`hWt
~p     RjEp`hW   UJp     c&Pj	uv`hnWv`   g8 tVUu      P5	M      )uP|5	^PMq`qpuDˋ]Kp/Qjju*  XZ]h  u  u   PUB`PjMd  Qju*  PhhMq`]ƃH   hu)mMK   Ph5h]s`uU   ZuƆH  h 뤐K   /Phh]s`EuU   uƆH   h`Tv`ú   8 u	PpE  BU  Vjs`h%(UUC`j j
j P{u`  \  ރ	t
9|<9w8xMQAQQRPuG]ƃH  RPhh-ul?   v ރpEV   PEPhQ#   PVhEp`Uǂ   
     UBpM  ]L     ҉  m     9~	UL  Mt   tX]Kp  ~J         ]x  t  	             U   
t|
~]H   uƃ  uFp=0  t=0  I=   mE  tƀ  U    B    B    B    Ƃ   /=  뵃huiMƁH  zPEpphu:j   EM   &uL   u   Mq`uituEFp      ǀ   
   MA@ gEu   אAC`8
  EHpAcC  UB|B@BH    t   B|        u  uw      t   EUp`p  )VPSukMQ<]  Q<KpAd!EÉP@x  t  	tE  6  M9    Uz@ tuUp  BLBP    Mz      ]]K!@uT]SC	u]E8 t
U   M   uV]sXjQn PQRuMQAQ뎋E    o @]v u_]W   h u gE     UP]spv MA|      ]S!@C@     EH      
h`ufUƂH  Kp|@uF`;p  Q95u]C@ tCD   GEMU@D   
0v hudf   ECP]Ћt  9rP@	9sÃuU~Lp  SP)5	tMp  t  ]CLEsTPRVUrLa]M{HCLCPCPvup  V/YC@ CD   IUWVSMQA	}]uMQ$A 	        U          R  z|  SEPh @  ub   uuE               u	o   tR  5  119}&   <
   CA9}
  މ9t        EP      Eh  P(f uD   un   U9t6)      MЙA Q$A Q$QRPW1e[^_ËM          Ǉ       t   뭃uu   jWj sv 
  A
        h   x5	  hWbc   CUM   W   'Q1|  xLEB|      PEUM#AtQx1jWfUWVS,E8L  wE    ǀL         H!  *             tJ   uU\   t6uEPVuWf =  E8 1     v t	>  EPEUF8EV<  NtFVQNtF V$Qu*   q                z     E؋VE!@UtDFVEЉUԋUԋE3U3E	t(ET  UX  M13E	t
   tbu4    t+Uzt"h W`   v e[^_Éu*   u݋   3E 1ʋE)E؋UUuuh@룐v4v0v<v8?;  N!@t'PQRvv  hWN`    ]vv  h׍v Pv<v8WÆx~|Rvxvtv<v8=  3F|       h@Wg_v EPVuW"hW_7   Rj PQVÃUh  Ed  UWVSM`  @(11Uuz1J~   ЃHtOЃ*t
e[^_Ív h  9d  tt   UO   	   u؉Ud        SRuQ뛉UWVSE UEd  EE E  ]䀻    uu耾z   :  } 0  v }䋟      i  u苎    	t,    9ωu؉}|9M3  9+  v Uh  ]䉃         }苗    	t(    9׉u؉}|9U   9   Ed  ؃]䉃   1   H	1    H	} tatT1VPQR)@t/EPuxuE } 1e[^_Ð裼8t8   v uv   럐   d؃u䉆   O   u䉆   h  )zUSP]P  uhS\   ]É0  Su㋃(    ,    ǃ0      ƃ   ƃ   ǃL      ƃ     1`  ǃ      uƃ  SP$(1^SӍv UE  u	   t1Ðh#  i{UUS1Ʉtv  t?tABu[É1tv UVS]   MtЃ t?tCAu [^É1t%A2A0ؐ+ҍv UE(PEPhu)Ív UWVS(EuE5	EU1R  hu譽  U/U  j?V豶1t  E E}?tj/V,t  UUj/VoÍp1H!ƀ}.  U:.   t&Ot j/Vѿ   O  uu61҉Ë}MU}OD;$x5	tNPWuSU</tt> t<?t/}uPXu|5	؍e[^_Ãu|5	1 ^z.*z/ EEG8.x.x/tEx/Ej/Vt j?V
t9s j?V  uv UWVS}}uE   Vb{  j VE茴t<V@$x5	Ã۸      VSXV|5	ރ}  } tƇ   T      ƇT  P  SVh`W[W  --  w $l  w8   tjW}<$1e[^_ÃhWVǇ     Ƌ  w9   uhʃ  tǇ     Qz   tPh!WV몸P  |5	  \VP  Ã۸   <v 4     0  9}s@y   Ƈ  0  \   u9P  5	X  u   Ƈ\   Ƈ\  X  |5	볉PRh WV/   0  jUWVSj]S}uEWEPVS&s u} ue[^_Ðj 6耴uW6sÃ΃6KUWVS]1|   tC0u
1e[^_Ív A<A,Q0	uI   t	z   t̃h@3TXP  5	UƃH  ƃS     UWVS}Ǉ\     WE    E    &1   v EPWua     EPEPIu   E   u(t$PVuWuE    v1뉋Eu^t	   t#WXu	tÍv e[^_ÃSͮtRPhZWSVSh>v P|5	듐Pj SEPqJv utX8tSt.EƀH     tP衱Eǀ   Pj SEPdqEPutE1۾   u   낅u   u'   f   P5	E¾   EƀH   Qj j EPpÃ~v UWVSuE>}UME_Et
E   EE} d  Et
E    EE쉆h  E   EC} E$KCuC@ x   PQRW    u	z   uAd  t   h  t(P  t|  xLttC|      e[^1_ËC0S4C|   CtSxv  vuUUB1<	vB<v
B<wv ÐUE@    @     @   UWVSE E}MU   ]uE    E    t
      EtAGw}$EPEt.GU8F@KGu1e[^_ø   v Gt8 j jj WmGG   ¸   v    뷀>
tKFG   >
tG   v FK댋Gu+M耹   t	G   ċEG	   ǀ      G   G9É]vEU      M싁      ~{uWEphRuuu)  EEu+EMG+Eu+]GG      h`U2mO   v u݋E耸    uU쀺   t	E    uVju
RgMqhQuuu  M1>
uG      2>
uulFK>
uG   q>
uK_ U    9|2tg  P  5	t;U    E  U  >
G
   }   yv Mǁ     h   x5	딀>
G   >
M    
  B       tCU쀺   tMG	   ǁ      KP  jQlPEtG   SVjuDPEUҸ   EUEU@    P     @    ÉUSjx5	Ã1tuS؋]Ív UVSj]ux5	1t,KEɉu'B    @    SAC   e[^ËFBFrtPV։Sv UVS]ۋut5Ft.;t;CSBCu&V3uV$|5	Ne[   ^ÉP؋Cu	F    ƋC@    뺐UVS]ۋutCuS|5	e[^ÉQVsSUSuӐUE@ÐUMWVS}]tsu
1[^_Ív ;tqAQBAu\SFCWu$A    @    OBG   벉]CACYt
HEHӉOv P뢋Au	C    됋A@    널UEE@tQPh RJ=   Ãh`UuZE     EUWVS(uƈ   FEE   E   h   EE    x5	"  ~F   jVvqEt8u3V̳j8hrjV
 uEEFE    뢃W|5	SVuPE   PVe[^_ËV   E    t   )PWjuLEuOt"4F)W|5	E뢃W|5	4$tPfPukW|5	v PjQUWVSu   E҉E}   uEC     C$    C(    ǆ       C    Pj8hrS蟩u(ǆ      FTE{uEe[^_E]Ee[^_v UWVSSM	]κ   ~
;t   Y[^_Ð{u{{u   uڃ

   t8   ~CE	EE9   |+EHE\   tt>t
CIt4ut*u&IC   t'tt
CItutt
   EIt   1)΋E01 UWVSU]   È          wHt/UBTMKsu
1e[^_Ãuu~PEPuEpT}t
rht QWSuPE   PS룃USRx5	uWjVsMqTP5Eǀ      av MUAT)UECǁ      2v EC3CPV5	uV|5	CRuUrT+EP贫EPs3tr13|5	3|5	MEQTKU)ʃ)EKǀ      sUBTMKRsǂ       C     C$    C(    C    Iƿ   (Щ   u>j8hrj/S<uM   ǁ      Su"j8hrjSuًEǀ         Ujj5	tUSQ]CM   u.Ew!$   	t@t   Ћ]ËCt1jj j j C   tދSu访C䐋!t1!uCtPNC    떃y닋CtP}C    ׉ Cf C\ CRUSS]۸   tC   Ct!Cu
   ]Qsjj Ѓ琋Cu=Cu&CuS|5	1ȐRsjj Ѓ␃P{̉PC}C    뮍v sjjj ЃiUSP]SҋM   t   tBu1]ruQSЃUSP]SҋM   t   tBu1]ÃrQSЃUWVSQME 1Uut <=t   v ABt
<=tKu A<=   tZ[^_Ê"tw҈t3  v "tS".
t%
t 1FAtKu E11,t\u҉u̿   \ƀ} 뺉u} tAE뀉UWVS  E} ƅ ƅ  ƅ   ؄  ut : fP%    ft^]PjVh)  7EtƅW	     v ut Ϊ fP%    ft^]׍EPPPV?   hP(   P5	   t^]t"? fP%    ftC]Ҁ,t53 t tu   e[^_ú   C]ŃhP.(t/hP(QGG    AhP'tP5	GhP'tP5	GhP~'G  P5	   <,  1Ʉt!ъARtB<,   uɉtUhS'   ƅ<,tu1ɄtъARtB<,tUuɉuV|5	 u# h5	GhB 뫍v B<,t낃hSe&]ƅQB B<,t   hP&VP5	GthP%tG   hP%   OG    1<  UWVS}1]v >PhjSFZ~e[^_ÉUWVS   UE҈[0F  ؄  l  D      L  TPHT  P  L  DuHB 1e[^_ÉDP HGu@    DBuc`P֯`h#jhSY\P1IQSVB   
  \DBLDwPh<7ZÃ۸   7SEPH  $|5	$!   x5	ƃ   VURD  H   j?u蛗  u+]Suh)Y  DH  SUR  $|5	XZxS}WDx+  QSppp 0Vh1 YÃ V|5	۸   S}W$  $|5	XZ]SWDzz  Srr ru2r[ POu%PhX(ThDp0"t	DB Tu
   `DB   DGtBRPT0hEXÃ۸   T2|5	TT81уQT25	Ã۸   hS}TQPT7hXWÃ۸   T0|5	TVSuD7w[ POu%Ph WT SD2Vh<VÃhp cV|5	pSuuh? w7Vh<VÃ۸   SEP  $|5	_XVURv ǅL%SǅP%5P
T    	v x    DT        PLHv USP]   C       CC    u{CC    u]CC    u?CC    u!C    C     C    C ]Ív P|5	АP|5	벐P|5	딐P|5	sP|5	QP|5	,US]  P؄  ]]UWVSx]uS1уIQVSiXZSue[^_ÐUMQ	Q	Q	ÉUWVS} Eu2    Ev t荟 fP%    ftFQjVhǯI   v    I fP%    ftFۃEPV&;  ]ۉ¸   tPE    @    v*d	   ׉uW   s׉tu|5	   e[^_ÃCPUBUBMABAZu|5	   }uE      v UVS]UK	US	MK	US	MK	UCu	VME贑[XuV詗e[^ÉUWVS   hSuV}MjSWu襛SFP4jSGPu艛SVjSWume[^_ÐUWVS   1ҋuوI
   ىэYQSVuV   )P3j R\XZXSVjSuh[SEP|jESPh[̚UB    B  e[^_Ív    xUVS1ҋ]9ڋMus2QDQ B9r[^UWVSx}1эY4Vx5	ǃ   tEPSuW]$CVWS^XSu荔E@    @ <$|5	1e[^_UWVS	  Eh   cj Pǅ%1%II ǅ      Uul        U  |2  xxF 5    |:  v	   h%Sj j j j RPRPj j RPRPRPj jh   jj j j j h	h   SN쀍t0 PVSj 7  u   e[^_Ð0t Ou%Phl	N^|5	1뢐uxFP|5	    ِj\SQt  t)t1۾t؉h   IRpE
  j.Pًt  I|Ba  ]3^Y[jP茓|ǅ    ǅ    ǅ    ǅ    FXF`d$\jjXWSXZSHV艒xSE0   WRVS_Kpp|CCPCPCPCPj j j j j j j j j j P   RRPRPj j P   QpRPRPj j j jpRPRPj j j jXj jj jj j j j@j jj jj j j j h	h   SHK   =  dwD<   Ɖ󥃅dd  wd<у󥉅ddp=  vh`	E0-[dRPcdpdtP9pddVPdPSj U3   2B Ou%Phl	JX|5	|x   @SSu6$   0Q|PWSSU2PWh	]3+ǅ     j/S讇t]tlǅ%%EUx        E¼  |  xhv UÐUEX  Ív UWVS E]u}     SVjE    E    ʈ~WVSj$  e[^_Ðjh(#  5	Ã1t܃EPEPh#  CPSVJE u+PVh	E0)$E    |5	EtWP#  E$|5	EkUWVS(}G P(Pj wR4       Mb)ˋG E؉G$gfffщ)хɉމO~{OG~cG      2~G2   2   G~,wwG$+EP7h	G0(1e[^_ÐG   G   G   y~\  MbUE])ËW ؉G$gfffU։)Ƹ2)щO&  뿐hG0j(   SUS]M؋fX$ÉUS]M؋fBX$ÐUE @	ÉUE P@	ÐUVSR]Sj uVw҉t)e[^ÐUWVSuVu}C19re[^_ËE)PEP\19wӋ?1ыEME붉UWVSUB] EE9ǂ8        Ev MQEPE)PSHU  uuh	u&1UуIQh#	Re   j j
j u,   =  p~bM<  9;M8  Rh+	Ph5	hN	u& ;];1e[^_Ph 	h_	u>&G   jh`	h  h	׃h	ҋUW׉IQhg	Rtj j
j u`t$QRPu胧Whm	hV	uX%Ph 	dh`	WUWVS1۾؋}ME;8  v1ҍe[^_Éuu2}։UVS]CuRh	h0$   $.te[^Éu]e[^#  v UVS]CuQh	h0p$   $te[^Éu]e[^  v UWVSuFo   UE	E    tE	1  $	F@;FF~1F   e[^_À|     jD  P~D         !ȃ@  j j h  @PS-E}   tQj uj uh	8  D  P]A1}ʋ} <
hg	D  PWVhǋD  PWV <  h	jǍEP@h#	D  PWV MQǋD  PWVsvh	jEP@ h	D  PWVFMQǋD  PWV0VǋB8pB8pj WD  v賃 xuEE
_Z0v艀PhZSf"PQRSH~]jD  Ph	0)"듍v RV&E끐RV   l|   tݐUWVSuUF8W    tPh	hZW!G   e[^_Ã@  PF(@9t PSh	W!F@;FF   f^(F    D  jSYXF(PS XZ,     Ph @  jD  v( x$8  90  D 1BuZY0v~PhZW 7   PF(@Ph	v toF@FSPh 	W* F9F~F   y,     Ph @  jD  vX IKfF(  F    D  jSYXF(PSXZ,     Ph @  jD  v    v UWVSuFU81ۍGE    tPh	hZW؍e[^_Ã@  PlfF(Ѓ9   RQh`	WF@;FF~PF(Ph	W27   뛃,     Ph @  4  PD  Pv	 ev~Y[0v|PhZ뛃@fF(F    D  jSVXZF(PSif~(v8  94  s
1   S4  P8  v躟,     Ph @  4  PD  v@ x%M4  1A Q$A Q$QRPW襟x}ZY0v|PhZW7   Pv .F@FRPh 	WWF9F~F   ,     Ph @  4  PD  v|~ ]PEp$p CUVSM1ۋAu t_rNt:t"Rh	hZPG   e[^Qh	hPVQӐVQ:VQUSPE  t&@  XD  $|5	1]ÐUWVSuV>XZjhH  5	   É          tǍ@=  G      @     D  u%GPj5	D           Cǃ8     <  F8f@ƆH   s    CfC,S^   u!WF8pC,Psu#Ɔ^  6E 1ҍe[^_ÃzZY0ViyPh-	6E   ͉GPj5	@     tUu~1ÉUWVS   E ]\uT=U  ҉@u$Su u7M  @j @4@>   te[^_ÉP@BPjr{  W  ǅX   1
   љ   X@@:t	ttlj jj j jjju K@Q7E   )A      *   tD   JG   H   F   t븃I   J   뚐`Pa{@F$9`F   v dPhSj @8  P@  qǅd   v@,   0  u@dсǬ      tftƤd@,  @0  %h?	\"ǅX   @@  WX   $	@0   u*   @^(WC9uȋ0  P@  PjuZ0  TAQAQVRP\mQh	hZ\'W@F@  Ph\S@0  P@  PR|SCv0utPhZ\ǅX   ov UVS]ǃ      3hY	h  yytJ  @PIt
I"AtƆo   e[1^ÐƆo  v N܍v hY	   yuUWVSE]u1     URXE      uug;EORU)Rjue|~2EPSVuuE9tt){e[^_ǋE8UWVS  EUE   
jj R]xp>tf  j x>f ƅƅf#  }ƅ   Vh   uW 51һوу1 dt=ƅ ƅ ƅ ƅ}֋d  n  1dWSPxu> u9t#h 		p   e[^_Ív  t  tPjRxu u	t
h`		듀 _  [  [   ZtGfRPPPPPh		p* t)h	pY[jx<1h	Ճ\tC]ofj]PPPPPh 
	lfj\PPPPPh
	2fj[PPPPPh@	h	U1׹ˍPSRxu 9udP|zVSuu腈1   J   t8tbQj@SW!XZPPPPh$	Sdx t?1pދ<Puh	p   둃Vuko*v hpu   v UWVS  uE   @  +,}1I+ $u     Wjj V9  jS9Sjv    th 	6   e[^_ÐMj S(ƅƅ ƅ>9D$PQSV u9Dth`	,mjS8jSu    th4	68   )j S8XZ@WjPSV u	@t
h	`t
h	J  <tW<tEt
h 
	#MtM9 uh`
	,,vh 	h`	E  E  M1IMIWuPƅ	s
uPrD$QSVj u;Dt
h	@PjRSV u	@t
h	N  + ƅƅƅ   R$$u$P ƅqE$ff*DQ WSVm u 9Dt
h 	@Rj
QSVǅ 
    u	@
t
h`	t
h	   <to<t_ 
~D@W 
 PSVr u 9@tjS51ǅ     냋fRPPPPPh	,
$<QuuVǅ    軁ǅ 
   ƅ   J   <t    Qj@HP3XZ6P4P2P0Ph$	HRpq t\ǅ    <,tEffSuh 	,	   0246y<WVShPPh`	2ǅ    ǅ    hN	65	   hb	ihy	։h	Nv h,PQh	,zƅ+UVuSt$Fu5Fu^V|5	ۉu܍e[^ÐP|5	ӐP|5	뼐UWVSE     EPuuuE    e1E   E   j x5	%  FCFCFCC    FC    C    C    tV   FueUtVt_vuEtPncEuEUEe[^_ÃuE    ։]륍v P5	CuCEuS|5	끃P|5	CPx5	CtQsvP|l(EE1v UWVS}1E    E    E       G0E       j j5	   75	C   jj5	C   E   EtEXGCC   C   tBEGU4]jMuEe[^_Ãu"E    މSBfGfEffB뢉]tsE   |5	XS|5	둃E   E   yUWVSj x5	ƃ1t/u5	ty}tP|5	XV|5	1e[^_ÐE FVFV>F    F   F   F@    uV<$|5	4$|5	롃듐UWVSE8l   t
p  uG G$e[^1_j j EPR`EUut+t%.n fP%    fu-uFEj j EPVP`щE9EtU!@u3UxEU䉇t  x  kE؋U ډG W$ԋEx+UM W O$빺UWVSE0j j h  V
ǃ   tbu%|     jj5	t`|  j Wi|   ;{Cu@tE 1e[^_Qh  h	V,j j%uY   %   ЃW|5	   뿐pCtPa    C    CWv USE |  sCtP`1]UWVS   E8|  j/6^Íx  Eh$ǅl    ǅ`    ǅd    uEU䉅X\\  U      
hۉ   %   t{ u%   e[^_Ív x  t  	J  h6hpp      !@  x  ~  l   PtPh @  u蠂l   t   x  t  	t(19Ӊ   |9   )1ۉt  x  hpSjQPj9   1`dPd`WPXuۂǅl*   t*l'p>flv P\XW	'lǅl7   luuctǅl*   딋t  h)Ǉt      Ǉx      p]xRPjUjuEUx  t  Dpie6h	W   SQRWzP6h	S  hA  6ex܃P]XZhUWVS   E8Ex  P4ǅ@    ǅ8    ǅ<    ǅ(    ǅ,    rEEU W18{<$|   tu%e[^_ÐU|  @S$EP$jh@t EU8EЉ<     z   tw   t
  u]x  ҋt  )  ;<
| ;8vh	W$   A)8_$<ۋO x  8<t6<18P<8WMt  x  	t;j x  t  $gax  t  11ȃ	ƺ$   jW:}@   <   ?  RP4$Sg   4 <8ttQ4șj(,u)8<@uWP,(W~Xu~ǅ@*   t8@Au~t
ǅ@*   @v PW"@몉<x8?  8 0tEUx  t  h	W   
<8hsh@  4P j 4jucj h	juEEЃDHPDP_ZY0ppPl  RP4 p@u   h	h?  40j 4juɉuP<8Wd|ᐐUWVS}11EEPh 	Vt'Á 	F~Έ__e[^_À}=uِUWVS,E}E         1<=      B:<=   u<=   Ѕ   1   [EЋE)EЋEЃPx5	ƃ1t[E0C~ÉWVKuWEP   1+Eԃ9}D+؈3C9|3 EЍe[^_Ã_E   B<8=BBE   31"v UWVS,uE1ۋUE    u1эq    Px5	EЋUЉEԃ1      11҅8  M̊GAND*؉MB~M؈UوÃ	ȊMڈǃ	 	Ã? 	˃   tyP 	P 	P 	P 	Phju E7E  MЋU
1эAe[^_É 	P 	P 	PhA	ǃ 	P 	PhI	mD* UVSuFt21ۋN9}uIC9|v|5	F    F    Fue[^ÐP|5	F    R|5	F    NUVSj
]SS1t   e[^Ív j
SRuUWVS0u>   jj V~   RPjS9]      PEPEPSEE   \tYSLT}t/h`	WEЉ   ZYjP1e[^_Ðh	W   v PEPEPSE   UEЃ뉉h	Ɖh 	뺉h`	W   뒍v UE   x  B4    B8B<ÐUWVS<E U]M      E    x  S4׉E+C8?  EE    E    E   C  RsPWaZSXsU|5	C    C    C    } twU  M1Q<S49E    E }E?
|  GF9։|}    9t)UEMԅu}} tUC4    S8E    C4=?  w8} t2u܅(E؋MUM؉  C< U܍e[^_ËM܅uj j
j ucWE؃뼋EԃCSsx5	CtRss8P.YN   띍v 9Ut{4    +MM}    ~Vuh	uE]s8fQ%   fFfA%   fFfA%   fE   v E䀸      us8juE܉}~N\S8UfQ%   ft0UBfA%   ftBfA%   ft	z tv GUE    C89UE    sMĊ	UȋEEB9}ĉUrM GUC8C4FUE C4    v uus8jP hU	uE E8   EP @  )PWuu 1҅E v UWVSXE   UEčE2P׋]E    e  EUۉEUE    E          U       E     N      E      REP{dYuud  )       }ЋWt}~QPju|Wt}t`EPSuu,Eu'Eȅu3Wt,EUuM7G< Ue[^_ÉE    ΍v uYr*   u뷃O0h 	V8   밃hq	V   뛍v uuREPhcYuucW$uuREPDcXuudc  ]UUUE  B`US]|  @u%Ph	SJ1  t]ÉjSƀH   1USj h]S
1  t]Ðj	Sm1UUEҍ  u1Ð   U1yP H%    ܍v UVuS  z) upBD    h  I   BHt
  uTZt=B@   QB0h	VU0  te[^Ív jVV;  v B@    RP뵐UWVS`  E  Uh   X	j PU  ۾ƅ ǅ    ƅǅ   t/RWSjK  j SWj  Pj jjWd  U   tPaKE      WjSVfǅ  ǅ   UR  SPPVǅ   Rt8LLZY0uJPh	   e[^_Ív jVfLf8     h   VPjDS_XPPPPh$	VkS sQPPPPPh@	z PPPPPPh	u-     u)U@@   ƂQ  jR1ĉPh   V`h	h	pv PrSxPǅ    h	0v PPSE   Pv
ǅ   ƅ+h   RSjP   񊅧IVj Suǅ    DaHtDt#Pdƅ PSh	{VuHPWPj
HRj R3UWVSuX    uO   t	ƆX  1ۄP    X	PhZV\+  t	e[^_Ð_@jVY[h	61USP]|  @u)r   tj S]ÐSC쐃jSYjjS  щUVSu|  @  tBuVwÃe[^ÐPj h	V*  u߃jVUVSu|  x  tV{Ãe[^ÐBtRPh	V(*  uكjVɉUWVSEd  E       E   UP   P  uq      	PhtMWPhZu)  u.utu|5	S|5	Y[ju1e[^_ÐEtu|5	   ڍv #u%L%/h  > j/VFCV5	EMɸ   fU1р|
/j/RL@ UjjuZ  UjjuF  UWVSuz   |    t@uVe[^_Éo  PVc$  tG   Wjo  PVl$  UVSum     u
  tBuVYÃe[^Ív RPh$	V'  uރjVΐUWVSE8|    U싗x  EӋt  	ÊMtt       x  ۋt    U  Ƈp    x  E    E    Eܐމ+]uxR   @  1U  Sju  1EU     9   |9   x  t  9U|9Er  ҋ  x%   +t  x  ҉    ~FSEpp   t.,	Pu"&  te[^_Ãju~14	Ѕx wh	Wj jj j jjju"](C   j 믃 tRv h<	W   y ݐ @  j SQ  Ѓh:VEph	uB%  j v UWVS}uE    |  UM썟  E            C@    t1ҋK@9   B9ʋ@}|u} u#t6v
t
tWEEe[^_Ãj WE@t
j WPsh	WA$  Euj؅tR0hZW$  EuVWEVC@-  
  UWVS   u  (@@>ǅ4    fǅ$  |  u
}   "  t]uAƆX   hP	Wj hf	V\#  u(@@1e[^_ÉPuhk	W=
   }   u; t<8P8PUREPUREPh	SDH tC; uƃh 	W   |; t〿   $  P^<Suuuuh@	W@ T     @          ShZj0EP8<f$  t	8 )  4P$SURVWH  4$f&  3P,P   P4V4WZt$(B@u
}   B  ۉ73Q        @     $d	Vj$PEP      Ã T   t	K   uj V|  QjTHj S G|  $PEPjVÃ ۉ|  g뗃hW   jj Vj$PEP   EAj&PEP,Ve  h	WƆX   Ƈ   SEPh	W$   4PV<4S      VTHt-4f   f&P   h	댃SV<   3Puuuuh	j0EP7 !v j(S9tBRGP@PFPEPDPh	CS|D t1ۅh	D   8(Du[@~tՋ@T   f$u3@  t(t#ttF<PhZj0EPg   1막UWVSE1}   0(  t]t9CtSuGǃe[^_Ãh	VJ   ލv h	VEƀY   몍v h	VY[j urUWVSl}|  E1U=     U   =&     h	SW  t&       ~zttQ9~ te[^_ÉWƃh SE@   ƃ  ^Xj W19~h`SUB   ͐h	S끐h9	S   5x  EEPEPEPEPEPEPhS	|  P
B    z   UBm     EEPEP>ZY0ppPl  RP4 p@u   h	h?  u0j ujW~Cj M<EXuuuuuuh 	h@  u(EPu?  UWVS}MEQӉ)ӃuE    t hl	uh   e[^_Ív    tPQh 	ut;t+ttEWEWwWWy׍v UWVSE8|    U싗`  Eы\  	]ut%9|!9vh-W?   e[^_ËEXpt  x  M	щUe  !@B  M܅   ;u*|;]s#VSx  t  h`	W3$   +]؋Eu܉XpMQA	uBj jj j jjju@h	WE@   XZj u@11x  t  h	WQx  t  h	u   juE؋U܃ 9։EU;u	9E؋U܃ )ËM։AQt  x  h  	WPUrh	u  OjWUWVSE Ex  }   }E    E   tUt4tEe[^_ËEt  x  juEWVSuXVSu`މ!@t7VShsh@  u j ujuEwPVSuWXuj j Ej |  P1Ã2UWVS,E]M  ttR^  tSmƃe[^_Éj EP}Ⱦ	   jfSE Otā^  th	3M   Prh	S+  ujS{UWVS}E7|  =  U   r          th` 	VoXZjWU@uRU     @    P    VVE0jj j jjjW΁(j WƇ$  ؍e[^_ÃWuiv QPh	VC   UWVSE0]|  1x     MEtg}tb}t4WSh	V}t   e[^_Ð&  N   u萁  uăMA   j u}EE  o     MQҋA	  |~EU䀾r      E       V$9UF |9Evx~wFVEUv$v h	V}tuuh	Vj jM1j uuju! Eƀ$  j P v낃h` 	V>XZju">>ux	 h	uh5K+}Ot&<(Et; UfP%   ft"KOuCj j j S.1ސMAQlUVSu    t3Qj h	V  te[^Ív jV	V_v UWVSu]K  |       Q׉)׃   L  ta  t	H   t"VSh	QC   e[^_Ív WPhZV  u݋ƀH  jVJċ  tRPh*	V  ujѐh 	뇉V냍v x`/QBu%Ph2	Vi  SjzUUM   tQRh:	P9   Ív QGUWVS,}  SPҋ   EE    tuEPRCTCL)PQW uUCP9t)ЉCP1e[^_ÃsL|5	ECL    CT    CP    $!CEUS\CX빍EPEPWQuM܅   C`  $	   tWQh 	u3   dU؋              CH    vktSE  h !	P   CDC@   QC@	PhX	W  jWCD   C@    뷃Wс   tUN  tMCH~#U؃  v@   맃Wƃ@CHCDC@C@R	PhX	W  փj W9\O0Ƈ    Ps`uWO8uWhPE؃  HPPh`	W  jQӉ)ӃtWE؃  v
@   U؋  t&Sj hW4  njWU؃     묁  ׃j W;tÃh`!	7B  t
j 'E@Px5	ɉEԸ   E؀|  "t u|5	XZhh	u막}  t}  Et<"t-ABtuUԉQRh	uU؉D  변z"uB" ΐ  ~PQh	7   7Ps`j WvQ։)փtih  tS@tKDth!	uC*	   CD   PCth	Ww
  jS@B;SCD    S@PCth	W:
  W@Q։)փt
CHHCH@tjWtS@PQh	uEuWPs`uW"Ps`uWPs`uWuWuWVs`uW:uWIUVS E  ҍ  ug  t9      EVP=Yuu=  e[)^Ív v\vXREP=Xuu=V$΍v v\vXEVP\=Yuu|=  UWVSu   VEE    4U   ~mPj GP1҅J	څHR	S70t+uEe[^_ÃVO`EE كh	u   Őhq	u   뭐UWVSu  K`1҅ɋ   Eu
Ѝe[^_ÃVc~dRPCP1҅J	HR	Ps/t$   tVauC`u뙃h	u_   넃hq	uH   jUWVS}7|  tP   SF,   CR,t   e[^_És	1҄tىjj5	ú   t|  덐UWVS   }E  7W<$O     T   ƇH   C$6 t	K   uG0tj W2uNWXZjWE$:EU\  CXS\t WuUe[^_ÃuW(狖|  QjTj EP|.U|     P   j Wu||  .뒉UWVS<UEUE狊|  Eu  h  1ɉME    V(  }N  M$$	}   V(v F,  j j Su  ~x  1эQ1эA)Ѐ~* 4    Md    ҉^,t Pv,h!	u$V E   t.      U   {#Mǁ   E܋@u~( t~< t
}   v M؅u]} uWM|        EЋ  E!@Ut-M܋SM13E	tE   uU܋RtPF  uE܅@    u]؅u} uU  uE؍e[^_ÃPuA  E؃uus3h "	PP E   댋UBEȋRE!@UtUM܋HUEȋU13E	Mt6MET  UX  M13E	tMA Q$M13E	u[~  U܋Pы 	E̅}̅~h	uE   } uuh@"	ujE   Ћ^$F$`  PEPuEP}E؉^$utLE؅~   E=   =   SPh"	uE   h	uUF( ƂH  둉jPM1Mh%5	F,$|5	F,    S|5	1F,    P|5	=EF( F*ƀH  UVS]ۋutu[u1e[^ÉRPhZV?  uPEPVEPAú}  ~P3h	6   뮍v UE}   t
AÉIv UWVS]  } }EtrA   E8P0t;QPh7	SE  t
e[^_ÉWSUB01WS}E   ]e[^_VI   댐US  h   Su5XuSuh"	E0_]ÉUWVSE8  l   Et
p  uG G$e[^1_j j EPRyEUut+t%* fP%    fu-uFEj j EPV0щE9Et\!@u:ExUEx  U܉t  B dE؋U ډG W$͋Ex+UM W O$벺또UWVS}  E|  1~w-|   tVPjo  PWuWauVue[^_Ív j jj j jjjWxl ܍v FFWUuq   u
E@uFuSjjsQjcUVS]z   ut
|  @    Pj
jSu'\  t'SQ  Ee[^ÉVSىUVS]u S}$t
e[^Ív SC  uu]e[^  v UWVS,  ]EPuh    V5Y_hV #1ǅ    щ$y!$WV   SR uO      9td)Wx5	ALt&RWVP"xPxTe[^_Ãhw
ǅ   АP0AXQ\릃SVjP KUWVS,  EPuh  XZh!ǅ    1эYv PSU   R u"}   u!9t
)뵍e[^_Ív WjP v USS]1   u]Qj h?	SujS$΍v UVS]S    t&9D  tr  |5	ǃ      Fu7VF,ue[1^Ív P|5	F,    މP|5	F    볉ǂD      UWVSE E싐|  h  Md    U1҃M؉uA( A*   v	  E@    @   jj5	U؃B   u
e[^_Ãhϱuq  j/Vy   }+h  1҅~E؋Hu9uFĉ)j P)VU2u؋VFɉ   QuV}؋G@W9ЍsGjG    Pw5	tGAu   VF4|5	4$   hD	u0X뷐t	:    MA    u쀾|   t}؋GuE@   U؋B,B) u1|EPj Mh  u6E:}؋Gtq1I])ˋE؋p,]1I9tu|5	WSVut݃h"	uE@)]렃h #	V%j j RE0U؃BuRXZhD	uyPuyhϱu5	M؋QFAw> uE@    ej/VpÉEHjj5	U؃B   j )SVM1u؋Vt!]}؅G   UUBV> 1р|/UWVS]EE|  1  } Euit)   tPǃ   e[^_Ðu} uƃP  E@(؍v j jj j jjjScƃ ِSƃUVS]SuVc; ue[^Ãj V-UWVSuCCj j SE j7j j SA7j j S7j j S_7  G(EuPVu0E8 u1e[^_ÉEPVu߉ېWUVSuK   t#n   u`  `	   ǆ`   	h  @h  hƨPtL  @PDt%DAtƃo   e[1^ƃo  ƃq  v hƨ   uǆ`  	gUWV0}EUE    E    E    E    E    E    E    uEUxex=j uuWVw   M tى؅ɉMtHEԋUԋEЍe^_Ðى؅UMtHE܋U܋E؉EU량ىMuمEtIMu}sUWV0Uu}EE    E    E    E    ẺUu}   9vPủUEE    MtUUE    MEUQU؋MԉUMEU0^_Ðu̅u
   1ủE̋E܋UủU܉EԋEủUE듍v E9Ev0UE    E    tuEUEMH|EƃuUU9UwM9Mr<U܋E+EUE   EU܋EE    4EU܉EUE    Ը    )EЋUE̊M	ẻUMЋU}܉EM	ǉu}܉U܉Eee;U܉wF;Ut<EE    M܋E)щM܉ʊME	E܉U;EvM+}U봐Uj uuuu   ÐUWV0Uu}EE    E    E    E    ẺUu}   9vPủUEE    utUUE    MEUQU؋MԉUMEU0^_Ð}̅u
   1ủE̋E܋UủU܉EԋEủUE듍v E9Ev0ME    E    tuEUEMH|EƃuUU9UwM9Mr<U܋E+EUE   EU܋UE    4EU܉EUE    Ը    )EЋUE̊M	ẻUMЋU}܉EM	ǉu}܉U܉Eee;U܉wF;Ut<EE    M܋E)щM܉ʊME	E܉U;EvM+}U봐UEPuuuu	   EUÐUWV0Uu}EE    E    E    E    ẺUu}   9vPủUEE    utUUE    MEUQU؋MԉUMEU0^_Ð}̅u
   1ủE̋E܋UủU܉EԋEủUE듍v E9Ev0ME    E    tuEUEMH|EƃuUU9UwM9Mr<U܋E+EUE   EU܋UE    4EU܉EUE    Ը    )EЋUE̊M	ẻUMЋU}܉EM	ǉu}܉U܉Eee;U܉wF;Ut<EE    M܋E)щM܉ʊME	E܉U;EvM+}U봐UVS5	-5	19sƐ5	C9r[^USP5	-5	Xu]6   5	KuUSR6	6	tЋuX[USR    [Æ ]                          Warning:  curl:  Build-time engines:   %s
   <none> %255[^=]= ;type= curl_formadd failed!
 %127[^/]/%127[^;,
] Error building form post!
 filename= out of memory
 is ambiguous is unknown requires parameter is badly used here unknown error out of memory singlecwd nocwd multicwd passive active Could not set TCP_KEEPINTVL!
 Could not set TCP_KEEPIDLE!
 Could not set SO_KEEPALIVE!
 * *a random-file *b egd-file *c connect-timeout ciphers *e disable-epsv *E *g trace *h trace-ascii *i limit-rate *j compressed *k *l *m *n *o *q ftp-create-dirs *r max-redirs *t proxy-ntlm *u crlf *v stderr *w interface *x krb krb4 *y max-filesize *z disable-eprt *Z $a ftp-ssl $b ftp-pasv $c socks5 socks $d tcp-nodelay $e proxy-digest $f proxy-basic $g retry $h retry-delay $i retry-max-time $k proxy-negotiate $m ftp-account $n proxy-anyauth $o trace-time $p ignore-content-length $q ftp-skip-pasv-ip $r ftp-method $s local-port $t socks4 $T socks4a $u ftp-alternative-to-user $v ftp-ssl-reqd $w sessionid $x ftp-ssl-control $y ftp-ssl-ccc $j ftp-ssl-ccc-mode $z libcurl $# raw $0 post301 $1 keepalive $2 socks5-hostname $3 keepalive-time $4 post302 $5 noproxy $8 proxy1.0 http1.0 tlsv1 sslv2 sslv3 ipv4 ipv6 append user-agent cookie use-ascii cookie-jar continue-at da data-ascii db data-binary data-urlencode dump-header referer Ea cacert Eb cert-type Ec Ed key-type Ee pass Ef engine Eg capath  Eh pubkey Ei hostpubmd5 fail form Fs form-string globoff get help include head junk-session-cookies insecure config list-only location Lt location-trusted manual no netrc-optional buffer remote-name Oa remote-name-all proxytunnel ftpport ftp-port disable Q quote range remote-time silent show-error telnet-options upload-file U proxy-user verbose version write-out http-request speed-limit speed-time time-cond progress-bar AsynchDNS Debug GSS-Negotiate IDN IPv6 Largefile NTLM SPNEGO SSPI libz CharConv no- wt Failed to open %s!
 %d - %d bad range input
 Features:   Protocols:  %s&%s %.*s=%s ;auto %Od- Failed to read %s .curlrc <stdin> %s:%d: warning: '%s' %s
 %s%s%s wb Failed to create the file %s
 %%-%ds %%5.1f%%%% 
%s COLUMNS %s%s, %zd bytes (0x%zx)
 %04zx:  %02x      < { } %s== Info: %s <= Recv header => Send header <= Recv data => Send data <= Recv SSL data => Send SSL data %s%s  [data not shown]
 Failed to create/open output %02d:%02d:%02d.%06ld  http:// https:// %p  [REMARK] */ /*  (curl_off_t)%Od  * libcurl. [m] #include <curl/curl.h>   CURLcode ret; HTTP error FTP error --url CURL *hnd = curl_easy_init(); Can't open '%s'!
 
[%d/%d]: %s --> %s
 CURLOPT_WRITEDATA CURLOPT_WRITEFUNCTION CURLOPT_READDATA CURLOPT_READFUNCTION CURLOPT_SEEKDATA CURLOPT_SEEKFUNCTION CURLOPT_INFILESIZE_LARGE CURLOPT_URL CURLOPT_PROXY CURLOPT_NOPROGRESS CURLOPT_NOBODY CURLOPT_HEADER CURLOPT_FAILONERROR CURLOPT_UPLOAD CURLOPT_DIRLISTONLY CURLOPT_APPEND CURLOPT_NETRC CURLOPT_FOLLOWLOCATION CURLOPT_UNRESTRICTED_AUTH CURLOPT_TRANSFERTEXT CURLOPT_USERPWD CURLOPT_PROXYUSERPWD CURLOPT_NOPROXY CURLOPT_RANGE CURLOPT_ERRORBUFFER CURLOPT_TIMEOUT CURLOPT_REFERER CURLOPT_AUTOREFERER CURLOPT_USERAGENT CURLOPT_FTPPORT CURLOPT_LOW_SPEED_LIMIT CURLOPT_LOW_SPEED_TIME CURLOPT_MAX_SEND_SPEED_LARGE CURLOPT_MAX_RECV_SPEED_LARGE CURLOPT_RESUME_FROM_LARGE CURLOPT_COOKIE CURLOPT_HTTPHEADER CURLOPT_SSLCERT CURLOPT_SSLCERTTYPE CURLOPT_SSLKEY CURLOPT_SSLKEYTYPE CURLOPT_KEYPASSWD CURLOPT_SSH_PRIVATE_KEYFILE CURLOPT_SSH_PUBLIC_KEYFILE CURLOPT_SSL_VERIFYHOST CURLOPT_SSL_VERIFYPEER CURLOPT_FILETIME CURLOPT_MAXREDIRS CURLOPT_CRLF CURLOPT_QUOTE CURLOPT_POSTQUOTE CURLOPT_PREQUOTE CURLOPT_WRITEHEADER CURLOPT_COOKIEFILE CURLOPT_COOKIESESSION CURLOPT_SSLVERSION CURLOPT_TIMECONDITION CURLOPT_TIMEVALUE CURLOPT_CUSTOMREQUEST CURLOPT_STDERR CURLOPT_HTTPPROXYTUNNEL CURLOPT_INTERFACE CURLOPT_KRBLEVEL CURLOPT_TELNETOPTIONS CURLOPT_RANDOM_FILE CURLOPT_EGDSOCKET CURLOPT_CONNECTTIMEOUT curl: (%d) %s
 CURLOPT_ENCODING CURLOPT_IPRESOLVE CURLOPT_FTP_ACCOUNT CURLOPT_IGNORE_CONTENT_LENGTH CURLOPT_FTP_SKIP_PASV_IP CURLOPT_FTP_FILEMETHOD CURLOPT_SSL_SESSIONID_CACHE CURLOPT_POSTREDIR ret = curl_easy_perform(hnd); Throwing away %Od bytes
 http CURLOPT_SOCKOPTFUNCTION CURLOPT_SOCKOPTDATA CURLOPT_HTTP_CONTENT_DECODING CURLOPT_LOCALPORT CURLOPT_LOCALPORTRANGE CURLOPT_PROXYTYPE CURLOPT_FTP_SSL_CCC CURLOPT_USE_SSL CURLOPT_MAXFILESIZE_LARGE CURLOPT_PROXYAUTH CURLOPT_SSLENGINE CURLOPT_SSLENGINE_DEFAULT CURLOPT_DEBUGFUNCTION CURLOPT_DEBUGDATA CURLOPT_VERBOSE CURLOPT_HTTPAUTH CURLOPT_FTP_USE_EPRT CURLOPT_FTP_USE_EPSV CURLOPT_HTTP_VERSION CURLOPT_SSL_CIPHER_LIST CURLOPT_PROGRESSFUNCTION CURLOPT_PROGRESSDATA CURLOPT_COOKIEJAR CURLOPT_CAPATH CURLOPT_CAINFO CURLOPT_POSTFIELDS CURLOPT_POSTFIELDSIZE_LARGE CURLOPT_HTTPPOST CURLOPT_BUFFERSIZE CURLOPT_TCP_NODELAY %s/?%s --_curl_-- %s%s
 <stdout> %s/%s ab bad output glob!
 curl_easy_cleanup(hnd); CURL_CA_BUNDLE SSL_CERT_DIR SSL_CERT_FILE no URL specified!
 option %s: %s
 Error creating directory %s.
                      You can only select one HTTP request!
                          curl: try 'curl --help' or 'curl --manual' for more information
                                Usage: curl [options...] <url>  Options: (H) means HTTP/HTTPS only, (F) means FTP only              --anyauth       Pick "any" authentication method (H)         -a/--append        Append to target file when uploading (F/SFTP)                                   --basic         Use HTTP Basic Authentication (H)               --cacert <file> CA certificate to verify peer against (SSL)     --capath <directory> CA directory to verify peer against (SSL)                               -E/--cert <cert[:passwd]> Client certificate file and password (SSL)                               --cert-type <type> Certificate file type (DER/PEM/ENG) (SSL)                                    --ciphers <list> SSL ciphers to use (SSL)                       --compressed    Request compressed response (using deflate or gzip)                          -K/--config <file> Specify which config file to read               --connect-timeout <seconds> Maximum time allowed for connection                              -C/--continue-at <offset> Resumed transfer offset               -b/--cookie <name=string/file> Cookie string or file to read cookies from (H)                   -c/--cookie-jar <file> Write cookies to this file after operation (H)                              --create-dirs   Create necessary local directory hierarchy      --crlf          Convert LF to CRLF in upload                 -d/--data <data>   HTTP POST data (H)                              --data-ascii <data>  HTTP POST ASCII data (H)                   --data-binary <data> HTTP POST binary data (H)                  --data-urlencode <name=data/name@filename> HTTP POST data url encoded (H)                       --digest        Use HTTP Digest Authentication (H)              --disable-eprt  Inhibit using EPRT or LPRT (F)                  --disable-epsv  Inhibit using EPSV (F)                       -D/--dump-header <file> Write the headers to this file             --egd-file <file> EGD socket path for random data (SSL)         --engine <eng>  Crypto engine to use (SSL). "--engine list" for list                         -f/--fail          Fail silently (no output at all) on HTTP errors (H)                          -F/--form <name=content> Specify HTTP multipart POST data (H)      --form-string <name=string> Specify HTTP multipart POST data (H)                                --ftp-account <data> Account data to send when requested by server (F)                          --ftp-alternative-to-user <cmd> String to replace "USER [name]" (F)                             --ftp-create-dirs Create the remote dirs if not present (F)     --ftp-method [multicwd/nocwd/singlecwd] Control CWD usage (F)                                   --ftp-pasv      Use PASV/EPSV instead of PORT (F)            -P/--ftp-port <address> Use PORT with address instead of PASV (F)                                  --ftp-skip-pasv-ip Skip the IP address for PASV (F)
    --ftp-ssl       Try SSL/TLS for ftp transfer (F)                        --ftp-ssl-ccc   Send CCC after authenticating (F)               --ftp-ssl-ccc-mode [active/passive] Set CCC mode (F)            --ftp-ssl-control Require SSL/TLS for ftp login, clear for transfer (F)                         --ftp-ssl-reqd  Require SSL/TLS for ftp transfer (F)         -G/--get           Send the -d data with a HTTP GET (H)         -g/--globoff       Disable URL sequences and ranges using {} and []                             -H/--header <line> Custom header to pass to server (H)          -I/--head          Show document info only                      -h/--help          This help text                                  --hostpubmd5 <md5> Hex encoded MD5 string of the host public key. (SSH)                      -0/--http1.0       Use HTTP 1.0 (H)                                --ignore-content-length  Ignore the HTTP Content-Length header                               -i/--include       Include protocol headers in the output (H/F)                                 -k/--insecure      Allow connections to SSL sites without certs (H)                                --interface <interface> Specify network interface/address to use                             -4/--ipv4          Resolve name to IPv4 address                 -6/--ipv6          Resolve name to IPv6 address                 -j/--junk-session-cookies Ignore session cookies read from file (H)                                --keepalive-time <seconds> Interval between keepalive probes                                    --key <key>     Private key file name (SSL/SSH)                 --key-type <type> Private key file type (DER/PEM/ENG) (SSL)     --krb <level>   Enable Kerberos with specified security level (F)                               --libcurl <file> Dump libcurl equivalent code of this command line                              --limit-rate <rate> Limit transfer speed to this rate        -l/--list-only     List only names of an FTP directory (F)         --local-port <num>[-num] Force use of these local port numbers                               -L/--location      Follow Location: hints (H)                      --location-trusted Follow Location: and send auth to other hosts (H)                         -M/--manual        Display the full manual                         --max-filesize <bytes> Maximum file size to download (H/F)      --max-redirs <num> Maximum number of redirects allowed (H)   -m/--max-time <seconds> Maximum time allowed for the transfer      --negotiate     Use HTTP Negotiate Authentication (H)        -n/--netrc         Must read .netrc for user name and password     --netrc-optional Use either .netrc or URL; overrides -n      -N/--no-buffer     Disable buffering of the output stream          --no-keepalive  Disable keepalive use on the connection         --no-sessionid  Disable SSL session-ID reusing (SSL)            --noproxy       Comma-separated list of hosts which do not use proxy                            --ntlm          Use HTTP NTLM authentication (H)             -o/--output <file> Write output to <file> instead of stdout        --pass  <pass>  Pass phrase for the private key (SSL/SSH)       --post301       Do not switch to GET after following a 301 redirect (H)                         --post302       Do not switch to GET after following a 302 redirect (H)                      -#/--progress-bar  Display transfer progress as a progress bar  -x/--proxy <host[:port]> Use HTTP proxy on given port              --proxy-anyauth Pick "any" proxy authentication method (H)      --proxy-basic   Use Basic authentication on the proxy (H)       --proxy-digest  Use Digest authentication on the proxy (H)      --proxy-negotiate Use Negotiate authentication on the proxy (H)                                 --proxy-ntlm    Use NTLM authentication on the proxy (H)     -U/--proxy-user <user[:password]> Set proxy user and password      --proxy1.0 <host[:port]> Use HTTP/1.0 proxy on given port    -p/--proxytunnel   Operate through a HTTP proxy tunnel (using CONNECT)                             --pubkey <key>  Public key file name (SSH)                   -Q/--quote <cmd>   Send command(s) to server before file transfer (F/SFTP)                         --random-file <file> File for reading random data from (SSL)                                 -r/--range <range> Retrieve only the bytes within a range          --raw           Pass HTTP "raw", without any transfer decoding (H)                           -e/--referer       Referer URL (H)                              -O/--remote-name   Write output to a file named as the remote file                                 --remote-name-all Use the remote file name for all URLs      -R/--remote-time   Set the remote file's time on the local output                               -X/--request <command> Specify request command to use              --retry <num>   Retry request <num> times if transient problems occur                           --retry-delay <seconds> When retrying, wait this many seconds between each                      --retry-max-time <seconds> Retry only within this period     -S/--show-error    Show error. With -s, make curl show errors when they occur                   -s/--silent        Silent mode. Don't output anything              --socks4 <host[:port]> SOCKS4 proxy on given host + port        --socks4a <host[:port]> SOCKS4a proxy on given host + port      --socks5 <host[:port]> SOCKS5 proxy on given host + port        --socks5-hostname <host[:port]> SOCKS5 proxy, pass host name to proxy                        -Y/--speed-limit   Stop transfer if below speed-limit for 'speed-time' secs                     -y/--speed-time    Time needed to trig speed-limit abort. Defaults to 30                        -2/--sslv2         Use SSLv2 (SSL)                              -3/--sslv3         Use SSLv3 (SSL)                                 --stderr <file> Where to redirect stderr. - means stdout        --tcp-nodelay   Use the TCP_NODELAY option                   -t/--telnet-option <OPT=val> Set telnet option                  -z/--time-cond <time> Transfer based on a time condition        -1/--tlsv1         Use TLSv1 (SSL)                                 --trace <file>  Write a debug trace to the given file           --trace-ascii <file> Like --trace but without the hex output                                    --trace-time    Add time stamps to trace/verbose output      -T/--upload-file <file> Transfer <file> to remote site             --url <URL>     Set URL to work with                         -B/--use-ascii     Use ASCII/text transfer                      -u/--user <user[:password]> Set server user and password        -A/--user-agent <string> User-Agent to send to server (H)       -v/--verbose       Make the operation more talkative            -V/--version       Show version number and quit                 -w/--write-out <format> What to output after completion         -q                 If used as the first parameter disables .curlrc                             Illegally formatted input field!
                               curl_formadd failed, possibly the file %s is bad!
              Illegally formatted content-type field!
                        had unsupported trailing garbage                                expected a proper numerical parameter                           the installed libcurl version doesn't support this              Enter %s password for user '%s':                                unrecognized ftp file method '%s', using default
               unrecognized ftp CCC method '%s', using default
                --trace overrides an earlier trace/verbose option
              --trace-ascii overrides an earlier trace/verbose option
        unsupported rate unit. Use G, M, K or B!
                       error trying read config from the '%s' file
                    curl 7.19.4 (i686-pc-linux-gnu) %s
                             Couldn't read data from file "%s", this makes an empty POST.
   Invalid character is found in given range. A specified range MUST have only digits in 'start'-'stop'. The server's response to this request is uncertain.
      A specified range MUST include at least one dash (-). Appending one for you!
                   -v/--verbose overrides an earlier trace/verbose option
         Illegal date format for -z/--timecond (and not a file name). Disabling time condition. See curl_getdate(3) for valid date syntax.
                              %scurl_easy_setopt(hnd, %s, %s);%s                              /********* Sample code generated by the curl command line tool **********                        * Lines with [REMARK] below might need to be modified to make this code                         * usable. Add error code checking where appropriate.            * Compile this with a suitable header include path. Then link with                              * If you use any *_LARGE options, make sure your compiler figure                                * out the correct size for the curl_off_t variable.             * Read the details for all curl_easy_setopt() options online on:                                * http://curlm.haxx.se/libcurl/c/curl_easy_setopt.html          ************************************************************************/                      int main(int argc, char *argv[])                                #define _FILE_OFFSET_BITS %d /* for pre libcurl 7.19.0 curl_off_t magic */
                       return (int)ret;
}
/**** End of sample code ****/
            Failed to open %s to write libcurl code!
                       error initializing curl library
                                CURLOPT_SSH_HOST_PUBLIC_KEY_MD5 If this HTTPS server uses a certificate signed by a CA represented in
 the bundle, the certificate verification probably failed due to a
 problem with the certificate (it might be expired, or the name might
 not match the domain name in the URL).
If you'd like to turn off curl's verification of the certificate, use
 the -k (or --insecure) option.
   More details here: http://curl.haxx.se/docs/sslcerts.html

curl performs SSL certificate verification by default, using a "bundle"
 of Certificate Authority (CA) public keys (CA certs). If the default
 bundle file isn't adequate, you can specify an alternate file
 using the --cacert option.
                            CURLOPT_FTP_CREATE_MISSING_DIRS CURLOPT_FTP_ALTERNATIVE_TO_USER Transient problem: %s Will retry in %ld seconds. %ld retries left.
                             CURLOPT_HTTP_TRANSFER_DECODING  Remote file name has no length!
                                curl/7.19.4 (i686-pc-linux-gnu) %s                              No space left on the file system that will contain the directory %s.
                           You don't have permission to create %s.
                        Cannot create directory %s because you exceeded your quota.
    The directory name %s is too long.
                             %s resides on a read-only file system.
                         ` `@ @@@ @ `  @  @ ` @ @  ` ` @ ` `  @ @ @ ` ` ` @@@ @ ` ` ` @ @     nu|f                                                                                                                                                                                                                                                                    W   
      "%   5   =@    MH    PS   Y\   hk   vy    O            _                .       ªŪ    ʪͪ   Ԫת                 
            '*   '1   7:    FI    VY    eh   nq   }              «ū    Ыӫ                  #&   .1   IL    Y\    fi    y|                      Ƭɬ   ٬ܬ             
            %!    a'    ,    l1    T8   C   yJ    T   _   V	i   kn   y|   	                  ­   ŭȭ   ѭԭ   ٭ܭ            X    +      	    ϸ'    +       f0    d8    =    ,R    L	[   b    l    ux           ?        ?               Ȯ    Ԯ   ܮ          $       [    J       (   `D   46   KA    I    Q   0   ͤ   ͤ[   h   	t   ۯ                              @                ǯ   ̯   ,   ӯ      د   ݯ   Th++++++++++ 2DVh+z++++++++++%
*+Pw&++++++++5IL*Ym[@J"EXiDe.?bq+BFoooo?ooofoooooooooooooooooooooFoooo?ooofo 3Y.Aef
=Pcv!
:^elsztt                        @ @ @%@        	'          Y@     k{G.y+u.ؒ4E<D) E@@FDfcϜi7C{mDY-V/{WKV1/{iOw=l}ǿ'o^٫U1QUYyQ=?l|<=S<+~F/ƇgǧojFiQcU,Q^qT&mRUfWQ%Q~U׉5W˼Y,*2lA_b`]9OO^E<ֈNiXٌ?K*~iwyqݥuhIaͥYeQ[['r3y)Mӛ'&9@QgCkJ1w@	E%7'yIo'4,K0r@7iB\DV5P$jD<E^$蠌Mq>II2QZLeW+zYsfAuB,i6-,󻤠Ō&|"\#aclkG-9K8L4d3**~}g2fIVULiH[ѮOt,~.GG>w	24j^KZqAĵ4"Z骴昺	Qp\R躪eZ%!Tw.#Y uúJ!uL#VK15uDpwgQvv+&8p$E^nu45O*:bA;~GYRbUuӦ$"_
`Vn9?̊JjK QNoMQ^\m:yym>z6o?d0Z"j/*
VwY{9jzMS%Ju&CetSiGJ鹼%qJ&Ѯ[ 
%
gON1)"㖒8u\HW>zC[od+{wwwE4{u90067A-e~ ŒIÚZ%%qFuu+y;q˘E%̜)Z$!(&qɛaTtCk,^$:L景hQ±1bJ{FEDɧǇN%Gdi<v
3<n _"7^HpG-Ev 
ExnfyW7$଼+C!]j,d6N/taL2w0PCIG4e[u$g9ړOۜqv~x>8:_Y^,$*r߳As*	٪ W\CSɀ.<ٕ_$`7|W6&kĂϊYw5]G'[
y~xDDg`Ȓ"H3Zt;)_ZsLFENL+޽xE8x7퍆GШ	o.tADޥD] rRKuUhF.i;d<%A
L>8`ggo/!beE/f	Uk0-sNm|M.:H/5?3\t1֚)*ˬ8~fy"o25l¸MGB~\h4Ox,MQ6mBq:1_mP0H$c	G+=]}U36,3ż+9	Ve6nMpe1eS?}S;
c93HQz(%.;M[	l&B	F;#V4'݈f{k
|\]a}l(`	<6&Bޫdo񒕀IDZV=,CeN͇8OgsFq.9G<ވn4گH#8t9>$YV(y;,C2-#U"GýWDGH͙w-I&HI&=_A"?W[
hXCt(+eh.)h-zUقPF<Ro<c8:T7UM-Ӽfc{Bo? 	?3R|qF9h!#kUtK΢"ӑC`@o".nLp$|7ЬNx,/7o~>j=SIS4yLǌNo)_?$̦SQcq^.3b0۽A|iU&A9>dDW5h:E)yMP)3a)(YND7Mo@Ena9ٔsUL'D$U Hg,b9+؍"͐Hd9:GD.1R_6P9mf9Yi!)up$t9N,%E¯Y5_ϒǪMu4jTxpa Ď2á?m$eEgB"E|"iI 88@t5/H<OŊVT;ڭDD&Xɘy8ul@)88:b'_څC',CjŴ$T"ҵ.L޲iS8qR5;D=5=ʆVuhնpz	E̻/;8y{&w{^EQE?*Ҥd4J\0|{6ݘV\	 QV
uRRˌy~H%uO[MGt	OIK=M~[oi=)/==Π,X[UU4/G5	'5z"EW&Sc岊'D\ZUz
RarD!,(_.iͽIr/mm#ыͼN/LL'./lpfAHV&65q٠ lcgorS7b/	E}Fmk}eymKj~Z,UC1׊W	_X9i6:F%Nt$>2nN/Ɉ6"KC46 ,*UKuL^DkIfՆ!oL-ْ`St=k{e(s*"
WJCP9A1f˴!IlLK91AL#{M\("k*=07wS|,WЈ;%ixyMvi^dCf8M|:Cf)[>h]i38.jfz3w
W䦛:lз<Wjɧ'Ok4;
Xf|GDdޒNMVs88f&ܶ\\c77@v;!V'c+u۝qWrǇpb)#Ulm~bʋe2ˋxDH^̕;=K~INtm'52\Xbki6tr;
rFdMޠcbxEZU.jU⯲ZV[nik"<ɟE2|E򛴈yQ_*!/<RO󌿎ߧBb'#"~5yâGRH=5-H;;h'Z^e,n֮V7$4-/|rut.X~+JV8؄,KMp\y,tfqĜvXKXrR9m*nHbKO
rMgc.-VDqՔFsf l[PK3/F2;6\:᷸Qnr~r2S(7rs"=}n'/RP{,.v{ޠ˲ԔmLNXUQa2XׇNO}cBwzzRL$Γ߫<Al奅W=[Lb*ըI25+>D|MLU<rdܥ;9҇8$e+݉旗D#_L"aT [Uʛ!͵Mfme=bA0MqE̴d7r;%9$J,,W4Ƞ'	fsfNT5w	C-b#}̵1>_GmFb[E𐶫|*{b#H2k:G*uqڱ۪-~h(܂Ԅ9χHo$4LE,$mvY9&(06[:{* Λ?&BjLYc`}(ό~#fM,vnlG5ΜPX[a7Bo4>)}|R+lUDjjȉXjY9->->D)Ut~cLV_76Oۏ
⌍$?hKr
IPLpٛ!0vJ鈣Iq|xe"h%B!^Ѿx}+BBTjB(U!1byy,ʫϐ(MM|V~H7CX懯h'M=N6!^L&_miY57	Žing6Io Yl5RWPbqT"H,Gڰ[N8GF}T&innAs7O2
.\$~rPfq3.	bÇd"fH!cn_INGm1^$'ݹ!r[	0
Lqz6oנEg"bBqJX5,LʽӬ;qȼbnQѐܤgQ2'q-t!
t:k|x*5Wjt8ǅ۰Iˢ=$*66%Ы"z[<#vd3D,S?3W
o5f>K%5\l9R@HmWPYԸc-*qL-h"V Ȱ6ח|GED}6|Ֆp>ond:A`tD\\s<	q\bcc. zk7.ᏖLeX,I2t&	OyV(e`#rI9А)76僮u*$×zF>]en>p8ŇWW.V$#  EgTǼ˳~4lA6Drz'u-yTa&NmKc\͡Pff)tq8cr45/XBx\֯U+eǊK>Ex\SOWLfm]c؈9DTs_xuf%ZՑg2'I()ܠݷxKăkqMe[ p"^V./4ha,rLE>RtHC4\i<j	)Ki<F̅ 7X\+21)n1#udYT%iꣳLQ{cs0:h$-%0ոQ2Ty@kr_bbcU씿dkinߌ
$b4Qc_)B3I@V
OR
]$ⓙK2hy{R<E؟& GZY*o,uZX{6azgr19nR1y:MYYaƩz*\J,idyɲ5?52%-5I4/Fi$ I-S"m\ZulVgbQçZ Jm+o;O@>z# UM)0=t:I`]p6h5~
>߈/ܷa-d[>o5H'=\ޚ&	Al_=]:8Pz0=
QHS
'ɫȗ
zipiEbe"xD,%Z)ԔDpʜ nMT%$J	m֕77[\%i,b:\N`a]LgдA4`f%	cbuL$|s},J8N	|QLgυnvfrc3cdѴ[[vb\=`ܶ3^);Q-F9y-b$5Ɋ>OtTzBD˶1ivrJB3Dj˵`(fu.hM+ο{ޓ9۱iqd/o)?BDEA˿z8HՖd3*$E5N	rpMPFޒP>`˴5T2t^_۴ȳEy~<>qtG>]E
n=o*m[amI\I!坭iPl5^EID4+o6	u_˘|(nv*ȗ1<e,Z2$!ݑ3tB@	¨4GCi'
Qǧ	MԚ1t#ijӾ?w/C;~miD+Kr4jxIȏey,S
75`A̘S%
I#̰tg ((ߚ̈́`&=+
pMtCZgj{tQ8~f{*p
Jb@Vw
<R)/+oF<TbcI:)R]#r{Hjq30y.sln/o,g-Ǔe=+ 䮒}1*-( bqdj;R~ #Z]D;Dq ԶU!6e_uF6yGɣ7_C8,YJ_gx6U!})xx7bbdt%qu]4ٲ33!x`܊L_1\]J=-
'akX񁸨jKO{2^lL
6Wm6X4C0g!}˓~"/5ρ%sa֑)ۊ7՟U6C\0yKPCE4]$c;
oQM|zL%uӢ$.ufp$`,t=J'ѷa/-t5"
⛮#\'ÇUYԏwHr׍6$4믚]eO]6zq8A
LH}`!fzXHXbQS/
"u\^G*eySXqxŦn 'O`e復O!قaO.iiٶr]K/S-؉^@շ)蒍DkZ_Wd?/On}8*Jr.Qvr 
!>L5ԾMtF/gI<m.Smk23|G*(&\"#EųdRנh!t=H/+mJΒi+^jaaEKfת`b+9qfI^Wf5FbXƗE"c)836w\b)E6 bvr."_]]}Ƃ۵ñ<{٬隗bw>e9="{#o;}1Yhq}~7 
/> Wre{qa8.N?P
y-T-*#L+>Y"ʒE	Ӭ YdqV=} \gVd:&LFa	7̋?nyE*aABs$?iS\>}Ak%#pro9:^m/.KV4ްe}-n;"Mf+c5A1Ie~DDbꂈ ,I.o&bbV ]Eb@©Mw?{9	$eh&5*||]G}ȩD
c^-SGqr${
A48=_F7's%^3&ΘVʀ^#eg6@P #(9yhbA!L<]h)ˀz1"݃&	>@$3lB4.!OXܮgw.\CyHvL#:9Ajqb:Ht SʴXkOjӆcǟE^XLm=Nx* *fj?%blܭ[AC^h76f಺xzWy뤝,A%Nx!RnI\V9$JJ{;
`ȱ.i cϱEo#1~Lp2YĔ4$^4$h(̑4XpVdEđɅ%25#^|ӋЀ㊯Hu1x&
"4Y'4OCY087l0l0 X8!] hjLқO\fF'& xGunYOS¾jxթAayi|ID`+y:̢
+<Pe9ޮ''c7ÙD+Č[G6T,Hj<p=l Y}h+qYi]|('4y)nmDq;\A$
%
kM]mx
]ź*#/!q.VQhzLX)zKnNaՐ%vMيu\戟kPSݦ0ClkΟs,3iQՉf (3L/ҙzs#c!7"[iߚ@"A 8  3Q2'1Rv +:t$"evlDDnk?Kۄ~#ʙX{[iFP35!.n]#F&,U+(ީ[<T`Q`Yo|^cޡVs
F)Gyq' Bi&~(O$hB+r(' NP.o.ܸ% SIUqV?Ywa1/I8w'gza?mIy@}rHʎYP:mfїH1jga?x
JsN$49;=5~١I؛ګ ]TU!@'w<FcAOJtISŻ:q=ܧ>IC
BkLsMB_((R1=քI@t_hqoߕ"aAZKG^Y ˅н*M0ĎU.ΚJkeUHah혯%pUe!VSpYą k 97W.|.C!Rb^Ğu'. "h26cX+HTOBxS9]ݓ{=oY/ROpG_Q1qaQrU@HH3UVۃsB遁tyj	,d
yIoPUp𢍪&">,S$9g/g('δ#/t./Tӷ!ɰPϴׄK T$)Eup5TM[T{o!/!c 	SQ$Q7ͺ(`@+k$|6$OM[q>7Ѳ>k&G`៨'9+ esh5zG5XڀiьQP}a:d.K'W1YO|{(Hlw~LF|Z53hY @b'{a\
# _9jD 
y7]J⿈Zg~No}luA:?XߣMen[,m$3ʬFo
:"sHbc\;7߅*A=y4_rP+Nm/g,sݽr$CV\XA*AZuڜJ
fq$dOf|G{q%?j[y"gs5S7:jc\7sZYR-]QܺXV,˧Jw<]Csx=@}qN(4ߵ9y`HEnZVF֑Ynr3|I|Tߒ9Lw|CR~; 8D}:^uv
!
q-F$Rf[Rg쳕^whYEJh\z	qОpHHΖF5Xu5?GH]b>Udb$zN|D`T8)fUZ"<UU#`Ey$7Y4X`v&s9!2?4k97pYݴ*CfHպrlxf!;.4wN*f
SKcV$X	(< Q \Wwc@ܴXR#fv9΁BL|鲌V9\C(܂'u8迺C,tχvti@9d4
8%Μ3բ5Z9 蘚4BoX"zdk!NhIZ&	3#jgV[Qor>VI^9V*~ClA>1W%ONHr 0ɀa4tfWCpo񠜆@i䱫MVTctR*E~j|7Xm'g{G :5 k@bȎܔ?YIY5m% W`ÖM]
7BϓIqJUdp̥ZF,ϲAE8y.S+^ET5Ofڙ
0%ypZ#٤%YbnrW`#!HD١ܻ{n,s8QyEs
׸f/D|b ȏR
`\SY	I_2RCe9GY'x(+>Je;KM6h.>ZNboK"H[7jߦUKko+oE~"w CQ/%_xqxۣ`>zs݉
ņP4wfTl!φoh%mԂ,.4D~FbwՅs/8a}Y2\:#QZgV\L&]I37LN?ݞ#?;rHzs+,[Ndj )Qˣ$g}ddNNc roI|N/λ8I1Ilhf4ePpӭ,>°JX%i<Pm}]>훴f	c!R6捲kS/:ՠ5-VmP=f츹]reg69lB p춍cQ: DM~ET+?VJ]W]/<H@-ijȑ
P~o3
扏R1QoW<Mӓ2>jUR,?ͮ4=M+
G0Nu<ZpdE%<dHquBz5-Wk\3m`5'\t68P[&ߺGE;ұ!7Pךs $38HZZNjt㻔(__{GW[-]*眼쁴KräKKH?mjIpn=U:nr¨E
eqKj`m/EQ%(;o
?1٬FWdFgM{axZ,I9ݪ`(еP
҉#%9dٲ*ۛ<\.S2Α,"ZG3"RzNr81<6h&ĩ#uz*:E9pNNiRísQ(0㤐/IckR5Q,N@Rb[;J}!Eݥ\sZ%\ݛEG.NL_I'y>h\%n6
CMUxKW2@A/
$4)FbD /`nn U8Ê}!$3nWBv!=R1N3B3p3"ExONsZ0m`Zͣ}2]U`_5j:	r6 ALnFƭ# nD6ւ|BLoh!2mP0YLj{OiQ
}
k7FTL".;GT:XLg?<@-)gwexϳ,Ge2{X)h ܄V;@W@fhʓ-Je趮"Z[ܴjC0ak`	LL%up.0^*ZI<-
=/l{᫠vfmpB	΋*  PGW$-jb%[K{ܞlі+FGں>zg@FM|050-='+}4R.
9 &.\*152R㛍B21čT	%Od3&]:;qd1H8+؍]oLTwzj}7E0mD7M:op2_}5ߣw5 _I_uz"~ z$-wFӪR;Pu^Sb_̪0A[VL^ w~K|2tґG[^韬
evJ`eU`z<Q J҃{
$	124zܚeJTa
ieDx 4Xj`+1(NYj@iY
ٝ2
֙S`#kV
~'wt<Rc>Q!פSJԮxx' (Qh!(Qcׁa >BoN&]QT-R7e"nZԲ̹M#78,,.c3ҾK* ω}ӐBMZfYxXn)v2 4r%	}`f2ɝls19/MGuute<@~ۑ((@.u]}

d`W+ 3\[f sĒ049NUU@qn6ٓ9K `qh֠Ʊ|4C]]"ͮˡ	FrUP . q!0*ֲ*ХtuWTh}`~
Wꀰ}jZ$껱2%*v;8UN..tw({ c;!imWaUD<ܧWϢx2p`H$XBm^
ϵ[3!g3ѡYLg\*">{{gyfewdfHľ ;쒨ˣGΜmOn${|<?5E24d$-hdI,+ h^!<ĚNX12`oS,7ܟ}e 
v8|bcZ^J|Uw=p퉴f)z
\lAdAcAApљy8X8xb
l{`X`I,ܦiH[>U26z0y3Ǯ#mPXW=KJGr`O=t>.\8{&f^o|nЁH_jŻXqi<mmuԀ ~}
A0GR;Xla<3l P2ԃ&*jbtv
U  PE|^N-4e~O"ˤѸJ*(PT"!VW$YRnl&6_j-8$WD%5,;[2^bU14JʁVm.YV#NF( wz	\l@{Ń~,ت;N &CJ_DT^1ψ\q0-A(:FJBL7oAq[y#
ʝ "<RY5W\]$-P
fHL$o>򀯊
hn\^-u"egc-m!F H*BɡCIU]:ȻC0ْ/T !ۯ^'EDߖҖ.|xpbC6L;ܩg%blTBgBlU*6X
zr-ު}p֞Ne	up0$kNE^r{D85hp6g6BS!WhX!u
uk ^{;	>8ӚB#=:dXC͎.^E"!Iĭrɛ4dpz&If#SxeTǷlw	!T˅uFI _cwY^W}AJQB)h"xpA60AN5u!aDmr*RN1TkXa{tq$Avz~0ɊAPP_+9kfEi41jzqö+ݰ1#l]ʌ
<6p^A]Letjҳ"Ki^{n{|%P`W jMG?gWPf>1SI=!:в>oaSkaəp̵/\?`y܇ьt+dFdi/i4,\r+Жʼ3:ee85JפLF`D2/H5pq;!&Yho|kDy君$w~
=\
ZfvH[H;
9ick$s*ٯT09¢]Xikc/E$Ӿ]ΆJ %0
#)bH%OJo%ŀ!F[:-9< #W51.jFqt5:aѵ>+oSWL!&
?)3ȠgZW&1bo.N^Gk|W?c
m+d`HI/]xW˝Jˤ,`,Ew^|SXTMVUc	Q 58dFZ!肇w>Jw׹<`+gt$ܨ.$<oL u+<ӚA/'ʆh
]meJQO	J9T %@\
jqma?/Jƛ2E9R-Hu	 ЫXf ~aXsHb?)5._x\OvYA*.|
C;eW?GO'?^?}^ӓM+4NI
p{m7-	K\YgٕOP2%l-$D{_`\M&MZ<Qt '3lu)4^4?I\<%v~NĐ7Î{yzbQPTQ=pT4
}'O
_W1Ќ."jzW4VW^ؖhMT
J"lcZ>	-pA-#5pɼLFWۢa XP//%P~S!V8]$StN	8sI!cR'WI
e-R=b3!(As%=W9`Q|y]L@;=%8FqhgIAyVo
hݝѣ^L$sot;G 
JoC3jt8T#B&)-w[e
W'jNfJ`@>_ٞ_d|c8	}chhPȁ6.qԄRvBS
z0d/ha"Zx֠(
tj E0+9?l%PHŪUҺV+h&+dH	D1.nv_II]Jm`P0S:[$ߊ--Bdu%Iք!h>iݹ+<XJG<FQY4E
+zcvѿH*ig(c{Fk&Wx\fռ	6MI0wvp%*O"l^)T:~퐀ſAg_1/~Wulwز'ho;t 	x*IY-~#Ois~[׀d5hjystxaŰ
3ԥy 9v&q[V?rSMO.APܸXK$r끞gsN+-hF(.6TduqzB5b2Qusm,d*lu.6WmѹꫳeL$3#]*GBy&x} Wb0$Ǣx/⨒_+КZy=";x(VOmk( Zʑg-~(5*[P;WBʐgnܢdZ5`To7guQx6 Z*%Sb9E-TvPNGIc^")*-ChcUeo=n6잛}7}$a
a;h.`q?
Z]h_a`lWRr2j]c8}5Mu'xq1r0priNE  IeZsj	e6]MX>Aj>[sڟ;PxH<u"C 4;IHa4sIb8<zpF3Ŷ`rփHRT$X44x.tOt@EZE_:=?THXUaTd_da@MB>[('PS6>IF-*eɖh4'j&̰`a;:`miUȖ
Q,jp뫝o[
s?ڴjyiQ[ɚ%n 
4Є4Z`}BOp5{&
JJnYyUѥro4Er9ۺ_>{r	JIhHbDU>utuIѧdL'18pTJU]~8 cdEfᜭ< ꮯt<j\exjc 6]S^XnN[UGڰ)b5xc8ʺii&	QćBt2ё	ڤTE@x9B*?ݜ0q?43~,MIP3rX#ֺkƃ':x)
;Ë22SUx\SD]C'ٓ^JN;rCS|+
n
bӶ2%:/oۧ]koy7W:D'e>_U2+]}}jS!șX8:zG0=f	- HçKFv:=gͭCZ-к%
̮3SK)+Im#X+@=bwrI(w] -IX*./XWҹ^0MII%c<	X?%I)Tw1jE%Wuf4,Wڪ3c_z<aTOq*l5@Bʧ.-~h;AK⮛s=Q1,FN4?{VCUΎ7_/b5I^ސFo=:ò%'1/b֞`n?mm~5vvOgG#ZmNGgG^޺˯{z,3?".61o@%$&ps{Su\1˗&L<uPX=_G.4tz>#O`I3?/3jgj^=۽.Vd>*]l%fgi1 Vhɰ5PHyZʌF5uʂ#HJZ+^fa
`IDu,UHr]1,i׈i@7|);݆[HQ#y|FVwDu.#}OxH
\#)uv]ht$$.
)w-0tG}6-3 }i⵭2;C+`vsA0P.[ɢX֝3QRR@p<|w4Wfف03%&U)ZuQnK,9t[K7B:c])SryQbd`'߷T /MLӣ/~'8J*Z"ũԀi!q p)0J#ct
ן^Jv{%z}?VURv\vH	t\h^
vh^
~HbT[$	{C)iWs.xhb+WC踽ѣ(P|Xc$NSju^(!v+It%*Pq ٬m 1,:US*.p|Jwci)xT:0Pp(嗤=WsWQbݗR1CyQ7\0l)pʝ o$f	Kmr"m?,{+P?´fH]ornp];fGIA
Ik);|rE	>8OvI"W
M@q@5h>PĔ LbrcX]"+	dh.ܼ1>@ dPAtʕ`]k`eBԒ6hr9XE@
66L(sZx-׈,GU  V-k/k+w= Tn9aËEY!dԹ4_97Cߔ
X=t*ߵHz/-{qbrݻ
t_E:LK;nإ~m=@\+[Cgckk,d
FAy`{yKz9ԪoYQ+"Ҍz[Ehd(F*#M}a;Q0#jyM Z_"&kw"s7K6)ߞWSd6LmsxY6zǵ0gE(yj4# ͺYIԎ۾\o(v5'vJ T}G0Vbl$}q>,i?ry.l+B܀ Y2+gOwi=6xhqJ'IWgDCԅ:PVpd
^ǲDF%i]\kɉȸ+7T3xs0O%?K$W,c6!|yA}cf
wC0Ո/+0qd>75bjkpi'<ҎpP&awY.ܣ{sGs?H`J]T-VZI	j<hn_ѭW%,
6z~zv6n
zmъ?DfR8v{$ݚώ^<gֹh]י˶73;ћ^<Of8F\_x=]S^
 'ݰU`axgvHƐw:PEHemQ&5aRZқ"N0ˡOB.5d3ǍW!ǬdyyEO:ڲApˤƅ
pqscs򌰆A@ud]ySB&ʌ%Eq2B|(bƆ<D7snx*q/,b.FA8iw,]Ʉf3Fh) Ok]@=rr-/ߔ{ΰp\NO$ΡtTbƄi(v?{ w2amJuqk[OW?wwvv~-y.<;ZSLcNVxŷ<Vm)^5lm
:zۤsH`.TG^FHs®5\DrƚK]Cx+Xl.	<CKF-i
xø,K*yJ=)<9Ӵܢ_Vf5Ǉ5M
DJRduys@681.SSEm&Mz!g	Dw0"_B91^u6["Ĺ	
esw*[u?jdbxrmLfzDJm]J~dfasN!jyյT*8F,Fw9QzD|v<Ԡ1!5*j7%-2^"[K\%*	H~x*L{Tr-}n7pd:^fݖ^}z:$-NIpS,i]c;$ujrܒ AZ"ZR"3儋޵<W#P_5@j3:AA/Udb@Dx~8®iYR+ՙ==Y]]	\@Hu /֓Ꚑz"cQy;\f9Uf^tehC@ːvO_<ZXVNh4N85ngN#/VfjlӔkuKNHQ
w\Hp2-3x:.+ГU4A-7ƯA;%.	!u!L`laB9̑xܮIVwGx(gd#AG/~bUGZ68mRAWٍIu2]UuYe!&HZzg.R9<F>m̮`p`'R*f]}k\j߆'}b#]δ[aloC</E;4_ir),$YRAOuR"]?0@CEZny)h1|*+C9]J;*JGQZ'"*toޓ
ݚ0saJZlzx]
c}rx$2qԭ0pSv\NO|(BHH._ot-C[lڎӂ|	K:cKo,X(ٚDӶ8K
@r}:za&^sfkMAɤJ(*9[5KZeEPUJaaJ#q0U{^:ƃ26VĘ9]
{RKcK~,I!$1T/ղF  }9u~Y7SR']jBWjv(qDtc^@N)z<Z}4O]ADS
+4H?%
?ʒ;H-_ƿr].z?vZNKZSٙwӡ-(|i
xЪ5A`uXǧ
.a+wJ'aY|^[#iUH)_z]W݅WjKщ|N_;oͩӚ>;h!ɭ1`ȠF$6>ܫ%0>;$owݨG%>I$<}̀Ò
@un΁ͱ^ne=P%|4$X.r&,t]Wbji  ǭR&tAPY|qBV B';nE:@sTu*g	1d{PMO	Ϊ1QvQaH1̄!I~Da!я<	ͼx9ʏQ\jWބiZ&cX6[ k$Y'@pWLY:He_, (IBCKKo\kE2l	*"3h%Hb<l&b*em
IZ`ܺF,z͝
jH<?qei~c
40Ǒ>[ ]ie.]
lT-FN>+X6Fb|~^.E`t݌
@Jb"]s;dMU$$3g'OODJ6RK0.@6"`RxD4>*um,
6K2FqiN{5Ѥv̀dم 3RJ*E*$Qä䎿fn1!1H{m@D
yv>SF[dRD`QW)T
2F	h%kξBt@ꯊ?7|D*-8lƀI1:=#RFXF,uOqTs^
.Rנ ZjZvK b`oLs&.;%JFsز$X7
C=rL/	Q4:$%$j]]Mӏ	CUX[:h5+p6~s&SI22W4e
%X!
xC%2$HG|% l]kz<,f
)'6Gb4`A rb
%Qi/-m^wkzP|ol޸.xHkcŚUR,MBtnF 4㬳jk*%_ݶ1X7Y{ߐV*L"
Ͼ1[. n ΟXlm )>v) 1=eE4#*|84Z
A'R%PdA|]Zjei+|_]lY7vy]uWqrgq#V՚atՂV0n]NKs73
v9=,),X.7,7g-<QСj
{JO/ƱK^d%=x(ԥɏNWJX:DX6"D$Dά=͠ްÎ2ď&d
_E쏨SiV'a+%A~F$gKߒd%D6eV $tpR&=>?ŰDYZbfj䋜hQYQV
㮨Ś&UA
P](8bjxF\%wSxeAפQaj7QWrdi?(L)Ҥx$۠[xCpK
$<(6$NwѦ|ϓepgbtʶ;)acv
az:,4+̦/EI^<Q`94׫#M2!ݓrUVވQuW_y>4L㤖Ĩݐ~U;n-&˲nɑcܦ&ȣ-}ak^p46KWVt\	ʉXoYĹo%iA3kj*!Yo:`c
M6 *s̯HcW!_
CxA.L"beXfr9n'1;|\_8w=4J5!$s[mPg}*}>]?ODAp]ЫbQ_
h|Cͬg5Q\*2	.?G^
" oUe=zGo\P
be&PH[_}oIal~ .jjoduo:ZZ`Msj)\2X_Bp hjR$"κ%Xdf60N2biy>RJ?4Etx\9l8*r͖j6bہ"h#tE]cɕ2P"ґ ֢~^FS+Us<tnŇiN\RV?mk.H,#%m`Ohs1jL1
Pϊo>F
]Ѫ_4+.qOX7Ri̀ngE	`׋Etp΍I
\ qЋK}K:$&,u G}":w-F
]jd!:r.0Ț{غ}*W{uYZS2~"
**3X쳃ؖ@<]Cz",tX }_sw#;뻎7海nwN˽BvY+cO9nrLZZȈWdFg7rV$	{r$o^i)A@h!co,Ӿ,X8"b}~tq1ht=[)Y
~➡[^ӗ{ȇ0pH"M.a(puug))Ps}fߚ{L
p)%	`&{8ؚ5$@ɂx0fhLUnw|qz\7GpaswIx©پק٢S..y1t?β{rNWuɦc2Ҽ:6EYњ(gA^VZ6B@onDqVd#/VuFQsbajQuSЎ5{s.es/'>mSG;d+"!aQp!c`J+V}ʕ#7A}KfC J2#yηݚx?Xkxdg,;{@p[)V .1g!uk,GzKpG7s(:c|Fئa9yyp'Ӕ5kMY7yEpܙ4oI!uhҞq)d@'+P[3ܹokDXX1H6 m͍Xёj]"vUK]z⛺zr]{M~<bs;FֶWzʚUrhxo7h8:ystl6"ڕa6Ov]<oK9A~~ů9dJ<
DGQ,-'8*44	ju6g\i>t('kH*xIYqvZ?|RX?=LKxCL|#E+(P,}
T܅g͈<2$s;LB\t@&itW_eVs/x|Oa W#ZqBAPiyF0zcnL e1d#|nzc%b;Lc[?]cP#h)x3$\]<ggU%|w\Gip
IK((P3
L\g;X8c[}A(5y:[Z	soE/M~+Fr,!CWTʮk<R.o'- 3J必ѓ8GU ֙:AYXU-MP!7:8JT[7#_,:xms/
r!Vtd4~(YR}IXޠItLoh#>ؿsP!S	MT)n-y(S"b8B^$DW
4ߜmý8?-i|2&]p$$ŕ!78yw^x}2kuJk3i#6ͷcBC6GeAhǳ+>n^&ǻ$oooliWIEll\
s.͂<;g"rx!ۈC?Ě$A
~ǯH;>:~<w&igf(|1h[?\=?:x"ay{xZ5³t[Zb$ңhP?y`04-@SǷ}FٖZ=i=-όqTP}}I^㒥^%q?b\b\Qfnqele^s! U+~qZX$bYEN2z,) cDVa\憛}GtLJV?Ӌ#p>J(FA_'c\]Z[^Oo,ٻYgZ诮vO?Y
PuY&USZioggwg;{{;?o66^~etqJ.*:9 \Ш2D/Ňyt2peۅ+zU/kb6/
CC!:-1	[	:{̺#&8ƥ
c&qIv|k8?=9f*ހOJ蟻3tcȈ
GA^r3ph2.l3d6U>VAV<Btl1 (#VqP\2	6Ģ0rDGi(>"G>HCcgDOT`1 o:M%xP'*+JLWVzմ|t'AVRMqrW&1Ͻчy1(r4>-[XR	u4h,*EZRJi!}U&#;V+0Nz3
ʌ{#rP)81`=:WZmjaYNv;4xJ{]핮ci9l$4{0 >c8B}x_%Y
A諸LeJz5p&q}oeE&.SjCjr
ж2fM[D
,`}3-4g佨j)5fܼn  ։WDqʅ!gOZ{$&hRh%,ަq*1`+}b܎`H]̧bD6xBtb',|P܅HB-ŷ@
Y"s7[ qL,Zkέal{{zt9;hWZgG':aǾ8"q8RkDP;y
	I#iX0gj` ^1o2H?Eg&RII%p?Y){ &u$ö4Gn`CZ5ɏ$-U-3J{Dm`=(D]"kViھW6\PhXcZ[
gHDI"-!$+V813wt*КGٮ䌲!<ť@El5e/[y؅lDcH(@9`'X0WF5Qm
|wH4:HPݝs~ZDVD;gяkO>!?_ACd^ʍI'2ueg?jas]g43VGI{O%[-v8D4Ӫcnר0`
}qoRU+9P4b]J7$,l7 NPg|Z}0;mtww'zt=䢽
ɀ07"M6 TpLnMqbqvxb,p5NGj_F!h>r֖J\X
ok\]%D"bKm,!Yf<U㴚=íh
CK,tKPAPt|(W#b/zwL _d81YR	Fӥ<6E4`9cp"C1@+V\eUty.0;E67B'I+g*th9bEq6Hp(O+@|Rҹ].d)wrq`āqzZ4LnR؏fH=ҺWxˣ㓣W.驮^3x4Lx5Im6"N
|Go;ӴL P=ؔ+$fsV(DL-U|\oL/܎	jЦTӔz3\W­U\8;⹨rU/ljy!Hz+ֆ +g>!^4Tni⢃C^㤠 1`@pb>®=^iLڠzڦڤʐ[kQRk?p1B(4`r5
Oa0ԭ6sl% Lfpygrnbئ H suK>P bN+C!m\va]1gy)
vO0G/b}eo-3yy|'Ovj/xhowzh}*naE FLI)=IDן+m*]A_DU|h-f
LQtm^j$eR%O4^X%rCK=͗/#MF2=jyg6~GX{KIre$46/^ vlO?⏣ҷufuzWywǷRdٵLvJGbJFfrl<qcɗ`PI
#D"FżO~*O/:kD3bnk/um}aI27!aAԘºXr^F^He7e/DrJI^t?P/ә<%PEo+q K-WEZ6OUG\*_2'qWCH40hf2D,3Dp`ݽ@Lg/sy}Hrkunm&
op&[>|Zr+CϮF4`{
y_}uҊ62	߰1_Ιɮ'a3@D#vvy\>J_	71sB$sWת%#ܪX -D's<m_Ōa4+B|K"gfЧd)f,V,4 dٱ8xpUXNjZm(É%	uD^q&v{wt^bJON2Ά;Kn|5K(A5O&g@NJEYNbWA=du]XrZ<)H6 d^BUAoDs9m-vd;}B(:A[KjݩFD."uoH@)gs"Q2%=`p@A#;+w/IY5PϝIMq8}Z`5WP!0o'tRu %⃺X\>,E)1D$ }Jn6Y[Pr:<*F?<TG'yem5Be[RZ['g)RQZ
}^q!Bфn+쎐Ah\N]aA{f'qJrLS_ST|,bv5"<ʘq\Dt5)ؒY>]'ԅwPmKyZa:ra5je_`]̐Uo\CD]-Lia
 ƨgRoZo[cH-*Ui%8Pm&q	ȡ| hjpbka	j8~9AIZ=
;T$ޒ.fas[=(6"{2Mӑr%ƞ;{ɧ%DY̙xs"9祍^E3@6I.1DKmDEonm)'0-27j#"}ٺskOe:_dAd@ׅRXҤގΣ?^ªƦV-܈>|M~qC˖)t_翐4o?Dߧٳ'hOٍ۱Sja1,MEihscŞ={jk㭴+E=B=4_~d?G?R76HNc4B߷xhㄔtEϟZC(%חd!<z3%7.A;%FlFK7~k8ڣ^hF;442 |ťUav1a^-koIѯ߾<lqF,vG?>~6eP8Vu_w#y8<=X"1ՒҕSျI%PR-#ci:a)J	3eƾԠKצ,EUxʠPW-%WD9)kFAEo^ >c\|Ξ_g]yړ۪M3Iu WVgn}x.z\܆5_rfO~y_xx6{PO1<h Q͞|sF[-.t[IBR'@͹׼B6,ޣ`=_nNv
RD &I噛tCc 	L\e#AǴZ!'?v;;pTqv V/JY`gHX4DXM:t0 ߅Fo `a7!CҨ5I6m0o6ၱTւ)&DMVw:˂U=,-emg&YV!kfz"dؖ/{[	{
%W2U{hC>䍵ruъIrˢ
L2'qj
Ǿ
ԛYR`h.M?+ݤdCRjIEiĹasby:˳+vJ49n";Uuye٥F憔}$[6>=g&V-n-Nfl\^U|Bv{oǙ6F!;f:~I6VeM$YM]֢>PMxAJtrkM!dD `yq
aMksBk fJ;5pvF?tdO>?G_H4``8	pb`G(u~Atװ#	Hg<&Utm˛ާх`OVF

D"m^@4|U$aN;˯;
J= E;;FbzgaS'*BЧu$;׹O6dJ4m)	h;$2J2Uڒ7[Me	F?1`[J
Q7Wx6
jK:d)1Vsoa{Ӝ(0؜T\JCr#١g!nsQv+Ơ?]9M5u$s$wͅ*)1Cn1D햱'.hB0dBnH	[ijHacc|vt2:9~}|"1kiO?3̛A\Sx$f(j6Fk̵!h.Af" 0ȅ=,
+
=qK݈K*k]w?ʻ4;.bHЌBn,ėhH>#_r>P@l=B\=D)OS<P6Qr rY]E'Oe
nP?Pօm/|#DkwR@B|*
%nd*"I5{])ϙi:ϛJ)5|~Ձ!{شӢVFAim~r4P^kP|Yl	!ƺNI93	"ZI6u.j?2y%CBO`DV9g9ߙ/!$eFHUBq̞)V 
jђ9~iv7vWUvM1V뭅*4ӻ0% $iEZ ЅHWKaMX7ͻ3g`0\\9\J&j5񼥊菮zWQc$,ˁ<3B@rN%=e[&qFtb.f[K_L]j{i pPjBcc"KO<WYT}Wl ~6;l&oo	Ԑ nP*E hۣ'z+ERDl,O+$(N:B8'..%w3{S^fklσ&
E,[IJ߄|Bs<+zB"}JU$۫<J5.xI萹(4&Ap{KZl=鳵Ʃ714"M qbȞ¯dqبY
AYe`	#n܈ N3'n~K Q#TO|7p({8COB8(ĦN_&B.Q7Zs1UyIyJ*8$ \6-I=ɨNi:ZZ >g	a$Z#OG?\D<:7.}	-_8Ht>X!qss<̗N2X߹o|uQb!;2}RzRulOל45\'ܢqJ^0D Y'R]@!iXPx?QeUvQEx-4xl}W"XcdM^
2BbF)D蛼]~/rw@:;VK@>{8
I8`&Pzl;{ٗ	Dk<!"Di7FVp\܏ "WVN,"buDTxRUD_1<%FP>\ĤsU;yV@כֿm6C7~1`D,\8-WsaeD-A7/E<؎wӁ:o`)d!ـ
u]L=tܱb:aAΪ壤%`ԍQOK9/%U3S	3Ǥф [
M"ek"c7eq׫iiJ6#~r_MqW):RYt3==-U 1j8'Ǫ:쏣XȯG)W.TR	 8-uGI%ZE"<N']VjZC1nyPߌk,dŖT*Nhg. &y	"D"R(24lppaЗͤi!
~Uv(=X#V5Ӕd('q7r,ZhChߊgF"fMNct|溠!dؔz[1A[pVP_;g{ݧvF;Yx(d]:Fo._~, qh&~aVAfIu piaпoIo%4A:)b3IM=QjEЕr*WjH0;cVemQK\C`amfLf=ԁ4 JmGSn'dPg(zYW\DќW35/XdkZ5<]P)>$D 
'F,k.(<OZ6].pTD 2Ͼ=y\V2>u8FKflZ~І 5Ucgj.hՃř}$-kk1-=2|^U<;?}JE'K)sVZ#/_J0QMq<Yt
ݜ$	+E"1&R-*6Y@5c/ړvBѵ<Sl(麉hFR,F2˿lJڙ`,9ka"-b!PpR,@*-"<(Dj(0oDC =bw,IOP~54nO+'g}Ķ@!K|j%?H-d4gABh<1j@P^CGhB\#цUn,aS{:]n<zbރ;$a
6hheTwSg$Fw(Sn8
kP +>	!8$h#ອ"ĩ!LCRc_(	:"T`*7ZufӍ!uFIE(~.
+*O޳Է~{AB,%,ys"bsbCZw+Aoʲ܎6$g͚JShMfZ?9\gh8Qi'~
N}ͨwq~fJ,yP$PtcwmZApЄ4`t6-wawgHC}*}-!Cʴ80tsلvw~g>
lJE>.=]
8pB@Cǉe>B{g*C~6|]>bٗǌd6V0ASkju/Bο	ZkK;gPNMoчoE0SPu ~QUUPC{Oŭ`$xũIb$6yri^$jNo/N ~"N鰭K\ mM|rn:z%$aNlZw uDhzfk,U,]GW\?l Cp},|<nVM)%>)v BOV-'6(-.PcGie7D//;=l:!,WygT'l\t^C6YIi1ղ?̕pՙ'+;I|y\3:8LKRGܱţ@)?|Ctx^܀I͊mJ61`\]и˃@yr
EΨ)y+m,ֹ^'i {>VK8J5}) czoLbibY*al Nmb
f^&]"u:	l,WhzΚy/8Q8
_@z:^P**@;qaQ?=3yIQ)hgdL{{O[>tz]%綋)_QÁuB#;MbK5..x%JdiktrϹ[?Fp&SFBf[y񧲺){G) Yl'ʑR䩉|N̄
Ie"ћO߼>zs}wp~|ՉQ8dDDh	ߨN1ac}rls9B`kָ*-Gs.͠ ?tmEr݇)m˦ 3RZ V*?lzsǤ57 w& 
?8.\i&ByаtX
<}˒H]UR9)Űtu18r$"Ii^
#_&+[cҘr0xmAK0iPCx)4( rY00,~Mj$$4(9%GIzI$b*nXHx
{+IaI
f8)F| |K,W`Ѱ5`eT[
'jLf)8ӥTm(#DԿʌW"
0NKeVШY|VY"n	!bm0
Uf1a+8^J%BHO~{	f8|;8}8{{WDBEWivsdD.  k\k~Gk4Mx,sOw-Fu3x~A><l<F
"FfZeӂ5RW檜fx98fH.9u{O?gO)]5#.1bQ&$Ee'_gǮK])9Bt1xՖt5nؠ$k[ۗ.릘ojD[ooB7|4T|$]ΒQ2{}zsUE<vPa
Kw3@ z[wedg7p7iF\~. hN_Х'sFHKĄq7|$$lrma`U,&uLbNES繪K&y H
aXl=>눅g&f6E
48% qoȇt3ܥY\'H]}ȷ(.Cݫ!:Bdi-=1O(Z*mUv K݇ǳC{&h\H2ID6G,^NN_<?#2̣{oG	s}լ.ZX'{Hk%sw+	ctE$~#Dlu3KUCLvE|qcS\/XZfjBs@Y'j'ڱzZ [$אPd/ J(ݙo8o%2ϵ-s+(uU(&&OFEl0&6\mğZ҇WئZM+8YUwqXJM0Q!
=n5|aP!˘X8.PK׺Ɏ7CfY^;t)׶Y0b tN"F>$r<S$G$kVߞ\oH^'y
AtFL:<h{PFܳm,^&9D6oUn:DSȔJ#e=zĐ]νQM֗O^Uآή5c`h`r
iK\TY
SײF7 Wdt`X-ͷQ`x.wJ]y>J'_
S0WF	HFEvuﵿ#ץwJo&0I	{W%V,M-)A,
54f.o%ԕ{)kn~v 1yTK?~lgwwwowom6ݦɝ/\܋;j&8tO]Г1x Ҕ.QjO&wa:o$yX59~uDi83fJHˡ.wħ
3cv6X癭IzCAab!gQyIv𗧞sL
O߄&x~WAT0%dt52!A
0XଥR;.
W쒵/tep	I`cceAMm:p`#"+(J1 {A+E2On!Hv_AU[RdpsQء/WZN-5}"(H 2ŘRˀM(h%BD|>?g/C?%VBS
8!VTӑd/kdl"/lue&R۩]łI+qqVI~ǅ./i"ʃ+As8J$9qAlia^! a<U)aVwCl\zUpdfv03v(:dLzAhWOb4^<9NG&C^԰͈&X z=Hi) 9W#}L5y,ĄhFb 1.1.4 unmatched brace at pos %zu
 illegal pattern at pos %zu
 %d-%d%c%d%c missing ']' %c-%c%c%d%c curl: (%d) [globbing] %s
 %0*d              nested braces not supported at pos %zu
                         error: bad range specification after pos %zu
                   illegal character in range specification at pos %zu
            error: unsupported character (%c) after range at pos %zu
       internal error: invalid pattern type (%d)
 url_effective http_code response_code http_connect time_total time_namelookup time_connect time_appconnect time_pretransfer time_starttransfer size_header size_request size_download size_upload speed_download speed_upload content_type num_connects time_redirect num_redirects ftp_entry_path redirect_url ssl_verify_result %.3f %.0f %03ld    +   9   C   Q   ^   i   y            
   ƞ   Ӟ      	   
   	      #   1   ?   N   [           {7"8T8`8l8x888888899F97R9a9m9|9999    curl: unknown --write-out variable: '%s'
 /dev/tty CURL_HOME        .AF<N<U<\<c<j<q<x<<<<<<<<<<<<<<<<<<=image/gif image/jpeg text/plain text/html application/xml application/octet-stream %s; boundary=%s
 --%s
 
%s 
--%s--
 
--%s-- 
Content-Type: %s ; filename="%s" ----------------------------            .gif    P.jpg    Z.jpeg   Z.txt    e.html   p.xml    zDB8B>B_BBBB2ADBoCCCD}DDDDD0123456789abcdef                        Content-Disposition: form-data; name="                          
--%s
Content-Disposition: attachment; filename="%s"          
Content-Type: multipart/mixed, boundary=%s
                  Content-Type: multipart/form-data Send failure: %s Failed writing header Data [%s %s %s] Header from                            Failed writing body (%d != %d) *  <  >  {  }  {  }  libcurl/7.19.4  zlib/%s tftp telnet dict ldap https ftps i686-pc-linux-gnu  lmqx}    %%%02X                  0123456789abcdefghijklmnopqrstuvwxyz                            0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ    X`````X`````````````X`X```X`X```X`X`X`X`X`X`X`X`X`X`````````````````````````````````````X`````X`````````````````````````````````````````````````X```````X`````````X`````````````````X````a` a aa aaObbbUbbbbbbb[bbbbbbc,c,c,c,c,c,c,c,c,cbbbbbbbbbbbbbbbbbbPcbb\cbbbbbbbbbbbbbbbbbbbbbbbbecbbbncbbbb\cbbbbbbbbwc[dletdlelelelelelelelelelelecleleleledlelelelelelelelelelededddleelelelelee'e@elelecleRelele~e(nil) (nil) %                               g lmgngg&o.%ld + CONNECT_ONLY is required! Failed to get recent socket                                                                                                                                                                                                                                                                                                Bind to local port %d failed, trying next
                      getsockname() failed with errno %d: %s                          Name '%s' family %i resolved to '%s' family %i
                 Local Interface %s is ip %s using address family %i
            SO_BINDTODEVICE %s failed with errno %d: %s; will do regular bind
                              Could not set TCP_NODELAY: %s
 bind failed with errno %d: %s Local port: %d
 Couldn't bind to '%s' Connection failed
 Failed connect to %s:%d; %s Connection time-out TCP_NODELAY set
 Timeout
 connected
 Failed to connect to %s: %s   Trying %s...  couldn't connect to host connect() timed out!    pp7II[pwwޗD(%E̟M    Pipe broke: handle 0x%x, url = %s
                              Internal error clearing splay node = %d
                        Internal error removing splay node = %d
                        Delayed kill of easy handle %p
 %p is at send pipe head!
 %p is at send pipe head B!
 Expire cleared
 No error Unsupported protocol Failed initialization Couldn't resolve proxy name Couldn't resolve host name Couldn't connect to server FTP: weird server reply FTP: unknown PASS reply FTP: unknown PASV reply FTP: couldn't set file type Transferred a partial file Quote command returned error HTTP response code said error Out of memory Timeout was reached FTP: command PORT failed FTP: command REST failed SSL connect error Couldn't resume download Couldn't read a file:// file LDAP: cannot bind LDAP: search failed Malformed telnet option SSL crypto engine not found Invalid LDAP URL Maximum file size exceeded Requested SSL level failed Login denied TFTP: File Not Found TFTP: Access Violation TFTP: Illegal operation TFTP: Unknown transfer ID Remote file already exists TFTP: No such user Conversion failed Remote file not found Error in the SSH layer Unknown error Invalid multi handle Invalid easy handle Internal error Invalid socket argument Unknown option Unknown share option Share currently in use Invalid share handle CURLSHcode unknown Unknown error %d                    URL using bad/illegal format or missing URL                     Access denied to remote resource                                FTP: unknown 227 response format                                FTP: can't figure out the host in the PASV response             FTP: couldn't retrieve (RETR failed) the specified file         Failed writing received data to disk/application                Upload failed (at start/before it took off)                     Failed to open/read local data from file/application            Requested range was not delivered by the server                 Internal problem setting up the POST                            A required function in the library was not found                Operation was aborted by an application callback                A libcurl function was given a bad argument                     Failed binding local connection end                             Number of redirects hit maximum amount                          User specified an unknown telnet option                         SSL peer certificate or SSH md5 fingerprint was not OK          Server returned nothing (no headers, no data)                   Can not set SSL crypto engine as default                        Failed sending data to the peer Failure when receiving data from the peer                       Problem with the local SSL certificate                          Couldn't use specified SSL cipher                               Peer certificate cannot be authenticated with known CA certificates                             Unrecognized HTTP Content-Encoding                              Send failed since rewinding of the data stream failed           Failed to initialise SSL crypto engine                          Disk full or allocation exceeded                                Caller must register CURLOPT_CONV_ callback options             Problem with the SSL CA cert (path? access rights?)             Failed to shut down the SSL connection                          Socket not ready for send/recv  Failed to load CRL file (path? access rights?, format?)         Issuer check against peer certificate failed                    Please call curl_multi_perform() soon   گhhh!(/h6=DhKRYh`jt~hhİΰذhh h
h(2<FPZhdnxȱұܱ",6@JT^hڲ Mon Tue Wed Thu Fri Sat Sun Monday Tuesday Wednesday Thursday Friday Saturday Sunday Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec %02d:%02d:%02d                     8<@DHLPT[cmv}                        GMT         UTC         WET         BST     WAT     <   AST        ADT        EST     ,  EDT        CST     h  CDT     ,  MST       MDT     h  PST       PDT       YST       YDT       HST     X  HDT       CAT     X  AHST    X  NT        IDLW      CET     MET     MEWT    MEST    CEST    MESZ    FWT     FST     EET     WAST    \WADT     CCT      JST     EAST    EADT    lGST     NZT     0NZST    0NZDT    IDLE    0                                   ;   Z   x                 0  N                                                  %31[ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz]               name lookup timed out Previous alarm fired off! %7lldd %3lldd %02lldh %2lld:%02lld:%02lld %4lldM %2lld.%0lldG %4lldG %4lldT %4lldP %5lld %4lldk %2lld.%0lldM Callback aborted   ,1^,	      %% Total    %% Received %% Xferd  Average Speed   Time    Time     Time  Current
                                 Dload  Upload   Total   Spent    Left  Speed
                               
%3lld %s  %3lld %s  %3lld %s  %s  %s %s %s %s %s               ** Resuming transfer from byte position %lld
        @@#HttpOnly_ Replaced Added TRUE FALSE %1023[^;=]=%4999[^;
] domain max-age expires httponly Set-Cookie: none %s%s%s	%s	%s	%s	%lld	%s	%s #
# Fatal libcurl error
        %s cookie %s="%s" for domain %s, path %s, expire %d
            skipped cookie with bad tailmatch domain: %s
                   skipped cookie with illegal dotcount domain: %s
                # Netscape HTTP Cookie File
# http://curl.haxx.se/rfc/cookie_spec.html
# This file was generated by libcurl! Edit at your own risk.

   ~T{7THTTP HTTPS Proxy- %sAuthorization: Basic %s
 Proxy Server Proxy-authorization: Basic Authorization: Digest CONNECT 1.1 Host: Host: %s
 Proxy-Connection: User-Agent: chunk reading DONE
 WWW-Authenticate: Proxy-authenticate: Content-Length: close chunked Transfer-Encoding: CONNECT responded chunked
 HTTP/1.%d %d %d bytes of chunk left
 Proxy CONNECT aborted Empty reply from server Expect: Expect: 100-continue
 Content-Type: Accept-Encoding: Accept: Accept: */*
 Content-Range: ;  %s%s=%s If-Modified-Since: %s
 Failed sending HTTP request %x
 
0

 Content-Length: %lld
 Failed sending PUT request Content-Length: 0

 Failed sending POST request Internal HTTP POST error! Last-Modified: %s
 If-Unmodified-Since: %s
 Cookie:  Range: bytes=%s
 Could not seek stream failed creating formpost data ftp:// ;type=%c ftps:// [ Host: %s%s%s:%d
 Host: %s%s%s
 Transfer-Encoding: chunked
 Accept-Encoding: %s
 Referer: Referer: %s
 GET          D        h
            P        P              I        h
h    P           @         ****        NTLM send, close instead of sending %lld bytes
                 The requested URL returned error: %d                            %s auth using %s with user '%s'
                                Authentication problem. Ignoring this.
                         Ignoring duplicate digest auth header.
                         Establish HTTP proxy tunnel to %s:%d
                           Proxy-Connection: Keep-Alive
  CONNECT %s:%d HTTP/%s
%s%s%s%s Received HTTP code %d from proxy after CONNECT                  Proxy replied OK to CONNECT request
                            Read %d bytes of chunk, continue
                               Ignore %lld bytes of response-body
                             Proxy CONNECT aborted due to select/poll error                  Proxy CONNECT aborted due to timeout                            Failed sending CONNECT to proxy Content-Range: bytes %s%lld/%lld
                              %s %s%s HTTP/%s
%s%s%s%s%s%s%s%s%s%s                           %s, %02d %s %4d %02d:%02d:%02d GMT                              Failed sending HTTP POST request                                Content-Type: application/x-www-form-urlencoded
               Could not get Content-Type header line!                         Content-Range: bytes %s/%lld
  Content-Range: bytes 0-%lld/%lld
                              File already completely uploaded                                Could only read %lld bytes from the input                       Chunky upload is not supported by HTTP 1.0                       @`		 @	`	                            8                                                    SSSSSSTS                                                                                                                                                                                                                                                                <no protocol> deflate, gzip ALL SESS FLUSH Closing connection #%ld
 proxy  %15[^:]:%[^
] %15[^
:]://%[^
/]%[^
] %25 Invalid IPv6 address format
 FTP. DICT. LDAP. <url> malformed %llu- no_proxy all_proxy ALL_PROXY http_proxy NO_PROXY %255[^:@]:%255[^@] %s://%s%s%s:%d%s%s Port number too large: %lu anonymous ftp@example.com Couldn't resolve host '%s' Couldn't resolve proxy '%s' %s://%s memory shortage User-Agent: %s
     WARNING: failed to save cookies in %s
                          /usr/share/ssl/certs/ca-bundle.crt                              Connection #%ld isn't open enough, can't reuse
                 Connection #%d seems to be dead!
                               Connection (#%d) was killed to make room (holds %d)
            This connection did not fit in the connection cache
            About to connect() to %s%s port %d (#%d)
                       unknown proxytype option given  Connected to %s (%s) port %d (#%d)
                             Protocol %s not supported or disabled in libcurl                [%*45[0123456789abcdefABCDEF:.]%c                               Couldn't find host %s in the .netrc file; using defaults
       Re-using existing connection! (#%ld) with host %s
              Connection #%ld to host %s left intact
                         Re-used connection seems dead, get a new one
 DICT /MATCH: lookup word is missing default Failed sending DICT request /M: /FIND: /DEFINE: /D: /LOOKUP:          n    w                                    D
             CLIENT libcurl 7.19.4
MATCH %s %s %s
QUIT
                   CLIENT libcurl 7.19.4
DEFINE %s %s
QUIT
                     CLIENT libcurl 7.19.4
%s
QUIT
                               Operation too slow. Less than %d bytes/sec transfered the last %d seconds OpenLDAP LDAP local: %s
 LDAP local: %s LDAPS encrypted cleartext LDAP remote: %s DN:  	 ;binary                      .    |                                                 LDAP local: LDAP Vendor = %s ; LDAP Version = %d
               There are more than %d entries
 LDAP local: trying to establish %s connection
                  LDAP local: ldap_simple_bind_s %s                               LDAP local: Cannot connect to %s:%d /dev/urandom PEM ENG P12 unable to set private key SSL Engine '%s' not found SSL read: %s, errno %d SSL_ERROR_WANT_WRITE
 SSL_ERROR_WANT_READ
 SSL shutdown timeout GMT 	 subjectAltName: %s matched
 	 common name: %s (matched)
 ssluse.c Error Client hello Client key Client finished Server hello Server verify Server finished Request CERT Client CERT Unknown Hello request Server key exchange CERT verify Client key exchange Finished TLS change cipher,  TLS alert,  TLS handshake,  TLS app data,  TLS Unknown,  SSLv%c, %s%s (%d):
   CAfile: %s
  CApath: %s
 successfully load CRL file:
   CRLfile: %s
 SSL re-using session ID
 SSL: SSL_set_fd failed: %s failed setting cipher list SSL: couldn't set callback!
 SSL connection using %s
 %s: %s(%s)    %s: %s
 %02x: (critical)  Signature: %s
 Signature Cert --- Certificate chain
 %2d Subject: %s
 Subject    Issuer: %s
 Issuer    Version: %lu (0x%lx)
 %lx Version    Start date: %s
 Start date    Expire date: %s
 Expire date    RSA Public Key (%d bits)
 RSA Public Key iqmp rsa dmq1 dmp1 pub_key dsa priv_key    Unable to load public key
    Public Key Algorithm: %s
 Public Key Algorithm    Signature Algorithm: %s
 Signature Algorithm Serial Number    Serial Number: %s
 %02x%c Server certificate:
 	 subject: %s
 	 start date: %s
 	 expire date: %s
 	 issuer: %s
 	 SSL certificate verify ok.
 failed to store ssl session SSL connection timeout SSL_write() return error %d SSL_write() error: %s OpenSSL/%lx.%lx.%lx%s libcurl is now using a weak random seed!
                       not supported file type '%s' for certificate                    unable to use client certificate (no key found or wrong pass phrase?)                           not supported file type for private key                         unable to set private key file: '%s' type %s                    Private key does not match the certificate public key           unable to create an SSL structure                               file type P12 for private key not supported                     no key set to load from crypto engine                           failed to load private key from crypto engine                   crypto engine not set, can't load private key                   could not parse PKCS12 file, check password, OpenSSL error %s   unable to use private key from PKCS12 file '%s'                 cannot add certificate to client CA list                        cannot add certificate to certificate chain                     private key from PKCS12 file '%s' does not match certificate in same file                       error reading PKCS12 file '%s'  could not open PKCS12 file '%s' file type ENG for certificate not implemented                   Failed to initialise SSL Engine '%s':
%s                        set default crypto engine '%s'
 set default crypto engine '%s' failed                           SSL_get_shutdown() returned SSL_SENT_SHUTDOWN
                  SSL_get_shutdown() returned SSL_SENT_SHUTDOWN|SSL_RECEIVED__SHUTDOWN
                           SSL_get_shutdown() returned SSL_RECEIVED_SHUTDOWN
              select/poll on SSL socket, errno: %d                            %04d-%02d-%02d %02d:%02d:%02d %s                                SSL: unable to obtain common name from peer certificate         SSL: certificate subject name '%s' does not match target host name '%s'                         	 common name: %s (does not match '%s')
                        error setting certificate verify locations:
  CAfile: %s
  CApath: %s
                          error setting certificate verify locations, continuing anyway:
 error loading CRL file :
  CRLfile: %s
                         SSL: couldn't create a context (handle)!                        SSL: SSL_set_session failed: %s error signaled by ssl ctx callback                              successfully set certificate verify locations:
                 SSL: couldn't set callback argument!
                           SSL: couldn't create a context! Unknown SSL protocol error in connection to %s:%d               SSL certificate problem, verify that the CA cert is OK. Details:
                                  Serial Number: %ld (0x%lx)
  SSL: couldn't get peer certificate!                             SSL: couldn't get X509-subject! SSL: couldn't get X509-issuer name!                             SSL: Certificate issuer check failed (%s)
                      	 SSL certificate issuer check ok (%s)
                         SSL certificate verify result: %s (%ld)                         	 SSL certificate verify result: %s (%ld), continuing anyway.
  SSL: Unable to read issuer cert (%s)
                           SSL: Unable to open issuer cert (%s)
                           SSL_write() returned SYSCALL, errno = %d    Ybipw~bwÔʔєؔBINARY ECHO RCP SUPPRESS GO AHEAD STATUS TIMING MARK RCTE NAOL NAOP NAOCRD NAOHTS NAOHTD NAOFFD NAOVTS NAOVTD NAOLFD EXTEND ASCII LOGOUT BYTE MACRO DE TERMINAL SUPDUP SUPDUP OUTPUT SEND LOCATION TERM TYPE END OF RECORD TACACS UID OUTPUT MARKING TTYLOC 3270 REGIME X3 PAD NAWS TERM SPEED LFLOW LINEMODE XDISPLOC OLD-ENVIRON AUTHENTICATION ENCRYPT NEW-ENVIRON EOF SUSP ABORT EOR NOP DMARK BRK AO AYT EC GA SB WILL WONT DO DONT IAC TELNET %s %s %s
 %s %s %d
 EXOPL %s %d %d
 %s IAC %s
 %s IAC %d
 SENT Sending data failed (%d) %s IAC SB  (terminated by  , not IAC SE!)  %s (unsupported)  %.2x  "%s"  =   NAME  INFO/REPLY  IS  SEND %d (unknown) (Empty suboption?) %d  %127[^= ]%*[ =]%255s NEW_ENV Unknown telnet option %s USER,%s %c%c%c%c%s%c%c %c%c%c%c %127[^,],%127s %c%s%c%s In SUBOPTION processing, RCVD Time-out                =
#(/6=DKRYfmx	'6>JNSY]agknrux{                                                       @   T+a
        Syntax error in telnet option: %s  	
 login password machine .netrc           operation aborted by callback HTTP/ Ignoring the response-body
 Failed writing data Trailer: Trailers: Content-Encoding: identity deflate x-gzip x-compress Last-Modified: Location: keep-alive  HTTP/%d.%d %3d  HTTP %3d select/poll returned error No URL set! %15[^?&/:]://%c Disables POST, goes with %s
 unspecified error %d              read function returned funny value                              necessary data rewind wasn't possible                           the ioctl callback returned %d
 ioctl callback returned error %d                                seek callback returned error %d Unrecognized content encoding type. libcurl understands `identity', `deflate' and `gzip' content encodings.                     we are done reading and this is set to close, stop send
        Rewinding stream by : %d bytes on url %s (size = %lld, maxdownload = %lld, bytecount = %lld, nread = %d)
                       Leftovers after chunking.  Rewinding %d bytes
                  Received problem %d in the chunky parser                        The requested document is not new enough
                       The requested document is not old enough
                       HTTP server doesn't seem to support byte ranges. Cannot resume. HTTP/1.0 connection set to keep alive!
                         HTTP/1.1 proxy connection set close!
                           HTTP/1.0 proxy connection set to keep alive!
                   Negative content-length: %lld, closing after transfer
          HTTP 1.0, assume close after body
                              Keep sending data to get tossed away!
                          no chunk, no close, no size. Assume close to signal end
        Failed to alloc memory for big header!                          Failed to alloc scratch buffer! transfer closed with outstanding read data remaining            transfer closed with %lld bytes remaining to read               Operation timed out after %ld milliseconds with %lld out of %lld bytes received                 Operation timed out after %ld milliseconds with %lld bytes received                             Done waiting for 100-continue
  Issue another request to this URL: '%s'
                        Violate RFC 2616/10.3.2 and switch from POST to GET
            Violate RFC 2616/10.3.3 and switch from POST to GET
            Maximum (%d) redirects followed Connection died, retrying a fresh connect
  Ohh                                                                                                            |"3F    Error while processing content unencoding: %s                   Error while processing content unencoding: Unknown failure within decompression software. 1.2.0.4   \B 
nonce stale true realm opaque qop auth-int algorithm MD5-sess MD5 %02x %06ld %s:%.*s %s:%s:%08x:%s:%s:%s %s, algorithm="%s" %s, opaque="%s"                         %sAuthorization: Digest username="%s", realm="%s", nonce="%s", uri="%s", cnonce="%s", nc=%08x, qop="%s", response="%s"          %sAuthorization: Digest username="%s", realm="%s", nonce="%s", uri="%s", response="%s"    KGS!@#$%                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 NTLMSSP %sAuthorization: NTLM %s
                          NTLMSSP%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%s%s    NTLMSSP%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c        user + domain + host name too big                               gethostname() failed, continuing without!                       gethostbyname_r(2) failed for %s
 TFTP got option=(%s) value=(%s)
 blksize requested blksize parsed from OACK %s (%d) %s (%d)
 %s (%d) tsize tsize parsed from OACK Connected for transmit Connected for receive octet netascii %s%c%s%c interval tftp_rx: internal error tftp_tx: internal error Internal state machine error TFTP finished bind() failed; %s Received too short packet ;mode= 	p>99    d8                    $8E      02222220====$==>            set timeouts for state %d; Total %d, retry %d maxtry %d
        server requested blksize larger than allocated                  blksize is smaller than min supported                           blksize is larger than max supported                            invalid blocksize value in OACK packet                          invalid tsize value in OACK packet                              Malformed ACK packet, rejecting tftp_send_first: internal error Received unexpected DATA packet block %d
                       tftp_rx: giving up waiting for block %d                         Timeout waiting for block %d ACK.  Retries = %d
                Received ACK for block %d, expecting %d
                        tftp_tx: giving up waiting for block %d ack                     Internal error: Unexpected packet                               Failed to send SOCKS4 connect request.                          Failed to receive SOCKS4 connect request ack.                   Can't complete SOCKS4 connection to %d.%d.%d.%d:%d. (%d), Unknown.                              Can't complete SOCKS4 connection to %d.%d.%d.%d:%d. (%d), request rejected because the client program and identd report different user-ids.                     Can't complete SOCKS4 connection to %d.%d.%d.%d:%d. (%d), request rejected because SOCKS server cannot connect to identd on the client.                         Can't complete SOCKS4 connection to %d.%d.%d.%d:%d. (%d), request rejected or failed.           SOCKS4 reply has wrong version, version should be 4.            Failed to resolve "%s" for SOCKS4 connect.                      SOCKS5: error occured during connection                         Unable to send initial SOCKS5 request.                          Unable to receive initial SOCKS5 response.                      Received invalid version in initial SOCKS5 response.            Undocumented SOCKS5 mode attempted to be used by server.        No authentication method was acceptable. (It is quite likely that the SOCKS5 server wanted a username/password, since none was supplied to the server on this connection.)                      No authentication method was acceptable.                        SOCKS5 GSSAPI per-message authentication is not supported.      Failed to send SOCKS5 sub-negotiation request.                  Unable to receive SOCKS5 sub-negotiation response.              Failed to send SOCKS5 connect request.                          Failed to receive SOCKS5 connect request ack.                   SOCKS5 reply has wrong version, version should be 5.            Can't complete SOCKS5 connection to %d.%d.%d.%d:%d. (%d)        Failed to resolve "%s" for SOCKS5 connect.                      User was rejected by the SOCKS5 server (%d %d).                 SOCKS5: server resolving disabled for hostnames of length > 255 [actual len=%d]
 SOCKS4a request granted.
 SOCKS4 request granted.
 %hu.%hu.%hu.%hu SOCKS5 read error occured SOCKS5 read timeout SOCKS5 nothing to read SOCKS5: connection timeout SOCKS5: no connection here Couldn't open file %s Can't get the size of %s Can't open %s for writing Can't get the size of file. Accept-ranges: bytes
                          U0R     Q                                       failed to resume file:// transfer                               Last-Modified: %s, %02d %s %4d %02d:%02d:%02d GMT
             ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/ %c%c%c= %c%c== FTPS FTP response reading failed FTP response timeout USER %s CWD %s getsockname() failed: %s PORT %d,%d,%d,%d,%d,%d listen(2) failed on socket bind(2) failed on socket socket(2) failed (%s) REST %d SIZE %s NLST MDTM %s APPE %s STOR %s Failed to read data disabling EPSV usage
 PASV Bad PASV/EPSV response: %03d Can't resolve new host %s:%d %d.%d.%d.%d %c%c%c%u%c Weirdly formatted EPSV reply Failed to do PORT disabling EPRT usage
 Connect data stream actively
 Skipping time comparison
 Given file does not exist %04d%02d%02d%02d%02d%02d Couldn't set desired mode REST %lld RETR %s Couldn't use REST Failed FTP upload: %0d RETR response: %03d Maxdownload = %lld
 Getting file with size: %lld
  bytes PBSZ %d Access denied: %03d ACCT %s PASS %s ACCT rejected by server: %03d AUTH %s PROT %c Failed to figure out path
 Entry path is '%s'
 QUOT command failed with %03d MKD %s Failed to MKD dir: %03d select/poll error No data was received! control connection looks dead QUOT string not accepted: %s TYPE %c QUIT no memory                   	pHD<Ğee    d              P	pHD<Ğee    d   @         	                                                  P	                                                                                                                                                                                                                                                                                                         EPSV PASV   uu9v9vTvuxvuAccept-ranges: bytes
  SSL TLS %$2m؈؈؈؈	+++==O`qq%̎̎̎̎̎̎̎̎̎̎̎Connection accepted from server
                                Error accept()ing server connect                                Timeout while waiting for server connect                        Error while waiting for server connect                          Timed out before server could connect to us                     Excessive FTP response line length received, %zd bytes. Stripping
                              FTP response aborted due to select/poll error: %d               Telling server to connect to %d.%d.%d.%d:%d
                    Failed to resolve host name %s
 Connect data stream passively
  File already completely uploaded
                               Couldn't interpret the 227-response                             Skips %d.%d.%d.%d for data connection, uses %s instead
         got positive EPSV response, but can't connect. Disabling EPSV
  Can't resolve proxy host %s:%d  unsupported MDTM reply format
  %04d%02d%02d %02d:%02d:%02d GMT Got a %03d response code instead of the assumed 200
            Offset (%lld) was beyond file size (%lld)                       File already completely downloaded
                             Instructs server to resume from offset %lld
                    ftp server doesn't support SIZE
                                Doing the SSL/TLS handshake on the data stream
                 ACCT requested but none available                               Got a %03d ftp-server response when 220 was expected            unsupported parameter to CURLOPT_FTPSSLAUTH: %d                 Failed to clear the command channel (CCC)                       Server denied you to change to the given directory              Remembering we are in dir "%s"
 Uploaded unaligned file size (%lld out of %lld bytes)           Received only partial file: %lld bytes                          server did not report OK, got %d                                Connecting to %s (%s) port %d
  Request has same path as previous transfer
                     Uploading to a URL without a file name! ;8      4}T   ~       <(  LT  p         zR |  X      |          
   N   .   .   .   .   .   .    .  (   x   X}         
     H      <          
   .   .   .   .   .   .  (               
     H     #          
   .   .   .   .   .
   .  (   h  Ȁ         
                         6	                       \                                   ``0                              a     
     
     0
     =
     N
     ^
     i
     
     
     
   P   H   d   d
   #                  6	                              oo   o                                                            5	        ưְ&6FVfvƱֱ&6FVfvƲֲ&6FVfvƳֳ&6FVfvƴִ&6FVfvƵֵ&6FVfvƶֶ&6FVfvƷַ&6FVfvƸָ&6FVfvƹֹ&6FVfvƺֺ&6FVfvƻֻ&6FVfvƼּ&6FVfvƽֽ&6FVfvƾ־&6FVfvƿֿ     GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  GCC: (GNU) 3.2.2 20030222 (Red Hat Linux 3.2.2-5)  .symtab .strtab .shstrtab .interp .note.ABI-tag .hash .dynsym .dynstr .gnu.version .gnu.version_r .rel.dyn .rel.plt .init .text .fini .rodata .eh_frame_hdr .eh_frame .data .dynamic .ctors .dtors .jcr .got .bss .comment                                                                       #         ((                     1         HH                 7         dd                 ?         dd  #                 G   o   &                  T   o   (  `                c   	      (                   l   	      )                u         0                    p         0  0                {         ?  p                         PP(                            ( z                          H#	H <                           #	                            5	                              5	                          6	̦                            6	Ԧ                            6	ܦ                            6	                          :	                                                                                                   =             	               ;                                             6	         6	      -   #	      @   6	      M   (5	      Q   :	     ]   (      s   d         6	         6	         %	         6	         ,                 t        	        6        I               5       LB       r       X     '  \     5   &     C  HJ     P      Z  TT     e       q       }  \-       J       S       ,       ,+       Xr       X       $       @l      h       *      :	       F    
          (     &       /       9  '     A  (     J      U  xy     e      j  T     w  ,5	     ~  -5	       j            I             :	       D       4               N'      X)G      P'v       (u        R    %  \+    .  /+    8  P-c    C       P  :	<     [   ;	<     d  9b     l  :)     s  l>        ?U        H       x?       ,@       @      F      G8       pP       JB       \;	              R!       dS*      PVl     *  pWa     5  ?     B  P[m     I  `;	     S  (     ]  @5	8     j  @<	P     l  P],     w  ],       %        %       _U       @`$       d`?                    e      ,r+       r       pt     !  u     /  v     :  <	     F  <	     Q  |d     a   9     m  <$    w  `c       ăt       D      ܅e       C       hb       #       m        0       P       l              !       D{     (  ?     9      F       R  8     f  ԕ%     u         t	             `               8       p       5	     
                 `    #  X     ,  TL     7  Y     ?  9     D  0     \  8    f  T    p  (     x  <:       5	       P       5	       5	       <	       <	       $'               '       @%     *  o     @       J  l    S  ,>    \       g  TY     q  p       P       h(       P       R              i       6          	  $     	         !	       1	  w     =	  l     H	       [	  $9     h	  `g     S  (     r	  8     	  *     	  Q     	  D+M     	  +     	  ,     	  $I]    	  MJ     	  K&     	  LH     
  L     
  N    0
  tR     ?
  R     O
  S    ]
  $T<     l
   V     y
  Vp     
  V    
  Z     
  Z     
  Z     
  [d    
  ]    
  ^Y    
  `       b=      @c    0  He     B   f}     O  f{    ^  h    i  j    u  p      t       u3       w      hw       |P       q       t       '      5	                           3     &  Љ     3  Y    ?  h     I  U     X  @    c  @     p  5     |              S      8.       h       @.       p             ,     
  n     
   J     
  l    -
  `    8
  d     K
      _
        m
  P     x
      
  ?     
  Ըn     
  D[     
       
  p     
      
  l     
  ܻ     
       
  0     
         +          $      .      5       F  xx     V  4     c       o  ,[    ~        d      H      d=       U       )       (I      w       \'       	6       (
       D
t    '  X    9  T     B  :     O  &     Z  W     i  L      w   k       [       L!       "(       4"       p>       9y      9       d8z      $8?       +      ,       ,     &  ,     6  ,     F  -+     S  0-n     c  -    y  X/V       /M        5~       0M       3      P0      7       U      0R8        Q
       P       hRC       	A     "  LZc     0       E  Q     L  pS    U  H     e  D*    q  <       Ğ4       e9       d       ]       ^D       `^      t_#       _      `e       teP       e3       4f        ng     3  fh    F  X	
     M  <k     `  kZ     t  qH      l`       xl^       l      `n       tn       nr       <%       d     "  doe    5  sB    I  :     Z  Xx     n  xX      H{       |      ~                    ^      Q       l*    %  ;     9  	     C  Ԅ    U       g       z         Ēu       8      z                    E               X                              (          H          d          d                                             	          
                         P     
               H#	          #	           5	          5	          6	          6	          6	          6	          :	                      x      {      8      .  "]    ?  аx     N  t     [  }s     j  0Z    |  `	8       3      \       B       D             Z%      :        |]       |      02       0;    4        G        _        }         <D                      (w       0O        F       D,g       0S      #  '    0  @8     C  DR     Y  ;r     a  @g     s  	8       P        HQ       K       ++       `D        p        N        0       t     
  |        *     -  0      7      I  F     V        c        o  б      }  =        5	       W                ^       q               
  0        q     3  @.      ?  U     J  Pd      `  vA     m         `       ]       \"       pX       8       8        TJ                      8      -  z      7  вZ      @  	8     W  hYI     g  x      {  2        -        Q        D      8!               8        q                      0=      +  @      4  ?     G  P     Y  @	8     k  8    }  `        ܬ      p                `T(       	               v       Q%       5	            %  XI     3  *     A      T  i     `  L     t  ȡu      ,               г|             \
       	8       XrQ     
  0n          -      @  $5	     M  x     e  	     y                 4       >                5      	       9       _     /   $     C      X  00      d  t@    w   	        k	      @               P=        M       ,U       `        	     '  	     9  p7      W  9      s  #              Xs              I      hl       #      6                @5            %         8   *     O   дx      a   h    k   Du     y            :         ̌                 L                 I         0      !  @y     !       
 !        ,!  t^     >!  Q     O!  s     n!  v    !  P9      !  u%    !  T     !  <    !  `     !  Jl    !  pM      !  us     "  h
     "        "  	     3"        <"   8     P"  6      `"  <      m"  a      "  $     "  $[    "  е
      "       "  X      "   x      "  s     "  }     "   "     #  x     "#  T     9#       O#  s     b#  w"     s#  6     #  L     #  5	     #         #       #  ̳     #  0M     #  @9      #  P.      $  C    $  `     #$  :	     5$  H    K$  :	     ]$   8     o$  pc      {$        $  {<    $  (w@     $  %      $  wO     $       $  (6     $  L4     %  T/     !%        1%  ?     C%  5      Z%  x5	     g%        {%  N\    %  9      %  ж      %  0<     %   q     %  "     %  |e     %  k     &  )     &  <       &  :     9&       G&        ]&         o&  E      &       &        &  0     &  e     &  x0     &  W    '  @"      '  P@      &'  (u     5'  t     H'       ^'        e'  K     x'  Tc    '  `      '  p      '  S     '  <	     '  =      '  Lr     '  T    '        '        (  X    (  +     0(  ={     ?(  ts     Q(  зF     b(  [     m(        (  x      (  G      (  ?    (   4      (        (  T9     (   ]-     )   5      ')  0      >)  (LW     P)  T8     e)  @?     ~)  (     )  u     )  P
      )  `
      )  p     )  P      )  D     )   }h     *  8     *        /*  į    B*        \*  H      m*        ~*  и     *  l6Y    *        *  p     *        *         *        *  ?     +         +  0      -+  @D      8+  	     T+  P      d+  l     z+  5	     +  `5      +  p      +  ȧ0     +  1     +       +       +        ,  K     ,        (,  :	     4,      @,  t     X,  X     l,  T9     ,  'U     ,  Q     ,  w     ,       ,  4U     ,  hw>     ,        -  й@      -        5-  5     B-  `	8     S-  8     e-  S    u-  5	     -  ,	     -  4*     -       -   R     -  L)     -  2    -       .       .   D      '.  z     2.  0     D.  @-     Y.  \+     m.       .  Q     .  	     .  `     .       .  <     .  L:     .   5	       /  4    /  Ta     /  @k      ,/  *     5/  :     L/  z     \/  Vs     g/  P9      w/  U     /       /  v     /  P     
 /  `s      /       /  p'      /  8	     /        0       !0  ;)     -0        ?0  r     S0        d0       v0        0       0  к9      0       0  pO     0  p@     0  W      0  Y    1  /     1  T     &1   G     C1  0    L1   N    ]1  
      p1   U      1  00      1  <4     1   SC     1  @
      1  P5      1  pq     1  `>      2  p:       2  {     /2  H    C2  ^      T2  ,     `2        w2      2        2  C     2  *     2        2  =      2  л      3  p     3  5	     *3  ;K     73   s    A3       W3  J      l3  t#     z3         3  -    3        3       3  U    3        3  HP&     3  0     3  ?     
4  	     $4  ]     54  @4      G4  :	     N4  PP     j4  ;0     |4  6	     4  `      4  \=	     4  p      4  x      4        4  )      4  ~<     5        5  q      #5  м:      45  0     F5  5	     S5  5      e5       5   C      5  (<     5        5   O      5  0>      5  @      5  P     5  `x      6  S     6  :	     )6       =6  p&      J6  0W=     [6  
      p6  y    6       6  |5	     6  k     6        6  [    6      6  C     6       	7   h	    7        B7  н     `7  t    l7       ~7  5	     7       7  x      7  ]     7        7         7        7  _     	8   7      8  `H     $8  Rh     68  `L/     O8  <     ]8  0x      m8  @      w8  P4      8  `q     8  p      8       8  &      8  du!     8   5	      8  u      8  з     9  @_     9  \     +9  9      =9              Q9  q      j9  =     y9         9  L    9  Ȳ?     9  t     9  x     9  о     9  D     9  &      :   i      :  T,     .:  k      <:  ,>>     M:        X:  0      m:  @|      }:  P6      :  `      :  ̨>     :  ̻    :  p     :  =     :  r     :        ;  C      ;  l+     #;  &      :;        G;  ,8     Y;       k;  tS     ;  t"     ;              ;  0     ;  ,:     ;  п0       call_gmon_start __CTOR_LIST__ __DTOR_LIST__ __EH_FRAME_BEGIN__ __JCR_LIST__ p.0 completed.1 __do_global_dtors_aux frame_dummy __CTOR_END__ __DTOR_END__ __FRAME_END__ __JCR_END__ __do_global_ctors_aux warnf main_init main_free SetHTTPrequest helpf helptext.0 help GetStr clean_getout new_getout AddMultiFiles FreeMultiInfo list_engines formparse param2text file2string file2memory cleanarg str2num str2offset checkpasswd add2list ftpfilemethod ftpcccmethod sockoptcallback aliases.1 feats.2 getparameter curlinfo parseconfig unslashquote my_get_line go_sleep my_fwrite my_seek my_fread myprogress progressbarinit dump s_infotype.3 newl.4 traced_data.5 my_trace free_config_fields output_expected _my_setopt easycode srchead dumpeasycode m.6 operate create_dir_hierarchy checkfds show_dir_errno hugehelpgz glob_set glob_word glob_range replacements withecho.0 noecho.1 ttyecho GetEnv AddHttpPost AddFormInfo ctts.0 ContentTypeForFilename memdup FormAdd AddFormData AddFormDataf readfromfile strippath randomizer.1 table16.2 slist_get_last convert_lineends send_plain pausewrite s_infotype.0 showit version.0 protocols version_info ssl_buffer.1 Curl_isalnum lower_digits upper_digits dprintf_DollarString dprintf_IsQualifierNoDollar dprintf_Pass1 null.0 strnil.1 dprintf_formatf addbyter alloc_addbyter storebuffer win32_cleanup win32_init initialized init_flags easy_connection waitconnect bindlocal verifyconnect trynextip singleipconnect tcpnodelay hash_element_dtor mk_hash_element multistate sh_addentry sh_delentry sh_freeentry fd_key_compare hash_fd sh_init update_timer multi_conn_using singlesocket add_closure waitconnect_getsock domore_getsock multi_getsock multi_runsingle checkPendPipeline addHandleToSendOrPendPipeline isHandleAtHead moveHandleFromSendToRecvPipeline multi_socket tv_zero.0 multi_timeout weekday tz checkday checkmonth checktz skip month_days_cumulative.0 my_timegm parsedate wait_ms safe_strequal init_ssl kill_session KEY_NOTUSED.0 KEY_NOTUSED.1 host_cache_initialized hostname_cache freednsentry create_hostcache_id hostcache_timestamp_remove hostcache_prune remove_entry_if_stale alarmfunc time2str max5data freecookie tailmatch get_netscape_format http_getsock_do https_connecting https_getsock checkheaders http_output_basic pickoneauth output_auth_headers http_output_auth readmoredata add_buffer_init add_buffer_send add_bufferf add_buffer add_custom_headers use_http_1_1 expect100 Curl_handler_dummy close_connections ConnectionKillOne setstropt setstropt_userpwd flush_cookies conn_free signalPipeClose SocketIsDead IsPipeliningPossible gethandleathead ConnectionExists ConnectionDone ConnectionStore ConnectPlease verboseconnect fix_hostname allocate_conn ParseURLAndFillConnection llist_dtor setup_range setup_connection_internals check_noproxy detect_proxy parse_proxy parse_proxy_auth parse_url_userpass parse_remote_port override_userpass set_userpass resolve_server reuse_conn create_conn setup_conn do_init do_complete dict_do unescape_word Curl_ldap passwd_callback rand_enough ossl_seed ssl_seeded.0 do_file_type cert_stuff x509_name_oneline cert_verify_callback SSL_strerror asn1_output hostmatch cert_hostcheck verifyhost ssl_msg_type tls_rt_type ssl_tls_trace ossl_connect_step1 ossl_connect_step2 asn1_object_dump push_certinfo_len push_certinfo pubkey_show X509V3_ext X509_signature dumpcert init_certinfo get_cert_chain servercert ossl_connect_step3 ossl_connect_common telnetoptions telnetcmds telnet_do telnet_done init_telnet negotiate set_remote_option set_local_option printoption send_negotiation rec_will rec_wont rec_do rec_dont printsub check_telnet_options suboption telrcv send_telnet_data checkhttpprefix data_pending read_rewind readwrite_data readwrite_http_headers readwrite_upload Transfer strlen_url strcpy_url is_absolute_url concat_url connect_host Curl_isxdigit process_zlib_error exit_zlib inflate_stream check_gzip_header get_pair md5_to_ascii readint_le type2_marker.0 setup_des_key lm_resp magic.1 mk_lm_hash ascii_to_unicode_le mk_nt_hash tftp_setup_connection tftp_do tftp_done tftp_connect tftp_disconnect tftp_set_timeouts setpacketevent setpacketblock getrpacketevent getrpacketblock Curl_strnlen tftp_option_get tftp_parse_option_ack tftp_option_add tftp_connect_for_tx tftp_tx tftp_connect_for_rx tftp_rx tftp_send_first tftp_state_machine file_do file_done file_connect file_range file_upload table64 decodeQuantum ftp_setup_connection ftp_do ftp_done ftp_nextconnect ftp_connect ftp_multi_statemach ftp_doing ftp_getsock ftp_disconnect freedirs isBadFtpString AllowServerConnect ftp_respinit ftp_readresp state ftp_state_user ftp_state_pwd ftp_state_cwd ftp_state_post_cwd ftp_state_use_port mode.0 ftp_state_use_pasv ftp_state_post_rest ftp_state_quote ftp_state_post_size ftp_state_post_type ftp_state_post_listtype ftp_state_post_retrtype ftp_state_post_stortype ftp_state_post_mdtm ftp_need_type ftp_nb_type ftp_state_ul_setup ftp_state_pasv_resp ftp_pasv_verbose ftp_state_port_resp ftp_state_mdtm_resp ftp_state_type_resp ftp_state_post_retr_size ftp_state_size_resp ftp_state_rest_resp ftp_state_stor_resp ftp_state_get_resp ftp_state_loggedin ftp_state_user_resp ftp_state_acct_resp ftpauth.1 ftp_statemach_act ftp_state_timeout ftp_easy_statemach ftp_init ftp_sendquote ftp_range ftp_perform ftp_parse_url_path ftp_regular_transfer ftp_quit ftp_dophase_done __udivmoddi4 Curl_parsenetrc Curl_speedcheck freeaddrinfo@@GLIBC_2.0 Curl_output_ntlm RAND_load_file curl_mprintf curl_easy_send Curl_input_digest Curl_handler_tftp Curl_setopt curl_version Curl_md5it Curl_SOCKS5 Curl_ssl_connect_nonblocking Curl_base64_decode mkdir@@GLIBC_2.0 curl_getenv __divdi3 Curl_open Curl_init_userdefined curl_share_cleanup SSL_CTX_use_certificate __strtoll_internal@@GLIBC_2.0 Curl_wkday Curl_hash_clean X509_load_crl_file Curl_httpchunk_init Curl_ossl_set_engine_default Curl_rm_connc ENGINE_load_private_key Curl_dupset sigaction@@GLIBC_2.0 Curl_getinfo Curl_handler_https Curl_ssl_initsessions homedir strchr@@GLIBC_2.0 Curl_handler_ftps SSL_set_fd Curl_formclean curlx_tvdiff Curl_freeset SSL_set_connect_state ldap_get_dn SSL_CTX_free Curl_month Curl_multi_canPipeline ENGINE_get_first Curl_ntlm_cleanup X509_free curl_share_setopt curl_formadd SSL_shutdown zlibVersion ENGINE_finish SSL_CTX_callback_ctrl _DYNAMIC strdup@@GLIBC_2.0 ERR_error_string_n curl_easy_unescape __ctype_tolower_loc@@GLIBC_2.3 __rawmemchr@@GLIBC_2.1 ENGINE_set_default Curl_cookie_loadfiles ENGINE_free Curl_sendf siglongjmp@@GLIBC_2.0 Curl_do_more Curl_multi_handlePipeBreak getaddrinfo@@GLIBC_2.0 curl_escape Curl_ssl_cleanup SSL_get_error Curl_handler_ldap DES_set_odd_parity Curl_getFormData inflate poll@@GLIBC_2.0 localtime@@GLIBC_2.0 BN_bn2bin RAND_add Curl_handler_ftp_proxy Curl_read_plain recvfrom@@GLIBC_2.0 fileno@@GLIBC_2.0 Curl_llist_alloc ERR_remove_state Curl_http_perhapsrewind Curl_ssl_init sk_num Curl_handler_dict close@@GLIBC_2.0 Curl_readrewind _fp_hw inet_pton@@GLIBC_2.0 SSL_peek Curl_blockread_all getenv@@GLIBC_2.0 Curl_handler_file Curl_is_connected ber_free Curl_expire SSL_get_shutdown fflush@@GLIBC_2.0 Curl_protocol_getsock Curl_ssl_close SSL_read curl_global_init_mem Curl_formpostheader __fini_array_end SSL_new curl_formfree Curl_safefree Curl_cookie_output SSL_CTX_new Curl_ossl_close_all curl_multi_cleanup Curl_ossl_connect UI_OpenSSL SSL_library_init Curl_httpchunk_read Curl_unencode_gzip_write Curl_handler_ftps_proxy curl_mvsnprintf Curl_readwrite Curl_resolv_timeout Curl_http_auth_act __dso_handle Curl_ssl_config_matches Curl_ssl_set_engine SSL_CTX_set_default_passwd_cb ldap_get_values_len __libc_csu_fini curl_multi_socket_action tcsetattr@@GLIBC_2.0 Curl_perform Curl_ssl_engines_list Curl_hash_str setlocale@@GLIBC_2.0 getpwuid@@GLIBC_2.0 Curl_http_input_auth PKCS12_free Curl_ossl_shutdown Curl_ssl_send Curl_pgrsUpdate ldap_first_entry Curl_unencode_deflate_write X509_get_pubkey Curl_getoff_all_pipelines Curl_protocol_connect TLSv1_client_method Curl_ssl_version Curl_multi_rmeasy SSL_CTX_load_verify_locations __errno_location@@GLIBC_2.0 Curl_hash_destroy Curl_ossl_init curl_maprintf memchr@@GLIBC_2.0 Curl_pgrsTime Curl_hostcache_prune __umoddi3 ldap_unbind_s SSL_pending Curl_fillreadbuffer Curl_clone_ssl_config SSL_CTX_set_verify Curl_printable_address accept@@GLIBC_2.0 __udivdi3 curl_strequal ldap_simple_bind_s access@@GLIBC_2.0 Curl_hash_add PKCS12_parse Curl_mk_dnscache X509_verify_cert_error_string BN_num_bits SSL_get_privatekey puts@@GLIBC_2.0 _init Curl_ossl_send Curl_ossl_version Curl_ssl_connect Curl_hash_clean_with_criterium Curl_cookie_init listen@@GLIBC_2.0 Curl_do Curl_failf Curl_setup_transfer malloc@@GLIBC_2.0 Curl_disconnect ENGINE_load_builtin_engines Curl_strlcat Curl_http_connect MD4_Update Curl_ssl_check_cxn BIO_free Curl_handler_telnet pipe@@GLIBC_2.0 inflateInit_ X509_NAME_print_ex Curl_compareheader Curl_cookie_add SSLeay fread@@GLIBC_2.0 memmove@@GLIBC_2.0 sendto@@GLIBC_2.0 curl_mvaprintf Curl_timeleft curl_multi_timeout curl_easy_getinfo Curl_ssl_free_certinfo getifaddrs@@GLIBC_2.3 Curl_ssl_close_all curl_easy_setopt Curl_ossl_data_pending Curl_poll Curl_crealloc BIO_ctrl curl_multi_init Curl_wait_for_resolv ldap_next_attribute getsockopt@@GLIBC_2.0 RAND_egd Curl_http_done SSL_SESSION_free stdout@@GLIBC_2.0 curl_multi_add_handle stderr@@GLIBC_2.0 Curl_handler_http CRYPTO_free ENGINE_init curl_easy_pause Curl_reset_reqproto SSL_load_error_strings curl_global_cleanup Curl_splay Curl_ossl_check_cxn Curl_removeHandleFromPipeline Curl_mk_connc curl_share_init Curl_share_unlock __sigsetjmp@@GLIBC_2.0 Curl_cmalloc SSL_get_certificate Curl_he2ai setsockopt@@GLIBC_2.0 RAND_file_name Curl_raw_toupper Curl_llist_insert_next Curl_llist_init Curl_hash_delete Curl_ossl_close curlx_tvnow i2t_ASN1_OBJECT Curl_pgrsSetDownloadSize Curl_strerror __strtok_r@@GLIBC_2.0 ASN1_STRING_print SSL_CTX_set_cipher_list Curl_ossl_connect_nonblocking MD4_Final fseek@@GLIBC_2.0 Curl_ossl_engines_list Curl_easy_initHandleData Curl_client_write SSL_CIPHER_get_name time@@GLIBC_2.0 curl_mvfprintf Curl_retry_request Curl_ssl_getsessionid _start Curl_resolv_unlock Curl_GetFTPResponse BIO_new SSLv23_client_method fgets@@GLIBC_2.0 curl_jmpenv MD5_Init Curl_connect Curl_http ldap_free_urldesc sk_value curl_multi_remove_handle strerror_r@@GLIBC_2.0 Curl_raw_equal Curl_llist_remove fputs@@GLIBC_2.0 Curl_debug X509_EXTENSION_get_critical Curl_easy_addmulti X509_NAME_get_index_by_NID Curl_SOCKS4 RAND_status strstr@@GLIBC_2.0 Curl_protocol_connecting curl_version_info CRYPTO_cleanup_all_ex_data ftruncate64@@GLIBC_2.1 Curl_freeaddrinfo Curl_str_key_compare EVP_PKEY_copy_parameters Curl_hash_init curl_mvprintf X509_get_subject_name ENGINE_get_id __strtol_internal@@GLIBC_2.0 DES_set_key Curl_cache_addr curl_easy_recv Curl_ssl_recv X509_EXTENSION_get_object curl_easy_strerror __xpg_basename@@GLIBC_2.0 ERR_error_string SSL_get1_session MD5_Final ourWriteOut ldap_search_s Curl_hash_alloc lseek64@@GLIBC_2.1 SSL_CTX_add_client_CA ASN1_STRING_type Curl_free_ssl_config strncmp@@GLIBC_2.0 X509_NAME_ENTRY_get_data RAND_bytes Curl_ssl_set_engine_default ENGINE_get_next Curl_cookie_clearsess __fini_array_start gmtime_r@@GLIBC_2.0 fputc@@GLIBC_2.0 __libc_csu_init glob_cleanup Curl_cookie_list __xstat64@@GLIBC_2.2 PKCS12_PBE_add ENGINE_by_id SSL_CTX_use_PrivateKey __bss_start Curl_resolv Curl_digest_cleanup_one Curl_pgrsResetTimes Curl_protocol_doing main Curl_FormBoundary curl_easy_perform Curl_num_addresses Curl_global_host_cache_init curl_easy_init X509_STORE_CTX_get_current_cert X509_get_ext_d2i __libc_start_main@@GLIBC_2.0 SSL_CTX_ctrl Curl_handler_ftp curl_multi_assign Curl_nbftpsendf __init_array_end Curl_llist_count Curl_getaddrinfo Curl_copy_header_value ldap_set_option Curl_addHandleToPipeline glob_next_url Curl_splaygetbest realloc@@GLIBC_2.0 EVP_cleanup Curl_if2ip strcat@@GLIBC_2.0 Curl_cookie_clearall Curl_digest_cleanup Curl_http_should_fail Curl_FormReader curl_getdate Curl_ossl_set_engine Curl_pgrsSetUploadCounter curl_multi_setopt curl_multi_socket_all data_start glob_match_url Curl_infof ldap_err2string hugehelp Curl_pgrsSetUploadSize curl_easy_reset Curl_write bind@@GLIBC_2.0 Curl_hash_pick Curl_is_resolved curl_global_init _fini fcntl@@GLIBC_2.0 Curl_splayremovebyaddr memcpy@@GLIBC_2.0 Curl_llist_move X509_STORE_add_lookup curl_multi_perform cutil_tvnow open64@@GLIBC_2.1 Curl_async_resolved ASN1_INTEGER_get fclose@@GLIBC_2.1 ASN1_STRING_data Curl_ssl_data_pending getsockname@@GLIBC_2.0 strrchr@@GLIBC_2.0 Curl_ip2addr Curl_cookie_freelist __strdup@@GLIBC_2.0 Curl_read Curl_ch_connc Curl_pretransfer gethostbyname_r@@GLIBC_2.1.2 glob_url Curl_connecthost ASN1_STRING_length X509_NAME_get_entry GENERAL_NAMES_free Curl_pgrsStartNow curl_slist_free_all X509_get_serialNumber fopen64@@GLIBC_2.1 Curl_getconnectinfo ERR_get_error gettimeofday@@GLIBC_2.0 Curl_speedinit Curl_cookie_getlist srand@@GLIBC_2.0 Curl_tvlong gethostname@@GLIBC_2.0 Curl_ssl_addsessionid SSL_CTX_use_certificate_chain_file Curl_llist_destroy Curl_ipvalid SSLv3_client_method MD4_Init SSLv2_client_method Curl_pgrsSetDownloadCounter Curl_ccalloc cutil_tvdiff Curl_done strcasecmp@@GLIBC_2.0 inet_ntop@@GLIBC_2.0 curl_msprintf exit@@GLIBC_2.0 Curl_close SSL_get_current_cipher curl_multi_fdset Curl_input_ntlm SSL_set_session Curl_FormInit calloc@@GLIBC_2.0 Curl_share_lock Curl_ossl_session_free curl_easy_escape sscanf@@GLIBC_2.0 _edata SSL_CTX_use_PrivateKey_file cutil_tvdiff_secs _GLOBAL_OFFSET_TABLE_ free@@GLIBC_2.0 _end SSL_CTX_check_private_key send@@GLIBC_2.0 ASN1_STRING_to_UTF8 ERR_free_strings Curl_nonblock DES_ecb_encrypt ldap_url_parse utime@@GLIBC_2.0 curlx_tvdiff_secs Curl_cstrdup isatty@@GLIBC_2.0 SSL_CTX_use_certificate_file memset@@GLIBC_2.0 cutil_tvlong BIO_s_mem PEM_read_X509 SSL_connect X509_STORE_set_flags strncasecmp@@GLIBC_2.0 connect@@GLIBC_2.0 Curl_cookie_cleanup stdin@@GLIBC_2.0 Curl_resolv_getsock ldap_memfree Curl_write_plain X509_get_issuer_name curl_easy_duphandle SSL_free Curl_cfree ldap_first_attribute strncpy@@GLIBC_2.0 Curl_base64_encode Curl_output_digest Curl_ssl_shutdown Curl_splayinsert Curl_proxyCONNECT SSL_CTX_set_default_passwd_cb_userdata __strtoul_internal@@GLIBC_2.0 Curl_follow Curl_ossl_cleanup __init_array_start _IO_stdin_used SSL_get_peer_certificate curl_unescape strtok@@GLIBC_2.0 ldap_next_entry SSL_get_verify_result curl_free d2i_PKCS12_fp curl_formget curl_slist_append Curl_isPipeliningEnabled Curl_ftpsendf recv@@GLIBC_2.0 ldap_init sprintf@@GLIBC_2.0 fwrite@@GLIBC_2.0 CRYPTO_malloc Curl_single_getsock ldap_value_free_len curl_strnequal __data_start inflateEnd Curl_ossl_recv curl_multi_info_read Curl_initinfo socket@@GLIBC_2.0 _Jv_RegisterClasses __ctype_b_loc@@GLIBC_2.3 Curl_ossl_seed rand@@GLIBC_2.0 Curl_getaddrinfo_ex curl_share_strerror curl_mfprintf curl_easy_cleanup X509V3_EXT_print inflateInit2_ SSL_get_peer_cert_chain PEM_write_bio_X509 Curl_doing_getsock EVP_PKEY_free Curl_strntoupper MD5_Update tcgetattr@@GLIBC_2.0 read@@GLIBC_2.0 alarm@@GLIBC_2.0 X509_LOOKUP_file curl_multi_socket Curl_socket_ready __fxstat64@@GLIBC_2.2 Curl_raw_nequal curl_msnprintf SSL_write geteuid@@GLIBC_2.0 Curl_pgrsDone freeifaddrs@@GLIBC_2.3 ldap_msgfree Curl_posttransfer X509_check_issued curl_multi_strerror curl_mvsprintf __gmon_start__ Curl_global_host_cache_dtor getpass_r strcpy@@GLIBC_2.0                                                                                                                                                                                                                                                                                                                                                                                    pre_diag/tools32/libldap.so.2                                                                       0000755 0000000 0000000 00000523571 12667754516 015010  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   ELF              c  4   DV     4    (                  TA TA          `A `Q `Q h	  l	           tE tU tU                                    b                P      ^  c                   M  {    F      "  J      X       e      E        g    ?              /          R  
           f                                  _     T    \      1    Y      l                                    }     o  Q       &     +    *    K      R   m   <  V  B       %     T   Z     ;      .         r          L     5    %   C         r        H          U  ~              (         0     w      #      9  y    t            _              *      J        k  z                 m     L             j                D  x           u            ]     S  '         d            
                          q  `   W  +           ~   Y                    W                  `  a      4  N  |  [  )   :  h        G            A                                                                                                                                                                                                          #                                  5                                                                                       E           P       A                           ;               <   "                       /               8   N           $                                       ^               w       0               -       G       U   f                              x   k           4                              C       \      ?               >   y           |       [                          a          9          F                     ,           2   6                      B       S             Z   n                                                  v          g                  i   '   V                  b       H   M   X   c                         j       }      s   :   z       (   !          {   =                                           D                                                     ]      o      K                                &             .      -                                     )             u                3         e                8                          !        3           O            I                       I   	  6  i  1   h                   n                O       v  7                      >  d                     l  Q                    s  p        =  ,  q                                           t     @                             @                     p   7  $                   2                                                    (            C            xG            G            xK            pS            S       	     c       
                 	           PA      
     `Q           tU           \V           dV           pV           tV           Z                                                                                                                                     @                  8      *  8      
   z    
   \o    
 d  (     
    |    
 	    U   
 $  ,    
 [
  T      
 5   #   
 7        
               ( S   
     #    
         
                    
     >    
    2    
        
   F     
 g  9 _    
       g       ^     
 $  lp    
   ث    
        
 	  <     
 F  ,     
 c  ` W    
         
               d   
 q  `      
 
    Z    
 
        
   j      
    e   
    tU            U              
       q                     2    
 u  c    
   ] K    
 v
  L# n    
            <   5    
 S  s ]   
    P     
 @  <      
     V    
                    
 m      %          j    
 q      U     Z      q      ~  l      
   h +    
   ^ 8    
 }
      r        ܪ     
 	  d  +    
 N  tS            #      (   ` T    
   l       
            R  0  ?   
 (	    q    
       >                    X 2    
 -
  P    
   . D   
 r	  h  d    
        
 .  H     
   ܹ j    
   4:     
 !      n      ^                   
 
  T  Z    
    = i   
 ]       
             j    V    
                o    
 u  P    
 m       
     
   
 /  4X R   
                        z           +            &       
 j
  $  f    
       J         6    
   7     
    S   
      N    
             +   8    
     ?    
 F  8      
   p l    
   Dm    
 8        
 
  -     
    >    
        
 D  < M   
 Q       
   ( '   
 ;      9      z  0. s    
   (    
            
    $    
 a  D    
 	      g       x     
    g   
 I   )    
     b    
             
    Z    
 
  % n    
       P       l     
   ; -   
          
   p  *    
 
  |  R    
 
        
                  9      x      X              
   pS        
        
 	  8  %    
     ]   
 J       
   }    
 {  <u 3    
 
        
 6	  0  0    
 /      X      v   2    
   8  U   
 
        
 w              8f  %   
 
        
     m    
 
        
 T      9             
    \   
   1    
             g    O    
   L       
 X   Td  j    
   L    
     i    
 \  <     
       9             
 =  pS                         9        g  q    
   ] K    
   z     
 -
       
   0o *    
       I                  X
        
        
       @      =
             x  s    
     ?    
 `  S     
 
       
       S        +    
   h      
   |S $    
 
  <4    
        
 Q  ` W    
   pu     
 N  8     
 *   ~    
   7      
   <     
   ̭    
 u  | 9	   
   l    
 S    '    
   H    
 &                            U     6    *    
     e    
 #        
               ` 
    
             i      E      K        
    *    
   0      
         
 )  G 	   
        
             
      
 N  L [    
 }   :     
 U  9 9    
    f   
   Dh     
   p      
       :       H  5   
 o  Z         
    
   \ N    
         
 o  #    
 ]    i    
 -  X J    
    2    
   0] Q    
 &       
 
    R    
   p      
 u  س  ]    
 
  d      
 ]  ċ    
       d      	  $     
   $ 2    
 |   2    
        
 @  t` +    
    O   
 $  :     
                          H      
   ă  ^    
         
 /               7    
 T  ^ M    
   $  }    
        
              D S    
       q            {     %       
               8 j    
     %   
 I  ԩ 2    
 8     w    
   2 e   
 `    
    
 L  ا      
 i  D8     
 k
    &    
    N    
        
 |            5          "         ;            ;                  F      X      	    *    
   x     
   d     
 '      
             f  l      
   ܘ     
 9  Ч      
 H  $  $   
 F           ]                 J      f              f    
     >    
       f      K  x  z    
   A    
    F    
 .      I      t   E    
   x     
   h  *    
   H  V    
 h  Z      
   tV      ?            H      n      {  Z      
        
 ~    
    
 L  B    
    d  j    
 E	  `  /    
   xl     
    5    
 
  (  Q    
 8       
   t     
 z   ̿      
 |      M     s        
 ;       
 T	    .    
 7  n h    
 u      C                   Pv v    
       x      W  i     
 a       
   ,       
   P|    
                g   
 D              p @    
     m    
   0 5    
 e        
   /    
 f                #    
 M  ?          P    
 ^  @@             5      L
    Z    
       V         q   
 
               xe      
   t_     
        
       
   O     
   -     
 	  ̲  j    
 8  xr a   
     %   
     i    
         
 b	       
 	  `  u    
    `g  m    
 b   S H           4      +         
       q     	    n    
 :  $8      
        
 {  4&    
   \ V    
 `      
       9        P $   
 D               
      q         ~    
             	  ع  I   
   hF     
   h S    
 n  y    
 0      }        $     
    ,e  K    
 A            4        
   `     
    | 2    
 W      
       |         |    
 >
        
        
     ]   
 
  ș     
       *       d *    
 u      G        ȁ      
 h  `     
             
  l^      
                 L      0        | =   
  _DYNAMIC _GLOBAL_OFFSET_TABLE_ __gmon_start__ _fini __cxa_finalize _Jv_RegisterClasses ldap_bind ldap_int_global_options ldap_simple_bind ldap_log_printf ldap_bind_s ldap_simple_bind_s ldap_open_defconn ldap_new_connection ldap_open ldap_init ldap_ld_free ldap_create ldap_int_initialize ber_memcalloc memmove ldap_url_duplist ber_memfree ldap_new_select_info ber_sockbuf_alloc ldap_free_urllist ldap_set_option ldap_initialize ldap_int_open_connection ldap_pvt_url_scheme2proto ldap_connect_to_path ber_sockbuf_io_debug ber_sockbuf_add_io ber_sockbuf_io_fd ldap_connect_to_host ber_sockbuf_io_tcp ldap_open_internal_connection memset ber_sockbuf_ctrl ldap_mark_select_read ldap_mark_select_write ldap_unbind ldap_result __assert_fail ldap_msgfree ldap_int_select ldap_is_read_ready ldap_is_write_ready ldap_int_flush_request __errno_location ldap_dump_connection ldap_dump_requests_and_responses ber_get_next ber_get_int ber_free_buf ber_init2 ber_free ldap_find_request_by_msgid ber_peek_tag ber_scanf ldap_free_connection ldap_free_request ldap_chase_referrals ldap_chase_v3referrals ldap_int_msgtype2str ldap_alloc_ber_with_options ber_printf ber_reset ber_skip_tag ldap_append_referral ldap_msgtype ldap_msgid ldap_msgdelete ldap_int_error_init ldap_err2string ldap_perror stderr fprintf fflush fwrite ldap_result2error ldap_parse_result ber_dup ldap_int_get_controls ber_strdup ldap_value_dup ber_memvfree ldap_compare_ext ldap_int_client_controls ldap_int_put_controls ldap_send_initial_request ldap_compare ldap_compare_ext_s ldap_compare_s ldap_search_ext ldap_build_search_req ldap_search_ext_s ldap_search ldap_pvt_put_filter ldap_search_st ldap_abandon ldap_search_s ber_memalloc ber_first_element ber_memrealloc ber_next_element ldap_controls_free ldap_control_free ldap_controls_dup ldap_control_dup ldap_create_control ber_flatten2 ldap_first_message ldap_next_message ldap_count_messages ldap_first_reference ldap_next_reference ldap_count_references ldap_parse_reference ldap_extended_operation ldap_extended_operation_s ldap_parse_extended_result ber_bvfree ldap_parse_extended_partial ldap_int_sasl_init ldap_int_sasl_close ldap_int_sasl_bind ldap_int_sasl_external ldap_modify_ext ldap_modify ldap_modify_ext_s ldap_modify_s ldap_add ldap_add_ext ldap_add_ext_s ldap_add_s ldap_rename ldap_rename2 ldap_modrdn2 ldap_modrdn ldap_rename_s ldap_rename2_s ldap_modrdn2_s ldap_modrdn_s ldap_delete_ext ldap_delete_ext_s ldap_delete ldap_delete_s ldap_abandon_ext ber_flush ldap_sasl_bind ldap_sasl_bind_s ldap_parse_sasl_bind_result ldap_pvt_sasl_getmechs ldap_first_entry ldap_get_values ldap_charray2str ldap_sasl_interactive_bind_s ldap_unbind_ext ldap_unbind_ext_s ber_sockbuf_free ldap_free_select_info ldap_unbind_s ldap_send_unbind ldap_enable_cache ldap_disable_cache ldap_set_cache_options ldap_destroy_cache ldap_flush_cache ldap_uncache_request ldap_uncache_entry ldap_add_request_to_cache ldap_add_result_to_cache ldap_check_cache ldap_pvt_find_wildcard ldap_pvt_filter_value_unescape __rawmemchr ldap_put_vrFilter ldap_memfree ldap_memvfree ldap_memalloc ldap_memcalloc ldap_memrealloc ldap_strdup ldap_mods_free ber_bvecfree ldap_sort_strcasecmp ldap_sort_entries ldap_count_entries qsort ldap_get_dn ldap_explode_dn ldap_sort_values ldap_parse_passwd ber_init ldap_passwd ber_alloc_t ldap_passwd_s ldap_parse_whoami ldap_whoami ldap_whoami_s ldap_get_dn_ber ber_set_option ldap_dn2ufn ldap_dn_normalize ldap_str2dn ldap_rdn2str ldap_dnfree ldap_explode_rdn ldap_str2rdn ldap_rdnfree ldap_dn2dcedn ldap_dcedn2dn ldap_dn2ad_canonical ldap_dn2str ldap_avafree ldap_bv2dn ldap_bv2rdn strncasecmp ldap_int_parse_numericoid ber_strndup ldap_utf8_lentab ldap_utf8_mintab ldap_rdn2bv ldap_dn2bv ldap_next_entry ldap_get_entry_controls ldap_first_attribute ldap_next_attribute ldap_get_attribute_ber ldap_get_values_len ldap_count_values ldap_count_values_len ldap_value_free ldap_value_free_len ldap_delete_result_entry ldap_add_result_entry ldap_set_ber_options ldap_send_server_request ldap_url_dup ldap_free_urldesc ldap_mark_select_clear ldap_pvt_ctime fputc ldap_free_request_int ldap_url_parse_ext strcat ber_write ber_log_dump ldap_int_tblsize ldap_int_inet4or6 ldap_int_timeval_dup ber_pvt_socket_set_nonblock socket shutdown setsockopt getpeername sys_nerr sys_errlist connect getaddrinfo freeaddrinfo inet_ntop gai_strerror inet_ntoa ldap_int_ip_init sysconf ldap_pvt_url_scheme2tls ldap_is_ldap_url ldap_is_ldaps_url ldap_is_ldapi_url ldap_url_desc2str sprintf ldap_pvt_hex_unescape __strtol_internal ldap_str2charray ldap_url_parse ldap_charray_dup ldap_url_parselist ldap_url_parselist_ext ldap_charray_free ldap_url_parsehosts ldap_url_list2hosts strcpy ldap_url_list2urls strncpy ldap_create_sort_keylist ldap_free_sort_keylist ldap_create_sort_control ldap_parse_sort_control ldap_create_vlv_control ldap_parse_vlv_control fopen fgets __ctype_b_loc fclose getenv ldap_int_initialize_global_options ldap_int_utils_init ldap_get_option strcmp ldap_set_rebind_proc vsnprintf ber_pvt_log_print ldap_pvt_strtok ldap_pvt_str2upper __ctype_toupper_loc ldap_pvt_str2upperbv ldap_pvt_str2lower __ctype_tolower_loc ldap_pvt_str2lowerbv ldap_pvt_gethostbyname_a gethostbyname __h_errno_location ldap_pvt_get_hname getnameinfo ldap_pvt_gethostbyaddr_a gethostbyaddr ldap_pvt_get_fqdn gethostname ldap_syntax2name ldap_matchingrule2name ldap_matchingruleuse2name ldap_attributetype2name ldap_objectclass2name ldap_contentrule2name ldap_nameform2name ldap_structurerule2name ldap_syntax2str ldap_syntax2bv ldap_matchingrule2str ldap_matchingrule2bv ldap_matchingruleuse2str ldap_matchingruleuse2bv ldap_objectclass2str ldap_objectclass2bv ldap_contentrule2str ldap_contentrule2bv ldap_structurerule2str ldap_structurerule2bv ldap_nameform2str ldap_nameform2bv ldap_attributetype2str ldap_attributetype2bv ldap_int_parse_ruleid ldap_syntax_free ldap_str2syntax ldap_matchingrule_free ldap_str2matchingrule ldap_matchingruleuse_free ldap_str2matchingruleuse ldap_attributetype_free ldap_str2attributetype ldap_objectclass_free ldap_str2objectclass ldap_contentrule_free ldap_str2contentrule ldap_structurerule_free ldap_str2structurerule ldap_nameform_free ldap_str2nameform ldap_scherr2str ldap_charray_add ldap_charray_merge ldap_charray_inlist ldap_utf8_strtok ldap_utf8_strchr ldap_start_tls_s ldap_dn2domain ldap_domain2dn ldap_domain2hostlist __res_query __dn_expand ldap_utf8_bytes ldap_utf8_chars ldap_utf8_next ldap_utf8_offset ldap_utf8_charlen ldap_utf8_charlen2 ldap_x_utf8_to_ucs4 ldap_x_ucs4_to_utf8 ldap_ucs_to_utf8s ldap_utf8_prev ldap_utf8_copy ldap_utf8_isascii ldap_utf8_isdigit ldap_utf8_isxdigit ldap_utf8_isspace ldap_utf8_isalpha ldap_utf8_isalnum ldap_utf8_islower ldap_utf8_isupper ldap_utf8_strcspn ldap_utf8_strspn ldap_utf8_strpbrk ldap_x_utf8_to_wc ldap_x_utf8s_to_wcs ldap_x_wc_to_utf8 ldap_x_wcs_to_utf8s ldap_x_utf8_to_mb wctomb ldap_x_utf8s_to_mbs wcstombs ldap_x_mb_to_utf8 mbtowc ldap_x_mbs_to_utf8s mbstowcs liblber.so.2 libresolv.so.2 libdl.so.2 libc.so.6 _edata __bss_start _end libldap.so.2 /usr/local/lib GLIBC_2.2 GLIBC_2.1.3 GLIBC_2.1 GLIBC_2.3 GLIBC_2.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                D         ii
           ^         si	        ii
        ii
        ii
         `Q    dQ    Q    Q    Q    Q    Q    Q    Q    Q    Q    Q    Q    Q    Q    Q    Q    Q    R    R    R    R    $R    ,R    4R    <R    DR    LR    TR    \R    dR    lR    tR    |R    R    R    R    R    R    R    R    R    R    R    R    R    R    R    R    R    S    S    S    S    $S    ,S    4S    <S    DS    LS    TS    \S    hS    S    S    S    S    (T    ,T    <T    PT    dT    xT    T    T    T    T    T     U     U    $U    (U    ,U    0U    4U    8U    <U    @U    DU    HU    LU    PU    XU    `U    hV    |Z .  Z >  Z `  Z   Z   Z   Z   Z   Z   Z   Z ? Z W Z y Z { Z  Z  Z  Z  Z  V   V   V "  V %  V '  V (  V *  V +  V 0  V 2  V 3  V 5  V 6  V 7  V 8  V :  V =  V C  V F  V G  V H  V I  V L  V M  V N  V P  V Q  V R  V T  V U  V V  V X   W Y  W Z  W \  W ]  W ^  W a  W d  W e   W f  $W g  (W h  ,W j  0W l  4W n  8W o  <W p  @W q  DW r  HW s  LW u  PW v  TW w  XW y  \W z  `W {  dW }  hW ~  lW   pW   tW   xW   |W   W   W   W   W   W   W   W   W   W   W   W   W   W   W   W   W   W   W   W   W   W   W   W   W   W   W   W   W   W   W   W   W    X   X   X   X   X   X   X   X    X   $X   (X   ,X   0X   4X   8X   <X   @X   DX   HX   LX   PX   TX   XX   \X   `X   dX   hX   lX   pX   tX   xX   |X   X   X   X   X   X  X  X  X  X  X 	 X 
 X  X  X  X  X  X  X  X  X  X  X  X  X ! X " X # X $ X % X & X ' X * X ,  Y - Y / Y 0 Y 2 Y 3 Y 4 Y 8 Y 9  Y : $Y < (Y = ,Y > 0Y ? 4Y @ 8Y A <Y B @Y C DY E HY F LY G PY H TY K XY L \Y M `Y N dY O hY P lY Q pY S tY U xY [ |Y ^ Y _ Y a Y c Y d Y f Y h Y j Y k Y l Y p Y q Y r Y s Y t Y v Y w Y z Y } Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y   Z  Z  Z  Z  Z  Z  Z  Z   Z  $Z  (Z  ,Z  0Z  4Z  8Z  <Z  @Z  DZ  HZ  LZ  PZ  TZ  XZ  \Z  `Z  dZ  hZ  lZ  pZ  tZ  xZ  U
    ?               h       h      h      h      h        h(   $   h0   (   h8   p,   h@   `0   hH   P4   hP   @8   hX   0<   h`    @   hh   D   hp    H   hx   L   h   P   h   T   h   X   h   \   h   `   h   d   h   h   h   pl   h   `p   h   Pt   h   @x   h   0|   h       h      h       h      h      h     h     h     h      h(     h0     h8  p   h@  `   hH  P   hP  @   hX  0   h`      hh     hp      hx     h     h     h     h     h     h     h     h  p   h  `   h  P   h  @   h  0   h      h    h     h    h     h    h    h    h      h(  $  h0  (  h8  p,  h@  `0  hH  P4  hP  @8  hX  0<  h`   @  hh  D  hp   H  hx  L  h  P  h  T  h  X  h  \  h  `  h  d  h  h  h  pl  h  `p  h  Pt  h  @x  h  0|  h     h    h     h    h     h    h    h    h     h(    h0    h8  p  h@  `  hH  P  hP  @  hX  0  h`     hh    hp     hx    h    h    h    h    h    h    h    h  p  h  `  h  P  h  @  h  0  h      h    h     h    h     h    h    h    h      h(  $  h0  (  h8  p,  h@  `0  hH  P4  hP  @8  hX  0<  h`   @  hh  D  hp   H  hx  L  h  P  h  T  h  X  h  \  h  `  h  d  h  h  h  pl  h  `p  h  Pt  h  @x  h  0|  h     h    h     h    h     h    h    h    h     h(    h0    h8  p  h@  `  hH  P  hP  @  hX  0  h`     hh    hp     hx    h    h    h    h    h    h    h    h  p  h  `  h  P  h  @  h  0  h      h    h     h    h     h    h    h    h      h(  $  h0  (  h8  p,  h@  `0  hH  P4  hP  @8  hX  0<  h`   @  hh  D  hp   H  hx  L  h  P  h  T  h  X  h  \  h  `  h  d  h  h  h  pl  h  `p  h  Pt  h  @x  h  0|  h     h    h     h    h     h    h    h    h     h(    h0    h8  p  h@  `  hH  P  hP  @  hX  0  h`     hh    hp     hx    h    h    h    h    h    h    h    h  p  h  `  h  P  h  @  h  0  h      h    h   USP    [ P  tЋ]ÐUSR    [þ T   u40  u/tҋuƃT  ]ÃK뾉USP    [V t
L  u]ÉPUVS    [ H  @uu,}   tFPV   e[^PuuVkꐃj j j Pjj  붉UVS    [ê H  @uu,}   tFPV   V   e[^RuuVꐃj j j Pjj  붐UVSj jujv$    [/ Vv FtuFPQ   e[^Ð@1UWVS    [ H  @}uuyVWƃ1tIVxAH  @t+j j ĲtβPղPjj  e[^_j j j V'1묃j VWPjj  hUWVS    [. H  E     Z   tf?t%j Wpf?tR   e[^_ÉB   h   jƃZ   tQjHWFPfF F8    F<    Zw EF$uVZ   뉍v sF|t fFL tE01]v v$AX붉j j j Pjj c ?v UWVSE    [ P}uD1҅u$tEp(tVWj0uau
Ue[^_j j juo1v UWVSE     E    [Ê P}u&tPWhP  uuEU1e[^_j j juv UWVS    [" H  @uP  vE   te[^_ÉuvM1u@t֍Pj
(  E0%j j
8  M1 	Ph(  E01놉VҋFE    t	:    E    E  u$   vH%	|  RuPuuuE0u @
Pj
(  M1Yj j
<  E0/Uyj j j Pjj  v UWVS}    [Ã WEt    e[^_Éj@jt   Pj@j V    F   F    pd$    j jj P` toPuj64Pj
(  6d j j
<  6PptZY6PYX67&EPj7E   /1.7Z       UWVSEuEE    [^ EEE}   tzH  @uOPuuV   tFP    @e[^_ËEEEEE}Eue[^_K  v j j u9Pjj  뒍OPjf[PdP}OPje[PzUWVS    [Â H  @  EphE    tX~6u     H  @uq6u  EtLExVuH  @u
e[^_Ãj j j ,Pjj  ؋FUBh믍v j j ulPjj  m}tU9tu낋Et(Et!Bdtst	y   Ru1QEtfMuFuFUBUuVt
FBF    F    	H  @j v6	}uFuFUBh똅jcj uuPjj  2UWVSE    [Ë uE    j  E@    H  @  E    t$VUj UEU]E܃v H  B   t  K  QuuudU   @E}u>Et-j ƋU+E)҉U~AH  @uu܃}zEe[^_Ãj j RPjj  ˋEE    @PU   ōv Epxt Rj j6_  v uuuE@  E   }   UBdEtxtlU}rxAv ~~ t}!u6ut׃uV6uuu  E 븃@(0R{EpdPdv UBHt8uEO1}Q   UBPxH  @j j 0,Pjj & uV6uuu    EWjEpxP^uj uulPjj H   B`uv6Pjj  H  @j j u̍Ph   [PdPPh   [PzߐUWVS   E    [ ǅ`      E  H  @`  UB*  f8Ɖl  EHv 7     PVHu0dh  UEB    Pl@#  uu     H  @uiPj jut4l?UBLPj lGl=jlYe[^_Éj j j Pjj  vv uu\u#H  xGj j u,뭃Hld@	  H  B	  \BEddǅT    ǅP    ǅx    ǅXBǅL      Uz   El   ǃdsDǅ|    =  \\V PtPPD @tEpPD=     \B   \Bv  dd  L  Uz  \H,u
BH   Ul   ׃L  \\V PtPPR @   tU  xt\B
  t1	H!\PH  BtG\B uƳP\BuƳP\plPjj  H  Bk  T  \B  jlBǅl    \@    H  @  \x,/  \Pu@0txu@4u\r  utjj uul  jj  UdG}lG!  ;U  Urhǅh    t9tZhvu`u&EWxhPj juE8UBP    dv H  @utFt@dt?st:yt5`zthtFhBE0뗋FUBhNAʉt@dtstyt멉j w7Pjj  jUt0ddv	dsueǅ`   UE:@P    v UBPZ   XJ,Ћ@H  dFU   tG\B uƳP\BuƳP\pPjj  Pt\uZnjl2\lPuǅl    t  @H	X뢃j j RǳPjj u F)V\\r,u$  \@,\@HBJ,uj j \2,Pjj  RB,
1x Pjl8Tǅl    \@    Kj j TٳPjj y pUBPt\B\@	   v xPjV\uy\TB    H   @jj j 2lPjj  IdeǅT    P\@    lP}\@     =E@HǅLu\B,W|PPD@   xPVj |\u/T\@    H   BuTǅL   j j 0Pjj  ŉ\@    H  BǅXT   =j j 0Pjj  BHǅLu\r,Q|PPD@   xP\Pj|\u T\Pt@   H  BuǅL   j j 0LPjj  ǅXT   b\p0dPPjj l "E@PT   jljlE@PT   @tE@PR   H  @u?UBPQ   ej j j Pjj  ʍPh  [PPBuUBj uuPjj m }Ph  [P9뒍Ph  [PztUWVSE    [      u}C   QGuƳPG uƳPww7KPV @tzjVCXZ}WV'@t5EPV4@t>WV4tU2e[^_Ív UBPT   jVًE@PT   E@PS   ֋UBPZ   UWVSuF    [ 	}   tEWu>GG   FGF F    wG    F G F     H  F   uDt5G uƳPGuƳPw,Pjj u e[^_Éj j 7lPjj O F뛃PmP
9FG	   VQPGPud@USPE    [ë t@]ÍUPh7  [PbPMUSPE    [k t ]ÍtPh?  [PbPUEaS    [) wY$Í󍃃덃㍃ۍӍˍ)Í뻍v 밍Ŵ먍մUWVS    [Þ H  @}E    u7t(GwjwE<$uًEe[^_Ãj j j Pjj u UWVS}    [ utwH  @uMWh1Ʌt
92tыRue[^_ÅtBARdH֋BGhj j j Pjj  땍Phw  [PzPKv UEPl1ҋMt1:tv 9t@<u1ø   UEVPlҋut.1Ƀ:tv 94tA<u<tDA<u1^øUÍv US    [ HɋUt;tHu1$Ív USP    [æ H  @u#u¾tPЋ]Ðj j j оPjj  뿉UWVS    [B H  @}u  r  fL  %  wPYwPtPR   PP  6BGX t	8    GTt	8    G\tu  0Re[^_É  0jjPG\1tU싓  UQ4uE0FG\u덍v VPP  0_RP0P6l5AAPh   MP!PAPh   MPߍAPh   MPzăj j j UPjj  Jv USPuj j j j EPu    [P u5E uЋ]ÉUWVS    [ H  @}E        f}  US  Et	E     Et	U    Et	E     Et	U    E t	E      uFdt
styuvu^   GP^   e[^_ÅtGT  GX  G\f  vSE8  GTPGXPGPPPuE @R  URuU=     }(  Fa  x&  }	  u u!HE@   PuE}   Mtj uUtGPUEunEtwXZUEtwT@UEtw\UvtFdt
styu&vuE$uETuE_   ET   GPT   *uuu=   t?}tσuuW=   ]PuE]PuE맃uu=   PG\PPuEGTPGPPbVPG\    PGX    _PGT    <gPh  MPPAgPh  MPߍgPh  MPzčv j j j yPjj _ UWVS    [ H  @ut  R  f~/  E  }   M    uVt	e[^_ÐVǃZ   tRuuujnF`@F`PPWt @tNPWuVuCPWL@t&WujnV:U 1҅xpVPFPS   jWFPQPjDPPPjCP⍃PjBPʍPjAP벍Pj@Pz뚉j j j Pjj  kv UWS}    [@ tF1}PEPj j EPuuIuMK uUe[_Í$Pj|P1Pv UVSEPuuuuuu    [í V t	e[^ÉEPj juV @tPjuVϋFPʍv UWS}    [P t3}1j j EPuuuIMMe[_ÍFPh   P1PUWVS    [ H  @u}(      f~   u$VutruWuY   v e[^_Éu   u,Pu$u uuuuuV10tPujcVNU01҅yVP룸뱍PjGPPPjFPzj j j Pjj  v UWVSEPu,}(Wu$u uuuuuu    [× V0te[^_Ív u0WjuV ~stytQj E00VFP뼍v UWVS    [. H  @u}   tff~u@jjj j uuuuWV0tPWjcVe[^_ÍPh   PP{Ph   Pz߃j j j Pjj  Zv UWVS    [Z u}ƃ1   
  E(u   PE,   PEpuWjc@`@B`PPV0@tjE   uVg@tuPuPV@tRWVu uu,PV@te[^_ËE@PS   jV1ߍv UBPS   E@PW   ֍U_UB UBEx,Ƴv UWVSuuuuu}    [ WO tMu$u jPW @t5PUtPj E$0WIe[^_ÐVWU   GPU   ߋGPڍv UWVSuuuuuu    [\ V}  t(Wj jPVi @tPj 7Ve[^_ËFP󐐐UWVSE    [ u}  Efx_  ;  #     Uz-x u1҅ue[^_ËUBP\   \   Qh   2PW@   tbUR0uWl@tePu}HtRPPWD@t=PW.@t;uPW@t1BE@PS   S   .UBPS   PPPW@tۋdUr8멍5Pj*KPVPU5Pj)KP⍃5Pj(KPzʐUWVSu    [? }  1҅tF +F1҅    Eu
e[^_ÃEPVE=   t1҃J⬃T˃jE    0Z   t     PEPuV@   jjE2  U   P75E܋E܅   E܋MUA    PRUPVM@   uVtLt-E@    U܉PuuV߿@Q1PEP*PVyQEPPVbXEHMZAuV냃    uT   rEtu7Z       CE    iPjzKPVP UVuS    [ tu*FuV"e[^ÃP߉PȉUWVS}    [ÿ t1uWe[^_Ã4FuUWVS}    [s 1tI1t
Fu1~1   PEu1t1uE    e[^_Ð4Ut
Fu˃u;1ƍv UWVS}    [Ͼ 1tBjƃ1t-       GuF    F    GFe[^_ËG@PFu!u
Vv1΃PiGFPwwv?VF 딃PGiUWVSU    [ ҋ}      Etqj,ƃZ   t4PjFPW豾@t;uнUVtE01e[^_ÉVwZ   VPh  KPPPh  KPVߍPh  KPUSQM    [ ɋUt`fyu:t-u1]Ðx uu\   AP\   ۋQ<uЍPh  KPPePh  KPzߐUSPU    [g ҋEtDfzu%t]ÍPj%P0PPj%P⍃Pj%PzʐUSRE    [ UtGfxu(tB]ÍEPj%%PWP膼EPj$%P⍃EPj#%PzʉUSQE    [s Ut6fxu1tR@u]ÍjPj0%PPjPj/%Pz␐USPU    [ ҋEtTfzu5txst
PR]ÍPjP0P葻PjP⍃PjPzʐUSRU    [ ҋEt]fzu>t@tv xst	@u1]ÍPj'PP Pj&P⍃Pj%PzUSQE    [ Ut@fxu1t
zstRu]É@Pj<PPuPj;PzUWVSLu    [w }E    Q  f~.  
  st
Y   e[^_Pj,wEPE:EPPu@ET   tAEE    t3Pu@ET   tuuLEEtjEUEuM}tEFPFXu$FTuEIPFT    PFX    ǃW*륃u
뎍PjUPPPjTP⍃PjSPzʐUWVS    [ H  @u  }  f~Z  }*  M  ~\   FP\   e[^_ÐV   U   uh   uh   jwF`@F`PRPWT @tMPWuVuBPW,@t%Wj jwVU1҅xaVPFPS   jW菶FPBuh   jwF`@F`P]lZ   FPZ   fPj8~PPZ=     fPj7~PlӍfPj6~P뻍fPj5~Pz룍v j j j Pjj W ?v UWVS    [ H  @}uQ  1  f     E   EPuuuVW贼 t	e[^_ÐEPj juW谳 @t\Et	E     E t	E      j u uuW tu둉PjuW끋GPyE NPh   ~PP躵=     Ph   ~PlЍPj~P븍Pj~~Pz렃j j j Pjj 跶 v UWVSu    [W   f~  E  H  @R  ~\   FP\   e[^_ËExxtY   FPY   ᐋEt	U    Et	E     FT  FX  Urа  FTPFXPEPPW' @)  EPWE    E    EO=     =      =   tpj WMtKEUUt,EUEFPEu1uĿu̃uPEPPW]@tFPT   j WQEuFP{P覻PEPPW@tuWLFPT   j W멃]PWо@tփuWZ   FPZ   PFX    /PFT    j j j Pjj  Ph   ~PPdPh   ~PߍPh   ~PzĉUWVSu    [G w  f~Q  E'  H  @  ~\   FP\   e[^_ËExytY   FPY   ᐋEt	U    Et	E     Ur֭u  PW9@G  EPWE    E    Ea=      =      ut%PW@tuW诸j WѯMtEEUUt&EUEu1u跼u҃uPEPPWP@NFPT   j WDEuFP~P虸PEPPW@tuW@FPT   j W몸Z   FPZ   v j j j !Pjj G >Ph-  ~PP谯>Ph,  ~Pߍ>Ph+  ~PzĐU1ÐU1ÐU\   ÉU1ÐUWVS    [r H  @[  uut
e[^_Éu赳ǃZ   t݃ujfUB`@B`PPW @   U1t>8    pp %PPW٬ @   FUuăPW贬@tVPWuuuLPW芬@t,WujfuvU1҅xEPPE@PS   jWUBPUBPS   ރpp06j j j Pjj + v USR    [Ҭ H  @u/EPj j uuu uUЋ]Ãj j j Pjj 軮 볉UVSEPuuuuu    [P V臬 te[^ÐEPj juVT @tQjuV販ЋFPˍv USj j uu    [ uö]ÐUSEPj j uu    [þ u uUЋ]ÐUWVS    [Ê H  @}    f  Mk  UD  uW误t
e[^_ÃW裰E   ujhG`@G`PPu @   U1t08    ppPuҩ@txFUuуPu诩@tUPuuWܶuHPu胩@t)uujhWoU1҅WPGPS   jupp#Pv Z   GPZ   +Pjn8PP軪+Pjm8P⍃+Pjl8Pʍ+Pjk8Pz벍v j j j >Pjj ǫ v UVSEPuuuuu    [X V诨 te[^ÐEPj juV\ @tPjuV躦ЋFPˍv USj j uu    [ u苬]ÐUWVS    [Ҩ H  @u  u V te[^_ÐVǺZ   tދM   ~FP\   jWVP붐uh   uuujlF`@F`PrPWA0xLPWuVouPWx#WujlVU$1҅<|FPS   eRuuujlF`@F`P~PW {j j j Pjj ϩ v USP    [v H  @u3EPj j uuuuu۳ uUЋ]Ðj j j Pjj [ 믉USuj uu    [ u>]ÐUSjj uu    [Φ u]ÉUVSEPu uuuuuu    [Ò V t
e[^Ív EPj juV蔤 @tPjuV΋FPɍv USj j uuuu    [( u轥]USj j uj uu    [ u莥]ÐUSj j jj uu    [ʥ u_]ÐUWVS    [æ H  @u\  9  f~  M   U   uV˩t
e[^_ÃV迪   ujJF`@F`PPW% @tOPWuVTuDPW@t'WujJVU1҅wVPnFPS   jW^Z   FPZ   IPj<PPOPj;P⍃Pj:PʍPj9Pz벍v j j j Pjj [ v UVSEPuuuu    [ V tFPe[^ÐEPj juV @tPjuVNUSP    [Þ H  @u/EPj j uuy uUЋ]Ív j j j Pjj 臥 볉USPj j u    [+ u ]ÐUWVS    [ H  @u}u1WuUt
e[^_ÉWuVVu   㐃j j VPjj  벍v UVS    [Ò H  @uu j j Vu胭e[H^Ãj j V'Pjj 舤 Ív UWVS    [. H  @}  EpdE   tv U9_  9V<  v<uuu諨uE@P    1e[^_ËEE       tE   ~   U9UtsEpl1t>tG<u   PV$UBluZ   rlBPZ   {U}Dt
E@P    UBPRVuΞyjj v(uZWj jU2耪@  uK   ujPUB`@B`P8PW讟E @   QWuuԬEt\}tCt8F( RjWP]tE@PQ   EE    UƃjWҟlPWE@uUBPS   |E@PS   kUEBPZ   EE@PQ   Wu6Rub E9Et1~HEF,tUY   BPY   j uuLPjj 臡 'UWVS    [* H  @uP  *  f~  E   uVZuE  ~\   FP\   e[^_ÉEl  V$E  f8  E   MtEP   uh   uvj`F`@F`PlPWX @tbPWuV自uCPW0@t&Wuj`VU 1҅8VP0FPS   jW蒝FPS   jW~ uuh   uvj`F`@F`PzPW詜0Luh   uvj`F`@F`PPjcPP"Z   FPZ   }ƳUE{EeF0EZPjHP뢍PjGP늍PjFPzov j j j Pjj  v UWVS    [Î H  @}E       E t#\   GP\   e[^_ËE      PEPuuuuuW= ũEPj juW@ @   E E    tj EPuWYƃttu蠨qQjuW]ttEt؃PϜʋU tEU E    ӋGP"j j j Pjj 蟝 v UWVS    [B H  @uL  (  f~  M  Ut~  E     UzatY   FPY   e[^_Ív FTE    i  FXF  Epɗ  ~   FTPFXPEPPW @   URWUL=      =   tWj WEt-EUEFPEuFP6uڦEtԃP%PEPPW~@uj W}T   FPT   ]PWL@t΃uW芡DFTPEPb띸Z   FPZ   P舢FX    PpFT    \   WPh  PPPh  PߍPh  PzĐj j j Pjj  v UWVS    [ê H  @}uE       QEPj EPj j ƳPWx t
GPe[^_ÉuWؙ   RVPWĜt[PVEtVȚ^uϤEU1땃V誚Xu豤Z   GPZ   ru蕤   GP   VuyGP=    GP    ,j j j Pjj 诙 v UWVSu    [O }t> uhEPW胔u+H  @u'uu$u uuuVuW脞 e[^_Ãj j uLPjj  뺉H  @tj j VPjj  뒐UWVS    [Ú H  @u}      f~u_tF}1IUMPEPj j Rj uVS uUe[^_ÉƳUEE    뻍PjGPPǖPjFPzv j j j Pjj  :v UWS    [ç H  @}uQt5}1IUMQj j j Rj uuVe[_Ív ƳUEE    ̍v j j j Pjj k 두UWVSu    [ }tKf~u(WVdt	e[^_ÐWujV蘓鍃2Pj(BPP芕2Pj'BPzUSuu    [Ê uߑ]ÉUSR    [j H  @uPj j u讑]Ðj j j KPjj o ωUWVS}Gd    [ u^  Gx7  GhtpP贠uGT   GX   G\   Gl   G|upG$uTGu8Gu7ْ<$衜e[^1_ÃP莜G    σPyG    볃PDG$    뗃PG|    xP7Gl    YP迕G\    6PGX    PGT    VjwxW褛OxuwdWXGduUSj j     [t uɏ]UWVS    [R H  @}   W賗tujBG`@G`PXPV#@t]PVuWRu;PjBPV@t5PjVuٓ@t1e[^_GPQ   jVeGPGPS   v j j j ]Pjj ˓ GUSPE    [o t]fxu:@Ht
]Ív   0j)jPl֍PjPPۑPjPzv UÍv UÍv UÍv UÍv UÍv UÍv UÍv UÍv UÐUWVuB<vB<wAF   t(B<vB<vB<	v-uA1uܸ   ^_1B<	wF1   tB<	w1A1u11.uu   ۉUWVuB<vB<   F   t,;t0B<vB<v
B<	v-uA1uظ   ^_1t1B<vB<vB<	v1-u֊F   tňv ;tȍB<vB<v
B<	v-uA1u딍B<	wF1   t;t7B<	w1A1u1_1.TL   ҅t1E8v UWVM1   t(u
(t?)t61<\t$tAtuلH^!_Åuغ   ѐOǐGÐUMAЃ	vAQvAQ	ÉUUVt%v (|1Ƀ)~*t\tBuމщ^Ív r1ɄtF<	vF<v
F<w v JA<	vA<vA<w뮉(|
*~\uB1UWVU11t,v Ѓ(|*~ \t%UGFUu׋E e^_ÐFEEtURUEx1UDP¹xEЋUFG넃}(|}*~}\uEctUWVS    [ƌ u2Puu辋1@tRFV1҅t=  PuVuy  1@t%)PutG@P!e[^_ÉUWVS    [6 H  @u  VGEMɸZ      uE    tW(   (    t|H  @uRj V.ZYVu  @Etu1} HEu袔Ee[^_Ãj j j Pjj 融 F봃)xH  @u)Pu?@tFME덉j j j %Pjj ? FE   	  
  &U  &  !   H  @   ҹ   E    tOUu<(t_<)tX<\tDE    tGt(u׃ VuO  @2w)"tUuE   IA뢃j j j 6Pjj Q \H  @u)j h   VuEJj j j JPjj  빃|H  @u	j h   뢃j j j [Pjj 轋 ًH  @uj h   lj j j kPjj 臋 ։F t	t
tPj j V|Pjj Q UWVS    [ H  @uE       td<    <	t<
t{tPFPEtYEE8  Vu!@t;E}   ttu}   t
1e[^_Ë}t> tFt< t<	t<
tmj j VPjj X 7UWVS    [ H  @u  V
ƃt`j=V葅t8PUP<  @  <  :   Vu1H!ǃV莐e[^_Ãu艌tЀ8 uwE   V7t}   t6upxPuVu썃Puǃ sVh   PuǃTE8*ux uE   xPuVuw  ̓@ j:VnEE    tK  Ej:uJE  U BUE8dxnx > M  EU: EtE8 
  Ph   2Pu
uEtU:    Y>    GuxbPuh   )Pu衄ǃ Etjh   PuvǃaVh   Pu>ǃ]Rh   Puǃ,PXoVE8duxnux tEEE    qVƳUT>t~E   v @ +E   E   v j j VPjj 耆 UUWVS    [& H  @u}E       Vh   Pu@t\? t9Wƺt?8 uxE   ? u8}   t/> uȃPu覂1҃Je[^_ÃWǁxPWu썃)Pui @u  E1F}耉Etj WVPjj Y UWVS    [ H  @u3  VEMɸZ   t~uE    tU(   (    txH  @uNj VYXVum@tuUNuqe[^_Ãj j j Pjj n F붃)uH  @u%Pu@tFM뇾딃j j j Pjj  FE    	   
   (   H  @   ҹ   E    tOUu<(t`<)tY<\tEE    tGt(u׃ Vu  @Kw);t7UuE   IA롃j j j Pjj = [V  Vu   F t	t
tj j V%Pjj ݂ UWVS    [Å uPVY_uVTXZPVc@e[^H	_ÉUWVS    [* H  @u   t\< tf<	tb<
t^tLFPǺt4GE Vu@tEtEu1ҍe[^_ÉFt< t<	t<
t덍v j j V9Pjj 贁 XUWVS    [Z H  @uE  Vdƃtcj=V|t8PUP<    <]  :   Vu!1}H!EVEe[^_Ãut̀8 uu   v Vt   t5u|xPuVWPuj}E sVh   PuJ}ESE8*ux u
   {PuVu΃@ j:V{ǃG  0   G>   ? t	?    Ph   2Pu|E@t	?    }> u^}u{x9Puh   )PuZ| E}kEVh   Pu|EWh   Pu|EVW9VVƳv >t~   @       鐃j j VQPjj ~ US    [<| uQ]US    [| u~]US    [{ uQ]USu    [{ u{]ÐUSu    [õ{ uj]ÐUS    [Ô{ u{]UWVS}    [o{ t81t)8 ygPuL@u54Fau׋Eue[^_ÃW?P/뽉R룍v PtR}㐐USE0E    [z 0^]ÐUWV}u	E t=Ҹt4Eɸ   t&1tu2uMuv 1e^_Ív 1< D 球44WuFtMu롍v UWVSE    [z c  E0u{E}   1}   URPE   Eu E~UE    }MEUDEDM   Quuu}UME@EOEuLPjuu.~UUU~,1}MD1U41E{OuڋEMu1e[^_ÐPuvXZjV~UM4$ˁQMAPZ   븍lPj]~PzPIyUSPU
    [ex 1t@uujPRH}1]ÐUWVS}    [+x UE      Efx      u   E@         j EPEPRu uMEt9PytMQuPV<EXZjV?w}tu蛀e[^_ËE@PT   T   ڋE@PZ   Z   ֍Pj PPxPjP⍃PjPʍPjPz벍v UWVSU    [v 1ҋuE    E      Efxl  E E    jt   PW}utVh   PWcuEtuh   PWDuEtuh   PW%uPWuj EPWEvxIu uuE@UH!PPu|jW\ue[^_ÉE@PS   S   v E@PZ   Z   эv EEEEnPjPPPvPjOP⍃PjNPzʍv UWVSEPu uuuu}    [t WW te[^_ÃEPj juWr @t6VuuWwtu]QjuWr뫍v GP룐UWVS}    [[t UEE       f   tktK     j PEPRW{ tPW e[^_Éu	}1獃Pj$P-PtPj$P⍃Pj$PʍPj$Pz벐USPU    [os ҋEt]fzu>tPuuj DPRQz]Í\Pj8$PPs\Pj7$P⍃\Pj6$PzUWVSEPuu}    [r W{t	e[^_ÐEPj juWp @t6QuuWutuMRjuW
p몍v GP뢐UWVSL    [Nr H  @u   U   EfxuetEv}   PEPUPEP~@tEe[^_Ív E@PT   1獃Pj_PPrPj^P⍃Pj]Pzʉj j j Pjj s 3v UWVSL    [Vq H  @uE    E      E^  Efx8    }   MUB           E     uWvEUҸZ   t\EUv}   uVuPu9}@t_Et,Mtj u(pE     Ee[^_ÐWVjutEtދUBPR   ER   뫍v E@PT   ET   뎐UUXPj{PPpPjzP⍃PjyPʍPjxPz벐j j j Pjj q ]v USP    [~o H  @E    uj@EPj uxsE]Ãj j j Pjj wq ʉUWVS    [o 1} HЃ@E苃H  @   Vj EPu	p1҅   E    1tv Gu   PuEtUU 1t'uPuV4mUGuރutE    e[^_Ãurt1jt1҅EtыE     Đj j j Pjj Cp v UWVS,    [m H  @  j EPEPut1҅7  E 0E    tEUuU   PsEk  E E       U4~E    )  WEPvVRU%     M   EEPPUas6vPpE8=@E؃~   EPUv:Pu_'  uIE8 UE<EB U<UE    uoUe[^_Ãu(o_un1ލv E8#U؃DPu#  vUЃ@PUr9v FD EFE뛉j j j Pjj 'n v USP    [k H  @E    uj0EPj uoE]Ãj j j Pjj m ʉUSP    [rk H  @E    ujEPj0uloE]Ãj j j -Pjj km ʉUSP    [k H  @E    ujPEPj uoE]Ãj j j <Pjj m ʉUWVS    [öj H  @u}E    uJtd1    tPuEPVkt	e[^_ÐPuWulXupۃj j j RPjj wl 똍ePh  PwPjv UWVS}    [i    Mt]P;pƃ1t<FFR7wPlV MQFEFVF    e[^_Í}PhI  PP=j}PhH  P߉UVuS    [?i tvMr4$Ere[^ÍPhb  PPiv UWVS}    [h t1uWqe[^_Ð4)rFuԉUWVS}    [Óh t1uWqe[^_Ð4jFuԉUWSU    [@h t,1WuuEIPMUke[_ÍPh  P!PhUWVS   Uz
h    [g ǅTT   ǅP    ǅL    ǅX    H,ǅD    @I  E  H  @  E%   u0    t'0wt  tY   e[^_ÐE01҅tPVj UrhT   uϋE%   0\O  \;@   `0\X48))Ƌ0`Qu48Q2g   \;@s+
t%E%       p  v XPHFD9ƉPǅX      ;@   :    B;@\s
E0.X   Px#PH4=hNPy݋,9HtHnH  @uLM1T5TuWPjj g ȃPgaPȃP<pkL   E%   0tM1;P}9L0HB;P|닍P    ǅT    L21;P}7΋<HD$$B;P$|뙋L0ǅTZ   j,9t8PPHjtƉHѥD\PTjtPPPHVf붊<,<;ǅTT    t؃0b/ր,р?/W\ BƳPuWPjj e Ph  PPcPh  PUWSU    [ c tR: t.1uuuEIPMU}ce[_ÍPh  PPwcPh  P!UWVS   ME    [qb 1E    ET   E    E    E    E    E    E    E    EEE   
  ҉U	  AE	  E	  Ec	  Et	U    E     E%   0t&0wt"	  tY   e[^_ËE1҅tPuj qdcT   uӋUUt:   0  0t  !    m  t< '  <	  <
  <
  t< g  <	_  <
W  <
O  tB<	   v$B<vB<w<E%          t: =   1tM1EEUBuKMxMu4iMyE9EtuhiEtMU
UP5iE   tO   tt   t0t   EtWjPtiuEɋutE%    t	E 0  uvt@Et t< t(<	t$<
t <
tt9 fuutBЉUttBt< t<	t<
t<
t밍MM~E%    t	E    ut@EtUUGPht  PP{_    uӋE%   t	w_uGEPuEPtU+EMR)QtU|      EmPh  qv 0uuEPuVuu
  뷋tGE    Et8 t7tB<vB<vB<	v-uUt@Et8 uɋUt1E)VE   E       }ĉEtʀ;uE   YFMVB<vB<vB<	v
-t;uuttVh   EPEPE    ]eMɉE'Ut   )UE   .P   P=@uEPURuUh  "M   t        1E      E%            ut@E    E    E1StME   1tE    U   PSbEt01҃M;U}uB;U|    뮋EEZ   `t8+T   J t0<t:,׉PuUREPUTtfMuAE9ME    E    tutU9t;EPuatMeutEZ   hȃP=atPEPuV]볉t< d  <	\  <
T  <
L  t9=@Et <    <	   <
   <
   t8#tzE   t
}E%    E    t	E   ut:"t/ @   Rt9 N    1@0   E@P   EE   E%    t
E 0  BEtB< t<	t<
t<
)tBv ЉUttB< t<	t<
t<
tE%    t
E 0  t@Et < t<	t<
t<
ttBЉUttB< t<	t<
t<
t@uEPuVuu  uEPuVuuw	     * Ph  P¼E   ePh  P&Ph  PiPh  P=KPh  P-UWVSu    [W 1  M  U  E     UUu9։UE    s2\  B<^J  Ҹ      E    F;ur΋UB9v&F<   <	  <
  <
  v U1E   2u7t+uE+uM1uRE8tVu(cUB1e[^_ÃFP)]UBVuPYMA ȃFP1\M9AE    sEM\tBMAEG9rUB9 xHPh#  PSPWAM\t,t;t+t"t<t>t t	t
t
t#wB<	vB<vB<wKEMTB<	vB<vB<w,EPEEP  EPEEG$HPh  P5v ~\BE      w~9$G< t<	t<
t<

\OE   u,;+E%   t/,t;t+t"t<t	>y   v B<wfFҸ   \   ,   ;   +   "   <   >t} tx	ts
tn
ti#tdB<	vB<vB<jVB<	vB<vB<NEPVN  E E<^v	M   FEHPh  P\HPh  PnHPh  P!PUWVSE    [wS 1}  M        ME    t<\l  </t<,tAuUB9v%A<    <	   <
   <
   1E   u7   +uuU)UUE}҉uPu^G1e[^_ËE@PX1ɋU1;MBs}>\tUE@AF;MrUB }W1I;MtaPhx  PlPRF>+MME)E>y\E      Eq9F< t<	t<
t<
~\NA/t,t=   EyaPh1  P\SaPh0  P5aPh/  P!v UWVSu    [3Q }  M        uE    t<\$  <,t<;t<+tFuUJ9v P t	t

t
u	x\tH1E   7u6   +EU)ЉEUE}҉uPu\G1ɍe[^_ËE@PV1ɋU1;MBs}>\tUE@AF;MrUB }W1I;MtPh  PlPPF>+uu})}=Fҹ   O\t+,t&;t!+t"t<t>t
E   EPh  P\zPh  P\Ph  P!>UWVSE    [O 1ɅuE      E        Ut<\d  <"P  Bu}   tot <   <	  <
   <
   1E   u<E+E)ȉEE9E   }Uɉ:uWuZUB1e[^_ËE@PT}G1ɋE19sv }>\tSE@AF;MrUB }W1I;MtPh  PlPNF>맍Ph
  PِB< t<	t<
t<
tUBv z t@B<,t3<;t/<=t+<+t'<<t#<>t<#t<\t<"tE      A^   Ph  P\>Ph  P Ph  P!UEVS    [óL u      HB<	v
B<wbBɈA<	wD
Јe[1^Ív A<w	D
v A<wD
ՍPhE  PPLB<wB땍Ph7  PӍPh+  P븍Ph*  P!띍v UWVSE    [óK }E      E}  W      M   u          P  	G  
>  
5  B<	vB<vB<  QB<	vB<vB<   u1E      u   U+U<Uҍ?   U)U;EuyE8GPPUBZ   tL19E    s3EEv EuEPEPEFE9r֋UB 1ҍe[^_ÍPh  PlPJ+M9\1   E   uM9 u   tJw-tAu,;+u tރ0ù/,B<w,;+r tۃ0 /[,ٍB<FPhV  P\PhU  PPhT  P!USPU    [H ҋMtMt*A]1Í
Ph  PP@I
Ph  PߐUWVSE    [?H tjEtDUt119re[^1_ÉEPUBP%FE;0r͍Ph  P!PHPh  Pߍv UWVSE    [ÛG %   MTɉUE  E  E     1҉UtByU:9E    }s!7u*E   EE}E9rߋEU1e[^_ÄP  @  E}vWD  E    tEE܋U܅҉Utv=   ;Usv :%   uB;UrEEEZgv <\tf<,tb<;t^<+tZ<"tV<<tR<>tN;}ti u9 t<	t7
t2
t-\t(,t#;t+t"t<t>t
EF<<\UU<\t<,t<;t<+t<"t<<t<>t< t<	t<
t<
t<#c몉E   %Ph  PPQF%Ph  P߉UWVSu    [OE   M  U  E EuU    e[^1_1MI;}E    Ms>E@EEMu.E\G0G0UAGMU܋E9ErċU:뜐8  Ћ@  4v+UM
E؊L
E؋D  E    tuu  v
E   t  EMB<`  \W  }vBuNXUM
NMBGUtURUۍv E E#UM<\   <,   <;   <+   <"   <<   <>   u4<\   <,t}<;ty<+tu<"tq<<tm<>ti< te<	ta<
t]<
tY<#tUU9Ut!MUUAMGM	M< t(<	t$<
t <
t<\t<,t<;t<+t<"t<<t<>uM\GE   tE@E뗉ȃPUEBPE뉍v uNv U\GPMEAPNEu3Ph_  P>PFC   3Ph@  PӍ3Ph?  P!븍3Ph>  P띐UWVSU    [B ҋu          :tzE   unR1Ʉt]<\td<,t`<;t\<+tX<"tT<<tP<>tL9tMz u,< t><	t:<
t6<
t2<\t.<,t*<;t&<+t"<"t<<t<>tABu1e[^_Ð<\t<,t<;t<+t<"t<<t<>t< t<	t<
t<
t<#uɐEPh  PPAEPh  P߉UWVS}    [@   El  EB  uE     1e[^_ÐE   tU    ލv 11P9U   GE<\   <,   <;   <+   <"   <<   <>   uM\U   ,   ;   +t|"tw<tr>tm th	tc
t^
tY#tT;ut#v UUFA;7NE	< t(<	t$<
t <
t<\t<,t<;t<+t<"t<<t<>uE\WAU뤍VPh  PP!@VPh  P!ߍVPh  Pčv UUVS    [? ҋutmtJ    t/E   u#R1Ʉt</t<,t<=tABu1e[^Ð荃dPh  PP`?dPh  PߐUWVS}    [_>    E   EtsuE     1e[^_ÐE   tU    ލv 119s!W</t<,t<=tUFA;7rߋE멋E\WAݍuPh!	  PP>uPh 	  P!ߍuPh	  PĉUUVS    [g= ҋutmtJ    t/E   u#R1Ʉt</t<,t<=tABu1e[^Ð荃PhN	  PP=PhM	  PߐUWVS}    [ÿ<    M   UtsuE     1e[^_ÐE   tU    ލv 119s!W</t<,t<=tUFA;7rߋE멋E\WAݍPhw	  PP<Phv	  P!ߍPhu	  PĉUWVSM    [; E    E   E     Ur  EL  U$  UMQUǋM    0   @uVFuO>uJV<dt<Du=B<ct<Cu2EE   tEPF@PvuE    >FEOyE8UMDUEe[^_ÉPuUEBPEF@P=vvu=FM.EF@E뗍Ph	  PPG;Ph	  PߍPh	  PčPh	  P멍Ph	  P뎍Ph	  PpUWVEU     11҉Et(J   pt#BtFGEuًU21ҍe^_ÐPEPMQBPUuڋE uE뻍v UWVSU    [K9 1E    uE81ҍe[^_ÉM4P6EvP!<>E=VG   ta#EGPFPuF<GMMtG+M
EUMu]EPUERPFPU?}랉UWVEU     11҉t'pBt+Hu!BtFG҉uۋU21ҍe^_úQEPuBPuӋEu븐UWVSU    [7 1E       v M4E   E    P6EvP:>E=FGt[HuNU#GPFPuF<GEMUuE81ҍe[^_úv EPEuPFPu}묐MGɲ,u/M?v UWVSu    [6 1   M   EU     1҉Et-DtaQ   t#A|GFEuՋU:1e[^_ÉPEPURAPu
E }E뾸ɍv 띍Ph
  PP6Ph
  PߐUWVSU    [5 1E       v U4V      E#EGPFP1uJF<GUUDt?VjPEP^8EUUuE81ҍe[^_ÐQjPEP8뿉EPUERPFPu}jUWVS}    [4 1   MtuEU     1҉t"v BFt-Hu BtFG҉uU21e[^_øv QEPuBPuދEu뻍Ph
  PP4Ph
  PUWVU1E    t`M4E   E    FtYHuNE#EGPFPXuF<GEUMuE81ҍe^_úEPEuPFPu}믐MGɲ,u/M_v UVSu    [3 Mt1%   =   Y   tPQEPu8Ue[^ÍPh3  P!P3UWVSu    [ç2 }  E    F      %   0q  0,     tY   e[^_ÍPEPWuEHT   uӋE@P{8F%   0   0watQ uPuWRuyǺ    uE)ЋV 1ev;S벃@t!P5juWRuy1uWRuǺ   닃juWRuh͍Tv @tPPEPWuEAPEPWuE/PEPWuEƳP1FPhD  PP1UVSu    [à0 Mt1%   =   Y   tPQEPu;Ue[^ÍPh  P!P1UWVS|E    [/0 ES     E     @    H  @Y  }2  E%   0E  0     t
Y   e[^_ÍEUM011҅E    t7uuVu4   MAʉM̋M}u΃GP5UB   M1E    E    tJEEuuuMAPM4    M̋EAuM̉Mu9uNWMA E    H  @uEuuMqPjj 0 ԍ+Ph  P6P;/}w}7G    뛐EZ   녍TM}@  PTM01҅E    t5uЉQVu42MAʉM̋M}ЅuЃGP$4UBcMIɉM   E   E      M1xPEĉEUuuuEUPRU4U u,1} MHI!EuąɉMyMA9 ]Ep86UB    Mq6}G    ES    EPj uu"M1M̅xEȉEUj uuEUPRU4 uMIuȅɉMy<Mq5} M11҅EEE    thMM4PuuVH_}t"t@uru:  v EMAʉM̋MuGP$2UBc}tuE̋}H11ɅEE    ~<}}Uuu}WR4MAu;MM|ʍEPVuuptM1E    E    tDEEuuMAPM4M̋EAuM̉MuWR<dt<DB<ct<C}M̉MM011҅E    t6u؍v QVu4MAʉM̋M}؅uЃGP0UBMI1MtJEԉEv Uj uuEUPRU4 MIuԃMu9+Ph  DƳP)UB1ƳPPu?Pjj + +Ph  PUSPU    [O) ҋEtTfzu5txdt
PR3]ÍPjP0P)PjP⍃PjPzʐUSRU    [( ҋEt]fzu>t@tv xdt	@u1]ÍPj*PPH)Pj)P⍃Pj(PzUSQE    [7( Ut@fxu1t
zdtRu]É@Pj?PP(Pj>PzUWVSLu    [ÿ' E}  f~         xdt
Y   e[^_Qj,pEPE~*XZPu3@ET   tWu/E}tEFPFXu!FTuE떃P50FT    P 0FX    ʍPjVPP'PjUP⍃PjTPʍPjSPzUWVS    [~& H  @uE      }n  EfxH  (  M  U    u+EU1tvv}   PuVRPu2@tVWVju*   UB9B tkUtHPEPWPuM2@tEUEe[^_ËE@PT   j u-%1ݍ\PjNqP{P-&Mt̍\PjJqPۉUBPR   릍\Pj*qP뵍\Pj)qP띍\Pj(qP녍\Pj'qPzjj j j Pjj & Jv UWVS    [Ö$ H  @}u      fuuEtVt6F9F t*PEPWPV0@tEe[^_GPT   1퍃PjlqPVP$PjkqP⍃PjjqPʍPjiqPz벐j j j Pjj % *v UWVS    [Ò# H  @}uE      E   Efx   M   t}tZF    G9G     tUuVt,PW/@tEe[^_ËE@PT   ET   ␍̍Ph   qPP#Ph   qPVߍPh   qPčPh   qP멍Ph   qPz뎐j j j Pjj $ UWVSLE    ['" uE      EfxY  9  }  H  @   v}   QEPERPuV[.@   uuC*uE   UuGXu*uWVE    	.@tSuu)tEtu\*EP]PVE    -@tEe[^_ËE@PT   1j j j aPjj '# rPj%PP!rPj$P⍃rPj#PʍrPj"Pz벍v UWVSLE    [c  uE      EfxY  9  E  H  @   v}   PEPERPuV,@   uu(uE   EuGXu(uWVE    E,@tSuu1(tEtu(EPPVE    +@tEe[^_ËE@PT   1j j j Pjj c! PjbPPPjaP⍃Pj`PʍPj_Pz벍v UU1t
1t@uÉUS    [Ä u]US    [d u!]US    [D uY&]UWVS}    [ 1t1t
Fu1ue[^_Ã   PF$EU1tً1uE    ōv 4Ut
FuσuS 1두UVuS1    [y EtatAt79tыRt)9ut!tBAB    Ѝe[^ËB1Pj+P5PPj+PUSPM    [ ɋUt,tB]Í6Pj4+P5P}6Pj3+PUVSuFL    [| Pte[^ÐFPZ   v UEfPLEfPÐUWVS    [2 H  Guu|Rj j6%@t"Pj j j j v`uVi e[^_ÉV(x$Gtȃj j j LPjj  몃ju[뮃j j j Pjj  cv UWVSu~(j v$    [c 7Ytb
8t0E@PQ   VPj j Wu$e[^_ÉF   7ut&E@P3   эv N,uF$PP PPF   7u 1띍v UWVS    [ê H  @}u  E    GP    c  ~t=juwPuGPQ   MtMIe[^_Ív VW  Gdt
x   j@j.   M@   @    EB$Er(thuuMAMABA@BA0J,B4Q0GdB<tP8WdB8    RW4 @@GP    U1EBGPZ   j j VWL"XZju EEHPWEtYPjuW  }E tEt
EE   @u jj uWƃ BCwtv j j j Pjj  v UWVS    [z H  @#  j$j{  u  UMɉtiutj VWu@u96uUtW$!E@PQ   1e[^_Ã76ԅtɃVTGUBxG EG   zxt`B@G      EptGxtH  @uOh   ƳPPu UOrtttG    Sj jWR0 1܃j j j lPjj ` 듃uE   GH  U@rtztuJEpDU2rrPP@UO rtuuWtj jWR1ރj j j Pjj  똋E@PZ   v %Wzv E@PZ   Kj j j Pjj k v UWVSExx    [ t9ut*G@t8 t
Vt: uEt6u׋ u1e[^_ÃPvRuϋG@9FuĉUVSuF    [Å j Fe[^ÐUWVS    [^ H  F}  EuIGHG~>j \FGue[^_Ãj j wPjj > ِ   G   WugMAx1҃t9   @ uwU;tPGt1uAwWH  @;j j j ?v 4FGu뤅tG B cG MAxUjP7uuj j 7u j j j Pjj  _v UWVSPU    [Ï ҍuƳP
P  0EE   Mȍ9UMEMċQtHMMă9m  ƳPrUċB@uIPPP  0] MċAhtstREpu  6!Y_EuP Pu6UċRu5  0j
EtEċ@ Ee[^_6jj~P~MċQt_1t 1t<E4VWu  0eMċQF uGuM  0jjP-v UWVS    [Ò   7jjPEpd;  ,E썃lEFt3t(ttt(Rv6u7p vvu7]v<u  6jj7PExht|cEuw7uE0wtCE0jjKPbEv v6u  0vuue[^_6j	j{Pp7j	j{PY.UVSuV8    [ umV<EPdV<tF8B8F$u@Fu)F uVe[^ÉPPɉjP=밋F<B<UWVS    [n H  @}uuiF0uJF,t'HP0@0t9tP4@4t9u92tVWe[^_ËF4v v0WN0u랃j 6vPjj  uUWVS<    [ú EU@P    H      AuE    E      1E    E    t4t.UB4M9A   H  rujMAPa   uXu'XE0<tEЋMUAP
   e[^_ËU    uE߃j j PPjj  vEE̋@,t
v E̋@,uɉuE    WUԉUuME4Hy  EԋP$\  @t	8 1  PjuuEt@(  UtuԋF  EPuuUB`@B`MPq$R   }؉  H  @y  ŰBMUȉE؋EPWj uűMq`VQ    E    E1E   UċJ6u&Zu]MċQ1E    t	FuHNM@    t EEUMȋR E@    VjuuEVMAP   H  @u.PUM4EPuAXuE    gj UrPY$ME4,Pjj 
 롃j UM4E0lPjj u
 \UBPS   ƳP=FH  @   UċBtn81tFu   PMqUăBt,MȉD    E1E        E   LE@PZ   8jMăAtUȉ@    뮋MAPZ   j j UM4Pjj d *P3E@    UBP\   ExPv j j j Pjj  @v UWVS<    [î	 H  @  E@P    UE    1t=1эq	v#UPj
uW tNG	w1e[^_ 
	vEP4E9P|*H  @tЃj j RPjj : 볋UB,Ut
Eċ@,u1E    E    }thEԉEj
Wt  Guukt~H  @uSPuȍEPuƋU   }uuU2rEЋUEj j uȍPjj [
 뎋H  @   E؃UEE   PuuUB`@B`PEp$R      uUĉEBuj uuE؋Ep`VP
uxẼur
 H  BuPuȍEPuƃ̃j j EpPPPjj `	 뻸