#ifndef _PCI9008_DEVICE_
#define _PCI9008_DEVICE_
//#################### ADӲPCI9008_PARA_AD #####################
// ADʵӲ
typedef struct _PCI9008_PARA_AD     
{
	LONG bChannelArray[16]; // ͨѡУֱ16ͨ=TRUEʾͨ򲻲
	LONG Gains[16];			// ƣֱ16ͨ
	LONG Frequency;         // ɼƵ, λΪHz, [3, 80000]
	LONG TriggerMode;		// ģʽѡ
	LONG TriggerSource;		// Դѡ
	LONG TriggerType;		// ѡ(ش/崥)
	LONG TriggerDir;		// ѡ(/򴥷)
	LONG TrigLevelVolt;		// ƽ(0--10000mV)
	LONG TrigWindow;		// [1, 65535], λ50
	LONG ClockSource;		// ʱԴѡ(/ʱԴ)
	LONG bClockOutput;      // ʱCLKOUT,=TRUE:ʱ, =FALSE:ֹʱ
} PCI9008_PARA_AD, *PPCI9008_PARA_AD;

//***********************************************************
// ADӲPCI9008_PARA_ADеGains[x]ģ뷶Χʹõѡ
const long PCI9008_GAINS_1MULT			= 0x00; // 1
const long PCI9008_GAINS_2MULT			= 0x01; // 2
const long PCI9008_GAINS_4MULT			= 0x02; // 4
const long PCI9008_GAINS_8MULT			= 0x03; // 8

//***********************************************************
// ADӲPCI9008_PARA_ADеTriggerModeԱʹôģʽѡ
const long PCI9008_TRIGMODE_SOFT		= 0x00; // ڴ
const long PCI9008_TRIGMODE_POST		= 0x01; // Ӳ󴥷

//***********************************************************
// ADӲPCI9008_PARA_ADеTriggerSourceԴźʹõѡ
const long PCI9008_TRIGSRC_ATR			= 0x00; // ѡⲿATRԴ
const long PCI9008_TRIGSRC_DTR			= 0x01; // ѡⲿDTRԴ

// ADӲPCI9008_PARA_ADеTriggerTypeʹõѡ
const long PCI9008_TRIGTYPE_EDGE		= 0x00; // ش
const long PCI9008_TRIGTYPE_PULSE		= 0x01; // 崥(ƽ)

//***********************************************************
// ADӲPCI9008_PARA_ADеTriggerDirʹõѡ
const long PCI9008_TRIGDIR_NEGATIVE		= 0x00; // 򴥷(/½ش)
const long PCI9008_TRIGDIR_POSITIVE		= 0x01; // 򴥷(/ش)
const long PCI9008_TRIGDIR_POSIT_NEGAT	= 0x02; // 򴥷(//½ش)

//***********************************************************
// ADӲPCI9008_PARA_ADеClockSourceʱԴʹõѡ
const long PCI9008_CLOCKSRC_IN			= 0x00; // ڲʱ
const long PCI9008_CLOCKSRC_OUT			= 0x01; // ⲿʱ

//*************************************************************************************
// ADʵӲ
typedef struct _PCI9008_STATUS_AD     
{
	LONG bNotEmpty;			// FIFO洢ķǿձ־=TRUEǿգ = FALSE 
	LONG bHalf;				// FIFO洢İ־=TRUEϣ = FALSE 
	LONG bOverflow;			// FIFO洢־= TRUEѷ = FALSEδ
	LONG nRemainCount;      // ADʣ
} PCI9008_STATUS_AD, *PPCI9008_STATUS_AD;

const int MAX_SEGMENT_COUNT = 64;
typedef struct _PCI9008_STATUS_DMA     
{
	LONG iCurSegmentID;								// ǰλID,ʾDMAڴĻ
	LONG bSegmentSts[MAX_SEGMENT_COUNT];			// ¾״̬,=1ʾӦΪ,Ϊ
	LONG bBufferOverflow;							// ״̬
} PCI9008_STATUS_DMA, *PPCI9008_STATUS_DMA;

//***********************************************************
// CreateFileObjectõļʽ(ָͨʵֶַʽ)
const long PCI9008_modeRead					= 0x0000;	// ֻļʽ
const long PCI9008_modeWrite				= 0x0001;	// ֻдļʽ
const long PCI9008_modeReadWrite			= 0x0002;	// ȶдļʽ
const long PCI9008_modeCreate				= 0x1000;	// ļԴļڣؽļ0
const long PCI9008_typeText					= 0x4000;	// ıʽļ

//***********************************************************
// ûӿ
#ifndef _PCI9008_DRIVER_
#define DEVAPI __declspec(dllimport)
#else
#define DEVAPI __declspec(dllexport)
#endif

#ifdef __cplusplus
extern "C" {
#endif
	//######################## 豸 ##############################
	HANDLE DEVAPI FAR PASCAL PCI9008_CreateDevice(int DeviceLgcID = 0);     // ߼Ŵ豸
	HANDLE DEVAPI FAR PASCAL PCI9008_CreateDeviceEx(int DevicePhysID = 0);  // Ŵ豸
	int DEVAPI FAR PASCAL PCI9008_GetDeviceCount(HANDLE hDevice); // ȡ豸̨
	BOOL DEVAPI FAR PASCAL PCI9008_GetDeviceCurrentID(HANDLE hDevice, PLONG DeviceLgcID, PLONG DevicePhysID);
	BOOL DEVAPI FAR PASCAL PCI9008_ListDeviceDlg(HANDLE hDevice); // ԶԻ巽ʽбϵͳееĸPCI豸
    BOOL DEVAPI FAR PASCAL PCI9008_ReleaseDevice(HANDLE hDevice); // ͷ豸

	//####################### ADݶȡ #################################
	// ڴͨûЩӿ򵥡ݡɿû֪豸
	// Ͳ㸴ӵӲЭͷƱ̣ĳʼ豸Ͷȡ
	// ADɸЧʵָ١ݲɼ
	BOOL DEVAPI FAR PASCAL PCI9008_ADCalibration(					// 豸У׼.		
										HANDLE hDevice);				// 豸
	// ADѯʽ
	BOOL DEVAPI FAR PASCAL PCI9008_InitDeviceProAD(			// ʼ豸TRUE,豸׼.
									HANDLE hDevice,			// 豸,CreateDevice
									PPCI9008_PARA_AD pADPara); // Ӳ, ڴ˺оӲ״̬

    BOOL DEVAPI FAR PASCAL PCI9008_StartDeviceProAD(		// ڳʼ֮豸
									HANDLE hDevice);		// 豸,CreateDevice

	BOOL DEVAPI FAR PASCAL PCI9008_ReadDeviceProAD_Npt(		// AD־Чʱô˺ȡ豸ϵAD(ǿշʽ)
									HANDLE hDevice,			// 豸,CreateDevice
									LONG ADBuffer[],		// ԭʼADݵû
									LONG nReadSizeWords,	// ƫƵݳ()
									PLONG nRetSizeWords);   // ʵʶȡĳ()

	BOOL DEVAPI FAR PASCAL PCI9008_GetDevStatusProAD(		// ADȡ豸ĸ״̬,ֵʾǷɹ
									HANDLE hDevice,			// 豸,CreateDevice
									PPCI9008_STATUS_AD pADStatus); // ADĸϢṹ

	BOOL DEVAPI FAR PASCAL PCI9008_ReadDeviceProAD_Half(	// AD־Чʱô˺ȡ豸ϵAD(ʽ)
									HANDLE hDevice,			// 豸,CreateDevice
									LONG ADBuffer[],		// ԭʼADݵû
									LONG nReadSizeWords,	// ƫλݳ()
									PLONG nRetSizeWords);	// ʵʶȡĳ()
		
    BOOL DEVAPI FAR PASCAL PCI9008_StopDeviceProAD(			// 豸֮ͣ豸
									HANDLE hDevice);		// 豸,CreateDevice

	BOOL DEVAPI FAR PASCAL PCI9008_ReleaseDeviceProAD(		// رAD豸,ֹ,ͷԴ
									HANDLE hDevice);		// 豸,CreateDevice

	//##################### ADݶȡ(жϷʽ)(ϲû) ###########################
	BOOL DEVAPI FAR PASCAL PCI9008_InitDeviceIntAD(								// ʼ豸TRUE,豸׼.
												HANDLE hDevice,					// 豸,CreateDevice
												HANDLE hEvent,					// ж¼,CreateSystemEvent
												ULONG nFifoHalfLength,			// ƫλݳ(СFIFO)
												PPCI9008_PARA_AD pPara);		// Ӳ, ڴ˺оӲ״̬
    BOOL DEVAPI FAR PASCAL PCI9008_StartDeviceIntAD(							// ڳʼ֮豸
												HANDLE hDevice);				// 豸
	BOOL DEVAPI FAR PASCAL PCI9008_ReadDeviceIntAD(HANDLE hDevice,				// 豸
												PLONG pADBuffer,				// ڽԭʼADݵû								
												LONG nReadSizeWords,			// ݳ()
												PLONG nRetSizeWords);			// شʵʳ()  
	
    BOOL DEVAPI FAR PASCAL PCI9008_StopDeviceIntAD(								// ڿʼADɼֹͣ豸
												HANDLE hDevice);				// 豸
	BOOL DEVAPI FAR PASCAL PCI9008_ReleaseDeviceIntAD(HANDLE hDevice);

	//##################### ADݶȡ(DMAʽ)(ϲû) ###########################
	// ADֱڴ(DMA)ʽ
	BOOL DEVAPI FAR PASCAL PCI9008_InitDeviceDmaAD(			// ʼ豸TRUE,豸׼.
									HANDLE hDevice,			// 豸,CreateDevice
									HANDLE hDmaEvent,		// DMA¼,CreateSystemEvent
									LONG ADBuffer[],		// û,Ϊά
									LONG nReadSizeWords,	// ÿDMAʱ,ûָӦȡʵʳ(ҪСڻnSegmentSizeWords)
									LONG nSegmentCount,		// ֶε,ȡֵΧΪ2-128
									LONG nSegmentSizeWords,	// ֶεĶγ(FIFO)
									PPCI9008_PARA_AD pADPara);	// Ӳ, ڴ˺оӲ״̬

    BOOL DEVAPI FAR PASCAL PCI9008_StartDeviceDmaAD(		// ڳʼ֮豸
									HANDLE hDevice);		// 豸,CreateDevice

	BOOL DEVAPI FAR PASCAL PCI9008_GetDevStatusDmaAD(		// ADȡDMAй״̬,ֵʾǷɹ
									HANDLE hDevice,			// 豸,CreateDevice
									PPCI9008_STATUS_DMA pDMAStatus); // õDMA״̬

	BOOL DEVAPI FAR PASCAL PCI9008_SetDevStatusDmaAD(		// ADDMAй״̬,ֵʾǷɹ
									HANDLE hDevice,			// 豸,CreateDevice
									LONG iClrBufferID);		// ҪĻID,Ϊ0
		
    BOOL DEVAPI FAR PASCAL PCI9008_StopDeviceDmaAD(			// 豸֮ͣ豸
									HANDLE hDevice);		// 豸,CreateDevice

	BOOL DEVAPI FAR PASCAL PCI9008_ReleaseDeviceDmaAD(		// رAD豸,ֹ,ͷԴ
									HANDLE hDevice);		// 豸,CreateDevice
	
	//##################### ADӲ ###########################
	BOOL DEVAPI FAR PASCAL PCI9008_SaveParaAD(HANDLE hDevice, PPCI9008_PARA_AD pADPara); // ǰADϵͳ
    BOOL DEVAPI FAR PASCAL PCI9008_LoadParaAD(HANDLE hDevice, PPCI9008_PARA_AD pADPara); // ADϵͳж
    BOOL DEVAPI FAR PASCAL PCI9008_ResetParaAD(HANDLE hDevice, PPCI9008_PARA_AD pADPara); // ADָĬֵ

	//################# ڴӳĴֱӲд ########################
	// ûԱ豸ֱӡ⡢Ͳ㡢ӵĿơ
	// ƶҪĿ̺ͿЧʱûʹЩӿʵ֡
	BOOL DEVAPI FAR PASCAL PCI9008_GetDeviceBar(					// ȡָָ豸ĴBARַ
									HANDLE hDevice,			// 豸,CreateDevice
									__int64 pbPCIBar[6]);	// PCI BARеַ,PCI BARжٿõַ뿴Ӳ˵
	BOOL DEVAPI FAR PASCAL PCI9008_GetDevVersion(					// ȡ豸̼汾
									HANDLE hDevice,			// 豸,CreateDevice
									PULONG pulFmwVersion,	// ̼汾
									PULONG pulDriverVersion);// 汾
	BOOL DEVAPI FAR PASCAL PCI9008_WriteRegisterByte(				// 豸ӳĴռָ˿д뵥
									HANDLE hDevice,			// 豸
									__int64 pbLinearAddr,	// ָӳĴԻַ
									ULONG OffsetBytes,		// ڻַƫλ
									BYTE Value);			// ַָд뵥ֽݣַԻַƫλþ
	BOOL DEVAPI FAR PASCAL PCI9008_WriteRegisterWord(				// д˫ֽݣͬϣ
									HANDLE hDevice, 
									__int64 pbLinearAddr,	// ָӳĴԻַ
									ULONG OffsetBytes,  
									WORD Value);
	BOOL DEVAPI FAR PASCAL PCI9008_WriteRegisterULong(				// дĽݣͬϣ
									HANDLE hDevice, 
									__int64 pbLinearAddr,	// ָӳĴԻַ
									ULONG OffsetBytes,  
									ULONG Value);
	BYTE DEVAPI FAR PASCAL PCI9008_ReadRegisterByte(				// 뵥ֽݣͬϣ
									HANDLE hDevice, 
									__int64 pbLinearAddr,	// ָӳĴԻַ
									ULONG OffsetBytes);
	WORD DEVAPI FAR PASCAL PCI9008_ReadRegisterWord(				// ˫ֽݣͬϣ
									HANDLE hDevice, 
									__int64 pbLinearAddr,	// ָӳĴԻַ
									ULONG OffsetBytes);
	ULONG DEVAPI FAR PASCAL PCI9008_ReadRegisterULong(				// ֽݣͬϣ
									HANDLE hDevice, 
									__int64 pbLinearAddr,	// ָӳĴԻַ
									ULONG OffsetBytes);

	//################# I/O˿ֱӲд ########################
	// ûԱ豸ֱӡ⡢Ͳ㡢ӵĿơ
	// ƶҪĿ̺ͿЧʱûʹЩӿʵ֡
	// ЩҪڴͳ豸ISAߡڡڵ豸ڱPCI豸
	BOOL DEVAPI FAR PASCAL PCI9008_WritePortByte(HANDLE hDevice, __int64 pbPort, ULONG offserBytes, BYTE Value);
	BOOL DEVAPI FAR PASCAL PCI9008_WritePortWord(HANDLE hDevice, __int64 pbPort, ULONG offserBytes, WORD Value);
	BOOL DEVAPI FAR PASCAL PCI9008_WritePortULong(HANDLE hDevice, __int64 pbPort, ULONG offserBytes, ULONG Value);

	BYTE DEVAPI FAR PASCAL PCI9008_ReadPortByte(HANDLE hDevice, __int64 pbPort, ULONG offserBytes);
	WORD DEVAPI FAR PASCAL PCI9008_ReadPortWord(HANDLE hDevice, __int64 pbPort, ULONG offserBytes);
	ULONG DEVAPI FAR PASCAL PCI9008_ReadPortULong(HANDLE hDevice, __int64 pbPort, ULONG offserBytes);


	//########################### ̲߳ ######################################
	HANDLE DEVAPI FAR PASCAL PCI9008_CreateSystemEvent(void); // ں¼󣬹InitDeviceDmaADVB̵߳Ⱥʹ
	BOOL DEVAPI FAR PASCAL PCI9008_ReleaseSystemEvent(HANDLE hEvent); // ͷں¼
	
#ifdef __cplusplus
}
#endif

//***********************************************************
// FIFO洢ĳ()
const long FIFO_IDT7202_LENGTH			= 1024;
const long FIFO_IDT7203_LENGTH			= 2048;
const long FIFO_IDT7204_LENGTH			= 4096;
const long FIFO_IDT7205_LENGTH			= 8192;
const long FIFO_IDT7206_LENGTH			= 16384;
const long FIFO_IDT7207_LENGTH			= 32768;

//***********************************************************
// 豸ַȡGetDeviceAddrĲRegisterIDʹõѡ(Ч)
const long PCI9008_REG_MEM_PLXCHIP	= 0x00; // 0żĴӦPLXоƬʹõڴģʽַ(ʹLinearAddr)

// Զ
#ifndef _PCI9008_DRIVER_
	#ifndef _WIN64
		#pragma comment(lib, "PCI9008_32.lib")
		#pragma message("======== Welcome to use our art company's products!")
		#pragma message("======== Automatically linking with PCI9008_32.dll...")
		#pragma message("======== Successfully linked with PCI9008_32.dll")
	#else
		#pragma comment(lib, "PCI9008_64.lib")
		#pragma message("======== Welcome to use our art company's products!")
		#pragma message("======== Automatically linking with PCI9008_64.dll...")
		#pragma message("======== Successfully linked with PCI9008_64.dll")
	#endif
#endif

#endif // _PCI9008_DEVICE_