#ifndef _PCI8996_DEVICE_
#define _PCI8996_DEVICE_
//***********************************************************
// ADʵӲ
typedef struct _PCI8996_PARA_AD     
{
	LONG bChannelArray[8];	// ͨѡУֱ8ͨ=TRUEʾͨ򲻲
	LONG InputRange;		// ģѡ
	LONG MultiFrequency;	// ʱʱӵıƵģʽ
	LONG Frequency;         // ɼƵ, λΪHz
	LONG TriggerMode;		// ģʽѡ
	LONG TriggerSource;		// Դѡ
	LONG TriggerType;		// ѡ(ش/崥)
	LONG TriggerDir;		// ѡ(/򴥷)
	LONG ClockSource;		// ʱԴѡ(/ʱԴ)
	LONG bTrigOutput;       // Ƿ񽫴źPXI,=TRUE:, =FALSE:ֹ
} PCI8996_PARA_AD, *PPCI8996_PARA_AD;

//***********************************************************
// ADӲPCI8996_PARA_ADеMultiFrequencyģ뷶Χʹõѡ
const long PCI8996_MULTIFRE_256			= 0x00; // 256
const long PCI8996_MULTIFRE_128			= 0x01; // 128
const long PCI8996_MULTIFRE_64			= 0x02; // 64

//***********************************************************
// ADӲPCI8996_PARA_ADеInputRangeʱʱӵıƵģʽʹõѡ
const long PCI8996_INPUT_N1000_P1000mV	= 0x00; // 1000mV
const long PCI8996_INPUT_N10000_P10000mV= 0x01; // 10000mV

//***********************************************************
// ADӲPCI8996_PARA_ADеTriggerModeԱʹôģʽѡ
const long PCI8996_TRIGMODE_SOFT		= 0x00; // ڴ
const long PCI8996_TRIGMODE_POST		= 0x01; // Ӳ󴥷

//***********************************************************
// ADӲPCI8996_PARA_ADеTriggerSourceԴźʹõѡ
const long PCI8996_TRIGSRC_DTR			= 0x00; // ѡⲿDTRԴ
const long PCI8996_TRIGSRC_PXI_TRIG0	= 0x01; // ѡPXIϵTRIG0Դ
const long PCI8996_TRIGSRC_PXI_TRIG1	= 0x02; // ѡPXIϵTRIG1Դ
const long PCI8996_TRIGSRC_PXI_TRIG7	= 0x03; // ѡPXIϵTRIG7Դ
const long PCI8996_TRIGSRC_PXI_STAR		= 0x04; // ѡPXIϵSTARԴ

// ADӲPCI8996_PARA_ADеTriggerTypeʹõѡ
const long PCI8996_TRIGTYPE_EDGE		= 0x00; // ش
const long PCI8996_TRIGTYPE_PULSE		= 0x01; // 崥(ƽ)

//***********************************************************
// ADӲPCI8996_PARA_ADеTriggerDirʹõѡ
const long PCI8996_TRIGDIR_NEGATIVE		= 0x00; // 򴥷(/½ش)
const long PCI8996_TRIGDIR_POSITIVE		= 0x01; // 򴥷(/ش)
const long PCI8996_TRIGDIR_POSIT_NEGAT	= 0x02; // 򴥷(//½ش)

//***********************************************************
// ADӲPCI8996_PARA_ADеClockSourceʱԴʹõѡ
const long PCI8996_CLOCKSRC_IN			= 0x00; // ڲʱ
const long PCI8996_CLOCKSRC_OUT			= 0x01; // ⲿʱ

//*************************************************************************************
// ADʵӲ
typedef struct _PCI8996_STATUS_AD     
{
	LONG bNotEmpty;			// FIFO洢ķǿձ־=TRUEǿգ = FALSE 
	LONG bHalf;				// FIFO洢İ־=TRUEϣ = FALSE 
	LONG bOverflow;			// FIFO洢Ķ̬־= TRUEѷ = FALSEδ
} PCI8996_STATUS_AD, *PPCI8996_STATUS_AD;

const int MAX_SEGMENT_COUNT = 64;
typedef struct _PCI8996_STATUS_DMA     
{
	LONG iCurSegmentID;								// ǰλID,ʾDMAڴĻ
	LONG bSegmentSts[MAX_SEGMENT_COUNT];			// ¾״̬,=1ʾӦΪ,Ϊ
	LONG bBufferOverflow;							// ״̬
} PCI8996_STATUS_DMA, *PPCI8996_STATUS_DMA;

//***********************************************************
// ûӿ
#ifndef _PCI8996_DRIVER_
#define DEVAPI __declspec(dllimport)
#else
#define DEVAPI __declspec(dllexport)
#endif

#ifdef __cplusplus
extern "C" {
#endif
	//######################## ͨú #################################
	// ڱ豸
	HANDLE DEVAPI FAR PASCAL PCI8996_CreateDevice(int DeviceID = 0);		// 豸
	int DEVAPI FAR PASCAL PCI8996_GetDeviceCount(HANDLE hDevice);			// ȡ豸̨
	BOOL DEVAPI FAR PASCAL PCI8996_GetDeviceCurrentID(HANDLE hDevice,		// ȡõǰ豸ӦID
													PLONG DeviceLgcID, 
													PLONG DevicePhysID);
	BOOL DEVAPI FAR PASCAL PCI8996_ListDeviceDlg(HANDLE hDevice);			// бϵͳееĸPCI豸
    BOOL DEVAPI FAR PASCAL PCI8996_ReleaseDevice(HANDLE hDevice);			// ر豸,ֹ,ͷԴ

	//####################### ADݶȡ #################################
	// ڴͨûЩӿ򵥡ݡɿû֪豸
	// Ͳ㸴ӵӲЭͷƱ̣ĳʼ豸Ͷȡ
	// ADɸЧʵָ١ݲɼ
    BOOL DEVAPI FAR PASCAL PCI8996_InitDeviceProAD(								// ʼ豸TRUE,豸̿ʼ.
												HANDLE hDevice,					// 豸
												PPCI8996_PARA_AD pADPara);		// Ӳ, ڴ˺оӲ״̬

    BOOL DEVAPI FAR PASCAL PCI8996_StartDeviceProAD(							// ڳʼ֮豸
												HANDLE hDevice);				// 豸
	
    BOOL DEVAPI FAR PASCAL PCI8996_ReadDeviceProAD_Npt(							// ÷ǿձ־ȡ豸ϵAD
												HANDLE hDevice,					// 豸
												PULONG pADBuffer,				// ڽݵû								
												ULONG nReadSizeWords,			// ݳ
												PLONG nRetSizeWords);			// ǷFIFO״̬(ĬΪ)

	BOOL DEVAPI FAR PASCAL PCI8996_GetDevStatusProAD(
												HANDLE hDevice,					// 豸
												PPCI8996_STATUS_AD pADStatus);	// AD״̬
	///////////////////////////////////////////////////////////////////////
	BOOL DEVAPI FAR PASCAL PCI8996_ReadDeviceProAD_Half(						// FIFOAD
												HANDLE hDevice,					// 豸
												PULONG pADBuffer,				// ڽݵû(뿪65536ֵĿռ)
												ULONG nReadSizeWords,
												PLONG nRetSizeWords);
								
    BOOL DEVAPI FAR PASCAL PCI8996_StopDeviceProAD(								// 豸֮ͣ豸
												HANDLE hDevice);				// 豸

	BOOL DEVAPI FAR PASCAL PCI8996_ReleaseDeviceProAD(							// رAD豸,ֹ,ͷԴ
												HANDLE hDevice);				// 豸

	//##################### ADݶȡ(DMAʽ)(ϲû) ###########################
	// ADֱڴ(DMA)ʽ
	BOOL DEVAPI FAR PASCAL PCI8996_InitDeviceDmaAD(								// ʼ豸TRUE,豸׼.
												HANDLE hDevice,					// 豸,CreateDevice
												HANDLE hDmaEvent,				// DMA¼,CreateSystemEvent
												ULONG ADBuffer[],				// û,Ϊά
												LONG nReadSizeWords,			// ÿDMAʱ,ûָӦȡʵʳ(ҪСڻnSegmentSizeWords)
												LONG nSegmentCount,				// ֶε,ȡֵΧΪ2-128
												LONG nSegmentSizeWords,			// ֶεĶγ(FIFO)
												PPCI8996_PARA_AD pADPara);		// Ӳ, ڴ˺оӲ״̬

    BOOL DEVAPI FAR PASCAL PCI8996_StartDeviceDmaAD(							// ڳʼ֮豸
												HANDLE hDevice);				// 豸,CreateDevice

	BOOL DEVAPI FAR PASCAL PCI8996_GetDevStatusDmaAD(							// ADȡDMAй״̬,ֵʾǷɹ
												HANDLE hDevice,					// 豸,CreateDevice
												PPCI8996_STATUS_DMA pDMAStatus);// õDMA״̬

	BOOL DEVAPI FAR PASCAL PCI8996_SetDevStatusDmaAD(							// ADDMAй״̬,ֵʾǷɹ
												HANDLE hDevice,					// 豸,CreateDevice
												LONG iClrBufferID);				// ҪĻID,Ϊ0

	BOOL DEVAPI FAR PASCAL PCI8996_StopDeviceDmaAD(								// 豸֮ͣ豸
												HANDLE hDevice);				// 豸,CreateDevice

	BOOL DEVAPI FAR PASCAL PCI8996_ReleaseDeviceDmaAD(							// رAD豸,ֹ,ͷԴ
												HANDLE hDevice);				// 豸,CreateDevice

	//################# ADӲ ########################
	BOOL DEVAPI FAR PASCAL PCI8996_SaveParaAD(HANDLE hDevice, PPCI8996_PARA_AD pADPara);  
	BOOL DEVAPI FAR PASCAL PCI8996_LoadParaAD(HANDLE hDevice, PPCI8996_PARA_AD pADPara);
	BOOL DEVAPI FAR PASCAL PCI8996_ResetParaAD(HANDLE hDevice, PPCI8996_PARA_AD pADPara);
	
	//################# ڴӳĴֱӲд ########################
	// ûԱ豸ֱӡ⡢Ͳ㡢ӵĿơ
	// ƶҪĿ̺ͿЧʱûʹЩӿʵ֡
	BOOL DEVAPI FAR PASCAL PCI8996_GetDeviceBar(								// ȡָָ豸ĴBARַ
												HANDLE hDevice,					// 豸,CreateDevice
												PUCHAR pbPCIBar[6]);			// PCI BARеַ,PCI BARжٿõַ뿴Ӳ˵
	BOOL DEVAPI FAR PASCAL PCI8996_GetDevVersion(								// ȡ豸̼汾
												HANDLE hDevice,					// 豸,CreateDevice
												PULONG pulFmwVersion,			// ̼汾
												PULONG pulDriverVersion);		// 汾
	BOOL DEVAPI FAR PASCAL PCI8996_WriteRegisterByte(							// 豸ӳĴռָ˿д뵥
												HANDLE hDevice,					// 豸
												PUCHAR pbLinearAddr,			// ָӳĴԻַ
												ULONG OffsetBytes,				// ڻַƫλ
												BYTE Value);					// ַָд뵥ֽݣַԻַƫλþ
	BOOL DEVAPI FAR PASCAL PCI8996_WriteRegisterWord(							// д˫ֽݣͬϣ
												HANDLE hDevice, 
												PUCHAR pbLinearAddr,			// ָӳĴԻַ
												ULONG OffsetBytes,  
												WORD Value);
	BOOL DEVAPI FAR PASCAL PCI8996_WriteRegisterULong(							// дĽݣͬϣ
												HANDLE hDevice, 
												PUCHAR pbLinearAddr,			// ָӳĴԻַ
												ULONG OffsetBytes,  
												ULONG Value);
	BYTE DEVAPI FAR PASCAL PCI8996_ReadRegisterByte(							// 뵥ֽݣͬϣ
												HANDLE hDevice, 
												PUCHAR pbLinearAddr,			// ָӳĴԻַ
												ULONG OffsetBytes);
	WORD DEVAPI FAR PASCAL PCI8996_ReadRegisterWord(							// ˫ֽݣͬϣ
												HANDLE hDevice, 
												PUCHAR pbLinearAddr,			// ָӳĴԻַ
												ULONG OffsetBytes);
	ULONG DEVAPI FAR PASCAL PCI8996_ReadRegisterULong(							// ֽݣͬϣ
												HANDLE hDevice, 
												PUCHAR pbLinearAddr,			// ָӳĴԻַ
												ULONG OffsetBytes);

	//################# I/O˿ֱӲд ########################
	// ûԱ豸ֱӡ⡢Ͳ㡢ӵĿơ
	// ƶҪĿ̺ͿЧʱûʹЩӿʵ֡
	// ЩҪڴͳ豸ISAߡڡڵ豸ڱPCI豸
    BOOL DEVAPI FAR PASCAL PCI8996_WritePortByte(HANDLE hDevice, PUCHAR pbPort, ULONG offserBytes, BYTE Value);
    BOOL DEVAPI FAR PASCAL PCI8996_WritePortWord(HANDLE hDevice, PUCHAR pbPort, ULONG offserBytes, WORD Value);
    BOOL DEVAPI FAR PASCAL PCI8996_WritePortULong(HANDLE hDevice, PUCHAR pbPort, ULONG offserBytes, ULONG Value);

    BYTE DEVAPI FAR PASCAL PCI8996_ReadPortByte(HANDLE hDevice, PUCHAR pbPort, ULONG offserBytes);
    WORD DEVAPI FAR PASCAL PCI8996_ReadPortWord(HANDLE hDevice, PUCHAR pbPort, ULONG offserBytes);
    ULONG DEVAPI FAR PASCAL PCI8996_ReadPortULong(HANDLE hDevice, PUCHAR pbPort, ULONG offserBytes);
	//########################### Ӳ ######################################
	HANDLE DEVAPI FAR PASCAL PCI8996_CreateSystemEvent(void);			// ں¼󣬹InitDeviceIntVB̵߳Ⱥʹ
	BOOL DEVAPI FAR PASCAL PCI8996_ReleaseSystemEvent(HANDLE hEvent);	// ͷں¼

#ifdef __cplusplus
}
#endif

// Զ
#ifndef _PCI8996_DRIVER_
	#ifndef _WIN64
		#pragma comment(lib, "PCI8996_32.lib")
		#pragma message("======== Welcome to use our art company's products!")
		#pragma message("======== Automatically linking with PCI8996_32.dll...")
		#pragma message("======== Successfully linked with PCI8996_32.dll")
	#else
		#pragma comment(lib, "PCI8996_64.lib")
		#pragma message("======== Welcome to use our art company's products!")
		#pragma message("======== Automatically linking with PCI8996_64.dll...")
		#pragma message("======== Successfully linked with PCI8996_64.dll")
	#endif
	
#endif

#endif // _PCI8996_DEVICE_
