#ifndef _PCI8018_DEVICE_
#define _PCI8018_DEVICE_
//#################### ADӲPCI8018_PARA_AD #####################
// ADʵӲ
typedef struct _PCI8018_PARA_AD     
{
	LONG bChannelArray[16]; // ͨѡУֱ16ͨ=TRUEʾͨ򲻲
	LONG Gains[16];			// ƣֱ16ͨ
	LONG Frequency;         // ɼƵ, λΪHz, [3, 80000]
	LONG TriggerMode;		// ģʽѡ
	LONG TriggerSource;		// Դѡ
	LONG TriggerType;		// ѡ(ش/崥)
	LONG TriggerDir;		// ѡ(/򴥷)
	LONG TrigLevelVolt;		// ƽ(0--10000mV)
	LONG TrigWindow;		// [1, 65535], λ50
	LONG ClockSource;		// ʱԴѡ(/ʱԴ)
	LONG bClockOutput;      // ʱCLKOUT,=TRUE:ʱ, =FALSE:ֹʱ
} PCI8018_PARA_AD, *PPCI8018_PARA_AD;

//***********************************************************
// ADӲPCI8018_PARA_ADеGains[x]ģ뷶Χʹõѡ
const long PCI8018_GAINS_1MULT			= 0x00; // 1
const long PCI8018_GAINS_2MULT			= 0x01; // 2
const long PCI8018_GAINS_4MULT			= 0x02; // 4
const long PCI8018_GAINS_8MULT			= 0x03; // 8

//***********************************************************
// ADӲPCI8018_PARA_ADеTriggerModeԱʹôģʽѡ
const long PCI8018_TRIGMODE_SOFT		= 0x00; // ڴ
const long PCI8018_TRIGMODE_POST		= 0x01; // Ӳ󴥷

//***********************************************************
// ADӲPCI8018_PARA_ADеTriggerSourceԴźʹõѡ
const long PCI8018_TRIGSRC_ATR			= 0x00; // ѡⲿATRԴ
const long PCI8018_TRIGSRC_DTR			= 0x01; // ѡⲿDTRԴ

// ADӲPCI8018_PARA_ADеTriggerTypeʹõѡ
const long PCI8018_TRIGTYPE_EDGE		= 0x00; // ش
const long PCI8018_TRIGTYPE_PULSE		= 0x01; // 崥(ƽ)

//***********************************************************
// ADӲPCI8018_PARA_ADеTriggerDirʹõѡ
const long PCI8018_TRIGDIR_NEGATIVE		= 0x00; // 򴥷(/½ش)
const long PCI8018_TRIGDIR_POSITIVE		= 0x01; // 򴥷(/ش)
const long PCI8018_TRIGDIR_POSIT_NEGAT	= 0x02; // 򴥷(//½ش)

//***********************************************************
// ADӲPCI8018_PARA_ADеClockSourceʱԴʹõѡ
const long PCI8018_CLOCKSRC_IN			= 0x00; // ڲʱ
const long PCI8018_CLOCKSRC_OUT			= 0x01; // ⲿʱ

//*************************************************************************************
// ADʵӲ
typedef struct _PCI8018_STATUS_AD     
{
	LONG bNotEmpty;			// FIFO洢ķǿձ־=TRUEǿգ = FALSE 
	LONG bHalf;				// FIFO洢İ־=TRUEϣ = FALSE 
	LONG bOverflow;			// FIFO洢־= TRUEѷ = FALSEδ
	LONG nRemainCount;      // ADʣ
} PCI8018_STATUS_AD, *PPCI8018_STATUS_AD;

const int MAX_SEGMENT_COUNT = 64;
typedef struct _PCI8018_STATUS_DMA     
{
	LONG iCurSegmentID;								// ǰλID,ʾDMAڴĻ
	LONG bSegmentSts[MAX_SEGMENT_COUNT];			// ¾״̬,=1ʾӦΪ,Ϊ
	LONG bBufferOverflow;							// ״̬
} PCI8018_STATUS_DMA, *PPCI8018_STATUS_DMA;

//***********************************************************
// ûӿ
#ifndef _PCI8018_DRIVER_
#define DEVAPI __declspec(dllimport)
#else
#define DEVAPI __declspec(dllexport)
#endif

#ifdef __cplusplus
extern "C" {
#endif
	//######################## ͨú #################################
	// ڱ豸
	HANDLE DEVAPI FAR PASCAL PCI8018_CreateDevice(int DeviceID = 0);  // 豸
	HANDLE DEVAPI FAR PASCAL PCI8018_CreateDeviceEx(int DevicePhysID = 0);  // Ŵ豸
	int DEVAPI FAR PASCAL PCI8018_GetDeviceCount(HANDLE hDevice);	  // ȡ豸̨
	BOOL DEVAPI FAR PASCAL PCI8018_GetDeviceCurrentID(HANDLE hDevice, PLONG DeviceLgcID, PLONG DevicePhysID);
	BOOL DEVAPI FAR PASCAL PCI8018_ListDeviceDlg(HANDLE hDevice); // бϵͳееĸPCI豸
    BOOL DEVAPI FAR PASCAL PCI8018_ReleaseDevice(HANDLE hDevice); // ر豸,ֹ,ͷԴ

	//####################### ADݶȡ #################################
	// ڴͨûЩӿ򵥡ݡɿû֪豸
	// Ͳ㸴ӵӲЭͷƱ̣ĳʼ豸Ͷȡ
	// ADɸЧʵָ١ݲɼ

	// ADѯʽ
	BOOL DEVAPI FAR PASCAL PCI8018_InitDeviceProAD(			// ʼ豸TRUE,豸׼.
										HANDLE hDevice,			// 豸,CreateDevice
										PPCI8018_PARA_AD pADPara); // Ӳ, ڴ˺оӲ״̬

	BOOL DEVAPI FAR PASCAL PCI8018_StartDeviceProAD(			// ڳʼ֮豸
										HANDLE hDevice);		// 豸,CreateDevice

	BOOL DEVAPI FAR PASCAL PCI8018_ReadDeviceProAD_Npt(		// AD־Чʱô˺ȡ豸ϵAD(ǿշʽ)
										HANDLE hDevice,			// 豸,CreateDevice
										LONG ADBuffer[],		// ԭʼADݵû
										LONG nReadSizeWords,	// ƫƵݳ()
										PLONG nRetSizeWords);   // ʵʶȡĳ()

	BOOL DEVAPI FAR PASCAL PCI8018_GetDevStatusProAD(			// ADȡ豸ĸ״̬,ֵʾǷɹ
										HANDLE hDevice,			// 豸,CreateDevice
										PPCI8018_STATUS_AD pADStatus); // ADĸϢṹ

	BOOL DEVAPI FAR PASCAL PCI8018_ReadDeviceProAD_Half(		// AD־Чʱô˺ȡ豸ϵAD(ʽ)
										HANDLE hDevice,			// 豸,CreateDevice
										LONG ADBuffer[],		// ԭʼADݵû
										LONG nReadSizeWords,	// ƫλݳ()
										PLONG nRetSizeWords);	// ʵʶȡĳ()
		
    BOOL DEVAPI FAR PASCAL PCI8018_StopDeviceProAD(				// 豸֮ͣ豸
										HANDLE hDevice);		// 豸,CreateDevice

	BOOL DEVAPI FAR PASCAL PCI8018_ReleaseDeviceProAD(			// رAD豸,ֹ,ͷԴ
										HANDLE hDevice);		// 豸,CreateDevice

	//##################### ADݶȡ(жϷʽ)(ϲû) ###########################
	BOOL DEVAPI FAR PASCAL PCI8018_InitDeviceIntAD(				// ʼ豸TRUE,豸׼.
										HANDLE hDevice,			// 豸,CreateDevice
										HANDLE hEvent,			// ж¼,CreateSystemEvent
										ULONG nFifoHalfLength,	// ƫλݳ(СFIFO)
										PPCI8018_PARA_AD pPara);// Ӳ, ڴ˺оӲ״̬
    BOOL DEVAPI FAR PASCAL PCI8018_StartDeviceIntAD(			// ڳʼ֮豸
										HANDLE hDevice);		// 豸
	BOOL DEVAPI FAR PASCAL PCI8018_ReadDeviceIntAD(HANDLE hDevice,// 豸
										PLONG pADBuffer,		// ڽԭʼADݵû								
										LONG nReadSizeWords,	// ݳ()
										PLONG nRetSizeWords);	// شʵʳ()  
	
    BOOL DEVAPI FAR PASCAL PCI8018_StopDeviceIntAD(				// ڿʼADɼֹͣ豸
										HANDLE hDevice);		// 豸
	BOOL DEVAPI FAR PASCAL PCI8018_ReleaseDeviceIntAD(HANDLE hDevice);

	//##################### ADݶȡ(DMAʽ)(ϲû) ###########################
	// ADֱڴ(DMA)ʽ
	BOOL DEVAPI FAR PASCAL PCI8018_InitDeviceDmaAD(				// ʼ豸TRUE,豸׼.
										HANDLE hDevice,			// 豸,CreateDevice
										HANDLE hDmaEvent,		// DMA¼,CreateSystemEvent
										LONG ADBuffer[],		// û,Ϊά
										LONG nReadSizeWords,	// ÿDMAʱ,ûָӦȡʵʳ(ҪСڻnSegmentSizeWords)
										LONG nSegmentCount,		// ֶε,ȡֵΧΪ2-128
										LONG nSegmentSizeWords,	// ֶεĶγ(FIFO)
										PPCI8018_PARA_AD pADPara);// Ӳ, ڴ˺оӲ״̬

    BOOL DEVAPI FAR PASCAL PCI8018_StartDeviceDmaAD(			// ڳʼ֮豸
										HANDLE hDevice);		// 豸,CreateDevice

	BOOL DEVAPI FAR PASCAL PCI8018_GetDevStatusDmaAD(			// ADȡDMAй״̬,ֵʾǷɹ
										HANDLE hDevice,			// 豸,CreateDevice
										PPCI8018_STATUS_DMA pDMAStatus); // õDMA״̬

	BOOL DEVAPI FAR PASCAL PCI8018_SetDevStatusDmaAD(			// ADDMAй״̬,ֵʾǷɹ
										HANDLE hDevice,			// 豸,CreateDevice
										LONG iClrBufferID);		// ҪĻID,Ϊ0
		
    BOOL DEVAPI FAR PASCAL PCI8018_StopDeviceDmaAD(				// 豸֮ͣ豸
										HANDLE hDevice);		// 豸,CreateDevice

	BOOL DEVAPI FAR PASCAL PCI8018_ReleaseDeviceDmaAD(			// رAD豸,ֹ,ͷԴ
										HANDLE hDevice);		// 豸,CreateDevice
	
	//##################### ADӲ ###########################
	BOOL DEVAPI FAR PASCAL PCI8018_SaveParaAD(HANDLE hDevice, PPCI8018_PARA_AD pADPara); // ǰADϵͳ
    BOOL DEVAPI FAR PASCAL PCI8018_LoadParaAD(HANDLE hDevice, PPCI8018_PARA_AD pADPara); // ADϵͳж
    BOOL DEVAPI FAR PASCAL PCI8018_ResetParaAD(HANDLE hDevice, PPCI8018_PARA_AD pADPara); // ADָĬֵ

	//################# ڴӳĴֱӲд ########################
	// ûԱ豸ֱӡ⡢Ͳ㡢ӵĿơ
	// ƶҪĿ̺ͿЧʱûʹЩӿʵ֡
	BOOL DEVAPI FAR PASCAL PCI8018_GetDeviceBar(				// ȡָָ豸ĴBARַ
										HANDLE hDevice,			// 豸,CreateDevice
										__int64 pbPCIBar[6]);	// PCI BARеַ,PCI BARжٿõַ뿴Ӳ˵
	BOOL DEVAPI FAR PASCAL PCI8018_GetDevVersion(				// ȡ豸̼汾
										HANDLE hDevice,			// 豸,CreateDevice
										PULONG pulFmwVersion,	// ̼汾
										PULONG pulDriverVersion);// 汾
	BOOL DEVAPI FAR PASCAL PCI8018_WriteRegisterByte(			// ָĴռλд뵥
										HANDLE hDevice,			// 豸,CreateDevice
										__int64 pbLinearAddr,	// ָĴԻַ,GetDeviceAddrеpbLinearAddrֵ
										ULONG OffsetBytes,		// Իַַƫλ(ֽ)
										BYTE Value);			// ַָд뵥ֽݣַԻַƫλþ

	BOOL DEVAPI FAR PASCAL PCI8018_WriteRegisterWord(			// д˫ֽݣͬϣ
										HANDLE hDevice, 
										__int64 pbLinearAddr, 
										ULONG OffsetBytes,  
										WORD Value);

	BOOL DEVAPI FAR PASCAL PCI8018_WriteRegisterULong(			// дĽݣͬϣ
										HANDLE hDevice, 
										__int64 pbLinearAddr, 
										ULONG OffsetBytes,  
										ULONG Value);

	BYTE DEVAPI FAR PASCAL PCI8018_ReadRegisterByte(			// 뵥ֽݣͬϣ
										HANDLE hDevice, 
										__int64 pbLinearAddr, 
										ULONG OffsetBytes);

	WORD DEVAPI FAR PASCAL PCI8018_ReadRegisterWord(			// ˫ֽݣͬϣ
										HANDLE hDevice, 
										__int64 pbLinearAddr, 
										ULONG OffsetBytes);

	ULONG DEVAPI FAR PASCAL PCI8018_ReadRegisterULong(			// ֽݣͬϣ
										HANDLE hDevice, 
										__int64 pbLinearAddr, 
										ULONG OffsetBytes);

	//################# I/O˿ֱӲд ########################
	// ûԱ豸ֱӡ⡢Ͳ㡢ӵĿơ
	// ƶҪĿ̺ͿЧʱûʹЩӿʵ֡
	// ЩҪڴͳ豸ISAߡڡڵ豸ڱPCI豸
    BOOL DEVAPI FAR PASCAL PCI8018_WritePortByte(				// 8λд˿
										HANDLE hDevice,			// 豸(CreateDevice)
										__int64 pPort,				// ˿ڵַ
										BYTE Value);			// д8λ

    BOOL DEVAPI FAR PASCAL PCI8018_WritePortWord(HANDLE hDevice, __int64 pPort, WORD Value);
    BOOL DEVAPI FAR PASCAL PCI8018_WritePortULong(HANDLE hDevice, __int64 pPort, ULONG Value);

    BYTE DEVAPI FAR PASCAL PCI8018_ReadPortByte(HANDLE hDevice, __int64 pPort);
    WORD DEVAPI FAR PASCAL PCI8018_ReadPortWord(HANDLE hDevice, __int64 pPort);
    ULONG DEVAPI FAR PASCAL PCI8018_ReadPortULong(HANDLE hDevice, __int64 pPort);
	// Ҫûģʽ£ֱӷӲ˿ڣ밲װʹISA\CommUserµReadPortByteExȺ

	//########################### Ӳ ######################################
	HANDLE DEVAPI FAR PASCAL PCI8018_CreateSystemEvent(void); // ں¼󣬹InitDeviceDmaADVB̵߳Ⱥʹ
	BOOL DEVAPI FAR PASCAL PCI8018_ReleaseSystemEvent(HANDLE hEvent); // ͷں¼

#ifdef __cplusplus
}
#endif

//***********************************************************
// FIFO洢ĳ()
const long FIFO_IDT7202_LENGTH			= 1024;
const long FIFO_IDT7203_LENGTH			= 2048;
const long FIFO_IDT7204_LENGTH			= 4096;
const long FIFO_IDT7205_LENGTH			= 8192;
const long FIFO_IDT7206_LENGTH			= 16384;
const long FIFO_IDT7207_LENGTH			= 32768;

// Զ
#ifndef _PCI8018_DRIVER_
	#ifndef _WIN64
		#pragma comment(lib, "PCI8018_32.lib")
		#pragma message("======== Welcome to use our art company's products!")
		#pragma message("======== Automatically linking with PCI8018_32.dll...")
		#pragma message("======== Successfully linked with PCI8018_32.dll")
	#else
		#pragma comment(lib, "PCI8018_64.lib")
		#pragma message("======== Welcome to use our art company's products!")
		#pragma message("======== Automatically linking with PCI8018_64.dll...")
		#pragma message("======== Successfully linked with PCI8018_64.dll")
	#endif
#endif

#endif // _PCI8018_DEVICE_