unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls,MMSystem, MPlayer, ComCtrls, ExtCtrls, Menus, RXSlider,
  RzTrkBar, shellapi;
const
  ModeStr: array[TMPModes] of string = ('Not ready', 'Stopped', 'Playing', 'Recording', 'Seeking', 'Paused', 'Open');

type
twavheader = record //һwavļͷʽ 
rid : longint; 
rlen : longint; 
wid : longint; 
fid : longint; 
flen : longint; 
wformattag : word; 
nchannels : word; 
nsamplespersec : longint; 
navgbytespersec : longint; 
nblockalign : word; 
wbitspersample : word; 
did : longint; 
wsamplelength : longint; 
end;

type
  TF_recorder = class(TForm)
    MediaPlayer1: TMediaPlayer;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Timer1: TTimer;
    btnew: TButton;
    btstart: TButton;
    btstop: TButton;
    btsave: TButton;
    btSaveAs: TButton;
    Label2: TLabel;
    Label1: TLabel;
    Button1: TButton;
    RxSlider1: TRzTrackBar;
    Button2: TButton;
    CheckBox1: TCheckBox;
    Label3: TLabel;
    Label4: TLabel;
    Button3: TButton;
    procedure btstartClick(Sender: TObject);
    procedure btstopClick(Sender: TObject);
    procedure createwav( channels : word; resolution : word; rate : longint;fn : string );
    procedure btsaveClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure MediaPlayer1Click(Sender: TObject; Button: TMPBtnType;
      var DoDefault: Boolean);
    procedure btnewClick(Sender: TObject);
    procedure btSaveAsClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure RxSlider1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  F_recorder: TF_recorder;

implementation

uses Unit2, U_mp3set;

{$R *.dfm}

function WinExecAndWait32(FileName:String; Visibility : integer): DWORD;
var
zAppName:array[0..512] of char;
zCurDir:array[0..255] of char;
WorkDir:String;
StartupInfo:TStartupInfo;
ProcessInfo:TProcessInformation;
begin
StrPCopy(zAppName,FileName);
GetDir(0,WorkDir);
StrPCopy(zCurDir,WorkDir);
FillChar(StartupInfo,Sizeof(StartupInfo),#0);
StartupInfo.cb := Sizeof(StartupInfo);
StartupInfo.dwFlags := STARTF_USESHOWWINDOW;
StartupInfo.wShowWindow := Visibility;
if not CreateProcess(
nil,
zAppName, { pointer to command line string }
nil, { pointer to process security attributes }
nil, { pointer to thread security attributes }
false, { handle inheritance flag }
CREATE_NEW_CONSOLE or { creation flags }
NORMAL_PRIORITY_CLASS,
nil, { pointer to new environment block }
nil, { pointer to current directory name }
StartupInfo, { pointer to STARTUPINFO }
ProcessInfo { pointer to PROCESS_INF }
)
then Result := $FFFFFFFF else begin
WaitforSingleObject(ProcessInfo.hProcess,INFINITE);
GetExitCodeProcess(ProcessInfo.hProcess,Result);
end;
end;


procedure tF_recorder.createwav( channels : word; { 1()2() }
resolution : word; { 816,8λ16λ }
rate : longint; { Ƶ,11025,22050, 44100}
fn : string { Ӧļ } );
var
wf : file of twavheader;
wh : twavheader;
begin
wh.rid := $46464952; 
wh.rlen := 36; 
wh.wid := $45564157; 
wh.fid := $20746d66; 
wh.flen := 16; 
wh.wformattag := 1; 
wh.nchannels := channels; 
wh.nsamplespersec := rate; 
wh.navgbytespersec := channels*rate*(resolution div 8);
wh.nblockalign := channels*(resolution div 8);
wh.wbitspersample := resolution;
wh.did := $61746164; 
wh.wsamplelength := 0; 

assignfile(wf,fn); {򿪶Ӧļ } 
rewrite(wf); {ƶָ뵽ļͷ} 
write(wf,wh); {дļͷ } 
closefile(wf); {رļ } 
end;


procedure TF_recorder.btstartClick(Sender: TObject);
var
newfile:widestring;
Bitrate,track,frequency:integer;
begin
if directoryexists(F_wavset.Edit1.Text) then
begin
if copy(F_wavset.Edit1.Text,length(F_wavset.Edit1.Text),1)<>'/' then
  F_wavset.Edit1.Text:=F_wavset.Edit1.Text+'/'
end
else
  F_wavset.Edit1.Text:=ExtractFilePath(application.ExeName);
SaveDialog1.InitialDir := F_wavset.Edit1.Text;
if SaveDialog1.Execute then
try
//ڳǰĿ¼´һwavļtemp.wav
newfile:=SaveDialog1.FileName;
case F_wavset.BitRate.ItemIndex of
0: bitrate:=16;
1: bitrate:=8;
end;
case F_wavset.track.ItemIndex of
0: track:=2;
else track:=1;
end;
case F_wavset.frequency.ItemIndex of
0: frequency:=48000;
1: frequency:=44100;
2: frequency:=22050;
3: frequency:=11025;
end;
createwav(track, bitrate, frequency, newfile);
caption:=ExtractFileName(newFile);
mediaplayer1.devicetype := dtautoselect;
mediaplayer1.filename := newfile;
mediaplayer1.open;
mediaplayer1.Rewind ;
btstart.enabled:=false;
btstop.enabled:=true;
btsave.Enabled :=true;
btSaveAs.Enabled :=true;
except
btstart.enabled:=true;
btstop.enabled:=false;
btsave.Enabled :=false;
btSaveAs.Enabled :=false;
application.messagebox('ý豸ʼʧܣ','',mb_iconerror+mb_ok);
end;
end;

procedure TF_recorder.btstopClick(Sender: TObject);
begin
try
mediaplayer1.stop;
mediaplayer1.close;
btnew.enabled:=true;
btstart.enabled:=true;
btstop.enabled:=false;
btsave.Enabled :=false;
btSaveAs.Enabled :=false;
except
btnew.enabled:=true;
btstart.enabled:=true;
btstop.enabled:=false;
btsave.Enabled :=false;
btSaveAs.Enabled :=false;
end;
end;


procedure TF_recorder.btsaveClick(Sender: TObject);
begin
    try
    mediaplayer1.stop;
    mediaplayer1.save;
    application.messagebox('!','Ϣ',mb_iconinformation+mb_ok);
    except
     application.messagebox('ļ!','',mb_iconerror+mb_ok);
    end;
end;

procedure TF_recorder.Timer1Timer(Sender: TObject);
begin
  if mediaplayer1.DeviceID<>0 then
  begin
  if checkbox1.Checked then
  begin
   if (mediaplayer1.Position< label3.Tag) or (mediaplayer1.Position> label4.Tag)  then
   begin
     mediaplayer1.Position :=label3.Tag;
     mediaplayer1.Resume ;
   end;
  end;
  RxSlider1.Max:= mediaplayer1.Length ;
  label1.caption:=format(':%s%-0.2f',[#13,RxSlider1.Max/1000]);
  RxSlider1.Position :=  mediaplayer1.Position;
  label2.Caption:=format('λ:%s%-0.2f',[#13,RxSlider1.Position / 1000]);
  if  mediaplayer1.Position=mediaplayer1.Length then
  begin
   if mediaplayer1.Mode =mpRecording  then
    begin
    mediaplayer1.Position:=mediaplayer1.Length-1000;
    mediaplayer1.Update ;
    MediaPlayer1.startrecording;
    end;
  end;
  end;
end;

procedure TF_recorder.MediaPlayer1Click(Sender: TObject; Button: TMPBtnType;
  var DoDefault: Boolean);
begin
if Button = btRecord then
  MediaPlayer1.startrecording;
end;

procedure TF_recorder.btnewClick(Sender: TObject);
var
newfile:widestring;
begin
try
//ڳǰĿ¼´һwavļtemp.wav
if opendialog1.Execute then
begin
  newfile:=opendialog1.FileName;
end
else
exit;
mediaplayer1.devicetype := dtautoselect;
mediaplayer1.filename := newfile;
mediaplayer1.open;
caption:=ExtractFileName(newFile);
btnew.enabled:=false;
btstop.enabled:=true;
btsave.Enabled :=true;
btSaveAs.Enabled :=true;
except
btnew.enabled:=true;
btstop.enabled:=false;
btsave.Enabled :=false;
btSaveAs.Enabled :=false;
application.messagebox('ý豸ʼʧܣ','',mb_iconerror+mb_ok);
end;
end;

procedure TF_recorder.btSaveAsClick(Sender: TObject);
var
newfile:string;
cmd:string;
begin
  SaveDialog1.Filter :='*.wav|*.wav|*.*|*|*.mp3|*.mp3';
  SaveDialog1.FilterIndex :=3;
  if SaveDialog1.Execute then
  begin
    try
    mediaplayer1.stop;
    if fileexists(mediaplayer1.filename)=false then
    mediaplayer1.save;
    if SaveDialog1.FilterIndex =3 then
    begin
      if ExtractFileExt(SaveDialog1.FileName)<>'mp3' then
      begin
        ChangeFileExt(savedialog1.FileName,'mp3');
      end;
      newfile:=savedialog1.FileName ;
      F_mp3set:=TF_mp3set.Create(nil);
      try
      if GetVersion()<$80000000 then
      begin
      cmd:='cmd /c lame.dll';
      end
      else
      cmd:='command /c lame.dll';
      if F_mp3set.ShowModal =mrok then
      begin
        case F_mp3set.track.ItemIndex of
        0:cmd:=cmd+' -m s';
        1:cmd:=cmd+' -m j';
        2:cmd:=cmd+' -m f';
        3:cmd:=cmd+' -m m';
        4:cmd:=cmd+' -m a';
        end;
        case F_mp3set.frequency.ItemIndex of
        0:cmd:=cmd+' --resample 48';
        1:cmd:=cmd+' --resample 44.1';
        2:cmd:=cmd+' --resample 22.05';
        3:cmd:=cmd+' --resample 11.025';
        end;
        cmd:=format('%s --cbr -b %s',[cmd,F_mp3set.bitrate.Text]);
        cmd:=format('%s -q %s',[cmd,F_mp3set.Noise.Text]);
        case F_mp3set.Compression.ItemIndex of
        0:cmd:=format('%s --comp %d',[cmd,3]);
        1:cmd:=format('%s --comp %d',[cmd,4]);
        2:cmd:=format('%s --comp %d',[cmd,7]);
        3:cmd:=format('%s --comp %d',[cmd,9]);
        4:cmd:=format('%s --comp %d',[cmd,11]);
        5:cmd:=format('%s --comp %d',[cmd,13]);
        6:cmd:=format('%s --comp %d',[cmd,15]);
        7:cmd:=format('%s --comp %d',[cmd,18]);
        8:cmd:=format('%s --comp %d',[cmd,22]);
        9:cmd:=format('%s --comp %d',[cmd,27]);
        end;
        cmd:=format('%s --tt %s',[cmd,F_mp3set.title.Text]);
        cmd:=format('%s --ta %s',[cmd,F_mp3set.artist.Text]);
        cmd:=format('%s --tl %s',[cmd,F_mp3set.album.Text]);
        cmd:=format('%s --ty %s',[cmd,F_mp3set.year.Text]);
        cmd:=format('%s --tc %s',[cmd,F_mp3set.comment.Text]);
        cmd:=format('%s --tn %s',[cmd,F_mp3set.E_track.Text]);
        if F_mp3set.Id2.Checked then
        cmd:=format('%s --add-id3v2',[cmd]);
      end;
      cmd:=cmd + ' "'+mediaplayer1.FileName+'" "'+newfile+'"';
      SetCurrentDirectory(pchar(ExtractFilePath(application.ExeName)));
      finally
        F_mp3set.Free ;
      end;
      if WinExecAndWait32(cmd,SW_SHOW)<>0 then
      begin
        messagebox(handle,'Mp3','',MB_ICONINFORMATION);
      end;
      exit;
    end;
    newfile:=savedialog1.FileName ;
    copyfile(pchar(mediaplayer1.FileName),pchar(newfile),false);
    application.messagebox('!','Ϣ',mb_iconinformation+mb_ok);
    except
     application.messagebox('ļ!','',mb_iconerror+mb_ok);
     btstart.enabled:=true;
     btstop.enabled:=false;
    end;
  end;
  SaveDialog1.Filter :='*.wav|*.wav|*.*|*';
end;

procedure TF_recorder.Button1Click(Sender: TObject);
begin
  F_wavset.ShowModal ;
end;

procedure TF_recorder.RxSlider1MouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if mediaplayer1.DeviceID<>0 then
  begin
   MediaPlayer1.Pause ;
   MediaPlayer1.Position := RxSlider1.Position ;
   MediaPlayer1.Resume ;
  end;
end;

procedure TF_recorder.Button2Click(Sender: TObject);
var
Filter:string;
begin
      Filter:=OpenDialog1.Filter;
      try
       OpenDialog1.Filter:='Mp3 File(*.mp3)|*.mp3';
       OpenDialog1.InitialDir :=SaveDialog1.InitialDir ;
       if OpenDialog1.Execute then
       shellexecute(0,'Open',pchar(OpenDialog1.FileName),'','',SW_SHOW);
      finally
        OpenDialog1.Filter:=Filter;
      end;
end;

procedure TF_recorder.Button3Click(Sender: TObject);
begin
if (Sender as Tbutton).Caption ='Start' then
begin
  label3.Tag:= RxSlider1.Position ;
  label3.caption:=format('ʼ:%s%-0.2f',[#13,RxSlider1.Position/1000]);
  (Sender as Tbutton).Caption:='end';
end
else
begin
  label4.Tag:= RxSlider1.Position ;
  label4.caption:=format(':%s%-0.2f',[#13,RxSlider1.Position/1000]);
  (Sender as Tbutton).Caption :='Start';
end;
end;

procedure TF_recorder.CheckBox1Click(Sender: TObject);
begin
 Button3.Enabled := not (sender as tCheckBox).Checked ;
end;

end.
