/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import sun.security.provider.SystemIdentity;
import sun.security.x509.X509Cert;
import sun.tools.jar.Manifest;

public class JarVerifierStream
extends ZipInputStream {
    private JarEntry current;
    private Hashtable verified = new Hashtable();
    private JarInputStream jis;
    private Manifest man = null;
    private ArrayList certCache = null;

    public int read() throws IOException {
        int n2 = this.jis.read();
        if (n2 == -1) {
            this.addIds();
        }
        return n2;
    }

    private void addIds() {
        Vector vector;
        Certificate[] certificateArray;
        if (this.current != null && (certificateArray = this.current.getCertificates()) != null && (vector = this.getIds(certificateArray)) != null) {
            this.verified.put(this.current.getName(), vector);
        }
    }

    public void close() throws IOException {
        this.jis.close();
    }

    public void closeEntry() throws IOException {
        this.jis.closeEntry();
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.jis.read(byArray, n2, n3);
        if (n4 == -1) {
            this.addIds();
        }
        return n4;
    }

    public JarVerifierStream(InputStream inputStream) throws IOException {
        super(inputStream);
        this.jis = new JarInputStream(inputStream);
    }

    public Enumeration getBlocks() {
        if (this.verified.isEmpty()) {
            return null;
        }
        return new Enumeration(){

            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() {
                return null;
            }
        };
    }

    public Hashtable getNameToHash() {
        return null;
    }

    public Hashtable getVerifiedSignatures() {
        if (this.verified.isEmpty()) {
            return null;
        }
        return this.verified;
    }

    public synchronized ZipEntry getNextEntry() throws IOException {
        this.current = (JarEntry)this.jis.getNextEntry();
        return this.current;
    }

    public Manifest getManifest() {
        if (this.man == null) {
            try {
                java.util.jar.Manifest manifest = this.jis.getManifest();
                if (manifest == null) {
                    return null;
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                manifest.write(byteArrayOutputStream);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                this.man = new Manifest(byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.man;
    }

    protected Vector getIds(Certificate[] certificateArray) {
        CertCache certCache;
        int n2;
        if (certificateArray == null) {
            return null;
        }
        if (this.certCache == null) {
            this.certCache = new ArrayList();
        }
        for (n2 = 0; n2 < this.certCache.size(); ++n2) {
            certCache = (CertCache)this.certCache.get(n2);
            if (!certCache.equals(certificateArray)) continue;
            return certCache.ids;
        }
        certCache = new CertCache();
        certCache.certs = certificateArray;
        if (certificateArray.length > 0) {
            for (n2 = 0; n2 < certificateArray.length; ++n2) {
                try {
                    X509Certificate x509Certificate = (X509Certificate)certificateArray[n2];
                    Principal principal = x509Certificate.getSubjectDN();
                    final SystemIdentity systemIdentity = new SystemIdentity(principal.getName(), null);
                    byte[] byArray = x509Certificate.getEncoded();
                    final X509Cert x509Cert = new X509Cert(byArray);
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws KeyManagementException {
                                systemIdentity.addCertificate(x509Cert);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw (KeyManagementException)privilegedActionException.getException();
                    }
                    if (certCache.ids == null) {
                        certCache.ids = new Vector();
                    }
                    certCache.ids.addElement(systemIdentity);
                    continue;
                }
                catch (KeyManagementException keyManagementException) {
                    continue;
                }
                catch (IOException iOException) {
                    continue;
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    // empty catch block
                }
            }
        }
        this.certCache.add(certCache);
        return certCache.ids;
    }

    static class CertCache {
        Certificate[] certs;
        Vector ids;

        CertCache() {
        }

        boolean equals(Certificate[] certificateArray) {
            int n2;
            boolean bl2;
            int n3;
            if (this.certs == null) {
                return certificateArray == null;
            }
            if (certificateArray == null) {
                return false;
            }
            for (n3 = 0; n3 < certificateArray.length; ++n3) {
                bl2 = false;
                for (n2 = 0; n2 < this.certs.length; ++n2) {
                    if (!certificateArray[n3].equals(this.certs[n2])) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                return false;
            }
            for (n3 = 0; n3 < this.certs.length; ++n3) {
                bl2 = false;
                for (n2 = 0; n2 < certificateArray.length; ++n2) {
                    if (!this.certs[n3].equals(certificateArray[n2])) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                return false;
            }
            return true;
        }
    }
}

