/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DTMNodeList
implements NodeList {
    private DTMIterator dtm_iter;
    private boolean valid = true;
    private int m_firstChild;
    private DTM m_parentDTM;

    public int getLength() {
        if (this.dtm_iter != null) {
            return this.dtm_iter.getLength();
        }
        int n2 = 0;
        int n3 = this.m_firstChild;
        while (n3 != -1) {
            ++n2;
            n3 = this.m_parentDTM.getNextSibling(n3);
        }
        return n2;
    }

    public DTMNodeList(DTM dTM, int n2) {
        this.dtm_iter = null;
        this.m_parentDTM = dTM;
        this.m_firstChild = dTM.getFirstChild(n2);
    }

    DTMIterator getDTMIterator() {
        return this.dtm_iter;
    }

    public DTMNodeList(DTMIterator dTMIterator) {
        int n2 = dTMIterator.getCurrentPos();
        try {
            this.dtm_iter = dTMIterator.cloneWithReset();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        this.dtm_iter.setShouldCacheNodes(true);
        this.dtm_iter.runTo(-1);
        this.dtm_iter.setCurrentPos(n2);
    }

    public Node item(int n2) {
        if (this.dtm_iter != null) {
            int n3 = this.dtm_iter.item(n2);
            return this.dtm_iter.getDTM(n3).getNode(n3);
        }
        int n4 = this.m_firstChild;
        while (--n2 >= 0 && n4 != -1) {
            n4 = this.m_parentDTM.getNextSibling(n4);
        }
        return this.m_parentDTM.getNode(n4);
    }
}

