/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.parser;

import org.apache.crimson.parser.SimpleHashtable;

final class ContentModel {
    public char type;
    public Object content;
    public ContentModel next;
    private SimpleHashtable cache = new SimpleHashtable();

    public boolean empty() {
        switch (this.type) {
            case '*': 
            case '?': {
                return true;
            }
            case '\u0000': 
            case '+': {
                return false;
            }
            case '|': {
                if (this.content instanceof ContentModel && ((ContentModel)this.content).empty()) {
                    return true;
                }
                ContentModel contentModel = this.next;
                while (contentModel != null) {
                    if (contentModel.empty()) {
                        return true;
                    }
                    contentModel = contentModel.next;
                }
                return false;
            }
            case ',': {
                if (this.content instanceof ContentModel) {
                    if (!((ContentModel)this.content).empty()) {
                        return false;
                    }
                } else {
                    return false;
                }
                ContentModel contentModel = this.next;
                while (contentModel != null) {
                    if (!contentModel.empty()) {
                        return false;
                    }
                    contentModel = contentModel.next;
                }
                return true;
            }
        }
        throw new InternalError();
    }

    public ContentModel(String string) {
        this.type = '\u0000';
        this.content = string;
    }

    public boolean first(String string) {
        boolean bl2;
        Boolean bl3 = (Boolean)this.cache.get(string);
        if (bl3 != null) {
            return bl3;
        }
        switch (this.type) {
            case '\u0000': 
            case '*': 
            case '+': 
            case '?': {
                if (this.content instanceof String) {
                    bl2 = this.content == string;
                    break;
                }
                bl2 = ((ContentModel)this.content).first(string);
                break;
            }
            case ',': {
                if (this.content instanceof String) {
                    bl2 = this.content == string;
                    break;
                }
                if (((ContentModel)this.content).first(string)) {
                    bl2 = true;
                    break;
                }
                if (!((ContentModel)this.content).empty()) {
                    bl2 = false;
                    break;
                }
                if (this.next != null) {
                    bl2 = this.next.first(string);
                    break;
                }
                bl2 = false;
                break;
            }
            case '|': {
                if (this.content instanceof String && this.content == string) {
                    bl2 = true;
                    break;
                }
                if (((ContentModel)this.content).first(string)) {
                    bl2 = true;
                    break;
                }
                if (this.next != null) {
                    bl2 = this.next.first(string);
                    break;
                }
                bl2 = false;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        if (bl2) {
            this.cache.put(string, Boolean.TRUE);
        } else {
            this.cache.put(string, Boolean.FALSE);
        }
        return bl2;
    }

    public ContentModel(char c2, ContentModel contentModel) {
        this.type = c2;
        this.content = contentModel;
    }
}

