/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public final class StringContent
implements AbstractDocument.Content,
Serializable {
    private static final char[] empty = new char[0];
    private char[] data;
    private int count;
    transient Vector marks;

    public int length() {
        return this.count;
    }

    public StringContent() {
        this(10);
    }

    public StringContent(int n2) {
        if (n2 < 1) {
            n2 = 1;
        }
        this.data = new char[n2];
        this.data[0] = 10;
        this.count = 1;
    }

    void resize(int n2) {
        char[] cArray = new char[n2];
        System.arraycopy(this.data, 0, cArray, 0, Math.min(n2, this.count));
        this.data = cArray;
    }

    synchronized void updateMarksForInsert(int n2, int n3) {
        if (n2 == 0) {
            n2 = 1;
        }
        int n4 = this.marks.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            PosRec posRec = (PosRec)this.marks.elementAt(i2);
            if (posRec.unused) {
                this.marks.removeElementAt(i2);
                --i2;
                --n4;
                continue;
            }
            if (posRec.offset < n2) continue;
            posRec.offset += n3;
        }
    }

    synchronized void updateMarksForRemove(int n2, int n3) {
        int n4 = this.marks.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            PosRec posRec = (PosRec)this.marks.elementAt(i2);
            if (posRec.unused) {
                this.marks.removeElementAt(i2);
                --i2;
                --n4;
                continue;
            }
            if (posRec.offset >= n2 + n3) {
                posRec.offset -= n3;
                continue;
            }
            if (posRec.offset < n2) continue;
            posRec.offset = n2;
        }
    }

    void replace(int n2, int n3, char[] cArray, int n4, int n5) {
        int n6 = n5 - n3;
        int n7 = n2 + n3;
        int n8 = this.count - n7;
        int n9 = n7 + n6;
        if (this.count + n6 >= this.data.length) {
            int n10 = Math.max(2 * this.data.length, this.count + n6);
            char[] cArray2 = new char[n10];
            System.arraycopy(this.data, 0, cArray2, 0, n2);
            System.arraycopy(cArray, n4, cArray2, n2, n5);
            System.arraycopy(this.data, n7, cArray2, n9, n8);
            this.data = cArray2;
        } else {
            System.arraycopy(this.data, n7, this.data, n9, n8);
            System.arraycopy(cArray, n4, this.data, n2, n5);
        }
        this.count += n6;
    }

    public String getString(int n2, int n3) throws BadLocationException {
        if (n2 + n3 > this.count) {
            throw new BadLocationException("Invalid range", this.count);
        }
        return new String(this.data, n2, n3);
    }

    protected void updateUndoPositions(Vector vector) {
        for (int i2 = vector.size() - 1; i2 >= 0; --i2) {
            UndoPosRef undoPosRef = (UndoPosRef)vector.elementAt(i2);
            if (undoPosRef.rec.unused) {
                vector.removeElementAt(i2);
                continue;
            }
            undoPosRef.resetLocation();
        }
    }

    public Position createPosition(int n2) throws BadLocationException {
        if (this.marks == null) {
            this.marks = new Vector();
        }
        return new StickyPosition(n2);
    }

    public void getChars(int n2, int n3, Segment segment) throws BadLocationException {
        if (n2 + n3 > this.count) {
            throw new BadLocationException("Invalid location", this.count);
        }
        segment.array = this.data;
        segment.offset = n2;
        segment.count = n3;
    }

    public UndoableEdit remove(int n2, int n3) throws BadLocationException {
        if (n2 + n3 >= this.count) {
            throw new BadLocationException("Invalid range", this.count);
        }
        String string = this.getString(n2, n3);
        RemoveUndo removeUndo = new RemoveUndo(n2, string);
        this.replace(n2, n3, empty, 0, 0);
        if (this.marks != null) {
            this.updateMarksForRemove(n2, n3);
        }
        return removeUndo;
    }

    protected Vector getPositionsInRange(Vector vector, int n2, int n3) {
        int n4 = this.marks.size();
        int n5 = n2 + n3;
        Vector vector2 = vector == null ? new Vector() : vector;
        for (int i2 = 0; i2 < n4; ++i2) {
            PosRec posRec = (PosRec)this.marks.elementAt(i2);
            if (posRec.unused) {
                this.marks.removeElementAt(i2);
                --i2;
                --n4;
                continue;
            }
            if (posRec.offset < n2 || posRec.offset > n5) continue;
            vector2.addElement(new UndoPosRef(posRec));
        }
        return vector2;
    }

    public UndoableEdit insertString(int n2, String string) throws BadLocationException {
        if (n2 >= this.count || n2 < 0) {
            throw new BadLocationException("Invalid location", this.count);
        }
        char[] cArray = string.toCharArray();
        this.replace(n2, 0, cArray, 0, cArray.length);
        if (this.marks != null) {
            this.updateMarksForInsert(n2, string.length());
        }
        return new InsertUndo(n2, string.length());
    }

    class InsertUndo
    extends AbstractUndoableEdit {
        protected int offset;
        protected int length;
        protected String string;
        protected Vector posRefs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void redo() throws CannotRedoException {
            super.redo();
            try {
                StringContent stringContent = StringContent.this;
                synchronized (stringContent) {
                    StringContent.this.insertString(this.offset, this.string);
                    this.string = null;
                    if (this.posRefs != null) {
                        StringContent.this.updateUndoPositions(this.posRefs);
                        this.posRefs = null;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undo() throws CannotUndoException {
            super.undo();
            try {
                StringContent stringContent = StringContent.this;
                synchronized (stringContent) {
                    if (StringContent.this.marks != null) {
                        this.posRefs = StringContent.this.getPositionsInRange(null, this.offset, this.length);
                    }
                    this.string = StringContent.this.getString(this.offset, this.length);
                    StringContent.this.remove(this.offset, this.length);
                }
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        protected InsertUndo(int n2, int n3) {
            this.offset = n2;
            this.length = n3;
        }
    }

    final class PosRec {
        int offset;
        boolean unused;

        PosRec(int n2) {
            this.offset = n2;
        }
    }

    class RemoveUndo
    extends AbstractUndoableEdit {
        protected int offset;
        protected int length;
        protected String string;
        protected Vector posRefs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void redo() throws CannotRedoException {
            super.redo();
            try {
                StringContent stringContent = StringContent.this;
                synchronized (stringContent) {
                    this.string = StringContent.this.getString(this.offset, this.length);
                    if (StringContent.this.marks != null) {
                        this.posRefs = StringContent.this.getPositionsInRange(null, this.offset, this.length);
                    }
                    StringContent.this.remove(this.offset, this.length);
                }
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undo() throws CannotUndoException {
            super.undo();
            try {
                StringContent stringContent = StringContent.this;
                synchronized (stringContent) {
                    StringContent.this.insertString(this.offset, this.string);
                    if (this.posRefs != null) {
                        StringContent.this.updateUndoPositions(this.posRefs);
                        this.posRefs = null;
                    }
                    this.string = null;
                }
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        protected RemoveUndo(int n2, String string) {
            this.offset = n2;
            this.string = string;
            this.length = string.length();
            if (StringContent.this.marks != null) {
                this.posRefs = StringContent.this.getPositionsInRange(null, n2, this.length);
            }
        }
    }

    final class StickyPosition
    implements Position {
        PosRec rec;

        public int getOffset() {
            return this.rec.offset;
        }

        protected void finalize() throws Throwable {
            this.rec.unused = true;
        }

        public String toString() {
            return Integer.toString(this.getOffset());
        }

        StickyPosition(int n2) {
            this.rec = new PosRec(n2);
            StringContent.this.marks.addElement(this.rec);
        }
    }

    final class UndoPosRef {
        protected int undoLocation;
        protected PosRec rec;

        protected void resetLocation() {
            this.rec.offset = this.undoLocation;
        }

        UndoPosRef(PosRec posRec) {
            this.rec = posRec;
            this.undoLocation = posRec.offset;
        }
    }
}

