/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;

public class ComponentView
extends View {
    private Component createdC;
    private Component c;

    void setComponentParent() {
        Container container;
        View view = this.getParent();
        if (view != null) {
            Container container2 = this.getContainer();
            if (container2 != null) {
                Component component;
                if (this.c == null && (component = this.createComponent()) != null) {
                    this.createdC = component;
                    this.c = new Invalidator(component);
                }
                if (this.c != null && this.c.getParent() == null) {
                    container2.add(this.c, this);
                }
            }
        } else if (this.c != null && (container = this.c.getParent()) != null) {
            container.remove(this.c);
        }
    }

    public float getAlignment(int n2) {
        if (this.c != null) {
            switch (n2) {
                case 0: {
                    return this.c.getAlignmentX();
                }
                case 1: {
                    return this.c.getAlignmentY();
                }
            }
        }
        return super.getAlignment(n2);
    }

    public float getMaximumSpan(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("Invalid axis: " + n2);
        }
        if (this.c != null) {
            Dimension dimension = this.c.getMaximumSize();
            if (n2 == 0) {
                return dimension.width;
            }
            return dimension.height;
        }
        return 0.0f;
    }

    public float getMinimumSpan(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("Invalid axis: " + n2);
        }
        if (this.c != null) {
            Dimension dimension = this.c.getMinimumSize();
            if (n2 == 0) {
                return dimension.width;
            }
            return dimension.height;
        }
        return 0.0f;
    }

    public float getPreferredSpan(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("Invalid axis: " + n2);
        }
        if (this.c != null) {
            Dimension dimension = this.c.getPreferredSize();
            if (n2 == 0) {
                return dimension.width;
            }
            return dimension.height;
        }
        return 0.0f;
    }

    protected Component createComponent() {
        AttributeSet attributeSet = this.getElement().getAttributes();
        Component component = StyleConstants.getComponent(attributeSet);
        return component;
    }

    public final Component getComponent() {
        return this.createdC;
    }

    public ComponentView(Element element) {
        super(element);
    }

    public void setParent(View view) {
        super.setParent(view);
        if (SwingUtilities.isEventDispatchThread()) {
            this.setComponentParent();
        } else {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Document document = ComponentView.this.getDocument();
                    try {
                        if (document instanceof AbstractDocument) {
                            ((AbstractDocument)document).readLock();
                        }
                        ComponentView.this.setComponentParent();
                        Container container = ComponentView.this.getContainer();
                        if (container != null) {
                            ComponentView.this.preferenceChanged(null, true, true);
                            container.repaint();
                        }
                    }
                    finally {
                        if (document instanceof AbstractDocument) {
                            ((AbstractDocument)document).readUnlock();
                        }
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void paint(Graphics graphics, Shape shape) {
        if (this.c != null) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            this.c.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
        Rectangle rectangle = (Rectangle)shape;
        if (f2 < (float)(rectangle.x + rectangle.width / 2)) {
            biasArray[0] = Position.Bias.Forward;
            return this.getStartOffset();
        }
        biasArray[0] = Position.Bias.Backward;
        return this.getEndOffset();
    }

    public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
        int n3 = this.getStartOffset();
        int n4 = this.getEndOffset();
        if (n2 >= n3 && n2 <= n4) {
            Rectangle rectangle = shape.getBounds();
            if (n2 == n4) {
                rectangle.x += rectangle.width;
            }
            rectangle.width = 0;
            return rectangle;
        }
        throw new BadLocationException(n2 + " not in range " + n3 + "," + n4, n2);
    }

    class Invalidator
    extends Container {
        Dimension min;
        Dimension pref;
        Dimension max;
        float yalign;
        float xalign;

        public float getAlignmentX() {
            this.validateIfNecessary();
            return this.xalign;
        }

        public float getAlignmentY() {
            this.validateIfNecessary();
            return this.yalign;
        }

        private void cacheChildSizes() {
            Component component = this.getComponent(0);
            this.min = component.getMinimumSize();
            this.pref = component.getPreferredSize();
            this.max = component.getMaximumSize();
            this.yalign = component.getAlignmentY();
            this.xalign = component.getAlignmentX();
        }

        public void doLayout() {
            this.cacheChildSizes();
        }

        public void invalidate() {
            super.invalidate();
            if (this.getParent() != null) {
                ComponentView.this.preferenceChanged(null, true, true);
            }
        }

        public void validateIfNecessary() {
            if (!this.isValid()) {
                this.validate();
            }
        }

        public void setBounds(int n2, int n3, int n4, int n5) {
            super.setBounds(n2, n3, n4, n5);
            this.getComponent(0).setSize(n4, n5);
            this.cacheChildSizes();
        }

        public void setVisible(boolean bl2) {
            super.setVisible(bl2);
            Component component = this.getComponent(0);
            component.setVisible(bl2);
        }

        public Dimension getMaximumSize() {
            this.validateIfNecessary();
            return this.max;
        }

        public Dimension getMinimumSize() {
            this.validateIfNecessary();
            return this.min;
        }

        public Dimension getPreferredSize() {
            this.validateIfNecessary();
            return this.pref;
        }

        public Set getFocusTraversalKeys(int n2) {
            return KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(n2);
        }

        Invalidator(Component component) {
            this.setLayout(null);
            this.add(component);
            this.cacheChildSizes();
        }
    }
}

