/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.CenterLayout;
import javax.swing.colorchooser.MainSwatchPanel;
import javax.swing.colorchooser.RecentSwatchPanel;
import javax.swing.colorchooser.SwatchPanel;

class DefaultSwatchChooserPanel
extends AbstractColorChooserPanel {
    SwatchPanel swatchPanel;
    RecentSwatchPanel recentSwatchPanel;
    MouseListener mainSwatchListener;
    MouseListener recentSwatchListener;
    private static String recentStr = UIManager.getString("ColorChooser.swatchesRecentText");

    public int getDisplayedMnemonicIndex() {
        return DefaultSwatchChooserPanel.getInt("ColorChooser.swatchesDisplayedMnemonicIndex", -1);
    }

    public int getMnemonic() {
        return DefaultSwatchChooserPanel.getInt("ColorChooser.swatchesMnemonic", -1);
    }

    protected void buildChooser() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.swatchPanel = new MainSwatchPanel();
        this.swatchPanel.getAccessibleContext().setAccessibleName(this.getDisplayName());
        this.recentSwatchPanel = new RecentSwatchPanel();
        this.recentSwatchPanel.getAccessibleContext().setAccessibleName(recentStr);
        this.mainSwatchListener = new MainSwatchListener();
        this.swatchPanel.addMouseListener(this.mainSwatchListener);
        this.recentSwatchListener = new RecentSwatchListener();
        this.recentSwatchPanel.addMouseListener(this.recentSwatchListener);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        CompoundBorder compoundBorder = new CompoundBorder(new LineBorder(Color.black), new LineBorder(Color.white));
        jPanel2.setBorder(compoundBorder);
        jPanel2.add((Component)this.swatchPanel, "Center");
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.recentSwatchPanel.addMouseListener(this.recentSwatchListener);
        jPanel3.setBorder(compoundBorder);
        jPanel3.add((Component)this.recentSwatchPanel, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel3, "Center");
        JLabel jLabel = new JLabel(recentStr);
        jLabel.setLabelFor(this.recentSwatchPanel);
        jPanel4.add((Component)jLabel, "North");
        JPanel jPanel5 = new JPanel(new CenterLayout());
        if (this.getComponentOrientation().isLeftToRight()) {
            jPanel5.setBorder(new EmptyBorder(2, 10, 2, 2));
        } else {
            jPanel5.setBorder(new EmptyBorder(2, 2, 2, 10));
        }
        jPanel5.add(jPanel4);
        jPanel.add((Component)jPanel5, "After");
        this.add(jPanel);
    }

    public void updateChooser() {
    }

    public String getDisplayName() {
        return UIManager.getString("ColorChooser.swatchesNameText");
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public void installChooserPanel(JColorChooser jColorChooser) {
        super.installChooserPanel(jColorChooser);
    }

    public void uninstallChooserPanel(JColorChooser jColorChooser) {
        super.uninstallChooserPanel(jColorChooser);
        this.swatchPanel.removeMouseListener(this.mainSwatchListener);
        this.recentSwatchPanel.removeMouseListener(this.recentSwatchListener);
        this.swatchPanel = null;
        this.recentSwatchPanel = null;
        this.mainSwatchListener = null;
        this.recentSwatchListener = null;
        this.removeAll();
    }

    class MainSwatchListener
    extends MouseAdapter
    implements Serializable {
        public void mousePressed(MouseEvent mouseEvent) {
            Color color = DefaultSwatchChooserPanel.this.swatchPanel.getColorForLocation(mouseEvent.getX(), mouseEvent.getY());
            DefaultSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
            DefaultSwatchChooserPanel.this.recentSwatchPanel.setMostRecentColor(color);
        }

        MainSwatchListener() {
        }
    }

    class RecentSwatchListener
    extends MouseAdapter
    implements Serializable {
        public void mousePressed(MouseEvent mouseEvent) {
            Color color = DefaultSwatchChooserPanel.this.recentSwatchPanel.getColorForLocation(mouseEvent.getX(), mouseEvent.getY());
            DefaultSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
        }

        RecentSwatchListener() {
        }
    }
}

