/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractCollection
implements Collection {
    public abstract int size();

    protected AbstractCollection() {
    }

    public void clear() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        Iterator iterator = this.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            objectArray[n2] = iterator.next();
            ++n2;
        }
        return objectArray;
    }

    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object object) {
        Iterator iterator = this.iterator();
        if (object == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean remove(Object object) {
        Iterator iterator = this.iterator();
        if (object == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                iterator.remove();
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Iterator iterator = this.iterator();
        boolean bl2 = iterator.hasNext();
        while (bl2) {
            Object object = iterator.next();
            stringBuffer.append(object == this ? "(this Collection)" : String.valueOf(object));
            bl2 = iterator.hasNext();
            if (!bl2) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean addAll(Collection collection) {
        boolean bl2 = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.add(iterator.next())) continue;
            bl2 = true;
        }
        return bl2;
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(Collection collection) {
        boolean bl2 = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl2 = true;
        }
        return bl2;
    }

    public boolean retainAll(Collection collection) {
        boolean bl2 = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl2 = true;
        }
        return bl2;
    }

    public abstract Iterator iterator();

    public Object[] toArray(Object[] objectArray) {
        int n2 = this.size();
        if (objectArray.length < n2) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n2);
        }
        Iterator iterator = this.iterator();
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = iterator.next();
        }
        if (objectArray.length > n2) {
            objectArray[n2] = null;
        }
        return objectArray;
    }
}

