/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

class FloatingDecimal {
    boolean isExceptional;
    boolean isNegative;
    int decExponent;
    char[] digits;
    int nDigits;
    int bigIntExp;
    int bigIntNBits;
    boolean mustSetRoundDir = false;
    int roundDir;
    static final long signMask = Long.MIN_VALUE;
    static final long expMask = 0x7FF0000000000000L;
    static final long fractMask = 0xFFFFFFFFFFFFFL;
    static final int expShift = 52;
    static final int expBias = 1023;
    static final long fractHOB = 0x10000000000000L;
    static final long expOne = 0x3FF0000000000000L;
    static final int maxSmallBinExp = 62;
    static final int minSmallBinExp = -21;
    static final int maxDecimalDigits = 15;
    static final int maxDecimalExponent = 308;
    static final int minDecimalExponent = -324;
    static final int bigDecimalExponent = 324;
    static final long highbyte = -72057594037927936L;
    static final long highbit = Long.MIN_VALUE;
    static final long lowbytes = 0xFFFFFFFFFFFFFFL;
    static final int singleSignMask = Integer.MIN_VALUE;
    static final int singleExpMask = 2139095040;
    static final int singleFractMask = 0x7FFFFF;
    static final int singleExpShift = 23;
    static final int singleFractHOB = 0x800000;
    static final int singleExpBias = 127;
    static final int singleMaxDecimalDigits = 7;
    static final int singleMaxDecimalExponent = 38;
    static final int singleMinDecimalExponent = -45;
    static final int intDecimalDigits = 9;
    private static FDBigInt[] b5p;
    private static ThreadLocal perThreadBuffer;
    private static final double[] small10pow;
    private static final float[] singleSmall10pow;
    private static final double[] big10pow;
    private static final double[] tiny10pow;
    private static final int maxSmallTen;
    private static final int singleMaxSmallTen;
    private static final int[] small5pow;
    private static final long[] long5pow;
    private static final int[] n5bits;
    private static final char[] infinity;
    private static final char[] notANumber;
    private static final char[] zero;
    static final /* synthetic */ boolean $assertionsDisabled;

    public double doubleValue() {
        boolean bl2;
        double d2;
        int n2;
        int n3;
        int n4 = Math.min(this.nDigits, 16);
        if (this.digits == infinity || this.digits == notANumber) {
            if (this.digits == notANumber) {
                return Double.NaN;
            }
            return this.isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        this.roundDir = 0;
        int n5 = this.digits[0] - 48;
        int n6 = Math.min(n4, 9);
        for (n3 = 1; n3 < n6; ++n3) {
            n5 = n5 * 10 + this.digits[n3] - 48;
        }
        long l2 = n5;
        for (n3 = n6; n3 < n4; ++n3) {
            l2 = l2 * 10L + (long)(this.digits[n3] - 48);
        }
        double d3 = l2;
        n3 = this.decExponent - n4;
        if (this.nDigits <= 15) {
            if (n3 == 0 || d3 == 0.0) {
                return this.isNegative ? -d3 : d3;
            }
            if (n3 >= 0) {
                if (n3 <= maxSmallTen) {
                    double d4 = d3 * small10pow[n3];
                    if (this.mustSetRoundDir) {
                        double d5 = d4 / small10pow[n3];
                        this.roundDir = d5 == d3 ? 0 : (d5 < d3 ? 1 : -1);
                    }
                    return this.isNegative ? -d4 : d4;
                }
                n2 = 15 - n4;
                if (n3 <= maxSmallTen + n2) {
                    double d6 = (d3 *= small10pow[n2]) * small10pow[n3 - n2];
                    if (this.mustSetRoundDir) {
                        double d7 = d6 / small10pow[n3 - n2];
                        this.roundDir = d7 == d3 ? 0 : (d7 < d3 ? 1 : -1);
                    }
                    return this.isNegative ? -d6 : d6;
                }
            } else if (n3 >= -maxSmallTen) {
                double d8 = d3 / small10pow[-n3];
                double d9 = d8 * small10pow[-n3];
                if (this.mustSetRoundDir) {
                    this.roundDir = d9 == d3 ? 0 : (d9 < d3 ? 1 : -1);
                }
                return this.isNegative ? -d8 : d8;
            }
        }
        if (n3 > 0) {
            if (this.decExponent > 309) {
                return this.isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if ((n3 & 0xF) != 0) {
                d3 *= small10pow[n3 & 0xF];
            }
            if ((n3 >>= 4) != 0) {
                n2 = 0;
                while (n3 > 1) {
                    if ((n3 & 1) != 0) {
                        d3 *= big10pow[n2];
                    }
                    ++n2;
                    n3 >>= 1;
                }
                d2 = d3 * big10pow[n2];
                if (Double.isInfinite(d2)) {
                    d2 = d3 / 2.0;
                    if (Double.isInfinite(d2 *= big10pow[n2])) {
                        return this.isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                    }
                    d2 = Double.MAX_VALUE;
                }
                d3 = d2;
            }
        } else if (n3 < 0) {
            n3 = -n3;
            if (this.decExponent < -325) {
                return this.isNegative ? -0.0 : 0.0;
            }
            if ((n3 & 0xF) != 0) {
                d3 /= small10pow[n3 & 0xF];
            }
            if ((n3 >>= 4) != 0) {
                n2 = 0;
                while (n3 > 1) {
                    if ((n3 & 1) != 0) {
                        d3 *= tiny10pow[n2];
                    }
                    ++n2;
                    n3 >>= 1;
                }
                d2 = d3 * tiny10pow[n2];
                if (d2 == 0.0) {
                    d2 = d3 * 2.0;
                    if ((d2 *= tiny10pow[n2]) == 0.0) {
                        return this.isNegative ? -0.0 : 0.0;
                    }
                    d2 = Double.MIN_VALUE;
                }
                d3 = d2;
            }
        }
        FDBigInt fDBigInt = new FDBigInt(l2, this.digits, n4, this.nDigits);
        n3 = this.decExponent - this.nDigits;
        do {
            FDBigInt fDBigInt2;
            FDBigInt fDBigInt3;
            int n7;
            int n8;
            int n9;
            int n10;
            FDBigInt fDBigInt4 = this.doubleToBigInt(d3);
            if (n3 >= 0) {
                n10 = 0;
                n9 = 0;
                n7 = n8 = n3;
            } else {
                n9 = n10 = -n3;
                n8 = 0;
                n7 = 0;
            }
            if (this.bigIntExp >= 0) {
                n9 += this.bigIntExp;
            } else {
                n7 -= this.bigIntExp;
            }
            int n11 = n9;
            int n12 = this.bigIntExp + this.bigIntNBits <= -1022 ? this.bigIntExp + 1023 + 52 : 54 - this.bigIntNBits;
            int n13 = Math.min(n9 += n12, Math.min(n7 += n12, n11));
            n11 -= n13;
            fDBigInt4 = FloatingDecimal.multPow52(fDBigInt4, n10, n9 -= n13);
            FDBigInt fDBigInt5 = FloatingDecimal.multPow52(new FDBigInt(fDBigInt), n8, n7 -= n13);
            int n14 = fDBigInt4.cmp(fDBigInt5);
            if (n14 > 0) {
                bl2 = true;
                fDBigInt3 = fDBigInt4.sub(fDBigInt5);
                if (this.bigIntNBits == 1 && this.bigIntExp > -1023 && --n11 < 0) {
                    n11 = 0;
                    fDBigInt3.lshiftMe(1);
                }
            } else {
                if (n14 >= 0) break;
                bl2 = false;
                fDBigInt3 = fDBigInt5.sub(fDBigInt4);
            }
            if ((n14 = fDBigInt3.cmp(fDBigInt2 = FloatingDecimal.constructPow52(n10, n11))) < 0) {
                this.roundDir = bl2 ? -1 : 1;
                break;
            }
            if (n14 != 0) continue;
            d3 += 0.5 * FloatingDecimal.ulp(d3, bl2);
            this.roundDir = bl2 ? -1 : 1;
            break;
        } while ((d3 += FloatingDecimal.ulp(d3, bl2)) != 0.0 && d3 != Double.POSITIVE_INFINITY);
        return this.isNegative ? -d3 : d3;
    }

    public float floatValue() {
        int n2;
        int n3 = Math.min(this.nDigits, 8);
        if (this.digits == infinity || this.digits == notANumber) {
            if (this.digits == notANumber) {
                return Float.NaN;
            }
            return this.isNegative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        int n4 = this.digits[0] - 48;
        for (n2 = 1; n2 < n3; ++n2) {
            n4 = n4 * 10 + this.digits[n2] - 48;
        }
        float f2 = n4;
        n2 = this.decExponent - n3;
        if (this.nDigits <= 7) {
            if (n2 == 0 || f2 == 0.0f) {
                return this.isNegative ? -f2 : f2;
            }
            if (n2 >= 0) {
                if (n2 <= singleMaxSmallTen) {
                    return this.isNegative ? -f2 : (f2 *= singleSmall10pow[n2]);
                }
                int n5 = 7 - n3;
                if (n2 <= singleMaxSmallTen + n5) {
                    f2 *= singleSmall10pow[n5];
                    return this.isNegative ? -f2 : (f2 *= singleSmall10pow[n2 - n5]);
                }
            } else if (n2 >= -singleMaxSmallTen) {
                return this.isNegative ? -f2 : (f2 /= singleSmall10pow[-n2]);
            }
        } else if (this.decExponent >= this.nDigits && this.nDigits + this.decExponent <= 15) {
            long l2 = n4;
            for (int i2 = n3; i2 < this.nDigits; ++i2) {
                l2 = l2 * 10L + (long)(this.digits[i2] - 48);
            }
            double d2 = l2;
            n2 = this.decExponent - this.nDigits;
            f2 = (float)(d2 *= small10pow[n2]);
            return this.isNegative ? -f2 : f2;
        }
        if (this.decExponent > 39) {
            return this.isNegative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        if (this.decExponent < -46) {
            return this.isNegative ? -0.0f : 0.0f;
        }
        this.mustSetRoundDir = true;
        double d3 = this.doubleValue();
        return this.stickyRound(d3);
    }

    static {
        $assertionsDisabled = !FloatingDecimal.class.desiredAssertionStatus();
        perThreadBuffer = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new char[26];
            }
        };
        small10pow = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
        singleSmall10pow = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f};
        big10pow = new double[]{1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};
        tiny10pow = new double[]{1.0E-16, 1.0E-32, 1.0E-64, 1.0E-128, 1.0E-256};
        maxSmallTen = small10pow.length - 1;
        singleMaxSmallTen = singleSmall10pow.length - 1;
        small5pow = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
        long5pow = new long[]{1L, 5L, 25L, 125L, 625L, 3125L, 15625L, 78125L, 390625L, 1953125L, 9765625L, 48828125L, 244140625L, 1220703125L, 6103515625L, 30517578125L, 152587890625L, 762939453125L, 3814697265625L, 19073486328125L, 95367431640625L, 476837158203125L, 2384185791015625L, 11920928955078125L, 59604644775390625L, 298023223876953125L, 1490116119384765625L};
        n5bits = new int[]{0, 3, 5, 7, 10, 12, 14, 17, 19, 21, 24, 26, 28, 31, 33, 35, 38, 40, 42, 45, 47, 49, 52, 54, 56, 59, 61};
        infinity = new char[]{'I', 'n', 'f', 'i', 'n', 'i', 't', 'y'};
        notANumber = new char[]{'N', 'a', 'N'};
        zero = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
    }

    private void roundup() {
        int n2 = this.nDigits - 1;
        char c2 = this.digits[n2];
        if (c2 == '9') {
            while (c2 == '9' && n2 > 0) {
                this.digits[n2] = 48;
                c2 = this.digits[--n2];
            }
            if (c2 == '9') {
                ++this.decExponent;
                this.digits[0] = 49;
                return;
            }
        }
        this.digits[n2] = (char)(c2 + '\u0001');
    }

    float stickyRound(double d2) {
        long l2 = Double.doubleToLongBits(d2);
        long l3 = l2 & 0x7FF0000000000000L;
        if (l3 == 0L || l3 == 0x7FF0000000000000L) {
            return (float)d2;
        }
        return (float)Double.longBitsToDouble(l2 += (long)this.roundDir);
    }

    public FloatingDecimal(double d2) {
        int n2;
        long l2 = Double.doubleToLongBits(d2);
        if ((l2 & Long.MIN_VALUE) != 0L) {
            this.isNegative = true;
            l2 ^= Long.MIN_VALUE;
        } else {
            this.isNegative = false;
        }
        int n3 = (int)((l2 & 0x7FF0000000000000L) >> 52);
        long l3 = l2 & 0xFFFFFFFFFFFFFL;
        if (n3 == 2047) {
            this.isExceptional = true;
            if (l3 == 0L) {
                this.digits = infinity;
            } else {
                this.digits = notANumber;
                this.isNegative = false;
            }
            this.nDigits = this.digits.length;
            return;
        }
        this.isExceptional = false;
        if (n3 == 0) {
            if (l3 == 0L) {
                this.decExponent = 0;
                this.digits = zero;
                this.nDigits = 1;
                return;
            }
            while ((l3 & 0x10000000000000L) == 0L) {
                l3 <<= 1;
                --n3;
            }
            n2 = 52 + n3 + 1;
            ++n3;
        } else {
            l3 |= 0x10000000000000L;
            n2 = 53;
        }
        this.dtoa(n3 -= 1023, l3, n2);
    }

    private static double ulp(double d2, boolean bl2) {
        long l2 = Double.doubleToLongBits(d2) & Long.MAX_VALUE;
        int n2 = (int)(l2 >>> 52);
        if (bl2 && n2 >= 52 && (l2 & 0xFFFFFFFFFFFFFL) == 0L) {
            --n2;
        }
        double d3 = n2 > 52 ? Double.longBitsToDouble((long)(n2 - 52) << 52) : (n2 == 0 ? Double.MIN_VALUE : Double.longBitsToDouble(1L << n2 - 1));
        if (bl2) {
            d3 = -d3;
        }
        return d3;
    }

    public FloatingDecimal(float f2) {
        int n2;
        int n3 = Float.floatToIntBits(f2);
        if ((n3 & Integer.MIN_VALUE) != 0) {
            this.isNegative = true;
            n3 ^= Integer.MIN_VALUE;
        } else {
            this.isNegative = false;
        }
        int n4 = (n3 & 0x7F800000) >> 23;
        int n5 = n3 & 0x7FFFFF;
        if (n4 == 255) {
            this.isExceptional = true;
            if ((long)n5 == 0L) {
                this.digits = infinity;
            } else {
                this.digits = notANumber;
                this.isNegative = false;
            }
            this.nDigits = this.digits.length;
            return;
        }
        this.isExceptional = false;
        if (n4 == 0) {
            if (n5 == 0) {
                this.decExponent = 0;
                this.digits = zero;
                this.nDigits = 1;
                return;
            }
            while ((n5 & 0x800000) == 0) {
                n5 <<= 1;
                --n4;
            }
            n2 = 23 + n4 + 1;
            ++n4;
        } else {
            n5 |= 0x800000;
            n2 = 24;
        }
        this.dtoa(n4 -= 127, (long)n5 << 29, n2);
    }

    private void dtoa(int n2, long l2, int n3) {
        long l3;
        boolean bl2;
        boolean bl3;
        int n4 = FloatingDecimal.countBits(l2);
        int n5 = Math.max(0, n4 - n2 - 1);
        if (n2 <= 62 && n2 >= -21 && n5 < long5pow.length && n4 + n5bits[n5] < 64 && n5 == 0) {
            long l4 = n2 > n3 ? 1L << n2 - n3 - 1 : 0L;
            l2 = n2 >= 52 ? (l2 <<= n2 - 52) : (l2 >>>= 52 - n2);
            this.developLongDigits(0, l2, l4);
            return;
        }
        double d2 = Double.longBitsToDouble(0x3FF0000000000000L | l2 & 0xFFEFFFFFFFFFFFFFL);
        int n6 = (int)Math.floor((d2 - 1.5) * 0.289529654 + 0.176091259 + (double)n2 * 0.301029995663981);
        int n7 = Math.max(0, -n6);
        int n8 = n7 + n5 + n2;
        int n9 = Math.max(0, n6);
        int n10 = n9 + n5;
        int n11 = n7;
        int n12 = n8 - n3;
        l2 >>>= 53 - n4;
        int n13 = Math.min(n8 -= n4 - 1, n10);
        n8 -= n13;
        n10 -= n13;
        n12 -= n13;
        if (n4 == 1) {
            --n12;
        }
        if (n12 < 0) {
            n8 -= n12;
            n10 -= n12;
            n12 = 0;
        }
        this.digits = new char[18];
        char[] cArray = this.digits;
        int n14 = 0;
        int n15 = n4 + n8 + (n7 < n5bits.length ? n5bits[n7] : n7 * 3);
        int n16 = n10 + 1 + (n9 + 1 < n5bits.length ? n5bits[n9 + 1] : (n9 + 1) * 3);
        if (n15 < 64 && n16 < 64) {
            if (n15 < 32 && n16 < 32) {
                int n17 = (int)l2 * small5pow[n7] << n8;
                int n18 = small5pow[n9] << n10;
                int n19 = small5pow[n11] << n12;
                int n20 = n18 * 10;
                n14 = 0;
                int n21 = n17 / n18;
                bl3 = (n17 = 10 * (n17 % n18)) < (n19 *= 10);
                boolean bl4 = bl2 = n17 + n19 > n20;
                if (!$assertionsDisabled && n21 >= 10) {
                    throw new AssertionError(n21);
                }
                if (n21 == 0 && !bl2) {
                    --n6;
                } else {
                    cArray[n14++] = (char)(48 + n21);
                }
                if (n6 <= -3 || n6 >= 8) {
                    bl3 = false;
                    bl2 = false;
                }
                while (!bl3 && !bl2) {
                    n21 = n17 / n18;
                    n17 = 10 * (n17 % n18);
                    n19 *= 10;
                    if (!$assertionsDisabled && n21 >= 10) {
                        throw new AssertionError(n21);
                    }
                    if ((long)n19 > 0L) {
                        bl3 = n17 < n19;
                        bl2 = n17 + n19 > n20;
                    } else {
                        bl3 = true;
                        bl2 = true;
                    }
                    cArray[n14++] = (char)(48 + n21);
                }
                l3 = (n17 << 1) - n20;
            } else {
                long l5 = l2 * long5pow[n7] << n8;
                long l6 = long5pow[n9] << n10;
                long l7 = long5pow[n11] << n12;
                long l8 = l6 * 10L;
                n14 = 0;
                int n22 = (int)(l5 / l6);
                bl3 = (l5 = 10L * (l5 % l6)) < (l7 *= 10L);
                boolean bl5 = bl2 = l5 + l7 > l8;
                if (!$assertionsDisabled && n22 >= 10) {
                    throw new AssertionError(n22);
                }
                if (n22 == 0 && !bl2) {
                    --n6;
                } else {
                    cArray[n14++] = (char)(48 + n22);
                }
                if (n6 <= -3 || n6 >= 8) {
                    bl3 = false;
                    bl2 = false;
                }
                while (!bl3 && !bl2) {
                    n22 = (int)(l5 / l6);
                    l5 = 10L * (l5 % l6);
                    l7 *= 10L;
                    if (!$assertionsDisabled && n22 >= 10) {
                        throw new AssertionError(n22);
                    }
                    if (l7 > 0L) {
                        bl3 = l5 < l7;
                        bl2 = l5 + l7 > l8;
                    } else {
                        bl3 = true;
                        bl2 = true;
                    }
                    cArray[n14++] = (char)(48 + n22);
                }
                l3 = (l5 << 1) - l8;
            }
        } else {
            FDBigInt fDBigInt = FloatingDecimal.multPow52(new FDBigInt(l2), n7, n8);
            FDBigInt fDBigInt2 = FloatingDecimal.constructPow52(n9, n10);
            FDBigInt fDBigInt3 = FloatingDecimal.constructPow52(n11, n12);
            int n23 = fDBigInt2.normalizeMe();
            fDBigInt.lshiftMe(n23);
            fDBigInt3.lshiftMe(n23);
            FDBigInt fDBigInt4 = fDBigInt2.mult(10);
            n14 = 0;
            int n24 = fDBigInt.quoRemIteration(fDBigInt2);
            fDBigInt3 = fDBigInt3.mult(10);
            bl3 = fDBigInt.cmp(fDBigInt3) < 0;
            boolean bl6 = bl2 = fDBigInt.add(fDBigInt3).cmp(fDBigInt4) > 0;
            if (!$assertionsDisabled && n24 >= 10) {
                throw new AssertionError(n24);
            }
            if (n24 == 0 && !bl2) {
                --n6;
            } else {
                cArray[n14++] = (char)(48 + n24);
            }
            if (n6 <= -3 || n6 >= 8) {
                bl3 = false;
                bl2 = false;
            }
            while (!bl3 && !bl2) {
                n24 = fDBigInt.quoRemIteration(fDBigInt2);
                fDBigInt3 = fDBigInt3.mult(10);
                if (!$assertionsDisabled && n24 >= 10) {
                    throw new AssertionError(n24);
                }
                bl3 = fDBigInt.cmp(fDBigInt3) < 0;
                bl2 = fDBigInt.add(fDBigInt3).cmp(fDBigInt4) > 0;
                cArray[n14++] = (char)(48 + n24);
            }
            if (bl2 && bl3) {
                fDBigInt.lshiftMe(1);
                l3 = fDBigInt.cmp(fDBigInt4);
            } else {
                l3 = 0L;
            }
        }
        this.decExponent = n6 + 1;
        this.digits = cArray;
        this.nDigits = n14;
        if (bl2) {
            if (bl3) {
                if (l3 == 0L) {
                    if ((cArray[this.nDigits - 1] & '\u0001') != 0) {
                        this.roundup();
                    }
                } else if (l3 > 0L) {
                    this.roundup();
                }
            } else {
                this.roundup();
            }
        }
    }

    private void developLongDigits(int n2, long l2, long l3) {
        int n3;
        char[] cArray;
        int n4;
        int n5 = 0;
        while (l3 >= 10L) {
            l3 /= 10L;
            ++n5;
        }
        if (n5 != 0) {
            long l4 = long5pow[n5] << n5;
            long l5 = l2 % l4;
            l2 /= l4;
            n2 += n5;
            if (l5 >= l4 >> 1) {
                ++l2;
            }
        }
        if (l2 <= Integer.MAX_VALUE) {
            if (!$assertionsDisabled && l2 <= 0L) {
                throw new AssertionError(l2);
            }
            int n6 = (int)l2;
            n4 = 10;
            cArray = (char[])perThreadBuffer.get();
            n3 = n4 - 1;
            int n7 = n6 % 10;
            n6 /= 10;
            while (n7 == 0) {
                ++n2;
                n7 = n6 % 10;
                n6 /= 10;
            }
            while (n6 != 0) {
                cArray[n3--] = (char)(n7 + 48);
                ++n2;
                n7 = n6 % 10;
                n6 /= 10;
            }
            cArray[n3] = (char)(n7 + 48);
        } else {
            n4 = 20;
            cArray = (char[])perThreadBuffer.get();
            n3 = n4 - 1;
            int n8 = (int)(l2 % 10L);
            l2 /= 10L;
            while (n8 == 0) {
                ++n2;
                n8 = (int)(l2 % 10L);
                l2 /= 10L;
            }
            while (l2 != 0L) {
                cArray[n3--] = (char)(n8 + 48);
                ++n2;
                n8 = (int)(l2 % 10L);
                l2 /= 10L;
            }
            cArray[n3] = (char)(n8 + 48);
        }
        char[] cArray2 = new char[n4 -= n3];
        System.arraycopy(cArray, n3, cArray2, 0, n4);
        this.digits = cArray2;
        this.decExponent = n2 + 1;
        this.nDigits = n4;
    }

    private static int countBits(long l2) {
        if (l2 == 0L) {
            return 0;
        }
        while ((l2 & 0xFF00000000000000L) == 0L) {
            l2 <<= 8;
        }
        while (l2 > 0L) {
            l2 <<= 1;
        }
        int n2 = 0;
        while ((l2 & 0xFFFFFFFFFFFFFFL) != 0L) {
            l2 <<= 8;
            n2 += 8;
        }
        while (l2 != 0L) {
            l2 <<= 1;
            ++n2;
        }
        return n2;
    }

    private FloatingDecimal(boolean bl2, int n2, char[] cArray, int n3, boolean bl3) {
        this.isNegative = bl2;
        this.isExceptional = bl3;
        this.decExponent = n2;
        this.digits = cArray;
        this.nDigits = n3;
    }

    private int getChars(char[] cArray) {
        if (!$assertionsDisabled && this.nDigits > 19) {
            throw new AssertionError(this.nDigits);
        }
        int n2 = 0;
        if (this.isNegative) {
            cArray[0] = 45;
            n2 = 1;
        }
        if (this.isExceptional) {
            System.arraycopy(this.digits, 0, cArray, n2, this.nDigits);
            n2 += this.nDigits;
        } else if (this.decExponent > 0 && this.decExponent < 8) {
            int n3 = Math.min(this.nDigits, this.decExponent);
            System.arraycopy(this.digits, 0, cArray, n2, n3);
            n2 += n3;
            if (n3 < this.decExponent) {
                n3 = this.decExponent - n3;
                System.arraycopy(zero, 0, cArray, n2, n3);
                n2 += n3;
                cArray[n2++] = 46;
                cArray[n2++] = 48;
            } else {
                cArray[n2++] = 46;
                if (n3 < this.nDigits) {
                    int n4 = this.nDigits - n3;
                    System.arraycopy(this.digits, n3, cArray, n2, n4);
                    n2 += n4;
                } else {
                    cArray[n2++] = 48;
                }
            }
        } else if (this.decExponent <= 0 && this.decExponent > -3) {
            cArray[n2++] = 48;
            cArray[n2++] = 46;
            if (this.decExponent != 0) {
                System.arraycopy(zero, 0, cArray, n2, -this.decExponent);
                n2 -= this.decExponent;
            }
            System.arraycopy(this.digits, 0, cArray, n2, this.nDigits);
            n2 += this.nDigits;
        } else {
            int n5;
            cArray[n2++] = this.digits[0];
            cArray[n2++] = 46;
            if (this.nDigits > 1) {
                System.arraycopy(this.digits, 1, cArray, n2, this.nDigits - 1);
                n2 += this.nDigits - 1;
            } else {
                cArray[n2++] = 48;
            }
            cArray[n2++] = 69;
            if (this.decExponent <= 0) {
                cArray[n2++] = 45;
                n5 = -this.decExponent + 1;
            } else {
                n5 = this.decExponent - 1;
            }
            if (n5 <= 9) {
                cArray[n2++] = (char)(n5 + 48);
            } else if (n5 <= 99) {
                cArray[n2++] = (char)(n5 / 10 + 48);
                cArray[n2++] = (char)(n5 % 10 + 48);
            } else {
                cArray[n2++] = (char)(n5 / 100 + 48);
                cArray[n2++] = (char)((n5 %= 100) / 10 + 48);
                cArray[n2++] = (char)(n5 % 10 + 48);
            }
        }
        return n2;
    }

    private FDBigInt doubleToBigInt(double d2) {
        long l2 = Double.doubleToLongBits(d2) & Long.MAX_VALUE;
        int n2 = (int)(l2 >>> 52);
        l2 &= 0xFFFFFFFFFFFFFL;
        if (n2 > 0) {
            l2 |= 0x10000000000000L;
        } else {
            if (!$assertionsDisabled && l2 == 0L) {
                throw new AssertionError(l2);
            }
            ++n2;
            while ((l2 & 0x10000000000000L) == 0L) {
                l2 <<= 1;
                --n2;
            }
        }
        int n3 = FloatingDecimal.countBits(l2);
        int n4 = 53 - n3;
        this.bigIntExp = (n2 -= 1023) + 1 - n3;
        this.bigIntNBits = n3;
        return new FDBigInt(l2 >>>= n4);
    }

    private static synchronized FDBigInt big5pow(int n2) {
        if (!$assertionsDisabled && n2 < 0) {
            throw new AssertionError(n2);
        }
        if (b5p == null) {
            b5p = new FDBigInt[n2 + 1];
        } else if (b5p.length <= n2) {
            FDBigInt[] fDBigIntArray = new FDBigInt[n2 + 1];
            System.arraycopy(b5p, 0, fDBigIntArray, 0, b5p.length);
            b5p = fDBigIntArray;
        }
        if (b5p[n2] != null) {
            return b5p[n2];
        }
        if (n2 < small5pow.length) {
            FloatingDecimal.b5p[n2] = new FDBigInt(small5pow[n2]);
            return FloatingDecimal.b5p[n2];
        }
        if (n2 < long5pow.length) {
            FloatingDecimal.b5p[n2] = new FDBigInt(long5pow[n2]);
            return FloatingDecimal.b5p[n2];
        }
        int n3 = n2 >> 1;
        int n4 = n2 - n3;
        FDBigInt fDBigInt = b5p[n3];
        if (fDBigInt == null) {
            fDBigInt = FloatingDecimal.big5pow(n3);
        }
        if (n4 < small5pow.length) {
            FloatingDecimal.b5p[n2] = fDBigInt.mult(small5pow[n4]);
            return FloatingDecimal.b5p[n2];
        }
        FDBigInt fDBigInt2 = b5p[n4];
        if (fDBigInt2 == null) {
            fDBigInt2 = FloatingDecimal.big5pow(n4);
        }
        FloatingDecimal.b5p[n2] = fDBigInt.mult(fDBigInt2);
        return FloatingDecimal.b5p[n2];
    }

    private static FDBigInt constructPow52(int n2, int n3) {
        FDBigInt fDBigInt = new FDBigInt(FloatingDecimal.big5pow(n2));
        if (n3 != 0) {
            fDBigInt.lshiftMe(n3);
        }
        return fDBigInt;
    }

    public String toJavaFormatString() {
        char[] cArray = (char[])perThreadBuffer.get();
        int n2 = this.getChars(cArray);
        return new String(cArray, 0, n2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.nDigits + 8);
        if (this.isNegative) {
            stringBuffer.append('-');
        }
        if (this.isExceptional) {
            stringBuffer.append(this.digits, 0, this.nDigits);
        } else {
            stringBuffer.append("0.");
            stringBuffer.append(this.digits, 0, this.nDigits);
            stringBuffer.append('e');
            stringBuffer.append(this.decExponent);
        }
        return new String(stringBuffer);
    }

    void appendTo(StringBuffer stringBuffer) {
        char[] cArray = (char[])perThreadBuffer.get();
        int n2 = this.getChars(cArray);
        stringBuffer.append(cArray, 0, n2);
    }

    private static FDBigInt multPow52(FDBigInt fDBigInt, int n2, int n3) {
        if (n2 != 0) {
            fDBigInt = n2 < small5pow.length ? fDBigInt.mult(small5pow[n2]) : fDBigInt.mult(FloatingDecimal.big5pow(n2));
        }
        if (n3 != 0) {
            fDBigInt.lshiftMe(n3);
        }
        return fDBigInt;
    }

    public static FloatingDecimal readJavaFormatString(String string) throws NumberFormatException {
        block36: {
            boolean bl2 = false;
            boolean bl3 = false;
            try {
                string = string.trim();
                int n2 = string.length();
                if (n2 == 0) {
                    throw new NumberFormatException("empty String");
                }
                int n3 = 0;
                char c2 = string.charAt(n3);
                switch (c2) {
                    case '-': {
                        bl2 = true;
                    }
                    case '+': {
                        ++n3;
                        bl3 = true;
                    }
                }
                c2 = string.charAt(n3);
                if (c2 == 'N' || c2 == 'I') {
                    int n4;
                    boolean bl4 = false;
                    char[] cArray = null;
                    if (c2 == 'N') {
                        cArray = notANumber;
                        bl4 = true;
                    } else {
                        cArray = infinity;
                    }
                    for (n4 = 0; n3 < n2 && n4 < cArray.length; ++n3, ++n4) {
                        if (string.charAt(n3) == cArray[n4]) {
                            continue;
                        }
                        break block36;
                    }
                    if (n4 == cArray.length && n3 == n2) {
                        return bl4 ? new FloatingDecimal(Double.NaN) : new FloatingDecimal(bl2 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
                    }
                    break block36;
                }
                char[] cArray = new char[n2];
                int n5 = 0;
                boolean bl5 = false;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                block19: while (n3 < n2) {
                    c2 = string.charAt(n3);
                    switch (c2) {
                        case '0': {
                            if (n5 > 0) {
                                ++n8;
                                break;
                            }
                            ++n7;
                            break;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            while (n8 > 0) {
                                cArray[n5++] = 48;
                                --n8;
                            }
                            cArray[n5++] = c2;
                            break;
                        }
                        case '.': {
                            if (bl5) {
                                throw new NumberFormatException("multiple points");
                            }
                            n6 = n3;
                            if (bl3) {
                                --n6;
                            }
                            bl5 = true;
                            break;
                        }
                        default: {
                            break block19;
                        }
                    }
                    ++n3;
                }
                if (n5 == 0) {
                    cArray = zero;
                    n5 = 1;
                    if (n7 == 0) break block36;
                }
                int n9 = bl5 ? n6 - n7 : n5 + n8;
                if (n3 < n2 && (c2 = string.charAt(n3)) == 'e' || c2 == 'E') {
                    int n10 = 1;
                    int n11 = 0;
                    int n12 = 0xCCCCCCC;
                    boolean bl6 = false;
                    switch (string.charAt(++n3)) {
                        case '-': {
                            n10 = -1;
                        }
                        case '+': {
                            ++n3;
                        }
                    }
                    int n13 = n3;
                    block21: while (n3 < n2) {
                        if (n11 >= n12) {
                            bl6 = true;
                        }
                        c2 = string.charAt(n3++);
                        switch (c2) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                n11 = n11 * 10 + (c2 - 48);
                                continue block21;
                            }
                        }
                        --n3;
                        break;
                    }
                    int n14 = 324 + n5 + n8;
                    n9 = bl6 || n11 > n14 ? n10 * n14 : (n9 += n10 * n11);
                    if (n3 == n13) break block36;
                }
                if (n3 >= n2 || n3 == n2 - 1 && (string.charAt(n3) == 'f' || string.charAt(n3) == 'F' || string.charAt(n3) == 'd' || string.charAt(n3) == 'D')) {
                    return new FloatingDecimal(bl2, n9, cArray, n5, false);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        throw NumberFormatException.forInputString(string);
    }
}

