/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.datatransfer.MimeTypeParameterList;
import java.awt.datatransfer.MimeTypeParseException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

class MimeType
implements Externalizable,
Cloneable {
    static final long serialVersionUID = -6568722458793895906L;
    private String primaryType;
    private String subType;
    private MimeTypeParameterList parameters;
    private static final String TSPECIALS = "()<>@,;:\\\"/[]?=";

    public int hashCode() {
        int n2 = 0;
        n2 += this.primaryType.hashCode();
        n2 += this.subType.hashCode();
        return n2 += this.parameters.hashCode();
    }

    public MimeType() {
    }

    private static boolean isTokenChar(char c2) {
        return c2 > ' ' && c2 < '\u007f' && TSPECIALS.indexOf(c2) < 0;
    }

    public boolean match(MimeType mimeType) {
        if (mimeType == null) {
            return false;
        }
        return this.primaryType.equals(mimeType.getPrimaryType()) && (this.subType.equals("*") || mimeType.getSubType().equals("*") || this.subType.equals(mimeType.getSubType()));
    }

    public MimeTypeParameterList getParameters() {
        return (MimeTypeParameterList)this.parameters.clone();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String string = objectInput.readUTF();
        if (string == null || string.length() == 0) {
            byte[] byArray = new byte[objectInput.readInt()];
            objectInput.readFully(byArray);
            string = new String(byArray);
        }
        try {
            this.parse(string);
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            throw new IOException(mimeTypeParseException.toString());
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        String string = this.toString();
        if (string.length() <= 65535) {
            objectOutput.writeUTF(string);
        } else {
            objectOutput.writeByte(0);
            objectOutput.writeByte(0);
            objectOutput.writeInt(string.length());
            objectOutput.write(string.getBytes());
        }
    }

    public Object clone() {
        MimeType mimeType = null;
        try {
            mimeType = (MimeType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        mimeType.parameters = (MimeTypeParameterList)this.parameters.clone();
        return mimeType;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MimeType)) {
            return false;
        }
        MimeType mimeType = (MimeType)object;
        boolean bl2 = this.primaryType.equals(mimeType.primaryType) && this.subType.equals(mimeType.subType) && this.parameters.equals(mimeType.parameters);
        return bl2;
    }

    public String getBaseType() {
        return this.primaryType + "/" + this.subType;
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public String getSubType() {
        return this.subType;
    }

    public String toString() {
        return this.getBaseType() + this.parameters.toString();
    }

    public MimeType(String string) throws MimeTypeParseException {
        this.parse(string);
    }

    private void parse(String string) throws MimeTypeParseException {
        int n2 = string.indexOf(47);
        int n3 = string.indexOf(59);
        if (n2 < 0 && n3 < 0) {
            throw new MimeTypeParseException("Unable to find a sub type.");
        }
        if (n2 < 0 && n3 >= 0) {
            throw new MimeTypeParseException("Unable to find a sub type.");
        }
        if (n2 >= 0 && n3 < 0) {
            this.primaryType = string.substring(0, n2).trim().toLowerCase();
            this.subType = string.substring(n2 + 1).trim().toLowerCase();
            this.parameters = new MimeTypeParameterList();
        } else if (n2 < n3) {
            this.primaryType = string.substring(0, n2).trim().toLowerCase();
            this.subType = string.substring(n2 + 1, n3).trim().toLowerCase();
            this.parameters = new MimeTypeParameterList(string.substring(n3));
        } else {
            throw new MimeTypeParseException("Unable to find a sub type.");
        }
        if (!this.isValidToken(this.primaryType)) {
            throw new MimeTypeParseException("Primary type is invalid.");
        }
        if (!this.isValidToken(this.subType)) {
            throw new MimeTypeParseException("Sub type is invalid.");
        }
    }

    public void removeParameter(String string) {
        this.parameters.remove(string);
    }

    private boolean isValidToken(String string) {
        int n2 = string.length();
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                if (MimeType.isTokenChar(c2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean match(String string) throws MimeTypeParseException {
        if (string == null) {
            return false;
        }
        return this.match(new MimeType(string));
    }

    public String getParameter(String string) {
        return this.parameters.get(string);
    }

    public MimeType(String string, String string2) throws MimeTypeParseException {
        this(string, string2, new MimeTypeParameterList());
    }

    public void setParameter(String string, String string2) {
        this.parameters.set(string, string2);
    }

    public MimeType(String string, String string2, MimeTypeParameterList mimeTypeParameterList) throws MimeTypeParseException {
        if (!this.isValidToken(string)) {
            throw new MimeTypeParseException("Primary type is invalid.");
        }
        this.primaryType = string.toLowerCase();
        if (!this.isValidToken(string2)) {
            throw new MimeTypeParseException("Sub type is invalid.");
        }
        this.subType = string2.toLowerCase();
        this.parameters = (MimeTypeParameterList)mimeTypeParameterList.clone();
    }
}

