/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import sun.java2d.SunCompositeContext;

public final class AlphaComposite
implements Composite {
    public static final int CLEAR = 1;
    public static final int SRC = 2;
    public static final int DST = 9;
    public static final int SRC_OVER = 3;
    public static final int DST_OVER = 4;
    public static final int SRC_IN = 5;
    public static final int DST_IN = 6;
    public static final int SRC_OUT = 7;
    public static final int DST_OUT = 8;
    public static final int SRC_ATOP = 10;
    public static final int DST_ATOP = 11;
    public static final int XOR = 12;
    public static final AlphaComposite Clear = new AlphaComposite(1);
    public static final AlphaComposite Src = new AlphaComposite(2);
    public static final AlphaComposite Dst = new AlphaComposite(9);
    public static final AlphaComposite SrcOver = new AlphaComposite(3);
    public static final AlphaComposite DstOver = new AlphaComposite(4);
    public static final AlphaComposite SrcIn = new AlphaComposite(5);
    public static final AlphaComposite DstIn = new AlphaComposite(6);
    public static final AlphaComposite SrcOut = new AlphaComposite(7);
    public static final AlphaComposite DstOut = new AlphaComposite(8);
    public static final AlphaComposite SrcAtop = new AlphaComposite(10);
    public static final AlphaComposite DstAtop = new AlphaComposite(11);
    public static final AlphaComposite Xor = new AlphaComposite(12);
    private static final int MIN_RULE = 1;
    private static final int MAX_RULE = 12;
    float extraAlpha;
    int rule;

    public float getAlpha() {
        return this.extraAlpha;
    }

    public int getRule() {
        return this.rule;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.extraAlpha) * 31 + this.rule;
    }

    private AlphaComposite(int n2) {
        this(n2, 1.0f);
    }

    private AlphaComposite(int n2, float f2) {
        if (f2 < 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("alpha value out of range");
        }
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("unknown composite rule");
        }
        this.rule = n2;
        this.extraAlpha = f2;
    }

    public static AlphaComposite getInstance(int n2) {
        switch (n2) {
            case 1: {
                return Clear;
            }
            case 2: {
                return Src;
            }
            case 9: {
                return Dst;
            }
            case 3: {
                return SrcOver;
            }
            case 4: {
                return DstOver;
            }
            case 5: {
                return SrcIn;
            }
            case 6: {
                return DstIn;
            }
            case 7: {
                return SrcOut;
            }
            case 8: {
                return DstOut;
            }
            case 10: {
                return SrcAtop;
            }
            case 11: {
                return DstAtop;
            }
            case 12: {
                return Xor;
            }
        }
        throw new IllegalArgumentException("unknown composite rule");
    }

    public static AlphaComposite getInstance(int n2, float f2) {
        if (f2 == 1.0f) {
            return AlphaComposite.getInstance(n2);
        }
        return new AlphaComposite(n2, f2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AlphaComposite)) {
            return false;
        }
        AlphaComposite alphaComposite = (AlphaComposite)object;
        if (this.rule != alphaComposite.rule) {
            return false;
        }
        return this.extraAlpha == alphaComposite.extraAlpha;
    }

    public CompositeContext createContext(ColorModel colorModel, ColorModel colorModel2, RenderingHints renderingHints) {
        return new SunCompositeContext(this, colorModel, colorModel2);
    }
}

